/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

#define GNOME_CMD_CUTTED 1
#define GNOME_CMD_COPIED 2

static int _type = 0;
static GList *_files = NULL;
static GnomeCmdDir *_from = NULL;


static void update_refs (GList *files, GnomeCmdDir *dir)
{
	if (_files != NULL)
		gnome_cmd_file_list_free (_files);	

	if (_from != NULL)
		gnome_cmd_dir_unref (_from);

	_files = gnome_cmd_file_list_copy (files);
	gnome_cmd_dir_ref (dir);
	_from = dir;
}

static void cut_and_paste (GnomeCmdDir *to)
{
	gnome_cmd_xfer_start (_files,
						  to,
						  NULL,
						  GNOME_VFS_XFER_REMOVESOURCE,
						  GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE);
}

static void copy_and_paste (GnomeCmdDir *to)
{
	gnome_cmd_xfer_start (_files,
						  to,
						  NULL,
						  GNOME_VFS_XFER_RECURSIVE,
						  GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE);
}

void cap_cut_files (GList *files, GnomeCmdDir *dir)
{
	update_refs (files, dir);
	
	_type = GNOME_CMD_CUTTED;
}


void cap_copy_files (GList *files, GnomeCmdDir *dir)
{
	update_refs (files, dir);

	_type = GNOME_CMD_COPIED;
}


void cap_paste_files (GnomeCmdDir *dir)
{
	switch (_type)
	{
		case GNOME_CMD_CUTTED:
			cut_and_paste (dir);
			break;
		case GNOME_CMD_COPIED:
			copy_and_paste (dir);
			break;
		default:			
	}
}



