/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

#define BUF_SIZE 128

static GtkWidget *cvs_update_win;

static void
on_close (GtkButton *btn,
		  gpointer user_data)
{
	GtkWidget *cvs_update_win = GTK_WIDGET (user_data);

	gtk_widget_hide (cvs_update_win);
}


static void
add_row (GtkWidget *cvs_update_win,
		 char *buf1,
		 char *buf2)
{
	GtkWidget *file_clist;
	GnomeCmdCvsUpdateColors *colors;

	colors = gnome_cmd_data_get_cvs_update_colors ();
	file_clist = lookup_widget (cvs_update_win, "file_clist");
	if (GTK_IS_CLIST (file_clist))
	{
		int row;
		char *text[3];
		GdkColor *c = NULL;
		
		text[0] = buf1;
		text[1] = buf2;
		text[2] = NULL;
		row = gtk_clist_append (GTK_CLIST (file_clist), text);

		if (strlen (buf1) > 0)
		{
			switch (buf1[0])
			{
				case 'M':
					c = colors->modified;
					break;
				case '?':
					c = colors->unknown;
					break;
				case 'U':
					c = colors->updated;
					break;
				case 'C':
					c = colors->conflict;
					break;
				case 'A':
					c = colors->added;
					break;
				case 'R':
					c = colors->removed;
					break;
			}

			if (c)
				gtk_clist_set_foreground (GTK_CLIST (file_clist), row, c);
		}
	}
	else
		g_printerr ("WARNING: GTK_IS_CLIST (file_clist) test failed\n");
}


void
cvs_update_win_show (void)
{
	GtkWidget *dialog_vbox1;
	GtkWidget *scrolledwindow1;
	GtkWidget *file_clist;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *dialog_action_area1;
	GtkWidget *close_button;

	cvs_update_win = gnome_dialog_new (_("CVS update"), NULL);
	gtk_object_set_data (GTK_OBJECT (cvs_update_win), "cvs_update_win",
						 cvs_update_win);
	gtk_widget_set_usize (cvs_update_win, 400, 400);

	dialog_vbox1 = GNOME_DIALOG (cvs_update_win)->vbox;
	gtk_object_set_data (GTK_OBJECT (cvs_update_win), "dialog_vbox1",
						 dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (cvs_update_win), "scrolledwindow1",
							  scrolledwindow1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), scrolledwindow1,
						TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
									GTK_POLICY_AUTOMATIC,
									GTK_POLICY_AUTOMATIC);

	file_clist = gtk_clist_new (2);
	gtk_widget_ref (file_clist);
	gtk_object_set_data_full (GTK_OBJECT (cvs_update_win), "file_clist",
							  file_clist,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (file_clist);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), file_clist);
	gtk_clist_set_column_width (GTK_CLIST (file_clist), 0, 19);
	gtk_clist_set_column_width (GTK_CLIST (file_clist), 1, 80);
	gtk_clist_column_titles_show (GTK_CLIST (file_clist));

	label1 = gtk_label_new ("");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (cvs_update_win), "label1", label1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_clist_set_column_widget (GTK_CLIST (file_clist), 0, label1);

	label2 = gtk_label_new (_("filename"));
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (cvs_update_win), "label2", label2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_clist_set_column_widget (GTK_CLIST (file_clist), 1, label2);

	dialog_action_area1 = GNOME_DIALOG (cvs_update_win)->action_area;
	gtk_object_set_data (GTK_OBJECT (cvs_update_win), "dialog_action_area1",
						 dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1),
							   GTK_BUTTONBOX_SPREAD);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

	gnome_dialog_append_button (GNOME_DIALOG (cvs_update_win),
								GNOME_STOCK_BUTTON_CLOSE);
	close_button = g_list_last (GNOME_DIALOG (cvs_update_win)->buttons)->data;
	gtk_widget_ref (close_button);
	gtk_object_set_data_full (GTK_OBJECT (cvs_update_win), "close_button",
							  close_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (close_button);
	GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
						GTK_SIGNAL_FUNC (on_close),
						cvs_update_win);

	gtk_widget_show (cvs_update_win);
}


void
cvs_update_win_update_dir (char *dir)
{
	int ret;
	char buf[BUF_SIZE], buf2[BUF_SIZE];
	FILE *fd;
	
	chdir (dir);
	fd = popen ("cvs update", "r");

	do
	{
		ret = fscanf (fd, "%s %s", buf, buf2);
		if (ret == 2)
			add_row (cvs_update_win, buf, buf2);
	} while (ret == 2);

	pclose (fd);
}


