/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

static GnomeDialogClass *parent_class = NULL;


struct _GnomeCmdCvsDialogPrivate {
	GnomeCmdCvsServer *selected_server;
	GnomeCmdCvsServer *server_to_add;
	
	GtkWidget         *server_list;
};



/******************************************************
	The main cvs dialog
******************************************************/

static void
load_servers (GnomeCmdCvsDialog *dialog)
{
	GList *tmp = gnome_cmd_data_get_cvs_servers ();
	GtkCList *server_list = GTK_CLIST (dialog->priv->server_list);
	GdkPixmap *pixmap = IMAGE_get_pixmap (PIXMAP_CVS_FISH_SMALL);
	GdkBitmap *mask = IMAGE_get_mask (PIXMAP_CVS_FISH_SMALL);

	gtk_clist_clear (server_list);
	
	while (tmp)
	{
		GnomeCmdCvsServer *server = (GnomeCmdCvsServer*)tmp->data;
		if (server)
		{
			int row;
			gchar *text[3];
			
			text[0] = NULL;
			text[1] = gnome_cmd_cvs_server_get_alias (server);
			text[2] = NULL;
			row = gtk_clist_append (server_list, text);
			gtk_clist_set_row_data (server_list, row, server);
			gtk_clist_set_pixmap (server_list, row, 0, pixmap, mask);
		}
		else
		{
			g_warning ("Null entry in the cvs-server list\n");				
		}
		tmp = tmp->next;
 	}
}


static void
on_connect_btn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	/*
    GtkWidget *passive_mode_check = lookup_widget (cvs_dialog, "passive_mode_check");
    GtkWidget *anonymous_pass_entry = lookup_widget (cvs_dialog, "anonymous_pw_entry");
    
    g_assert (passive_mode_check);
    g_assert (anonymous_pass_entry);
    
    g_data.cvs.passive_mode = gtk_toggle_button_get_active (
    	GTK_TOGGLE_BUTTON (passive_mode_check));
    	
    g_data.cvs.anonymous_pass = gtk_entry_get_text (GTK_ENTRY (anonymous_pass_entry));
    
    on_cvs_dialog_cancel (button, user_data);
    
    create_cvs_session ();
	*/
}


static void
on_new_cvs_server_dialog_ok_btn_clicked (GtkButton       *button,
										 gpointer         user_data)
{
	GnomeCmdCvsDialog *dialog = GNOME_CMD_CVS_DIALOG (user_data);
	gnome_cmd_data_add_cvs_server (dialog->priv->server_to_add);
	dialog->priv->server_to_add = NULL;
	load_servers (dialog);
}


static void
on_edit_cvs_server_dialog_ok_btn_clicked (GtkButton       *button,
										 gpointer         user_data)
{
	GnomeCmdCvsDialog *dialog = GNOME_CMD_CVS_DIALOG (user_data);
	load_servers (dialog);
}


static void
on_cancel_btn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GnomeCmdCvsDialog *dialog = GNOME_CMD_CVS_DIALOG (user_data);
	gtk_widget_hide (GTK_WIDGET (dialog));
}


static void
on_new_btn_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	GnomeCmdCvsServer *server = gnome_cmd_cvs_server_new ();
	GnomeCmdCvsDialog *dialog = GNOME_CMD_CVS_DIALOG (user_data);
	GnomeCmdCvsServerDialog *cvs_server_dialog =
		GNOME_CMD_CVS_SERVER_DIALOG (gnome_cmd_cvs_server_dialog_new (server));

	gtk_signal_connect (GTK_OBJECT (cvs_server_dialog->ok_button), "clicked",
						GTK_SIGNAL_FUNC (on_new_cvs_server_dialog_ok_btn_clicked),
						dialog);

	dialog->priv->server_to_add = server;

	gtk_widget_show (GTK_WIDGET (cvs_server_dialog));
}


static void
on_edit_btn_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	GnomeCmdCvsDialog *dialog = GNOME_CMD_CVS_DIALOG (user_data);
	GnomeCmdCvsServer *server = dialog->priv->selected_server;

	if (server)
	{
		GnomeCmdCvsServerDialog *cvs_server_dialog =
			GNOME_CMD_CVS_SERVER_DIALOG (gnome_cmd_cvs_server_dialog_new (server));

		gtk_signal_connect (GTK_OBJECT (cvs_server_dialog->ok_button), "clicked",
							GTK_SIGNAL_FUNC (on_edit_cvs_server_dialog_ok_btn_clicked),
							dialog);
		
		gtk_widget_show (GTK_WIDGET (cvs_server_dialog));
	}
	else
		g_warning ("No server selected");
}


static void
on_remove_btn_clicked                  (GtkButton       *button,
                                        GnomeCmdCvsDialog *dialog)
{	
    GnomeCmdCvsServer *server = dialog->priv->selected_server;
	
    if (!server)
        return;

	gnome_cmd_data_remove_cvs_server (server);	
    load_servers (dialog);
    dialog->priv->selected_server = NULL;
}


static void
on_server_list_select_row                (GtkCList *clist, gint row, gint column,
										  GdkEvent *event, gpointer user_data)
{
	if (event->type == GDK_2BUTTON_PRESS)
	{
	}
	else
	{
		GnomeCmdCvsServer *server = (GnomeCmdCvsServer*)gtk_clist_get_row_data (clist, row);
		GnomeCmdCvsDialog *dialog = GNOME_CMD_CVS_DIALOG (user_data);

		dialog->priv->selected_server = server;
	}
}


static void
on_server_list_row_move                  (GtkCList        *clist,
										  gint             arg1,
										  gint             arg2,
										  gpointer         user_data)
{
	/*
    server_t *s;
    
    s = (server_t*)g_slist_nth_data (g_data.cvs.servers, arg1);
    if (!s)
    {
    	g_printerr ("error in server list\n");
    	return;
    }
    
    g_data.cvs.servers = g_slist_remove (g_data.cvs.servers, s);    
    g_data.cvs.servers = g_slist_insert (g_data.cvs.servers, s, arg2);
	*/
}




/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	GnomeCmdCvsDialog *dialog = GNOME_CMD_CVS_DIALOG (object);

	if (!dialog->priv)
		g_warning ("GnomeCmdCvsDialog: dialog->priv != NULL test failed\n");
	else
		g_free (dialog->priv);

	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdCvsDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());

	object_class->destroy = destroy;

	widget_class->map = map;
}

static void
init (GnomeCmdCvsDialog *cvs_dialog)
{
	GtkWidget *dialog_vbox;
	GtkWidget *vbox;
	GtkWidget *server_frame;
	GtkWidget *server_list_vbox;
	GtkWidget *scrolledwindow;
	GtkWidget *viewport;
	GtkWidget *label119;
	GtkWidget *label120;
	GtkWidget *buttonbox;
	GtkWidget *new_button;
	GtkWidget *edit_button;
	GtkWidget *remove_button;
	GtkWidget *connect_button;
	GtkWidget *cancel_button;
	
	GtkWidget *dialog = GTK_WIDGET (cvs_dialog);

	cvs_dialog->priv = g_new (GnomeCmdCvsDialogPrivate, 1);
	cvs_dialog->priv->selected_server = NULL;
	

	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

	dialog_vbox = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_vbox", dialog_vbox);
	gtk_widget_show (dialog_vbox);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "vbox", vbox,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), vbox, TRUE, TRUE, 0);

	server_frame = gtk_frame_new (_("servers"));
	gtk_widget_ref (server_frame);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "server_frame", server_frame,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (server_frame);
	gtk_box_pack_start (GTK_BOX (vbox), server_frame, TRUE, TRUE, 2);
	gtk_widget_set_usize (server_frame, 250, 250);

	server_list_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (server_list_vbox);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "server_list_vbox", server_list_vbox,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (server_list_vbox);
	gtk_container_add (GTK_CONTAINER (server_frame), server_list_vbox);

	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "scrolledwindow", scrolledwindow,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow);
	gtk_box_pack_start (GTK_BOX (server_list_vbox), scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	viewport = gtk_viewport_new (NULL, NULL);
	gtk_widget_ref (viewport);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "viewport", viewport,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (viewport);
	gtk_container_add (GTK_CONTAINER (scrolledwindow), viewport);

	cvs_dialog->priv->server_list = gtk_clist_new (2);
	gtk_widget_ref (cvs_dialog->priv->server_list);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "server_list", cvs_dialog->priv->server_list,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cvs_dialog->priv->server_list);
	gtk_container_add (GTK_CONTAINER (viewport), cvs_dialog->priv->server_list);
	gtk_widget_set_usize (cvs_dialog->priv->server_list, 170, -2);
	gtk_clist_set_column_width (GTK_CLIST (cvs_dialog->priv->server_list), 0, 16);
	gtk_clist_set_column_width (GTK_CLIST (cvs_dialog->priv->server_list), 1, 80);
	gtk_clist_column_titles_show (GTK_CLIST (cvs_dialog->priv->server_list));

	label119 = gtk_label_new ("");
	gtk_widget_ref (label119);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label119", label119,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label119);
	gtk_clist_set_column_widget (GTK_CLIST (cvs_dialog->priv->server_list), 0, label119);

	label120 = gtk_label_new (_("alias"));
	gtk_widget_ref (label120);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label120", label120,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label120);
	gtk_clist_set_column_widget (GTK_CLIST (cvs_dialog->priv->server_list), 1, label120);

	buttonbox = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (buttonbox);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "buttonbox", buttonbox,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (buttonbox);
	gtk_box_pack_start (GTK_BOX (server_list_vbox), buttonbox, FALSE, FALSE, 0);

	new_button = gtk_button_new_with_label (_("New..."));
	gtk_widget_ref (new_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "new_button", new_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (new_button);
	gtk_box_pack_start (GTK_BOX (buttonbox), new_button, TRUE, TRUE, 1);

	edit_button = gtk_button_new_with_label (_("Edit..."));
	gtk_widget_ref (edit_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "edit_button", edit_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (edit_button);
	gtk_box_pack_start (GTK_BOX (buttonbox), edit_button, TRUE, TRUE, 1);

	remove_button = gtk_button_new_with_label (_("Remove"));
	gtk_widget_ref (remove_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "remove_button", remove_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (remove_button);
	gtk_box_pack_start (GTK_BOX (buttonbox), remove_button, TRUE, TRUE, 1);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (dialog),
											_("Connect"), GNOME_STOCK_PIXMAP_REFRESH);
	connect_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (connect_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "connect_button", connect_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (connect_button);
	GTK_WIDGET_SET_FLAGS (connect_button, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_CANCEL);
	cancel_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (cancel_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "cancel_button", cancel_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cancel_button);
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (cvs_dialog->priv->server_list), "select_row",
						GTK_SIGNAL_FUNC (on_server_list_select_row),
						dialog);
	gtk_signal_connect (GTK_OBJECT (cvs_dialog->priv->server_list), "row_move",
						GTK_SIGNAL_FUNC (on_server_list_row_move),
						dialog);
	gtk_signal_connect (GTK_OBJECT (new_button), "clicked",
						GTK_SIGNAL_FUNC (on_new_btn_clicked),
						dialog);
	gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
						GTK_SIGNAL_FUNC (on_edit_btn_clicked),
						dialog);
	gtk_signal_connect (GTK_OBJECT (remove_button), "clicked",
						GTK_SIGNAL_FUNC (on_remove_btn_clicked),
						dialog);
	gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
						GTK_SIGNAL_FUNC (on_cancel_btn_clicked),
						dialog);
	gtk_signal_connect (GTK_OBJECT (connect_button), "clicked",
						GTK_SIGNAL_FUNC (on_connect_btn_clicked),
						dialog);
}






/***********************************
 * Public functions
 ***********************************/

GtkType
gnome_cmd_cvs_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdCvsDialog",
			sizeof (GnomeCmdCvsDialog),
			sizeof (GnomeCmdCvsDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}


GtkWidget*
gnome_cmd_cvs_dialog_new (void)
{
	GnomeCmdCvsDialog *dialog;

	dialog = gtk_type_new (gnome_cmd_cvs_dialog_get_type ());

	load_servers (dialog);

	return GTK_WIDGET (dialog);
}
