/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
  FIXME: Fix gtk_entry_get_text memory leaks in this file
  */
#include <config.h>
#include "gnome-cmd-includes.h"

static GnomeDialogClass *parent_class = NULL;


struct _GnomeCmdFtpServerDialogPrivate {
	GnomeCmdFtpServer *server;

	GtkWidget *alias_entry;
	GtkWidget *host_entry;
	GtkWidget *port_entry;
	GtkWidget *user_entry;
};




static void
show_server (GnomeCmdFtpServerDialog *dialog, GnomeCmdFtpServer *server)
{
	const char *alias = gnome_cmd_ftp_server_get_alias (server);
	const char *host  = gnome_cmd_ftp_server_get_host_name (server);
	const char *user  = gnome_cmd_ftp_server_get_user_name (server);
	char *port  = g_strdup_printf ("%d", gnome_cmd_ftp_server_get_host_port (server));

	gtk_entry_set_text (GTK_ENTRY (dialog->priv->alias_entry), alias);
	gtk_entry_set_text (GTK_ENTRY (dialog->priv->host_entry),  host);
	gtk_entry_set_text (GTK_ENTRY (dialog->priv->user_entry),  user);	
	gtk_entry_set_text (GTK_ENTRY (dialog->priv->port_entry),  port);

	g_free (port);

	dialog->priv->server = server;
}


static gboolean
update_server (GnomeCmdFtpServerDialog *dialog)
{
	GnomeCmdFtpServer *server = dialog->priv->server;

	char *alias = gtk_entry_get_text (GTK_ENTRY (dialog->priv->alias_entry));
	char *host  = gtk_entry_get_text (GTK_ENTRY (dialog->priv->host_entry));
	char *user  = gtk_entry_get_text (GTK_ENTRY (dialog->priv->user_entry));
	char *port  = gtk_entry_get_text (GTK_ENTRY (dialog->priv->port_entry));

	gushort iport;


	if (string2ushort (port, &iport))
	{
		gnome_cmd_ftp_server_set_alias (server, alias);
		gnome_cmd_ftp_server_set_host_name (server, host);
		gnome_cmd_ftp_server_set_user_name (server, user);
		gnome_cmd_ftp_server_set_host_port (server, iport);
		
		return TRUE;
	}

	create_error_dialog ("Invalid port nr: %s", port);
	
	return FALSE;
}


static void
on_ok_btn_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GnomeCmdFtpServerDialog *dialog = GNOME_CMD_FTP_SERVER_DIALOG (user_data);

	if (update_server (dialog))
		gtk_widget_hide (GTK_WIDGET (dialog));
}


static void
on_cancel_btn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GnomeCmdFtpServerDialog *dialog = GNOME_CMD_FTP_SERVER_DIALOG (user_data);
	
	gtk_widget_hide (GTK_WIDGET (dialog));
}












/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	GnomeCmdFtpServerDialog *dialog = GNOME_CMD_FTP_SERVER_DIALOG (object);

	if (!dialog->priv)
		g_warning ("GnomeCmdFtpServerDialog: dialog->priv != NULL test failed\n");
	else
		g_free (dialog->priv);

	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdFtpServerDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());

	object_class->destroy = destroy;

	widget_class->map = map;
}

static void
init (GnomeCmdFtpServerDialog *dialog)
{
	GtkWidget *dialog_vbox21;
	GtkWidget *table5;
	GtkWidget *alias_label;
	GtkWidget *host_label;
	GtkWidget *port_label;
	GtkWidget *user_label;
	GtkWidget *cancel_button;
	
	dialog->priv = g_new (GnomeCmdFtpServerDialogPrivate, 1);	


	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

	dialog_vbox21 = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_vbox21", dialog_vbox21);
	gtk_widget_show (dialog_vbox21);

	table5 = gtk_table_new (4, 2, FALSE);
	gtk_widget_ref (table5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "table5", table5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table5);
	gtk_box_pack_start (GTK_BOX (dialog_vbox21), table5, FALSE, FALSE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table5), 2);
	gtk_table_set_col_spacings (GTK_TABLE (table5), 2);

	alias_label = gtk_label_new (_("alias"));
	gtk_widget_ref (alias_label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "alias_label", alias_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alias_label);
	gtk_table_attach (GTK_TABLE (table5), alias_label, 0, 1, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (alias_label), 0, 0.5);

	host_label = gtk_label_new (_("host"));
	gtk_widget_ref (host_label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "host_label", host_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (host_label);
	gtk_table_attach (GTK_TABLE (table5), host_label, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (host_label), 0, 0.5);

	port_label = gtk_label_new (_("port"));
	gtk_widget_ref (port_label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "port_label", port_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (port_label);
	gtk_table_attach (GTK_TABLE (table5), port_label, 0, 1, 2, 3,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (port_label), 0, 0.5);

	user_label = gtk_label_new (_("user"));
	gtk_widget_ref (user_label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "user_label", user_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (user_label);
	gtk_table_attach (GTK_TABLE (table5), user_label, 0, 1, 3, 4,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (user_label), 0, 0.5);

	dialog->priv->alias_entry = gtk_entry_new ();
	gtk_widget_ref (dialog->priv->alias_entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "alias_entry", dialog->priv->alias_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->priv->alias_entry);
	gtk_table_attach (GTK_TABLE (table5), dialog->priv->alias_entry, 1, 2, 0, 1,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	dialog->priv->host_entry = gtk_entry_new ();
	gtk_widget_ref (dialog->priv->host_entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "host_entry", dialog->priv->host_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->priv->host_entry);
	gtk_table_attach (GTK_TABLE (table5), dialog->priv->host_entry, 1, 2, 1, 2,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	dialog->priv->port_entry = gtk_entry_new ();
	gtk_widget_ref (dialog->priv->port_entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "port_entry", dialog->priv->port_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->priv->port_entry);
	gtk_table_attach (GTK_TABLE (table5), dialog->priv->port_entry, 1, 2, 2, 3,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text (GTK_ENTRY (dialog->priv->port_entry), "21");

	dialog->priv->user_entry = gtk_entry_new ();
	gtk_widget_ref (dialog->priv->user_entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "user_entry", dialog->priv->user_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->priv->user_entry);
	gtk_table_attach (GTK_TABLE (table5), dialog->priv->user_entry, 1, 2, 3, 4,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text (GTK_ENTRY (dialog->priv->user_entry), _("anonymous"));

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_OK);
	dialog->ok_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (dialog->ok_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "ok_button", dialog->ok_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->ok_button);
	GTK_WIDGET_SET_FLAGS (dialog->ok_button, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_CANCEL);
	cancel_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (cancel_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "cancel_button", cancel_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cancel_button);
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

	
	gtk_signal_connect (GTK_OBJECT (dialog->ok_button), "clicked",
						GTK_SIGNAL_FUNC (on_ok_btn_clicked),
						dialog);
	gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
						GTK_SIGNAL_FUNC (on_cancel_btn_clicked),
						dialog);

	gtk_widget_grab_focus (dialog->priv->alias_entry);
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog),
								 GTK_EDITABLE(dialog->priv->alias_entry));
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog),
								 GTK_EDITABLE(dialog->priv->host_entry));
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog),
								 GTK_EDITABLE(dialog->priv->port_entry));
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog),
								 GTK_EDITABLE(dialog->priv->user_entry));
	gnome_dialog_set_default (GNOME_DIALOG (dialog), 0);
}




/***********************************
 * Public functions
 ***********************************/

GtkType
gnome_cmd_ftp_server_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdFtpServerDialog",
			sizeof (GnomeCmdFtpServerDialog),
			sizeof (GnomeCmdFtpServerDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}


GtkWidget*
gnome_cmd_ftp_server_dialog_new (GnomeCmdFtpServer *server)
{	
	GnomeCmdFtpServerDialog *dialog;
	dialog = gtk_type_new (gnome_cmd_ftp_server_dialog_get_type ());

	show_server (dialog, server);
	
	return GTK_WIDGET (dialog);
}
