/* vi:set ts=8 sts=0 sw=8:
 * $Id: advopts.c,v 1.3 2001/01/26 05:02:48 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "win.h"
#include "main.h"
#include "misc.h"
#include "prefs.h"
#include "advopts.h"


enum ef_advopts_id_e {
	Ef_ao_toplev,
	Ef_ao_test_added,	/* entry */
	Ef_ao_but_ok,		/* button */

	/* options */
	Ef_ao_daystart,		/* checkbutton */
	Ef_ao_depth,		/* checkbutton */
	Ef_ao_follow,		/* checkbutton */
	Ef_ao_maxdepth,		/* checkbutton */
	Ef_ao_maxdepth_val,	/* spinbutton */
	Ef_ao_mindepth,		/* checkbutton */
	Ef_ao_mindepth_val,	/* spinbutton */
	Ef_ao_xdev,		/* checkbutton */
	Ef_ao_noleaf,		/* checkbutton */

	/* tests - atime */
	Ef_ao_amin_optmenu,	/* optionmenu */
	Ef_ao_amin_val,		/* spinbutton */
	Ef_ao_amin_and,		/* button */
	Ef_ao_amin_or,		/* button */
	Ef_ao_amin_not,		/* button */

	Ef_ao_atime_optmenu,	/* optionmenu */
	Ef_ao_atime_val,	/* spinbutton */
	Ef_ao_atime_and,	/* button */
	Ef_ao_atime_or,		/* button */
	Ef_ao_atime_not,	/* button */

	Ef_ao_anewer_combo,	/* gnome file entry */
	Ef_ao_anewer_entry,	/* entry */
	Ef_ao_anewer_and,	/* button */
	Ef_ao_anewer_or,	/* button */
	Ef_ao_anewer_not,	/* button */

	/* tests - ctime */
	Ef_ao_cmin_optmenu,	/* optionmenu */
	Ef_ao_cmin_val,		/* spinbutton */
	Ef_ao_cmin_and,		/* button */
	Ef_ao_cmin_or,		/* button */
	Ef_ao_cmin_not,		/* button */

	Ef_ao_ctime_optmenu,	/* optionmenu */
	Ef_ao_ctime_val,	/* spinbutton */
	Ef_ao_ctime_and,	/* button */
	Ef_ao_ctime_or,		/* button */
	Ef_ao_ctime_not,	/* button */

	Ef_ao_cnewer_combo,	/* gnome file entry */
	Ef_ao_cnewer_entry,	/* entry */
	Ef_ao_cnewer_and,	/* button */
	Ef_ao_cnewer_or,	/* button */
	Ef_ao_cnewer_not,	/* button */

	/* tests - mtime */
	Ef_ao_mmin_optmenu,	/* optionmenu */
	Ef_ao_mmin_val,		/* spinbutton */
	Ef_ao_mmin_and,		/* button */
	Ef_ao_mmin_or,		/* button */
	Ef_ao_mmin_not,		/* button */

	Ef_ao_mtime_optmenu,	/* optionmenu */
	Ef_ao_mtime_val,	/* spinbutton */
	Ef_ao_mtime_and,	/* button */
	Ef_ao_mtime_or,		/* button */
	Ef_ao_mtime_not,	/* button */

	Ef_ao_mnewer_combo,	/* gnome file entry */
	Ef_ao_mnewer_entry,	/* entry */
	Ef_ao_mnewer_and,	/* button */
	Ef_ao_mnewer_or,	/* button */
	Ef_ao_mnewer_not,	/* button */

	/* tests - permissions */
	Ef_ao_perm_ur,		/* checkbutton */
	Ef_ao_perm_uw,		/* checkbutton */
	Ef_ao_perm_ux,		/* checkbutton */
	Ef_ao_perm_gr,		/* checkbutton */
	Ef_ao_perm_gw,		/* checkbutton */
	Ef_ao_perm_gx,		/* checkbutton */
	Ef_ao_perm_or,		/* checkbutton */
	Ef_ao_perm_ow,		/* checkbutton */
	Ef_ao_perm_ox,		/* checkbutton */
	Ef_ao_setuid,		/* checkbutton */
	Ef_ao_setgid,		/* checkbutton */
	Ef_ao_sticky,		/* checkbutton */
	Ef_ao_perm_exact,	/* radiobutton */
	Ef_ao_perm_all,		/* radiobutton */
	Ef_ao_perm_any,		/* radiobutton */
	Ef_ao_perm_but_and,	/* button */
	Ef_ao_perm_but_or,	/* button */
	Ef_ao_perm_but_not,	/* button */

	/* tests - owner & group */
	Ef_ao_owner_name_e,	/* entry */
	Ef_ao_owner_name_and,	/* button */
	Ef_ao_owner_name_or,	/* button */
	Ef_ao_owner_name_not,	/* button */
	Ef_ao_owner_uid_s,	/* spinbutton */
	Ef_ao_owner_uid_and,	/* button */
	Ef_ao_owner_uid_or,	/* button */
	Ef_ao_owner_uid_not,	/* button */

	Ef_ao_group_name_e,	/* entry */
	Ef_ao_group_name_and,	/* button */
	Ef_ao_group_name_or,	/* button */
	Ef_ao_group_name_not,	/* button */
	Ef_ao_group_gid_s,	/* spinbutton */
	Ef_ao_group_gid_and,	/* button */
	Ef_ao_group_gid_or,	/* button */
	Ef_ao_group_gid_not,	/* button */

	Ef_ao_no_uid_and,	/* button */
	Ef_ao_no_uid_or,	/* button */
	Ef_ao_no_uid_not,	/* button */
	Ef_ao_no_gid_and,	/* button */
	Ef_ao_no_gid_or,	/* button */
	Ef_ao_no_gid_not,	/* button */

	/* tests - type / size */
	Ef_ao_fsize_optmenu,	/* optionmenu */
	Ef_ao_fsize_val,	/* spinbutton */
	Ef_ao_fsize_blocks,	/* radiobutton */
	Ef_ao_fsize_bytes,	/* radiobutton */
	Ef_ao_fsize_kb,		/* radiobutton */
	Ef_ao_fsize_words,	/* radiobutton */
	Ef_ao_fsize_and,	/* button */
	Ef_ao_fsize_or,		/* button */
	Ef_ao_fsize_not,	/* button */

	Ef_ao_ftype_optmenu,	/* optionmenu */
	Ef_ao_ftype_and,	/* button */
	Ef_ao_ftype_or,		/* button */
	Ef_ao_ftype_not,	/* button */

	Ef_ao_xtype_optmenu,	/* optionmenu */
	Ef_ao_xtype_and,	/* button */
	Ef_ao_xtype_or,		/* button */
	Ef_ao_xtype_not,	/* button */

	/* tests - misc */
	Ef_ao_empty_and,	/* button */
	Ef_ao_empty_or,		/* button */
	Ef_ao_empty_not,	/* button */
	Ef_ao_inum_val,		/* spinbutton */
	Ef_ao_inum_and,		/* button */
	Ef_ao_inum_or,		/* button */
	Ef_ao_inum_not,		/* button */
	Ef_ao_links_optmenu,	/* optionmenu */
	Ef_ao_links_val,	/* spinbutton */
	Ef_ao_links_and,	/* button */
	Ef_ao_links_or,		/* button */
	Ef_ao_links_not,	/* button */
	Ef_ao_fstype_e,		/* entry */
	Ef_ao_fstype_and,	/* button */
	Ef_ao_fstype_or,	/* button */
	Ef_ao_fstype_not,	/* button */

	/* tests - selected */
	Ef_tests_sel_list,	/* clist */
	Ef_tests_sel_tb,	/* toolbar */
	Ef_tests_sel_up,	/* button */
	Ef_tests_sel_down,	/* button */
	Ef_tests_sel_del,	/* button */
	Ef_tests_sel_clear,	/* button */

	/* actions - printing/reporting options */
	Ef_ao_window,		/* checkbutton */
	Ef_ao_wprint_vbox,	/* vbox */
	Ef_ao_wprint,		/* radiobutton */
	Ef_ao_wls,		/* radiobutton */

	Ef_ao_stdout,		/* checkbutton */
	Ef_ao_stdout_table,	/* table */
	Ef_ao_print,		/* radiobutton */
	Ef_ao_print0,		/* radiobutton */
	Ef_ao_ls,		/* radiobutton */
	Ef_ao_printf,		/* radiobutton */
	Ef_ao_printf_e,		/* entry */

	Ef_ao_file,		/* checkbutton */
	Ef_ao_fprint_table,	/* table */
	Ef_ao_filename_e,	/* entry */
	Ef_ao_fprint,		/* radiobutton */
	Ef_ao_fprint0,		/* radiobutton */
	Ef_ao_fls,		/* radiobutton */
	Ef_ao_fprintf,		/* radiobutton */
	Ef_ao_fprintf_e,	/* entry */

	/* actions - execute actions */
	Ef_ao_exec,		/* checkbutton */
	Ef_ao_exec_entry,	/* entry */
	Ef_ao_exec_combo,	/* combo */
	Ef_ao_prompt,		/* checkbutton */
	Ef_ao_prompt_entry,	/* entry */
	Ef_ao_prompt_combo,	/* combo */

	/* actions - misc */
	Ef_ao_prune,		/* checkbutton */

	/* actions - special */
	Ef_ao_grep,		/* checkbutton */
	Ef_ao_grep_e,		/* entry */
	Ef_ao_grep_combo,	/* gnome entry */

	Ef_ao_MAX
};
typedef enum ef_advopts_id_e ef_advopts_id_t;


/*** PRIVATE FUNCTION PROTOTYPES ***/
static void advopts_but_ok_cb(GtkWidget *wgt, gpointer cbdata);
static void advopts_chkbut_cb(GtkWidget *wgt, gpointer cbdata);
static void advopts_bool_cb(GtkWidget *wgt, gpointer cbdata);
static void acm_entry_cb(GtkWidget *wgt, gpointer cbdata);
static void advopts_tests_clear_cb(GtkWidget *wgt, gpointer cbdata);
static void advopts_tests_up_cb(GtkWidget *wgt, gpointer cbdata);
static void advopts_tests_down_cb(GtkWidget *wgt, gpointer cbdata);
static void advopts_tests_del_cb(GtkWidget *wgt, gpointer cbdata);
static void perm_cb(GtkWidget *wgt, gpointer cbdata);
static void owner_name_cb(GtkWidget *wgt, gpointer cbdata);
static void owner_uid_cb(GtkWidget *wgt, gpointer cbdata);
static void group_name_cb(GtkWidget *wgt, gpointer cbdata);
static void group_gid_cb(GtkWidget *wgt, gpointer cbdata);
static void fsize_cb(GtkWidget *wgt, gpointer cbdata);
static void ftype_cb(GtkWidget *wgt, gpointer cbdata);
static void owner_name_entry_cb(GtkWidget *wgt, gpointer cbdata);
static void group_name_entry_cb(GtkWidget *wgt, gpointer cbdata);
static void advopts_spinbut_append(win_t *w, ef_advopts_id_t id, GSList *argvl);
static int advopts_toggle_append1(win_t *, ef_advopts_id_t, GSList *, char *s1);
static int advopts_toggle_append2(win_t *w, ef_advopts_id_t id, GSList *argvl,
				  char *s1, char *s2);
static void advopts_set_clear(win_t *w, advopt_t opt, gboolean set);
static void chkbut_common_cb(win_t *w, GtkWidget *, int ao_flag, int sens_id);
static void advopts_tests_list_add(win_t *w, char *txt, gboolean free_it);
static void advopts_bool_common_cb(win_t *w, int entry_id, int omenu_id,
				   char *b, char *t);
static void entry_common_cb(win_t *w, int entry_id, int and_id, int or_id,
			    int not_id);
static void perm_common_cb(win_t *w, char *op);
static void entry_bool_add(win_t *w, int entry_id, gboolean is_string,
			       char *test, char *op);
static void entry_bool_common(GtkWidget *wgt, win_t *w, char *test,
				  gboolean is_string, int entry_id, int and_id,
				  int or_id, int not_id);
static void fsize_common_cb(win_t *w, char *op);
static void ftype_common_cb(win_t *w, char *test, char *op);
static void fstype_entry_cb(GtkWidget *wgt, gpointer cbdata);
static void fstype_bool_cb(GtkWidget *wgt, gpointer cbdata);


static ef_t ef_advopts_widgets[] = {
	{
		"Advanced Opts",
		Ef_ao_toplev,
		Ef_wgt_toplev,
		GTK_SIGNAL_FUNC(gtk_true)
	},
	{
		"entry_test_added",
		Ef_ao_test_added,
		Ef_wgt_entry,
	},
	{
		"but_ok",
		Ef_ao_but_ok,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_but_ok_cb)
	},

	/* options */
	{
		"chkbut_daystart",
		Ef_ao_daystart,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"chkbut_depth",
		Ef_ao_depth,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"chkbut_follow",
		Ef_ao_follow,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"chkbut_maxdepth",
		Ef_ao_maxdepth,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"spinbut_maxdepth",
		Ef_ao_maxdepth_val,
		Ef_wgt_spinbutton,
	},
	{
		"chkbut_mindepth",
		Ef_ao_mindepth,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"spinbut_mindepth",
		Ef_ao_mindepth_val,
		Ef_wgt_spinbutton,
	},
	{
		"chkbut_xdev",
		Ef_ao_xdev,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"chkbut_noleaf",
		Ef_ao_noleaf,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},

	/* tests - atime */
	{
		"optmenu_amin",
		Ef_ao_amin_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_amin",
		Ef_ao_amin_val,
		Ef_wgt_spinbutton,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_amin_and",
		Ef_ao_amin_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_amin_or",
		Ef_ao_amin_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_amin_not",
		Ef_ao_amin_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"optmenu_atime",
		Ef_ao_atime_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_atime",
		Ef_ao_atime_val,
		Ef_wgt_spinbutton,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_atime_and",
		Ef_ao_atime_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_atime_or",
		Ef_ao_atime_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_atime_not",
		Ef_ao_atime_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"fileentry_anewer",
		Ef_ao_anewer_combo,
		Ef_wgt_dont_care,
	},
	{
		"entry_anewer",
		Ef_ao_anewer_entry,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_anewer_and",
		Ef_ao_anewer_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_anewer_or",
		Ef_ao_anewer_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_anewer_not",
		Ef_ao_anewer_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	/* ctime */
	{
		"optmenu_cmin",
		Ef_ao_cmin_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_cmin",
		Ef_ao_cmin_val,
		Ef_wgt_spinbutton,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_cmin_and",
		Ef_ao_cmin_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_cmin_or",
		Ef_ao_cmin_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_cmin_not",
		Ef_ao_cmin_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"optmenu_ctime",
		Ef_ao_ctime_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_ctime",
		Ef_ao_ctime_val,
		Ef_wgt_spinbutton,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_ctime_and",
		Ef_ao_ctime_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_ctime_or",
		Ef_ao_ctime_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_ctime_not",
		Ef_ao_ctime_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"fileentry_cnewer",
		Ef_ao_cnewer_combo,
		Ef_wgt_dont_care,
	},
	{
		"entry_cnewer",
		Ef_ao_cnewer_entry,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_cnewer_and",
		Ef_ao_cnewer_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_cnewer_or",
		Ef_ao_cnewer_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_cnewer_not",
		Ef_ao_cnewer_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	/* mtime */
	{
		"optmenu_mmin",
		Ef_ao_mmin_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_mmin",
		Ef_ao_mmin_val,
		Ef_wgt_spinbutton,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_mmin_and",
		Ef_ao_mmin_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_mmin_or",
		Ef_ao_mmin_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_mmin_not",
		Ef_ao_mmin_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"optmenu_mtime",
		Ef_ao_mtime_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_mtime",
		Ef_ao_mtime_val,
		Ef_wgt_spinbutton,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_mtime_and",
		Ef_ao_mtime_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_mtime_or",
		Ef_ao_mtime_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_mtime_not",
		Ef_ao_mtime_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"fileentry_mnewer",
		Ef_ao_mnewer_combo,
		Ef_wgt_dont_care,
	},
	{
		"entry_mnewer",
		Ef_ao_mnewer_entry,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(acm_entry_cb)
	},
	{
		"but_mnewer_and",
		Ef_ao_mnewer_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_mnewer_or",
		Ef_ao_mnewer_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_mnewer_not",
		Ef_ao_mnewer_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	/* permissions */
	{
		"chkbut_owner_read",
		Ef_ao_perm_ur,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_owner_write",
		Ef_ao_perm_uw,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_owner_exec",
		Ef_ao_perm_ux,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_group_read",
		Ef_ao_perm_gr,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_group_write",
		Ef_ao_perm_gw,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_group_exec",
		Ef_ao_perm_gx,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_other_read",
		Ef_ao_perm_or,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_other_write",
		Ef_ao_perm_ow,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_other_exec",
		Ef_ao_perm_ox,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_setuid",
		Ef_ao_setuid,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_setgid",
		Ef_ao_setgid,
		Ef_wgt_checkbutton,
	},
	{
		"chkbut_sticky_bit",
		Ef_ao_sticky,
		Ef_wgt_checkbutton,
	},
	{
		"radio_perm_exact",
		Ef_ao_perm_exact,
		Ef_wgt_radiobutton,
	},
	{
		"radio_perm_all",
		Ef_ao_perm_all,
		Ef_wgt_radiobutton,
	},
	{
		"radio_perm_any",
		Ef_ao_perm_any,
		Ef_wgt_radiobutton,
	},
	{
		"but_perm_and",
		Ef_ao_perm_but_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(perm_cb)
	},
	{
		"but_perm_or",
		Ef_ao_perm_but_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(perm_cb)
	},
	{
		"but_perm_not",
		Ef_ao_perm_but_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(perm_cb)
	},

	/* tests - owner & group */
	{
		"entry_onwer_name",
		Ef_ao_owner_name_e,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(owner_name_entry_cb)
	},
	{
		"but_owner_name_and",
		Ef_ao_owner_name_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(owner_name_cb)
	},
	{
		"but_owner_name_or",
		Ef_ao_owner_name_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(owner_name_cb)
	},
	{
		"but_owner_name_not",
		Ef_ao_owner_name_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(owner_name_cb)
	},

	{
		"spinbut_owner_uid",
		Ef_ao_owner_uid_s,
		Ef_wgt_spinbutton,
	},
	{
		"but_uid_and",
		Ef_ao_owner_uid_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(owner_uid_cb)
	},
	{
		"but_uid_or",
		Ef_ao_owner_uid_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(owner_uid_cb)
	},
	{
		"but_uid_not",
		Ef_ao_owner_uid_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(owner_uid_cb)
	},

	{
		"entry_group_name",
		Ef_ao_group_name_e,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(group_name_entry_cb)
	},
	{
		"but_group_name_and",
		Ef_ao_group_name_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(group_name_cb)
	},
	{
		"but_group_name_or",
		Ef_ao_group_name_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(group_name_cb)
	},
	{
		"but_group_name_not",
		Ef_ao_group_name_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(group_name_cb)
	},

	{
		"spinbut_group_gid",
		Ef_ao_group_gid_s,
		Ef_wgt_spinbutton,
	},
	{
		"but_gid_and",
		Ef_ao_group_gid_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(group_gid_cb)
	},
	{
		"but_gid_or",
		Ef_ao_group_gid_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(group_gid_cb)
	},
	{
		"but_gid_not",
		Ef_ao_group_gid_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(group_gid_cb)
	},

	{
		"but_nouser_and",
		Ef_ao_no_uid_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_nouser_or",
		Ef_ao_no_uid_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_nouser_not",
		Ef_ao_no_uid_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"but_nogroup_and",
		Ef_ao_no_gid_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_nogroup_or",
		Ef_ao_no_gid_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_nogroup_not",
		Ef_ao_no_gid_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	/* tests - type & size */
	{
		"optmenu_file_size",
		Ef_ao_fsize_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_file_size",
		Ef_ao_fsize_val,
		Ef_wgt_spinbutton,
	},
	{
		"radio_blocks",
		Ef_ao_fsize_blocks,
		Ef_wgt_radiobutton,
	},
	{
		"radio_bytes",
		Ef_ao_fsize_bytes,
		Ef_wgt_radiobutton,
	},
	{
		"radio_kb",
		Ef_ao_fsize_kb,
		Ef_wgt_radiobutton,
	},
	{
		"radio_words",
		Ef_ao_fsize_words,
		Ef_wgt_radiobutton,
	},
	{
		"but_fsize_and",
		Ef_ao_fsize_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(fsize_cb)
	},
	{
		"but_fsize_or",
		Ef_ao_fsize_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(fsize_cb)
	},
	{
		"but_fsize_not",
		Ef_ao_fsize_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(fsize_cb)
	},

	{
		"optmenu_file_type",
		Ef_ao_ftype_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"but_ftype_and",
		Ef_ao_ftype_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(ftype_cb)
	},
	{
		"but_ftype_or",
		Ef_ao_ftype_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(ftype_cb)
	},
	{
		"but_ftype_not",
		Ef_ao_ftype_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(ftype_cb)
	},

	{
		"optmenu_file_xtype",
		Ef_ao_xtype_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"but_xtype_and",
		Ef_ao_xtype_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(ftype_cb)
	},
	{
		"but_xtype_or",
		Ef_ao_xtype_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(ftype_cb)
	},
	{
		"but_xtype_not",
		Ef_ao_xtype_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(ftype_cb)
	},

	/* tests - misc */
	{
		"but_empty_and",
		Ef_ao_empty_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_empty_or",
		Ef_ao_empty_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_empty_not",
		Ef_ao_empty_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"spinbut_inum",
		Ef_ao_inum_val,
		Ef_wgt_spinbutton,
	},
	{
		"but_inum_and",
		Ef_ao_inum_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_inum_or",
		Ef_ao_inum_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_inum_not",
		Ef_ao_inum_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},

	{
		"optmenu_links",
		Ef_ao_links_optmenu,
		Ef_wgt_optmenu,
	},
	{
		"spinbut_links",
		Ef_ao_links_val,
		Ef_wgt_spinbutton,
	},
	{
		"but_links_and",
		Ef_ao_links_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_links_or",
		Ef_ao_links_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"but_links_not",
		Ef_ao_links_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_bool_cb)
	},
	{
		"entry_fstype",
		Ef_ao_fstype_e,
		Ef_wgt_entry,
		GTK_SIGNAL_FUNC(fstype_entry_cb)
	},
	{
		"but_fstype_and",
		Ef_ao_fstype_and,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(fstype_bool_cb)
	},
	{
		"but_fstype_or",
		Ef_ao_fstype_or,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(fstype_bool_cb)
	},
	{
		"but_fstype_not",
		Ef_ao_fstype_not,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(fstype_bool_cb)
	},

	/* tests - selected */
	{
		"clist_tests_selected",
		Ef_tests_sel_list,
		Ef_wgt_clist,
	},
	{
		"tb_tests_selected",
		Ef_tests_sel_tb,
		Ef_wgt_toolbar
	},
	{
		"but_tests_sel_up",
		Ef_tests_sel_up,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_tests_up_cb)
	},
	{
		"but_tests_sel_down",
		Ef_tests_sel_down,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_tests_down_cb)
	},
	{
		"but_tests_sel_del",
		Ef_tests_sel_del,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_tests_del_cb)
	},
	{
		"but_tests_sel_clear",
		Ef_tests_sel_clear,
		Ef_wgt_button,
		GTK_SIGNAL_FUNC(advopts_tests_clear_cb)
	},

	/* actions - print options */
	{
		"chkbut_print_to_window",
		Ef_ao_window,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"vbox_print_to_window",
		Ef_ao_wprint_vbox,
		Ef_wgt_vbox,
	},
	{
		"radio_pathname_only",
		Ef_ao_wprint,
		Ef_wgt_radiobutton,
	},
	{
		"radio_include_file_details",
		Ef_ao_wls,
		Ef_wgt_radiobutton,
	},

	{
		"chkbut_print_to_stdout",
		Ef_ao_stdout,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"table_print_to_stdout",
		Ef_ao_stdout_table,
		Ef_wgt_table,
	},
	{
		"radio_option_print",
		Ef_ao_print,
		Ef_wgt_radiobutton,
	},
	{
		"radio_option_print0",
		Ef_ao_print0,
		Ef_wgt_radiobutton,
	},
	{
		"radio_option_ls",
		Ef_ao_ls,
		Ef_wgt_radiobutton,
	},
	{
		"radio_option_printf",
		Ef_ao_printf,
		Ef_wgt_radiobutton,
	},
	{
		"entry_printf",
		Ef_ao_printf_e,
		Ef_wgt_entry,
	},

	{
		"chkbut_print_to_file",
		Ef_ao_file,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"table_print_to_file",
		Ef_ao_fprint_table,
		Ef_wgt_table,
	},
	{
		"entry_print_filename",
		Ef_ao_filename_e,
		Ef_wgt_entry,
	},
	{
		"radio_option_fprint",
		Ef_ao_fprint,
		Ef_wgt_radiobutton,
	},
	{
		"radio_option_fprint0",
		Ef_ao_fprint0,
		Ef_wgt_radiobutton,
	},
	{
		"radio_option_fls",
		Ef_ao_fls,
		Ef_wgt_radiobutton,
	},
	{
		"radio_option_fprintf",
		Ef_ao_fprintf,
		Ef_wgt_radiobutton,
	},
	{
		"entry_fprintf",
		Ef_ao_fprintf_e,
		Ef_wgt_entry,
	},

	/* actions - execute */
	{
		"chkbut_exec_exec",
		Ef_ao_exec,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"entry_exec_exec",
		Ef_ao_exec_entry,
		Ef_wgt_entry,
	},
	{
		"combo_exec_exec",
		Ef_ao_exec_combo,
		Ef_wgt_dont_care,
	},
	{
		"chkbut_exec_prompt",
		Ef_ao_prompt,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"entry_exec_prompt",
		Ef_ao_prompt_entry,
		Ef_wgt_entry,
	},
	{
		"combo_exec_prompt",
		Ef_ao_prompt_combo,
		Ef_wgt_dont_care,
	},

	/* actions - misc */
	{
		"chkbut_prune",
		Ef_ao_prune,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},

	/* actions - special */
	{
		"chkbut_grep",
		Ef_ao_grep,
		Ef_wgt_checkbutton,
		GTK_SIGNAL_FUNC(advopts_chkbut_cb)
	},
	{
		"entry_grep",
		Ef_ao_grep_e,
		Ef_wgt_entry,
	},
	{
		"combo_grep",
		Ef_ao_grep_combo,
		Ef_wgt_dont_care,
	},

	{ NULL }
}; /* ef_advopts_widgets */


/*** PUBLIC FUNCTION DEFINITIONS ***/
/*
 * Callback for the "Show Advanced Options" button from the main menu.  If the
 * dialog window exists already, simply raise it and show it.  Otherwise,
 * create a new one.
 */
void
advopts_cb(GtkWidget *wgt, gpointer cbdata)
{
	int num;
	win_t *w = (win_t *)cbdata;

	num = (sizeof(ef_advopts_widgets) / sizeof(ef_advopts_widgets[0])) - 1;
	w->advwgts = my_widgets_setup(w, w->advwgts, num,
				      ef_advopts_widgets, "Advanced Opts",
				      Ef_ao_toplev, Ef_ao_MAX, FALSE);
	advopts_prefs_toolbar_set(w);
	my_prefs_window_set_size(w->advwgts[Ef_ao_toplev],
				 Prefs_save_advopts_win,
				 Prefs_adv_win_w,
				 Prefs_adv_win_h);
	gtk_widget_show(w->advwgts[Ef_ao_toplev]);
} /* advopts_cb */


/*
 * Sets toolbar settings for the "Tests selected" toolbar.
 */
void
advopts_prefs_toolbar_set(win_t *w)
{
	if (!w->advwgts)
		return;
	prefs_toolbar_set(Prefs_adv_tbstyle, w->advwgts[Ef_tests_sel_tb]);
} /* advopts_prefs_toolbar_set */


/*
 * Appends all advanced "Options" to argument list "argvl".  Returns the number
 * of arguments added to argvl.
 */
int
advopts_options_add(win_t *w, GSList *argvl)
{
	int argc = 0;

	if (w->advopts & AO_DAYSTART) {
		argvl = g_slist_append(argvl, g_strdup("-daystart"));
		argc++;
	}
	if (w->advopts & AO_DEPTH) {
		argvl = g_slist_append(argvl, g_strdup("-depth"));
		argc++;
	}
	if (w->advopts & AO_FOLLOW) {
		argvl = g_slist_append(argvl, g_strdup("-follow"));
		argc++;
	}
	if (w->advopts & AO_MAXDEPTH) {
		argvl = g_slist_append(argvl, g_strdup("-maxdepth"));
		advopts_spinbut_append(w, Ef_ao_maxdepth_val, argvl);
		argc += 2;
	}
	if (w->advopts & AO_MINDEPTH) {
		argvl = g_slist_append(argvl, g_strdup("-mindepth"));
		advopts_spinbut_append(w, Ef_ao_mindepth_val, argvl);
		argc += 2;
	}
	if (w->advopts & AO_XDEV) {
		argvl = g_slist_append(argvl, g_strdup("-xdev"));
		argc++;
	}
	if (w->advopts & AO_NOLEAF) {
		argvl = g_slist_append(argvl, g_strdup("-noleaf"));
		argc++;
	}

	return argc;
} /* advopts_options_add */


/*
 * Appends all advanced "Actions" to argument list "argvl".  Returns the number
 * of arguments added to argvl.
 */
int
advopts_actions_add(win_t *w, GSList *argvl)
{
	GtkWidget *wgt;
	char *txt, *fmt;
	int argc = 0;

	/* actions - misc */
	if (w->advopts & AO_PRUNE)
		argc += advopts_toggle_append1(w, Ef_ao_prune, argvl, "-prune");

	/* actions - special */
	if (w->advopts & AO_GREP) {
		wgt = w->advwgts[Ef_ao_grep_e];
		g_assert(GTK_IS_ENTRY(wgt));
		txt = gtk_entry_get_text(GTK_ENTRY(wgt));
		if (txt && txt[0] != '\0') {
			argvl = g_slist_append(argvl, g_strdup("-exec"));
			argvl = g_slist_append(argvl, g_strdup("grep"));
			argvl = g_slist_append(argvl, g_strdup("-l"));
			argvl = g_slist_append(argvl, g_strdup(txt));
			argvl = g_slist_append(argvl, g_strdup("{}"));
			argvl = g_slist_append(argvl, g_strdup(";"));
			argc += 6;
		}
	}

	/* actions - printing */
	if (w->advopts & AO_WPRINT) {
		argc += advopts_toggle_append1(w, Ef_ao_wprint, argvl,
					       "-wprint");
		argc += advopts_toggle_append1(w, Ef_ao_wls, argvl,
					       "-wls");
	}
	if (w->advopts & AO_STDOUT) {
		argc += advopts_toggle_append1(w, Ef_ao_print, argvl,
					      "-print");
		argc += advopts_toggle_append1(w, Ef_ao_print0, argvl,
					      "-print0");
		argc += advopts_toggle_append1(w, Ef_ao_ls, argvl, "-ls");

		wgt = w->advwgts[Ef_ao_printf];
		g_assert(GTK_IS_RADIO_BUTTON(wgt));
		if (GTK_TOGGLE_BUTTON(wgt)->active) {
			wgt = w->advwgts[Ef_ao_printf_e];
			g_assert(GTK_IS_ENTRY(wgt));
			fmt = gtk_entry_get_text(GTK_ENTRY(wgt));
			if (fmt && fmt[0] != '\0') {
				argvl = g_slist_append(argvl,
						       g_strdup("-printf"));
				argvl = g_slist_append(argvl, g_strdup(fmt));
				argc += 2;
			}
		}
	} /* AO_STDOUT */
	if (w->advopts & AO_FPRINT) {
		wgt = w->advwgts[Ef_ao_filename_e];
		g_assert(GTK_IS_ENTRY(wgt));
		txt = gtk_entry_get_text(GTK_ENTRY(wgt));
		if (txt && txt[0] != '\0') {
			argc += advopts_toggle_append2(w, Ef_ao_fprint,
						       argvl, "-fprint", txt);
			argc += advopts_toggle_append2(w, Ef_ao_fprint0,
						       argvl, "-fprint0", txt);
			argc += advopts_toggle_append2(w, Ef_ao_fls,
						       argvl, "-fls", txt);

			wgt = w->advwgts[Ef_ao_fprintf];
			g_assert(GTK_IS_RADIO_BUTTON(wgt));
			if (GTK_TOGGLE_BUTTON(wgt)->active) {
				wgt = w->advwgts[Ef_ao_fprintf_e];
				g_assert(GTK_IS_ENTRY(wgt));
				fmt = gtk_entry_get_text(GTK_ENTRY(wgt));
				if (fmt && fmt[0] != '\0') {
					argc += advopts_toggle_append2(
							w, Ef_ao_fprintf,
							argvl, "-fprintf", txt);
					argvl = g_slist_append(argvl,
							g_strdup(fmt));
					argc++;
				}
			}
		}
	} /* AO_FPRINT */

	/* actions - exec */
	if (w->advopts & AO_EXEC_EXEC) {
		wgt = w->advwgts[Ef_ao_exec_entry];
		g_assert(GTK_IS_ENTRY(wgt));
		txt = gtk_entry_get_text(GTK_ENTRY(wgt));
		if (txt && txt[0] != '\0') {
			argvl = g_slist_append(argvl, g_strdup("-exec"));
			argc++;
			argvl = my_argvl_build(txt, &argc, argvl);
		}
	}
	if (w->advopts & AO_EXEC_PROMPT) {
		wgt = w->advwgts[Ef_ao_prompt_entry];
		g_assert(GTK_IS_ENTRY(wgt));
		txt = gtk_entry_get_text(GTK_ENTRY(wgt));
		if (txt && txt[0] != '\0') {
			argvl = g_slist_append(argvl, g_strdup("-ok"));
			argc++;
			argvl = my_argvl_build(txt, &argc, argvl);
		}
	}

	return argc;
} /* advopts_actions_add */


/*
 * Appends all advanced "Tests" to argument list "argvl".
 */
int
advopts_tests_add(win_t *w, GSList *argvl)
{
	char *tmp, *txt;
	GtkCList *clist;
	int i, argc = 0;

	g_assert(w->advwgts);
	g_assert(w->advwgts[Ef_tests_sel_list]);
	g_assert(GTK_IS_CLIST(w->advwgts[Ef_tests_sel_list]));
	clist = GTK_CLIST(w->advwgts[Ef_tests_sel_list]);

	for (i = 0; i < clist->rows; i++) {
		(void)gtk_clist_get_text(clist, i, 0, &tmp);
		txt = g_strdup(tmp);
		argvl = my_argvl_build(txt, &argc, argvl);
		g_free(txt);
	}
	
	return argc;
} /* advopts_tests_add */


void
advopts_prefs_save(win_t *w)
{
	int width, height;

	if (!w->advwgts)
		return;

	gdk_window_get_size(w->advwgts[Ef_ao_toplev]->window, &width, &height);
	prefs_int_set(Prefs_adv_win_w, width);
	prefs_int_set(Prefs_adv_win_h, height);
} /* advopts_prefs_save */


/*** PRIVATE FUNCTION DEFINITIONS ***/
/*
 * Convenience routine to grab the value from a spinbutton entry and append it
 * as an argument to argvl.
 */
static void
advopts_spinbut_append(win_t *w, ef_advopts_id_t id, GSList *argvl)
{
	char *txt;
	int num;

	g_assert(GTK_IS_SPIN_BUTTON(w->advwgts[id]));
	g_assert(GTK_IS_ENTRY(w->advwgts[id]));
	num = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w->advwgts[id]));
	txt = g_strdup_printf("%d", num);
	argvl = g_slist_append(argvl, txt);
} /* advopts_spinbut_append */


/*
 * Convenience routine to append string "s1" to argument list argvl if the
 * toggle button as specified by "id" is active.  Returns 1, if s1 was
 * appended, 0 if not.
 */
static int
advopts_toggle_append1(win_t *w, ef_advopts_id_t id, GSList *argvl, char *s1)
{
	GtkWidget *wgt;
	
	wgt = w->advwgts[id];
	g_assert(GTK_IS_TOGGLE_BUTTON(wgt));
	if (GTK_TOGGLE_BUTTON(wgt)->active) {
		argvl = g_slist_append(argvl, g_strdup(s1));
		return 1;
	}

	return 0;
} /* advopts_toggle_append1 */


/*
 * Like advopts_toggle_append1(), but appends "s1" as well as "s2".  Returns 2
 * if s1 and s2 were appended, 0 if not.
 */
static int
advopts_toggle_append2(win_t *w, ef_advopts_id_t id, GSList *argvl,
		       char *s1, char *s2)
{
	int ret;

	if ((ret = advopts_toggle_append1(w, id, argvl, s1)) > 0) {
		g_assert(s2 && s2[0] != '\0');
		argvl = g_slist_append(argvl, g_strdup(s2));
		return 2;
	}

	return 0;
} /* advopts_toggle_append2 */


/*
 * Sets or clears an advanced search option (AO_*).
 */
static void
advopts_set_clear(win_t *w, advopt_t opt, gboolean set)
{
	if (set)
		w->advopts |= opt;
	else
		w->advopts &= ~opt;
} /* advopts_set_clear */


/*
 * Callback for "Ok" button for the advanced options dialog.  It simply hides
 * the entire dialog window.
 */
static void
advopts_but_ok_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	gtk_widget_hide(w->advwgts[Ef_ao_toplev]);
} /* advopts_but_ok_cb */


static void
chkbut_common_cb(win_t *w, GtkWidget *chkbut, int ao_flag, int sens_id)
{
	g_assert(GTK_IS_CHECK_BUTTON(chkbut));
	advopts_set_clear(w, ao_flag, GTK_TOGGLE_BUTTON(chkbut)->active);
	if (sens_id != Ef_ao_MAX)
		gtk_widget_set_sensitive(GTK_WIDGET(w->advwgts[sens_id]),
					 GTK_TOGGLE_BUTTON(chkbut)->active);
} /* chkbut_common_cb */


static void
advopts_chkbut_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (wgt == w->advwgts[Ef_ao_daystart])
		chkbut_common_cb(w, wgt, AO_DAYSTART, Ef_ao_MAX);
	else if (wgt == w->advwgts[Ef_ao_depth])
		chkbut_common_cb(w, wgt, AO_DEPTH, Ef_ao_MAX);
	else if (wgt == w->advwgts[Ef_ao_follow])
		chkbut_common_cb(w, wgt, AO_FOLLOW, Ef_ao_MAX);
	else if (wgt == w->advwgts[Ef_ao_maxdepth])
		chkbut_common_cb(w, wgt, AO_MAXDEPTH, Ef_ao_maxdepth_val);
	else if (wgt == w->advwgts[Ef_ao_mindepth])
		chkbut_common_cb(w, wgt, AO_MINDEPTH, Ef_ao_mindepth_val);
	else if (wgt == w->advwgts[Ef_ao_xdev])
		chkbut_common_cb(w, wgt, AO_XDEV, Ef_ao_MAX);
	else if (wgt == w->advwgts[Ef_ao_noleaf])
		chkbut_common_cb(w, wgt, AO_NOLEAF, Ef_ao_MAX);
	else if (wgt == w->advwgts[Ef_ao_window])
		chkbut_common_cb(w, wgt, AO_WPRINT, Ef_ao_wprint_vbox);
	else if (wgt == w->advwgts[Ef_ao_stdout])
		chkbut_common_cb(w, wgt, AO_STDOUT, Ef_ao_stdout_table);
	else if (wgt == w->advwgts[Ef_ao_file])
		chkbut_common_cb(w, wgt, AO_FPRINT, Ef_ao_fprint_table);
	else if (wgt == w->advwgts[Ef_ao_exec])
		chkbut_common_cb(w, wgt, AO_EXEC_EXEC, Ef_ao_exec_combo);
	else if (wgt == w->advwgts[Ef_ao_prompt])
		chkbut_common_cb(w, wgt, AO_EXEC_PROMPT, Ef_ao_prompt_combo);
	else if (wgt == w->advwgts[Ef_ao_prune])
		chkbut_common_cb(w, wgt, AO_PRUNE, Ef_ao_MAX);
	else if (wgt == w->advwgts[Ef_ao_grep])
		chkbut_common_cb(w, wgt, AO_GREP, Ef_ao_grep_combo);
#ifdef ENABLE_DEBUG
	else
		g_error("advopts_chkbut_cb: Unknown widget\n");
#endif
} /* advopts_chkbut_cb */


static void
advopts_tests_list_add(win_t *w, char *txt, gboolean free_it)
{
	char *atxt[2];

	atxt[0] = txt;
	atxt[1] = NULL;
	gtk_clist_append(GTK_CLIST(w->advwgts[Ef_tests_sel_list]), atxt);
	gtk_entry_set_text(GTK_ENTRY(w->advwgts[Ef_ao_test_added]), txt);
	if (free_it)
		g_free(txt);
} /* advopts_tests_list_add */


/*
 * entry_id: Ef_ao_* id of either a spinbutton, or a gnome file entry widget.
 * omenu_id: Ef_ao_* id of the option menu.  Used only for the amin, cmin,
 *	mmin, atime, ctime, and mtime tests.  For the {a,c,m}newer tests, this
 *	value must be Ef_ao_MAX.
 * b: the boolean operator. ("-a", "-o", "!");
 * t: the character string of the operation ("amin", "cmin", et al).
 */
static void
advopts_bool_common_cb(win_t *w, int entry_id, int omenu_id, char *b, char *t)
{
	GtkWidget *child;
	GtkButton *button;
	char *str, *listtxt;
	int val;

	if (entry_id == Ef_ao_MAX && omenu_id == Ef_ao_MAX) {
		listtxt = g_strdup_printf("%s -%s", b, t);
	} else if (omenu_id != Ef_ao_MAX) {
		str = gtk_entry_get_text(GTK_ENTRY(w->advwgts[entry_id]));
		/* -{a,c,m}{min,time} test */
		val = atoi(str);

		button = &(GTK_OPTION_MENU(w->advwgts[omenu_id])->button);
		child = GTK_BIN(button)->child;

		g_assert(GTK_IS_LABEL(child));
		gtk_label_get(GTK_LABEL(child), &str);

		if (g_strcasecmp(str, "Exactly") == 0) {
			listtxt = g_strdup_printf("%s -%s %d", b, t, val);
		} else if (g_strcasecmp(str, "More than") == 0) {
			listtxt = g_strdup_printf("%s -%s +%d", b, t, val);
		} else {
			g_assert(g_strcasecmp(str, "Less than") == 0);
			listtxt = g_strdup_printf("%s -%s -%d", b, t, val);
		}
	} else {
		str = gtk_entry_get_text(GTK_ENTRY(w->advwgts[entry_id]));
		g_assert(str);
		g_assert(strlen(str) > 0);

		if (GTK_IS_SPIN_BUTTON(w->advwgts[entry_id])) {
			val = atoi(str);
			listtxt = g_strdup_printf("%s -%s %d", b, t, val);
		} else {
			/* XXX - won't work if name already has double quotes */
			listtxt = g_strdup_printf("%s -%s \"%s\"", b, t, str);
		}
	}

	g_assert(listtxt);
	advopts_tests_list_add(w, listtxt, TRUE);
} /* advopts_bool_common_cb */


static void
advopts_bool_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (wgt == w->advwgts[Ef_ao_amin_and])
		advopts_bool_common_cb(cbdata, Ef_ao_amin_val,
				       Ef_ao_amin_optmenu, "-a", "amin");
	else if (wgt == w->advwgts[Ef_ao_amin_or])
		advopts_bool_common_cb(cbdata, Ef_ao_amin_val,
				       Ef_ao_amin_optmenu, "-o", "amin");
	else if (wgt == w->advwgts[Ef_ao_amin_not])
		advopts_bool_common_cb(cbdata, Ef_ao_amin_val,
				       Ef_ao_amin_optmenu, "!", "amin");

	else if (wgt == w->advwgts[Ef_ao_cmin_and])
		advopts_bool_common_cb(cbdata, Ef_ao_cmin_val,
				       Ef_ao_cmin_optmenu, "-a", "cmin");
	else if (wgt == w->advwgts[Ef_ao_cmin_or])
		advopts_bool_common_cb(cbdata, Ef_ao_cmin_val,
				       Ef_ao_cmin_optmenu, "-o", "cmin");
	else if (wgt == w->advwgts[Ef_ao_cmin_not])
		advopts_bool_common_cb(cbdata, Ef_ao_cmin_val,
				       Ef_ao_cmin_optmenu, "!", "cmin");

	else if (wgt == w->advwgts[Ef_ao_mmin_and])
		advopts_bool_common_cb(cbdata, Ef_ao_mmin_val,
				       Ef_ao_mmin_optmenu, "-a", "mmin");
	else if (wgt == w->advwgts[Ef_ao_mmin_or])
		advopts_bool_common_cb(cbdata, Ef_ao_mmin_val,
				       Ef_ao_mmin_optmenu, "-o", "mmin");
	else if (wgt == w->advwgts[Ef_ao_mmin_not])
		advopts_bool_common_cb(cbdata, Ef_ao_mmin_val,
				       Ef_ao_mmin_optmenu, "!", "mmin");

	else if (wgt == w->advwgts[Ef_ao_atime_and])
		advopts_bool_common_cb(cbdata, Ef_ao_atime_val,
				       Ef_ao_atime_optmenu, "-a", "atime");
	else if (wgt == w->advwgts[Ef_ao_atime_or])
		advopts_bool_common_cb(cbdata, Ef_ao_atime_val,
				       Ef_ao_atime_optmenu, "-o", "atime");
	else if (wgt == w->advwgts[Ef_ao_atime_not])
		advopts_bool_common_cb(cbdata, Ef_ao_atime_val,
				       Ef_ao_atime_optmenu, "!", "atime");

	else if (wgt == w->advwgts[Ef_ao_ctime_and])
		advopts_bool_common_cb(cbdata, Ef_ao_ctime_val,
				       Ef_ao_ctime_optmenu, "-a", "ctime");
	else if (wgt == w->advwgts[Ef_ao_ctime_or])
		advopts_bool_common_cb(cbdata, Ef_ao_ctime_val,
				       Ef_ao_ctime_optmenu, "-o", "ctime");
	else if (wgt == w->advwgts[Ef_ao_ctime_not])
		advopts_bool_common_cb(cbdata, Ef_ao_ctime_val,
				       Ef_ao_ctime_optmenu, "!", "ctime");

	else if (wgt == w->advwgts[Ef_ao_mtime_and])
		advopts_bool_common_cb(cbdata, Ef_ao_mtime_val,
				       Ef_ao_mtime_optmenu, "-a", "mtime");
	else if (wgt == w->advwgts[Ef_ao_mtime_or])
		advopts_bool_common_cb(cbdata, Ef_ao_mtime_val,
				       Ef_ao_mtime_optmenu, "-o", "mtime");
	else if (wgt == w->advwgts[Ef_ao_mtime_not])
		advopts_bool_common_cb(cbdata, Ef_ao_mtime_val,
				       Ef_ao_mtime_optmenu, "!", "mtime");

	else if (wgt == w->advwgts[Ef_ao_anewer_and])
		advopts_bool_common_cb(cbdata, Ef_ao_anewer_entry,
				       Ef_ao_MAX, "-a", "anewer");
	else if (wgt == w->advwgts[Ef_ao_anewer_or])
		advopts_bool_common_cb(cbdata, Ef_ao_anewer_entry,
				       Ef_ao_MAX, "-o", "anewer");
	else if (wgt == w->advwgts[Ef_ao_anewer_not])
		advopts_bool_common_cb(cbdata, Ef_ao_anewer_entry,
				       Ef_ao_MAX, "!", "anewer");

	else if (wgt == w->advwgts[Ef_ao_cnewer_and])
		advopts_bool_common_cb(cbdata, Ef_ao_cnewer_entry,
				       Ef_ao_MAX, "-a", "cnewer");
	else if (wgt == w->advwgts[Ef_ao_cnewer_or])
		advopts_bool_common_cb(cbdata, Ef_ao_cnewer_entry,
				       Ef_ao_MAX, "-o", "cnewer");
	else if (wgt == w->advwgts[Ef_ao_cnewer_not])
		advopts_bool_common_cb(cbdata, Ef_ao_cnewer_entry,
				       Ef_ao_MAX, "!", "cnewer");

	else if (wgt == w->advwgts[Ef_ao_mnewer_and])
		advopts_bool_common_cb(cbdata, Ef_ao_mnewer_entry,
				       Ef_ao_MAX, "-a", "mnewer");
	else if (wgt == w->advwgts[Ef_ao_mnewer_or])
		advopts_bool_common_cb(cbdata, Ef_ao_mnewer_entry,
				       Ef_ao_MAX, "-o", "mnewer");
	else if (wgt == w->advwgts[Ef_ao_mnewer_not])
		advopts_bool_common_cb(cbdata, Ef_ao_mnewer_entry,
				       Ef_ao_MAX, "!", "mnewer");

	else if (wgt == w->advwgts[Ef_ao_inum_and])
		advopts_bool_common_cb(cbdata, Ef_ao_inum_val,
				       Ef_ao_MAX, "-a", "inum");
	else if (wgt == w->advwgts[Ef_ao_inum_or])
		advopts_bool_common_cb(cbdata, Ef_ao_inum_val,
				       Ef_ao_MAX, "-o", "inum");
	else if (wgt == w->advwgts[Ef_ao_inum_not])
		advopts_bool_common_cb(cbdata, Ef_ao_inum_val,
				       Ef_ao_MAX, "!", "inum");

	else if (wgt == w->advwgts[Ef_ao_links_and])
		advopts_bool_common_cb(cbdata, Ef_ao_links_val,
				       Ef_ao_links_optmenu, "-a", "links");
	else if (wgt == w->advwgts[Ef_ao_links_or])
		advopts_bool_common_cb(cbdata, Ef_ao_links_val,
				       Ef_ao_links_optmenu, "-o", "links");
	else if (wgt == w->advwgts[Ef_ao_links_not])
		advopts_bool_common_cb(cbdata, Ef_ao_links_val,
				       Ef_ao_links_optmenu, "!", "links");

	else if (wgt == w->advwgts[Ef_ao_xtype_and])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-a", "xtype");
	else if (wgt == w->advwgts[Ef_ao_xtype_or])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-o", "xtype");
	else if (wgt == w->advwgts[Ef_ao_xtype_not])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "!", "xtype");

	else if (wgt == w->advwgts[Ef_ao_empty_and])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-a", "empty");
	else if (wgt == w->advwgts[Ef_ao_empty_or])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-o", "empty");
	else if (wgt == w->advwgts[Ef_ao_empty_not])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "!", "empty");

	else if (wgt == w->advwgts[Ef_ao_no_uid_and])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-a", "nouser");
	else if (wgt == w->advwgts[Ef_ao_no_uid_or])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-o", "nouser");
	else if (wgt == w->advwgts[Ef_ao_no_uid_not])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "!", "nouser");

	else if (wgt == w->advwgts[Ef_ao_no_gid_and])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-a", "nogroup");
	else if (wgt == w->advwgts[Ef_ao_no_gid_or])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "-o", "nogroup");
	else if (wgt == w->advwgts[Ef_ao_no_gid_not])
		advopts_bool_common_cb(cbdata, Ef_ao_MAX,
				       Ef_ao_MAX, "!", "nogroup");
#ifdef ENABLE_DEBUG
	else
		g_error("advopts_bool_cb: Unknown widget\n");
#endif
} /* advopts_bool_cb */


static void
entry_common_cb(win_t *w, int entry_id, int and_id, int or_id, int not_id)
{
	GtkWidget *wgt;
	char *txt;
	gboolean sens;

	wgt = w->advwgts[entry_id];
	g_assert(GTK_IS_ENTRY(wgt));
	txt = gtk_entry_get_text(GTK_ENTRY(wgt));
	if (GTK_IS_SPIN_BUTTON(wgt)) {
		sens = (atoi(txt) > 0);
	} else {
		sens = (txt && strlen(txt) > 0);
	}

	gtk_widget_set_sensitive(w->advwgts[and_id], sens);
	gtk_widget_set_sensitive(w->advwgts[or_id],  sens);
	gtk_widget_set_sensitive(w->advwgts[not_id], sens);
} /* entry_common_cb */


static void
acm_entry_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (wgt == w->advwgts[Ef_ao_amin_val])
		entry_common_cb(cbdata, Ef_ao_amin_val, Ef_ao_amin_and,
					Ef_ao_amin_or, Ef_ao_amin_not);
	else if (wgt == w->advwgts[Ef_ao_atime_val])
		entry_common_cb(cbdata, Ef_ao_atime_val, Ef_ao_atime_and,
					Ef_ao_atime_or, Ef_ao_atime_not);
	else if (wgt == w->advwgts[Ef_ao_anewer_entry])
		entry_common_cb(cbdata, Ef_ao_anewer_entry, Ef_ao_anewer_and,
					Ef_ao_anewer_or, Ef_ao_anewer_not);
	else if (wgt == w->advwgts[Ef_ao_cmin_val])
		entry_common_cb(cbdata, Ef_ao_cmin_val, Ef_ao_cmin_and,
					Ef_ao_cmin_or, Ef_ao_cmin_not);
	else if (wgt == w->advwgts[Ef_ao_ctime_val])
		entry_common_cb(cbdata, Ef_ao_ctime_val, Ef_ao_ctime_and,
					Ef_ao_ctime_or, Ef_ao_ctime_not);
	else if (wgt == w->advwgts[Ef_ao_cnewer_entry])
		entry_common_cb(cbdata, Ef_ao_cnewer_entry, Ef_ao_cnewer_and,
					Ef_ao_cnewer_or, Ef_ao_cnewer_not);
	else if (wgt == w->advwgts[Ef_ao_mmin_val])
		entry_common_cb(cbdata, Ef_ao_mmin_val, Ef_ao_mmin_and,
					Ef_ao_mmin_or, Ef_ao_mmin_not);
	else if (wgt == w->advwgts[Ef_ao_mtime_val])
		entry_common_cb(cbdata, Ef_ao_mtime_val, Ef_ao_mtime_and,
					Ef_ao_mtime_or, Ef_ao_mtime_not);
	else if (wgt == w->advwgts[Ef_ao_mnewer_entry])
		entry_common_cb(cbdata, Ef_ao_mnewer_entry, Ef_ao_mnewer_and,
					Ef_ao_mnewer_or, Ef_ao_mnewer_not);
#ifdef ENABLE_DEBUG
	else
		g_error("acm_entry_cb: Unknown widget\n");
#endif
} /* acm_entry_cb */


static void
advopts_tests_clear_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	gtk_clist_clear(GTK_CLIST(w->advwgts[Ef_tests_sel_list]));
} /* advopts_tests_clear_cb */


static void
advopts_tests_up_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_up(w->advwgts, Ef_tests_sel_list);
} /* advopts_tests_up_cb */


static void
advopts_tests_down_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_down(w->advwgts, Ef_tests_sel_list);
} /* advopts_tests_down_cb */


static void
advopts_tests_del_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	my_clist_del(w->advwgts, Ef_tests_sel_list);
} /* advopts_tests_del_cb */


static void
perm_common_cb(win_t *w, char *op)
{
	char buf[20];
	int mode = 0;

	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_ur])->active)
		mode += 400;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_uw])->active)
		mode += 200;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_ux])->active)
		mode += 100;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_gr])->active)
		mode += 40;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_gw])->active)
		mode += 20;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_gx])->active)
		mode += 10;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_or])->active)
		mode += 4;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_ow])->active)
		mode += 2;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_ox])->active)
		mode += 1;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_setuid])->active)
		mode += 4000;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_setgid])->active)
		mode += 2000;
	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_sticky])->active)
		mode += 1000;

	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_exact])->active)
		g_snprintf(buf, 20, "%s -perm %d", op, mode);
	else if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_all])->active)
		g_snprintf(buf, 20, "%s -perm -%d", op, mode);
	else if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_perm_any])->active)
		g_snprintf(buf, 20, "%s -perm +%d", op, mode);
#ifdef ENABLE_DEBUG
	else
		g_error("perm_common_cb: unknown perm match\n");
	APPDBG_ADVOPTS(("perm_common_cb: '%s'\n", buf));
#endif
	advopts_tests_list_add(w, buf, FALSE);
} /* perm_common_cb */


static void
perm_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (wgt == w->advwgts[Ef_ao_perm_but_and])
		perm_common_cb(w, "-a");
	else if (wgt == w->advwgts[Ef_ao_perm_but_or])
		perm_common_cb(w, "-o");
	else if (wgt == w->advwgts[Ef_ao_perm_but_not])
		perm_common_cb(w, "!");
#ifdef ENABLE_DEBUG
	else
		g_error("perm_cb: Unknown widget\n");
#endif
} /* perm_cb */


static void
owner_name_entry_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_common_cb(cbdata, Ef_ao_owner_name_e, Ef_ao_owner_name_and,
				Ef_ao_owner_name_or, Ef_ao_owner_name_not);
} /* owner_name_entry_cb */


static void
group_name_entry_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_common_cb(cbdata, Ef_ao_group_name_e, Ef_ao_group_name_and,
				Ef_ao_group_name_or, Ef_ao_group_name_not);
} /* group_name_entry_cb */


static void
entry_bool_add(win_t *w, int entry_id, gboolean is_string,
		     char *test, char *op)
{
	char *name, *txt;

	name = gtk_entry_get_text(GTK_ENTRY(w->advwgts[entry_id]));
	if (name && name[0] != '\0') {
		if (is_string) {
			txt = g_strdup_printf("%s -%s %s", op, test, name);
		} else {
			int num = atoi(name);
			txt = g_strdup_printf("%s -%s %d", op, test, num);
		}
		advopts_tests_list_add(w, txt, TRUE);
	}
} /* entry_bool_add */


static void
entry_bool_common(GtkWidget *wgt, win_t *w, char *test, gboolean is_string,
		      int entry_id, int and_id, int or_id, int not_id)
{
	if (wgt == w->advwgts[and_id])
		entry_bool_add(w, entry_id, is_string, test, "-a");
	else if (wgt == w->advwgts[or_id])
		entry_bool_add(w, entry_id, is_string, test, "-o");
	else if (wgt == w->advwgts[not_id])
		entry_bool_add(w, entry_id, is_string, test, "!");
#ifdef ENABLE_DEBUG
	else
		g_error("entry_bool_common: Unknown widget\n");
#endif
} /* entry_bool_common */


static void
fstype_bool_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_bool_common(wgt, cbdata, "fstype", TRUE,
			  Ef_ao_fstype_e, Ef_ao_fstype_and,
			  Ef_ao_fstype_or, Ef_ao_fstype_not);
} /* fstype_bool_cb */


static void
owner_name_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_bool_common(wgt, cbdata, "user", TRUE,
			  Ef_ao_owner_name_e, Ef_ao_owner_name_and,
			  Ef_ao_owner_name_or, Ef_ao_owner_name_not);
} /* owner_name_cb */


static void
group_name_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_bool_common(wgt, cbdata, "group", TRUE,
			  Ef_ao_group_name_e, Ef_ao_group_name_and,
			  Ef_ao_group_name_or, Ef_ao_group_name_not);
} /* group_name_cb */


static void
owner_uid_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_bool_common(wgt, cbdata, "uid", FALSE,
			  Ef_ao_owner_uid_s, Ef_ao_owner_uid_and,
			  Ef_ao_owner_uid_or, Ef_ao_owner_uid_not);
} /* owner_uid_cb */


static void
group_gid_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_bool_common(wgt, cbdata, "gid", FALSE,
			  Ef_ao_group_gid_s, Ef_ao_group_gid_and,
			  Ef_ao_group_gid_or, Ef_ao_group_gid_not);
} /* group_gid_cb */


static void
fsize_common_cb(win_t *w, char *op)
{
	GtkWidget *child;
	GtkButton *button;
	char *str, *txt;
	char unit;
	int val;

	txt = gtk_entry_get_text(GTK_ENTRY(w->advwgts[Ef_ao_fsize_val]));
	val = atoi(txt);

	if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_fsize_blocks])->active)
		unit = 'b';
	else if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_fsize_bytes])->active)
		unit = 'c';
	else if (GTK_TOGGLE_BUTTON(w->advwgts[Ef_ao_fsize_kb])->active)
		unit = 'k';
	else {
		g_assert(GTK_TOGGLE_BUTTON(
				w->advwgts[Ef_ao_fsize_words])->active);
		unit = 'w';
	}

	button = &(GTK_OPTION_MENU(w->advwgts[Ef_ao_fsize_optmenu])->button);
	child = GTK_BIN(button)->child;

	g_assert(GTK_IS_LABEL(child));
	gtk_label_get(GTK_LABEL(child), &str);

	if (g_strcasecmp(str, "Exactly") == 0) {
		txt = g_strdup_printf("%s -size %d%c", op, val, unit);
	} else if (g_strcasecmp(str, "More than") == 0) {
		txt = g_strdup_printf("%s -size +%d%c", op, val, unit);
	} else {
		g_assert(g_strcasecmp(str, "Less than") == 0);
		txt = g_strdup_printf("%s -size -%d%c", op, val, unit);
	}

	advopts_tests_list_add(w, txt, TRUE);
} /* fsize_common_cb */


static void
fsize_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (wgt == w->advwgts[Ef_ao_fsize_and])
		fsize_common_cb(cbdata, "-a");
	else if (wgt == w->advwgts[Ef_ao_fsize_or])
		fsize_common_cb(cbdata, "-o");
	else if (wgt == w->advwgts[Ef_ao_fsize_not])
		fsize_common_cb(cbdata, "!");
#ifdef ENABLE_DEBUG
	else
		g_error("fsize_cb: Unknown widget\n");
#endif
} /* fsize_cb */


static void
ftype_common_cb(win_t *w, char *test, char *op)
{
	GtkWidget *child;
	GtkButton *button;
	char *str, *txt;
	char ftype;

	if (strcmp(test, "type") == 0) {
		button = &(GTK_OPTION_MENU(
				w->advwgts[Ef_ao_ftype_optmenu])->button);
	} else {
		g_assert(strcmp(test, "xtype") == 0);
		button = &(GTK_OPTION_MENU(
				w->advwgts[Ef_ao_xtype_optmenu])->button);
	}
	child = GTK_BIN(button)->child;

	g_assert(GTK_IS_LABEL(child));
	gtk_label_get(GTK_LABEL(child), &str);

	if (g_strcasecmp(str, "Regular File") == 0) {
		ftype = 'f';
	} else if (g_strcasecmp(str, "Directory") == 0) {
		ftype = 'd';
	} else if (g_strcasecmp(str, "Symbolic Link") == 0) {
		ftype = 'l';
	} else if (g_strcasecmp(str, "Block Device") == 0) {
		ftype = 'b';
	} else if (g_strcasecmp(str, "Character Device") == 0) {
		ftype = 'c';
	} else if (g_strcasecmp(str, "Named Pipe") == 0) {
		ftype = 'p';
	} else {
		g_assert(g_strcasecmp(str, "Socket") == 0);
		ftype = 's';
	}
	txt = g_strdup_printf("%s -%s %c", op, test, ftype);
	advopts_tests_list_add(w, txt, TRUE);
} /* ftype_common_cb */


static void
ftype_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (wgt == w->advwgts[Ef_ao_ftype_and])
		ftype_common_cb(cbdata, "type", "-a");
	else if (wgt == w->advwgts[Ef_ao_ftype_or])
		ftype_common_cb(cbdata, "type", "-o");
	else if (wgt == w->advwgts[Ef_ao_ftype_not])
		ftype_common_cb(cbdata, "type", "!");
	else if (wgt == w->advwgts[Ef_ao_xtype_and])
		ftype_common_cb(cbdata, "xtype", "-a");
	else if (wgt == w->advwgts[Ef_ao_xtype_or])
		ftype_common_cb(cbdata, "xtype", "-o");
	else if (wgt == w->advwgts[Ef_ao_xtype_not])
		ftype_common_cb(cbdata, "xtype", "!");
#ifdef ENABLE_DEBUG
	else
		g_error("ftype_cb: Unknown widget\n");
#endif
} /* ftype_cb */


static void
fstype_entry_cb(GtkWidget *wgt, gpointer cbdata)
{
	entry_common_cb(cbdata, Ef_ao_fstype_e, Ef_ao_fstype_and,
				Ef_ao_fstype_or, Ef_ao_fstype_not);
} /* fstype_entry_cb */


/* the end */
