/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 * Copyright 2008, James P. Michels III <james.p.michels@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
using System;
using Gtk;
using System.Threading;
using System.Diagnostics;
using System.IO;
using Mono.Unix;
using System.Collections.Generic;

namespace GnomeRDP 
{
	public class ProcessCaller
	{
		private readonly string	_fileName;
		private readonly string	_arguments;
		private readonly string	_workingDirectory;
		private readonly bool _vnc;
		private readonly string	_passwd;
		private readonly Gtk.Window	_wnd;
		private readonly Process process;
		
		private static int _connectionCount = 0;
		public static int ConnectionCount
		{
			get 
			{
				return _connectionCount;
			}
		}

		private readonly static List<Process> _processes = new List<Process>();
		public static Process[] Processes
		{
			get 
			{
				return _processes.ToArray();
			}
		}
		
		public ProcessCaller(
			string		fileName,
			string 		arguments,
			string 		workingDirectory,
			bool   		vnc,
			string 		passwd,
			Gtk.Window 	pwnd)	
		{			
			this._fileName = fileName;
			this._arguments = arguments;
			this._workingDirectory = workingDirectory;
			this._vnc = vnc;
			this._passwd = passwd;
			this._wnd = pwnd;
		
			if (Defines.DEBUG) Console.WriteLine(this.ToString());
		
			this.process = new Process();
			process.StartInfo.UseShellExecute 		= false;
			process.StartInfo.RedirectStandardOutput= true;
			process.StartInfo.RedirectStandardError	= true;
			process.StartInfo.RedirectStandardInput	= true;
			process.StartInfo.CreateNoWindow 		= true;
			process.StartInfo.FileName	 			= this._fileName;
			process.StartInfo.Arguments 		 	= this._arguments;
			process.StartInfo.WorkingDirectory	 	= this._workingDirectory;
			process.EnableRaisingEvents 		 	= true;
			process.WaitForInputIdle();			
			_processes.Add(process);
		}
		
		public void StartProcess()
		{
			new System.Threading.Thread(new ThreadStart(ThreadRoutine)).Start();
		}
		
		private void ThreadRoutine()
		{
			_connectionCount++;
			try 
			{
				this.process.Start();
			}
			catch (Exception ex) 
			{
				Console.WriteLine(ex.Message);
				Gdk.Threads.Enter();
				MessageDialog md = new MessageDialog(this._wnd, DialogFlags.Modal, MessageType.Error, ButtonsType.Close, String.Format(Catalog.GetString("{0} seems not to be installed."), _processes[_processes.Count-1].StartInfo.FileName));
				md.Run();
				md.Destroy();
				Gdk.Threads.Leave();
			}
			
			new System.Threading.Thread(new ThreadStart(ReadStdOut)).Start();
			new System.Threading.Thread(new ThreadStart(ReadStdErr)).Start();
			
			if (this._vnc)
			{
				try
				{
					this.process.StandardInput.WriteLine(this._passwd);
 					this.process.StandardInput.WriteLine(this._passwd);
				}
				catch (Exception e)
				{
					Console.WriteLine(e.Message);
				}
			}
			
			this.process.WaitForExit();
			_connectionCount--;
		}	
		
		public virtual void ReadStdOut()
		{
			string msg = GLib.Markup.EscapeText(this.process.StandardOutput.ReadToEnd());
			if (msg != null && msg.Trim().Length > 0 && this._vnc == false)
			{
				Gdk.Threads.Enter();
				MessageDialog md = new MessageDialog(this._wnd, DialogFlags.Modal, MessageType.Info, ButtonsType.Close, msg);
				md.Run();
				md.Destroy();
				Gdk.Threads.Leave();
			}										
		}
		
		public virtual void ReadStdErr()
		{
			string msg = GLib.Markup.EscapeText(this.process.StandardError.ReadToEnd());
			if (msg != null && msg.Trim().Length > 0 && this._vnc == false)
			{
				Gdk.Threads.Enter();
				MessageDialog md = new MessageDialog(this._wnd, DialogFlags.Modal, MessageType.Info, ButtonsType.Close, msg);
				md.Run();
				md.Destroy();
				Gdk.Threads.Leave();
			}													
		}
		
		public override string ToString()
		{
			return string.Format("ProcessCaller: fileName={0},arguements={1},workingdirectory={2},isVnc={3},password={4}", _fileName, _arguments, _workingDirectory, _vnc, _passwd);
		}
	}
}
