#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001 Free Software Foundation
#
# FILE:
# GParserHelpers.py
#
# DESCRIPTION:
# Class that holds GNUe Parser helper classes
#
# NOTES:
#
# HISTORY:
#

from xml.sax import saxutils

#
# Class GContent
#
# Base class for xml content
#
class GContent:

  def __init__(self, parent, content):
    self._content = content
    if parent :
      parent.addChild(self)

  def getEscapedContent(self):
    return saxutils.escape(self._content)

  def getContent(self):
    return self._content

  def toXML(self):
    return saxutils.escape(self._content)

  def dumpXML(self, lookupDict, treeDump=None, gap=None, escape=1):
    if escape:
      return saxutils.escape(self._content)
    else:
      return self._content

  def showTree(self, indent=0):
    print ' '*indent + 'GContent ' + `self._content`

  def getObjectType(self):
    return "_content_"

  #
  # getDescription
  #
  # Return a useful description of this object
  # Used by designer clients
  #
  def getDescription(self):
    return "(Content)"
