#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# mysql/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data vi MySQL
#
# NOTES:
# Supports transactions if the MySQL server is compiled w/transaction support
# (which it does NOT by default)


from string import lower
import sys
from gnue.common import GDebug, GDataObjects
from gnue.common.dbdrivers._dbsig.DBdriver \
   import DBSIG_RecordSet, DBSIG_ResultSet, DBSIG_DataObject, \
          DBSIG_DataObject_SQL, DBSIG_DataObject_Object

try: 
  import MySQLdb
except ImportError, mesg:
  GDebug.printMesg(1,mesg)
  print "-"*79
  print "\nCould not load MySQLdb.  For MySQL support, please install \n" \
      + "mysql-python 0.9.0 or later " \
      + "from http://sourceforge.net/projects/mysql-python\n"
  print "Error:  %s" % mesg
  print "-"*79
  sys.exit()



class MySQL_RecordSet(DBSIG_RecordSet): 
  pass    


class MySQL_ResultSet(DBSIG_ResultSet): 
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None): 
    DBSIG_ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = MySQL_RecordSet



class MySQL_DataObject(DBSIG_DataObject): 
  def __init__(self): 
    DBSIG_DataObject.__init__(self)
    self._DatabaseError = MySQLdb.DatabaseError
    self._resultSetClass = MySQL_ResultSet


  def connect(self, connectData={}): 
    GDebug.printMesg(1,"Mysql database driver initializing")
    try: 
      self._dataConnection = MySQLdb.connect(user=connectData['_username'], 
                   passwd=connectData['_password'], 
                   host=connectData['host'], 
                   db=connectData['dbname'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._beginTransaction()
    self._postConnect()


  def _postConnect(self): 
    self.triggerExtensions = TriggerExtensions(self._dataConnection)


  def _beginTransaction(self):
    try: 
      self._dataConnection.begin()
    except: 
      pass

class MySQL_DataObject_Object(MySQL_DataObject, \
      DBSIG_DataObject_Object):

  def __init__(self): 
    MySQL_DataObject.__init__(self)

  def _buildQuery(self, conditions={}): 
    return DBSIG_DataObject_Object._buildQuery(self, conditions)


class MySQL_DataObject_SQL(MySQL_DataObject, \
      DBSIG_DataObject_SQL): 
  def __init__(self): 
    # Call DBSIG init first because MySQL_DataObject needs to overwrite 
    # some of its values
    DBSIG_DataObject_SQL.__init__(self) 
    MySQL_DataObject.__init__(self)

  def _buildQuery(self, conditions={}): 
    return DBSIG_DataObject_SQL._buildQuery(self, conditions)


#
#  Extensions to Trigger Namespaces
#  
class TriggerExtensions: 

  def __init__(self, connection): 
    self.__connection = connection

  # Return the current date, according to database
#  def getDate(self): 
#    pass

  # Return a sequence number from sequence 'name' 
#  def getSequence(self, name): 
#    pass

  # Run the SQL statement 'statement'
#  def sql(self, statement): 
#    pass



######################################
#
#  The following hashes describe 
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
# 
supportedDataObjects = { 
  'object': MySQL_DataObject_Object,
  'sql':    MySQL_DataObject_SQL
}

