#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# postgresql/DBdriver.py
#
# DESCRIPTION:
# Postgresql implementation of dbdriver using Python DB-SIG v2
# specification.
#
# NOTES:
#


from gnue.common import GDebug, GDataObjects, GConnections
from gnue.common.dbdrivers._pgsql.DBdriver \
   import PGSQL_RecordSet, PGSQL_ResultSet, PGSQL_DataObject, \
          PGSQL_DataObject_SQL, PGSQL_DataObject_Object, \
          PGSQL_TriggerExtensions

try:
  import pgdb
  from _pg import error as PGError   # This is so we can catch login errors
except ImportError, message:
  raise GConnections.AdapterNotInstalled, \
         "Driver not installed: pygresql for PostgreSQL [%s]" % message

class PG_RecordSet(PGSQL_RecordSet):
  pass

class PG_ResultSet(PGSQL_ResultSet):
  pass

class PG_DataObject(PGSQL_DataObject):

  def __init__(self):
    PGSQL_DataObject.__init__(self)
    self._DatabaseError = pgdb.Error
    self._resultSetClass = PG_ResultSet

  # TODO: This needs to go away.  Need to make _pgsql use a _getConnection
  # TODO: method that returns the data connection.  But I'm out of time for
  # TODO: today

  def connect(self, connectData={}):
    GDebug.printMesg(1,"Postgresql database driver initializing")
    try:
      self._dataConnection = pgdb.connect(user=connectData['_username'],
                   password=connectData['_password'],
                   host=connectData['host'],
                   database=connectData['dbname'])
      self.triggerExtensions = TriggerExtensions(self._dataConnection)
    except PGError, value:
      raise GDataObjects.LoginError, value
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    try: 
      encoding = connectData['encoding']
      GDebug.printMesg(1,'Setting postgresql client_encoding to %s' % encoding)
      cursor = self._dataConnection.cursor()
      cursor.execute("SET CLIENT_ENCODING TO '%s'" % encoding)
      cursor.close()
    except KeyError: 
      pass
    except self._DatabaseError: 
      try: 
        cursor.close()
      except: 
        pass

    self._postConnect()

class PG_DataObject_Object(PG_DataObject, PGSQL_DataObject_Object):
  def __init__(self):
    PGSQL_DataObject_Object.__init__(self)
    PG_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
        return PGSQL_DataObject_Object._buildQuery(self, conditions)
      
class PG_DataObject_SQL(PG_DataObject, PGSQL_DataObject_SQL):
  def __init__(self):
    PGSQL_DataObject_SQL.__init__(self)
    PG_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
        return PGSQL_DataObject_SQL._buildQuery(self, conditions)

class TriggerExtensions(PGSQL_TriggerExtensions):
  pass

######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': PG_DataObject_Object,
  'sql':    PG_DataObject_SQL
}






