#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# StatusBar.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from re import search
from string import split
import string
from Control import Control
import sio, curses

class StatusBar(Control):
  """
    This class implements a status bar. Sizes is a tuple of integers,
    specifying the size of each Field.  Of any sizes are 0, then they
    are automatically expanded.
  """

  def __init__(self, Parent, StatusName, Y, X, W, Sizes, **properties):
    Control.__init__(self, Parent, StatusName, **properties)
    self.PadHeight = 2 # pad the height by this much if multiline
    self.PARENT = Parent
    self.X = X
    self.Y = Y
    self.W = W
    self.H = 1
    self.CANGETFOCUS=0
    self.NUM_FIELDS = numfields = len(Sizes)
    self.FIELD_SIZES = Sizes = list(Sizes)
    self.FIELD_X = []
    self._visible = 0


    #
    # Fill the autosizers
    #
    staticTotal = 0
    autos = []

    i = 0
    for size in Sizes:
      if size < 1:
        autos.append (i)
      else:
        staticTotal += size

      i += 1

    if len(autos):
      autoTotal = W - (numfields - 1 + staticTotal)
      autoSize = int(autoTotal / len(autos))

      for i in autos:
        Sizes[i] = autoSize

      # In case there's an odd number of autoTotal,
      # make the last one take up remaining space.
      Sizes[autos[-1]] = autoTotal - autoSize * (len(autos) - 1)


    #
    # Set starting X's
    #
    self._EmptyStatusBar = ""
    lx = X
    addsep = 0
    for size in Sizes:
      self.FIELD_X.append(lx)
      lx += size + 1

      # Create empty status bar
      if addsep:
        self._EmptyStatusBar += chr(tiVLINE)
      self._EmptyStatusBar += " " * size

      addsep = 1

    self._EmptyStatusBar += " " * (W - len(self._EmptyStatusBar))


    self.CLASS = "LABEL"
    self.TEXT = [" "] * self.NUM_FIELDS
    self.CANGETFOCUS = 0

    self.SetMethod("SYSPAINT", self.Paint)
    self.SetMethod("SYSGOTFOCUS", None)
    self.SetMethod("SYSLOSTFOCUS", None)

    gDebug(1,"X=%s,Y=%s,W=%s, Xs=%s, lenEmpty=%s, Sizes=%s" % \
                       (X, Y, W, self.FIELD_X, len(self._EmptyStatusBar), Sizes))


  def SetText (self, index, caption):
    # for more carefully formatted output
    if index >= self.NUM_FIELDS:
      raise "StatusBar.SetText called with an index greater than the number of sections"

    self.TEXT[index] = caption

    if self._visible:
      size =self.FIELD_SIZES[index]
      X = self.FIELD_X[index] + self.X - self.X
      caption = string.ljust(caption[:size], size)

      Container = self.PARENT.Screen()
      y,x = Container.GetYX()
      self.HiLight
      Container.PrintAt(self.Y,X,caption, Container.colors.C_STATUSBAR_FIELD)

      Container.GotoYX(y,x)






  def Paint(self, v1, v2, v3):
    Container = self.PARENT.Screen()
    if Container == None:
      raise "No container--can't paint!"
#    self.LoLight()
    Y = self.Y

    Container.PrintAt(Y,self.X,self._EmptyStatusBar, Container.colors.C_STATUSBAR)

    for index in range(self.NUM_FIELDS):

      size =self.FIELD_SIZES[index]
      X = self.FIELD_X[index] + self.X - self.X
      caption = string.ljust(self.TEXT[index][:size], size)

      Container.PrintAt(Y,X,caption, Container.colors.C_STATUSBAR_FIELD)

    self._visible = 1

