#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
#
# FILE:
# GCoreTrigger.py
#
# DESCRIPTION:
# A base class inherited by GObj.  It's only purpose
# is to keep all the trigger code in one place instead
# of tacking some trigger code into GObj directly
# It's in it's own file to prevent circular imports
#
# NOTES:
#

#
# GTriggerCore
#
#
class GTriggerCore:
  def __init__(self):
    self._triggerGlobal = 0
    self._triggerFunctions = {}

    self._triggerProperties = {}

    #
    # Dictionary representing this object's
    # local namespace.  Populated as part of
    # GTriggerNamespace.constructTriggerObject
    #
    self._localTriggerNamespace = {}
    
    #
    # Links to functions to be used when
    # trigger attempts to directly set or get
    # the objects by name
    #
    self._triggerSet = None
    self._triggerGet = None


    #
    # Dict of triggers that are valid for this specific 
    # object
    #
    self._validTriggers = {}

