#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
"""
A QT-based user interface driver for GNUe forms.
"""
# NOTES:
#

from gnue.common.apps import GDebug
import sys

from qt import *

__QtApp = None

def getQtApp():
    global __QtApp

    if not __QtApp:
        GDebug.printMesg(6,"QtApp initializing")
        __QtApp = GFqtApp()
    return __QtApp

class GFqtApp(QApplication):
  def __init__(self):
    QApplication.__init__(self, sys.argv)
    QObject.connect(self, SIGNAL('lastWindowClosed()'),
                    self, SLOT('quit()'))

  # TODO: self.setFont() will set fonts for all child widgets!!!

