/*
**  BounceWindowController.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_BounceWindowController
#define _GNUMail_H_BounceWindowController

#import <AppKit/AppKit.h>

#include "AddressTaker.h"

@class Message;

@interface BounceWindowController: NSWindowController <AddressTaker>
{
  // Outlets
  IBOutlet NSTextField *toField;
  IBOutlet NSTextField *ccField;
  IBOutlet NSTextField *bccField;
  
  IBOutlet id sendButton;
  IBOutlet id addressesButton;
  
  IBOutlet NSPopUpButton *accountPopUpButton;
  IBOutlet NSPopUpButton *transportMethodPopUpButton;

  // Other ivar
  Message *message;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// action methods
//
- (IBAction) send : (id) sender;
- (IBAction) accountSelectionHasChanged: (id) sender;


//
// delegate methods
//
- (void) windowWillClose: (NSNotification *) theNotification;
- (void) windowDidBecomeMain: (NSNotification *) theNotification;
- (void) windowDidLoad;


//
// access/mutation methods
//
- (Message *) message;
- (void) setMessage: (Message *) theMessage;

@end


//
// Private methods
//
@interface BounceWindowController (Private)

- (BOOL) _appendAdditionalHeadersToData: (NSMutableData *) theData;
- (void) _loadAccounts;

@end

#endif // _GNUMail_H_BounceWindowController
