/*
**  MailboxesView.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>   
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "MailboxesView.h"

#include "Constants.h"
#include "LabelWidget.h"


//
//
//
@implementation MailboxesView

- (void) dealloc
{
  NSDebugLog(@"MailboxesView: -dealloc");
  
  RELEASE(mailboxesDefaultInboxPopUpButton);
  RELEASE(mailboxesDefaultSentPopUpButton);
  RELEASE(mailboxesDefaultDraftsPopUpButton);
  RELEASE(mailboxesDefaultTrashPopUpButton);
  RELEASE(mailboxesDefaultInboxLabel);
  RELEASE(mailboxesRefreshButton);

  [super dealloc];
}


//
//
//
- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}


//
//
//
- (void) layoutView
{
  LabelWidget *label;

  [self setFrame: NSMakeRect(0,0,400,360)];
  [self setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];


  //
  // Inbox
  //
  mailboxesDefaultInboxLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,300,380,TextFieldHeight)
					    label: _(@"Save messages received from this account in this mailbox:")];
  [self addSubview: mailboxesDefaultInboxLabel];
  RETAIN(mailboxesDefaultInboxLabel);

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 270, 50, TextFieldHeight)
		       label: _(@"Inbox:")
		       alignment: NSRightTextAlignment];
  [self addSubview: label];
  
  mailboxesDefaultInboxPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(65, 270, 250, ButtonHeight)];
  [mailboxesDefaultInboxPopUpButton addItemWithTitle: @""];
  [self addSubview: mailboxesDefaultInboxPopUpButton];
  


  //
  // Sent
  //
  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,230,380,TextFieldHeight)
		       label: _(@"Save messages sent from this account in this mailbox:")];
  [self addSubview: label];

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 200, 50, TextFieldHeight)
		       label: _(@"Sent:")
		       alignment: NSRightTextAlignment];
  [self addSubview: label];
  
  mailboxesDefaultSentPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(65, 200, 250, ButtonHeight)];
  [mailboxesDefaultSentPopUpButton addItemWithTitle: @""];
  [self addSubview: mailboxesDefaultSentPopUpButton];


  //
  // Drafts
  //
  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,160,380,TextFieldHeight)
		       label: _(@"Save composed but unsent messages in this mailbox:")];
  [self addSubview: label];

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 130, 50, TextFieldHeight)
		       label: _(@"Drafts:")
		       alignment: NSRightTextAlignment];
  [self addSubview: label];
  
  mailboxesDefaultDraftsPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(65, 130, 250, ButtonHeight)];
  [mailboxesDefaultDraftsPopUpButton addItemWithTitle: @""];
  [self addSubview: mailboxesDefaultDraftsPopUpButton];


  //
  // Trash
  //
  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,90,380,TextFieldHeight)
		       label: _(@"Save deleted messages in this mailbox:")];
  [self addSubview: label];

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5, 60, 50, TextFieldHeight)
		       label: _(@"Trash:")
		       alignment: NSRightTextAlignment];
  [self addSubview: label];
 
  mailboxesDefaultTrashPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(65, 60, 250, ButtonHeight)];
  [mailboxesDefaultTrashPopUpButton addItemWithTitle: @""];
  [self addSubview: mailboxesDefaultTrashPopUpButton];
  
  
  //
  // label
  //
  label =  [LabelWidget labelWidgetWithFrame: NSMakeRect(10, 20, 425, 30)
			label: _(@"If you don't see all your IMAP mailboxes, first open a connection to this server.\nTo update the list immediately, click on the Refresh button.")];
  [label setFont: [NSFont systemFontOfSize: 10]];
  [self addSubview: label];


  //
  // Refresh button
  //
  mailboxesRefreshButton = [[NSButton alloc] initWithFrame: NSMakeRect(330,5,60,ButtonHeight)];
  [mailboxesRefreshButton setStringValue: _(@"Refresh")];
  [mailboxesRefreshButton setTarget: parent];
  [mailboxesRefreshButton setAction: @selector(mailboxesRefreshButtonClicked:)];
  [self addSubview: mailboxesRefreshButton];
}

@end
