/*
**  AdvancedViewController.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>   
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "AdvancedViewController.h"

#include "Constants.h"
#include "ExtendedTableColumn.h"
#include "SwitchTableView.h"

#ifndef MACOSX
#include "AdvancedView.h"
#endif

#include <stdlib.h>


static AdvancedViewController *singleInstance = nil;

typedef struct _row {
  NSString *option;
  NSString *key;
  int value;
} row;

static row *rows;

#define COUNT 7

#define SET_VALUES(i, v1, v2, v3) \
 rows[i].option = RETAIN(v1); \
 rows[i].key = v2; \
 rows[i].value = v3


//
//
//
@implementation AdvancedViewController

- (id) initWithNibName: (NSString *) theName
{
  self = [super init];

  rows = (row *)malloc(COUNT * sizeof(row));

  SET_VALUES(0, _(@"Compact mailbox when closing"), @"COMPACT_MAILBOX_ON_CLOSE", NSOffState);
  SET_VALUES(1, _(@"Prompt before compacting a mailbox"), @"PROMPT_BEFORE_COMPACT", NSOffState);
  SET_VALUES(2, _(@"Repeat the message's subject (message threading)"), @"MAILWINDOW_REPEAT_SUBJECT", NSOnState);
  SET_VALUES(3, _(@"Automatically expand threads (message threading)"), @"AUTOMATICALLY_EXPAND_THREADS", NSOffState);
  SET_VALUES(4, _(@"Open the Console window on startup"), @"OPEN_CONSOLE_ON_STARTUP", NSOffState);
  SET_VALUES(5, _(@"Open the Mailboxes window on startup"), @"OPEN_MAILBOXMANAGER_ON_STARTUP", NSOffState);
  SET_VALUES(6, _(@"Enable continuous spell checking"), @"ENABLE_SPELL_CHECKING", NSOffState);

#ifdef MACOSX
  
  if ( ![NSBundle loadNibNamed: theName
		  owner: self] )
    {
      NSDebugLog(@"Fatal error occured while loading the AdvancedView nib file");
      AUTORELEASE(self);
      return nil;
    }

  RETAIN(view);

#else
  // We link our view
  view = [[AdvancedView alloc] initWithParent: self];
  [view layoutView];

  // We link our outlets
  tableView = ((AdvancedView*)view)->tableView;
  optionsColumn = ((AdvancedView*)view)->optionsColumn;
  enabledColumn = ((AdvancedView*)view)->enabledColumn;
#endif

#ifdef MACOSX
  {
    ExtendedTableColumn *extendedTableColumn;
    NSButtonCell *cell;

    cell = [[NSButtonCell alloc] init];

    [cell setButtonType: NSSwitchButton];
    [cell setImagePosition: NSImageOnly];
    [cell setControlSize: NSSmallControlSize];
    
    extendedTableColumn = (ExtendedTableColumn *)[tableView tableColumnWithIdentifier: @"enabled"];
    [extendedTableColumn setDataCell: cell];
    [extendedTableColumn setShouldUseMouse: YES];
    [extendedTableColumn setShouldUseAndSetState: YES];
    
    RELEASE(cell);
  }
#endif

  // We get our defaults for this panel
  [self initializeFromDefaults];

  return self;
}


//
//
//
- (void) dealloc
{
  int i;

  NSDebugLog(@"AdvancedViewController: -dealloc");
  
  // Cocoa bug?
#ifdef MACOSX
  [tableView setDataSource: nil];
#endif

  for (i = 0; i < COUNT; i++)
    {
      RELEASE(rows[i].option);
    }

  free(rows);

  singleInstance = nil;
  RELEASE(view);

  [super dealloc];
}


//
// access methods
//
- (NSImage *) image
{
  NSBundle *aBundle;
  
  aBundle = [NSBundle bundleForClass: [self class]];
  
  return AUTORELEASE([[NSImage alloc] initWithContentsOfFile:
					[aBundle pathForResource: @"advanced" ofType: @"tiff"]]);
}


//
//
//
- (NSString *) name
{
  return _(@"Advanced");
}


//
//
//
- (NSView *) view
{
  return view;
}

- (BOOL) hasChangesPending
{
  return YES;
}


//
//
//
- (void) initializeFromDefaults
{
  int i;

  for (i = 0; i < COUNT; i++)
    {
      if ( [[NSUserDefaults standardUserDefaults] objectForKey: rows[i].key] )
	{
	  rows[i].value = [[NSUserDefaults standardUserDefaults] integerForKey: rows[i].key];
	}
    }
}


//
//
//
- (void) saveChanges
{ 
  int i;

  for (i = 0; i < COUNT; i++)
    {
      [[NSUserDefaults standardUserDefaults] setInteger: rows[i].value
					     forKey: rows[i].key];
    }
}


//
// Data Source methods
//
- (int) numberOfRowsInTableView: (NSTableView *)aTableView
{
  return COUNT;
}


//
//
//
- (id)           tableView: (NSTableView *)aTableView
 objectValueForTableColumn: (NSTableColumn *)aTableColumn 
		       row: (int)rowIndex
{
  if ( aTableColumn == optionsColumn )
    {
      return rows[rowIndex].option;
    }

  return ( rows[rowIndex].value == NSOnState ? _(@"Yes") : _(@"No") );
}


- (int)    tableView: (NSTableView *) aTableView
 stateForTableColumn: (NSTableColumn *) aTableColumn 
		 row: (int) rowIndex
{
  return rows[rowIndex].value;
}


- (void) tableView: (NSTableView *) aTableView
	  setState: (int) aState
    forTableColumn: (NSTableColumn *) aTableColumn 
	       row: (int) rowIndex
{
  rows[rowIndex].value = aState;
}


//
// class methods
//
+ (id) singleInstance
{
  if ( !singleInstance)
    {
      singleInstance = [[AdvancedViewController alloc] initWithNibName: @"AdvancedView"];
    }

  return singleInstance;
}

@end
