/*
**  ExtendedOutlineView.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Francis Lachapelle <francis@Sophos.ca>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_ExtendedOutlineView
#define _GNUMail_H_ExtendedOutlineView

#import <AppKit/AppKit.h>

@interface ExtendedOutlineView: NSOutlineView
{
  NSImage *expanded, *collapsed;
}

#ifdef MACOSX
- (BOOL) isExpandable: (id) item;
#else
- (void) setCollapsedImage: (NSImage *) theImage;
- (void) setExpandedImage: (NSImage *) theImage;
#endif
- (void) setDropItem: (id) item 
      dropChildIndex: (int) index;
- (BOOL)shouldCollapseAutoExpandedItemsForDeposited: (BOOL) deposited;

@end

#endif // _GNUMail_H_ExtendedOutlineView
