/*
**  MailboxManager.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "MailboxManager.h"

#include "GNUMail.h"
#include "Constants.h"
#include "LabelWidget.h"
#include "ExtendedOutlineView.h"


//
//
//
@implementation MailboxManager

- (void) dealloc
{
  NSDebugLog(@"MailboxManager: -dealloc");

  RELEASE(mailboxColumn);
  RELEASE(messagesColumn);
  
  RELEASE(outlineView);
  RELEASE(scrollView);

  [super dealloc];
}


//
//
//
- (void) layoutWindow
{
  NSButton *create, *delete, *rename;

  delete = [[NSButton alloc] initWithFrame: NSMakeRect(24,388,40,40)];
  [delete setButtonType: NSMomentaryPushButton];
  [delete setTitle: @""];
  [delete setTarget: [self windowController]];
  [delete setAction: @selector(delete:)];
  [delete setImagePosition: NSImageOnly];
  [delete setImage: [NSImage imageNamed: @"delete_32.tiff"]];
  [delete setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: delete];
  RELEASE(delete);
   
  create = [[NSButton alloc] initWithFrame: NSMakeRect(69,388,40,40)];
  [create setButtonType: NSMomentaryPushButton];
  [create setTitle: @""];
  [create setTarget: [self windowController]];
  [create setAction: @selector(create:)];
  [create setImagePosition: NSImageOnly];
  [create setImage: [NSImage imageNamed: @"mailbox_add_32.tiff"]];
  [create setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: create];
  RELEASE(create);
  
  rename = [[NSButton alloc] initWithFrame: NSMakeRect(114,388,40,40)];
  [rename setButtonType: NSMomentaryPushButton];
  [rename setTitle: @""];
  [rename setTarget: [self windowController]];
  [rename setAction: @selector(rename:)];
  [rename setImagePosition: NSImageOnly];
  [rename setImage: [NSImage imageNamed: @"mailbox_rename_32.tiff"]];
  [rename setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: rename];
  RELEASE(rename);

  move = [[NSButton alloc] initWithFrame: NSMakeRect(231,388,40,40)];
  [move setButtonType: NSMomentaryPushButton];
  [move setTitle: @""];
  [move setTag: MOVE_MESSAGES];
  [move setTarget: [self windowController]];
  [move setAction: @selector(transfer:)];
  [move setImagePosition: NSImageOnly];
  [move setImage: [NSImage imageNamed: @"mailbox_move_32.tiff"]];
  [move setAutoresizingMask: NSViewMinXMargin|NSViewMinYMargin];
  [[self contentView] addSubview: move];
  RELEASE(move);

  copy = [[NSButton alloc] initWithFrame: NSMakeRect(276,388,40,40)];
  [copy setButtonType: NSMomentaryPushButton];
  [copy setTitle: @""];
  [copy setTag: COPY_MESSAGES];
  [copy setTarget: [self windowController]];
  [copy setAction: @selector(transfer:)];
  [copy setImagePosition: NSImageOnly];
  [copy setImage: [NSImage imageNamed: @"mailbox_copy_32.tiff"]];
  [copy setAutoresizingMask: NSViewMinXMargin|NSViewMinYMargin];
  [[self contentView] addSubview: copy];
  RELEASE(copy);

  mailboxColumn = [[NSTableColumn alloc] initWithIdentifier: @"Mailbox"];
  [mailboxColumn setEditable: NO];
  [[mailboxColumn headerCell] setStringValue: _(@"Mailbox")];
  [mailboxColumn setMinWidth: 200];

  messagesColumn = [[NSTableColumn alloc] initWithIdentifier: @"Messages"];
  [messagesColumn setEditable: NO];
  [[messagesColumn headerCell] setStringValue: _(@"Messages")];

  outlineView = [[ExtendedOutlineView alloc] initWithFrame: NSMakeRect (0, 0, 400, 380)];
  [outlineView addTableColumn: mailboxColumn];
  [outlineView addTableColumn: messagesColumn];
  [outlineView setOutlineTableColumn: mailboxColumn];
  [outlineView setDrawsGrid: NO];
  [outlineView setIndentationPerLevel: 10];
  [outlineView setAutoresizesOutlineColumn: YES];
  [outlineView setIndentationMarkerFollowsCell: YES];
  [outlineView setAllowsColumnSelection: NO];
  [outlineView setAllowsColumnReordering: NO];
  [outlineView setAutoresizesAllColumnsToFit: YES];
  [outlineView sizeLastColumnToFit];
  [outlineView setDataSource: [self windowController]];
  [outlineView setDelegate: [self windowController]];
  [outlineView setDoubleAction: @selector(open:)];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect (0, 0, 400, 380)];
  [scrollView setDocumentView: outlineView];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
  [[self contentView] addSubview: scrollView];
 
  [self setMinSize: NSMakeSize(300,250)];
}

@end
