/*
**  MailboxManagerController.h
**
**  Copyright (C) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_MailboxManagerController
#define _GNUMail_H_MailboxManagerController

#import <AppKit/AppKit.h>

@class EditWindowController;
@class ExtendedOutlineView;
@class Flags;
@class Folder;
@class FolderNode;
@class IMAPFolder;
@class IMAPStore;
@class MailboxManagerCache;
@class Message;
@class Store;
@class URLName;

#ifdef MACOSX
@interface MailboxManagerController: NSObject
#else
@interface MailboxManagerController: NSWindowController
#endif
{
  // Outlets - PS: _no_ view under OS X, only the model/controller.
#ifndef MACOSX
  IBOutlet NSButton *move, *copy;
  IBOutlet NSImageView *icon;
  IBOutlet NSScrollView *scrollView;
#else
  IBOutlet NSMenu *menu;
#endif
  IBOutlet ExtendedOutlineView *outlineView;

  // Other ivars
  MailboxManagerCache *mailboxManagerCache;

  NSMutableArray *allFolders;
  FolderNode *localNodes;

  NSMutableDictionary *allStores;
}

//
// delegate methods
//
- (void) windowDidLoad;


//
// action methods
//
- (IBAction) open: (id) sender;
- (IBAction) transfer: (id) sender;
- (IBAction) create: (id) sender;
- (IBAction) delete: (id) sender;
- (IBAction) rename: (id) sender;


//
// access/mutation methods
//
- (NSOutlineView *) outlineView;

- (id) storeForName: (NSString *) theName
           username: (NSString *) theUsername;

- (id) storeForURLName: (URLName *) theURLName;

- (void) setStore: (id) theStore
             name: (NSString *) theName
         username: (NSString *) theUsername;


- (MailboxManagerCache *) mailboxManagerCache;
- (void) setMailboxManagerCache: (MailboxManagerCache *) theMailboxManagerCache;


- (void) addMessage: (NSDictionary *) theDictionary;
- (void) addMessage: (NSData *) theMessage
           toFolder: (URLName *) theURLName;

- (Message *) messageFromDraftsFolder;

- (NSDictionary *) allStores;

#ifdef MACOSX
- (NSMenu *) outlineView: (NSOutlineView *) aOutlineView
      contextMenuForItem: (id) item;
- (void) setCurrentOutlineView: (id) theOutlineView;
#endif

- (void) updateFolderInformation: (NSDictionary *) theInformation;

//
// class methods
//
+ (id) singleInstance;


//
// Other methods
//
- (void) openFolderWithURLName: (URLName *) theURLName
                        sender: (id) theSender;

- (void) reloadAllFolders;

- (BOOL) transferMessageFromRawSource: (NSData *) theRawSource
                                flags: (Flags *) theFlags
		     toFolderWithName: (NSString *) theFolderName
                           orToFolder: (Folder *) theFolder
                                store: (Store *) theStore;

- (BOOL) folderNameExists: (NSString *) theFolderName
                 forStore: (Store *) theStore;

- (void) connectionWasLost: (id) sender;

- (BOOL) storeWithURLNameIsOpen: (URLName *) theURLName;

- (void) saveMessageInDraftsFolderForController: (EditWindowController *) theEditWindowController;

@end


//
// Private methods
//
@interface MailboxManagerController (Private)

- (void) _accountsHaveChanged: (id) sender;

- (BOOL) _deletingDefaultMailbox: (NSString **) theMailboxName
             usingURLNameAsString: (NSString *) theURLNameAsString;

- (BOOL) _initializeIMAPStoreWithAccountName: (NSString *) theAccountName;

- (void) _nbOfMessages: (int *) theNbOfMessages
    nbOfUnreadMessages: (int *) theNbOfUnreadMessages
               forItem: (id) theItem;


- (void) _openLocalFolderWithName: (NSString *) theFolderName
                           sender: (id) theSender;

- (void) _openIMAPFolderWithName: (NSString *) theFolderName
                           store: (IMAPStore *) theStore
                          sender: (id) theSender;

- (void) _reloadFoldersForIMAPStoreWithName: (NSString *) theName
                                   username: (NSString *) theUsername
                                    account: (NSString *) theAccountName;

- (FolderNode *) _storeFolderNodeForName: (NSString *) theName;

- (void) _reloadFoldersAndExpandParentsFromNode: (FolderNode *) theNode
                             selectNodeWithPath: (NSString *) thePath;

- (FolderNode *) _rootFolderNodeForNode: (FolderNode *) theNode;

- (NSString *) _stringValueOfURLNameFromItem: (id) theItem
                                       store: (Store **) theStore;

- (void) _updateShowOrHideReadAndDeletedForFolder: (Folder *) theFolder;

@end

#endif // _GNUMail_H_MailboxManagerController
