;;; ping.scm: send ping messages to buddy
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;; 
;;; ping.scm should be automatically loaded thru init.scm
;;; example:
;;; ?eval (ping 'buddy 10)


(define (ping buddy count)
  "send ping messages to buddy"
  (gy-send-message buddy 
		   (string-append "[" 
				  (strftime "%c UTC" (gmtime (current-time)))
				  "] <PING>"))
  (if (= count 1)
      '()
      (ping buddy (- count 1))))


;;; Dynamic command support
(gy-register-command! '("?ping" "?ping buddy count\n\t- ping a buddy count number of time(s)"))

(define (?ping args-list)
  (if (= (length args-list) 2)
      (ping (list-ref args-list 0) (list-ref args-list 1))
      (begin (display "?ping: wrong number of arguments") (newline) (display "usage: ?ping buddy count") (newline))))
