/* 
   extension.c: gnuyahoo extensions to guile
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#include <guile/gh.h>
#include "extension.h"
#include "gnuyahoo.h"
#include "scm-procedures.h"

SCM ex_message_send_hook;
SCM ex_message_receive_hook;
SCM ex_message_receive_offline_hook;
SCM ex_login_post_hook;
int hook_return = 0;

int
get_hook_return (void)
{
  return hook_return;
}

void
set_hook_return (int hook_return_value)
{
  hook_return = hook_return_value;
}

SCM
get_message_send_hook ()
{
  return (ex_message_send_hook);
}

SCM
get_message_receive_hook ()
{
  return (ex_message_receive_hook);
}

SCM
get_message_receive_offline_hook ()
{
  return (ex_message_receive_offline_hook);
}

SCM
get_login_post_hook ()
{
  return (ex_login_post_hook);
}

void
install_new_variables (void)
{
  // This is this is the place to install new variables
}

void
install_new_hooks (void)
{
  /* 
     ;; sample eqivalent code in scheme

     (define hook-test (make-hook 2))
     (define hook-proc (lambda (frm message)
     (display frm)
     (newline)
     (display message)
     (newline)))
     (add-hook! hook-test hook-proc)
     (run-hook hook-test "hi" "test")
   */

  /* scm_create_hook creates a hook with name, which is
     interned. This is only really useful from c, since in scheme, you
     can (define name (make-hook n_args))
   */

  ex_message_send_hook = scm_create_hook ("gy-message-send-hook", 2);
  /* hook: gy-message-send-hook

     is called from
     file: yahoo-wrapper.c
     function: send_message (...)

     with arguments
     "message-to" and "message-data"

     set the hook like this
     (add-hook! gy-message-send-hook (lambda (to message) (do-something)))
   */

  ex_message_receive_hook = scm_create_hook ("gy-message-receive-hook", 2);
  /* hook: gy-message-receive-offline-hook
     is called from
     file: yahoo-wrapper.c
     function: send_message (...)
     with arguments
     "message-from" and "message-data"

     set the hook like this
     (add-hook! gy-message-receive-hook (lambda (from message) (do-something)))
   */

  ex_message_receive_offline_hook = 
    scm_create_hook ("gy-message-receive-offline-hook", 3);
  /* hook: gy-message-receive-offline-hook

     is called from
     file: yahoo-wrapper.c
     function: process_offline_message (...)
     with arguments
     "message-from" "message-data" "message-time"
     
     set the hook like this
     (add-hook! gy-message-send-hook (lambda (from message time) (do-something)))
   */

  ex_login_post_hook = scm_create_hook ("gy-login-post-hook", 0);
  /* hook: gy-login-post-hook
     is called from
     file: messenger.c
     function: send_message (...)
     with arguments
     "message-from" and "message-data"

     set the hook like this
     (add-hook! gy-login-post-hook (lambda () (do-something)))
   */
}

void
install_new_procedures (void)
{
  /* installing general procedures */
  gh_new_procedure ("gy-load", ex_load, 1, 0, 0);
  /* this way you call me
     (gy-load "aliases.scm")
  */

  gh_new_procedure ("gy-send-message", ex_send_message, 2, 0, 0);
  /* this way you call me
     (gy-send-message "hello gnu")
  */

  gh_new_procedure ("gy-send-message-no-hook", ex_send_message_no_hook, 2, 0,
		    0);
  /* this way you call me
     (gy-send-message-no-hook "hello gnu")
  */

  gh_new_procedure ("gy-set-current-target-buddy!",
		    ex_set_current_target_buddy_x, 1, 0, 0);
  /* this way you call me
     (gy-set-current-target-buddy! "my_friend")
  */

  gh_new_procedure ("gy-register-command!", ex_register_command_x, 1, 0, 0);
  /* this way you call me
     (gy-register-command  "?ping")
  */

  gh_new_procedure ("gy-unregister-command!", ex_unregister_command_x, 1, 0, 0);
  /* this way you call me
     (gy-unregister-command  "?ping")
  */

  gh_new_procedure ("gy-version", ex_version, 0, 0, 0);
  /* this way you call me
     (display (gy-version))
  */

  gh_new_procedure ("gy-display", ex_display, 1, 0, 0);
  /* this way you call me
     (gy-display "Hello GNU")
  */


  /* installing configuration procedures */
  gh_new_procedure ("gy-bell!", ex_bell, 0, 0, 0);
  /* this way you call me
     (gy-bell!)
  */

  gh_new_procedure ("gy-toggle!", ex_toggle_x, 1, 0, 0);
  /* this way you call me
     (gy-bell-toggle! 'bell)
  */

  gh_new_procedure ("gy-get-home-dir", ex_get_home_dir, 0, 0, 0);
  /* this way you call me
     (display (gy-get-home-dir))
  */

  gh_new_procedure ("gy-get-config-dir", ex_get_config_dir, 0, 0, 0);
  /* this way you call me
     (display (gy-get-config-dir))
  */

  gh_new_procedure ("gy-get-config-filename", ex_get_config_filename, 0, 0,
		    0);
  /* this way you call me
     (display (gy-get-config-filename)
  */

  gh_new_procedure ("gy-get-download-filename", ex_get_download_filename, 0,
		    0, 0);
  /* this way you call me
     (display (gy-get-downlaod-filename)
  */

  gh_new_procedure ("gy-get-global-extensions-directory",
		    ex_get_global_extensions_directory, 0, 0, 0);
  /* this way you call me
     (display (gy-get-global-extensions-directory))
  */

  gh_new_procedure ("gy-get-local-extensions-directory",
		    ex_get_local_extensions_directory, 0, 0, 0);
  /* this way you call me
     (display (gy-get-local-extensions-directory))
  */

  gh_new_procedure ("gy-get-default-login-id", ex_get_default_login_id, 0, 0,
		    0);
  /* this way you call me
     (display (gy-get-login-id))
  */

  gh_new_procedure ("gy-set-default-login-id!", ex_set_default_login_id_x, 1,
		    0, 0);
  /* this way you call me
     (gy-set-login-id! "abindian")
  */

  gh_new_procedure ("gy-set-default-password!", ex_set_default_password_x, 1,
		    0, 0);
  /* this way you call me
     (gy-set-login-id! "press_enter")
  */

  gh_new_procedure ("gy-set-default-status!", ex_set_default_status_x, 1, 0,
		    0);
  /* this way you call me
     ;; default to invisible mode
     (gy-set-status! 12)
  */


  /* installing hook related extensions */
  gh_new_procedure ("gy-hook-return", ex_hook_return, 0, 0, 0);
  /* this way you call me
     (gy-hook-return)
  */

  gh_new_procedure ("gy-set-message!", ex_set_message_x, 1, 0, 0);
  /* this way you call me
     (gy-set-message! (string-upcase message))
  */

  gh_new_procedure ("gy-set-message-to!", ex_set_message_to_x, 1, 0, 0);
  /* this way you call me
     (gy-set-message-to! "rms")
  */

  gh_new_procedure ("gy-set-received-message!", ex_set_received_message_x, 1,
		    0, 0);
  /* this way you call me
     (gy-set-received-message! "CENSORED, SORRY!!")
  */

  gh_new_procedure ("gy-set-received-message-from!",
		    ex_set_received_message_from_x, 1, 0, 0);
  /* this way you call me
     (gy-set-received-message-from! "my_friend")
  */
}

// guile initialization area
void
guile_env_init (void)
{
  install_new_variables ();
  install_new_procedures ();
  install_new_hooks ();
}
