/* goat.c */

#include "main.h"
#include "goat.h"
#include "menu.h"
#include "fcntl.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "ipmsg.h"

extern gint num_goats,ox,oy, last_dispx, last_dispy, size_default, colour_default;
/* extern Goat *goat_list_start; */
extern GtkWidget *delete_icon, *cross_icon, *hide_icon,
                 *text_icon, *pen_icon, *mail_dialog,
                 *address_entry, *subject_entry,
                 *menu, *sticky_item, *floating_item, *shaded_item,
                 *ipmsg_dialog, *ip_entry;
extern gchar *pixmapdir, *default_sound_file, *default_font_name,
             *print_command, *mail_command;
extern GdkColor *default_fg, *default_bg[3];
extern GdkGC *global_gc;
extern GdkCursor *cursor;
extern gboolean drag_button, resize_button, 
                fall_on_release, delete_button, default_sound,
                default_sticky, default_floating, popup_stay,
                autosave;
extern GList *goats;
extern Goat *current_goat;

static GtkTargetEntry drag_types[] =
  {
    { "text/uri-list", 0, 0 },
  };

static gint n_drag_types = sizeof (drag_types) / sizeof (drag_types [0]);

/********************************
  Function to create new goat 
*********************************/

void
goat_create(gint x,gint y, gint height, gint width,
            gchar *message, gboolean alarm, time_t alarm_time,
            gboolean notify_message, gboolean play_sound,
            gchar *sound_filename, gchar *text, gint colour,
            gchar *font_name, gboolean lowered, gboolean sticky,
            gboolean floating, gboolean shaded, gint alarm_repeat,
            gchar *title, gboolean hidden)
{

  Goat *new_goat;
  GtkStyle *oldstyle;
  GdkColor *background_colour;
  GtkWidget *vbox, *hbox, *resize, *scrollwin;
  gint position;
  gchar *fname, *temp;

  /* allocate memory for goat */

  num_goats++;

  new_goat = (Goat*)g_malloc(sizeof(Goat));

  goats = g_list_append(goats,new_goat);

  /* create the main window */

  new_goat->note = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (new_goat->note), "Goat");

  gtk_widget_set_events(new_goat->note, 
                        GDK_BUTTON_PRESS_MASK |
                        GDK_BUTTON_RELEASE_MASK |
                        GDK_POINTER_MOTION_MASK |
                        GDK_POINTER_MOTION_HINT_MASK |
                        GDK_KEY_PRESS_MASK
                        );
  gtk_drag_dest_set (new_goat->note,
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_DROP,
		     drag_types, n_drag_types,
		     GDK_ACTION_COPY);

  /* add a vbox to split text/dragbar */

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (new_goat->note), vbox);

  /* split the dragbar up with a hbox */

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

  /* load the pixmaps */

  new_goat->cross = gnome_pixmap_new_from_gnome_pixmap(GNOME_PIXMAP(delete_icon));
  fname = g_strdup_printf("%s%s",pixmapdir,"resize.png");
  resize = gnome_pixmap_new_from_file(fname);
  g_free(fname);

  /* do the resize button in an eventbox */

  new_goat->eventbox1 = gtk_event_box_new();
  gtk_box_pack_start (GTK_BOX (hbox), new_goat->eventbox1, TRUE, TRUE, 0);
  gtk_container_add(GTK_CONTAINER(new_goat->eventbox1), resize);

  /* do the dragbar in another eventbox */

  new_goat->eventbox2 = gtk_event_box_new();
  gtk_box_pack_start (GTK_BOX (hbox), new_goat->eventbox2, TRUE, TRUE, 0);
  temp = g_strdup_printf("%s",title);
  new_goat->title = gtk_label_new(temp);
  g_free(temp);
  gtk_label_set_justify(GTK_LABEL(new_goat->title),GTK_JUSTIFY_LEFT);
  gtk_container_add(GTK_CONTAINER(new_goat->eventbox2), new_goat->title);

  /* do the cross in another eventbox */

  new_goat->eventbox3 = gtk_event_box_new();
  gtk_box_pack_start (GTK_BOX (hbox), new_goat->eventbox3, TRUE, TRUE, 0);
  gtk_container_add(GTK_CONTAINER(new_goat->eventbox3), new_goat->cross);

  /* make the text box */

  new_goat->font = gdk_fontset_load(font_name);
  if(new_goat->font == NULL) 
    new_goat->font = gdk_font_load(font_name);

  if(new_goat->font == NULL)
    new_goat->font = gdk_font_load(default_font_name);

  gdk_font_ref(new_goat->font);

  new_goat->font_name = g_strdup_printf("%s",font_name);
  new_goat->content = gtk_text_new(NULL,NULL);
  gtk_text_set_editable (GTK_TEXT(new_goat->content), TRUE);
  gtk_text_set_word_wrap(GTK_TEXT(new_goat->content), TRUE);

  /* set goat fore and background colours */

  if (colour == 4) {
    colour = (rand()%3)+1;
  }

  background_colour = default_bg[colour-1];
  new_goat->fg = gdk_color_copy(default_fg);
  new_goat->bg = gdk_color_copy(background_colour);
  new_goat->bg_topbar = (GdkColor *)g_malloc(sizeof(GdkColor));

  if (background_colour->red - 35*256 > 0)
    new_goat->bg_topbar->red = background_colour->red - 35*256;
  else new_goat->bg_topbar->red = 0;
  if (background_colour->blue - 35*256 > 0) 
    new_goat->bg_topbar->blue = background_colour->blue - 35*256;
  else new_goat->bg_topbar->blue = 0;
  if (background_colour->green - 35*256 > 0) 
    new_goat->bg_topbar->green = background_colour->green - 35*256;
  else new_goat->bg_topbar->green = 0;

  gdk_colormap_alloc_color(gtk_widget_get_colormap(new_goat->note),
			   new_goat->bg_topbar, TRUE, TRUE);
  gdk_colormap_alloc_color(gtk_widget_get_colormap(new_goat->note),
			   new_goat->bg, TRUE, TRUE);
  gdk_colormap_alloc_color(gtk_widget_get_colormap(new_goat->note),
			   new_goat->fg, TRUE, TRUE);

  oldstyle = gtk_widget_get_style(new_goat->content);
  new_goat->style = gtk_style_copy(oldstyle);
  (new_goat->style)->font = new_goat->font;
  new_goat->styletop = gtk_style_new();

  memcpy(&new_goat->styletop->bg[GTK_STATE_NORMAL], 
         new_goat->bg_topbar, sizeof(GdkColor));
  memcpy(&new_goat->style->base[GTK_STATE_NORMAL], 
         new_goat->bg, sizeof(GdkColor));
  memcpy(&new_goat->style->text[GTK_STATE_NORMAL], 
         new_goat->fg, sizeof(GdkColor));

  /* jdongsu: remove border */
  new_goat->style->klass->xthickness = 0;
  new_goat->style->klass->ythickness = 0;

  gtk_widget_set_style(new_goat->content, new_goat->style);
  gtk_widget_set_style(new_goat->eventbox1, new_goat->styletop);
  gtk_widget_set_style(new_goat->eventbox2, new_goat->styletop);
  gtk_widget_set_style(new_goat->eventbox3, new_goat->styletop);

  position = 0;

  if(text != NULL) {
    gtk_editable_insert_text(GTK_EDITABLE(new_goat->content),text,
                             strlen(text),&position);
  }

  /* set goat size */

  new_goat->height = height;
  new_goat->width = width;
  new_goat->colour = colour;

  scrollwin = gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwin),
				 GTK_POLICY_NEVER,
				 GTK_POLICY_NEVER);
  gtk_container_add(GTK_CONTAINER(scrollwin),new_goat->content);

  gtk_box_pack_start (GTK_BOX (vbox), scrollwin, TRUE, TRUE, 0);

  /* connect signals */

/*  gtk_signal_connect (GTK_OBJECT (new_goat->content),
                      "button_press_event",
                      GTK_SIGNAL_FUNC (goat_text_pressed),
                      new_goat); */

  gnome_popup_menu_attach(menu, new_goat->content, NULL);
  gnome_popup_menu_attach(menu, new_goat->eventbox2, NULL);
  gnome_popup_menu_attach(menu, new_goat->eventbox3, NULL);

  gtk_signal_connect (GTK_OBJECT (new_goat->content),
                      "key_press_event",
                      GTK_SIGNAL_FUNC (goat_key_pressed),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->content),
                      "selection_notify_event",
                      GTK_SIGNAL_FUNC (goat_selection_insert),
                      new_goat);
  gtk_signal_connect_after (GTK_OBJECT (new_goat->note),
                      "leave_notify_event",
                      GTK_SIGNAL_FUNC (goat_pointer_left),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->note),
                      "enter_notify_event",
                      GTK_SIGNAL_FUNC (goat_pointer_enter),
                      new_goat); 
  gtk_signal_connect (GTK_OBJECT (new_goat->eventbox1), 
                      "button_press_event",
		      GTK_SIGNAL_FUNC (goat_resize_pressed),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->eventbox2), 
                      "button_press_event",
		      GTK_SIGNAL_FUNC (goat_topbar_pressed),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->eventbox3), 
                      "button_press_event",
		      GTK_SIGNAL_FUNC (goat_cross_pressed),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->note), 
                      "button_release_event",
		      GTK_SIGNAL_FUNC (goat_button_released),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->note), 
                      "motion_notify_event",
		      GTK_SIGNAL_FUNC (goat_mouse_moved),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->note), 
                      "drag_data_received",
		      GTK_SIGNAL_FUNC (goat_drag_received),
                      new_goat);

  /* set a few defaults */

  new_goat->alarm = alarm;
  new_goat->message = g_strdup_printf("%s",message);
  new_goat->play_sound = play_sound;
  new_goat->sound_filename = g_strdup_printf("%s",sound_filename);
  new_goat->notify_message = notify_message;
  new_goat->alarm_time = alarm_time;
  new_goat->lowered = lowered;
  new_goat->sticky = sticky;
  new_goat->floating = floating;
  new_goat->shaded = shaded;
  new_goat->alarm_repeat = alarm_repeat;
  new_goat->hidden = hidden;
  new_goat->changed = FALSE;
  new_goat->height = height;
  new_goat->width = width;
  new_goat->x = x;
  new_goat->y = y;

  gtk_signal_connect (GTK_OBJECT (new_goat->note), 
                      "map",
		      GTK_SIGNAL_FUNC (goat_note_realize),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->content), 
                      "map",
		      GTK_SIGNAL_FUNC (goat_content_realize),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->note), 
                      "realize",
		      GTK_SIGNAL_FUNC (goat_note_real),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->eventbox1), 
                      "map",
		      GTK_SIGNAL_FUNC (goat_eventbox1_realize),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->eventbox2), 
                      "map",
		      GTK_SIGNAL_FUNC (goat_eventbox2_realize),
                      new_goat);
  gtk_signal_connect (GTK_OBJECT (new_goat->eventbox3), 
                      "map",
		      GTK_SIGNAL_FUNC (goat_eventbox3_realize),
                      new_goat);


/*  gtk_widget_show(new_goat->content); 
  gtk_widget_show(new_goat->eventbox1); 
  gtk_widget_show(new_goat->eventbox2); 
  gtk_widget_show(new_goat->eventbox3);  */
  if (!hidden) gtk_widget_show_all(new_goat->note);
}

void goat_note_real(GtkWidget *widget, Goat *goat)
{

  gdk_window_set_decorations(goat->note->window, 0);
  gnome_win_hints_set_hints(goat->note, 
                            WIN_HINTS_SKIP_TASKBAR |
                            WIN_HINTS_SKIP_WINLIST);
}

void goat_note_realize(GtkWidget *widget, Goat *goat)
{
  gint height;

  /* set cursor changes */

  cursor = gdk_cursor_new(GDK_XTERM);
  gdk_window_set_cursor(goat->note->window, cursor);
  gdk_cursor_destroy(cursor);

  if (goat->shaded) {
    height = 20;
  }
  else height = goat->height;

  if(goat->x != -1) {
    gdk_window_move(goat->note->window, goat->x, goat->y);
  }
  else {
    gdk_window_get_origin (goat->note->window, &(goat->x), &(goat->y)); 
  } 

  gdk_window_resize(goat->note->window, goat->width, height);
  gtk_widget_set_usize(goat->content, goat->width, goat->height-20);
  gtk_widget_set_usize(goat->eventbox2, goat->width-40, 20);

  if(goat->lowered) {
    gdk_window_lower(goat->note->window);
  }

  if(goat->floating) gnome_win_hints_set_layer(goat->note, 
					       WIN_LAYER_ONTOP);
  if(goat->sticky) gnome_win_hints_set_state(goat->note,
					     WIN_STATE_STICKY);
  
}

void goat_content_realize(GtkWidget *widget, Goat *goat)
{
  if(goat->shaded) goat_shade(goat, TRUE);
}

void goat_eventbox1_realize(GtkWidget *widget, Goat *goat)
{
  cursor = gdk_cursor_new(GDK_TOP_LEFT_CORNER);
  gdk_window_set_cursor(goat->eventbox1->window, cursor);
  gdk_cursor_destroy(cursor);
}

void goat_eventbox2_realize(GtkWidget *widget, Goat *goat)
{
  cursor = gdk_cursor_new(GDK_FLEUR);
  gdk_window_set_cursor(goat->eventbox2->window, cursor);
  gdk_cursor_destroy(cursor);
/*  gtk_widget_set_usize(goat->eventbox2, goat->width-40, 20); */
}

void goat_eventbox3_realize(GtkWidget *widget, Goat *goat)
{
  cursor = gdk_cursor_new(GDK_PIRATE);
  gdk_window_set_cursor(goat->eventbox3->window, cursor);
  gdk_cursor_destroy(cursor);
}

/********************************************
  Callbacks for mouse operations on the goat 
*********************************************/

gint
goat_topbar_pressed(GtkWidget *widget, 
                    GdkEventButton *event, Goat *goat)
{
  gint x,y;

  x = event->x;
  y = event->y;

  if (event->button == 1) {

    /* double click to change the title... */

    if (event->type == GDK_2BUTTON_PRESS) {
      goat_set_title(NULL, &goat); 
      return TRUE;
    }
    /* raise the window and prepare to drag... */

    drag_button = TRUE;

    gdk_window_raise(goat->note->window);
    gtk_window_set_modal(GTK_WINDOW(goat->note), TRUE); 
    ox = x+20;
    oy = y;
    goat->dragging = TRUE;
  }
  else if (event->button == 2) {

    /* shade notes... */

    if (goat->shaded) goat_shade(goat, FALSE);
    else goat_shade(goat, TRUE);

    /* update the menucheckbuttons */
 
    goat_pointer_enter(widget, NULL, goat);

  }
  return FALSE;
}

gint
goat_button_released(GtkWidget *widget, 
                     GdkEventButton *event, Goat *goat)
{
  drag_button = FALSE;
  resize_button = FALSE;
  goat->dragging = FALSE;
  gtk_window_set_modal(GTK_WINDOW(goat->note),FALSE);

  /* drop the goat to the back if this is what the user wants */

  if (fall_on_release) {
    if(goat->lowered) gdk_window_lower(goat->note->window);
  }
  return TRUE;
}

gint
goat_mouse_moved(GtkWidget *widget, 
                 GdkEventMotion *event, Goat *goat)
{
  gint x,y, wx, wy, dx, dy, dispx, dispy;
  GdkModifierType state;

  gdk_window_get_pointer (goat->note->window, &x, &y, &state);
  dx = x-ox;
  dy = y-oy;

  /* ox,oy is the original displacement of the pointer from the top
     left of the window */

  if (drag_button) {
    if (goat->dragging) {
      gdk_window_get_origin (goat->note->window, &wx, &wy); 
      gdk_window_move(goat->note->window, wx+dx, wy+dy);
      gdk_flush();
      goat->x = wx+dx;
      goat->y = wy+dy;
      gdk_window_get_pointer (goat->note->window, &x, &y, &state);
    }        
  }
  else if (resize_button) {
      gdk_window_get_origin (goat->note->window, &wx, &wy); 
      dispx = dx/20;
      dispy = dy/20; 
      if((dispx != last_dispx) || (dispy != last_dispy)) {
        gdk_window_move(goat->note->window, wx+dispx*10, wy+dispy*10);
        goat_set_size(goat->height - dispy*10,goat->width - dispx*10,goat); 
        gdk_flush();
        last_dispx = dispx;
        last_dispy = dispy;
        goat->x = wx+dispx*10;
        goat->y = wy+dispy+10;
      }
  }
  return FALSE;
}

gint
goat_cross_pressed(GtkWidget *widget, 
                   GdkEventButton *event, Goat *goat)
{
  /* delete/hide the goat */

  if(event->button == 1) {
    if(delete_button) goat_delete(widget,&goat);
    else goat_hide(widget, &goat);
  }

  return FALSE;
}

gint
goat_resize_pressed(GtkWidget *widget,
                    GdkEventButton *event, Goat *goat)
{
  gint x,y;

  if(event->button == 1) {
	if(goat->shaded) {
	  goat_shade(goat, FALSE);
	}
    x = event->x;
    y = event->y;
    resize_button = TRUE;
    gdk_window_raise(goat->note->window);
    gtk_window_set_modal(GTK_WINDOW(goat->note),TRUE);
    ox = x;
    oy = y;
    last_dispx = 0;
    last_dispy = 0;
  }
  return FALSE;
}

gint
goat_key_pressed(GtkWidget *widget, GdkEventKey *event, Goat *goat)
{
  if (event->length >0) {
    goat->changed = TRUE;
  }
  return TRUE;
}


gint
goat_selection_insert(GtkWidget *widget, GdkEventSelection *event, Goat *goat)
{
  goat->changed = TRUE;
  return TRUE;
}

/*******************************************
  Callbacks for activation of menu options 
********************************************/

void 
goat_new(GtkWidget *widget)
{

  goat_create(-1,-1,size_default,size_default,_("Alarm Triggered!"),FALSE,0,
              TRUE, default_sound, default_sound_file,NULL,colour_default, default_font_name, 
              FALSE, default_sticky, default_floating, FALSE, 0,"",
              FALSE);
  
}

void
goat_fit_to_text(GtkWidget *widget, Goat **goat)
{
  gint length, position, linepixels, maxpixels, lastline;
  gchar *character, *line;
  const gint newline=10;

  maxpixels=50;
  position=0;
  lastline=0;
  length = gtk_text_get_length(GTK_TEXT((*goat)->content));
  while (position < length) {
    character = gtk_editable_get_chars(GTK_EDITABLE((*goat)->content),
                                  position,position+1);
    position++;

  /* look for newline characters, or if this is the last line */

    if (strchr(character, newline) || (position == length)) {
      line = gtk_editable_get_chars(GTK_EDITABLE((*goat)->content),
                                    lastline,position); 
  /* measure the pixel width of this line + a bit of padding*/

      linepixels = gdk_string_width((*goat)->font, line) + 20;
      if (linepixels > maxpixels) maxpixels = linepixels;
      lastline = position;
    }
  }

  /* set size to the max pixel width of the text */
  if (maxpixels > 1000) maxpixels = 1000;
  goat_set_size((*goat)->height,maxpixels,*goat);
}

void
goat_print_text(GtkWidget *widget, Goat **goat)
{
  gchar *filename, *command, *format, *title;

  filename = goat_text_to_temp_file((*goat));
  if (filename) {
    gtk_label_get(GTK_LABEL((*goat)->title),&title);
    
    format = g_strdup_printf("%s%s",print_command," %s");
    command = g_strdup_printf(format, title, filename);
    system(command);
    
    unlink(filename);
    g_free(filename);
    g_free(format);
    g_free(command);
  }
}

void
goat_mail_text(GtkWidget *widget, Goat **goat)
{
/* display the dialog that asks for address & subject */

  mail_dialog_create(*goat);
  gnome_dialog_run_and_close(GNOME_DIALOG(mail_dialog));

}

void
goat_clear_text(GtkWidget *widget, Goat **goat)
{
  gtk_text_set_point(GTK_TEXT((*goat)->content),0);
  gtk_text_forward_delete(GTK_TEXT((*goat)->content),
             gtk_text_get_length(GTK_TEXT((*goat)->content)));
}

void
goat_set_title(GtkWidget *widget, Goat **goat)
{
  GtkWidget *dialog;
  gchar *current_title;

  gtk_label_get(GTK_LABEL((*goat)->title),&current_title);
  
  dialog = gnome_request_dialog(FALSE,_("Title for goat..."),
                                current_title,
                                100, (GnomeStringCallback)goat_change_title,
                                *goat, GTK_WINDOW((*goat)->note));
}

void
goat_insert_time(GtkWidget *widget, Goat **goat)
{

  time_t current;
  gchar *current_time;
  gint cursor,position, offset;
   
  current = time(NULL);
  current_time = ctime(&current);

  /* make sure we grab the right bit of the date string */

  offset = strlen(current_time) - 14;

  cursor = gtk_editable_get_position(GTK_EDITABLE((*goat)->content)); 
  position = cursor * sizeof(gchar); 

  gtk_editable_insert_text(GTK_EDITABLE((*goat)->content),
                           current_time+offset*sizeof(gchar),
                           8,&position);
  (*goat)->changed = TRUE;
}

void
goat_insert_date(GtkWidget *widget, Goat **goat)
{
  FILE *pipe;
  gchar line[100];
  gint cursor,position;

  /* just pipe the output of 'date' into the goat */
   
  pipe = popen("date +\"%A %e %B %Y\"", "r");

  fgets(line, 200, pipe);
  cursor = gtk_editable_get_position(GTK_EDITABLE((*goat)->content)); 
  position = cursor * sizeof(gchar); 

  gtk_editable_insert_text(GTK_EDITABLE((*goat)->content),
                           line,strlen(line),&position);
  pclose(pipe);
  (*goat)->changed = TRUE;
}

void
goat_insert_calendar(GtkWidget *widget, Goat **goat)
{
  FILE *pipe;
  gchar line[200];
  gint cursor,position;

  /* just pipe the output of 'cal' into the goat, line by line */
   
  pipe = popen("cal", "r");

  while (fgets(line, 200, pipe)) {
    g_assert((*goat)->font != NULL);
    cursor = gtk_editable_get_position(GTK_EDITABLE((*goat)->content)); 
    position = cursor * sizeof(gchar); 

    gtk_editable_insert_text(GTK_EDITABLE((*goat)->content),
                           line,strlen(line),&position);
  }
  pclose(pipe);
  (*goat)->changed = TRUE;
}

void
goat_insert_fortune(GtkWidget *widget, Goat **goat)
{
  FILE *pipe;
  gchar line[200];
  gint cursor,position;

  /* just pipe the output of 'fortune' into the goat, line by line */
   
  pipe = popen("/usr/games/fortune", "r");

  while (fgets(line, 200, pipe)) {
    g_assert((*goat)->font != NULL);
    cursor = gtk_editable_get_position(GTK_EDITABLE((*goat)->content)); 
    position = cursor * sizeof(gchar); 

    gtk_editable_insert_text(GTK_EDITABLE((*goat)->content),
                           line,strlen(line),&position);
  }
  pclose(pipe);
  (*goat)->changed = TRUE;
}

void
goat_change_colour(GtkWidget *widget, Goat **goat)
{
  gint *colour;

  colour = gtk_object_get_data(GTK_OBJECT(widget),"colour");
  (*goat)->colour = *colour;
  goat_recreate(*goat);
}


void
goat_change_font(GtkWidget *widget, Goat **goat)
{
  GtkWidget *font_selection, *dialog;
  GdkFont *newfont;
  gchar *font;
  gint whichbutton;

  font_selection = gtk_font_selection_new();
  gtk_font_selection_set_font_name(GTK_FONT_SELECTION(font_selection),
                                   (*goat)->font_name);
  gtk_widget_show(font_selection);
  dialog = gnome_dialog_new(_("Choose a font"),
                            GNOME_STOCK_BUTTON_OK,
			    GNOME_STOCK_BUTTON_CANCEL,NULL);
  gtk_container_add(GTK_CONTAINER(GNOME_DIALOG(dialog)->vbox),font_selection);
  whichbutton = gnome_dialog_run(GNOME_DIALOG(dialog));
  if (whichbutton == 0) {

      /* ok clicked */

      g_free ((*goat)->font_name); 

      font = gtk_font_selection_get_font_name(GTK_FONT_SELECTION(font_selection));
      newfont = gdk_fontset_load(font);
      if(newfont == NULL) {
        newfont = gdk_font_load(font);
      }
      if (newfont != NULL) {
        gdk_font_unref((*goat)->font);
        (*goat)->font = newfont;
        (*goat)->font_name = font;
        (*goat)->style->font = newfont;
	gdk_font_ref(newfont);
      }
  }
  gnome_dialog_close(GNOME_DIALOG(dialog));
  (*goat)->changed = TRUE;
  goat_recreate(*goat);
}

void
goat_sticky(GtkWidget *widget, Goat **goat)
{
  gboolean sticky;

  if ((*goat) == NULL) return;

  sticky = GTK_CHECK_MENU_ITEM(widget)->active;

  if(!sticky) {
    (*goat)->sticky = FALSE; 
    gnome_win_hints_set_state((*goat)->note,0);
  }
  else {
    (*goat)->sticky = TRUE;
    gnome_win_hints_set_state((*goat)->note,WIN_STATE_STICKY);
  }
}

void
goat_floating(GtkWidget *widget, Goat **goat)
{
  gboolean floating;

  if ((*goat) == NULL) return;

  floating = GTK_CHECK_MENU_ITEM(widget)->active;

  if(!floating) {
    (*goat)->floating = FALSE;
    gnome_win_hints_set_layer((*goat)->note,
                              WIN_LAYER_NORMAL);
  }
  else {
    (*goat)->floating = TRUE;
    gnome_win_hints_set_layer((*goat)->note, 
                              WIN_LAYER_ONTOP);
  }
}

void 
goat_shaded(GtkWidget *widget, Goat **goat)
{
  gboolean shaded;

  if ((*goat) == NULL) return;

  shaded = GTK_CHECK_MENU_ITEM(widget)->active;

  if(!shaded) {
    goat_shade((*goat), FALSE);
  }
  else {
    goat_shade((*goat), TRUE);
  }
}

void
goat_raise(GtkWidget *widget, Goat **goat)
{
  gdk_window_raise((*goat)->note->window);
  (*goat)->lowered = FALSE;
}

void
goat_lower(GtkWidget *widget, Goat **goat)
{
  gdk_window_lower((*goat)->note->window);
  (*goat)->lowered = TRUE;
}

void
goat_hide(GtkWidget *widget, Goat **goat)
{
  gtk_widget_hide((*goat)->note);
  (*goat)->hidden = TRUE;
}

void
goat_delete(GtkWidget *widget, Goat **goat)
{
  GtkWidget *message_box;
  gint return_val;

  if ((*goat)->alarm) {
    message_box = gnome_message_box_new(_("This note has an alarm set!\nAre you sure you want to delete it?"),
                                        GNOME_MESSAGE_BOX_WARNING,
                                        GNOME_STOCK_BUTTON_OK,
                                        GNOME_STOCK_BUTTON_CANCEL,NULL);
    gtk_widget_show(message_box);
    return_val = gnome_dialog_run_and_close(GNOME_DIALOG(message_box));
    switch (return_val) {
      case 0:
             break;
      case 1:
             return;
      default:
             return;
    }
  };

  num_goats--;
  (*goat)->alarm = FALSE;
 
  gtk_style_unref((*goat)->content->style); 
  gtk_style_unref((*goat)->eventbox2->style);
/*   gdk_color_unref((*goat)->fg); */
/*   gdk_color_unref((*goat)->bg); */
  g_free((*goat)->bg_topbar);
  gdk_font_unref((*goat)->font); 

  g_free((*goat)->message);
  g_free((*goat)->sound_filename);
  g_free((*goat)->font_name); 
/*   g_free((*goat)->title);  */
  gtk_widget_destroy((*goat)->note); 
  goat_delete_from_list(*goat);
  g_free(*goat);
}

void goat_send_ipmsg(GtkWidget *widget, Goat **goat)
{
  /* display the dialog that asks for address & subject */

  ipmsg_dialog_create(*goat);
  gnome_dialog_run_and_close(GNOME_DIALOG(ipmsg_dialog));

  return;
}

void
ipmsg_ok_clicked(GtkWidget *widget, Goat *goat)
{
  IPMsgPacket  *msg_packet;
  gint text_len;
  gchar        *text;

  g_log(G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG,
       "Function 'ipmsg_ok_clicke()' in\n");

  msg_packet = g_malloc(sizeof(IPMsgPacket));
  if (! msg_packet)
    return;

  /* hostname */
  msg_packet->hostname = g_strdup_printf("%s", getenv("HOSTNAME"));
  if (! msg_packet->hostname)
    return;

  /* username */
  msg_packet->username = g_strdup_printf("%s", getenv("USER"));
  if (! msg_packet->username)
    return;

  /* addtional part (message body) */
  text_len = gtk_text_get_length(GTK_TEXT(goat->content))-1;
  text = gtk_editable_get_chars(GTK_EDITABLE(goat->content),0,text_len+1);
  msg_packet->additional_part = g_strdup_printf("%s", text);

  /* version number */
  msg_packet->version = 1;

  /* packet number */
  msg_packet->packet_id = time(NULL);

  /* command number */
  msg_packet->command = IPMSG_SENDMSG;

  /* destination address */
  msg_packet->destination_ip = g_strdup_printf("%s", gtk_entry_get_text(GTK_ENTRY(ip_entry)));

  /* send message */
  ipmsg_send_msg(msg_packet);

  g_free(msg_packet->username);
  g_free(msg_packet->hostname);
  g_free(msg_packet->additional_part);
  g_free(msg_packet->destination_ip);
  g_free(msg_packet);
  g_free(text);

  g_log(G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG,
       "Function 'ipmsg_ok_clicke()' out\n");

  return;
}

/*****************************************************
 Functions relating to checking and activating alarms 
******************************************************/

Goat *
goat_check_alarm (Goat *goat)
{
  time_t current_time;
  GtkWidget *message_box;
  gint workspace;
  Goat *next_goat;
         
  workspace = gnome_win_hints_get_current_workspace();
  next_goat = goat->next;

  if(goat->alarm == TRUE) {
    current_time = time(NULL);
    if(goat->alarm_time <= current_time) {
      goat->alarm = FALSE; 
      if(goat->play_sound) {
        goat_play_sound(goat);
      }
      if (goat->alarm_repeat != 0) {
        goat->alarm_time = goat_repeat_alarm(goat->alarm_repeat,goat->alarm_time);
        goat->alarm = TRUE; 
      }
      if(goat->notify_message) {
        message_box = gnome_message_box_new(goat->message, 
                                            GNOME_MESSAGE_BOX_INFO,
                                            GNOME_STOCK_BUTTON_OK, NULL);
        gtk_widget_show(message_box);
        gdk_window_raise(goat->note->window);
      }
      else {
        goat_popup(goat);  
      }
    }
  }
  return next_goat;
}

GTime 
goat_repeat_alarm(gint repeat,GTime thetime)
{
/* I am sure there is a More Beautiful way to do
   this, but isn't there always? */
  GDate *current_date;
  time_t current_time;
  GTime new_time;
  struct tm *breakdown;
  struct tm *new_breakdown;

  new_time = 0;
  new_breakdown = g_malloc(sizeof(struct tm));
  current_date = g_date_new();
  current_time = thetime;

  g_date_set_time(current_date,current_time);  

  breakdown = localtime(&current_time); 
  switch (repeat) {
    case 1:
      g_date_add_days(current_date,1);
      break;
    case 2:
      g_date_add_days(current_date,7);
      break;
    case 3:
      g_date_add_months(current_date,1);
      break;
    case 4:
      g_date_add_years(current_date,1);
      break;
  }
 
  g_date_to_struct_tm(current_date,new_breakdown);

  new_breakdown->tm_sec = breakdown->tm_sec;
  new_breakdown->tm_min = breakdown->tm_min;
  new_breakdown->tm_hour = breakdown->tm_hour; 

  new_time = mktime(new_breakdown);
  g_free(new_breakdown);  
  g_free(current_date); 

  return new_time;
}

void 
goat_popup(Goat *goat)
{
  if(!popup_stay) {
    /* ok, the only way i know to move it to your current 
       desktop is to delete it and recreate it again... i'm
       sure you can move it but nobody seems to want to say 
       how because it's supposed to be the WM's job, but it
       can't always do it's job properly, can it? */
    goat_recreate(goat);
  }
  else {
    /* things are much simpler if you leave it where it is... */
    if (goat->hidden) goat_show(NULL, &goat);
    gdk_window_raise(goat->note->window);
  }  
}

void goat_recreate(Goat *goat)
{
  gchar *text,*title;
  gint length;

    resize_button = FALSE;
    length = gtk_text_get_length(GTK_TEXT(goat->content))-1;
    text = gtk_editable_get_chars(GTK_EDITABLE(goat->content),0,length+1);
    gtk_label_get(GTK_LABEL(goat->title),&title);

    goat_create(goat->x,goat->y, goat->height, goat->width,
                goat->message, goat->alarm, goat->alarm_time,
                goat->notify_message, goat->play_sound,
                goat->sound_filename, text, goat->colour,
                goat->font_name, FALSE, goat->sticky, goat->floating,
                goat->shaded, goat->alarm_repeat, title, FALSE);
    g_free(text); 
    goat->alarm = FALSE;
    goat_delete(NULL, &goat);
}

void
goat_play_sound(Goat *goat)
{
  gnome_sound_play(goat->sound_filename);
}


/**********************************
  Miscellaneous helper functions 
***********************************/

void
goat_show(GtkWidget *widget, Goat **goat)
{
  (*goat)->hidden = FALSE;
  gtk_widget_show_all((*goat)->note);
/*  gtk_widget_hide((*goat)->note);
  gtk_widget_show((*goat)->note); */
  gdk_window_move((*goat)->note->window,(*goat)->x,(*goat)->y);
  gnome_win_hints_set_hints((*goat)->note,
                            WIN_HINTS_SKIP_TASKBAR |
                            WIN_HINTS_SKIP_WINLIST);
  if((*goat)->floating) gnome_win_hints_set_layer((*goat)->note,
                                                  WIN_LAYER_ONTOP);
  else gnome_win_hints_set_layer((*goat)->note, 
                                 WIN_LAYER_NORMAL);
  if(!(*goat)->sticky) gnome_win_hints_set_state((*goat)->note,0);
  else gnome_win_hints_set_state((*goat)->note,WIN_STATE_STICKY); 
}

void
goat_set_size(gint height, gint width, Goat *goat)
{
  if (height<70) height = 70;
  if (width<50) width = 50;

  goat->height = height;
  goat->width = width;

  if (!goat->shaded) 
    gtk_widget_set_usize(goat->content, width,height-20);

  gtk_widget_set_usize(goat->eventbox2, width-40, 20);
  gdk_window_resize(goat->note->window, width,height);
}

void
goat_save(Goat *goat, gchar *section)
{
  gchar *key, *text, *title_text;
  guint length;

  key = g_strdup_printf("%s%s",section,"x");
  gnome_config_set_int(key,goat->x);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"y");
  gnome_config_set_int(key,goat->y);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"height");
  gnome_config_set_int(key,goat->height);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"width");
  gnome_config_set_int(key,goat->width);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"message");
  gnome_config_set_string(key,goat->message);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"alarm");
  gnome_config_set_bool(key,goat->alarm);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"alarm_time");
  gnome_config_set_int(key,goat->alarm_time);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"notify_message");
  gnome_config_set_bool(key,goat->notify_message);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"play_sound");
  gnome_config_set_bool(key,goat->play_sound);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"sound_filename");
  gnome_config_set_string(key,goat->sound_filename);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"colour");
  gnome_config_set_int(key,goat->colour);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"font_name");
  gnome_config_set_string(key,goat->font_name);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"lowered");
  gnome_config_set_bool(key,goat->lowered);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"sticky");
  gnome_config_set_bool(key,goat->sticky);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"floating");
  gnome_config_set_bool(key,goat->floating);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"shaded");
  gnome_config_set_bool(key,goat->shaded);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"alarm_repeat");
  gnome_config_set_int(key,goat->alarm_repeat);
  g_free(key); 
  key = g_strdup_printf("%s%s",section,"hidden");
  gnome_config_set_bool(key,goat->hidden);
  g_free(key); 

  length = gtk_text_get_length(GTK_TEXT(goat->content));
  text = gtk_editable_get_chars(GTK_EDITABLE(goat->content),0,length);

  key = g_strdup_printf("%s%s",section,"text");
  gnome_config_set_string(key,text);
  g_free(key);
  g_free(text);

  gtk_label_get(GTK_LABEL(goat->title), &title_text);
  key = g_strdup_printf("%s%s",section,"title");
  gnome_config_set_string(key,title_text);
  g_free(key);
}

void
goat_delete_from_list(Goat *goat)
{
  goats =  g_list_remove(goats,goat);
}

void
goat_shade(Goat *goat, gboolean shade)
{
  goat->shaded = shade;

  if(shade) {
    gtk_widget_hide(goat->content);
    gdk_window_resize(goat->note->window, goat->width, 20);
  }
  else {
    gtk_widget_show(goat->content);
    gtk_widget_show(goat->note); /* apparently this is sometimes needed */
    goat_set_size(goat->height, goat->width, goat);
  }
}


void
goat_change_title(gchar *new_title, Goat *goat)
{
  if (new_title != NULL) {
    gtk_label_set_text(GTK_LABEL(goat->title),g_strdup_printf("%s",new_title));
  }
  goat->changed = TRUE;
}

void
mail_ok_clicked(GtkWidget *widget, Goat *goat)
{
  gchar *address, *subject, *filename, *format, *command;

  filename = goat_text_to_temp_file(goat);
  if (filename) {
    address = g_strdup_printf("%s",gtk_entry_get_text(GTK_ENTRY(address_entry)));
    subject = g_strdup_printf("%s",gtk_entry_get_text(GTK_ENTRY(subject_entry)));
    
    format = g_strdup_printf("%s%s",mail_command," < %s");
    command = g_strdup_printf(format, subject, address, filename);
    system(command);
    
    unlink(filename);
    g_free(filename);
    g_free(command);
    g_free(format);
    g_free(address);
    g_free(subject);
  }
}

gchar *
goat_text_to_temp_file(Goat *goat)
{
  gchar filename[21],  *text;
  gint fd, length;
  FILE *temp_file;

  g_snprintf(filename, 21, "/usr/tmp/goatsXXXXXX");

  fd = mkstemp(filename);
  if (fd == -1) {
    gnome_error_dialog("Couldn't create temporary file!");
    return NULL;
  }
  else {
    length = gtk_text_get_length(GTK_TEXT(goat->content))-1;
    text = gtk_editable_get_chars(GTK_EDITABLE(goat->content),0,length+1);
    
    temp_file = fdopen(fd,"w");
    if(temp_file == NULL) g_message("couldn't open temp file...");
    if (fputs(text,temp_file) == EOF) g_message("couldn't write to temp file");
    fclose(temp_file);
    close(fd);
    
    g_free(text);

    return g_strdup(filename);
  }
}

void 
mail_dialog_create(Goat *goat)
{
  GtkWidget *table;
  GtkWidget *subject_label, *address_label;
  gchar *subject_text;

  mail_dialog = gnome_dialog_new(_("Mail note..."), GNOME_STOCK_BUTTON_OK, 
                   GNOME_STOCK_BUTTON_CANCEL, NULL);

  table = gtk_table_new(2,2,FALSE);
  gtk_widget_show(table);
  gtk_container_set_border_width (GTK_CONTAINER (table), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5);
  gtk_table_set_col_spacings(GTK_TABLE (table), 5);
  
  address_label = gtk_label_new(_("Mail to..."));
  gtk_widget_show(address_label);
  gtk_table_attach (GTK_TABLE (table), address_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  subject_label = gtk_label_new(_("Subject"));
  gtk_widget_show(subject_label);
  gtk_table_attach (GTK_TABLE (table), subject_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  address_entry = gtk_entry_new();
  gtk_widget_show(address_entry);
  gtk_table_attach (GTK_TABLE (table), address_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  subject_entry = gtk_entry_new();
  gtk_widget_show(subject_entry);
  gtk_label_get(GTK_LABEL(goat->title),&subject_text);
  gtk_entry_set_text(GTK_ENTRY(subject_entry),subject_text);
  gtk_table_attach (GTK_TABLE (table), subject_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(mail_dialog)->vbox), table, 
                     TRUE, TRUE, 0);

  gnome_dialog_button_connect(GNOME_DIALOG(mail_dialog), 0, 
                              GTK_SIGNAL_FUNC(mail_ok_clicked), goat);

}      

void
goat_unshade_note(GtkWidget *widget, Goat **goat)
{
  if ((*goat)->shaded != FALSE) {
    goat_shade(*goat, FALSE);
  }
}

void
goat_shade_note(GtkWidget *widget, Goat **goat)
{
  if ((*goat)->shaded != TRUE) {
    goat_shade(*goat, TRUE);
  }
}

gint goat_pointer_left(GtkWidget *widget, GdkEventCrossing *event,
		       Goat *goat)
{
  if (goat->changed) {
    if (autosave) {
      main_save_session(NULL);
      goat->changed = FALSE;
    }
  }
  return FALSE;
}

gint goat_pointer_enter(GtkWidget *widget, GdkEventProximity *event,
		        Goat *goat)
{
  current_goat = goat;

  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(shaded_item),
                                 goat->shaded);

  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(floating_item),
                                 goat->floating);

  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(sticky_item),
                                 goat->sticky);
  return FALSE;
}

void
ipmsg_dialog_create(Goat *goat)
{
  GtkWidget    *ip_label;
  GtkWidget    *table;

  /* */
  ipmsg_dialog = gnome_dialog_new(_("Send note..."),
                                 GNOME_STOCK_BUTTON_OK,
                                 GNOME_STOCK_BUTTON_CANCEL, NULL);

  /* make table */
  /* ơ֥*/
  table = gtk_table_new(1, 2, FALSE);
  gtk_widget_show(table);
  gtk_container_set_border_width (GTK_CONTAINER (table), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5);
  gtk_table_set_col_spacings(GTK_TABLE (table), 5);

  /* make lavel */
  /* ٥*/
  ip_label = gtk_label_new("IP Address");
  gtk_widget_show(ip_label);
  gtk_table_attach (GTK_TABLE (table), ip_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  /* make text entry */
  /* ƥ*/
  ip_entry = gtk_entry_new();
  gtk_widget_show(ip_entry);
  gtk_table_attach (GTK_TABLE (table), ip_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  /* pack table to virtical box */
  /* ơ֥ľܥå˥ѥå롣*/
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(ipmsg_dialog)->vbox), table,
                     TRUE, TRUE, 0);

  /* connect "OK" button to CB function */
  /* "OK" ܥΥʥCBؿ³롣*/
  gnome_dialog_button_connect(GNOME_DIALOG(ipmsg_dialog), 0,
                              GTK_SIGNAL_FUNC(ipmsg_ok_clicked), goat);

}


void goat_drag_received(GtkWidget *widget, GdkDragContext *context,
                        gint x, gint y, GtkSelectionData *data,
                        guint info, guint time, Goat *goat)
{
  GList *list;
  gchar *filename;

  list = gnome_uri_list_extract_filenames (data->data);
  
  while (list != NULL) {
      filename = g_strdup ((gchar *)list->data);
      goat_insert_file(goat, filename);
      g_free (filename);
      list = list->next;
  }
}

void goat_insert_file(Goat *goat, gchar *filename)
{
  gint cursor, position, size;
  gchar *line;
  FILE *file;
  struct stat info;

  stat(filename, &info);
  size = info.st_size;
  line = (gchar *)g_malloc(size+1);

  file = fopen(filename, "r");
  if (file) {
    while (fgets(line, size, file)) {
      cursor = gtk_editable_get_position(GTK_EDITABLE(goat->content)); 
      position = cursor * sizeof(gchar); 
      
      gtk_editable_insert_text(GTK_EDITABLE(goat->content),
  			     line,strlen(line),&position);
    }
  }
}
