/* menu.c */

#include "main.h"
#include "goat.h"
#include "menu.h"
#include "alarm.h"

extern GtkWidget *menu, *sticky_item, *floating_item, *shaded_item;
extern Goat *current_goat;
extern GdkPixmap *bg_swatch[3];
extern gint one,two,three;

/*******************************
  Function to create popup menu
********************************/

void
popup_menu_create()
{
  /* create popup menu */

  GtkWidget *item, *set_menu, *colour_menu, *insert_menu,
            *text_menu, *properties_menu,
            *colour3, *colour1, *colour2;

  menu = gtk_menu_new();
  item = gtk_menu_item_new_with_label(_("New Goat"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_new),NULL);

  item = gtk_menu_item_new();
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  text_menu = gtk_menu_new();
  gtk_widget_show(text_menu);

  item = gtk_menu_item_new_with_label(_("Fit size"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(text_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_fit_to_text), &current_goat);

  item = gtk_menu_item_new_with_label(_("Print"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(text_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_print_text), &current_goat);

  item = gtk_menu_item_new_with_label(_("Mail"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(text_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_mail_text), &current_goat);

  item = gtk_menu_item_new_with_label("IP Message");

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(text_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                    GTK_SIGNAL_FUNC(goat_send_ipmsg), &current_goat);

  item = gtk_menu_item_new_with_label(_("Clear"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(text_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_clear_text), &current_goat);

  item = gtk_menu_item_new_with_label(_("Text"));

  gtk_widget_show(item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), text_menu);
  gtk_menu_append(GTK_MENU(menu),item);

  set_menu = gtk_menu_new();
  gtk_widget_show(set_menu);
 
  item = gtk_menu_item_new_with_label(_("Title"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(set_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_set_title), &current_goat);

  item = gtk_menu_item_new_with_label(_("Alarm"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(set_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(alarm_set), &current_goat);

  item = gtk_menu_item_new_with_label(_("Set..."));

  gtk_widget_show(item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), set_menu);
  gtk_menu_append(GTK_MENU(menu),item);

  insert_menu =  gtk_menu_new(); 
  gtk_widget_show(insert_menu);

  item = gtk_menu_item_new_with_label(_("Time"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(insert_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_insert_time), &current_goat);

  item = gtk_menu_item_new_with_label(_("Date"));

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(insert_menu), item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_insert_date), &current_goat);

  item = gtk_menu_item_new_with_label(_("Calendar"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(insert_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_insert_calendar), &current_goat);

  item = gtk_menu_item_new_with_label(_("Fortune"));

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(insert_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_insert_fortune), &current_goat);

  item = gtk_menu_item_new_with_label(_("Insert"));

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item),insert_menu);
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  properties_menu = gtk_menu_new();
  gtk_widget_show(properties_menu);

  colour_menu = gtk_menu_new();
  gtk_widget_show(colour_menu);

  item = gtk_menu_item_new();
  colour1 = gtk_pixmap_new(bg_swatch[0],NULL);
  gtk_widget_show(colour1);
  gtk_container_add(GTK_CONTAINER(item),colour1);

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(colour_menu),item);
  gtk_object_set_data(GTK_OBJECT(item),"colour",&one);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_change_colour), &current_goat);

  item = gtk_menu_item_new();
  colour2 = gtk_pixmap_new(bg_swatch[1],NULL);
  gtk_widget_show(colour2);
  gtk_container_add(GTK_CONTAINER(item),colour2);

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(colour_menu),item);
  gtk_object_set_data(GTK_OBJECT(item),"colour",&two);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_change_colour), &current_goat);

  item = gtk_menu_item_new();
  colour3 = gtk_pixmap_new(bg_swatch[2],NULL);
  gtk_widget_show(colour3);
  gtk_container_add(GTK_CONTAINER(item),colour3);

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(colour_menu),item);
  gtk_object_set_data(GTK_OBJECT(item),"colour",&three);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_change_colour), &current_goat);

  item = gtk_menu_item_new_with_label(_("Colour"));
 
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item),colour_menu);
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(properties_menu),item);

  item = gtk_menu_item_new_with_label(_("Font..."));

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(properties_menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_change_font), &current_goat);

  sticky_item = gtk_check_menu_item_new_with_label(_("Sticky"));
  gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(sticky_item),TRUE);
 
  gtk_widget_show(sticky_item);
  gtk_menu_append(GTK_MENU(properties_menu),sticky_item);

  gtk_signal_connect(GTK_OBJECT(sticky_item), "toggled",
                     GTK_SIGNAL_FUNC(goat_sticky), &current_goat);

  floating_item = gtk_check_menu_item_new_with_label(_("Floating"));
  gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(floating_item),TRUE);

  gtk_widget_show(floating_item);
  gtk_menu_append(GTK_MENU(properties_menu),floating_item);

  gtk_signal_connect(GTK_OBJECT(floating_item), "toggled",
                     GTK_SIGNAL_FUNC(goat_floating), &current_goat);

  shaded_item = gtk_check_menu_item_new_with_label(_("Shaded"));
  gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(shaded_item),TRUE);
 
  gtk_widget_show(shaded_item);
  gtk_menu_append(GTK_MENU(properties_menu),shaded_item);

  gtk_signal_connect(GTK_OBJECT(shaded_item), "toggled",
                     GTK_SIGNAL_FUNC(goat_shaded), &current_goat);

  item = gtk_menu_item_new_with_label(_("Properties"));

  gtk_widget_show(item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), properties_menu);
  gtk_menu_append(GTK_MENU(menu),item);

  item = gtk_menu_item_new();
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  item = gtk_menu_item_new_with_label(_("Raise"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_raise), &current_goat);

  item = gtk_menu_item_new_with_label(_("Lower"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_lower), &current_goat);

  item = gtk_menu_item_new();
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  item = gtk_menu_item_new_with_label(_("Hide"));

  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item); 

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_hide), &current_goat);

  item = gtk_menu_item_new_with_label(_("Delete"));
 
  gtk_widget_show(item);
  gtk_menu_append(GTK_MENU(menu),item);

  gtk_signal_connect(GTK_OBJECT(item), "activate",
                     GTK_SIGNAL_FUNC(goat_delete), &current_goat);

  gtk_widget_show(menu);

}
