#include "main.h"
#include "preferences.h"

extern GtkWidget *global_options, *size_options, *colour_options,
          *raise_options, *popup_options, *default_sound_checkbutton,
          *default_sound_entry, *fontpicker, *default_sound_file_select,
          *ampm_toggle, *print_entry, *mail_entry, *autosave_toggle, 
          *default_sticky_checkbutton, *default_floating_checkbutton,
          *sizespin, *delete_options, *default_fg_button,
          *file_selector, *scan_toggle;
extern gint size_default, colour_default;
extern GdkPixmap *bg_swatch[3];
extern GdkColor *default_fg, *default_bg[3];
extern GdkGC *global_gc;
extern gchar *default_font_name, *print_command, *mail_command,
             *default_sound_file;
extern guint8 red_fg,green_fg,blue_fg,red[3],green[3],blue[3];
extern gboolean ampm, delete_button, fall_on_release, popup_stay,
                default_sound, default_sticky, default_floating,
                autosave, scan;

void
preferences_create()
{

  GtkWidget *w, *notebook2, *table4, *glade_menuitem, *colour_options_menu,
            *table5, *table6, *popup_options_menu, *raise_options_menu,
            *delete_options_menu, *options_ok, *colour_customize, *options_cancel;
  GtkObject *sizespin_adj;
  gfloat temp_float;

  global_options = gnome_dialog_new(_("Goats - Preferences"), 
				    NULL);

  gtk_window_set_policy (GTK_WINDOW (global_options), 
			 FALSE, FALSE, FALSE);

  w = GNOME_DIALOG (global_options)->vbox;

  gtk_widget_show (w);
  notebook2 = gtk_notebook_new ();
  gtk_widget_show (notebook2);
  gtk_box_pack_start (GTK_BOX (w), notebook2, TRUE, TRUE, 0);

  table4 = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (table4);
  gtk_container_add (GTK_CONTAINER (notebook2), table4);
  gtk_container_set_border_width (GTK_CONTAINER (table4), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table4), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table4), 5);

  w = gtk_label_new (_("Default size (pixels)"));
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table4), w, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  w = gtk_label_new (_("Default colour"));
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table4), w, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  w = gtk_label_new (_("Default font"));
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table4), w, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  sizespin_adj = gtk_adjustment_new (150, 50, 1000, 10, 10, 10);
  sizespin = gtk_spin_button_new (GTK_ADJUSTMENT (sizespin_adj), 1, 0);
  gtk_table_attach (GTK_TABLE (table4), sizespin, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 5, 5);
  gtk_widget_show (sizespin);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (sizespin), TRUE);
  temp_float = size_default;
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(sizespin),temp_float);

  w = gtk_hbox_new(FALSE,5);
  gtk_widget_show(w);
  gtk_table_attach (GTK_TABLE (table4), w, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  colour_options = gtk_option_menu_new (); 
  gtk_widget_show (colour_options);
  gtk_box_pack_start(GTK_BOX(w), colour_options, TRUE,
                     TRUE, 5);
  colour_customize = gtk_button_new_with_label(_("Customize..."));
  gtk_widget_show(colour_customize);
  gtk_box_pack_start(GTK_BOX(w), colour_customize, TRUE,
                     TRUE, 5);
  
  colour_options_menu = gtk_menu_new ();

  glade_menuitem = gtk_menu_item_new();
  gtk_widget_show (glade_menuitem);
  w = gtk_pixmap_new(bg_swatch[0],NULL);
  gtk_widget_show(w);
  gtk_container_add(GTK_CONTAINER(glade_menuitem),w);
  gtk_menu_append (GTK_MENU (colour_options_menu), glade_menuitem);

  glade_menuitem = gtk_menu_item_new();
  gtk_widget_show (glade_menuitem);
  w = gtk_pixmap_new(bg_swatch[1],NULL);
  gtk_widget_show(w);
  gtk_container_add(GTK_CONTAINER(glade_menuitem),w);
  gtk_menu_append (GTK_MENU (colour_options_menu), glade_menuitem);

  glade_menuitem = gtk_menu_item_new();
  gtk_widget_show (glade_menuitem);
  w = gtk_pixmap_new(bg_swatch[2],NULL);
  gtk_widget_show(w);
  gtk_container_add(GTK_CONTAINER(glade_menuitem),w);
  gtk_menu_append (GTK_MENU (colour_options_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Random"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (colour_options_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (colour_options), colour_options_menu);

  fontpicker = gnome_font_picker_new ();
  gtk_widget_show (fontpicker);
  gtk_table_attach (GTK_TABLE (table4), fontpicker, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gnome_font_picker_set_mode (GNOME_FONT_PICKER (fontpicker), GNOME_FONT_PICKER_MODE_FONT_INFO);
  gnome_font_picker_set_font_name(GNOME_FONT_PICKER(fontpicker),
                                  default_font_name);

  default_sound_checkbutton = gtk_check_button_new_with_label (_("Default alarm sound"));
  gtk_widget_show (default_sound_checkbutton);
  gtk_table_attach (GTK_TABLE (table4), default_sound_checkbutton, 0, 1, 3, 4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  w = gtk_hbox_new(FALSE,0);
  gtk_widget_show(w);
  gtk_table_attach (GTK_TABLE (table4), w, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);

  default_sound_entry = gtk_entry_new();
  gtk_widget_show (default_sound_entry);
  gtk_box_pack_start(GTK_BOX(w), default_sound_entry, TRUE, TRUE, 0);

  default_sound_file_select = gtk_button_new_with_label(_("Select File"));
  gtk_widget_show(default_sound_file_select);
  gtk_box_pack_start(GTK_BOX(w), default_sound_file_select, TRUE, TRUE, 0);

  default_sticky_checkbutton = gtk_check_button_new_with_label (_("Sticky by default"));
  gtk_widget_show (default_sticky_checkbutton);
  gtk_table_attach (GTK_TABLE (table4), default_sticky_checkbutton, 0, 1, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  default_floating_checkbutton = gtk_check_button_new_with_label (_("Floating by default"));
  gtk_widget_show (default_floating_checkbutton);
  gtk_table_attach (GTK_TABLE (table4), default_floating_checkbutton, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);

  default_fg_button = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(default_fg_button), FALSE);
  gnome_color_picker_set_i8(GNOME_COLOR_PICKER(default_fg_button),
                            red_fg,green_fg,blue_fg,255);
  gtk_widget_show(default_fg_button);
  gtk_table_attach (GTK_TABLE (table4), default_fg_button, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);

  w = gtk_label_new (_("Text colour"));
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table4), w, 0, 1, 5, 6,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  w = gtk_label_new (_("Defaults"));
  gtk_widget_show (w);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 0), w);

  table5 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table5);
  gtk_container_add (GTK_CONTAINER (notebook2), table5);
  gtk_container_set_border_width (GTK_CONTAINER (table5), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table5), 5); 

  w = gtk_label_new (_("Raise note..."));
 
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table5), w, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  w = gtk_label_new (_("When popping up note..."));

  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table5), w, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  w = gtk_label_new(_("When setting an alarm..."));
  gtk_widget_show(w);
  gtk_table_attach (GTK_TABLE(table5), w, 0,1,2,3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 15);

  ampm_toggle = gtk_check_button_new_with_label(_("Use 24hr clock"));
  gtk_widget_show(ampm_toggle);
  gtk_table_attach (GTK_TABLE(table5), ampm_toggle, 1,2,2,3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 15);

  w = gtk_label_new(_("Autosave goats..."));
  gtk_widget_show(w);
  gtk_table_attach (GTK_TABLE(table5), w, 0,1,4,5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 15);

  autosave_toggle = gtk_check_button_new_with_label(_("On focus out"));
  gtk_widget_show(autosave_toggle);
  gtk_table_attach (GTK_TABLE(table5), autosave_toggle, 1,2,4,5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 15);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(autosave_toggle),autosave);

  popup_options = gtk_option_menu_new ();

  gtk_widget_show (popup_options);
  gtk_table_attach (GTK_TABLE (table5), popup_options, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (popup_options), 5);
  popup_options_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("Move it to current desktop"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (popup_options_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Leave it where it is"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (popup_options_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (popup_options), popup_options_menu);

  raise_options = gtk_option_menu_new ();

  gtk_widget_show (raise_options);
  gtk_table_attach (GTK_TABLE (table5), raise_options, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (raise_options), 5);
  raise_options_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("When dragbar is clicked"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (raise_options_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Only when button is held"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (raise_options_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (raise_options), raise_options_menu);

  w = gtk_label_new(_("Delete button..."));
  gtk_widget_show(w);
  gtk_table_attach (GTK_TABLE(table5), w, 0,1,3,4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 10);
 
  delete_options = gtk_option_menu_new ();

  gtk_widget_show (delete_options);
  gtk_table_attach (GTK_TABLE (table5), delete_options, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (delete_options), 5);
  delete_options_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("Deletes the note"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (delete_options_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Hides the note"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (delete_options_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (delete_options), delete_options_menu);

  w = gtk_label_new (_("Options"));

  gtk_widget_show (w);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 1), w);

  table6 = gtk_table_new (2, 2, TRUE);
  gtk_widget_show (table6);
  gtk_container_add (GTK_CONTAINER (notebook2), table6);
  gtk_container_set_border_width (GTK_CONTAINER (table6), 20);
  gtk_table_set_row_spacings (GTK_TABLE (table6), 20);

  w = gtk_label_new (_("Print command"));
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table6), w, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  w = gtk_label_new (_("Mail command"));
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table6), w, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  w = gtk_label_new (_("Other programs..."));
  gtk_widget_show (w);
  gtk_table_attach (GTK_TABLE (table6), w, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  print_entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(print_entry),print_command);
  gtk_widget_show (print_entry);
  gtk_table_attach (GTK_TABLE (table6), print_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  mail_entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(mail_entry),mail_command);
  gtk_widget_show (mail_entry);
  gtk_table_attach (GTK_TABLE (table6), mail_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  scan_toggle = gtk_check_button_new_with_label(_("Let other programs create notes"));
  gtk_widget_show(scan_toggle);
  gtk_table_attach (GTK_TABLE(table6), scan_toggle, 1, 2, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 15);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(scan_toggle), scan);

  w = gtk_label_new (_("Helpers"));
  gtk_widget_show (w);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 2), w);

  w = GNOME_DIALOG (global_options)->action_area;

  gtk_widget_show (w);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (w), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (w), 8);

  gnome_dialog_append_button (GNOME_DIALOG (global_options), GNOME_STOCK_BUTTON_OK);
  options_ok = g_list_last (GNOME_DIALOG (global_options)->buttons)->data;

  gtk_widget_show (options_ok);
  GTK_WIDGET_SET_FLAGS (options_ok, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (global_options), GNOME_STOCK_BUTTON_CANCEL);
  options_cancel = g_list_last (GNOME_DIALOG (global_options)->buttons)->data;

  gtk_widget_show (options_cancel);
  GTK_WIDGET_SET_FLAGS (options_cancel, GTK_CAN_DEFAULT);

  /*set the selections on the option menus */

  gtk_option_menu_set_history(GTK_OPTION_MENU(colour_options),colour_default-1);
  if (!delete_button)
    gtk_option_menu_set_history(GTK_OPTION_MENU(delete_options),1);

  if (fall_on_release) {
    gtk_option_menu_set_history(GTK_OPTION_MENU(raise_options),1);
  }
  else {
    gtk_option_menu_set_history(GTK_OPTION_MENU(raise_options),0);
  }

  if (popup_stay) {
    gtk_option_menu_set_history(GTK_OPTION_MENU(popup_options),1);
  }
  else {
    gtk_option_menu_set_history(GTK_OPTION_MENU(popup_options),0);
  }

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(default_sound_checkbutton),
                               default_sound);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(default_sticky_checkbutton),
                               default_sticky);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(default_floating_checkbutton),
                               default_floating);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ampm_toggle),
                               ampm);
  gtk_entry_set_text(GTK_ENTRY(default_sound_entry),default_sound_file);

  preferences_update();

  gtk_signal_connect(GTK_OBJECT(options_cancel),
                     "clicked", GTK_SIGNAL_FUNC(preferences_cancel_clicked),
                     (gpointer) global_options);

  gtk_signal_connect(GTK_OBJECT(colour_customize),
                     "clicked", GTK_SIGNAL_FUNC(preferences_colour_customize_clicked),
                     NULL);

  gtk_signal_connect(GTK_OBJECT(options_ok),
                     "clicked", GTK_SIGNAL_FUNC(preferences_ok_clicked),
                     (gpointer) global_options);

  gtk_signal_connect(GTK_OBJECT(default_sound_checkbutton), "toggled",
                     GTK_SIGNAL_FUNC(preferences_default_sound_toggled), NULL);

  gtk_signal_connect(GTK_OBJECT(default_sound_file_select), "clicked",
                     GTK_SIGNAL_FUNC(preferences_default_sound_select), default_sound_entry);

  gtk_signal_connect(GTK_OBJECT(default_fg_button), "color_set",
                     GTK_SIGNAL_FUNC(preferences_colour_picked), NULL);
}

void 
preferences_update()
{
  default_sound = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(default_sound_checkbutton));

  if(default_sound) {
    gtk_widget_set_sensitive(default_sound_entry,TRUE);
    gtk_widget_set_sensitive(default_sound_file_select,TRUE);
  }
  else {   
    gtk_widget_set_sensitive(default_sound_entry,FALSE);
    gtk_widget_set_sensitive(default_sound_file_select,FALSE);
  }
}

void
preferences_show()
{
  preferences_create();
  gtk_widget_show(global_options);

}

void
preferences_ok_clicked(GtkWidget *widget, GtkWidget *options)
{
  GtkWidget *label;
  GdkPixmap *pixmap;
  GdkBitmap *bitmap;
  gchar *text;
  guint8 alpha;

  /* get the options we selected and set the global variables */

  size_default = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sizespin));

  label = GTK_BIN(colour_options)->child;

  if (GTK_IS_PIXMAP(label)) {
    gtk_pixmap_get(GTK_PIXMAP(label), &pixmap, &bitmap);
   
    if (pixmap == bg_swatch[0]) colour_default = 1;
    else if (pixmap == bg_swatch[1]) colour_default = 2;
    else colour_default = 3;
  }
  else colour_default = 4;

  label = GTK_BIN(raise_options)->child;
  gtk_label_get(GTK_LABEL(label), &text);

  if (strcmp(text,_("When dragbar is clicked")) == FALSE) {
    fall_on_release = FALSE;
  }
  else {
    fall_on_release = TRUE;
  }

  label = GTK_BIN(popup_options)->child;
  gtk_label_get(GTK_LABEL(label), &text);

  if (strcmp(text,_("Leave it where it is")) == FALSE) {
    popup_stay = TRUE;
  }
  else {
    popup_stay = FALSE;
  }

  label = GTK_BIN(delete_options)->child;
  gtk_label_get(GTK_LABEL(label), &text);

  if (strcmp(text,_("Deletes the note")) == FALSE) {
    delete_button = TRUE;
  }
  else {
    delete_button = FALSE;
  }
  main_update_delete_icon();

  default_font_name = g_strdup_printf("%s",gnome_font_picker_get_font_name(GNOME_FONT_PICKER(fontpicker)));

  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(default_sound_checkbutton))) {
    if (default_sound_file) g_free(default_sound_file);
    default_sound_file = g_strdup_printf("%s",
                         gtk_entry_get_text(GTK_ENTRY(default_sound_entry)));
  }

  default_sticky = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(default_sticky_checkbutton));
  default_floating = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(default_floating_checkbutton));
  autosave = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autosave_toggle));
  scan = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(scan_toggle));
  ampm = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ampm_toggle));

  if (mail_command) g_free(mail_command);
  if (print_command) g_free(print_command);

  mail_command = g_strdup_printf("%s",gtk_entry_get_text(GTK_ENTRY(mail_entry)));
  print_command = g_strdup_printf("%s",gtk_entry_get_text(GTK_ENTRY(print_entry)));

  gnome_color_picker_get_i8(GNOME_COLOR_PICKER(default_fg_button),
                              &red_fg,&green_fg,&blue_fg,&alpha);
  preferences_set_default_colours();

  gtk_widget_destroy(global_options);
}

void
preferences_cancel_clicked(GtkWidget *widget, GtkWidget *options)
{
  gtk_widget_destroy(options);
}

void
preferences_default_sound_toggled(GtkWidget *widget)
{
  preferences_update();
}

void
preferences_default_sound_select(GtkWidget *widget, GtkWidget *entry)
{
  gtk_grab_remove(global_options);
  main_create_file_selector(default_sound_entry);
  gtk_grab_add(file_selector);
}

void 
preferences_colour_customize_clicked(GtkWidget *widget)
{
  GtkWidget *dialog, *table, *picker1, *picker2, *picker3,
            *label1, *label2, *label3;
  gint whichbutton;
  guint8 alpha;

  picker1 = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(picker1), FALSE);
  gnome_color_picker_set_i8(GNOME_COLOR_PICKER(picker1),
                            red[0],green[0],blue[0],255);
  gtk_widget_show(picker1);
  label1 = gtk_label_new(_("Colour 1"));
  gtk_widget_show(label1);
  picker2 = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(picker2), FALSE);
  gnome_color_picker_set_i8(GNOME_COLOR_PICKER(picker2),
                            red[1],green[1],blue[1],255);
  gtk_widget_show(picker2);
  label2 = gtk_label_new(_("Colour 2"));
  gtk_widget_show(label2);
  picker3 = gnome_color_picker_new();
  gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(picker3), FALSE);
  gnome_color_picker_set_i8(GNOME_COLOR_PICKER(picker3),
                            red[2],green[2],blue[2],255);
  gtk_widget_show(picker3);
  label3 = gtk_label_new(_("Colour 3"));
  gtk_widget_show(label3);
  
  table = gtk_table_new(3,2,FALSE);
  gtk_widget_show(table);

  gtk_table_attach (GTK_TABLE (table), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_table_attach (GTK_TABLE (table), picker1, 1, 2, 0, 1,
                    (GtkAttachOptions) (1),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_table_attach (GTK_TABLE (table), label2, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_table_attach (GTK_TABLE (table), picker2, 1, 2, 1, 2,
                    (GtkAttachOptions) (1),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_table_attach (GTK_TABLE (table), label3, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_table_attach (GTK_TABLE (table), picker3, 1, 2, 2, 3,
                    (GtkAttachOptions) (1),
                    (GtkAttachOptions) (0), 5, 5);

  gtk_signal_connect(GTK_OBJECT(picker1), "color_set",
                     GTK_SIGNAL_FUNC(preferences_colour_picked), NULL);
  gtk_signal_connect(GTK_OBJECT(picker2), "color_set",
                     GTK_SIGNAL_FUNC(preferences_colour_picked), NULL);
  gtk_signal_connect(GTK_OBJECT(picker3), "color_set",
                     GTK_SIGNAL_FUNC(preferences_colour_picked), NULL);

  dialog = gnome_dialog_new(_("Customize colours"),
                            GNOME_STOCK_BUTTON_OK,
			    GNOME_STOCK_BUTTON_CANCEL,NULL);
  gtk_container_add(GTK_CONTAINER(GNOME_DIALOG(dialog)->vbox),table);

  whichbutton = gnome_dialog_run(GNOME_DIALOG(dialog));
  if (whichbutton == 0) {
    gnome_color_picker_get_i8(GNOME_COLOR_PICKER(picker1),
                              &red[0],&green[0],&blue[0],&alpha);  
    gnome_color_picker_get_i8(GNOME_COLOR_PICKER(picker2),
                              &red[1],&green[1],&blue[1],&alpha);  
    gnome_color_picker_get_i8(GNOME_COLOR_PICKER(picker3),
                              &red[2],&green[2],&blue[2],&alpha);  
    preferences_set_default_colours();
  }
  gnome_dialog_close(GNOME_DIALOG(dialog));
}

void 
preferences_colour_picked(GnomeColorPicker *picker,
              guint red, guint green, guint blue, guint alpha)
{
  gnome_color_picker_set_i16(picker, red, green, blue, alpha); 
}

void 
preferences_set_default_colours()
{
  gint i;
  GdkColor *color;

  for (i=0;i<3;i++) {
    color = default_bg[i];
    g_assert(color != NULL);
    default_bg[i]->red=red[i]*256;
    default_bg[i]->green=green[i]*256;
    default_bg[i]->blue=blue[i]*256;
    gdk_colormap_alloc_color(gdk_colormap_get_system(),
	  		     color,TRUE,TRUE);
    gdk_gc_set_foreground(global_gc,color);
    g_assert(bg_swatch[i] != NULL);
    gdk_draw_rectangle(bg_swatch[i],global_gc,TRUE,0,0,20,20);  
  }
  g_assert(default_fg != NULL);
  default_fg->red=red_fg*256; 
  default_fg->green=green_fg*256;
  default_fg->blue=blue_fg*256; 
  gdk_colormap_alloc_color(gdk_colormap_get_system(),
	  		   default_fg,TRUE,TRUE);
} 
