/* Goats summary.c */
/* The summary box that shows you all your goats &
   lets you change things about them */

#include "summary.h"
#include "main.h"
#include "goat.h"

extern GList *goats;

static GtkWidget *summary=NULL;
static gint summary_delete_cb(GtkWidget *widget, GdkEvent *event);
static void summary_ok_cb(GtkWidget *widget);
static void add_info(void);
static gint summary_button_cb(GtkWidget *widget, 
			      GdkEventButton *event);
static Goat *get_selected_goat(void);
static void delete_cb(Goat *goat,
		      guint action, GtkWidget *widget);
static void cancel_alarm_cb(Goat *goat,
			    guint action, GtkWidget *widget);
static void popup_cb(Goat *goat,
		     guint action, GtkWidget *widget);
static void raise_cb(Goat *goat,
		     guint action, GtkWidget *widget);
static void lower_cb(Goat *goat,
		     guint action, GtkWidget *widget);
static void show_cb(Goat *goat,
		    guint action, GtkWidget *widget);
static void hide_cb(Goat *goat,
		    guint action, GtkWidget *widget);

static GtkItemFactoryEntry menu_items[] = {
  { "/Delete",        NULL, delete_cb,       0, NULL},
  { "/Cancel alarm",  NULL, cancel_alarm_cb, 0, NULL},
  { "/Popup",         NULL, popup_cb,        0, NULL},
  { "/Raise",         NULL, raise_cb,        0, NULL},
  { "/Lower",         NULL, lower_cb,        0, NULL},
  { "/Show",          NULL, show_cb,         0, NULL},
  { "/Hide",          NULL, hide_cb,         0, NULL},
};

#define N_MENU_ITEMS 7

void summary_show()
{
  GtkWidget *window1;
  GtkWidget *vbox1;
  GtkWidget *clist1;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *label4;
  GtkWidget *hseparator1;
  GtkWidget *hbuttonbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *button1;

  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal(GTK_WINDOW(window1), TRUE);
  gtk_window_set_title (GTK_WINDOW (window1), _("List of Goats"));

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window1), vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 10);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  clist1 = gtk_clist_new (4);
  gtk_widget_ref (clist1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "clist1", clist1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 2, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 3, 80);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));
  gtk_widget_set_usize(clist1, 400, 200);

  label1 = gtk_label_new (_("Title"));
  gtk_widget_ref (label1);
   gtk_widget_show (label1);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label1);

  label2 = gtk_label_new (_("Text..."));
  gtk_widget_ref (label2);
  gtk_widget_show (label2);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label2);

  label3 = gtk_label_new (_("Visible?"));
  gtk_widget_ref (label3);
  gtk_widget_show (label3);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 2, label3);

  label4 = gtk_label_new (_("Alarm"));
  gtk_widget_ref (label4);
  gtk_widget_show (label4);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 3, label4);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 5);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbuttonbox1", hbuttonbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, FALSE, TRUE, 5);

  button1 = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button1);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button1);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

  gtk_signal_connect(GTK_OBJECT(button1),
                     "clicked", 
		     GTK_SIGNAL_FUNC(summary_ok_cb),NULL);

  summary = window1;

  gtk_signal_connect(GTK_OBJECT(summary),
                     "delete_event", 
		     GTK_SIGNAL_FUNC(summary_delete_cb),NULL);

  add_info();

  gtk_widget_set_events(clist1, 
			GDK_BUTTON_PRESS_MASK);

  gtk_signal_connect(GTK_OBJECT(clist1),
                     "button_press_event", 
		     GTK_SIGNAL_FUNC(summary_button_cb),NULL);

  gtk_widget_show(summary);
}

gint summary_delete_cb(GtkWidget *widget, GdkEvent *event)
{
  summary = NULL;

  return FALSE;
}

void summary_ok_cb(GtkWidget *widget)
{
  gtk_widget_destroy(summary);
  summary = NULL;
}

void add_info()
{
  GtkCList *clist;
  gchar *text[4];
  gint i;
  gint row;
  Goat *goat;
  GDate *date;
  struct tm *time;

  clist = gtk_object_get_data(GTK_OBJECT(summary),
			      "clist1");
  gtk_clist_clear(clist);

  for (i=0; i<g_list_length(goats); i++) {
    goat = g_list_nth_data(goats, i);
    gtk_label_get(GTK_LABEL(goat->title),
		  &text[0]);
    text[1] = gtk_editable_get_chars(GTK_EDITABLE(goat->content),
				     0,-1);
    if (goat->hidden) text[2] = _("No");
    else text[2] = _("Yes");
    if (goat->alarm) {
      date = g_date_new();
      g_date_set_time(date, goat->alarm_time);
      time = localtime(&goat->alarm_time);
      text[3] = g_strdup_printf(" %02i:%02i   %i/%i/%i",
				time->tm_hour,
				time->tm_min,
				g_date_day(date),
				g_date_month(date),
				g_date_year(date));
    }
    else text[3] = _("Not set");					
    row =  gtk_clist_append(clist, text);
    gtk_clist_set_row_data(clist, row, goat);
  }

}

gint summary_button_cb(GtkWidget *widget, 
		       GdkEventButton *event)
{
  GtkItemFactory *item_factory;
  GtkWidget *menu, *w;
  Goat *goat;
  gchar *wname;

  if(event->button == 3) {
    goat = get_selected_goat();
    if (goat != NULL) {
      item_factory = gtk_item_factory_new(GTK_TYPE_MENU,
					  "<main>",
					  NULL);
      gtk_item_factory_create_items(item_factory,
				    N_MENU_ITEMS,
				    menu_items, goat);
      if (goat->hidden) wname = "/Hide";
      else wname = "/Show";

      w = gtk_item_factory_get_widget(item_factory,wname);
      gtk_widget_set_sensitive(w,FALSE);

      if (!goat->alarm) {
        w = gtk_item_factory_get_widget(item_factory, "/Cancel alarm");
        gtk_widget_set_sensitive(w, FALSE);
      }

      menu = gtk_item_factory_get_widget(item_factory,"<main>");
      gtk_widget_show(menu);
      gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,NULL,
		     event->button, event->time);
    }
  }

  return FALSE;
}

Goat *get_selected_goat()
{
  GtkCList *clist;

  clist = gtk_object_get_data(GTK_OBJECT(summary),
			      "clist1");
  if (g_list_length(clist->selection) == 1) {
    return gtk_clist_get_row_data(clist,
           GPOINTER_TO_INT(g_list_nth_data(clist->selection,0)));
  }
  else return NULL;
}

void delete_cb(Goat *goat,
	       guint action, GtkWidget *widget)
{
  goat_delete(widget, &goat);
  add_info();
}

void cancel_alarm_cb(Goat *goat,
		     guint action, GtkWidget *widget)
{
  goat->alarm = FALSE;
  add_info();
}

void popup_cb(Goat *goat,
	      guint action, GtkWidget *widget)
{
  goat_popup(goat);
  add_info();
}

void raise_cb(Goat *goat,
	      guint action, GtkWidget *widget)
{
  goat_raise(widget, &goat);
}

void lower_cb(Goat *goat,
	      guint action, GtkWidget *widget)
{
  goat_lower(widget, &goat);
}

void show_cb(Goat *goat,
	     guint action, GtkWidget *widget)
{
  goat_show(widget, &goat);
  add_info();
}

void hide_cb(Goat *goat,
	     guint action, GtkWidget *widget)
{
  goat_hide(widget,&goat);
  add_info();
}

