indexing

	description:

		"Eiffel parsers"

	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 1999, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2001/01/01 18:08:54 $"
	revision:   "$Revision: 1.1 $"

class EIFFEL_PARSER

inherit

	YY_PARSER_SKELETON [ANY]
		rename
			make as make_parser_skeleton
		redefine
			report_error
		end

	EIFFEL_SCANNER
		rename
			make as make_eiffel_scanner
		end

	KL_SHARED_EXCEPTIONS
	KL_SHARED_ARGUMENTS

creation

	make, execute, benchmark


feature {NONE} -- Implementation

	yy_build_parser_tables is
			-- Build parser tables.
		do
			yytranslate ?= yytranslate_template
			yyr1 ?= yyr1_template
			yyr2 ?= yyr2_template
			yydefact ?= yydefact_template
			yydefgoto ?= yydefgoto_template
			yypact ?= yypact_template
			yypgoto ?= yypgoto_template
			yytable ?= yytable_template
			yycheck ?= yycheck_template
		end

feature {NONE} -- Semantic actions

	yy_do_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
			inspect yy_act
			else
					-- No action
				yyval := yyval_default
			end
		end

feature {NONE} -- Table templates

	yytranslate_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    0,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,  123,    2,    2,  125,    2,    2,    2,
			  121,  122,  106,  104,  116,  105,  124,  107,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,  115,  114,
			  100,   98,  101,  126,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,  117,    2,  118,  110,    2,    2,    2,    2,    2,

			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,  119,    2,  120,  127,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,

			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
			    2,    2,    2,    2,    2,    2,    1,    2,    3,    4,
			    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
			   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
			   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
			   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,

			   45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
			   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
			   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
			   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
			   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
			   95,   96,   97,   99,  102,  103,  108,  109,  111,  112,
			  113>>)
		end

	yyr1_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    0,  128,  128,  129,  129,  138,  130,  130,  139,  139,
			  139,  140,  140,  140,  140,  142,  142,  143,  143,  145,
			  145,  141,  141,  131,  147,  147,  147,  147,  132,  132,
			  148,  148,  148,  149,  149,  149,  151,  133,  133,  137,
			  153,  153,  153,  153,  153,  153,  154,  154,  154,  154,
			  154,  155,  155,  156,  156,  156,  156,  156,  157,  158,
			  159,  160,  161,  162,  162,  171,  171,  167,  163,  163,
			  173,  173,  173,  174,  174,  174,  175,  177,  177,  178,
			  178,  178,  176,  180,  180,  179,  179,  179,  169,  165,
			  165,  168,  164,  164,  170,  166,  166,  134,  134,  181,

			  181,  182,  182,  152,  152,  152,  135,  135,  183,  183,
			  184,  185,  185,  185,  186,  186,  186,  187,  189,  192,
			  192,  193,  193,  193,  188,  188,  195,  195,  172,  172,
			  172,  196,  196,  196,  196,  197,  197,  197,  197,  197,
			  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
			  197,  197,  197,  190,  190,  198,  198,  198,  199,  199,
			  199,  200,  201,  201,  191,  191,  194,  205,  205,  205,
			  205,  209,  209,  204,  204,  203,  203,  203,  206,  206,
			  206,  136,  136,  210,  210,  210,  211,  211,  211,  212,
			  212,  207,  207,  202,  202,  202,  202,  202,  202,  202,

			  150,  215,  216,  216,  217,  217,  217,  208,  208,  218,
			  218,  219,  219,  219,  219,  219,  219,  219,  219,  219,
			  219,  219,  220,  220,  230,  230,  228,  228,  232,  222,
			  233,  233,  223,  235,  235,  234,  234,  234,  224,  236,
			  236,  236,  237,  237,  237,  238,  238,  239,  239,  239,
			  225,  240,  240,  240,  240,  226,  241,  241,  242,  242,
			  242,  227,  221,  221,  221,  221,  221,  221,  221,  221,
			  221,  221,  243,  243,  231,  231,  244,  244,  244,  245,
			  245,  246,  246,  246,  246,  229,  229,  213,  213,  213,
			  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,

			  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
			  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
			  213,  213,  213,  213,  213,  213,  213,  250,  250,  250,
			  250,  250,  250,  250,  251,  252,  252,  253,  253,  253,
			  254,  254,  254,  249,  249,  249,  248,  248,  248,  146,
			  146,  146,  146,  146,  146,  247,  247,  214,  214,  214,
			  255,  255,  255,  144,  144>>)
		end

	yyr2_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    0,    0,    2,    8,    5,    3,    0,    2,    0,    1,
			    2,    1,    2,    3,    4,    1,    3,    1,    3,    1,
			    1,    1,    2,    3,    0,    1,    1,    1,    0,    3,
			    0,    2,    4,    0,    2,    3,    3,    0,    2,    2,
			    2,    4,    4,    2,    5,    5,    1,    3,    4,    3,
			    4,    0,    1,    1,    1,    1,    1,    1,    6,    5,
			    4,    3,    2,    2,    1,    3,    5,    2,    0,    1,
			    0,    1,    2,    1,    2,    3,    2,    1,    1,    0,
			    1,    3,    3,    0,    1,    0,    1,    3,    2,    0,
			    1,    2,    0,    1,    2,    0,    1,    0,    1,    1,

			    2,    3,    3,    0,    1,    3,    0,    1,    1,    2,
			    3,    0,    1,    2,    1,    2,    3,    2,    3,    0,
			    2,    1,    1,    1,    1,    3,    1,    2,    1,    2,
			    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    0,    3,    0,    1,    2,    1,    2,
			    3,    3,    1,    3,    0,    2,    7,    1,    2,    2,
			    3,    0,    2,    0,    2,    0,    2,    3,    0,    2,
			    3,    0,    2,    0,    1,    2,    1,    2,    3,    1,
			    2,    0,    2,    1,    2,    2,    2,    2,    2,    2,

			    2,    1,    0,    3,    0,    1,    3,    0,    1,    1,
			    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    5,    3,    0,    3,    6,    3,    5,    3,
			    1,    1,    7,    0,    2,    0,    4,    5,    5,    0,
			    4,    5,    0,    1,    3,    1,    3,    1,    1,    1,
			    9,    0,    1,    2,    4,    4,    0,    3,    0,    1,
			    3,    3,    1,    3,    3,    5,    2,    4,    5,    7,
			    5,    7,    2,    4,    0,    3,    0,    1,    3,    1,
			    2,    1,    1,    1,    3,    1,    1,    1,    1,    1,
			    3,    1,    1,    1,    1,    1,    1,    3,    2,    2,

			    2,    2,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    4,
			    4,    3,    2,    4,    1,    1,    3,    2,    2,    2,
			    4,    4,    2,    1,    3,    0,    3,    0,    1,    3,
			    1,    3,    1,    0,    1,    3,    0,    1,    3,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    2,    2,
			    1,    2,    2,    1,    1>>)
		end

	yydefact_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    1,    6,    8,    2,   24,    0,    0,  355,  356,  364,
			  354,  353,  363,  360,  357,  350,    7,    9,   11,   15,
			   19,   17,   20,  351,  349,  352,   27,   26,   25,   28,
			    0,  361,  358,  362,  359,   21,   10,   12,    0,    0,
			   30,   37,    0,   21,    0,   13,   22,   19,   18,   16,
			   33,    0,    0,   97,   23,   14,    0,   31,   29,    0,
			   38,   83,   97,   83,  106,    4,   98,   99,  201,   34,
			  202,   33,   85,   84,  103,  106,    0,   46,   39,   51,
			  103,   83,  181,  107,  108,  100,  103,   35,  204,  200,
			   32,   86,    0,  104,  102,  181,   40,   79,   79,   64,

			   79,   70,   97,   97,   52,   53,   54,   55,   56,   57,
			   68,   92,   89,   95,    0,  101,  111,  183,    0,  109,
			    0,    0,    0,    0,    0,  193,  205,    0,   82,    0,
			    0,    5,    0,    0,  128,   80,   91,   94,   63,    0,
			   88,   67,   71,   73,   79,   97,    0,   49,   97,    0,
			   47,   92,   69,   89,   93,   95,   90,    0,   96,   62,
			    0,  126,  110,  112,  114,  153,  124,    0,    0,    0,
			    0,  346,    0,    0,    0,    0,    0,    0,  274,  288,
			  289,    0,  346,  296,  295,  294,  293,  292,  274,  182,
			  184,  186,  189,  287,  324,  262,  291,  325,  333,    3,

			   36,  195,  196,  197,  194,    0,    0,  199,  198,  203,
			    0,   87,  105,  131,  134,  133,  132,  129,  152,  150,
			  149,  147,  151,  148,  146,  145,  144,  143,  142,  141,
			  140,  139,  138,  137,  136,  135,  130,    0,    0,    0,
			   72,   74,   78,   76,   77,    0,   50,   42,    0,   48,
			   41,   89,   95,    0,   61,  127,  113,  115,  155,    0,
			  117,  164,  335,  332,  274,    0,    0,  347,    0,  322,
			  300,  301,  299,  298,    0,  276,    0,  266,    0,  329,
			    0,  328,  343,    0,  190,  272,  327,  185,  187,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

			    0,    0,    0,    0,    0,    0,    0,    0,  206,   81,
			    0,   65,   75,   45,   44,   95,    0,   60,  116,  162,
			    0,  156,  158,    0,  125,    0,  119,  337,  334,  290,
			    0,  326,    0,    0,    0,  279,    0,  277,    0,    0,
			  274,  263,  264,  344,    0,  297,  188,  302,  307,  309,
			  308,  306,  305,  304,  303,  315,  314,  313,  312,  311,
			  310,    0,  316,  318,    0,  317,  321,  274,    0,    0,
			   59,  154,  157,  159,    0,    0,  165,   37,  118,  342,
			    0,  340,    0,  338,    0,  330,  274,  331,  348,  224,
			    0,  283,  282,  281,  280,  275,    0,  274,  267,  323,

			    0,  319,  320,  273,   66,   58,  160,  163,  161,  122,
			  175,  121,  120,  123,    0,  336,    0,  265,  268,    0,
			  228,    0,  278,  270,  345,  183,  173,  341,  339,    0,
			  274,  284,    0,  183,  176,  155,    0,  269,  225,  271,
			  177,  174,  207,    0,  207,  167,  178,    0,    0,    0,
			  220,    0,  286,    0,  219,    0,    0,  207,  256,  183,
			    0,  285,  169,  208,  209,  211,  212,  213,  214,  215,
			  216,  217,  218,  221,    0,  171,  168,  183,  191,    0,
			    0,    0,    0,  286,  285,  224,  239,    0,  181,  258,
			  207,    0,  224,  210,  231,  230,    0,    0,  170,  183,

			  179,  207,    0,    0,    0,    0,    0,  227,  242,  233,
			  207,  251,  259,    0,    0,  261,  223,  229,  172,  180,
			  192,  166,  224,    0,    0,  248,  247,  249,    0,  243,
			  245,  242,  207,    0,  235,  252,    0,  257,    0,  255,
			  222,  224,    0,  207,    0,    0,  234,  238,    0,  233,
			  274,  253,    0,  260,  226,  244,  240,  246,  207,    0,
			    0,    0,    0,    0,  241,  207,    0,  232,  254,  207,
			  236,  207,    0,  237,  250,    0,    0>>)
		end

	yydefgoto_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    1,    3,    4,   29,   41,   53,   75,   82,  118,   65,
			   76,   16,   17,   36,   18,   19,  264,   21,   22,   30,
			   51,   57,  125,   87,   94,   78,   79,  103,  104,  105,
			  106,  107,  108,  109,  110,  151,  153,  155,  157,  111,
			  154,  156,  158,  138,  135,  141,  142,  143,   73,  243,
			  136,   92,   74,   66,   67,   83,   84,  162,  163,  164,
			  165,  260,  261,  326,  378,  412,  413,  166,  217,  236,
			  320,  321,  322,  323,  126,  426,  436,  446,  478,  502,
			  462,  498,  189,  190,  191,  192,   23,   70,   89,  127,
			  463,  464,  465,  193,  467,  468,  469,  470,  471,  472,

			  473,  474,  420,  285,  194,  496,  549,  533,  509,  528,
			  529,  530,  536,  490,  513,  195,  336,  381,  394,  196,
			  268,  344,  197,  198,  328,  382,  383,   25>>)
		end

	yypact_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			 -32768,   65,  461, -32768,  225,  370,  358, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768, -32768, -32768, -32768,  887, -32768,  376,
			  392, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768,  388,
			  482, -32768, -32768, -32768, -32768,  476,  386, -32768,  461,  461,
			  123,  448,  123, -32768,  306, -32768, -32768, -32768, -32768,  376,
			  475,  238,  484,  179, -32768, -32768,  457, -32768, -32768,  123,
			 -32768,  319,   26,  319,  440, -32768,   36, -32768, -32768,  419,
			  372,  475,  123, -32768,  123,  440,  450, -32768, -32768,  318,
			  123,  319,  308,  440, -32768, -32768,  123, -32768,  174, -32768,
			 -32768, -32768,   90, -32768,  355,  308, -32768,  268,  268,  268,

			  268,  319,  321,   68, -32768, -32768, -32768, -32768, -32768, -32768,
			  446,  394,  379,  361,  445,  355,  222, 1001,  444, -32768,
			   -9,  457,  147,  457,   45, -32768, -32768,  218, -32768,  123,
			  123, -32768,  175, 1322, -32768, -32768,  320,  320,  346,  441,
			  320, -32768,   76, -32768,  199,   26,  431, -32768,   26,  428,
			 -32768,  394, -32768,  379, -32768,  361, -32768,  413, -32768, -32768,
			  268, -32768, -32768,    7, -32768,  -54, -32768,  268,  267, 1001,
			  174, 1001, 1001, 1001, 1001, 1001, 1001,  325,  212,  155,
			  138,  322, 1001, -32768, -32768, -32768, -32768, -32768,  201, -32768,
			  918, -32768, 1285, -32768, -32768,  257, -32768, -32768, -32768, -32768,

			 -32768, -32768, -32768, -32768, -32768,  435,  433, -32768, -32768, -32768,
			  174, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768, -32768, -32768, -32768,  268,  268,  268,
			  319, -32768, -32768, -32768,  320,  406, -32768, -32768,  404, -32768,
			 -32768,  379,  361,  400, -32768, -32768,  222, -32768,  123,  222,
			 -32768,  310,  305, -32768,  143, 1256,  304, 1285,  207, -32768,
			 -32768, -32768, -32768, -32768,  174,  720,  174,  298,  123, -32768,
			  123, -32768,  123,   -4, -32768, -32768, -32768, 1001, -32768, 1001,
			 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,

			 1001, 1001, 1001,  876, 1001,  845, 1001,  123, -32768, -32768,
			  399, -32768, -32768, -32768, -32768,  361,  387, -32768, -32768, -32768,
			  290,   11, -32768,  168, -32768,  174,  371,  701, -32768,  118,
			  -14, -32768, 1001,  289,   22, 1285,  144, -32768,  287,  123,
			  265,  257,  257, -32768,  111, -32768, -32768, -32768,  -19,  -19,
			  -19,  -19,  -19,  416,  416,  295,  295,  295,  295,  295,
			  295, 1001, 1334,  692, 1001,  692, 1320,  265,  268,  369,
			 -32768, -32768,  123, -32768,  123,  174, -32768,  443, -32768,  267,
			  174, -32768,    2, -32768,  123, -32768,  265, -32768, 1285,  -49,
			 1001, -32768, -32768, -32768, -32768, -32768,  720,  265,  257, -32768,

			  123, 1334,  692, -32768, -32768, -32768, -32768, -32768, -32768, -32768,
			  340, -32768, -32768, -32768,  271, -32768,  701,  257,  266,  123,
			 -32768, 1227, -32768,  264, -32768,  635,  339,  -14, -32768,  123,
			  265, -32768,  123, 1001, -32768,  123,  323,  257, -32768,  257,
			 -32768, -32768,  959,  373,  959, -32768,  350,  174, 1001,  174,
			 -32768,   15,   62,  252, -32768, 1001, 1001,  959,  246, 1001,
			   80, 1115, -32768,  959, -32768, -32768, -32768, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768,  237,  343, -32768,  569,  311,  234,
			 1198,  233,  174, -32768, -32768,  -49, 1180, 1162,  308,  337,
			  959,  312,  -49, -32768, -32768, -32768, 1001,  331, -32768, 1001,

			 -32768,  959,  307,   80,  180,  263,  112, -32768,   73,   29,
			  959,  140, -32768,  -17,  196, -32768, -32768, 1285, -32768, -32768,
			 -32768, -32768,  -49,   80,   62, -32768, -32768, -32768,  -31, -32768,
			  150,   73,  959,  124,  114, 1001,   57, -32768,   95, -32768,
			 -32768,  -49,   73,  959,   73,  -36, -32768, -32768, 1001,  187,
			  148, 1285, 1001, -32768, -32768, -32768, -32768, -32768,  959, 1108,
			 1001,   38, 1001,  990, -32768,  959, 1090, -32768, 1285,  959,
			 -32768,  959,   24, -32768, -32768,   35, -32768>>)
		end

	yypgoto_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			 -32768, -32768, -32768, -32768, -32768,  183,  505,  479,  -93, -32768,
			   96, -32768, -32768,  517,  176,  514,   -2,  513,  173, -32768,
			 -32768,  472,  568, -32768,  240, -32768, -32768, -32768, -32768, -32768,
			 -32768, -32768, -32768, -32768, -32768, -32768,  395, -114, -151,  426,
			  460,  459,  458, -32768,  -16, -32768, -32768, -124,  -95, -32768,
			  102, -32768,  128, -32768,  465, -32768,  451, -32768, -32768, -133,
			 -32768, -32768, -32768, -32768, -32768, -32768, -32768,  269, -32768, -32768,
			   84, -32768, -309, -32768, -141, -32768, -32768, -32768, -32768, -32768,
			 -384, -32768, -270, -32768, -179,   -3, -123, -32768, -32768, -32768,
			 -32768,   55, -32768,   54, -32768, -32768, -32768, -32768, -32768, -32768,

			 -32768, -392, -325, -171, -32768, -32768, -32768,  -34, -32768,  -15,
			  -29,  -30, -32768, -32768, -32768, -275, -32768, -266, -32768,    6,
			  330, -32768, -32768, -154, -32768, -32768,   94, -32768>>)
		end

	yytable_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			   20,  208,  131,  341,  253,  342,  144,  277,   24,  337,
			  345,  288,  373,   12,  263,   20,    9,   12,  241,  200,
			    9,   12,  558,   24,    9,  279,  281,  543,   12,  266,
			  257,    9,   68,   20,  286,  576,   47,   47,   50,  252,
			   54,   24,   20,  160,   24,   24,  133,  144,   63,   14,
			   24,   12,  574,  386,    9,  532,  132,   71,   63,  485,
			  476,  133,  259,  406,  398,  575,  567,  258,  492,  308,
			   91,  132,   93,  488,   68,  419,  525,   14,   93,   12,
			  542,  483,    9,  139,   93,  542,   12,  392,  391,    9,
			   63,  290,  289,  531,   61,  134,  134,  134,  134,  538,

			  161,  316,  553,    2,   61,  537,  514,  130,  346,  417,
			  286,  522,  332,  167,  134,  188,  312,  520,  416,  552,
			  203,  256,  207,  318,  415,  372,  534,  211,  212,   12,
			  422,  541,    9,  333,  482,  338,   61,  315,  453,  524,
			  178,  548,  134,  390,  255,  144,  483,  161,  546,  206,
			  205,  262,  547,   12,  437,  434,    9,  439,  134,  556,
			  507,  134,  544,  440,  369,  134,  265,  516,  267,  269,
			  270,  271,  272,  273,  564,  385,  387,  206,  205,  267,
			   68,  570,  148,  124,  376,  572,  278,  573,  188,  491,
			  240,   80,  449,   37,  448,   72,  403,  540,  146,  149,

			  137,   63,  140,  535,  123,   12,  129,  500,    9,  116,
			  128,   45,  202,  532,  560,  418,  554,  242,  122,   62,
			   55,  309,  310,  311,  539,  263,  423,  400,   12,  519,
			  121,    9,  523,  399,  408,  134,  134,  134,  133,  414,
			  161,  245,  384,  161,  248,  167,  244,   61,  132,   28,
			  216,  215,  495,  494,  134,   27,  319,  134,  160,  438,
			  396,  133,  280,  562,  275,  167,  395,  214,  213,  275,
			  167,  132,  335,  387,   12,  167,  340,    9,  340,  278,
			  343,   26,  167,  375,  374,  188,  347,  348,  349,  350,
			  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,

			  362,  363,  365,  366,  384,  367,  479,  133,  481,   15,
			   14,   13,   12,   11,   10,    9,  284,  132,  393,  319,
			  115,  -43,  275,  332,  335,  331,  120,   68,  167,  388,
			  386,  276,  134,  275,  210,  521,  209,  340,  518,    8,
			  515,  506,  -43,   63,  512,  -43,  102,  445,  444,  101,
			  117,  -43,  404,  505,   59,  443,   58,  503,  401,  -43,
			  497,  402,   34,   33,  501,    7,  134,  489,  100,   99,
			  319,  442,  407,   98,   32,   31,  280,  -43,   97,  477,
			  475,  307,  340,   24,  435,  526,  275,  421,  432,   61,
			  429,  427,  425,  335,  167,  511,  286,  405,  424,  296,

			  295,  294,  293,  292,  291,  290,  289,  397,  526,  389,
			    6,    5,  371,  335,  377,  370,   98,  430,  368,  526,
			   46,  526,  339,  188,  330,  325,  327,  340,  317,  100,
			  340,  188,  314,  319,  313,  145,  237,   34,   72,   32,
			  461,  254,  461,  282,  274,  480,   15,   14,   13,  484,
			   11,   10,  486,  487,   97,  461,  250,  188,  484,  247,
			  239,  461,  238,   68,   15,   14,   13,   12,   11,   10,
			    9,  130,  199,  159,   81,  188,    8,  101,   96,   15,
			   14,   13,   12,   11,   10,    9,   56,   86,  461,   88,
			   52,   60,   38,  517,    8,   52,  466,  188,  466,  461,

			   46,  484,    7,   42,  409,   40,  340,   39,  461,    8,
			  428,  466,  283,  555,  557,  561,  545,  466,  493,  441,
			    7,  484,  294,  293,  292,  291,  290,  289,  324,  340,
			  461,   85,  551,  550,  119,    7,  152,  114,  113,  112,
			  340,  461,  340,   90,  466,  559,  251,    6,    5,  563,
			  411,   48,   44,   49,   95,  466,  461,  566,   64,  568,
			  410,    0,  527,  461,  466,    6,    5,  461,    0,  461,
			    0,    0,  187,  186,  185,   12,  184,  183,    9,    0,
			    6,    5,  182,    0,    0,  527,  466,    0,    0,    0,
			   43,    0,    0,    0,    0,    0,  527,  466,  527,    0,

			    0,    0,    8,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,  466,    0,    0,    0,    0,    0,    0,  466,
			    0,    0,    0,  466,   69,  466,  181,  499,    7,    0,
			   77,    0,    0,    0,  180,  179,  178,  177,  187,  186,
			  185,   12,  184,  183,    9,    0,    0,    0,  182,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,  433,    0,    0,    0,    0,    0,    0,    8,    0,
			  147,  150,    0,  176,  175,    0,    0,    0,    0,    0,
			  174,  173,  172,    0,    0,    0,  171,    0,  170,  201,
			  169,  204,  181,    0,    7,  168,  167,    0,    0,    0,

			  180,  179,  178,  177,  187,  186,  185,   12,  184,  183,
			    9,    0,    0,  246,  182,    0,  249,    0,    0,    0,
			    0,    0,    0,  187,  186,  185,   12,  184,  183,    9,
			    0,    0,    0,  182,    8,    0,    0,    0,    0,  176,
			  175,    0,    0,    0,    0,    0,  174,  173,  172,    0,
			    0,    0,  171,    8,  170,    0,  169,    0,  181,    0,
			    7,  168,  167,    0,    0,    0,  180,  179,  178,  177,
			    0,    0,    0,    0,    0,    0,    0,  181,    0,    7,
			    0,    0,    0,    0,    0,  180,  179,  178,  177,  303,
			  302,  301,  300,  299,  298,  297,  296,  295,  294,  293,

			  292,  291,  290,  289,    0,  176,  175,    0,    0,    0,
			    0,    0,  174,  173,  172,    0,    0,    0,  171,    0,
			  380,    0,  169,    0,  176,  175,  334,  379,  167,    0,
			    0,  174,  173,  172,    0,    0,    0,  171,    0,  170,
			    0,  169,    0,    0,    0,  334,  168,  167,  187,  186,
			  185,   12,  184,  183,    9,    0,    0,    0,  182,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,  364,    0,    0,    0,    0,    0,    0,    8,  187,
			  186,  185,   12,  184,  183,    9,    0,    0,    0,  182,
			   15,   14,   13,   12,   11,   10,    9,    0,    0,    0,

			    0,    0,  181,    0,    7,    0,    0,    0,    0,    8,
			  180,  179,  178,  177,    0,    0,    0,    0,    0,    0,
			    8,  187,  186,  185,   12,  184,  183,    9,    0,    0,
			    0,  182,    0,  181,  361,    7,    0,    0,    0,    0,
			    0,  180,  179,  178,  177,    0,    7,    0,    0,  176,
			  175,    8,    0,    0,    0,    0,  174,  173,  172,    0,
			    0,    0,  171,    0,  170,   12,  169,    0,    9,  460,
			    0,  168,  167,    0,    0,  181,    0,    7,    0,  459,
			  176,  175,  458,  180,  179,  178,  177,  174,  173,  172,
			    0,    6,    5,  171,  457,  170,  456,  169,    0,    0,

			  455,   35,  168,  167,  187,  186,  185,   12,  184,  183,
			    9,    0,    0,  454,  182,    0,    0,    0,    0,    0,
			    0,    0,  176,  175,  453,  452,  178,  451,    0,  174,
			  173,  172,  287,    0,    8,  171,  569,  170,    0,  169,
			    0,    0,    0,    0,  168,  167,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,  181,    0,
			    7,    0,    0,    0,    0,    0,  180,  179,  178,  177,
			    0,    0,    0,  450,    0,    0,    0,    0,  449,    0,
			  448,    0,  447,    0,  306,  305,  304,  303,  302,  301,
			  300,  299,  298,  297,  296,  295,  294,  293,  292,  291,

			  290,  289,    0,    0,    0,  176,  175,    0,    0,    0,
			    0,    0,  174,  173,  172,    0,    0,    0,  171,    0,
			  170, -274,  169,    0, -274, -274,    0,  168,  167,    0,
			    0,    0,    0,    0,    0, -274,    0,    0, -274,    0,
			    0, -274, -274, -274, -274,    0,    0,    0,  571,    0,
			 -274,    0, -274,    0,    0,    0, -274, -274,    0,    0,
			    0,    0,    0,    0,    0,    0,  565,    0, -274, -274,
			    0,    0,    0,    0,    0,    0,    0, -274, -274, -274,
			 -274, -274, -274, -274,  306,  305,  304,  303,  302,  301,
			  300,  299,  298,  297,  296,  295,  294,  293,  292,  291,

			  290,  289,  306,  305,  304,  303,  302,  301,  300,  299,
			  298,  297,  296,  295,  294,  293,  292,  291,  290,  289,
			  510,    0,    0,    0,    0,    0,    0,    0,    0, -274,
			    0,    0,    0,    0, -274,    0,  275,    0, -274, -274,
			    0,    0,    0,    0,  508,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,  306,  305,  304,  303,
			  302,  301,  300,  299,  298,  297,  296,  295,  294,  293,
			  292,  291,  290,  289,  306,  305,  304,  303,  302,  301,
			  300,  299,  298,  297,  296,  295,  294,  293,  292,  291,
			  290,  289,  306,  305,  304,  303,  302,  301,  300,  299,

			  298,  297,  296,  295,  294,  293,  292,  291,  290,  289,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			  504,  306,  305,  304,  303,  302,  301,  300,  299,  298,
			  297,  296,  295,  294,  293,  292,  291,  290,  289,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,  431,
			  306,  305,  304,  303,  302,  301,  300,  299,  298,  297,
			  296,  295,  294,  293,  292,  291,  290,  289,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,  329,  306,
			  305,  304,  303,  302,  301,  300,  299,  298,  297,  296,
			  295,  294,  293,  292,  291,  290,  289,  235,  234,  233,

			  232,  231,  230,  229,  228,  227,  226,  225,  224,  223,
			  222,  221,  220,  219,  218,  305,  304,  303,  302,  301,
			  300,  299,  298,  297,  296,  295,  294,  293,  292,  291,
			  290,  289,  302,  301,  300,  299,  298,  297,  296,  295,
			  294,  293,  292,  291,  290,  289>>)
		end

	yycheck_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yyfixed_array (<<
			    2,  124,   95,  278,  155,  280,  101,  178,    2,  275,
			   14,  190,  321,    6,  168,   17,    9,    6,  142,   28,
			    9,    6,   58,   17,    9,  179,  180,   58,    6,  170,
			  163,    9,    6,   35,  188,    0,   38,   39,   40,  153,
			   42,   35,   44,   36,   38,   39,   39,  142,   22,    4,
			   44,    6,   28,   67,    9,   26,   49,   59,   22,  451,
			  444,   39,  116,  372,  339,    0,   28,  121,  460,  210,
			   72,   49,   74,  457,    6,  124,    3,    4,   80,    6,
			  116,   66,    9,   99,   86,  116,    6,   65,   66,    9,
			   22,  110,  111,   64,   68,   97,   98,   99,  100,  116,

			  116,  252,    7,   38,   68,  122,  490,  116,  287,  384,
			  264,  503,  116,  127,  116,  117,  240,  501,  116,   62,
			  122,  114,  124,  256,  122,  114,  510,  129,  130,    6,
			  396,  523,    9,  274,  119,  276,   68,  251,   65,   66,
			   67,   27,  144,  121,  160,  240,   66,  163,  532,  104,
			  105,  167,   28,    6,  429,  425,    9,  432,  160,  543,
			  485,  163,   12,  433,  315,  167,  169,  492,  171,  172,
			  173,  174,  175,  176,  558,  329,  330,  104,  105,  182,
			    6,  565,  114,    9,  325,  569,  124,  571,  190,  459,
			  114,   63,  119,   17,  121,  119,  367,  522,  102,  103,

			   98,   22,  100,   63,   30,    6,  116,  477,    9,   81,
			  120,   35,   65,   26,   27,  386,  541,   18,   44,   40,
			   44,  237,  238,  239,   28,  379,  397,  116,    6,  499,
			   56,    9,  120,  122,  375,  237,  238,  239,   39,  380,
			  256,  145,  124,  259,  148,  127,  144,   68,   49,   24,
			   75,   76,   15,   16,  256,   30,  258,  259,   36,  430,
			  116,   39,  124,  115,  121,  127,  122,   92,   93,  121,
			  127,   49,  275,  427,    6,  127,  278,    9,  280,  124,
			  282,   56,  127,  115,  116,  287,  289,  290,  291,  292,
			  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,

			  303,  304,  305,  306,  124,  307,  447,   39,  449,    3,
			    4,    5,    6,    7,    8,    9,  115,   49,  334,  321,
			   80,    0,  121,  116,  327,  118,   86,    6,  127,  332,
			   67,  119,  334,  121,  116,   28,  118,  339,    7,   33,
			   28,  482,   21,   22,    7,   24,   28,   24,   25,   31,
			   42,   30,  368,  120,  116,   32,  118,  123,  361,   38,
			   17,  364,    4,    5,   53,   59,  368,  121,   50,   51,
			  372,   48,  374,   55,    4,    5,  124,   56,   60,   29,
			    7,  124,  384,  377,   45,  508,  121,  390,  124,   68,
			  124,  120,   52,  396,  127,  488,  550,   28,  400,  104,

			  105,  106,  107,  108,  109,  110,  111,  120,  531,  120,
			  104,  105,  122,  416,   43,   28,   55,  419,   19,  542,
			  114,  544,  124,  425,  120,  115,  121,  429,   28,   50,
			  432,  433,   28,  435,   28,  114,  116,    4,  119,    4,
			  442,   28,  444,  121,  119,  448,    3,    4,    5,  451,
			    7,    8,  455,  456,   60,  457,   28,  459,  460,   28,
			   19,  463,  116,    6,    3,    4,    5,    6,    7,    8,
			    9,  116,   28,   28,   34,  477,   33,   31,   28,    3,
			    4,    5,    6,    7,    8,    9,   11,   68,  490,  117,
			   47,    7,  116,  496,   33,   47,  442,  499,  444,  501,

			  114,  503,   59,   21,   61,  117,  508,  115,  510,   33,
			  416,  457,  182,  542,  544,  549,  531,  463,  463,  435,
			   59,  523,  106,  107,  108,  109,  110,  111,  259,  531,
			  532,   66,  535,  535,   83,   59,  110,   79,   79,   79,
			  542,  543,  544,   71,  490,  548,  151,  104,  105,  552,
			  377,   38,   35,   39,   75,  501,  558,  560,   53,  562,
			  377,   -1,  508,  565,  510,  104,  105,  569,   -1,  571,
			   -1,   -1,    3,    4,    5,    6,    7,    8,    9,   -1,
			  104,  105,   13,   -1,   -1,  531,  532,   -1,   -1,   -1,
			  114,   -1,   -1,   -1,   -1,   -1,  542,  543,  544,   -1,

			   -1,   -1,   33,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
			   -1,   -1,  558,   -1,   -1,   -1,   -1,   -1,   -1,  565,
			   -1,   -1,   -1,  569,   56,  571,   57,   58,   59,   -1,
			   62,   -1,   -1,   -1,   65,   66,   67,   68,    3,    4,
			    5,    6,    7,    8,    9,   -1,   -1,   -1,   13,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
			   -1,   26,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,
			  102,  103,   -1,  104,  105,   -1,   -1,   -1,   -1,   -1,
			  111,  112,  113,   -1,   -1,   -1,  117,   -1,  119,  121,
			  121,  123,   57,   -1,   59,  126,  127,   -1,   -1,   -1,

			   65,   66,   67,   68,    3,    4,    5,    6,    7,    8,
			    9,   -1,   -1,  145,   13,   -1,  148,   -1,   -1,   -1,
			   -1,   -1,   -1,    3,    4,    5,    6,    7,    8,    9,
			   -1,   -1,   -1,   13,   33,   -1,   -1,   -1,   -1,  104,
			  105,   -1,   -1,   -1,   -1,   -1,  111,  112,  113,   -1,
			   -1,   -1,  117,   33,  119,   -1,  121,   -1,   57,   -1,
			   59,  126,  127,   -1,   -1,   -1,   65,   66,   67,   68,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   57,   -1,   59,
			   -1,   -1,   -1,   -1,   -1,   65,   66,   67,   68,   97,
			   98,   99,  100,  101,  102,  103,  104,  105,  106,  107,

			  108,  109,  110,  111,   -1,  104,  105,   -1,   -1,   -1,
			   -1,   -1,  111,  112,  113,   -1,   -1,   -1,  117,   -1,
			  119,   -1,  121,   -1,  104,  105,  125,  126,  127,   -1,
			   -1,  111,  112,  113,   -1,   -1,   -1,  117,   -1,  119,
			   -1,  121,   -1,   -1,   -1,  125,  126,  127,    3,    4,
			    5,    6,    7,    8,    9,   -1,   -1,   -1,   13,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
			   -1,   26,   -1,   -1,   -1,   -1,   -1,   -1,   33,    3,
			    4,    5,    6,    7,    8,    9,   -1,   -1,   -1,   13,
			    3,    4,    5,    6,    7,    8,    9,   -1,   -1,   -1,

			   -1,   -1,   57,   -1,   59,   -1,   -1,   -1,   -1,   33,
			   65,   66,   67,   68,   -1,   -1,   -1,   -1,   -1,   -1,
			   33,    3,    4,    5,    6,    7,    8,    9,   -1,   -1,
			   -1,   13,   -1,   57,   58,   59,   -1,   -1,   -1,   -1,
			   -1,   65,   66,   67,   68,   -1,   59,   -1,   -1,  104,
			  105,   33,   -1,   -1,   -1,   -1,  111,  112,  113,   -1,
			   -1,   -1,  117,   -1,  119,    6,  121,   -1,    9,   10,
			   -1,  126,  127,   -1,   -1,   57,   -1,   59,   -1,   20,
			  104,  105,   23,   65,   66,   67,   68,  111,  112,  113,
			   -1,  104,  105,  117,   35,  119,   37,  121,   -1,   -1,

			   41,  114,  126,  127,    3,    4,    5,    6,    7,    8,
			    9,   -1,   -1,   54,   13,   -1,   -1,   -1,   -1,   -1,
			   -1,   -1,  104,  105,   65,   66,   67,   68,   -1,  111,
			  112,  113,  114,   -1,   33,  117,   46,  119,   -1,  121,
			   -1,   -1,   -1,   -1,  126,  127,   -1,   -1,   -1,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   57,   -1,
			   59,   -1,   -1,   -1,   -1,   -1,   65,   66,   67,   68,
			   -1,   -1,   -1,  114,   -1,   -1,   -1,   -1,  119,   -1,
			  121,   -1,  123,   -1,   94,   95,   96,   97,   98,   99,
			  100,  101,  102,  103,  104,  105,  106,  107,  108,  109,

			  110,  111,   -1,   -1,   -1,  104,  105,   -1,   -1,   -1,
			   -1,   -1,  111,  112,  113,   -1,   -1,   -1,  117,   -1,
			  119,    6,  121,   -1,    9,   10,   -1,  126,  127,   -1,
			   -1,   -1,   -1,   -1,   -1,   20,   -1,   -1,   23,   -1,
			   -1,   26,   27,   28,   29,   -1,   -1,   -1,   58,   -1,
			   35,   -1,   37,   -1,   -1,   -1,   41,   42,   -1,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   58,   -1,   53,   54,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   62,   63,   64,
			   65,   66,   67,   68,   94,   95,   96,   97,   98,   99,
			  100,  101,  102,  103,  104,  105,  106,  107,  108,  109,

			  110,  111,   94,   95,   96,   97,   98,   99,  100,  101,
			  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
			   58,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  114,
			   -1,   -1,   -1,   -1,  119,   -1,  121,   -1,  123,  124,
			   -1,   -1,   -1,   -1,   64,   -1,   -1,   -1,   -1,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   94,   95,   96,   97,
			   98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
			  108,  109,  110,  111,   94,   95,   96,   97,   98,   99,
			  100,  101,  102,  103,  104,  105,  106,  107,  108,  109,
			  110,  111,   94,   95,   96,   97,   98,   99,  100,  101,

			  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
			  122,   94,   95,   96,   97,   98,   99,  100,  101,  102,
			  103,  104,  105,  106,  107,  108,  109,  110,  111,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  122,
			   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
			  104,  105,  106,  107,  108,  109,  110,  111,   -1,   -1,
			   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  122,   94,
			   95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
			  105,  106,  107,  108,  109,  110,  111,   75,   76,   77,

			   78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
			   88,   89,   90,   91,   92,   95,   96,   97,   98,   99,
			  100,  101,  102,  103,  104,  105,  106,  107,  108,  109,
			  110,  111,   98,   99,  100,  101,  102,  103,  104,  105,
			  106,  107,  108,  109,  110,  111>>)
		end

feature {NONE} -- Constants

	yyFinal: INTEGER is 576
			-- Termination state id

	yyFlag: INTEGER is -32768
			-- Most negative INTEGER

	yyNtbase: INTEGER is 128
			-- Number of tokens

	yyLast: INTEGER is 1445
			-- Upper bound of `yytable' and `yycheck'

	yyMax_token: INTEGER is 360
			-- Maximum token id
			-- (upper bound of `yytranslate'.)

	yyNsyms: INTEGER is 256
			-- Number of symbols
			-- (terminal and nonterminal)

feature -- User-defined features



feature {NONE} -- Initialization

	make is
			-- Create a new Eiffel parser.
		do
			make_eiffel_scanner
			make_parser_skeleton
		end

	execute is
			-- Parse Eiffel files `arguments (1..argument_count)'.
		local
			j, n: INTEGER
			a_filename: STRING
			a_file: like INPUT_STREAM_TYPE
		do
			make
			n := Arguments.argument_count
			if n = 0 then
				std.error.put_string ("usage: eiffel_parser filename ...%N")
				Exceptions.die (1)
			else
				from j := 1 until j > n loop
					a_filename := Arguments.argument (j)
					a_file := INPUT_STREAM_.make_file_open_read (a_filename)
					if INPUT_STREAM_.is_open_read (a_file) then
						reset
						set_input_buffer (new_file_buffer (a_file))
						parse
						INPUT_STREAM_.close (a_file)
					else
						std.error.put_string ("eiffel_parser: cannot read %'")
						std.error.put_string (a_filename)
						std.error.put_string ("%'%N")
					end
					j := j + 1
				end
			end
		end

	benchmark is
			-- Parse Eiffel file `argument (2)' `argument (1)' times.
		local
			j, n: INTEGER
			a_filename: STRING
			a_file: like INPUT_STREAM_TYPE
		do
			make
			if
				Arguments.argument_count < 2 or else
				not STRING_.is_integer (Arguments.argument (1))
			then
				std.error.put_string ("usage: eiffel_parser nb filename%N")
				Exceptions.die (1)
			else
				n := Arguments.argument (1).to_integer
				a_filename := Arguments.argument (2)
				from j := 1 until j > n loop
					a_file := INPUT_STREAM_.make_file_open_read (a_filename)
					if INPUT_STREAM_.is_open_read (a_file) then
						reset
						set_input_buffer (new_file_buffer (a_file))
						parse
						INPUT_STREAM_.close (a_file)
					else
						std.error.put_string ("eiffel_parser: cannot read %'")
						std.error.put_string (a_filename)
						std.error.put_string ("%'%N")
						Exceptions.die (1)
					end
					j := j + 1
				end
			end
		end

feature -- Error handling

	report_error (a_message: STRING) is
			-- Print error message.
		local
			f_buffer: YY_FILE_BUFFER
		do
			f_buffer ?= input_buffer
			if f_buffer /= Void then
				std.error.put_string (INPUT_STREAM_.name (f_buffer.file))
				std.error.put_string (", line ")
			else
				std.error.put_string ("line ")
			end
			std.error.put_integer (eif_lineno)
			std.error.put_string (": ")
			std.error.put_string (a_message)
			std.error.put_character ('%N')
		end

end -- class EIFFEL_PARSER
