indexing

	description:

		"Test case aborted results"

	library:    "Gobo Eiffel Test Library"
	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 2000, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2000/11/05 15:03:12 $"
	revision:   "$Revision: 1.1 $"

class TS_ABORTED_RESULT

inherit

	TS_RESULT
		redefine
			aborted
		end

creation

	make

feature {NONE} -- Initialization

	make (a_test: like test; a_reason: like reason) is
			-- Create a new aborted result associated with `a_test'.
		require
			a_test_not_void: a_test /= Void
			a_reason_not_void: a_reason /= Void
		do
			test := a_test
			reason := a_reason
		ensure
			test_set: test = a_test
			reason_set: reason = a_reason
		end

feature -- Access

	reason: STRING
			-- Abort reason

feature -- Status report

	aborted: BOOLEAN is True
			-- Has `test' aborted?

feature -- Output

	print_result (a_file: like OUTPUT_STREAM_TYPE) is
			-- Print result to `a_file'.
		do
			a_file.put_string ("ABORT:  [")
			a_file.put_string (test.name)
			a_file.put_string ("] ")
			a_file.put_string (reason)
		end

invariant

	reason_not_void: reason /= Void

end -- class TS_ABORTED_RESULT
