indexing

	description:

		"System clocks (precision to the second)"

	library:    "Gobo Eiffel Time Library"
	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 2001, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2001/04/11 08:52:55 $"
	revision:   "$Revision: 1.1 $"

class DT_SYSTEM_CLOCK

inherit

	DT_CLOCK

	DT_GREGORIAN_CALENDAR
		export {NONE} all end

creation

	make

feature {NONE} -- Initialization

	make is
			-- Create a new system clock.
		do
		end

feature -- Setting

	set_time_to_now (a_time: DT_TIME) is
			-- Set `a_time' to current time.
		local
			s: INTEGER
		do
			basic_time.update
			s := basic_time.second
			if s >= Seconds_in_minute then
				s := Seconds_in_minute - 1
			end
			a_time.set_precise_hour_minute_second (basic_time.hour,
				basic_time.minute, s, 0)
		end

	set_date_to_now (a_date: DT_DATE) is
			-- Set `a_date' to current date.
		do
			basic_time.update
			a_date.set_year_month_day (basic_time.year,
				basic_time.month, basic_time.day)
		end

	set_date_time_to_now (a_date_time: DT_DATE_TIME) is
			-- Set `a_date_time' to current date time.
		local
			s: INTEGER
		do
			basic_time.update
			s := basic_time.second
			if s >= Seconds_in_minute then
				s := Seconds_in_minute - 1
			end
			a_date_time.set_year_month_day (basic_time.year,
				basic_time.month, basic_time.day)
			a_date_time.set_precise_hour_minute_second (basic_time.hour,
				basic_time.minute, s, 0)
		end

feature {NONE} -- Implementation

	basic_time: BASIC_TIME
			-- System time

end -- class DT_SYSTEM_CLOCK
