indexing

	description:

		"Shell commands"

	library:    "Gobo Eiffel Utility Library"
	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 2000, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2000/12/17 13:36:12 $"
	revision:   "$Revision: 1.2 $"

class UT_SHELL_COMMAND

inherit

	UT_COMMAND

creation

	make

feature {NONE} -- Initialization

	make (a_command: like command) is
			-- Create a new shell command.
		require
			a_command_not_void: a_command /= Void
			a_command_not_empty: a_command.count > 0
		do
			command := a_command
		ensure
			command_set: command = a_command
		end

feature -- Access

	command: STRING
			-- Command to be executed from the shell

feature -- Execution

	execute is
			-- Ask operating system to execute `command'.
			-- Wait until termination.
		local
			retried: BOOLEAN
			environment: expanded EXECUTION_ENVIRONMENT
		do
			if not retried then
				environment.system (command)
			end
		rescue
			if not retried then
				retried := True
				retry
			end
		end

invariant

	command_not_void: command /= Void
	command_not_empty: command.count > 0

end -- class UT_SHELL_COMMAND
