// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchCreatePartition = "BatchCreatePartition"

// BatchCreatePartitionRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreatePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreatePartition for more information on using the BatchCreatePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreatePartitionRequest method.
//    req, resp := client.BatchCreatePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition
func (c *Glue) BatchCreatePartitionRequest(input *BatchCreatePartitionInput) (req *request.Request, output *BatchCreatePartitionOutput) {
	op := &request.Operation{
		Name:       opBatchCreatePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCreatePartitionInput{}
	}

	output = &BatchCreatePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreatePartition API operation for AWS Glue.
//
// Creates one or more partitions in a batch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchCreatePartition for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition
func (c *Glue) BatchCreatePartition(input *BatchCreatePartitionInput) (*BatchCreatePartitionOutput, error) {
	req, out := c.BatchCreatePartitionRequest(input)
	return out, req.Send()
}

// BatchCreatePartitionWithContext is the same as BatchCreatePartition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreatePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchCreatePartitionWithContext(ctx aws.Context, input *BatchCreatePartitionInput, opts ...request.Option) (*BatchCreatePartitionOutput, error) {
	req, out := c.BatchCreatePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteConnection = "BatchDeleteConnection"

// BatchDeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteConnection for more information on using the BatchDeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteConnectionRequest method.
//    req, resp := client.BatchDeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection
func (c *Glue) BatchDeleteConnectionRequest(input *BatchDeleteConnectionInput) (req *request.Request, output *BatchDeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteConnectionInput{}
	}

	output = &BatchDeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteConnection API operation for AWS Glue.
//
// Deletes a list of connection definitions from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeleteConnection for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection
func (c *Glue) BatchDeleteConnection(input *BatchDeleteConnectionInput) (*BatchDeleteConnectionOutput, error) {
	req, out := c.BatchDeleteConnectionRequest(input)
	return out, req.Send()
}

// BatchDeleteConnectionWithContext is the same as BatchDeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeleteConnectionWithContext(ctx aws.Context, input *BatchDeleteConnectionInput, opts ...request.Option) (*BatchDeleteConnectionOutput, error) {
	req, out := c.BatchDeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeletePartition = "BatchDeletePartition"

// BatchDeletePartitionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeletePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeletePartition for more information on using the BatchDeletePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeletePartitionRequest method.
//    req, resp := client.BatchDeletePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition
func (c *Glue) BatchDeletePartitionRequest(input *BatchDeletePartitionInput) (req *request.Request, output *BatchDeletePartitionOutput) {
	op := &request.Operation{
		Name:       opBatchDeletePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeletePartitionInput{}
	}

	output = &BatchDeletePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeletePartition API operation for AWS Glue.
//
// Deletes one or more partitions in a batch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeletePartition for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition
func (c *Glue) BatchDeletePartition(input *BatchDeletePartitionInput) (*BatchDeletePartitionOutput, error) {
	req, out := c.BatchDeletePartitionRequest(input)
	return out, req.Send()
}

// BatchDeletePartitionWithContext is the same as BatchDeletePartition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeletePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeletePartitionWithContext(ctx aws.Context, input *BatchDeletePartitionInput, opts ...request.Option) (*BatchDeletePartitionOutput, error) {
	req, out := c.BatchDeletePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteTable = "BatchDeleteTable"

// BatchDeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteTable for more information on using the BatchDeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteTableRequest method.
//    req, resp := client.BatchDeleteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable
func (c *Glue) BatchDeleteTableRequest(input *BatchDeleteTableInput) (req *request.Request, output *BatchDeleteTableOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteTableInput{}
	}

	output = &BatchDeleteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteTable API operation for AWS Glue.
//
// Deletes multiple tables at once.
//
// After completing this operation, you no longer have access to the table versions
// and partitions that belong to the deleted table. Glue deletes these "orphaned"
// resources asynchronously in a timely manner, at the discretion of the service.
//
// To ensure the immediate deletion of all related resources, before calling
// BatchDeleteTable, use DeleteTableVersion or BatchDeleteTableVersion, and
// DeletePartition or BatchDeletePartition, to delete any resources that belong
// to the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeleteTable for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * ResourceNotReadyException
//   A resource was not ready for a transaction.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable
func (c *Glue) BatchDeleteTable(input *BatchDeleteTableInput) (*BatchDeleteTableOutput, error) {
	req, out := c.BatchDeleteTableRequest(input)
	return out, req.Send()
}

// BatchDeleteTableWithContext is the same as BatchDeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeleteTableWithContext(ctx aws.Context, input *BatchDeleteTableInput, opts ...request.Option) (*BatchDeleteTableOutput, error) {
	req, out := c.BatchDeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteTableVersion = "BatchDeleteTableVersion"

// BatchDeleteTableVersionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteTableVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteTableVersion for more information on using the BatchDeleteTableVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteTableVersionRequest method.
//    req, resp := client.BatchDeleteTableVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion
func (c *Glue) BatchDeleteTableVersionRequest(input *BatchDeleteTableVersionInput) (req *request.Request, output *BatchDeleteTableVersionOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteTableVersionInput{}
	}

	output = &BatchDeleteTableVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteTableVersion API operation for AWS Glue.
//
// Deletes a specified batch of versions of a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeleteTableVersion for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion
func (c *Glue) BatchDeleteTableVersion(input *BatchDeleteTableVersionInput) (*BatchDeleteTableVersionOutput, error) {
	req, out := c.BatchDeleteTableVersionRequest(input)
	return out, req.Send()
}

// BatchDeleteTableVersionWithContext is the same as BatchDeleteTableVersion with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteTableVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeleteTableVersionWithContext(ctx aws.Context, input *BatchDeleteTableVersionInput, opts ...request.Option) (*BatchDeleteTableVersionOutput, error) {
	req, out := c.BatchDeleteTableVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetBlueprints = "BatchGetBlueprints"

// BatchGetBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetBlueprints for more information on using the BatchGetBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetBlueprintsRequest method.
//    req, resp := client.BatchGetBlueprintsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetBlueprints
func (c *Glue) BatchGetBlueprintsRequest(input *BatchGetBlueprintsInput) (req *request.Request, output *BatchGetBlueprintsOutput) {
	op := &request.Operation{
		Name:       opBatchGetBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetBlueprintsInput{}
	}

	output = &BatchGetBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetBlueprints API operation for AWS Glue.
//
// Retrieves information about a list of blueprints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetBlueprints for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetBlueprints
func (c *Glue) BatchGetBlueprints(input *BatchGetBlueprintsInput) (*BatchGetBlueprintsOutput, error) {
	req, out := c.BatchGetBlueprintsRequest(input)
	return out, req.Send()
}

// BatchGetBlueprintsWithContext is the same as BatchGetBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetBlueprintsWithContext(ctx aws.Context, input *BatchGetBlueprintsInput, opts ...request.Option) (*BatchGetBlueprintsOutput, error) {
	req, out := c.BatchGetBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetCrawlers = "BatchGetCrawlers"

// BatchGetCrawlersRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetCrawlers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetCrawlers for more information on using the BatchGetCrawlers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetCrawlersRequest method.
//    req, resp := client.BatchGetCrawlersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers
func (c *Glue) BatchGetCrawlersRequest(input *BatchGetCrawlersInput) (req *request.Request, output *BatchGetCrawlersOutput) {
	op := &request.Operation{
		Name:       opBatchGetCrawlers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetCrawlersInput{}
	}

	output = &BatchGetCrawlersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetCrawlers API operation for AWS Glue.
//
// Returns a list of resource metadata for a given list of crawler names. After
// calling the ListCrawlers operation, you can call this operation to access
// the data to which you have been granted permissions. This operation supports
// all IAM permissions, including permission conditions that uses tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetCrawlers for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers
func (c *Glue) BatchGetCrawlers(input *BatchGetCrawlersInput) (*BatchGetCrawlersOutput, error) {
	req, out := c.BatchGetCrawlersRequest(input)
	return out, req.Send()
}

// BatchGetCrawlersWithContext is the same as BatchGetCrawlers with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetCrawlers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetCrawlersWithContext(ctx aws.Context, input *BatchGetCrawlersInput, opts ...request.Option) (*BatchGetCrawlersOutput, error) {
	req, out := c.BatchGetCrawlersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetDevEndpoints = "BatchGetDevEndpoints"

// BatchGetDevEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDevEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetDevEndpoints for more information on using the BatchGetDevEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetDevEndpointsRequest method.
//    req, resp := client.BatchGetDevEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints
func (c *Glue) BatchGetDevEndpointsRequest(input *BatchGetDevEndpointsInput) (req *request.Request, output *BatchGetDevEndpointsOutput) {
	op := &request.Operation{
		Name:       opBatchGetDevEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDevEndpointsInput{}
	}

	output = &BatchGetDevEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetDevEndpoints API operation for AWS Glue.
//
// Returns a list of resource metadata for a given list of development endpoint
// names. After calling the ListDevEndpoints operation, you can call this operation
// to access the data to which you have been granted permissions. This operation
// supports all IAM permissions, including permission conditions that uses tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetDevEndpoints for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints
func (c *Glue) BatchGetDevEndpoints(input *BatchGetDevEndpointsInput) (*BatchGetDevEndpointsOutput, error) {
	req, out := c.BatchGetDevEndpointsRequest(input)
	return out, req.Send()
}

// BatchGetDevEndpointsWithContext is the same as BatchGetDevEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetDevEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetDevEndpointsWithContext(ctx aws.Context, input *BatchGetDevEndpointsInput, opts ...request.Option) (*BatchGetDevEndpointsOutput, error) {
	req, out := c.BatchGetDevEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetJobs = "BatchGetJobs"

// BatchGetJobsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetJobs for more information on using the BatchGetJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetJobsRequest method.
//    req, resp := client.BatchGetJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs
func (c *Glue) BatchGetJobsRequest(input *BatchGetJobsInput) (req *request.Request, output *BatchGetJobsOutput) {
	op := &request.Operation{
		Name:       opBatchGetJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetJobsInput{}
	}

	output = &BatchGetJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetJobs API operation for AWS Glue.
//
// Returns a list of resource metadata for a given list of job names. After
// calling the ListJobs operation, you can call this operation to access the
// data to which you have been granted permissions. This operation supports
// all IAM permissions, including permission conditions that uses tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetJobs for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs
func (c *Glue) BatchGetJobs(input *BatchGetJobsInput) (*BatchGetJobsOutput, error) {
	req, out := c.BatchGetJobsRequest(input)
	return out, req.Send()
}

// BatchGetJobsWithContext is the same as BatchGetJobs with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetJobsWithContext(ctx aws.Context, input *BatchGetJobsInput, opts ...request.Option) (*BatchGetJobsOutput, error) {
	req, out := c.BatchGetJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetPartition = "BatchGetPartition"

// BatchGetPartitionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetPartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetPartition for more information on using the BatchGetPartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetPartitionRequest method.
//    req, resp := client.BatchGetPartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition
func (c *Glue) BatchGetPartitionRequest(input *BatchGetPartitionInput) (req *request.Request, output *BatchGetPartitionOutput) {
	op := &request.Operation{
		Name:       opBatchGetPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetPartitionInput{}
	}

	output = &BatchGetPartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetPartition API operation for AWS Glue.
//
// Retrieves partitions in a batch request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetPartition for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * InvalidStateException
//   An error that indicates your data is in an invalid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition
func (c *Glue) BatchGetPartition(input *BatchGetPartitionInput) (*BatchGetPartitionOutput, error) {
	req, out := c.BatchGetPartitionRequest(input)
	return out, req.Send()
}

// BatchGetPartitionWithContext is the same as BatchGetPartition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetPartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetPartitionWithContext(ctx aws.Context, input *BatchGetPartitionInput, opts ...request.Option) (*BatchGetPartitionOutput, error) {
	req, out := c.BatchGetPartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetTriggers = "BatchGetTriggers"

// BatchGetTriggersRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetTriggers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetTriggers for more information on using the BatchGetTriggers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetTriggersRequest method.
//    req, resp := client.BatchGetTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers
func (c *Glue) BatchGetTriggersRequest(input *BatchGetTriggersInput) (req *request.Request, output *BatchGetTriggersOutput) {
	op := &request.Operation{
		Name:       opBatchGetTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetTriggersInput{}
	}

	output = &BatchGetTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetTriggers API operation for AWS Glue.
//
// Returns a list of resource metadata for a given list of trigger names. After
// calling the ListTriggers operation, you can call this operation to access
// the data to which you have been granted permissions. This operation supports
// all IAM permissions, including permission conditions that uses tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetTriggers for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers
func (c *Glue) BatchGetTriggers(input *BatchGetTriggersInput) (*BatchGetTriggersOutput, error) {
	req, out := c.BatchGetTriggersRequest(input)
	return out, req.Send()
}

// BatchGetTriggersWithContext is the same as BatchGetTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetTriggersWithContext(ctx aws.Context, input *BatchGetTriggersInput, opts ...request.Option) (*BatchGetTriggersOutput, error) {
	req, out := c.BatchGetTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetWorkflows = "BatchGetWorkflows"

// BatchGetWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetWorkflows for more information on using the BatchGetWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetWorkflowsRequest method.
//    req, resp := client.BatchGetWorkflowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows
func (c *Glue) BatchGetWorkflowsRequest(input *BatchGetWorkflowsInput) (req *request.Request, output *BatchGetWorkflowsOutput) {
	op := &request.Operation{
		Name:       opBatchGetWorkflows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetWorkflowsInput{}
	}

	output = &BatchGetWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetWorkflows API operation for AWS Glue.
//
// Returns a list of resource metadata for a given list of workflow names. After
// calling the ListWorkflows operation, you can call this operation to access
// the data to which you have been granted permissions. This operation supports
// all IAM permissions, including permission conditions that uses tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetWorkflows for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows
func (c *Glue) BatchGetWorkflows(input *BatchGetWorkflowsInput) (*BatchGetWorkflowsOutput, error) {
	req, out := c.BatchGetWorkflowsRequest(input)
	return out, req.Send()
}

// BatchGetWorkflowsWithContext is the same as BatchGetWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetWorkflowsWithContext(ctx aws.Context, input *BatchGetWorkflowsInput, opts ...request.Option) (*BatchGetWorkflowsOutput, error) {
	req, out := c.BatchGetWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchStopJobRun = "BatchStopJobRun"

// BatchStopJobRunRequest generates a "aws/request.Request" representing the
// client's request for the BatchStopJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchStopJobRun for more information on using the BatchStopJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchStopJobRunRequest method.
//    req, resp := client.BatchStopJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun
func (c *Glue) BatchStopJobRunRequest(input *BatchStopJobRunInput) (req *request.Request, output *BatchStopJobRunOutput) {
	op := &request.Operation{
		Name:       opBatchStopJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchStopJobRunInput{}
	}

	output = &BatchStopJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchStopJobRun API operation for AWS Glue.
//
// Stops one or more job runs for a specified job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchStopJobRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun
func (c *Glue) BatchStopJobRun(input *BatchStopJobRunInput) (*BatchStopJobRunOutput, error) {
	req, out := c.BatchStopJobRunRequest(input)
	return out, req.Send()
}

// BatchStopJobRunWithContext is the same as BatchStopJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See BatchStopJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchStopJobRunWithContext(ctx aws.Context, input *BatchStopJobRunInput, opts ...request.Option) (*BatchStopJobRunOutput, error) {
	req, out := c.BatchStopJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdatePartition = "BatchUpdatePartition"

// BatchUpdatePartitionRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdatePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdatePartition for more information on using the BatchUpdatePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdatePartitionRequest method.
//    req, resp := client.BatchUpdatePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchUpdatePartition
func (c *Glue) BatchUpdatePartitionRequest(input *BatchUpdatePartitionInput) (req *request.Request, output *BatchUpdatePartitionOutput) {
	op := &request.Operation{
		Name:       opBatchUpdatePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchUpdatePartitionInput{}
	}

	output = &BatchUpdatePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdatePartition API operation for AWS Glue.
//
// Updates one or more partitions in a batch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchUpdatePartition for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchUpdatePartition
func (c *Glue) BatchUpdatePartition(input *BatchUpdatePartitionInput) (*BatchUpdatePartitionOutput, error) {
	req, out := c.BatchUpdatePartitionRequest(input)
	return out, req.Send()
}

// BatchUpdatePartitionWithContext is the same as BatchUpdatePartition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdatePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchUpdatePartitionWithContext(ctx aws.Context, input *BatchUpdatePartitionInput, opts ...request.Option) (*BatchUpdatePartitionOutput, error) {
	req, out := c.BatchUpdatePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMLTaskRun = "CancelMLTaskRun"

// CancelMLTaskRunRequest generates a "aws/request.Request" representing the
// client's request for the CancelMLTaskRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMLTaskRun for more information on using the CancelMLTaskRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelMLTaskRunRequest method.
//    req, resp := client.CancelMLTaskRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun
func (c *Glue) CancelMLTaskRunRequest(input *CancelMLTaskRunInput) (req *request.Request, output *CancelMLTaskRunOutput) {
	op := &request.Operation{
		Name:       opCancelMLTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelMLTaskRunInput{}
	}

	output = &CancelMLTaskRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelMLTaskRun API operation for AWS Glue.
//
// Cancels (stops) a task run. Machine learning task runs are asynchronous tasks
// that Glue runs on your behalf as part of various machine learning workflows.
// You can cancel a machine learning task run at any time by calling CancelMLTaskRun
// with a task run's parent transform's TransformID and the task run's TaskRunId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CancelMLTaskRun for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun
func (c *Glue) CancelMLTaskRun(input *CancelMLTaskRunInput) (*CancelMLTaskRunOutput, error) {
	req, out := c.CancelMLTaskRunRequest(input)
	return out, req.Send()
}

// CancelMLTaskRunWithContext is the same as CancelMLTaskRun with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMLTaskRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CancelMLTaskRunWithContext(ctx aws.Context, input *CancelMLTaskRunInput, opts ...request.Option) (*CancelMLTaskRunOutput, error) {
	req, out := c.CancelMLTaskRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelStatement = "CancelStatement"

// CancelStatementRequest generates a "aws/request.Request" representing the
// client's request for the CancelStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelStatement for more information on using the CancelStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelStatementRequest method.
//    req, resp := client.CancelStatementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelStatement
func (c *Glue) CancelStatementRequest(input *CancelStatementInput) (req *request.Request, output *CancelStatementOutput) {
	op := &request.Operation{
		Name:       opCancelStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelStatementInput{}
	}

	output = &CancelStatementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelStatement API operation for AWS Glue.
//
// Cancels the statement..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CancelStatement for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * IllegalSessionStateException
//   The session is in an invalid state to perform a requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelStatement
func (c *Glue) CancelStatement(input *CancelStatementInput) (*CancelStatementOutput, error) {
	req, out := c.CancelStatementRequest(input)
	return out, req.Send()
}

// CancelStatementWithContext is the same as CancelStatement with the addition of
// the ability to pass a context and additional request options.
//
// See CancelStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CancelStatementWithContext(ctx aws.Context, input *CancelStatementInput, opts ...request.Option) (*CancelStatementOutput, error) {
	req, out := c.CancelStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCheckSchemaVersionValidity = "CheckSchemaVersionValidity"

// CheckSchemaVersionValidityRequest generates a "aws/request.Request" representing the
// client's request for the CheckSchemaVersionValidity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CheckSchemaVersionValidity for more information on using the CheckSchemaVersionValidity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CheckSchemaVersionValidityRequest method.
//    req, resp := client.CheckSchemaVersionValidityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CheckSchemaVersionValidity
func (c *Glue) CheckSchemaVersionValidityRequest(input *CheckSchemaVersionValidityInput) (req *request.Request, output *CheckSchemaVersionValidityOutput) {
	op := &request.Operation{
		Name:       opCheckSchemaVersionValidity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckSchemaVersionValidityInput{}
	}

	output = &CheckSchemaVersionValidityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CheckSchemaVersionValidity API operation for AWS Glue.
//
// Validates the supplied schema. This call has no side effects, it simply validates
// using the supplied schema using DataFormat as the format. Since it does not
// take a schema set name, no compatibility checks are performed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CheckSchemaVersionValidity for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CheckSchemaVersionValidity
func (c *Glue) CheckSchemaVersionValidity(input *CheckSchemaVersionValidityInput) (*CheckSchemaVersionValidityOutput, error) {
	req, out := c.CheckSchemaVersionValidityRequest(input)
	return out, req.Send()
}

// CheckSchemaVersionValidityWithContext is the same as CheckSchemaVersionValidity with the addition of
// the ability to pass a context and additional request options.
//
// See CheckSchemaVersionValidity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CheckSchemaVersionValidityWithContext(ctx aws.Context, input *CheckSchemaVersionValidityInput, opts ...request.Option) (*CheckSchemaVersionValidityOutput, error) {
	req, out := c.CheckSchemaVersionValidityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBlueprint = "CreateBlueprint"

// CreateBlueprintRequest generates a "aws/request.Request" representing the
// client's request for the CreateBlueprint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBlueprint for more information on using the CreateBlueprint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBlueprintRequest method.
//    req, resp := client.CreateBlueprintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateBlueprint
func (c *Glue) CreateBlueprintRequest(input *CreateBlueprintInput) (req *request.Request, output *CreateBlueprintOutput) {
	op := &request.Operation{
		Name:       opCreateBlueprint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBlueprintInput{}
	}

	output = &CreateBlueprintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBlueprint API operation for AWS Glue.
//
// Registers a blueprint with Glue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateBlueprint for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateBlueprint
func (c *Glue) CreateBlueprint(input *CreateBlueprintInput) (*CreateBlueprintOutput, error) {
	req, out := c.CreateBlueprintRequest(input)
	return out, req.Send()
}

// CreateBlueprintWithContext is the same as CreateBlueprint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBlueprint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateBlueprintWithContext(ctx aws.Context, input *CreateBlueprintInput, opts ...request.Option) (*CreateBlueprintOutput, error) {
	req, out := c.CreateBlueprintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClassifier = "CreateClassifier"

// CreateClassifierRequest generates a "aws/request.Request" representing the
// client's request for the CreateClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClassifier for more information on using the CreateClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClassifierRequest method.
//    req, resp := client.CreateClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier
func (c *Glue) CreateClassifierRequest(input *CreateClassifierInput) (req *request.Request, output *CreateClassifierOutput) {
	op := &request.Operation{
		Name:       opCreateClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClassifierInput{}
	}

	output = &CreateClassifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateClassifier API operation for AWS Glue.
//
// Creates a classifier in the user's account. This can be a GrokClassifier,
// an XMLClassifier, a JsonClassifier, or a CsvClassifier, depending on which
// field of the request is present.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateClassifier for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier
func (c *Glue) CreateClassifier(input *CreateClassifierInput) (*CreateClassifierOutput, error) {
	req, out := c.CreateClassifierRequest(input)
	return out, req.Send()
}

// CreateClassifierWithContext is the same as CreateClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateClassifierWithContext(ctx aws.Context, input *CreateClassifierInput, opts ...request.Option) (*CreateClassifierOutput, error) {
	req, out := c.CreateClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnection for more information on using the CreateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectionRequest method.
//    req, resp := client.CreateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection
func (c *Glue) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *CreateConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &CreateConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConnection API operation for AWS Glue.
//
// Creates a connection definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateConnection for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection
func (c *Glue) CreateConnection(input *CreateConnectionInput) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	return out, req.Send()
}

// CreateConnectionWithContext is the same as CreateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateConnectionWithContext(ctx aws.Context, input *CreateConnectionInput, opts ...request.Option) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCrawler = "CreateCrawler"

// CreateCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the CreateCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCrawler for more information on using the CreateCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCrawlerRequest method.
//    req, resp := client.CreateCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler
func (c *Glue) CreateCrawlerRequest(input *CreateCrawlerInput) (req *request.Request, output *CreateCrawlerOutput) {
	op := &request.Operation{
		Name:       opCreateCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCrawlerInput{}
	}

	output = &CreateCrawlerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateCrawler API operation for AWS Glue.
//
// Creates a new crawler with specified targets, role, configuration, and optional
// schedule. At least one crawl target must be specified, in the s3Targets field,
// the jdbcTargets field, or the DynamoDBTargets field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateCrawler for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler
func (c *Glue) CreateCrawler(input *CreateCrawlerInput) (*CreateCrawlerOutput, error) {
	req, out := c.CreateCrawlerRequest(input)
	return out, req.Send()
}

// CreateCrawlerWithContext is the same as CreateCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateCrawlerWithContext(ctx aws.Context, input *CreateCrawlerInput, opts ...request.Option) (*CreateCrawlerOutput, error) {
	req, out := c.CreateCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatabase = "CreateDatabase"

// CreateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatabase for more information on using the CreateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatabaseRequest method.
//    req, resp := client.CreateDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase
func (c *Glue) CreateDatabaseRequest(input *CreateDatabaseInput) (req *request.Request, output *CreateDatabaseOutput) {
	op := &request.Operation{
		Name:       opCreateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatabaseInput{}
	}

	output = &CreateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDatabase API operation for AWS Glue.
//
// Creates a new database in a Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateDatabase for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase
func (c *Glue) CreateDatabase(input *CreateDatabaseInput) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	return out, req.Send()
}

// CreateDatabaseWithContext is the same as CreateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateDatabaseWithContext(ctx aws.Context, input *CreateDatabaseInput, opts ...request.Option) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDevEndpoint = "CreateDevEndpoint"

// CreateDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDevEndpoint for more information on using the CreateDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDevEndpointRequest method.
//    req, resp := client.CreateDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint
func (c *Glue) CreateDevEndpointRequest(input *CreateDevEndpointInput) (req *request.Request, output *CreateDevEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDevEndpointInput{}
	}

	output = &CreateDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDevEndpoint API operation for AWS Glue.
//
// Creates a new development endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateDevEndpoint for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * IdempotentParameterMismatchException
//   The same unique identifier was associated with two different records.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * ValidationException
//   A value could not be validated.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint
func (c *Glue) CreateDevEndpoint(input *CreateDevEndpointInput) (*CreateDevEndpointOutput, error) {
	req, out := c.CreateDevEndpointRequest(input)
	return out, req.Send()
}

// CreateDevEndpointWithContext is the same as CreateDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateDevEndpointWithContext(ctx aws.Context, input *CreateDevEndpointInput, opts ...request.Option) (*CreateDevEndpointOutput, error) {
	req, out := c.CreateDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob
func (c *Glue) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for AWS Glue.
//
// Creates a new job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * IdempotentParameterMismatchException
//   The same unique identifier was associated with two different records.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob
func (c *Glue) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMLTransform = "CreateMLTransform"

// CreateMLTransformRequest generates a "aws/request.Request" representing the
// client's request for the CreateMLTransform operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMLTransform for more information on using the CreateMLTransform
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMLTransformRequest method.
//    req, resp := client.CreateMLTransformRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform
func (c *Glue) CreateMLTransformRequest(input *CreateMLTransformInput) (req *request.Request, output *CreateMLTransformOutput) {
	op := &request.Operation{
		Name:       opCreateMLTransform,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMLTransformInput{}
	}

	output = &CreateMLTransformOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMLTransform API operation for AWS Glue.
//
// Creates an Glue machine learning transform. This operation creates the transform
// and all the necessary parameters to train it.
//
// Call this operation as the first step in the process of using a machine learning
// transform (such as the FindMatches transform) for deduplicating data. You
// can provide an optional Description, in addition to the parameters that you
// want to use for your algorithm.
//
// You must also specify certain parameters for the tasks that Glue runs on
// your behalf as part of learning from your data and creating a high-quality
// machine learning transform. These parameters include Role, and optionally,
// AllocatedCapacity, Timeout, and MaxRetries. For more information, see Jobs
// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateMLTransform for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * IdempotentParameterMismatchException
//   The same unique identifier was associated with two different records.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform
func (c *Glue) CreateMLTransform(input *CreateMLTransformInput) (*CreateMLTransformOutput, error) {
	req, out := c.CreateMLTransformRequest(input)
	return out, req.Send()
}

// CreateMLTransformWithContext is the same as CreateMLTransform with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMLTransform for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateMLTransformWithContext(ctx aws.Context, input *CreateMLTransformInput, opts ...request.Option) (*CreateMLTransformOutput, error) {
	req, out := c.CreateMLTransformRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePartition = "CreatePartition"

// CreatePartitionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePartition for more information on using the CreatePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePartitionRequest method.
//    req, resp := client.CreatePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition
func (c *Glue) CreatePartitionRequest(input *CreatePartitionInput) (req *request.Request, output *CreatePartitionOutput) {
	op := &request.Operation{
		Name:       opCreatePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePartitionInput{}
	}

	output = &CreatePartitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreatePartition API operation for AWS Glue.
//
// Creates a new partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreatePartition for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition
func (c *Glue) CreatePartition(input *CreatePartitionInput) (*CreatePartitionOutput, error) {
	req, out := c.CreatePartitionRequest(input)
	return out, req.Send()
}

// CreatePartitionWithContext is the same as CreatePartition with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreatePartitionWithContext(ctx aws.Context, input *CreatePartitionInput, opts ...request.Option) (*CreatePartitionOutput, error) {
	req, out := c.CreatePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePartitionIndex = "CreatePartitionIndex"

// CreatePartitionIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreatePartitionIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePartitionIndex for more information on using the CreatePartitionIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePartitionIndexRequest method.
//    req, resp := client.CreatePartitionIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartitionIndex
func (c *Glue) CreatePartitionIndexRequest(input *CreatePartitionIndexInput) (req *request.Request, output *CreatePartitionIndexOutput) {
	op := &request.Operation{
		Name:       opCreatePartitionIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePartitionIndexInput{}
	}

	output = &CreatePartitionIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreatePartitionIndex API operation for AWS Glue.
//
// Creates a specified partition index in an existing table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreatePartitionIndex for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartitionIndex
func (c *Glue) CreatePartitionIndex(input *CreatePartitionIndexInput) (*CreatePartitionIndexOutput, error) {
	req, out := c.CreatePartitionIndexRequest(input)
	return out, req.Send()
}

// CreatePartitionIndexWithContext is the same as CreatePartitionIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePartitionIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreatePartitionIndexWithContext(ctx aws.Context, input *CreatePartitionIndexInput, opts ...request.Option) (*CreatePartitionIndexOutput, error) {
	req, out := c.CreatePartitionIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRegistry = "CreateRegistry"

// CreateRegistryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRegistry for more information on using the CreateRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRegistryRequest method.
//    req, resp := client.CreateRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateRegistry
func (c *Glue) CreateRegistryRequest(input *CreateRegistryInput) (req *request.Request, output *CreateRegistryOutput) {
	op := &request.Operation{
		Name:       opCreateRegistry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRegistryInput{}
	}

	output = &CreateRegistryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRegistry API operation for AWS Glue.
//
// Creates a new registry which may be used to hold a collection of schemas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateRegistry for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateRegistry
func (c *Glue) CreateRegistry(input *CreateRegistryInput) (*CreateRegistryOutput, error) {
	req, out := c.CreateRegistryRequest(input)
	return out, req.Send()
}

// CreateRegistryWithContext is the same as CreateRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateRegistryWithContext(ctx aws.Context, input *CreateRegistryInput, opts ...request.Option) (*CreateRegistryOutput, error) {
	req, out := c.CreateRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchema = "CreateSchema"

// CreateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchema for more information on using the CreateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSchemaRequest method.
//    req, resp := client.CreateSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSchema
func (c *Glue) CreateSchemaRequest(input *CreateSchemaInput) (req *request.Request, output *CreateSchemaOutput) {
	op := &request.Operation{
		Name:       opCreateSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSchemaInput{}
	}

	output = &CreateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchema API operation for AWS Glue.
//
// Creates a new schema set and registers the schema definition. Returns an
// error if the schema set already exists without actually registering the version.
//
// When the schema set is created, a version checkpoint will be set to the first
// version. Compatibility mode "DISABLED" restricts any additional schema versions
// from being added after the first schema version. For all other compatibility
// modes, validation of compatibility settings will be applied only from the
// second version onwards when the RegisterSchemaVersion API is used.
//
// When this API is called without a RegistryId, this will create an entry for
// a "default-registry" in the registry database tables, if it is not already
// present.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateSchema for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSchema
func (c *Glue) CreateSchema(input *CreateSchemaInput) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	return out, req.Send()
}

// CreateSchemaWithContext is the same as CreateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateSchemaWithContext(ctx aws.Context, input *CreateSchemaInput, opts ...request.Option) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScript = "CreateScript"

// CreateScriptRequest generates a "aws/request.Request" representing the
// client's request for the CreateScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScript for more information on using the CreateScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScriptRequest method.
//    req, resp := client.CreateScriptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript
func (c *Glue) CreateScriptRequest(input *CreateScriptInput) (req *request.Request, output *CreateScriptOutput) {
	op := &request.Operation{
		Name:       opCreateScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScriptInput{}
	}

	output = &CreateScriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScript API operation for AWS Glue.
//
// Transforms a directed acyclic graph (DAG) into code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateScript for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript
func (c *Glue) CreateScript(input *CreateScriptInput) (*CreateScriptOutput, error) {
	req, out := c.CreateScriptRequest(input)
	return out, req.Send()
}

// CreateScriptWithContext is the same as CreateScript with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateScriptWithContext(ctx aws.Context, input *CreateScriptInput, opts ...request.Option) (*CreateScriptOutput, error) {
	req, out := c.CreateScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityConfiguration = "CreateSecurityConfiguration"

// CreateSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityConfiguration for more information on using the CreateSecurityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSecurityConfigurationRequest method.
//    req, resp := client.CreateSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration
func (c *Glue) CreateSecurityConfigurationRequest(input *CreateSecurityConfigurationInput) (req *request.Request, output *CreateSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityConfigurationInput{}
	}

	output = &CreateSecurityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityConfiguration API operation for AWS Glue.
//
// Creates a new security configuration. A security configuration is a set of
// security properties that can be used by Glue. You can use a security configuration
// to encrypt data at rest. For information about using security configurations
// in Glue, see Encrypting Data Written by Crawlers, Jobs, and Development Endpoints
// (https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateSecurityConfiguration for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration
func (c *Glue) CreateSecurityConfiguration(input *CreateSecurityConfigurationInput) (*CreateSecurityConfigurationOutput, error) {
	req, out := c.CreateSecurityConfigurationRequest(input)
	return out, req.Send()
}

// CreateSecurityConfigurationWithContext is the same as CreateSecurityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateSecurityConfigurationWithContext(ctx aws.Context, input *CreateSecurityConfigurationInput, opts ...request.Option) (*CreateSecurityConfigurationOutput, error) {
	req, out := c.CreateSecurityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSession = "CreateSession"

// CreateSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSession for more information on using the CreateSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSessionRequest method.
//    req, resp := client.CreateSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSession
func (c *Glue) CreateSessionRequest(input *CreateSessionInput) (req *request.Request, output *CreateSessionOutput) {
	op := &request.Operation{
		Name:       opCreateSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSessionInput{}
	}

	output = &CreateSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSession API operation for AWS Glue.
//
// Creates a new session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateSession for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * IdempotentParameterMismatchException
//   The same unique identifier was associated with two different records.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * ValidationException
//   A value could not be validated.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSession
func (c *Glue) CreateSession(input *CreateSessionInput) (*CreateSessionOutput, error) {
	req, out := c.CreateSessionRequest(input)
	return out, req.Send()
}

// CreateSessionWithContext is the same as CreateSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateSessionWithContext(ctx aws.Context, input *CreateSessionInput, opts ...request.Option) (*CreateSessionOutput, error) {
	req, out := c.CreateSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTable = "CreateTable"

// CreateTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTable for more information on using the CreateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTableRequest method.
//    req, resp := client.CreateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable
func (c *Glue) CreateTableRequest(input *CreateTableInput) (req *request.Request, output *CreateTableOutput) {
	op := &request.Operation{
		Name:       opCreateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTableInput{}
	}

	output = &CreateTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTable API operation for AWS Glue.
//
// Creates a new table definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateTable for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * ResourceNotReadyException
//   A resource was not ready for a transaction.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable
func (c *Glue) CreateTable(input *CreateTableInput) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	return out, req.Send()
}

// CreateTableWithContext is the same as CreateTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateTableWithContext(ctx aws.Context, input *CreateTableInput, opts ...request.Option) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrigger = "CreateTrigger"

// CreateTriggerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrigger for more information on using the CreateTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTriggerRequest method.
//    req, resp := client.CreateTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger
func (c *Glue) CreateTriggerRequest(input *CreateTriggerInput) (req *request.Request, output *CreateTriggerOutput) {
	op := &request.Operation{
		Name:       opCreateTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTriggerInput{}
	}

	output = &CreateTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrigger API operation for AWS Glue.
//
// Creates a new trigger.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateTrigger for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * IdempotentParameterMismatchException
//   The same unique identifier was associated with two different records.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger
func (c *Glue) CreateTrigger(input *CreateTriggerInput) (*CreateTriggerOutput, error) {
	req, out := c.CreateTriggerRequest(input)
	return out, req.Send()
}

// CreateTriggerWithContext is the same as CreateTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateTriggerWithContext(ctx aws.Context, input *CreateTriggerInput, opts ...request.Option) (*CreateTriggerOutput, error) {
	req, out := c.CreateTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserDefinedFunction = "CreateUserDefinedFunction"

// CreateUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserDefinedFunction for more information on using the CreateUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserDefinedFunctionRequest method.
//    req, resp := client.CreateUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction
func (c *Glue) CreateUserDefinedFunctionRequest(input *CreateUserDefinedFunctionInput) (req *request.Request, output *CreateUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opCreateUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserDefinedFunctionInput{}
	}

	output = &CreateUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateUserDefinedFunction API operation for AWS Glue.
//
// Creates a new function definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateUserDefinedFunction for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction
func (c *Glue) CreateUserDefinedFunction(input *CreateUserDefinedFunctionInput) (*CreateUserDefinedFunctionOutput, error) {
	req, out := c.CreateUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// CreateUserDefinedFunctionWithContext is the same as CreateUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateUserDefinedFunctionWithContext(ctx aws.Context, input *CreateUserDefinedFunctionInput, opts ...request.Option) (*CreateUserDefinedFunctionOutput, error) {
	req, out := c.CreateUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkflow = "CreateWorkflow"

// CreateWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkflow for more information on using the CreateWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkflowRequest method.
//    req, resp := client.CreateWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow
func (c *Glue) CreateWorkflowRequest(input *CreateWorkflowInput) (req *request.Request, output *CreateWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkflowInput{}
	}

	output = &CreateWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkflow API operation for AWS Glue.
//
// Creates a new workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateWorkflow for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow
func (c *Glue) CreateWorkflow(input *CreateWorkflowInput) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	return out, req.Send()
}

// CreateWorkflowWithContext is the same as CreateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateWorkflowWithContext(ctx aws.Context, input *CreateWorkflowInput, opts ...request.Option) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBlueprint = "DeleteBlueprint"

// DeleteBlueprintRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBlueprint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBlueprint for more information on using the DeleteBlueprint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBlueprintRequest method.
//    req, resp := client.DeleteBlueprintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteBlueprint
func (c *Glue) DeleteBlueprintRequest(input *DeleteBlueprintInput) (req *request.Request, output *DeleteBlueprintOutput) {
	op := &request.Operation{
		Name:       opDeleteBlueprint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBlueprintInput{}
	}

	output = &DeleteBlueprintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBlueprint API operation for AWS Glue.
//
// Deletes an existing blueprint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteBlueprint for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteBlueprint
func (c *Glue) DeleteBlueprint(input *DeleteBlueprintInput) (*DeleteBlueprintOutput, error) {
	req, out := c.DeleteBlueprintRequest(input)
	return out, req.Send()
}

// DeleteBlueprintWithContext is the same as DeleteBlueprint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBlueprint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteBlueprintWithContext(ctx aws.Context, input *DeleteBlueprintInput, opts ...request.Option) (*DeleteBlueprintOutput, error) {
	req, out := c.DeleteBlueprintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClassifier = "DeleteClassifier"

// DeleteClassifierRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClassifier for more information on using the DeleteClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClassifierRequest method.
//    req, resp := client.DeleteClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier
func (c *Glue) DeleteClassifierRequest(input *DeleteClassifierInput) (req *request.Request, output *DeleteClassifierOutput) {
	op := &request.Operation{
		Name:       opDeleteClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClassifierInput{}
	}

	output = &DeleteClassifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClassifier API operation for AWS Glue.
//
// Removes a classifier from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteClassifier for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier
func (c *Glue) DeleteClassifier(input *DeleteClassifierInput) (*DeleteClassifierOutput, error) {
	req, out := c.DeleteClassifierRequest(input)
	return out, req.Send()
}

// DeleteClassifierWithContext is the same as DeleteClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteClassifierWithContext(ctx aws.Context, input *DeleteClassifierInput, opts ...request.Option) (*DeleteClassifierOutput, error) {
	req, out := c.DeleteClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteColumnStatisticsForPartition = "DeleteColumnStatisticsForPartition"

// DeleteColumnStatisticsForPartitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteColumnStatisticsForPartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteColumnStatisticsForPartition for more information on using the DeleteColumnStatisticsForPartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteColumnStatisticsForPartitionRequest method.
//    req, resp := client.DeleteColumnStatisticsForPartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForPartition
func (c *Glue) DeleteColumnStatisticsForPartitionRequest(input *DeleteColumnStatisticsForPartitionInput) (req *request.Request, output *DeleteColumnStatisticsForPartitionOutput) {
	op := &request.Operation{
		Name:       opDeleteColumnStatisticsForPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteColumnStatisticsForPartitionInput{}
	}

	output = &DeleteColumnStatisticsForPartitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteColumnStatisticsForPartition API operation for AWS Glue.
//
// Delete the partition column statistics of a column.
//
// The Identity and Access Management (IAM) permission required for this operation
// is DeletePartition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteColumnStatisticsForPartition for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForPartition
func (c *Glue) DeleteColumnStatisticsForPartition(input *DeleteColumnStatisticsForPartitionInput) (*DeleteColumnStatisticsForPartitionOutput, error) {
	req, out := c.DeleteColumnStatisticsForPartitionRequest(input)
	return out, req.Send()
}

// DeleteColumnStatisticsForPartitionWithContext is the same as DeleteColumnStatisticsForPartition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteColumnStatisticsForPartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteColumnStatisticsForPartitionWithContext(ctx aws.Context, input *DeleteColumnStatisticsForPartitionInput, opts ...request.Option) (*DeleteColumnStatisticsForPartitionOutput, error) {
	req, out := c.DeleteColumnStatisticsForPartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteColumnStatisticsForTable = "DeleteColumnStatisticsForTable"

// DeleteColumnStatisticsForTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteColumnStatisticsForTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteColumnStatisticsForTable for more information on using the DeleteColumnStatisticsForTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteColumnStatisticsForTableRequest method.
//    req, resp := client.DeleteColumnStatisticsForTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable
func (c *Glue) DeleteColumnStatisticsForTableRequest(input *DeleteColumnStatisticsForTableInput) (req *request.Request, output *DeleteColumnStatisticsForTableOutput) {
	op := &request.Operation{
		Name:       opDeleteColumnStatisticsForTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteColumnStatisticsForTableInput{}
	}

	output = &DeleteColumnStatisticsForTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteColumnStatisticsForTable API operation for AWS Glue.
//
// Retrieves table statistics of columns.
//
// The Identity and Access Management (IAM) permission required for this operation
// is DeleteTable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteColumnStatisticsForTable for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable
func (c *Glue) DeleteColumnStatisticsForTable(input *DeleteColumnStatisticsForTableInput) (*DeleteColumnStatisticsForTableOutput, error) {
	req, out := c.DeleteColumnStatisticsForTableRequest(input)
	return out, req.Send()
}

// DeleteColumnStatisticsForTableWithContext is the same as DeleteColumnStatisticsForTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteColumnStatisticsForTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteColumnStatisticsForTableWithContext(ctx aws.Context, input *DeleteColumnStatisticsForTableInput, opts ...request.Option) (*DeleteColumnStatisticsForTableOutput, error) {
	req, out := c.DeleteColumnStatisticsForTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectionRequest method.
//    req, resp := client.DeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection
func (c *Glue) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *DeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &DeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnection API operation for AWS Glue.
//
// Deletes a connection from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection
func (c *Glue) DeleteConnection(input *DeleteConnectionInput) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCrawler = "DeleteCrawler"

// DeleteCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCrawler for more information on using the DeleteCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCrawlerRequest method.
//    req, resp := client.DeleteCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler
func (c *Glue) DeleteCrawlerRequest(input *DeleteCrawlerInput) (req *request.Request, output *DeleteCrawlerOutput) {
	op := &request.Operation{
		Name:       opDeleteCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCrawlerInput{}
	}

	output = &DeleteCrawlerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCrawler API operation for AWS Glue.
//
// Removes a specified crawler from the Glue Data Catalog, unless the crawler
// state is RUNNING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteCrawler for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * CrawlerRunningException
//   The operation cannot be performed because the crawler is already running.
//
//   * SchedulerTransitioningException
//   The specified scheduler is transitioning.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler
func (c *Glue) DeleteCrawler(input *DeleteCrawlerInput) (*DeleteCrawlerOutput, error) {
	req, out := c.DeleteCrawlerRequest(input)
	return out, req.Send()
}

// DeleteCrawlerWithContext is the same as DeleteCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteCrawlerWithContext(ctx aws.Context, input *DeleteCrawlerInput, opts ...request.Option) (*DeleteCrawlerOutput, error) {
	req, out := c.DeleteCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatabase = "DeleteDatabase"

// DeleteDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatabase for more information on using the DeleteDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatabaseRequest method.
//    req, resp := client.DeleteDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase
func (c *Glue) DeleteDatabaseRequest(input *DeleteDatabaseInput) (req *request.Request, output *DeleteDatabaseOutput) {
	op := &request.Operation{
		Name:       opDeleteDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatabaseInput{}
	}

	output = &DeleteDatabaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatabase API operation for AWS Glue.
//
// Removes a specified database from a Data Catalog.
//
// After completing this operation, you no longer have access to the tables
// (and all table versions and partitions that might belong to the tables) and
// the user-defined functions in the deleted database. Glue deletes these "orphaned"
// resources asynchronously in a timely manner, at the discretion of the service.
//
// To ensure the immediate deletion of all related resources, before calling
// DeleteDatabase, use DeleteTableVersion or BatchDeleteTableVersion, DeletePartition
// or BatchDeletePartition, DeleteUserDefinedFunction, and DeleteTable or BatchDeleteTable,
// to delete any resources that belong to the database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteDatabase for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase
func (c *Glue) DeleteDatabase(input *DeleteDatabaseInput) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	return out, req.Send()
}

// DeleteDatabaseWithContext is the same as DeleteDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteDatabaseWithContext(ctx aws.Context, input *DeleteDatabaseInput, opts ...request.Option) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDevEndpoint = "DeleteDevEndpoint"

// DeleteDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDevEndpoint for more information on using the DeleteDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDevEndpointRequest method.
//    req, resp := client.DeleteDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint
func (c *Glue) DeleteDevEndpointRequest(input *DeleteDevEndpointInput) (req *request.Request, output *DeleteDevEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDevEndpointInput{}
	}

	output = &DeleteDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDevEndpoint API operation for AWS Glue.
//
// Deletes a specified development endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteDevEndpoint for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint
func (c *Glue) DeleteDevEndpoint(input *DeleteDevEndpointInput) (*DeleteDevEndpointOutput, error) {
	req, out := c.DeleteDevEndpointRequest(input)
	return out, req.Send()
}

// DeleteDevEndpointWithContext is the same as DeleteDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteDevEndpointWithContext(ctx aws.Context, input *DeleteDevEndpointInput, opts ...request.Option) (*DeleteDevEndpointOutput, error) {
	req, out := c.DeleteDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobRequest method.
//    req, resp := client.DeleteJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob
func (c *Glue) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteJob API operation for AWS Glue.
//
// Deletes a specified job definition. If the job definition is not found, no
// exception is thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob
func (c *Glue) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMLTransform = "DeleteMLTransform"

// DeleteMLTransformRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMLTransform operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMLTransform for more information on using the DeleteMLTransform
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMLTransformRequest method.
//    req, resp := client.DeleteMLTransformRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform
func (c *Glue) DeleteMLTransformRequest(input *DeleteMLTransformInput) (req *request.Request, output *DeleteMLTransformOutput) {
	op := &request.Operation{
		Name:       opDeleteMLTransform,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMLTransformInput{}
	}

	output = &DeleteMLTransformOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMLTransform API operation for AWS Glue.
//
// Deletes an Glue machine learning transform. Machine learning transforms are
// a special type of transform that use machine learning to learn the details
// of the transformation to be performed by learning from examples provided
// by humans. These transformations are then saved by Glue. If you no longer
// need a transform, you can delete it by calling DeleteMLTransforms. However,
// any Glue jobs that still reference the deleted transform will no longer succeed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteMLTransform for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform
func (c *Glue) DeleteMLTransform(input *DeleteMLTransformInput) (*DeleteMLTransformOutput, error) {
	req, out := c.DeleteMLTransformRequest(input)
	return out, req.Send()
}

// DeleteMLTransformWithContext is the same as DeleteMLTransform with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMLTransform for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteMLTransformWithContext(ctx aws.Context, input *DeleteMLTransformInput, opts ...request.Option) (*DeleteMLTransformOutput, error) {
	req, out := c.DeleteMLTransformRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePartition = "DeletePartition"

// DeletePartitionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePartition for more information on using the DeletePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePartitionRequest method.
//    req, resp := client.DeletePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition
func (c *Glue) DeletePartitionRequest(input *DeletePartitionInput) (req *request.Request, output *DeletePartitionOutput) {
	op := &request.Operation{
		Name:       opDeletePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePartitionInput{}
	}

	output = &DeletePartitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePartition API operation for AWS Glue.
//
// Deletes a specified partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeletePartition for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition
func (c *Glue) DeletePartition(input *DeletePartitionInput) (*DeletePartitionOutput, error) {
	req, out := c.DeletePartitionRequest(input)
	return out, req.Send()
}

// DeletePartitionWithContext is the same as DeletePartition with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeletePartitionWithContext(ctx aws.Context, input *DeletePartitionInput, opts ...request.Option) (*DeletePartitionOutput, error) {
	req, out := c.DeletePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePartitionIndex = "DeletePartitionIndex"

// DeletePartitionIndexRequest generates a "aws/request.Request" representing the
// client's request for the DeletePartitionIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePartitionIndex for more information on using the DeletePartitionIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePartitionIndexRequest method.
//    req, resp := client.DeletePartitionIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionIndex
func (c *Glue) DeletePartitionIndexRequest(input *DeletePartitionIndexInput) (req *request.Request, output *DeletePartitionIndexOutput) {
	op := &request.Operation{
		Name:       opDeletePartitionIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePartitionIndexInput{}
	}

	output = &DeletePartitionIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePartitionIndex API operation for AWS Glue.
//
// Deletes a specified partition index from an existing table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeletePartitionIndex for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ConflictException
//   The CreatePartitions API was called on a table that has indexes enabled.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionIndex
func (c *Glue) DeletePartitionIndex(input *DeletePartitionIndexInput) (*DeletePartitionIndexOutput, error) {
	req, out := c.DeletePartitionIndexRequest(input)
	return out, req.Send()
}

// DeletePartitionIndexWithContext is the same as DeletePartitionIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePartitionIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeletePartitionIndexWithContext(ctx aws.Context, input *DeletePartitionIndexInput, opts ...request.Option) (*DeletePartitionIndexOutput, error) {
	req, out := c.DeletePartitionIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegistry = "DeleteRegistry"

// DeleteRegistryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegistry for more information on using the DeleteRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegistryRequest method.
//    req, resp := client.DeleteRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteRegistry
func (c *Glue) DeleteRegistryRequest(input *DeleteRegistryInput) (req *request.Request, output *DeleteRegistryOutput) {
	op := &request.Operation{
		Name:       opDeleteRegistry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRegistryInput{}
	}

	output = &DeleteRegistryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRegistry API operation for AWS Glue.
//
// Delete the entire registry including schema and all of its versions. To get
// the status of the delete operation, you can call the GetRegistry API after
// the asynchronous call. Deleting a registry will deactivate all online operations
// for the registry such as the UpdateRegistry, CreateSchema, UpdateSchema,
// and RegisterSchemaVersion APIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteRegistry for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteRegistry
func (c *Glue) DeleteRegistry(input *DeleteRegistryInput) (*DeleteRegistryOutput, error) {
	req, out := c.DeleteRegistryRequest(input)
	return out, req.Send()
}

// DeleteRegistryWithContext is the same as DeleteRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteRegistryWithContext(ctx aws.Context, input *DeleteRegistryInput, opts ...request.Option) (*DeleteRegistryOutput, error) {
	req, out := c.DeleteRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourcePolicyRequest method.
//    req, resp := client.DeleteResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteResourcePolicy
func (c *Glue) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for AWS Glue.
//
// Deletes a specified policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * ConditionCheckFailureException
//   A specified condition was not satisfied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteResourcePolicy
func (c *Glue) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchema = "DeleteSchema"

// DeleteSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchema for more information on using the DeleteSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSchemaRequest method.
//    req, resp := client.DeleteSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchema
func (c *Glue) DeleteSchemaRequest(input *DeleteSchemaInput) (req *request.Request, output *DeleteSchemaOutput) {
	op := &request.Operation{
		Name:       opDeleteSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSchemaInput{}
	}

	output = &DeleteSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSchema API operation for AWS Glue.
//
// Deletes the entire schema set, including the schema set and all of its versions.
// To get the status of the delete operation, you can call GetSchema API after
// the asynchronous call. Deleting a registry will deactivate all online operations
// for the schema, such as the GetSchemaByDefinition, and RegisterSchemaVersion
// APIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteSchema for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchema
func (c *Glue) DeleteSchema(input *DeleteSchemaInput) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	return out, req.Send()
}

// DeleteSchemaWithContext is the same as DeleteSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteSchemaWithContext(ctx aws.Context, input *DeleteSchemaInput, opts ...request.Option) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchemaVersions = "DeleteSchemaVersions"

// DeleteSchemaVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchemaVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchemaVersions for more information on using the DeleteSchemaVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSchemaVersionsRequest method.
//    req, resp := client.DeleteSchemaVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchemaVersions
func (c *Glue) DeleteSchemaVersionsRequest(input *DeleteSchemaVersionsInput) (req *request.Request, output *DeleteSchemaVersionsOutput) {
	op := &request.Operation{
		Name:       opDeleteSchemaVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSchemaVersionsInput{}
	}

	output = &DeleteSchemaVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSchemaVersions API operation for AWS Glue.
//
// Remove versions from the specified schema. A version number or range may
// be supplied. If the compatibility mode forbids deleting of a version that
// is necessary, such as BACKWARDS_FULL, an error is returned. Calling the GetSchemaVersions
// API after this call will list the status of the deleted versions.
//
// When the range of version numbers contain check pointed version, the API
// will return a 409 conflict and will not proceed with the deletion. You have
// to remove the checkpoint first using the DeleteSchemaCheckpoint API before
// using this API.
//
// You cannot use the DeleteSchemaVersions API to delete the first schema version
// in the schema set. The first schema version can only be deleted by the DeleteSchema
// API. This operation will also delete the attached SchemaVersionMetadata under
// the schema versions. Hard deletes will be enforced on the database.
//
// If the compatibility mode forbids deleting of a version that is necessary,
// such as BACKWARDS_FULL, an error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteSchemaVersions for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchemaVersions
func (c *Glue) DeleteSchemaVersions(input *DeleteSchemaVersionsInput) (*DeleteSchemaVersionsOutput, error) {
	req, out := c.DeleteSchemaVersionsRequest(input)
	return out, req.Send()
}

// DeleteSchemaVersionsWithContext is the same as DeleteSchemaVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchemaVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteSchemaVersionsWithContext(ctx aws.Context, input *DeleteSchemaVersionsInput, opts ...request.Option) (*DeleteSchemaVersionsOutput, error) {
	req, out := c.DeleteSchemaVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityConfiguration = "DeleteSecurityConfiguration"

// DeleteSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityConfiguration for more information on using the DeleteSecurityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSecurityConfigurationRequest method.
//    req, resp := client.DeleteSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSecurityConfiguration
func (c *Glue) DeleteSecurityConfigurationRequest(input *DeleteSecurityConfigurationInput) (req *request.Request, output *DeleteSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityConfigurationInput{}
	}

	output = &DeleteSecurityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityConfiguration API operation for AWS Glue.
//
// Deletes a specified security configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteSecurityConfiguration for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSecurityConfiguration
func (c *Glue) DeleteSecurityConfiguration(input *DeleteSecurityConfigurationInput) (*DeleteSecurityConfigurationOutput, error) {
	req, out := c.DeleteSecurityConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSecurityConfigurationWithContext is the same as DeleteSecurityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteSecurityConfigurationWithContext(ctx aws.Context, input *DeleteSecurityConfigurationInput, opts ...request.Option) (*DeleteSecurityConfigurationOutput, error) {
	req, out := c.DeleteSecurityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSession = "DeleteSession"

// DeleteSessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSession for more information on using the DeleteSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSessionRequest method.
//    req, resp := client.DeleteSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSession
func (c *Glue) DeleteSessionRequest(input *DeleteSessionInput) (req *request.Request, output *DeleteSessionOutput) {
	op := &request.Operation{
		Name:       opDeleteSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSessionInput{}
	}

	output = &DeleteSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSession API operation for AWS Glue.
//
// Deletes the session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteSession for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * IllegalSessionStateException
//   The session is in an invalid state to perform a requested operation.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSession
func (c *Glue) DeleteSession(input *DeleteSessionInput) (*DeleteSessionOutput, error) {
	req, out := c.DeleteSessionRequest(input)
	return out, req.Send()
}

// DeleteSessionWithContext is the same as DeleteSession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteSessionWithContext(ctx aws.Context, input *DeleteSessionInput, opts ...request.Option) (*DeleteSessionOutput, error) {
	req, out := c.DeleteSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTable for more information on using the DeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTableRequest method.
//    req, resp := client.DeleteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable
func (c *Glue) DeleteTableRequest(input *DeleteTableInput) (req *request.Request, output *DeleteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	output = &DeleteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTable API operation for AWS Glue.
//
// Removes a table definition from the Data Catalog.
//
// After completing this operation, you no longer have access to the table versions
// and partitions that belong to the deleted table. Glue deletes these "orphaned"
// resources asynchronously in a timely manner, at the discretion of the service.
//
// To ensure the immediate deletion of all related resources, before calling
// DeleteTable, use DeleteTableVersion or BatchDeleteTableVersion, and DeletePartition
// or BatchDeletePartition, to delete any resources that belong to the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteTable for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * ResourceNotReadyException
//   A resource was not ready for a transaction.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable
func (c *Glue) DeleteTable(input *DeleteTableInput) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	return out, req.Send()
}

// DeleteTableWithContext is the same as DeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteTableWithContext(ctx aws.Context, input *DeleteTableInput, opts ...request.Option) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTableVersion = "DeleteTableVersion"

// DeleteTableVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTableVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTableVersion for more information on using the DeleteTableVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTableVersionRequest method.
//    req, resp := client.DeleteTableVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion
func (c *Glue) DeleteTableVersionRequest(input *DeleteTableVersionInput) (req *request.Request, output *DeleteTableVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableVersionInput{}
	}

	output = &DeleteTableVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTableVersion API operation for AWS Glue.
//
// Deletes a specified version of a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteTableVersion for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion
func (c *Glue) DeleteTableVersion(input *DeleteTableVersionInput) (*DeleteTableVersionOutput, error) {
	req, out := c.DeleteTableVersionRequest(input)
	return out, req.Send()
}

// DeleteTableVersionWithContext is the same as DeleteTableVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTableVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteTableVersionWithContext(ctx aws.Context, input *DeleteTableVersionInput, opts ...request.Option) (*DeleteTableVersionOutput, error) {
	req, out := c.DeleteTableVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrigger = "DeleteTrigger"

// DeleteTriggerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrigger for more information on using the DeleteTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTriggerRequest method.
//    req, resp := client.DeleteTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger
func (c *Glue) DeleteTriggerRequest(input *DeleteTriggerInput) (req *request.Request, output *DeleteTriggerOutput) {
	op := &request.Operation{
		Name:       opDeleteTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTriggerInput{}
	}

	output = &DeleteTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrigger API operation for AWS Glue.
//
// Deletes a specified trigger. If the trigger is not found, no exception is
// thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteTrigger for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger
func (c *Glue) DeleteTrigger(input *DeleteTriggerInput) (*DeleteTriggerOutput, error) {
	req, out := c.DeleteTriggerRequest(input)
	return out, req.Send()
}

// DeleteTriggerWithContext is the same as DeleteTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteTriggerWithContext(ctx aws.Context, input *DeleteTriggerInput, opts ...request.Option) (*DeleteTriggerOutput, error) {
	req, out := c.DeleteTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserDefinedFunction = "DeleteUserDefinedFunction"

// DeleteUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserDefinedFunction for more information on using the DeleteUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserDefinedFunctionRequest method.
//    req, resp := client.DeleteUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction
func (c *Glue) DeleteUserDefinedFunctionRequest(input *DeleteUserDefinedFunctionInput) (req *request.Request, output *DeleteUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserDefinedFunctionInput{}
	}

	output = &DeleteUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserDefinedFunction API operation for AWS Glue.
//
// Deletes an existing function definition from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteUserDefinedFunction for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction
func (c *Glue) DeleteUserDefinedFunction(input *DeleteUserDefinedFunctionInput) (*DeleteUserDefinedFunctionOutput, error) {
	req, out := c.DeleteUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// DeleteUserDefinedFunctionWithContext is the same as DeleteUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteUserDefinedFunctionWithContext(ctx aws.Context, input *DeleteUserDefinedFunctionInput, opts ...request.Option) (*DeleteUserDefinedFunctionOutput, error) {
	req, out := c.DeleteUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkflow = "DeleteWorkflow"

// DeleteWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkflow for more information on using the DeleteWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkflowRequest method.
//    req, resp := client.DeleteWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow
func (c *Glue) DeleteWorkflowRequest(input *DeleteWorkflowInput) (req *request.Request, output *DeleteWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkflowInput{}
	}

	output = &DeleteWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWorkflow API operation for AWS Glue.
//
// Deletes a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteWorkflow for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow
func (c *Glue) DeleteWorkflow(input *DeleteWorkflowInput) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	return out, req.Send()
}

// DeleteWorkflowWithContext is the same as DeleteWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteWorkflowWithContext(ctx aws.Context, input *DeleteWorkflowInput, opts ...request.Option) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlueprint = "GetBlueprint"

// GetBlueprintRequest generates a "aws/request.Request" representing the
// client's request for the GetBlueprint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlueprint for more information on using the GetBlueprint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlueprintRequest method.
//    req, resp := client.GetBlueprintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprint
func (c *Glue) GetBlueprintRequest(input *GetBlueprintInput) (req *request.Request, output *GetBlueprintOutput) {
	op := &request.Operation{
		Name:       opGetBlueprint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlueprintInput{}
	}

	output = &GetBlueprintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlueprint API operation for AWS Glue.
//
// Retrieves the details of a blueprint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetBlueprint for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprint
func (c *Glue) GetBlueprint(input *GetBlueprintInput) (*GetBlueprintOutput, error) {
	req, out := c.GetBlueprintRequest(input)
	return out, req.Send()
}

// GetBlueprintWithContext is the same as GetBlueprint with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlueprint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetBlueprintWithContext(ctx aws.Context, input *GetBlueprintInput, opts ...request.Option) (*GetBlueprintOutput, error) {
	req, out := c.GetBlueprintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlueprintRun = "GetBlueprintRun"

// GetBlueprintRunRequest generates a "aws/request.Request" representing the
// client's request for the GetBlueprintRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlueprintRun for more information on using the GetBlueprintRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlueprintRunRequest method.
//    req, resp := client.GetBlueprintRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRun
func (c *Glue) GetBlueprintRunRequest(input *GetBlueprintRunInput) (req *request.Request, output *GetBlueprintRunOutput) {
	op := &request.Operation{
		Name:       opGetBlueprintRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlueprintRunInput{}
	}

	output = &GetBlueprintRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlueprintRun API operation for AWS Glue.
//
// Retrieves the details of a blueprint run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetBlueprintRun for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRun
func (c *Glue) GetBlueprintRun(input *GetBlueprintRunInput) (*GetBlueprintRunOutput, error) {
	req, out := c.GetBlueprintRunRequest(input)
	return out, req.Send()
}

// GetBlueprintRunWithContext is the same as GetBlueprintRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlueprintRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetBlueprintRunWithContext(ctx aws.Context, input *GetBlueprintRunInput, opts ...request.Option) (*GetBlueprintRunOutput, error) {
	req, out := c.GetBlueprintRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlueprintRuns = "GetBlueprintRuns"

// GetBlueprintRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetBlueprintRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlueprintRuns for more information on using the GetBlueprintRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlueprintRunsRequest method.
//    req, resp := client.GetBlueprintRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRuns
func (c *Glue) GetBlueprintRunsRequest(input *GetBlueprintRunsInput) (req *request.Request, output *GetBlueprintRunsOutput) {
	op := &request.Operation{
		Name:       opGetBlueprintRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBlueprintRunsInput{}
	}

	output = &GetBlueprintRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlueprintRuns API operation for AWS Glue.
//
// Retrieves the details of blueprint runs for a specified blueprint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetBlueprintRuns for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRuns
func (c *Glue) GetBlueprintRuns(input *GetBlueprintRunsInput) (*GetBlueprintRunsOutput, error) {
	req, out := c.GetBlueprintRunsRequest(input)
	return out, req.Send()
}

// GetBlueprintRunsWithContext is the same as GetBlueprintRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlueprintRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetBlueprintRunsWithContext(ctx aws.Context, input *GetBlueprintRunsInput, opts ...request.Option) (*GetBlueprintRunsOutput, error) {
	req, out := c.GetBlueprintRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBlueprintRunsPages iterates over the pages of a GetBlueprintRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBlueprintRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBlueprintRuns operation.
//    pageNum := 0
//    err := client.GetBlueprintRunsPages(params,
//        func(page *glue.GetBlueprintRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetBlueprintRunsPages(input *GetBlueprintRunsInput, fn func(*GetBlueprintRunsOutput, bool) bool) error {
	return c.GetBlueprintRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBlueprintRunsPagesWithContext same as GetBlueprintRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetBlueprintRunsPagesWithContext(ctx aws.Context, input *GetBlueprintRunsInput, fn func(*GetBlueprintRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBlueprintRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBlueprintRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBlueprintRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCatalogImportStatus = "GetCatalogImportStatus"

// GetCatalogImportStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetCatalogImportStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCatalogImportStatus for more information on using the GetCatalogImportStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCatalogImportStatusRequest method.
//    req, resp := client.GetCatalogImportStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus
func (c *Glue) GetCatalogImportStatusRequest(input *GetCatalogImportStatusInput) (req *request.Request, output *GetCatalogImportStatusOutput) {
	op := &request.Operation{
		Name:       opGetCatalogImportStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCatalogImportStatusInput{}
	}

	output = &GetCatalogImportStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCatalogImportStatus API operation for AWS Glue.
//
// Retrieves the status of a migration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCatalogImportStatus for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus
func (c *Glue) GetCatalogImportStatus(input *GetCatalogImportStatusInput) (*GetCatalogImportStatusOutput, error) {
	req, out := c.GetCatalogImportStatusRequest(input)
	return out, req.Send()
}

// GetCatalogImportStatusWithContext is the same as GetCatalogImportStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetCatalogImportStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCatalogImportStatusWithContext(ctx aws.Context, input *GetCatalogImportStatusInput, opts ...request.Option) (*GetCatalogImportStatusOutput, error) {
	req, out := c.GetCatalogImportStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClassifier = "GetClassifier"

// GetClassifierRequest generates a "aws/request.Request" representing the
// client's request for the GetClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClassifier for more information on using the GetClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClassifierRequest method.
//    req, resp := client.GetClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier
func (c *Glue) GetClassifierRequest(input *GetClassifierInput) (req *request.Request, output *GetClassifierOutput) {
	op := &request.Operation{
		Name:       opGetClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetClassifierInput{}
	}

	output = &GetClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClassifier API operation for AWS Glue.
//
// Retrieve a classifier by name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetClassifier for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier
func (c *Glue) GetClassifier(input *GetClassifierInput) (*GetClassifierOutput, error) {
	req, out := c.GetClassifierRequest(input)
	return out, req.Send()
}

// GetClassifierWithContext is the same as GetClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See GetClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetClassifierWithContext(ctx aws.Context, input *GetClassifierInput, opts ...request.Option) (*GetClassifierOutput, error) {
	req, out := c.GetClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClassifiers = "GetClassifiers"

// GetClassifiersRequest generates a "aws/request.Request" representing the
// client's request for the GetClassifiers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClassifiers for more information on using the GetClassifiers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClassifiersRequest method.
//    req, resp := client.GetClassifiersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers
func (c *Glue) GetClassifiersRequest(input *GetClassifiersInput) (req *request.Request, output *GetClassifiersOutput) {
	op := &request.Operation{
		Name:       opGetClassifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetClassifiersInput{}
	}

	output = &GetClassifiersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClassifiers API operation for AWS Glue.
//
// Lists all classifier objects in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetClassifiers for usage and error information.
//
// Returned Error Types:
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers
func (c *Glue) GetClassifiers(input *GetClassifiersInput) (*GetClassifiersOutput, error) {
	req, out := c.GetClassifiersRequest(input)
	return out, req.Send()
}

// GetClassifiersWithContext is the same as GetClassifiers with the addition of
// the ability to pass a context and additional request options.
//
// See GetClassifiers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetClassifiersWithContext(ctx aws.Context, input *GetClassifiersInput, opts ...request.Option) (*GetClassifiersOutput, error) {
	req, out := c.GetClassifiersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetClassifiersPages iterates over the pages of a GetClassifiers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetClassifiers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetClassifiers operation.
//    pageNum := 0
//    err := client.GetClassifiersPages(params,
//        func(page *glue.GetClassifiersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetClassifiersPages(input *GetClassifiersInput, fn func(*GetClassifiersOutput, bool) bool) error {
	return c.GetClassifiersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetClassifiersPagesWithContext same as GetClassifiersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetClassifiersPagesWithContext(ctx aws.Context, input *GetClassifiersInput, fn func(*GetClassifiersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetClassifiersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetClassifiersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetClassifiersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetColumnStatisticsForPartition = "GetColumnStatisticsForPartition"

// GetColumnStatisticsForPartitionRequest generates a "aws/request.Request" representing the
// client's request for the GetColumnStatisticsForPartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetColumnStatisticsForPartition for more information on using the GetColumnStatisticsForPartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetColumnStatisticsForPartitionRequest method.
//    req, resp := client.GetColumnStatisticsForPartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForPartition
func (c *Glue) GetColumnStatisticsForPartitionRequest(input *GetColumnStatisticsForPartitionInput) (req *request.Request, output *GetColumnStatisticsForPartitionOutput) {
	op := &request.Operation{
		Name:       opGetColumnStatisticsForPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetColumnStatisticsForPartitionInput{}
	}

	output = &GetColumnStatisticsForPartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetColumnStatisticsForPartition API operation for AWS Glue.
//
// Retrieves partition statistics of columns.
//
// The Identity and Access Management (IAM) permission required for this operation
// is GetPartition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetColumnStatisticsForPartition for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForPartition
func (c *Glue) GetColumnStatisticsForPartition(input *GetColumnStatisticsForPartitionInput) (*GetColumnStatisticsForPartitionOutput, error) {
	req, out := c.GetColumnStatisticsForPartitionRequest(input)
	return out, req.Send()
}

// GetColumnStatisticsForPartitionWithContext is the same as GetColumnStatisticsForPartition with the addition of
// the ability to pass a context and additional request options.
//
// See GetColumnStatisticsForPartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetColumnStatisticsForPartitionWithContext(ctx aws.Context, input *GetColumnStatisticsForPartitionInput, opts ...request.Option) (*GetColumnStatisticsForPartitionOutput, error) {
	req, out := c.GetColumnStatisticsForPartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetColumnStatisticsForTable = "GetColumnStatisticsForTable"

// GetColumnStatisticsForTableRequest generates a "aws/request.Request" representing the
// client's request for the GetColumnStatisticsForTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetColumnStatisticsForTable for more information on using the GetColumnStatisticsForTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetColumnStatisticsForTableRequest method.
//    req, resp := client.GetColumnStatisticsForTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForTable
func (c *Glue) GetColumnStatisticsForTableRequest(input *GetColumnStatisticsForTableInput) (req *request.Request, output *GetColumnStatisticsForTableOutput) {
	op := &request.Operation{
		Name:       opGetColumnStatisticsForTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetColumnStatisticsForTableInput{}
	}

	output = &GetColumnStatisticsForTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetColumnStatisticsForTable API operation for AWS Glue.
//
// Retrieves table statistics of columns.
//
// The Identity and Access Management (IAM) permission required for this operation
// is GetTable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetColumnStatisticsForTable for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForTable
func (c *Glue) GetColumnStatisticsForTable(input *GetColumnStatisticsForTableInput) (*GetColumnStatisticsForTableOutput, error) {
	req, out := c.GetColumnStatisticsForTableRequest(input)
	return out, req.Send()
}

// GetColumnStatisticsForTableWithContext is the same as GetColumnStatisticsForTable with the addition of
// the ability to pass a context and additional request options.
//
// See GetColumnStatisticsForTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetColumnStatisticsForTableWithContext(ctx aws.Context, input *GetColumnStatisticsForTableInput, opts ...request.Option) (*GetColumnStatisticsForTableOutput, error) {
	req, out := c.GetColumnStatisticsForTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnection = "GetConnection"

// GetConnectionRequest generates a "aws/request.Request" representing the
// client's request for the GetConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnection for more information on using the GetConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectionRequest method.
//    req, resp := client.GetConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection
func (c *Glue) GetConnectionRequest(input *GetConnectionInput) (req *request.Request, output *GetConnectionOutput) {
	op := &request.Operation{
		Name:       opGetConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConnectionInput{}
	}

	output = &GetConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnection API operation for AWS Glue.
//
// Retrieves a connection definition from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetConnection for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection
func (c *Glue) GetConnection(input *GetConnectionInput) (*GetConnectionOutput, error) {
	req, out := c.GetConnectionRequest(input)
	return out, req.Send()
}

// GetConnectionWithContext is the same as GetConnection with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetConnectionWithContext(ctx aws.Context, input *GetConnectionInput, opts ...request.Option) (*GetConnectionOutput, error) {
	req, out := c.GetConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnections = "GetConnections"

// GetConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the GetConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnections for more information on using the GetConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectionsRequest method.
//    req, resp := client.GetConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections
func (c *Glue) GetConnectionsRequest(input *GetConnectionsInput) (req *request.Request, output *GetConnectionsOutput) {
	op := &request.Operation{
		Name:       opGetConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConnectionsInput{}
	}

	output = &GetConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnections API operation for AWS Glue.
//
// Retrieves a list of connection definitions from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetConnections for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections
func (c *Glue) GetConnections(input *GetConnectionsInput) (*GetConnectionsOutput, error) {
	req, out := c.GetConnectionsRequest(input)
	return out, req.Send()
}

// GetConnectionsWithContext is the same as GetConnections with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetConnectionsWithContext(ctx aws.Context, input *GetConnectionsInput, opts ...request.Option) (*GetConnectionsOutput, error) {
	req, out := c.GetConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetConnectionsPages iterates over the pages of a GetConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetConnections operation.
//    pageNum := 0
//    err := client.GetConnectionsPages(params,
//        func(page *glue.GetConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetConnectionsPages(input *GetConnectionsInput, fn func(*GetConnectionsOutput, bool) bool) error {
	return c.GetConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetConnectionsPagesWithContext same as GetConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetConnectionsPagesWithContext(ctx aws.Context, input *GetConnectionsInput, fn func(*GetConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCrawler = "GetCrawler"

// GetCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the GetCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCrawler for more information on using the GetCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCrawlerRequest method.
//    req, resp := client.GetCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler
func (c *Glue) GetCrawlerRequest(input *GetCrawlerInput) (req *request.Request, output *GetCrawlerOutput) {
	op := &request.Operation{
		Name:       opGetCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCrawlerInput{}
	}

	output = &GetCrawlerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCrawler API operation for AWS Glue.
//
// Retrieves metadata for a specified crawler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCrawler for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler
func (c *Glue) GetCrawler(input *GetCrawlerInput) (*GetCrawlerOutput, error) {
	req, out := c.GetCrawlerRequest(input)
	return out, req.Send()
}

// GetCrawlerWithContext is the same as GetCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See GetCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlerWithContext(ctx aws.Context, input *GetCrawlerInput, opts ...request.Option) (*GetCrawlerOutput, error) {
	req, out := c.GetCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCrawlerMetrics = "GetCrawlerMetrics"

// GetCrawlerMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetCrawlerMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCrawlerMetrics for more information on using the GetCrawlerMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCrawlerMetricsRequest method.
//    req, resp := client.GetCrawlerMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics
func (c *Glue) GetCrawlerMetricsRequest(input *GetCrawlerMetricsInput) (req *request.Request, output *GetCrawlerMetricsOutput) {
	op := &request.Operation{
		Name:       opGetCrawlerMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCrawlerMetricsInput{}
	}

	output = &GetCrawlerMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCrawlerMetrics API operation for AWS Glue.
//
// Retrieves metrics about specified crawlers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCrawlerMetrics for usage and error information.
//
// Returned Error Types:
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics
func (c *Glue) GetCrawlerMetrics(input *GetCrawlerMetricsInput) (*GetCrawlerMetricsOutput, error) {
	req, out := c.GetCrawlerMetricsRequest(input)
	return out, req.Send()
}

// GetCrawlerMetricsWithContext is the same as GetCrawlerMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetCrawlerMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlerMetricsWithContext(ctx aws.Context, input *GetCrawlerMetricsInput, opts ...request.Option) (*GetCrawlerMetricsOutput, error) {
	req, out := c.GetCrawlerMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCrawlerMetricsPages iterates over the pages of a GetCrawlerMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCrawlerMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCrawlerMetrics operation.
//    pageNum := 0
//    err := client.GetCrawlerMetricsPages(params,
//        func(page *glue.GetCrawlerMetricsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetCrawlerMetricsPages(input *GetCrawlerMetricsInput, fn func(*GetCrawlerMetricsOutput, bool) bool) error {
	return c.GetCrawlerMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCrawlerMetricsPagesWithContext same as GetCrawlerMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlerMetricsPagesWithContext(ctx aws.Context, input *GetCrawlerMetricsInput, fn func(*GetCrawlerMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCrawlerMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCrawlerMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCrawlerMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCrawlers = "GetCrawlers"

// GetCrawlersRequest generates a "aws/request.Request" representing the
// client's request for the GetCrawlers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCrawlers for more information on using the GetCrawlers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCrawlersRequest method.
//    req, resp := client.GetCrawlersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers
func (c *Glue) GetCrawlersRequest(input *GetCrawlersInput) (req *request.Request, output *GetCrawlersOutput) {
	op := &request.Operation{
		Name:       opGetCrawlers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCrawlersInput{}
	}

	output = &GetCrawlersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCrawlers API operation for AWS Glue.
//
// Retrieves metadata for all crawlers defined in the customer account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCrawlers for usage and error information.
//
// Returned Error Types:
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers
func (c *Glue) GetCrawlers(input *GetCrawlersInput) (*GetCrawlersOutput, error) {
	req, out := c.GetCrawlersRequest(input)
	return out, req.Send()
}

// GetCrawlersWithContext is the same as GetCrawlers with the addition of
// the ability to pass a context and additional request options.
//
// See GetCrawlers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlersWithContext(ctx aws.Context, input *GetCrawlersInput, opts ...request.Option) (*GetCrawlersOutput, error) {
	req, out := c.GetCrawlersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCrawlersPages iterates over the pages of a GetCrawlers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCrawlers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCrawlers operation.
//    pageNum := 0
//    err := client.GetCrawlersPages(params,
//        func(page *glue.GetCrawlersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetCrawlersPages(input *GetCrawlersInput, fn func(*GetCrawlersOutput, bool) bool) error {
	return c.GetCrawlersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCrawlersPagesWithContext same as GetCrawlersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlersPagesWithContext(ctx aws.Context, input *GetCrawlersInput, fn func(*GetCrawlersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCrawlersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCrawlersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCrawlersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDataCatalogEncryptionSettings = "GetDataCatalogEncryptionSettings"

// GetDataCatalogEncryptionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetDataCatalogEncryptionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataCatalogEncryptionSettings for more information on using the GetDataCatalogEncryptionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataCatalogEncryptionSettingsRequest method.
//    req, resp := client.GetDataCatalogEncryptionSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings
func (c *Glue) GetDataCatalogEncryptionSettingsRequest(input *GetDataCatalogEncryptionSettingsInput) (req *request.Request, output *GetDataCatalogEncryptionSettingsOutput) {
	op := &request.Operation{
		Name:       opGetDataCatalogEncryptionSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataCatalogEncryptionSettingsInput{}
	}

	output = &GetDataCatalogEncryptionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataCatalogEncryptionSettings API operation for AWS Glue.
//
// Retrieves the security configuration for a specified catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDataCatalogEncryptionSettings for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings
func (c *Glue) GetDataCatalogEncryptionSettings(input *GetDataCatalogEncryptionSettingsInput) (*GetDataCatalogEncryptionSettingsOutput, error) {
	req, out := c.GetDataCatalogEncryptionSettingsRequest(input)
	return out, req.Send()
}

// GetDataCatalogEncryptionSettingsWithContext is the same as GetDataCatalogEncryptionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataCatalogEncryptionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDataCatalogEncryptionSettingsWithContext(ctx aws.Context, input *GetDataCatalogEncryptionSettingsInput, opts ...request.Option) (*GetDataCatalogEncryptionSettingsOutput, error) {
	req, out := c.GetDataCatalogEncryptionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatabase = "GetDatabase"

// GetDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the GetDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatabase for more information on using the GetDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDatabaseRequest method.
//    req, resp := client.GetDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase
func (c *Glue) GetDatabaseRequest(input *GetDatabaseInput) (req *request.Request, output *GetDatabaseOutput) {
	op := &request.Operation{
		Name:       opGetDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDatabaseInput{}
	}

	output = &GetDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatabase API operation for AWS Glue.
//
// Retrieves the definition of a specified database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDatabase for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase
func (c *Glue) GetDatabase(input *GetDatabaseInput) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	return out, req.Send()
}

// GetDatabaseWithContext is the same as GetDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDatabaseWithContext(ctx aws.Context, input *GetDatabaseInput, opts ...request.Option) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatabases = "GetDatabases"

// GetDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the GetDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatabases for more information on using the GetDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDatabasesRequest method.
//    req, resp := client.GetDatabasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases
func (c *Glue) GetDatabasesRequest(input *GetDatabasesInput) (req *request.Request, output *GetDatabasesOutput) {
	op := &request.Operation{
		Name:       opGetDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDatabasesInput{}
	}

	output = &GetDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatabases API operation for AWS Glue.
//
// Retrieves all databases defined in a given Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDatabases for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases
func (c *Glue) GetDatabases(input *GetDatabasesInput) (*GetDatabasesOutput, error) {
	req, out := c.GetDatabasesRequest(input)
	return out, req.Send()
}

// GetDatabasesWithContext is the same as GetDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDatabasesWithContext(ctx aws.Context, input *GetDatabasesInput, opts ...request.Option) (*GetDatabasesOutput, error) {
	req, out := c.GetDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDatabasesPages iterates over the pages of a GetDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDatabases operation.
//    pageNum := 0
//    err := client.GetDatabasesPages(params,
//        func(page *glue.GetDatabasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetDatabasesPages(input *GetDatabasesInput, fn func(*GetDatabasesOutput, bool) bool) error {
	return c.GetDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDatabasesPagesWithContext same as GetDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDatabasesPagesWithContext(ctx aws.Context, input *GetDatabasesInput, fn func(*GetDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDataflowGraph = "GetDataflowGraph"

// GetDataflowGraphRequest generates a "aws/request.Request" representing the
// client's request for the GetDataflowGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataflowGraph for more information on using the GetDataflowGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataflowGraphRequest method.
//    req, resp := client.GetDataflowGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph
func (c *Glue) GetDataflowGraphRequest(input *GetDataflowGraphInput) (req *request.Request, output *GetDataflowGraphOutput) {
	op := &request.Operation{
		Name:       opGetDataflowGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataflowGraphInput{}
	}

	output = &GetDataflowGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataflowGraph API operation for AWS Glue.
//
// Transforms a Python script into a directed acyclic graph (DAG).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDataflowGraph for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph
func (c *Glue) GetDataflowGraph(input *GetDataflowGraphInput) (*GetDataflowGraphOutput, error) {
	req, out := c.GetDataflowGraphRequest(input)
	return out, req.Send()
}

// GetDataflowGraphWithContext is the same as GetDataflowGraph with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataflowGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDataflowGraphWithContext(ctx aws.Context, input *GetDataflowGraphInput, opts ...request.Option) (*GetDataflowGraphOutput, error) {
	req, out := c.GetDataflowGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevEndpoint = "GetDevEndpoint"

// GetDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevEndpoint for more information on using the GetDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDevEndpointRequest method.
//    req, resp := client.GetDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint
func (c *Glue) GetDevEndpointRequest(input *GetDevEndpointInput) (req *request.Request, output *GetDevEndpointOutput) {
	op := &request.Operation{
		Name:       opGetDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevEndpointInput{}
	}

	output = &GetDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevEndpoint API operation for AWS Glue.
//
// Retrieves information about a specified development endpoint.
//
// When you create a development endpoint in a virtual private cloud (VPC),
// Glue returns only a private IP address, and the public IP address field is
// not populated. When you create a non-VPC development endpoint, Glue returns
// only a public IP address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDevEndpoint for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint
func (c *Glue) GetDevEndpoint(input *GetDevEndpointInput) (*GetDevEndpointOutput, error) {
	req, out := c.GetDevEndpointRequest(input)
	return out, req.Send()
}

// GetDevEndpointWithContext is the same as GetDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDevEndpointWithContext(ctx aws.Context, input *GetDevEndpointInput, opts ...request.Option) (*GetDevEndpointOutput, error) {
	req, out := c.GetDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevEndpoints = "GetDevEndpoints"

// GetDevEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the GetDevEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevEndpoints for more information on using the GetDevEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDevEndpointsRequest method.
//    req, resp := client.GetDevEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints
func (c *Glue) GetDevEndpointsRequest(input *GetDevEndpointsInput) (req *request.Request, output *GetDevEndpointsOutput) {
	op := &request.Operation{
		Name:       opGetDevEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDevEndpointsInput{}
	}

	output = &GetDevEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevEndpoints API operation for AWS Glue.
//
// Retrieves all the development endpoints in this AWS account.
//
// When you create a development endpoint in a virtual private cloud (VPC),
// Glue returns only a private IP address and the public IP address field is
// not populated. When you create a non-VPC development endpoint, Glue returns
// only a public IP address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDevEndpoints for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints
func (c *Glue) GetDevEndpoints(input *GetDevEndpointsInput) (*GetDevEndpointsOutput, error) {
	req, out := c.GetDevEndpointsRequest(input)
	return out, req.Send()
}

// GetDevEndpointsWithContext is the same as GetDevEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDevEndpointsWithContext(ctx aws.Context, input *GetDevEndpointsInput, opts ...request.Option) (*GetDevEndpointsOutput, error) {
	req, out := c.GetDevEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDevEndpointsPages iterates over the pages of a GetDevEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDevEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDevEndpoints operation.
//    pageNum := 0
//    err := client.GetDevEndpointsPages(params,
//        func(page *glue.GetDevEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetDevEndpointsPages(input *GetDevEndpointsInput, fn func(*GetDevEndpointsOutput, bool) bool) error {
	return c.GetDevEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDevEndpointsPagesWithContext same as GetDevEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDevEndpointsPagesWithContext(ctx aws.Context, input *GetDevEndpointsInput, fn func(*GetDevEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDevEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDevEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDevEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetJob = "GetJob"

// GetJobRequest generates a "aws/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJob for more information on using the GetJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRequest method.
//    req, resp := client.GetJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob
func (c *Glue) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJob API operation for AWS Glue.
//
// Retrieves an existing job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob
func (c *Glue) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	return out, req.Send()
}

// GetJobWithContext is the same as GetJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobWithContext(ctx aws.Context, input *GetJobInput, opts ...request.Option) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobBookmark = "GetJobBookmark"

// GetJobBookmarkRequest generates a "aws/request.Request" representing the
// client's request for the GetJobBookmark operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobBookmark for more information on using the GetJobBookmark
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobBookmarkRequest method.
//    req, resp := client.GetJobBookmarkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark
func (c *Glue) GetJobBookmarkRequest(input *GetJobBookmarkInput) (req *request.Request, output *GetJobBookmarkOutput) {
	op := &request.Operation{
		Name:       opGetJobBookmark,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobBookmarkInput{}
	}

	output = &GetJobBookmarkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobBookmark API operation for AWS Glue.
//
// Returns information on a job bookmark entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJobBookmark for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ValidationException
//   A value could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark
func (c *Glue) GetJobBookmark(input *GetJobBookmarkInput) (*GetJobBookmarkOutput, error) {
	req, out := c.GetJobBookmarkRequest(input)
	return out, req.Send()
}

// GetJobBookmarkWithContext is the same as GetJobBookmark with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobBookmark for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobBookmarkWithContext(ctx aws.Context, input *GetJobBookmarkInput, opts ...request.Option) (*GetJobBookmarkOutput, error) {
	req, out := c.GetJobBookmarkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobRun = "GetJobRun"

// GetJobRunRequest generates a "aws/request.Request" representing the
// client's request for the GetJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobRun for more information on using the GetJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRunRequest method.
//    req, resp := client.GetJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun
func (c *Glue) GetJobRunRequest(input *GetJobRunInput) (req *request.Request, output *GetJobRunOutput) {
	op := &request.Operation{
		Name:       opGetJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobRunInput{}
	}

	output = &GetJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobRun API operation for AWS Glue.
//
// Retrieves the metadata for a given job run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJobRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun
func (c *Glue) GetJobRun(input *GetJobRunInput) (*GetJobRunOutput, error) {
	req, out := c.GetJobRunRequest(input)
	return out, req.Send()
}

// GetJobRunWithContext is the same as GetJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobRunWithContext(ctx aws.Context, input *GetJobRunInput, opts ...request.Option) (*GetJobRunOutput, error) {
	req, out := c.GetJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobRuns = "GetJobRuns"

// GetJobRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetJobRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobRuns for more information on using the GetJobRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRunsRequest method.
//    req, resp := client.GetJobRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns
func (c *Glue) GetJobRunsRequest(input *GetJobRunsInput) (req *request.Request, output *GetJobRunsOutput) {
	op := &request.Operation{
		Name:       opGetJobRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetJobRunsInput{}
	}

	output = &GetJobRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobRuns API operation for AWS Glue.
//
// Retrieves metadata for all runs of a given job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJobRuns for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns
func (c *Glue) GetJobRuns(input *GetJobRunsInput) (*GetJobRunsOutput, error) {
	req, out := c.GetJobRunsRequest(input)
	return out, req.Send()
}

// GetJobRunsWithContext is the same as GetJobRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobRunsWithContext(ctx aws.Context, input *GetJobRunsInput, opts ...request.Option) (*GetJobRunsOutput, error) {
	req, out := c.GetJobRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetJobRunsPages iterates over the pages of a GetJobRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetJobRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetJobRuns operation.
//    pageNum := 0
//    err := client.GetJobRunsPages(params,
//        func(page *glue.GetJobRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetJobRunsPages(input *GetJobRunsInput, fn func(*GetJobRunsOutput, bool) bool) error {
	return c.GetJobRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetJobRunsPagesWithContext same as GetJobRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobRunsPagesWithContext(ctx aws.Context, input *GetJobRunsInput, fn func(*GetJobRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetJobRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetJobRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetJobRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetJobs = "GetJobs"

// GetJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobs for more information on using the GetJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobsRequest method.
//    req, resp := client.GetJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs
func (c *Glue) GetJobsRequest(input *GetJobsInput) (req *request.Request, output *GetJobsOutput) {
	op := &request.Operation{
		Name:       opGetJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetJobsInput{}
	}

	output = &GetJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobs API operation for AWS Glue.
//
// Retrieves all current job definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs
func (c *Glue) GetJobs(input *GetJobsInput) (*GetJobsOutput, error) {
	req, out := c.GetJobsRequest(input)
	return out, req.Send()
}

// GetJobsWithContext is the same as GetJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobsWithContext(ctx aws.Context, input *GetJobsInput, opts ...request.Option) (*GetJobsOutput, error) {
	req, out := c.GetJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetJobsPages iterates over the pages of a GetJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetJobs operation.
//    pageNum := 0
//    err := client.GetJobsPages(params,
//        func(page *glue.GetJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetJobsPages(input *GetJobsInput, fn func(*GetJobsOutput, bool) bool) error {
	return c.GetJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetJobsPagesWithContext same as GetJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobsPagesWithContext(ctx aws.Context, input *GetJobsInput, fn func(*GetJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetMLTaskRun = "GetMLTaskRun"

// GetMLTaskRunRequest generates a "aws/request.Request" representing the
// client's request for the GetMLTaskRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLTaskRun for more information on using the GetMLTaskRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMLTaskRunRequest method.
//    req, resp := client.GetMLTaskRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun
func (c *Glue) GetMLTaskRunRequest(input *GetMLTaskRunInput) (req *request.Request, output *GetMLTaskRunOutput) {
	op := &request.Operation{
		Name:       opGetMLTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMLTaskRunInput{}
	}

	output = &GetMLTaskRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLTaskRun API operation for AWS Glue.
//
// Gets details for a specific task run on a machine learning transform. Machine
// learning task runs are asynchronous tasks that Glue runs on your behalf as
// part of various machine learning workflows. You can check the stats of any
// task run by calling GetMLTaskRun with the TaskRunID and its parent transform's
// TransformID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetMLTaskRun for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun
func (c *Glue) GetMLTaskRun(input *GetMLTaskRunInput) (*GetMLTaskRunOutput, error) {
	req, out := c.GetMLTaskRunRequest(input)
	return out, req.Send()
}

// GetMLTaskRunWithContext is the same as GetMLTaskRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLTaskRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMLTaskRunWithContext(ctx aws.Context, input *GetMLTaskRunInput, opts ...request.Option) (*GetMLTaskRunOutput, error) {
	req, out := c.GetMLTaskRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMLTaskRuns = "GetMLTaskRuns"

// GetMLTaskRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetMLTaskRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLTaskRuns for more information on using the GetMLTaskRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMLTaskRunsRequest method.
//    req, resp := client.GetMLTaskRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns
func (c *Glue) GetMLTaskRunsRequest(input *GetMLTaskRunsInput) (req *request.Request, output *GetMLTaskRunsOutput) {
	op := &request.Operation{
		Name:       opGetMLTaskRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMLTaskRunsInput{}
	}

	output = &GetMLTaskRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLTaskRuns API operation for AWS Glue.
//
// Gets a list of runs for a machine learning transform. Machine learning task
// runs are asynchronous tasks that Glue runs on your behalf as part of various
// machine learning workflows. You can get a sortable, filterable list of machine
// learning task runs by calling GetMLTaskRuns with their parent transform's
// TransformID and other optional parameters as documented in this section.
//
// This operation returns a list of historic runs and must be paginated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetMLTaskRuns for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns
func (c *Glue) GetMLTaskRuns(input *GetMLTaskRunsInput) (*GetMLTaskRunsOutput, error) {
	req, out := c.GetMLTaskRunsRequest(input)
	return out, req.Send()
}

// GetMLTaskRunsWithContext is the same as GetMLTaskRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLTaskRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMLTaskRunsWithContext(ctx aws.Context, input *GetMLTaskRunsInput, opts ...request.Option) (*GetMLTaskRunsOutput, error) {
	req, out := c.GetMLTaskRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetMLTaskRunsPages iterates over the pages of a GetMLTaskRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetMLTaskRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetMLTaskRuns operation.
//    pageNum := 0
//    err := client.GetMLTaskRunsPages(params,
//        func(page *glue.GetMLTaskRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetMLTaskRunsPages(input *GetMLTaskRunsInput, fn func(*GetMLTaskRunsOutput, bool) bool) error {
	return c.GetMLTaskRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetMLTaskRunsPagesWithContext same as GetMLTaskRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMLTaskRunsPagesWithContext(ctx aws.Context, input *GetMLTaskRunsInput, fn func(*GetMLTaskRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetMLTaskRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetMLTaskRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetMLTaskRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetMLTransform = "GetMLTransform"

// GetMLTransformRequest generates a "aws/request.Request" representing the
// client's request for the GetMLTransform operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLTransform for more information on using the GetMLTransform
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMLTransformRequest method.
//    req, resp := client.GetMLTransformRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransform
func (c *Glue) GetMLTransformRequest(input *GetMLTransformInput) (req *request.Request, output *GetMLTransformOutput) {
	op := &request.Operation{
		Name:       opGetMLTransform,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMLTransformInput{}
	}

	output = &GetMLTransformOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLTransform API operation for AWS Glue.
//
// Gets an Glue machine learning transform artifact and all its corresponding
// metadata. Machine learning transforms are a special type of transform that
// use machine learning to learn the details of the transformation to be performed
// by learning from examples provided by humans. These transformations are then
// saved by Glue. You can retrieve their metadata by calling GetMLTransform.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetMLTransform for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransform
func (c *Glue) GetMLTransform(input *GetMLTransformInput) (*GetMLTransformOutput, error) {
	req, out := c.GetMLTransformRequest(input)
	return out, req.Send()
}

// GetMLTransformWithContext is the same as GetMLTransform with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLTransform for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMLTransformWithContext(ctx aws.Context, input *GetMLTransformInput, opts ...request.Option) (*GetMLTransformOutput, error) {
	req, out := c.GetMLTransformRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMLTransforms = "GetMLTransforms"

// GetMLTransformsRequest generates a "aws/request.Request" representing the
// client's request for the GetMLTransforms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLTransforms for more information on using the GetMLTransforms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMLTransformsRequest method.
//    req, resp := client.GetMLTransformsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms
func (c *Glue) GetMLTransformsRequest(input *GetMLTransformsInput) (req *request.Request, output *GetMLTransformsOutput) {
	op := &request.Operation{
		Name:       opGetMLTransforms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMLTransformsInput{}
	}

	output = &GetMLTransformsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLTransforms API operation for AWS Glue.
//
// Gets a sortable, filterable list of existing Glue machine learning transforms.
// Machine learning transforms are a special type of transform that use machine
// learning to learn the details of the transformation to be performed by learning
// from examples provided by humans. These transformations are then saved by
// Glue, and you can retrieve their metadata by calling GetMLTransforms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetMLTransforms for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms
func (c *Glue) GetMLTransforms(input *GetMLTransformsInput) (*GetMLTransformsOutput, error) {
	req, out := c.GetMLTransformsRequest(input)
	return out, req.Send()
}

// GetMLTransformsWithContext is the same as GetMLTransforms with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLTransforms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMLTransformsWithContext(ctx aws.Context, input *GetMLTransformsInput, opts ...request.Option) (*GetMLTransformsOutput, error) {
	req, out := c.GetMLTransformsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetMLTransformsPages iterates over the pages of a GetMLTransforms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetMLTransforms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetMLTransforms operation.
//    pageNum := 0
//    err := client.GetMLTransformsPages(params,
//        func(page *glue.GetMLTransformsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetMLTransformsPages(input *GetMLTransformsInput, fn func(*GetMLTransformsOutput, bool) bool) error {
	return c.GetMLTransformsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetMLTransformsPagesWithContext same as GetMLTransformsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMLTransformsPagesWithContext(ctx aws.Context, input *GetMLTransformsInput, fn func(*GetMLTransformsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetMLTransformsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetMLTransformsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetMLTransformsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetMapping = "GetMapping"

// GetMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapping for more information on using the GetMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMappingRequest method.
//    req, resp := client.GetMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping
func (c *Glue) GetMappingRequest(input *GetMappingInput) (req *request.Request, output *GetMappingOutput) {
	op := &request.Operation{
		Name:       opGetMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMappingInput{}
	}

	output = &GetMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMapping API operation for AWS Glue.
//
// Creates mappings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetMapping for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping
func (c *Glue) GetMapping(input *GetMappingInput) (*GetMappingOutput, error) {
	req, out := c.GetMappingRequest(input)
	return out, req.Send()
}

// GetMappingWithContext is the same as GetMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMappingWithContext(ctx aws.Context, input *GetMappingInput, opts ...request.Option) (*GetMappingOutput, error) {
	req, out := c.GetMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPartition = "GetPartition"

// GetPartitionRequest generates a "aws/request.Request" representing the
// client's request for the GetPartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPartition for more information on using the GetPartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPartitionRequest method.
//    req, resp := client.GetPartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition
func (c *Glue) GetPartitionRequest(input *GetPartitionInput) (req *request.Request, output *GetPartitionOutput) {
	op := &request.Operation{
		Name:       opGetPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPartitionInput{}
	}

	output = &GetPartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPartition API operation for AWS Glue.
//
// Retrieves information about a specified partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetPartition for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition
func (c *Glue) GetPartition(input *GetPartitionInput) (*GetPartitionOutput, error) {
	req, out := c.GetPartitionRequest(input)
	return out, req.Send()
}

// GetPartitionWithContext is the same as GetPartition with the addition of
// the ability to pass a context and additional request options.
//
// See GetPartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionWithContext(ctx aws.Context, input *GetPartitionInput, opts ...request.Option) (*GetPartitionOutput, error) {
	req, out := c.GetPartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPartitionIndexes = "GetPartitionIndexes"

// GetPartitionIndexesRequest generates a "aws/request.Request" representing the
// client's request for the GetPartitionIndexes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPartitionIndexes for more information on using the GetPartitionIndexes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPartitionIndexesRequest method.
//    req, resp := client.GetPartitionIndexesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes
func (c *Glue) GetPartitionIndexesRequest(input *GetPartitionIndexesInput) (req *request.Request, output *GetPartitionIndexesOutput) {
	op := &request.Operation{
		Name:       opGetPartitionIndexes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPartitionIndexesInput{}
	}

	output = &GetPartitionIndexesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPartitionIndexes API operation for AWS Glue.
//
// Retrieves the partition indexes associated with a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetPartitionIndexes for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ConflictException
//   The CreatePartitions API was called on a table that has indexes enabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes
func (c *Glue) GetPartitionIndexes(input *GetPartitionIndexesInput) (*GetPartitionIndexesOutput, error) {
	req, out := c.GetPartitionIndexesRequest(input)
	return out, req.Send()
}

// GetPartitionIndexesWithContext is the same as GetPartitionIndexes with the addition of
// the ability to pass a context and additional request options.
//
// See GetPartitionIndexes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionIndexesWithContext(ctx aws.Context, input *GetPartitionIndexesInput, opts ...request.Option) (*GetPartitionIndexesOutput, error) {
	req, out := c.GetPartitionIndexesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPartitionIndexesPages iterates over the pages of a GetPartitionIndexes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPartitionIndexes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetPartitionIndexes operation.
//    pageNum := 0
//    err := client.GetPartitionIndexesPages(params,
//        func(page *glue.GetPartitionIndexesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetPartitionIndexesPages(input *GetPartitionIndexesInput, fn func(*GetPartitionIndexesOutput, bool) bool) error {
	return c.GetPartitionIndexesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPartitionIndexesPagesWithContext same as GetPartitionIndexesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionIndexesPagesWithContext(ctx aws.Context, input *GetPartitionIndexesInput, fn func(*GetPartitionIndexesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPartitionIndexesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPartitionIndexesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPartitionIndexesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetPartitions = "GetPartitions"

// GetPartitionsRequest generates a "aws/request.Request" representing the
// client's request for the GetPartitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPartitions for more information on using the GetPartitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPartitionsRequest method.
//    req, resp := client.GetPartitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions
func (c *Glue) GetPartitionsRequest(input *GetPartitionsInput) (req *request.Request, output *GetPartitionsOutput) {
	op := &request.Operation{
		Name:       opGetPartitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPartitionsInput{}
	}

	output = &GetPartitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPartitions API operation for AWS Glue.
//
// Retrieves information about the partitions in a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetPartitions for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * InvalidStateException
//   An error that indicates your data is in an invalid state.
//
//   * ResourceNotReadyException
//   A resource was not ready for a transaction.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions
func (c *Glue) GetPartitions(input *GetPartitionsInput) (*GetPartitionsOutput, error) {
	req, out := c.GetPartitionsRequest(input)
	return out, req.Send()
}

// GetPartitionsWithContext is the same as GetPartitions with the addition of
// the ability to pass a context and additional request options.
//
// See GetPartitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionsWithContext(ctx aws.Context, input *GetPartitionsInput, opts ...request.Option) (*GetPartitionsOutput, error) {
	req, out := c.GetPartitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPartitionsPages iterates over the pages of a GetPartitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPartitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetPartitions operation.
//    pageNum := 0
//    err := client.GetPartitionsPages(params,
//        func(page *glue.GetPartitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetPartitionsPages(input *GetPartitionsInput, fn func(*GetPartitionsOutput, bool) bool) error {
	return c.GetPartitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPartitionsPagesWithContext same as GetPartitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionsPagesWithContext(ctx aws.Context, input *GetPartitionsInput, fn func(*GetPartitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPartitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPartitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPartitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetPlan = "GetPlan"

// GetPlanRequest generates a "aws/request.Request" representing the
// client's request for the GetPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlan for more information on using the GetPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPlanRequest method.
//    req, resp := client.GetPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan
func (c *Glue) GetPlanRequest(input *GetPlanInput) (req *request.Request, output *GetPlanOutput) {
	op := &request.Operation{
		Name:       opGetPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPlanInput{}
	}

	output = &GetPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlan API operation for AWS Glue.
//
// Gets code to perform a specified mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetPlan for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan
func (c *Glue) GetPlan(input *GetPlanInput) (*GetPlanOutput, error) {
	req, out := c.GetPlanRequest(input)
	return out, req.Send()
}

// GetPlanWithContext is the same as GetPlan with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPlanWithContext(ctx aws.Context, input *GetPlanInput, opts ...request.Option) (*GetPlanOutput, error) {
	req, out := c.GetPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegistry = "GetRegistry"

// GetRegistryRequest generates a "aws/request.Request" representing the
// client's request for the GetRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegistry for more information on using the GetRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegistryRequest method.
//    req, resp := client.GetRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetRegistry
func (c *Glue) GetRegistryRequest(input *GetRegistryInput) (req *request.Request, output *GetRegistryOutput) {
	op := &request.Operation{
		Name:       opGetRegistry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegistryInput{}
	}

	output = &GetRegistryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegistry API operation for AWS Glue.
//
// Describes the specified registry in detail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetRegistry for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetRegistry
func (c *Glue) GetRegistry(input *GetRegistryInput) (*GetRegistryOutput, error) {
	req, out := c.GetRegistryRequest(input)
	return out, req.Send()
}

// GetRegistryWithContext is the same as GetRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetRegistryWithContext(ctx aws.Context, input *GetRegistryInput, opts ...request.Option) (*GetRegistryOutput, error) {
	req, out := c.GetRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicies = "GetResourcePolicies"

// GetResourcePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicies for more information on using the GetResourcePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcePoliciesRequest method.
//    req, resp := client.GetResourcePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies
func (c *Glue) GetResourcePoliciesRequest(input *GetResourcePoliciesInput) (req *request.Request, output *GetResourcePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcePoliciesInput{}
	}

	output = &GetResourcePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicies API operation for AWS Glue.
//
// Retrieves the resource policies set on individual resources by Resource Access
// Manager during cross-account permission grants. Also retrieves the Data Catalog
// resource policy.
//
// If you enabled metadata encryption in Data Catalog settings, and you do not
// have permission on the KMS key, the operation can't return the Data Catalog
// resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetResourcePolicies for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies
func (c *Glue) GetResourcePolicies(input *GetResourcePoliciesInput) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	return out, req.Send()
}

// GetResourcePoliciesWithContext is the same as GetResourcePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetResourcePoliciesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, opts ...request.Option) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcePoliciesPages iterates over the pages of a GetResourcePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourcePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourcePolicies operation.
//    pageNum := 0
//    err := client.GetResourcePoliciesPages(params,
//        func(page *glue.GetResourcePoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetResourcePoliciesPages(input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool) error {
	return c.GetResourcePoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcePoliciesPagesWithContext same as GetResourcePoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetResourcePoliciesPagesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcePoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcePoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourcePoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcePolicyRequest method.
//    req, resp := client.GetResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicy
func (c *Glue) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for AWS Glue.
//
// Retrieves a specified resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicy
func (c *Glue) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchema = "GetSchema"

// GetSchemaRequest generates a "aws/request.Request" representing the
// client's request for the GetSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchema for more information on using the GetSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSchemaRequest method.
//    req, resp := client.GetSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchema
func (c *Glue) GetSchemaRequest(input *GetSchemaInput) (req *request.Request, output *GetSchemaOutput) {
	op := &request.Operation{
		Name:       opGetSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSchemaInput{}
	}

	output = &GetSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchema API operation for AWS Glue.
//
// Describes the specified schema in detail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetSchema for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchema
func (c *Glue) GetSchema(input *GetSchemaInput) (*GetSchemaOutput, error) {
	req, out := c.GetSchemaRequest(input)
	return out, req.Send()
}

// GetSchemaWithContext is the same as GetSchema with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSchemaWithContext(ctx aws.Context, input *GetSchemaInput, opts ...request.Option) (*GetSchemaOutput, error) {
	req, out := c.GetSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaByDefinition = "GetSchemaByDefinition"

// GetSchemaByDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaByDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaByDefinition for more information on using the GetSchemaByDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSchemaByDefinitionRequest method.
//    req, resp := client.GetSchemaByDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaByDefinition
func (c *Glue) GetSchemaByDefinitionRequest(input *GetSchemaByDefinitionInput) (req *request.Request, output *GetSchemaByDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetSchemaByDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSchemaByDefinitionInput{}
	}

	output = &GetSchemaByDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaByDefinition API operation for AWS Glue.
//
// Retrieves a schema by the SchemaDefinition. The schema definition is sent
// to the Schema Registry, canonicalized, and hashed. If the hash is matched
// within the scope of the SchemaName or ARN (or the default registry, if none
// is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound
// error is returned. Schema versions in Deleted statuses will not be included
// in the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetSchemaByDefinition for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaByDefinition
func (c *Glue) GetSchemaByDefinition(input *GetSchemaByDefinitionInput) (*GetSchemaByDefinitionOutput, error) {
	req, out := c.GetSchemaByDefinitionRequest(input)
	return out, req.Send()
}

// GetSchemaByDefinitionWithContext is the same as GetSchemaByDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaByDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSchemaByDefinitionWithContext(ctx aws.Context, input *GetSchemaByDefinitionInput, opts ...request.Option) (*GetSchemaByDefinitionOutput, error) {
	req, out := c.GetSchemaByDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaVersion = "GetSchemaVersion"

// GetSchemaVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaVersion for more information on using the GetSchemaVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSchemaVersionRequest method.
//    req, resp := client.GetSchemaVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersion
func (c *Glue) GetSchemaVersionRequest(input *GetSchemaVersionInput) (req *request.Request, output *GetSchemaVersionOutput) {
	op := &request.Operation{
		Name:       opGetSchemaVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSchemaVersionInput{}
	}

	output = &GetSchemaVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaVersion API operation for AWS Glue.
//
// Get the specified schema by its unique ID assigned when a version of the
// schema is created or registered. Schema versions in Deleted status will not
// be included in the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetSchemaVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersion
func (c *Glue) GetSchemaVersion(input *GetSchemaVersionInput) (*GetSchemaVersionOutput, error) {
	req, out := c.GetSchemaVersionRequest(input)
	return out, req.Send()
}

// GetSchemaVersionWithContext is the same as GetSchemaVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSchemaVersionWithContext(ctx aws.Context, input *GetSchemaVersionInput, opts ...request.Option) (*GetSchemaVersionOutput, error) {
	req, out := c.GetSchemaVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaVersionsDiff = "GetSchemaVersionsDiff"

// GetSchemaVersionsDiffRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaVersionsDiff operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaVersionsDiff for more information on using the GetSchemaVersionsDiff
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSchemaVersionsDiffRequest method.
//    req, resp := client.GetSchemaVersionsDiffRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersionsDiff
func (c *Glue) GetSchemaVersionsDiffRequest(input *GetSchemaVersionsDiffInput) (req *request.Request, output *GetSchemaVersionsDiffOutput) {
	op := &request.Operation{
		Name:       opGetSchemaVersionsDiff,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSchemaVersionsDiffInput{}
	}

	output = &GetSchemaVersionsDiffOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaVersionsDiff API operation for AWS Glue.
//
// Fetches the schema version difference in the specified difference type between
// two stored schema versions in the Schema Registry.
//
// This API allows you to compare two schema versions between two schema definitions
// under the same schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetSchemaVersionsDiff for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersionsDiff
func (c *Glue) GetSchemaVersionsDiff(input *GetSchemaVersionsDiffInput) (*GetSchemaVersionsDiffOutput, error) {
	req, out := c.GetSchemaVersionsDiffRequest(input)
	return out, req.Send()
}

// GetSchemaVersionsDiffWithContext is the same as GetSchemaVersionsDiff with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaVersionsDiff for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSchemaVersionsDiffWithContext(ctx aws.Context, input *GetSchemaVersionsDiffInput, opts ...request.Option) (*GetSchemaVersionsDiffOutput, error) {
	req, out := c.GetSchemaVersionsDiffRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSecurityConfiguration = "GetSecurityConfiguration"

// GetSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetSecurityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSecurityConfiguration for more information on using the GetSecurityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSecurityConfigurationRequest method.
//    req, resp := client.GetSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfiguration
func (c *Glue) GetSecurityConfigurationRequest(input *GetSecurityConfigurationInput) (req *request.Request, output *GetSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSecurityConfigurationInput{}
	}

	output = &GetSecurityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSecurityConfiguration API operation for AWS Glue.
//
// Retrieves a specified security configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetSecurityConfiguration for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfiguration
func (c *Glue) GetSecurityConfiguration(input *GetSecurityConfigurationInput) (*GetSecurityConfigurationOutput, error) {
	req, out := c.GetSecurityConfigurationRequest(input)
	return out, req.Send()
}

// GetSecurityConfigurationWithContext is the same as GetSecurityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecurityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSecurityConfigurationWithContext(ctx aws.Context, input *GetSecurityConfigurationInput, opts ...request.Option) (*GetSecurityConfigurationOutput, error) {
	req, out := c.GetSecurityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSecurityConfigurations = "GetSecurityConfigurations"

// GetSecurityConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the GetSecurityConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSecurityConfigurations for more information on using the GetSecurityConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSecurityConfigurationsRequest method.
//    req, resp := client.GetSecurityConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations
func (c *Glue) GetSecurityConfigurationsRequest(input *GetSecurityConfigurationsInput) (req *request.Request, output *GetSecurityConfigurationsOutput) {
	op := &request.Operation{
		Name:       opGetSecurityConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSecurityConfigurationsInput{}
	}

	output = &GetSecurityConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSecurityConfigurations API operation for AWS Glue.
//
// Retrieves a list of all security configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetSecurityConfigurations for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations
func (c *Glue) GetSecurityConfigurations(input *GetSecurityConfigurationsInput) (*GetSecurityConfigurationsOutput, error) {
	req, out := c.GetSecurityConfigurationsRequest(input)
	return out, req.Send()
}

// GetSecurityConfigurationsWithContext is the same as GetSecurityConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecurityConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSecurityConfigurationsWithContext(ctx aws.Context, input *GetSecurityConfigurationsInput, opts ...request.Option) (*GetSecurityConfigurationsOutput, error) {
	req, out := c.GetSecurityConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSecurityConfigurationsPages iterates over the pages of a GetSecurityConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSecurityConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSecurityConfigurations operation.
//    pageNum := 0
//    err := client.GetSecurityConfigurationsPages(params,
//        func(page *glue.GetSecurityConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetSecurityConfigurationsPages(input *GetSecurityConfigurationsInput, fn func(*GetSecurityConfigurationsOutput, bool) bool) error {
	return c.GetSecurityConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSecurityConfigurationsPagesWithContext same as GetSecurityConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSecurityConfigurationsPagesWithContext(ctx aws.Context, input *GetSecurityConfigurationsInput, fn func(*GetSecurityConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSecurityConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSecurityConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSecurityConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSession = "GetSession"

// GetSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSession for more information on using the GetSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSessionRequest method.
//    req, resp := client.GetSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSession
func (c *Glue) GetSessionRequest(input *GetSessionInput) (req *request.Request, output *GetSessionOutput) {
	op := &request.Operation{
		Name:       opGetSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSessionInput{}
	}

	output = &GetSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSession API operation for AWS Glue.
//
// Retrieves the session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetSession for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSession
func (c *Glue) GetSession(input *GetSessionInput) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	return out, req.Send()
}

// GetSessionWithContext is the same as GetSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetSessionWithContext(ctx aws.Context, input *GetSessionInput, opts ...request.Option) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStatement = "GetStatement"

// GetStatementRequest generates a "aws/request.Request" representing the
// client's request for the GetStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStatement for more information on using the GetStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStatementRequest method.
//    req, resp := client.GetStatementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetStatement
func (c *Glue) GetStatementRequest(input *GetStatementInput) (req *request.Request, output *GetStatementOutput) {
	op := &request.Operation{
		Name:       opGetStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStatementInput{}
	}

	output = &GetStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStatement API operation for AWS Glue.
//
// Retrieves the statement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetStatement for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * IllegalSessionStateException
//   The session is in an invalid state to perform a requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetStatement
func (c *Glue) GetStatement(input *GetStatementInput) (*GetStatementOutput, error) {
	req, out := c.GetStatementRequest(input)
	return out, req.Send()
}

// GetStatementWithContext is the same as GetStatement with the addition of
// the ability to pass a context and additional request options.
//
// See GetStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetStatementWithContext(ctx aws.Context, input *GetStatementInput, opts ...request.Option) (*GetStatementOutput, error) {
	req, out := c.GetStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTable = "GetTable"

// GetTableRequest generates a "aws/request.Request" representing the
// client's request for the GetTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTable for more information on using the GetTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTableRequest method.
//    req, resp := client.GetTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable
func (c *Glue) GetTableRequest(input *GetTableInput) (req *request.Request, output *GetTableOutput) {
	op := &request.Operation{
		Name:       opGetTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableInput{}
	}

	output = &GetTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTable API operation for AWS Glue.
//
// Retrieves the Table definition in a Data Catalog for a specified table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTable for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * ResourceNotReadyException
//   A resource was not ready for a transaction.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable
func (c *Glue) GetTable(input *GetTableInput) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	return out, req.Send()
}

// GetTableWithContext is the same as GetTable with the addition of
// the ability to pass a context and additional request options.
//
// See GetTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableWithContext(ctx aws.Context, input *GetTableInput, opts ...request.Option) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTableVersion = "GetTableVersion"

// GetTableVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetTableVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTableVersion for more information on using the GetTableVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTableVersionRequest method.
//    req, resp := client.GetTableVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion
func (c *Glue) GetTableVersionRequest(input *GetTableVersionInput) (req *request.Request, output *GetTableVersionOutput) {
	op := &request.Operation{
		Name:       opGetTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableVersionInput{}
	}

	output = &GetTableVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTableVersion API operation for AWS Glue.
//
// Retrieves a specified version of a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTableVersion for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion
func (c *Glue) GetTableVersion(input *GetTableVersionInput) (*GetTableVersionOutput, error) {
	req, out := c.GetTableVersionRequest(input)
	return out, req.Send()
}

// GetTableVersionWithContext is the same as GetTableVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetTableVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableVersionWithContext(ctx aws.Context, input *GetTableVersionInput, opts ...request.Option) (*GetTableVersionOutput, error) {
	req, out := c.GetTableVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTableVersions = "GetTableVersions"

// GetTableVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetTableVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTableVersions for more information on using the GetTableVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTableVersionsRequest method.
//    req, resp := client.GetTableVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions
func (c *Glue) GetTableVersionsRequest(input *GetTableVersionsInput) (req *request.Request, output *GetTableVersionsOutput) {
	op := &request.Operation{
		Name:       opGetTableVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTableVersionsInput{}
	}

	output = &GetTableVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTableVersions API operation for AWS Glue.
//
// Retrieves a list of strings that identify available versions of a specified
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTableVersions for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions
func (c *Glue) GetTableVersions(input *GetTableVersionsInput) (*GetTableVersionsOutput, error) {
	req, out := c.GetTableVersionsRequest(input)
	return out, req.Send()
}

// GetTableVersionsWithContext is the same as GetTableVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetTableVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableVersionsWithContext(ctx aws.Context, input *GetTableVersionsInput, opts ...request.Option) (*GetTableVersionsOutput, error) {
	req, out := c.GetTableVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTableVersionsPages iterates over the pages of a GetTableVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTableVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTableVersions operation.
//    pageNum := 0
//    err := client.GetTableVersionsPages(params,
//        func(page *glue.GetTableVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetTableVersionsPages(input *GetTableVersionsInput, fn func(*GetTableVersionsOutput, bool) bool) error {
	return c.GetTableVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTableVersionsPagesWithContext same as GetTableVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableVersionsPagesWithContext(ctx aws.Context, input *GetTableVersionsInput, fn func(*GetTableVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTableVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTableVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTableVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTables = "GetTables"

// GetTablesRequest generates a "aws/request.Request" representing the
// client's request for the GetTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTables for more information on using the GetTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTablesRequest method.
//    req, resp := client.GetTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables
func (c *Glue) GetTablesRequest(input *GetTablesInput) (req *request.Request, output *GetTablesOutput) {
	op := &request.Operation{
		Name:       opGetTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTablesInput{}
	}

	output = &GetTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTables API operation for AWS Glue.
//
// Retrieves the definitions of some or all of the tables in a given Database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTables for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables
func (c *Glue) GetTables(input *GetTablesInput) (*GetTablesOutput, error) {
	req, out := c.GetTablesRequest(input)
	return out, req.Send()
}

// GetTablesWithContext is the same as GetTables with the addition of
// the ability to pass a context and additional request options.
//
// See GetTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTablesWithContext(ctx aws.Context, input *GetTablesInput, opts ...request.Option) (*GetTablesOutput, error) {
	req, out := c.GetTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTablesPages iterates over the pages of a GetTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTables operation.
//    pageNum := 0
//    err := client.GetTablesPages(params,
//        func(page *glue.GetTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetTablesPages(input *GetTablesInput, fn func(*GetTablesOutput, bool) bool) error {
	return c.GetTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTablesPagesWithContext same as GetTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTablesPagesWithContext(ctx aws.Context, input *GetTablesInput, fn func(*GetTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTags
func (c *Glue) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AWS Glue.
//
// Retrieves a list of tags associated with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTags for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTags
func (c *Glue) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrigger = "GetTrigger"

// GetTriggerRequest generates a "aws/request.Request" representing the
// client's request for the GetTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrigger for more information on using the GetTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTriggerRequest method.
//    req, resp := client.GetTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger
func (c *Glue) GetTriggerRequest(input *GetTriggerInput) (req *request.Request, output *GetTriggerOutput) {
	op := &request.Operation{
		Name:       opGetTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTriggerInput{}
	}

	output = &GetTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrigger API operation for AWS Glue.
//
// Retrieves the definition of a trigger.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTrigger for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger
func (c *Glue) GetTrigger(input *GetTriggerInput) (*GetTriggerOutput, error) {
	req, out := c.GetTriggerRequest(input)
	return out, req.Send()
}

// GetTriggerWithContext is the same as GetTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTriggerWithContext(ctx aws.Context, input *GetTriggerInput, opts ...request.Option) (*GetTriggerOutput, error) {
	req, out := c.GetTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTriggers = "GetTriggers"

// GetTriggersRequest generates a "aws/request.Request" representing the
// client's request for the GetTriggers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTriggers for more information on using the GetTriggers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTriggersRequest method.
//    req, resp := client.GetTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers
func (c *Glue) GetTriggersRequest(input *GetTriggersInput) (req *request.Request, output *GetTriggersOutput) {
	op := &request.Operation{
		Name:       opGetTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTriggersInput{}
	}

	output = &GetTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTriggers API operation for AWS Glue.
//
// Gets all the triggers associated with a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTriggers for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers
func (c *Glue) GetTriggers(input *GetTriggersInput) (*GetTriggersOutput, error) {
	req, out := c.GetTriggersRequest(input)
	return out, req.Send()
}

// GetTriggersWithContext is the same as GetTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See GetTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTriggersWithContext(ctx aws.Context, input *GetTriggersInput, opts ...request.Option) (*GetTriggersOutput, error) {
	req, out := c.GetTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTriggersPages iterates over the pages of a GetTriggers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTriggers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTriggers operation.
//    pageNum := 0
//    err := client.GetTriggersPages(params,
//        func(page *glue.GetTriggersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetTriggersPages(input *GetTriggersInput, fn func(*GetTriggersOutput, bool) bool) error {
	return c.GetTriggersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTriggersPagesWithContext same as GetTriggersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTriggersPagesWithContext(ctx aws.Context, input *GetTriggersInput, fn func(*GetTriggersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTriggersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTriggersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTriggersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUnfilteredPartitionMetadata = "GetUnfilteredPartitionMetadata"

// GetUnfilteredPartitionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetUnfilteredPartitionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUnfilteredPartitionMetadata for more information on using the GetUnfilteredPartitionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUnfilteredPartitionMetadataRequest method.
//    req, resp := client.GetUnfilteredPartitionMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionMetadata
func (c *Glue) GetUnfilteredPartitionMetadataRequest(input *GetUnfilteredPartitionMetadataInput) (req *request.Request, output *GetUnfilteredPartitionMetadataOutput) {
	op := &request.Operation{
		Name:       opGetUnfilteredPartitionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUnfilteredPartitionMetadataInput{}
	}

	output = &GetUnfilteredPartitionMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUnfilteredPartitionMetadata API operation for AWS Glue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetUnfilteredPartitionMetadata for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * PermissionTypeMismatchException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionMetadata
func (c *Glue) GetUnfilteredPartitionMetadata(input *GetUnfilteredPartitionMetadataInput) (*GetUnfilteredPartitionMetadataOutput, error) {
	req, out := c.GetUnfilteredPartitionMetadataRequest(input)
	return out, req.Send()
}

// GetUnfilteredPartitionMetadataWithContext is the same as GetUnfilteredPartitionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetUnfilteredPartitionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUnfilteredPartitionMetadataWithContext(ctx aws.Context, input *GetUnfilteredPartitionMetadataInput, opts ...request.Option) (*GetUnfilteredPartitionMetadataOutput, error) {
	req, out := c.GetUnfilteredPartitionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUnfilteredPartitionsMetadata = "GetUnfilteredPartitionsMetadata"

// GetUnfilteredPartitionsMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetUnfilteredPartitionsMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUnfilteredPartitionsMetadata for more information on using the GetUnfilteredPartitionsMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUnfilteredPartitionsMetadataRequest method.
//    req, resp := client.GetUnfilteredPartitionsMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionsMetadata
func (c *Glue) GetUnfilteredPartitionsMetadataRequest(input *GetUnfilteredPartitionsMetadataInput) (req *request.Request, output *GetUnfilteredPartitionsMetadataOutput) {
	op := &request.Operation{
		Name:       opGetUnfilteredPartitionsMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUnfilteredPartitionsMetadataInput{}
	}

	output = &GetUnfilteredPartitionsMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUnfilteredPartitionsMetadata API operation for AWS Glue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetUnfilteredPartitionsMetadata for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * PermissionTypeMismatchException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionsMetadata
func (c *Glue) GetUnfilteredPartitionsMetadata(input *GetUnfilteredPartitionsMetadataInput) (*GetUnfilteredPartitionsMetadataOutput, error) {
	req, out := c.GetUnfilteredPartitionsMetadataRequest(input)
	return out, req.Send()
}

// GetUnfilteredPartitionsMetadataWithContext is the same as GetUnfilteredPartitionsMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetUnfilteredPartitionsMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUnfilteredPartitionsMetadataWithContext(ctx aws.Context, input *GetUnfilteredPartitionsMetadataInput, opts ...request.Option) (*GetUnfilteredPartitionsMetadataOutput, error) {
	req, out := c.GetUnfilteredPartitionsMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUnfilteredPartitionsMetadataPages iterates over the pages of a GetUnfilteredPartitionsMetadata operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUnfilteredPartitionsMetadata method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUnfilteredPartitionsMetadata operation.
//    pageNum := 0
//    err := client.GetUnfilteredPartitionsMetadataPages(params,
//        func(page *glue.GetUnfilteredPartitionsMetadataOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetUnfilteredPartitionsMetadataPages(input *GetUnfilteredPartitionsMetadataInput, fn func(*GetUnfilteredPartitionsMetadataOutput, bool) bool) error {
	return c.GetUnfilteredPartitionsMetadataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUnfilteredPartitionsMetadataPagesWithContext same as GetUnfilteredPartitionsMetadataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUnfilteredPartitionsMetadataPagesWithContext(ctx aws.Context, input *GetUnfilteredPartitionsMetadataInput, fn func(*GetUnfilteredPartitionsMetadataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUnfilteredPartitionsMetadataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUnfilteredPartitionsMetadataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUnfilteredPartitionsMetadataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUnfilteredTableMetadata = "GetUnfilteredTableMetadata"

// GetUnfilteredTableMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetUnfilteredTableMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUnfilteredTableMetadata for more information on using the GetUnfilteredTableMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUnfilteredTableMetadataRequest method.
//    req, resp := client.GetUnfilteredTableMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredTableMetadata
func (c *Glue) GetUnfilteredTableMetadataRequest(input *GetUnfilteredTableMetadataInput) (req *request.Request, output *GetUnfilteredTableMetadataOutput) {
	op := &request.Operation{
		Name:       opGetUnfilteredTableMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUnfilteredTableMetadataInput{}
	}

	output = &GetUnfilteredTableMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUnfilteredTableMetadata API operation for AWS Glue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetUnfilteredTableMetadata for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * PermissionTypeMismatchException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredTableMetadata
func (c *Glue) GetUnfilteredTableMetadata(input *GetUnfilteredTableMetadataInput) (*GetUnfilteredTableMetadataOutput, error) {
	req, out := c.GetUnfilteredTableMetadataRequest(input)
	return out, req.Send()
}

// GetUnfilteredTableMetadataWithContext is the same as GetUnfilteredTableMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetUnfilteredTableMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUnfilteredTableMetadataWithContext(ctx aws.Context, input *GetUnfilteredTableMetadataInput, opts ...request.Option) (*GetUnfilteredTableMetadataOutput, error) {
	req, out := c.GetUnfilteredTableMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserDefinedFunction = "GetUserDefinedFunction"

// GetUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the GetUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserDefinedFunction for more information on using the GetUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserDefinedFunctionRequest method.
//    req, resp := client.GetUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction
func (c *Glue) GetUserDefinedFunctionRequest(input *GetUserDefinedFunctionInput) (req *request.Request, output *GetUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opGetUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserDefinedFunctionInput{}
	}

	output = &GetUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserDefinedFunction API operation for AWS Glue.
//
// Retrieves a specified function definition from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetUserDefinedFunction for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction
func (c *Glue) GetUserDefinedFunction(input *GetUserDefinedFunctionInput) (*GetUserDefinedFunctionOutput, error) {
	req, out := c.GetUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// GetUserDefinedFunctionWithContext is the same as GetUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUserDefinedFunctionWithContext(ctx aws.Context, input *GetUserDefinedFunctionInput, opts ...request.Option) (*GetUserDefinedFunctionOutput, error) {
	req, out := c.GetUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserDefinedFunctions = "GetUserDefinedFunctions"

// GetUserDefinedFunctionsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserDefinedFunctions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserDefinedFunctions for more information on using the GetUserDefinedFunctions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserDefinedFunctionsRequest method.
//    req, resp := client.GetUserDefinedFunctionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions
func (c *Glue) GetUserDefinedFunctionsRequest(input *GetUserDefinedFunctionsInput) (req *request.Request, output *GetUserDefinedFunctionsOutput) {
	op := &request.Operation{
		Name:       opGetUserDefinedFunctions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUserDefinedFunctionsInput{}
	}

	output = &GetUserDefinedFunctionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserDefinedFunctions API operation for AWS Glue.
//
// Retrieves multiple function definitions from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetUserDefinedFunctions for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions
func (c *Glue) GetUserDefinedFunctions(input *GetUserDefinedFunctionsInput) (*GetUserDefinedFunctionsOutput, error) {
	req, out := c.GetUserDefinedFunctionsRequest(input)
	return out, req.Send()
}

// GetUserDefinedFunctionsWithContext is the same as GetUserDefinedFunctions with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserDefinedFunctions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUserDefinedFunctionsWithContext(ctx aws.Context, input *GetUserDefinedFunctionsInput, opts ...request.Option) (*GetUserDefinedFunctionsOutput, error) {
	req, out := c.GetUserDefinedFunctionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUserDefinedFunctionsPages iterates over the pages of a GetUserDefinedFunctions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUserDefinedFunctions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUserDefinedFunctions operation.
//    pageNum := 0
//    err := client.GetUserDefinedFunctionsPages(params,
//        func(page *glue.GetUserDefinedFunctionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetUserDefinedFunctionsPages(input *GetUserDefinedFunctionsInput, fn func(*GetUserDefinedFunctionsOutput, bool) bool) error {
	return c.GetUserDefinedFunctionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUserDefinedFunctionsPagesWithContext same as GetUserDefinedFunctionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUserDefinedFunctionsPagesWithContext(ctx aws.Context, input *GetUserDefinedFunctionsInput, fn func(*GetUserDefinedFunctionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUserDefinedFunctionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUserDefinedFunctionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUserDefinedFunctionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetWorkflow = "GetWorkflow"

// GetWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflow for more information on using the GetWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkflowRequest method.
//    req, resp := client.GetWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow
func (c *Glue) GetWorkflowRequest(input *GetWorkflowInput) (req *request.Request, output *GetWorkflowOutput) {
	op := &request.Operation{
		Name:       opGetWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWorkflowInput{}
	}

	output = &GetWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflow API operation for AWS Glue.
//
// Retrieves resource metadata for a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetWorkflow for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow
func (c *Glue) GetWorkflow(input *GetWorkflowInput) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	return out, req.Send()
}

// GetWorkflowWithContext is the same as GetWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetWorkflowWithContext(ctx aws.Context, input *GetWorkflowInput, opts ...request.Option) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflowRun = "GetWorkflowRun"

// GetWorkflowRunRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflowRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflowRun for more information on using the GetWorkflowRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkflowRunRequest method.
//    req, resp := client.GetWorkflowRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRun
func (c *Glue) GetWorkflowRunRequest(input *GetWorkflowRunInput) (req *request.Request, output *GetWorkflowRunOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWorkflowRunInput{}
	}

	output = &GetWorkflowRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflowRun API operation for AWS Glue.
//
// Retrieves the metadata for a given workflow run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetWorkflowRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRun
func (c *Glue) GetWorkflowRun(input *GetWorkflowRunInput) (*GetWorkflowRunOutput, error) {
	req, out := c.GetWorkflowRunRequest(input)
	return out, req.Send()
}

// GetWorkflowRunWithContext is the same as GetWorkflowRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflowRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetWorkflowRunWithContext(ctx aws.Context, input *GetWorkflowRunInput, opts ...request.Option) (*GetWorkflowRunOutput, error) {
	req, out := c.GetWorkflowRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflowRunProperties = "GetWorkflowRunProperties"

// GetWorkflowRunPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflowRunProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflowRunProperties for more information on using the GetWorkflowRunProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkflowRunPropertiesRequest method.
//    req, resp := client.GetWorkflowRunPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRunProperties
func (c *Glue) GetWorkflowRunPropertiesRequest(input *GetWorkflowRunPropertiesInput) (req *request.Request, output *GetWorkflowRunPropertiesOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowRunProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWorkflowRunPropertiesInput{}
	}

	output = &GetWorkflowRunPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflowRunProperties API operation for AWS Glue.
//
// Retrieves the workflow run properties which were set during the run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetWorkflowRunProperties for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRunProperties
func (c *Glue) GetWorkflowRunProperties(input *GetWorkflowRunPropertiesInput) (*GetWorkflowRunPropertiesOutput, error) {
	req, out := c.GetWorkflowRunPropertiesRequest(input)
	return out, req.Send()
}

// GetWorkflowRunPropertiesWithContext is the same as GetWorkflowRunProperties with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflowRunProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetWorkflowRunPropertiesWithContext(ctx aws.Context, input *GetWorkflowRunPropertiesInput, opts ...request.Option) (*GetWorkflowRunPropertiesOutput, error) {
	req, out := c.GetWorkflowRunPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflowRuns = "GetWorkflowRuns"

// GetWorkflowRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflowRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflowRuns for more information on using the GetWorkflowRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkflowRunsRequest method.
//    req, resp := client.GetWorkflowRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns
func (c *Glue) GetWorkflowRunsRequest(input *GetWorkflowRunsInput) (req *request.Request, output *GetWorkflowRunsOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetWorkflowRunsInput{}
	}

	output = &GetWorkflowRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflowRuns API operation for AWS Glue.
//
// Retrieves metadata for all runs of a given workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetWorkflowRuns for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns
func (c *Glue) GetWorkflowRuns(input *GetWorkflowRunsInput) (*GetWorkflowRunsOutput, error) {
	req, out := c.GetWorkflowRunsRequest(input)
	return out, req.Send()
}

// GetWorkflowRunsWithContext is the same as GetWorkflowRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflowRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetWorkflowRunsWithContext(ctx aws.Context, input *GetWorkflowRunsInput, opts ...request.Option) (*GetWorkflowRunsOutput, error) {
	req, out := c.GetWorkflowRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetWorkflowRunsPages iterates over the pages of a GetWorkflowRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetWorkflowRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetWorkflowRuns operation.
//    pageNum := 0
//    err := client.GetWorkflowRunsPages(params,
//        func(page *glue.GetWorkflowRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetWorkflowRunsPages(input *GetWorkflowRunsInput, fn func(*GetWorkflowRunsOutput, bool) bool) error {
	return c.GetWorkflowRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetWorkflowRunsPagesWithContext same as GetWorkflowRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetWorkflowRunsPagesWithContext(ctx aws.Context, input *GetWorkflowRunsInput, fn func(*GetWorkflowRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetWorkflowRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetWorkflowRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetWorkflowRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opImportCatalogToGlue = "ImportCatalogToGlue"

// ImportCatalogToGlueRequest generates a "aws/request.Request" representing the
// client's request for the ImportCatalogToGlue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCatalogToGlue for more information on using the ImportCatalogToGlue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportCatalogToGlueRequest method.
//    req, resp := client.ImportCatalogToGlueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue
func (c *Glue) ImportCatalogToGlueRequest(input *ImportCatalogToGlueInput) (req *request.Request, output *ImportCatalogToGlueOutput) {
	op := &request.Operation{
		Name:       opImportCatalogToGlue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCatalogToGlueInput{}
	}

	output = &ImportCatalogToGlueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ImportCatalogToGlue API operation for AWS Glue.
//
// Imports an existing Amazon Athena Data Catalog to Glue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ImportCatalogToGlue for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue
func (c *Glue) ImportCatalogToGlue(input *ImportCatalogToGlueInput) (*ImportCatalogToGlueOutput, error) {
	req, out := c.ImportCatalogToGlueRequest(input)
	return out, req.Send()
}

// ImportCatalogToGlueWithContext is the same as ImportCatalogToGlue with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCatalogToGlue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ImportCatalogToGlueWithContext(ctx aws.Context, input *ImportCatalogToGlueInput, opts ...request.Option) (*ImportCatalogToGlueOutput, error) {
	req, out := c.ImportCatalogToGlueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBlueprints = "ListBlueprints"

// ListBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the ListBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBlueprints for more information on using the ListBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBlueprintsRequest method.
//    req, resp := client.ListBlueprintsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListBlueprints
func (c *Glue) ListBlueprintsRequest(input *ListBlueprintsInput) (req *request.Request, output *ListBlueprintsOutput) {
	op := &request.Operation{
		Name:       opListBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBlueprintsInput{}
	}

	output = &ListBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBlueprints API operation for AWS Glue.
//
// Lists all the blueprint names in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListBlueprints for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListBlueprints
func (c *Glue) ListBlueprints(input *ListBlueprintsInput) (*ListBlueprintsOutput, error) {
	req, out := c.ListBlueprintsRequest(input)
	return out, req.Send()
}

// ListBlueprintsWithContext is the same as ListBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See ListBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListBlueprintsWithContext(ctx aws.Context, input *ListBlueprintsInput, opts ...request.Option) (*ListBlueprintsOutput, error) {
	req, out := c.ListBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBlueprintsPages iterates over the pages of a ListBlueprints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBlueprints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBlueprints operation.
//    pageNum := 0
//    err := client.ListBlueprintsPages(params,
//        func(page *glue.ListBlueprintsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListBlueprintsPages(input *ListBlueprintsInput, fn func(*ListBlueprintsOutput, bool) bool) error {
	return c.ListBlueprintsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBlueprintsPagesWithContext same as ListBlueprintsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListBlueprintsPagesWithContext(ctx aws.Context, input *ListBlueprintsInput, fn func(*ListBlueprintsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBlueprintsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBlueprintsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBlueprintsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCrawlers = "ListCrawlers"

// ListCrawlersRequest generates a "aws/request.Request" representing the
// client's request for the ListCrawlers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCrawlers for more information on using the ListCrawlers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCrawlersRequest method.
//    req, resp := client.ListCrawlersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers
func (c *Glue) ListCrawlersRequest(input *ListCrawlersInput) (req *request.Request, output *ListCrawlersOutput) {
	op := &request.Operation{
		Name:       opListCrawlers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCrawlersInput{}
	}

	output = &ListCrawlersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCrawlers API operation for AWS Glue.
//
// Retrieves the names of all crawler resources in this Amazon Web Services
// account, or the resources with the specified tag. This operation allows you
// to see which resources are available in your account, and their names.
//
// This operation takes the optional Tags field, which you can use as a filter
// on the response so that tagged resources can be retrieved as a group. If
// you choose to use tags filtering, only resources with the tag are retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListCrawlers for usage and error information.
//
// Returned Error Types:
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers
func (c *Glue) ListCrawlers(input *ListCrawlersInput) (*ListCrawlersOutput, error) {
	req, out := c.ListCrawlersRequest(input)
	return out, req.Send()
}

// ListCrawlersWithContext is the same as ListCrawlers with the addition of
// the ability to pass a context and additional request options.
//
// See ListCrawlers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListCrawlersWithContext(ctx aws.Context, input *ListCrawlersInput, opts ...request.Option) (*ListCrawlersOutput, error) {
	req, out := c.ListCrawlersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCrawlersPages iterates over the pages of a ListCrawlers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCrawlers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCrawlers operation.
//    pageNum := 0
//    err := client.ListCrawlersPages(params,
//        func(page *glue.ListCrawlersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListCrawlersPages(input *ListCrawlersInput, fn func(*ListCrawlersOutput, bool) bool) error {
	return c.ListCrawlersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCrawlersPagesWithContext same as ListCrawlersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListCrawlersPagesWithContext(ctx aws.Context, input *ListCrawlersInput, fn func(*ListCrawlersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCrawlersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCrawlersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCrawlersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDevEndpoints = "ListDevEndpoints"

// ListDevEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListDevEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevEndpoints for more information on using the ListDevEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevEndpointsRequest method.
//    req, resp := client.ListDevEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints
func (c *Glue) ListDevEndpointsRequest(input *ListDevEndpointsInput) (req *request.Request, output *ListDevEndpointsOutput) {
	op := &request.Operation{
		Name:       opListDevEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevEndpointsInput{}
	}

	output = &ListDevEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevEndpoints API operation for AWS Glue.
//
// Retrieves the names of all DevEndpoint resources in this Amazon Web Services
// account, or the resources with the specified tag. This operation allows you
// to see which resources are available in your account, and their names.
//
// This operation takes the optional Tags field, which you can use as a filter
// on the response so that tagged resources can be retrieved as a group. If
// you choose to use tags filtering, only resources with the tag are retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListDevEndpoints for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints
func (c *Glue) ListDevEndpoints(input *ListDevEndpointsInput) (*ListDevEndpointsOutput, error) {
	req, out := c.ListDevEndpointsRequest(input)
	return out, req.Send()
}

// ListDevEndpointsWithContext is the same as ListDevEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListDevEndpointsWithContext(ctx aws.Context, input *ListDevEndpointsInput, opts ...request.Option) (*ListDevEndpointsOutput, error) {
	req, out := c.ListDevEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevEndpointsPages iterates over the pages of a ListDevEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevEndpoints operation.
//    pageNum := 0
//    err := client.ListDevEndpointsPages(params,
//        func(page *glue.ListDevEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListDevEndpointsPages(input *ListDevEndpointsInput, fn func(*ListDevEndpointsOutput, bool) bool) error {
	return c.ListDevEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevEndpointsPagesWithContext same as ListDevEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListDevEndpointsPagesWithContext(ctx aws.Context, input *ListDevEndpointsInput, fn func(*ListDevEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs
func (c *Glue) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Glue.
//
// Retrieves the names of all job resources in this Amazon Web Services account,
// or the resources with the specified tag. This operation allows you to see
// which resources are available in your account, and their names.
//
// This operation takes the optional Tags field, which you can use as a filter
// on the response so that tagged resources can be retrieved as a group. If
// you choose to use tags filtering, only resources with the tag are retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs
func (c *Glue) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *glue.ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMLTransforms = "ListMLTransforms"

// ListMLTransformsRequest generates a "aws/request.Request" representing the
// client's request for the ListMLTransforms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMLTransforms for more information on using the ListMLTransforms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMLTransformsRequest method.
//    req, resp := client.ListMLTransformsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms
func (c *Glue) ListMLTransformsRequest(input *ListMLTransformsInput) (req *request.Request, output *ListMLTransformsOutput) {
	op := &request.Operation{
		Name:       opListMLTransforms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMLTransformsInput{}
	}

	output = &ListMLTransformsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMLTransforms API operation for AWS Glue.
//
// Retrieves a sortable, filterable list of existing Glue machine learning transforms
// in this Amazon Web Services account, or the resources with the specified
// tag. This operation takes the optional Tags field, which you can use as a
// filter of the responses so that tagged resources can be retrieved as a group.
// If you choose to use tag filtering, only resources with the tags are retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListMLTransforms for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms
func (c *Glue) ListMLTransforms(input *ListMLTransformsInput) (*ListMLTransformsOutput, error) {
	req, out := c.ListMLTransformsRequest(input)
	return out, req.Send()
}

// ListMLTransformsWithContext is the same as ListMLTransforms with the addition of
// the ability to pass a context and additional request options.
//
// See ListMLTransforms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListMLTransformsWithContext(ctx aws.Context, input *ListMLTransformsInput, opts ...request.Option) (*ListMLTransformsOutput, error) {
	req, out := c.ListMLTransformsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMLTransformsPages iterates over the pages of a ListMLTransforms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMLTransforms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMLTransforms operation.
//    pageNum := 0
//    err := client.ListMLTransformsPages(params,
//        func(page *glue.ListMLTransformsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListMLTransformsPages(input *ListMLTransformsInput, fn func(*ListMLTransformsOutput, bool) bool) error {
	return c.ListMLTransformsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMLTransformsPagesWithContext same as ListMLTransformsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListMLTransformsPagesWithContext(ctx aws.Context, input *ListMLTransformsInput, fn func(*ListMLTransformsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMLTransformsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMLTransformsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMLTransformsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRegistries = "ListRegistries"

// ListRegistriesRequest generates a "aws/request.Request" representing the
// client's request for the ListRegistries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegistries for more information on using the ListRegistries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegistriesRequest method.
//    req, resp := client.ListRegistriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListRegistries
func (c *Glue) ListRegistriesRequest(input *ListRegistriesInput) (req *request.Request, output *ListRegistriesOutput) {
	op := &request.Operation{
		Name:       opListRegistries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRegistriesInput{}
	}

	output = &ListRegistriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRegistries API operation for AWS Glue.
//
// Returns a list of registries that you have created, with minimal registry
// information. Registries in the Deleting status will not be included in the
// results. Empty results will be returned if there are no registries available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListRegistries for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListRegistries
func (c *Glue) ListRegistries(input *ListRegistriesInput) (*ListRegistriesOutput, error) {
	req, out := c.ListRegistriesRequest(input)
	return out, req.Send()
}

// ListRegistriesWithContext is the same as ListRegistries with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegistries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListRegistriesWithContext(ctx aws.Context, input *ListRegistriesInput, opts ...request.Option) (*ListRegistriesOutput, error) {
	req, out := c.ListRegistriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRegistriesPages iterates over the pages of a ListRegistries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRegistries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRegistries operation.
//    pageNum := 0
//    err := client.ListRegistriesPages(params,
//        func(page *glue.ListRegistriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListRegistriesPages(input *ListRegistriesInput, fn func(*ListRegistriesOutput, bool) bool) error {
	return c.ListRegistriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRegistriesPagesWithContext same as ListRegistriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListRegistriesPagesWithContext(ctx aws.Context, input *ListRegistriesInput, fn func(*ListRegistriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRegistriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRegistriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRegistriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemaVersions = "ListSchemaVersions"

// ListSchemaVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemaVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemaVersions for more information on using the ListSchemaVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSchemaVersionsRequest method.
//    req, resp := client.ListSchemaVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemaVersions
func (c *Glue) ListSchemaVersionsRequest(input *ListSchemaVersionsInput) (req *request.Request, output *ListSchemaVersionsOutput) {
	op := &request.Operation{
		Name:       opListSchemaVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemaVersionsInput{}
	}

	output = &ListSchemaVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemaVersions API operation for AWS Glue.
//
// Returns a list of schema versions that you have created, with minimal information.
// Schema versions in Deleted status will not be included in the results. Empty
// results will be returned if there are no schema versions available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListSchemaVersions for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemaVersions
func (c *Glue) ListSchemaVersions(input *ListSchemaVersionsInput) (*ListSchemaVersionsOutput, error) {
	req, out := c.ListSchemaVersionsRequest(input)
	return out, req.Send()
}

// ListSchemaVersionsWithContext is the same as ListSchemaVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemaVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListSchemaVersionsWithContext(ctx aws.Context, input *ListSchemaVersionsInput, opts ...request.Option) (*ListSchemaVersionsOutput, error) {
	req, out := c.ListSchemaVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemaVersionsPages iterates over the pages of a ListSchemaVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemaVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSchemaVersions operation.
//    pageNum := 0
//    err := client.ListSchemaVersionsPages(params,
//        func(page *glue.ListSchemaVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListSchemaVersionsPages(input *ListSchemaVersionsInput, fn func(*ListSchemaVersionsOutput, bool) bool) error {
	return c.ListSchemaVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemaVersionsPagesWithContext same as ListSchemaVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListSchemaVersionsPagesWithContext(ctx aws.Context, input *ListSchemaVersionsInput, fn func(*ListSchemaVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemaVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemaVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemaVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemas = "ListSchemas"

// ListSchemasRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemas for more information on using the ListSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSchemasRequest method.
//    req, resp := client.ListSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemas
func (c *Glue) ListSchemasRequest(input *ListSchemasInput) (req *request.Request, output *ListSchemasOutput) {
	op := &request.Operation{
		Name:       opListSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemasInput{}
	}

	output = &ListSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemas API operation for AWS Glue.
//
// Returns a list of schemas with minimal details. Schemas in Deleting status
// will not be included in the results. Empty results will be returned if there
// are no schemas available.
//
// When the RegistryId is not provided, all the schemas across registries will
// be part of the API response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListSchemas for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemas
func (c *Glue) ListSchemas(input *ListSchemasInput) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	return out, req.Send()
}

// ListSchemasWithContext is the same as ListSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListSchemasWithContext(ctx aws.Context, input *ListSchemasInput, opts ...request.Option) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemasPages iterates over the pages of a ListSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSchemas operation.
//    pageNum := 0
//    err := client.ListSchemasPages(params,
//        func(page *glue.ListSchemasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListSchemasPages(input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool) error {
	return c.ListSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemasPagesWithContext same as ListSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListSchemasPagesWithContext(ctx aws.Context, input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSessions = "ListSessions"

// ListSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSessions for more information on using the ListSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSessionsRequest method.
//    req, resp := client.ListSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSessions
func (c *Glue) ListSessionsRequest(input *ListSessionsInput) (req *request.Request, output *ListSessionsOutput) {
	op := &request.Operation{
		Name:       opListSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSessionsInput{}
	}

	output = &ListSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSessions API operation for AWS Glue.
//
// Retrieve a session..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListSessions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSessions
func (c *Glue) ListSessions(input *ListSessionsInput) (*ListSessionsOutput, error) {
	req, out := c.ListSessionsRequest(input)
	return out, req.Send()
}

// ListSessionsWithContext is the same as ListSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListSessionsWithContext(ctx aws.Context, input *ListSessionsInput, opts ...request.Option) (*ListSessionsOutput, error) {
	req, out := c.ListSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSessionsPages iterates over the pages of a ListSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSessions operation.
//    pageNum := 0
//    err := client.ListSessionsPages(params,
//        func(page *glue.ListSessionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListSessionsPages(input *ListSessionsInput, fn func(*ListSessionsOutput, bool) bool) error {
	return c.ListSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSessionsPagesWithContext same as ListSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListSessionsPagesWithContext(ctx aws.Context, input *ListSessionsInput, fn func(*ListSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStatements = "ListStatements"

// ListStatementsRequest generates a "aws/request.Request" representing the
// client's request for the ListStatements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStatements for more information on using the ListStatements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStatementsRequest method.
//    req, resp := client.ListStatementsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListStatements
func (c *Glue) ListStatementsRequest(input *ListStatementsInput) (req *request.Request, output *ListStatementsOutput) {
	op := &request.Operation{
		Name:       opListStatements,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStatementsInput{}
	}

	output = &ListStatementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStatements API operation for AWS Glue.
//
// Lists statements for the session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListStatements for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * IllegalSessionStateException
//   The session is in an invalid state to perform a requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListStatements
func (c *Glue) ListStatements(input *ListStatementsInput) (*ListStatementsOutput, error) {
	req, out := c.ListStatementsRequest(input)
	return out, req.Send()
}

// ListStatementsWithContext is the same as ListStatements with the addition of
// the ability to pass a context and additional request options.
//
// See ListStatements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListStatementsWithContext(ctx aws.Context, input *ListStatementsInput, opts ...request.Option) (*ListStatementsOutput, error) {
	req, out := c.ListStatementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTriggers = "ListTriggers"

// ListTriggersRequest generates a "aws/request.Request" representing the
// client's request for the ListTriggers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTriggers for more information on using the ListTriggers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTriggersRequest method.
//    req, resp := client.ListTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers
func (c *Glue) ListTriggersRequest(input *ListTriggersInput) (req *request.Request, output *ListTriggersOutput) {
	op := &request.Operation{
		Name:       opListTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTriggersInput{}
	}

	output = &ListTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTriggers API operation for AWS Glue.
//
// Retrieves the names of all trigger resources in this Amazon Web Services
// account, or the resources with the specified tag. This operation allows you
// to see which resources are available in your account, and their names.
//
// This operation takes the optional Tags field, which you can use as a filter
// on the response so that tagged resources can be retrieved as a group. If
// you choose to use tags filtering, only resources with the tag are retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListTriggers for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers
func (c *Glue) ListTriggers(input *ListTriggersInput) (*ListTriggersOutput, error) {
	req, out := c.ListTriggersRequest(input)
	return out, req.Send()
}

// ListTriggersWithContext is the same as ListTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListTriggersWithContext(ctx aws.Context, input *ListTriggersInput, opts ...request.Option) (*ListTriggersOutput, error) {
	req, out := c.ListTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTriggersPages iterates over the pages of a ListTriggers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTriggers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTriggers operation.
//    pageNum := 0
//    err := client.ListTriggersPages(params,
//        func(page *glue.ListTriggersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListTriggersPages(input *ListTriggersInput, fn func(*ListTriggersOutput, bool) bool) error {
	return c.ListTriggersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTriggersPagesWithContext same as ListTriggersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListTriggersPagesWithContext(ctx aws.Context, input *ListTriggersInput, fn func(*ListTriggersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTriggersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTriggersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTriggersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkflows = "ListWorkflows"

// ListWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflows for more information on using the ListWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkflowsRequest method.
//    req, resp := client.ListWorkflowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows
func (c *Glue) ListWorkflowsRequest(input *ListWorkflowsInput) (req *request.Request, output *ListWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListWorkflows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowsInput{}
	}

	output = &ListWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkflows API operation for AWS Glue.
//
// Lists names of workflows created in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ListWorkflows for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows
func (c *Glue) ListWorkflows(input *ListWorkflowsInput) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	return out, req.Send()
}

// ListWorkflowsWithContext is the same as ListWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListWorkflowsWithContext(ctx aws.Context, input *ListWorkflowsInput, opts ...request.Option) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkflowsPages iterates over the pages of a ListWorkflows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkflows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkflows operation.
//    pageNum := 0
//    err := client.ListWorkflowsPages(params,
//        func(page *glue.ListWorkflowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) ListWorkflowsPages(input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool) error {
	return c.ListWorkflowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkflowsPagesWithContext same as ListWorkflowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ListWorkflowsPagesWithContext(ctx aws.Context, input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkflowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkflowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkflowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDataCatalogEncryptionSettings = "PutDataCatalogEncryptionSettings"

// PutDataCatalogEncryptionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutDataCatalogEncryptionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDataCatalogEncryptionSettings for more information on using the PutDataCatalogEncryptionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDataCatalogEncryptionSettingsRequest method.
//    req, resp := client.PutDataCatalogEncryptionSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutDataCatalogEncryptionSettings
func (c *Glue) PutDataCatalogEncryptionSettingsRequest(input *PutDataCatalogEncryptionSettingsInput) (req *request.Request, output *PutDataCatalogEncryptionSettingsOutput) {
	op := &request.Operation{
		Name:       opPutDataCatalogEncryptionSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDataCatalogEncryptionSettingsInput{}
	}

	output = &PutDataCatalogEncryptionSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDataCatalogEncryptionSettings API operation for AWS Glue.
//
// Sets the security configuration for a specified catalog. After the configuration
// has been set, the specified encryption is applied to every catalog write
// thereafter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation PutDataCatalogEncryptionSettings for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutDataCatalogEncryptionSettings
func (c *Glue) PutDataCatalogEncryptionSettings(input *PutDataCatalogEncryptionSettingsInput) (*PutDataCatalogEncryptionSettingsOutput, error) {
	req, out := c.PutDataCatalogEncryptionSettingsRequest(input)
	return out, req.Send()
}

// PutDataCatalogEncryptionSettingsWithContext is the same as PutDataCatalogEncryptionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutDataCatalogEncryptionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) PutDataCatalogEncryptionSettingsWithContext(ctx aws.Context, input *PutDataCatalogEncryptionSettingsInput, opts ...request.Option) (*PutDataCatalogEncryptionSettingsOutput, error) {
	req, out := c.PutDataCatalogEncryptionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourcePolicyRequest method.
//    req, resp := client.PutResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutResourcePolicy
func (c *Glue) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for AWS Glue.
//
// Sets the Data Catalog resource policy for access control.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * ConditionCheckFailureException
//   A specified condition was not satisfied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutResourcePolicy
func (c *Glue) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSchemaVersionMetadata = "PutSchemaVersionMetadata"

// PutSchemaVersionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the PutSchemaVersionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSchemaVersionMetadata for more information on using the PutSchemaVersionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSchemaVersionMetadataRequest method.
//    req, resp := client.PutSchemaVersionMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutSchemaVersionMetadata
func (c *Glue) PutSchemaVersionMetadataRequest(input *PutSchemaVersionMetadataInput) (req *request.Request, output *PutSchemaVersionMetadataOutput) {
	op := &request.Operation{
		Name:       opPutSchemaVersionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutSchemaVersionMetadataInput{}
	}

	output = &PutSchemaVersionMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSchemaVersionMetadata API operation for AWS Glue.
//
// Puts the metadata key value pair for a specified schema version ID. A maximum
// of 10 key value pairs will be allowed per schema version. They can be added
// over one or more calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation PutSchemaVersionMetadata for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutSchemaVersionMetadata
func (c *Glue) PutSchemaVersionMetadata(input *PutSchemaVersionMetadataInput) (*PutSchemaVersionMetadataOutput, error) {
	req, out := c.PutSchemaVersionMetadataRequest(input)
	return out, req.Send()
}

// PutSchemaVersionMetadataWithContext is the same as PutSchemaVersionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See PutSchemaVersionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) PutSchemaVersionMetadataWithContext(ctx aws.Context, input *PutSchemaVersionMetadataInput, opts ...request.Option) (*PutSchemaVersionMetadataOutput, error) {
	req, out := c.PutSchemaVersionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutWorkflowRunProperties = "PutWorkflowRunProperties"

// PutWorkflowRunPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the PutWorkflowRunProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutWorkflowRunProperties for more information on using the PutWorkflowRunProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutWorkflowRunPropertiesRequest method.
//    req, resp := client.PutWorkflowRunPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutWorkflowRunProperties
func (c *Glue) PutWorkflowRunPropertiesRequest(input *PutWorkflowRunPropertiesInput) (req *request.Request, output *PutWorkflowRunPropertiesOutput) {
	op := &request.Operation{
		Name:       opPutWorkflowRunProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutWorkflowRunPropertiesInput{}
	}

	output = &PutWorkflowRunPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutWorkflowRunProperties API operation for AWS Glue.
//
// Puts the specified workflow run properties for the given workflow run. If
// a property already exists for the specified run, then it overrides the value
// otherwise adds the property to existing properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation PutWorkflowRunProperties for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   A resource to be created or added already exists.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutWorkflowRunProperties
func (c *Glue) PutWorkflowRunProperties(input *PutWorkflowRunPropertiesInput) (*PutWorkflowRunPropertiesOutput, error) {
	req, out := c.PutWorkflowRunPropertiesRequest(input)
	return out, req.Send()
}

// PutWorkflowRunPropertiesWithContext is the same as PutWorkflowRunProperties with the addition of
// the ability to pass a context and additional request options.
//
// See PutWorkflowRunProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) PutWorkflowRunPropertiesWithContext(ctx aws.Context, input *PutWorkflowRunPropertiesInput, opts ...request.Option) (*PutWorkflowRunPropertiesOutput, error) {
	req, out := c.PutWorkflowRunPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQuerySchemaVersionMetadata = "QuerySchemaVersionMetadata"

// QuerySchemaVersionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the QuerySchemaVersionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See QuerySchemaVersionMetadata for more information on using the QuerySchemaVersionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QuerySchemaVersionMetadataRequest method.
//    req, resp := client.QuerySchemaVersionMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/QuerySchemaVersionMetadata
func (c *Glue) QuerySchemaVersionMetadataRequest(input *QuerySchemaVersionMetadataInput) (req *request.Request, output *QuerySchemaVersionMetadataOutput) {
	op := &request.Operation{
		Name:       opQuerySchemaVersionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QuerySchemaVersionMetadataInput{}
	}

	output = &QuerySchemaVersionMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// QuerySchemaVersionMetadata API operation for AWS Glue.
//
// Queries for the schema version metadata information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation QuerySchemaVersionMetadata for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/QuerySchemaVersionMetadata
func (c *Glue) QuerySchemaVersionMetadata(input *QuerySchemaVersionMetadataInput) (*QuerySchemaVersionMetadataOutput, error) {
	req, out := c.QuerySchemaVersionMetadataRequest(input)
	return out, req.Send()
}

// QuerySchemaVersionMetadataWithContext is the same as QuerySchemaVersionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See QuerySchemaVersionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) QuerySchemaVersionMetadataWithContext(ctx aws.Context, input *QuerySchemaVersionMetadataInput, opts ...request.Option) (*QuerySchemaVersionMetadataOutput, error) {
	req, out := c.QuerySchemaVersionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterSchemaVersion = "RegisterSchemaVersion"

// RegisterSchemaVersionRequest generates a "aws/request.Request" representing the
// client's request for the RegisterSchemaVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterSchemaVersion for more information on using the RegisterSchemaVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterSchemaVersionRequest method.
//    req, resp := client.RegisterSchemaVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RegisterSchemaVersion
func (c *Glue) RegisterSchemaVersionRequest(input *RegisterSchemaVersionInput) (req *request.Request, output *RegisterSchemaVersionOutput) {
	op := &request.Operation{
		Name:       opRegisterSchemaVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterSchemaVersionInput{}
	}

	output = &RegisterSchemaVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterSchemaVersion API operation for AWS Glue.
//
// Adds a new version to the existing schema. Returns an error if new version
// of schema does not meet the compatibility requirements of the schema set.
// This API will not create a new schema set and will return a 404 error if
// the schema set is not already present in the Schema Registry.
//
// If this is the first schema definition to be registered in the Schema Registry,
// this API will store the schema version and return immediately. Otherwise,
// this call has the potential to run longer than other operations due to compatibility
// modes. You can call the GetSchemaVersion API with the SchemaVersionId to
// check compatibility modes.
//
// If the same schema definition is already stored in Schema Registry as a version,
// the schema ID of the existing schema is returned to the caller.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation RegisterSchemaVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RegisterSchemaVersion
func (c *Glue) RegisterSchemaVersion(input *RegisterSchemaVersionInput) (*RegisterSchemaVersionOutput, error) {
	req, out := c.RegisterSchemaVersionRequest(input)
	return out, req.Send()
}

// RegisterSchemaVersionWithContext is the same as RegisterSchemaVersion with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterSchemaVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) RegisterSchemaVersionWithContext(ctx aws.Context, input *RegisterSchemaVersionInput, opts ...request.Option) (*RegisterSchemaVersionOutput, error) {
	req, out := c.RegisterSchemaVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveSchemaVersionMetadata = "RemoveSchemaVersionMetadata"

// RemoveSchemaVersionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the RemoveSchemaVersionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveSchemaVersionMetadata for more information on using the RemoveSchemaVersionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveSchemaVersionMetadataRequest method.
//    req, resp := client.RemoveSchemaVersionMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RemoveSchemaVersionMetadata
func (c *Glue) RemoveSchemaVersionMetadataRequest(input *RemoveSchemaVersionMetadataInput) (req *request.Request, output *RemoveSchemaVersionMetadataOutput) {
	op := &request.Operation{
		Name:       opRemoveSchemaVersionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveSchemaVersionMetadataInput{}
	}

	output = &RemoveSchemaVersionMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveSchemaVersionMetadata API operation for AWS Glue.
//
// Removes a key value pair from the schema version metadata for the specified
// schema version ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation RemoveSchemaVersionMetadata for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RemoveSchemaVersionMetadata
func (c *Glue) RemoveSchemaVersionMetadata(input *RemoveSchemaVersionMetadataInput) (*RemoveSchemaVersionMetadataOutput, error) {
	req, out := c.RemoveSchemaVersionMetadataRequest(input)
	return out, req.Send()
}

// RemoveSchemaVersionMetadataWithContext is the same as RemoveSchemaVersionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveSchemaVersionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) RemoveSchemaVersionMetadataWithContext(ctx aws.Context, input *RemoveSchemaVersionMetadataInput, opts ...request.Option) (*RemoveSchemaVersionMetadataOutput, error) {
	req, out := c.RemoveSchemaVersionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetJobBookmark = "ResetJobBookmark"

// ResetJobBookmarkRequest generates a "aws/request.Request" representing the
// client's request for the ResetJobBookmark operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetJobBookmark for more information on using the ResetJobBookmark
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetJobBookmarkRequest method.
//    req, resp := client.ResetJobBookmarkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark
func (c *Glue) ResetJobBookmarkRequest(input *ResetJobBookmarkInput) (req *request.Request, output *ResetJobBookmarkOutput) {
	op := &request.Operation{
		Name:       opResetJobBookmark,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetJobBookmarkInput{}
	}

	output = &ResetJobBookmarkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetJobBookmark API operation for AWS Glue.
//
// Resets a bookmark entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ResetJobBookmark for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark
func (c *Glue) ResetJobBookmark(input *ResetJobBookmarkInput) (*ResetJobBookmarkOutput, error) {
	req, out := c.ResetJobBookmarkRequest(input)
	return out, req.Send()
}

// ResetJobBookmarkWithContext is the same as ResetJobBookmark with the addition of
// the ability to pass a context and additional request options.
//
// See ResetJobBookmark for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ResetJobBookmarkWithContext(ctx aws.Context, input *ResetJobBookmarkInput, opts ...request.Option) (*ResetJobBookmarkOutput, error) {
	req, out := c.ResetJobBookmarkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeWorkflowRun = "ResumeWorkflowRun"

// ResumeWorkflowRunRequest generates a "aws/request.Request" representing the
// client's request for the ResumeWorkflowRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeWorkflowRun for more information on using the ResumeWorkflowRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResumeWorkflowRunRequest method.
//    req, resp := client.ResumeWorkflowRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResumeWorkflowRun
func (c *Glue) ResumeWorkflowRunRequest(input *ResumeWorkflowRunInput) (req *request.Request, output *ResumeWorkflowRunOutput) {
	op := &request.Operation{
		Name:       opResumeWorkflowRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResumeWorkflowRunInput{}
	}

	output = &ResumeWorkflowRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResumeWorkflowRun API operation for AWS Glue.
//
// Restarts selected nodes of a previous partially completed workflow run and
// resumes the workflow run. The selected nodes and all nodes that are downstream
// from the selected nodes are run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ResumeWorkflowRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentRunsExceededException
//   Too many jobs are being run concurrently.
//
//   * IllegalWorkflowStateException
//   The workflow is in an invalid state to perform a requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResumeWorkflowRun
func (c *Glue) ResumeWorkflowRun(input *ResumeWorkflowRunInput) (*ResumeWorkflowRunOutput, error) {
	req, out := c.ResumeWorkflowRunRequest(input)
	return out, req.Send()
}

// ResumeWorkflowRunWithContext is the same as ResumeWorkflowRun with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeWorkflowRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ResumeWorkflowRunWithContext(ctx aws.Context, input *ResumeWorkflowRunInput, opts ...request.Option) (*ResumeWorkflowRunOutput, error) {
	req, out := c.ResumeWorkflowRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunStatement = "RunStatement"

// RunStatementRequest generates a "aws/request.Request" representing the
// client's request for the RunStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RunStatement for more information on using the RunStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RunStatementRequest method.
//    req, resp := client.RunStatementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RunStatement
func (c *Glue) RunStatementRequest(input *RunStatementInput) (req *request.Request, output *RunStatementOutput) {
	op := &request.Operation{
		Name:       opRunStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunStatementInput{}
	}

	output = &RunStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RunStatement API operation for AWS Glue.
//
// Executes the statement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation RunStatement for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * ValidationException
//   A value could not be validated.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * IllegalSessionStateException
//   The session is in an invalid state to perform a requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RunStatement
func (c *Glue) RunStatement(input *RunStatementInput) (*RunStatementOutput, error) {
	req, out := c.RunStatementRequest(input)
	return out, req.Send()
}

// RunStatementWithContext is the same as RunStatement with the addition of
// the ability to pass a context and additional request options.
//
// See RunStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) RunStatementWithContext(ctx aws.Context, input *RunStatementInput, opts ...request.Option) (*RunStatementOutput, error) {
	req, out := c.RunStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchTables = "SearchTables"

// SearchTablesRequest generates a "aws/request.Request" representing the
// client's request for the SearchTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchTables for more information on using the SearchTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchTablesRequest method.
//    req, resp := client.SearchTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables
func (c *Glue) SearchTablesRequest(input *SearchTablesInput) (req *request.Request, output *SearchTablesOutput) {
	op := &request.Operation{
		Name:       opSearchTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchTablesInput{}
	}

	output = &SearchTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchTables API operation for AWS Glue.
//
// Searches a set of tables based on properties in the table metadata as well
// as on the parent database. You can search against text or filter conditions.
//
// You can only get tables that you have access to based on the security policies
// defined in Lake Formation. You need at least a read-only access to the table
// for it to be returned. If you do not have access to all the columns in the
// table, these columns will not be searched against when returning the list
// of tables back to you. If you have access to the columns but not the data
// in the columns, those columns and the associated metadata for those columns
// will be included in the search.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation SearchTables for usage and error information.
//
// Returned Error Types:
//   * InternalServiceException
//   An internal service error occurred.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables
func (c *Glue) SearchTables(input *SearchTablesInput) (*SearchTablesOutput, error) {
	req, out := c.SearchTablesRequest(input)
	return out, req.Send()
}

// SearchTablesWithContext is the same as SearchTables with the addition of
// the ability to pass a context and additional request options.
//
// See SearchTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) SearchTablesWithContext(ctx aws.Context, input *SearchTablesInput, opts ...request.Option) (*SearchTablesOutput, error) {
	req, out := c.SearchTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchTablesPages iterates over the pages of a SearchTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchTables operation.
//    pageNum := 0
//    err := client.SearchTablesPages(params,
//        func(page *glue.SearchTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) SearchTablesPages(input *SearchTablesInput, fn func(*SearchTablesOutput, bool) bool) error {
	return c.SearchTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchTablesPagesWithContext same as SearchTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) SearchTablesPagesWithContext(ctx aws.Context, input *SearchTablesInput, fn func(*SearchTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartBlueprintRun = "StartBlueprintRun"

// StartBlueprintRunRequest generates a "aws/request.Request" representing the
// client's request for the StartBlueprintRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBlueprintRun for more information on using the StartBlueprintRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartBlueprintRunRequest method.
//    req, resp := client.StartBlueprintRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartBlueprintRun
func (c *Glue) StartBlueprintRunRequest(input *StartBlueprintRunInput) (req *request.Request, output *StartBlueprintRunOutput) {
	op := &request.Operation{
		Name:       opStartBlueprintRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartBlueprintRunInput{}
	}

	output = &StartBlueprintRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBlueprintRun API operation for AWS Glue.
//
// Starts a new run of the specified blueprint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartBlueprintRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * IllegalBlueprintStateException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartBlueprintRun
func (c *Glue) StartBlueprintRun(input *StartBlueprintRunInput) (*StartBlueprintRunOutput, error) {
	req, out := c.StartBlueprintRunRequest(input)
	return out, req.Send()
}

// StartBlueprintRunWithContext is the same as StartBlueprintRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartBlueprintRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartBlueprintRunWithContext(ctx aws.Context, input *StartBlueprintRunInput, opts ...request.Option) (*StartBlueprintRunOutput, error) {
	req, out := c.StartBlueprintRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCrawler = "StartCrawler"

// StartCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the StartCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCrawler for more information on using the StartCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCrawlerRequest method.
//    req, resp := client.StartCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawler
func (c *Glue) StartCrawlerRequest(input *StartCrawlerInput) (req *request.Request, output *StartCrawlerOutput) {
	op := &request.Operation{
		Name:       opStartCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartCrawlerInput{}
	}

	output = &StartCrawlerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartCrawler API operation for AWS Glue.
//
// Starts a crawl using the specified crawler, regardless of what is scheduled.
// If the crawler is already running, returns a CrawlerRunningException (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartCrawler for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * CrawlerRunningException
//   The operation cannot be performed because the crawler is already running.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawler
func (c *Glue) StartCrawler(input *StartCrawlerInput) (*StartCrawlerOutput, error) {
	req, out := c.StartCrawlerRequest(input)
	return out, req.Send()
}

// StartCrawlerWithContext is the same as StartCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See StartCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartCrawlerWithContext(ctx aws.Context, input *StartCrawlerInput, opts ...request.Option) (*StartCrawlerOutput, error) {
	req, out := c.StartCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCrawlerSchedule = "StartCrawlerSchedule"

// StartCrawlerScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StartCrawlerSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCrawlerSchedule for more information on using the StartCrawlerSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCrawlerScheduleRequest method.
//    req, resp := client.StartCrawlerScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawlerSchedule
func (c *Glue) StartCrawlerScheduleRequest(input *StartCrawlerScheduleInput) (req *request.Request, output *StartCrawlerScheduleOutput) {
	op := &request.Operation{
		Name:       opStartCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartCrawlerScheduleInput{}
	}

	output = &StartCrawlerScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartCrawlerSchedule API operation for AWS Glue.
//
// Changes the schedule state of the specified crawler to SCHEDULED, unless
// the crawler is already running or the schedule state is already SCHEDULED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartCrawlerSchedule for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * SchedulerRunningException
//   The specified scheduler is already running.
//
//   * SchedulerTransitioningException
//   The specified scheduler is transitioning.
//
//   * NoScheduleException
//   There is no applicable schedule.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawlerSchedule
func (c *Glue) StartCrawlerSchedule(input *StartCrawlerScheduleInput) (*StartCrawlerScheduleOutput, error) {
	req, out := c.StartCrawlerScheduleRequest(input)
	return out, req.Send()
}

// StartCrawlerScheduleWithContext is the same as StartCrawlerSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StartCrawlerSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartCrawlerScheduleWithContext(ctx aws.Context, input *StartCrawlerScheduleInput, opts ...request.Option) (*StartCrawlerScheduleOutput, error) {
	req, out := c.StartCrawlerScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExportLabelsTaskRun = "StartExportLabelsTaskRun"

// StartExportLabelsTaskRunRequest generates a "aws/request.Request" representing the
// client's request for the StartExportLabelsTaskRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExportLabelsTaskRun for more information on using the StartExportLabelsTaskRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartExportLabelsTaskRunRequest method.
//    req, resp := client.StartExportLabelsTaskRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartExportLabelsTaskRun
func (c *Glue) StartExportLabelsTaskRunRequest(input *StartExportLabelsTaskRunInput) (req *request.Request, output *StartExportLabelsTaskRunOutput) {
	op := &request.Operation{
		Name:       opStartExportLabelsTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExportLabelsTaskRunInput{}
	}

	output = &StartExportLabelsTaskRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExportLabelsTaskRun API operation for AWS Glue.
//
// Begins an asynchronous task to export all labeled data for a particular transform.
// This task is the only label-related API call that is not part of the typical
// active learning workflow. You typically use StartExportLabelsTaskRun when
// you want to work with all of your existing labels at the same time, such
// as when you want to remove or change labels that were previously submitted
// as truth. This API operation accepts the TransformId whose labels you want
// to export and an Amazon Simple Storage Service (Amazon S3) path to export
// the labels to. The operation returns a TaskRunId. You can check on the status
// of your task run by calling the GetMLTaskRun API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartExportLabelsTaskRun for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartExportLabelsTaskRun
func (c *Glue) StartExportLabelsTaskRun(input *StartExportLabelsTaskRunInput) (*StartExportLabelsTaskRunOutput, error) {
	req, out := c.StartExportLabelsTaskRunRequest(input)
	return out, req.Send()
}

// StartExportLabelsTaskRunWithContext is the same as StartExportLabelsTaskRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartExportLabelsTaskRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartExportLabelsTaskRunWithContext(ctx aws.Context, input *StartExportLabelsTaskRunInput, opts ...request.Option) (*StartExportLabelsTaskRunOutput, error) {
	req, out := c.StartExportLabelsTaskRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImportLabelsTaskRun = "StartImportLabelsTaskRun"

// StartImportLabelsTaskRunRequest generates a "aws/request.Request" representing the
// client's request for the StartImportLabelsTaskRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImportLabelsTaskRun for more information on using the StartImportLabelsTaskRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartImportLabelsTaskRunRequest method.
//    req, resp := client.StartImportLabelsTaskRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartImportLabelsTaskRun
func (c *Glue) StartImportLabelsTaskRunRequest(input *StartImportLabelsTaskRunInput) (req *request.Request, output *StartImportLabelsTaskRunOutput) {
	op := &request.Operation{
		Name:       opStartImportLabelsTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartImportLabelsTaskRunInput{}
	}

	output = &StartImportLabelsTaskRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImportLabelsTaskRun API operation for AWS Glue.
//
// Enables you to provide additional labels (examples of truth) to be used to
// teach the machine learning transform and improve its quality. This API operation
// is generally used as part of the active learning workflow that starts with
// the StartMLLabelingSetGenerationTaskRun call and that ultimately results
// in improving the quality of your machine learning transform.
//
// After the StartMLLabelingSetGenerationTaskRun finishes, Glue machine learning
// will have generated a series of questions for humans to answer. (Answering
// these questions is often called 'labeling' in the machine learning workflows).
// In the case of the FindMatches transform, these questions are of the form,
// “What is the correct way to group these rows together into groups composed
// entirely of matching records?” After the labeling process is finished,
// users upload their answers/labels with a call to StartImportLabelsTaskRun.
// After StartImportLabelsTaskRun finishes, all future runs of the machine learning
// transform use the new and improved labels and perform a higher-quality transformation.
//
// By default, StartMLLabelingSetGenerationTaskRun continually learns from and
// combines all labels that you upload unless you set Replace to true. If you
// set Replace to true, StartImportLabelsTaskRun deletes and forgets all previously
// uploaded labels and learns only from the exact set that you upload. Replacing
// labels can be helpful if you realize that you previously uploaded incorrect
// labels, and you believe that they are having a negative effect on your transform
// quality.
//
// You can check on the status of your task run by calling the GetMLTaskRun
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartImportLabelsTaskRun for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartImportLabelsTaskRun
func (c *Glue) StartImportLabelsTaskRun(input *StartImportLabelsTaskRunInput) (*StartImportLabelsTaskRunOutput, error) {
	req, out := c.StartImportLabelsTaskRunRequest(input)
	return out, req.Send()
}

// StartImportLabelsTaskRunWithContext is the same as StartImportLabelsTaskRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartImportLabelsTaskRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartImportLabelsTaskRunWithContext(ctx aws.Context, input *StartImportLabelsTaskRunInput, opts ...request.Option) (*StartImportLabelsTaskRunOutput, error) {
	req, out := c.StartImportLabelsTaskRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartJobRun = "StartJobRun"

// StartJobRunRequest generates a "aws/request.Request" representing the
// client's request for the StartJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartJobRun for more information on using the StartJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartJobRunRequest method.
//    req, resp := client.StartJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartJobRun
func (c *Glue) StartJobRunRequest(input *StartJobRunInput) (req *request.Request, output *StartJobRunOutput) {
	op := &request.Operation{
		Name:       opStartJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartJobRunInput{}
	}

	output = &StartJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartJobRun API operation for AWS Glue.
//
// Starts a job run using a job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartJobRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentRunsExceededException
//   Too many jobs are being run concurrently.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartJobRun
func (c *Glue) StartJobRun(input *StartJobRunInput) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	return out, req.Send()
}

// StartJobRunWithContext is the same as StartJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartJobRunWithContext(ctx aws.Context, input *StartJobRunInput, opts ...request.Option) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMLEvaluationTaskRun = "StartMLEvaluationTaskRun"

// StartMLEvaluationTaskRunRequest generates a "aws/request.Request" representing the
// client's request for the StartMLEvaluationTaskRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMLEvaluationTaskRun for more information on using the StartMLEvaluationTaskRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMLEvaluationTaskRunRequest method.
//    req, resp := client.StartMLEvaluationTaskRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLEvaluationTaskRun
func (c *Glue) StartMLEvaluationTaskRunRequest(input *StartMLEvaluationTaskRunInput) (req *request.Request, output *StartMLEvaluationTaskRunOutput) {
	op := &request.Operation{
		Name:       opStartMLEvaluationTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMLEvaluationTaskRunInput{}
	}

	output = &StartMLEvaluationTaskRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMLEvaluationTaskRun API operation for AWS Glue.
//
// Starts a task to estimate the quality of the transform.
//
// When you provide label sets as examples of truth, Glue machine learning uses
// some of those examples to learn from them. The rest of the labels are used
// as a test to estimate quality.
//
// Returns a unique identifier for the run. You can call GetMLTaskRun to get
// more information about the stats of the EvaluationTaskRun.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartMLEvaluationTaskRun for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * ConcurrentRunsExceededException
//   Too many jobs are being run concurrently.
//
//   * MLTransformNotReadyException
//   The machine learning transform is not ready to run.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLEvaluationTaskRun
func (c *Glue) StartMLEvaluationTaskRun(input *StartMLEvaluationTaskRunInput) (*StartMLEvaluationTaskRunOutput, error) {
	req, out := c.StartMLEvaluationTaskRunRequest(input)
	return out, req.Send()
}

// StartMLEvaluationTaskRunWithContext is the same as StartMLEvaluationTaskRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartMLEvaluationTaskRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartMLEvaluationTaskRunWithContext(ctx aws.Context, input *StartMLEvaluationTaskRunInput, opts ...request.Option) (*StartMLEvaluationTaskRunOutput, error) {
	req, out := c.StartMLEvaluationTaskRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMLLabelingSetGenerationTaskRun = "StartMLLabelingSetGenerationTaskRun"

// StartMLLabelingSetGenerationTaskRunRequest generates a "aws/request.Request" representing the
// client's request for the StartMLLabelingSetGenerationTaskRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMLLabelingSetGenerationTaskRun for more information on using the StartMLLabelingSetGenerationTaskRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMLLabelingSetGenerationTaskRunRequest method.
//    req, resp := client.StartMLLabelingSetGenerationTaskRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLLabelingSetGenerationTaskRun
func (c *Glue) StartMLLabelingSetGenerationTaskRunRequest(input *StartMLLabelingSetGenerationTaskRunInput) (req *request.Request, output *StartMLLabelingSetGenerationTaskRunOutput) {
	op := &request.Operation{
		Name:       opStartMLLabelingSetGenerationTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMLLabelingSetGenerationTaskRunInput{}
	}

	output = &StartMLLabelingSetGenerationTaskRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMLLabelingSetGenerationTaskRun API operation for AWS Glue.
//
// Starts the active learning workflow for your machine learning transform to
// improve the transform's quality by generating label sets and adding labels.
//
// When the StartMLLabelingSetGenerationTaskRun finishes, Glue will have generated
// a "labeling set" or a set of questions for humans to answer.
//
// In the case of the FindMatches transform, these questions are of the form,
// “What is the correct way to group these rows together into groups composed
// entirely of matching records?”
//
// After the labeling process is finished, you can upload your labels with a
// call to StartImportLabelsTaskRun. After StartImportLabelsTaskRun finishes,
// all future runs of the machine learning transform will use the new and improved
// labels and perform a higher-quality transformation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartMLLabelingSetGenerationTaskRun for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * ConcurrentRunsExceededException
//   Too many jobs are being run concurrently.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLLabelingSetGenerationTaskRun
func (c *Glue) StartMLLabelingSetGenerationTaskRun(input *StartMLLabelingSetGenerationTaskRunInput) (*StartMLLabelingSetGenerationTaskRunOutput, error) {
	req, out := c.StartMLLabelingSetGenerationTaskRunRequest(input)
	return out, req.Send()
}

// StartMLLabelingSetGenerationTaskRunWithContext is the same as StartMLLabelingSetGenerationTaskRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartMLLabelingSetGenerationTaskRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartMLLabelingSetGenerationTaskRunWithContext(ctx aws.Context, input *StartMLLabelingSetGenerationTaskRunInput, opts ...request.Option) (*StartMLLabelingSetGenerationTaskRunOutput, error) {
	req, out := c.StartMLLabelingSetGenerationTaskRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTrigger = "StartTrigger"

// StartTriggerRequest generates a "aws/request.Request" representing the
// client's request for the StartTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTrigger for more information on using the StartTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTriggerRequest method.
//    req, resp := client.StartTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger
func (c *Glue) StartTriggerRequest(input *StartTriggerInput) (req *request.Request, output *StartTriggerOutput) {
	op := &request.Operation{
		Name:       opStartTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTriggerInput{}
	}

	output = &StartTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTrigger API operation for AWS Glue.
//
// Starts an existing trigger. See Triggering Jobs (https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html)
// for information about how different types of trigger are started.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartTrigger for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentRunsExceededException
//   Too many jobs are being run concurrently.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger
func (c *Glue) StartTrigger(input *StartTriggerInput) (*StartTriggerOutput, error) {
	req, out := c.StartTriggerRequest(input)
	return out, req.Send()
}

// StartTriggerWithContext is the same as StartTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See StartTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartTriggerWithContext(ctx aws.Context, input *StartTriggerInput, opts ...request.Option) (*StartTriggerOutput, error) {
	req, out := c.StartTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkflowRun = "StartWorkflowRun"

// StartWorkflowRunRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkflowRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkflowRun for more information on using the StartWorkflowRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartWorkflowRunRequest method.
//    req, resp := client.StartWorkflowRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartWorkflowRun
func (c *Glue) StartWorkflowRunRequest(input *StartWorkflowRunInput) (req *request.Request, output *StartWorkflowRunOutput) {
	op := &request.Operation{
		Name:       opStartWorkflowRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkflowRunInput{}
	}

	output = &StartWorkflowRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkflowRun API operation for AWS Glue.
//
// Starts a new run of the specified workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartWorkflowRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * ConcurrentRunsExceededException
//   Too many jobs are being run concurrently.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartWorkflowRun
func (c *Glue) StartWorkflowRun(input *StartWorkflowRunInput) (*StartWorkflowRunOutput, error) {
	req, out := c.StartWorkflowRunRequest(input)
	return out, req.Send()
}

// StartWorkflowRunWithContext is the same as StartWorkflowRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkflowRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartWorkflowRunWithContext(ctx aws.Context, input *StartWorkflowRunInput, opts ...request.Option) (*StartWorkflowRunOutput, error) {
	req, out := c.StartWorkflowRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCrawler = "StopCrawler"

// StopCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the StopCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCrawler for more information on using the StopCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopCrawlerRequest method.
//    req, resp := client.StopCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler
func (c *Glue) StopCrawlerRequest(input *StopCrawlerInput) (req *request.Request, output *StopCrawlerOutput) {
	op := &request.Operation{
		Name:       opStopCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCrawlerInput{}
	}

	output = &StopCrawlerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopCrawler API operation for AWS Glue.
//
// If the specified crawler is running, stops the crawl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopCrawler for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * CrawlerNotRunningException
//   The specified crawler is not running.
//
//   * CrawlerStoppingException
//   The specified crawler is stopping.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler
func (c *Glue) StopCrawler(input *StopCrawlerInput) (*StopCrawlerOutput, error) {
	req, out := c.StopCrawlerRequest(input)
	return out, req.Send()
}

// StopCrawlerWithContext is the same as StopCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See StopCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopCrawlerWithContext(ctx aws.Context, input *StopCrawlerInput, opts ...request.Option) (*StopCrawlerOutput, error) {
	req, out := c.StopCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCrawlerSchedule = "StopCrawlerSchedule"

// StopCrawlerScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StopCrawlerSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCrawlerSchedule for more information on using the StopCrawlerSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopCrawlerScheduleRequest method.
//    req, resp := client.StopCrawlerScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule
func (c *Glue) StopCrawlerScheduleRequest(input *StopCrawlerScheduleInput) (req *request.Request, output *StopCrawlerScheduleOutput) {
	op := &request.Operation{
		Name:       opStopCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCrawlerScheduleInput{}
	}

	output = &StopCrawlerScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopCrawlerSchedule API operation for AWS Glue.
//
// Sets the schedule state of the specified crawler to NOT_SCHEDULED, but does
// not stop the crawler if it is already running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopCrawlerSchedule for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * SchedulerNotRunningException
//   The specified scheduler is not running.
//
//   * SchedulerTransitioningException
//   The specified scheduler is transitioning.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule
func (c *Glue) StopCrawlerSchedule(input *StopCrawlerScheduleInput) (*StopCrawlerScheduleOutput, error) {
	req, out := c.StopCrawlerScheduleRequest(input)
	return out, req.Send()
}

// StopCrawlerScheduleWithContext is the same as StopCrawlerSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StopCrawlerSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopCrawlerScheduleWithContext(ctx aws.Context, input *StopCrawlerScheduleInput, opts ...request.Option) (*StopCrawlerScheduleOutput, error) {
	req, out := c.StopCrawlerScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSession = "StopSession"

// StopSessionRequest generates a "aws/request.Request" representing the
// client's request for the StopSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSession for more information on using the StopSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopSessionRequest method.
//    req, resp := client.StopSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopSession
func (c *Glue) StopSessionRequest(input *StopSessionInput) (req *request.Request, output *StopSessionOutput) {
	op := &request.Operation{
		Name:       opStopSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopSessionInput{}
	}

	output = &StopSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopSession API operation for AWS Glue.
//
// Stops the session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopSession for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * IllegalSessionStateException
//   The session is in an invalid state to perform a requested operation.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopSession
func (c *Glue) StopSession(input *StopSessionInput) (*StopSessionOutput, error) {
	req, out := c.StopSessionRequest(input)
	return out, req.Send()
}

// StopSessionWithContext is the same as StopSession with the addition of
// the ability to pass a context and additional request options.
//
// See StopSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopSessionWithContext(ctx aws.Context, input *StopSessionInput, opts ...request.Option) (*StopSessionOutput, error) {
	req, out := c.StopSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrigger = "StopTrigger"

// StopTriggerRequest generates a "aws/request.Request" representing the
// client's request for the StopTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrigger for more information on using the StopTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTriggerRequest method.
//    req, resp := client.StopTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopTrigger
func (c *Glue) StopTriggerRequest(input *StopTriggerInput) (req *request.Request, output *StopTriggerOutput) {
	op := &request.Operation{
		Name:       opStopTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTriggerInput{}
	}

	output = &StopTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopTrigger API operation for AWS Glue.
//
// Stops a specified trigger.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopTrigger for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopTrigger
func (c *Glue) StopTrigger(input *StopTriggerInput) (*StopTriggerOutput, error) {
	req, out := c.StopTriggerRequest(input)
	return out, req.Send()
}

// StopTriggerWithContext is the same as StopTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopTriggerWithContext(ctx aws.Context, input *StopTriggerInput, opts ...request.Option) (*StopTriggerOutput, error) {
	req, out := c.StopTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopWorkflowRun = "StopWorkflowRun"

// StopWorkflowRunRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkflowRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopWorkflowRun for more information on using the StopWorkflowRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopWorkflowRunRequest method.
//    req, resp := client.StopWorkflowRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopWorkflowRun
func (c *Glue) StopWorkflowRunRequest(input *StopWorkflowRunInput) (req *request.Request, output *StopWorkflowRunOutput) {
	op := &request.Operation{
		Name:       opStopWorkflowRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkflowRunInput{}
	}

	output = &StopWorkflowRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopWorkflowRun API operation for AWS Glue.
//
// Stops the execution of the specified workflow run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopWorkflowRun for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * IllegalWorkflowStateException
//   The workflow is in an invalid state to perform a requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopWorkflowRun
func (c *Glue) StopWorkflowRun(input *StopWorkflowRunInput) (*StopWorkflowRunOutput, error) {
	req, out := c.StopWorkflowRunRequest(input)
	return out, req.Send()
}

// StopWorkflowRunWithContext is the same as StopWorkflowRun with the addition of
// the ability to pass a context and additional request options.
//
// See StopWorkflowRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopWorkflowRunWithContext(ctx aws.Context, input *StopWorkflowRunInput, opts ...request.Option) (*StopWorkflowRunOutput, error) {
	req, out := c.StopWorkflowRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TagResource
func (c *Glue) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Glue.
//
// Adds tags to a resource. A tag is a label you can assign to an Amazon Web
// Services resource. In Glue, you can tag only certain resources. For information
// about what resources you can tag, see Amazon Web Services Tags in Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TagResource
func (c *Glue) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UntagResource
func (c *Glue) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Glue.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UntagResource
func (c *Glue) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBlueprint = "UpdateBlueprint"

// UpdateBlueprintRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBlueprint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBlueprint for more information on using the UpdateBlueprint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBlueprintRequest method.
//    req, resp := client.UpdateBlueprintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateBlueprint
func (c *Glue) UpdateBlueprintRequest(input *UpdateBlueprintInput) (req *request.Request, output *UpdateBlueprintOutput) {
	op := &request.Operation{
		Name:       opUpdateBlueprint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBlueprintInput{}
	}

	output = &UpdateBlueprintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBlueprint API operation for AWS Glue.
//
// Updates a registered blueprint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateBlueprint for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * IllegalBlueprintStateException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateBlueprint
func (c *Glue) UpdateBlueprint(input *UpdateBlueprintInput) (*UpdateBlueprintOutput, error) {
	req, out := c.UpdateBlueprintRequest(input)
	return out, req.Send()
}

// UpdateBlueprintWithContext is the same as UpdateBlueprint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBlueprint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateBlueprintWithContext(ctx aws.Context, input *UpdateBlueprintInput, opts ...request.Option) (*UpdateBlueprintOutput, error) {
	req, out := c.UpdateBlueprintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClassifier = "UpdateClassifier"

// UpdateClassifierRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClassifier for more information on using the UpdateClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClassifierRequest method.
//    req, resp := client.UpdateClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateClassifier
func (c *Glue) UpdateClassifierRequest(input *UpdateClassifierInput) (req *request.Request, output *UpdateClassifierOutput) {
	op := &request.Operation{
		Name:       opUpdateClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClassifierInput{}
	}

	output = &UpdateClassifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateClassifier API operation for AWS Glue.
//
// Modifies an existing classifier (a GrokClassifier, an XMLClassifier, a JsonClassifier,
// or a CsvClassifier, depending on which field is present).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateClassifier for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * VersionMismatchException
//   There was a version conflict.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateClassifier
func (c *Glue) UpdateClassifier(input *UpdateClassifierInput) (*UpdateClassifierOutput, error) {
	req, out := c.UpdateClassifierRequest(input)
	return out, req.Send()
}

// UpdateClassifierWithContext is the same as UpdateClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateClassifierWithContext(ctx aws.Context, input *UpdateClassifierInput, opts ...request.Option) (*UpdateClassifierOutput, error) {
	req, out := c.UpdateClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateColumnStatisticsForPartition = "UpdateColumnStatisticsForPartition"

// UpdateColumnStatisticsForPartitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateColumnStatisticsForPartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateColumnStatisticsForPartition for more information on using the UpdateColumnStatisticsForPartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateColumnStatisticsForPartitionRequest method.
//    req, resp := client.UpdateColumnStatisticsForPartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForPartition
func (c *Glue) UpdateColumnStatisticsForPartitionRequest(input *UpdateColumnStatisticsForPartitionInput) (req *request.Request, output *UpdateColumnStatisticsForPartitionOutput) {
	op := &request.Operation{
		Name:       opUpdateColumnStatisticsForPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateColumnStatisticsForPartitionInput{}
	}

	output = &UpdateColumnStatisticsForPartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateColumnStatisticsForPartition API operation for AWS Glue.
//
// Creates or updates partition statistics of columns.
//
// The Identity and Access Management (IAM) permission required for this operation
// is UpdatePartition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateColumnStatisticsForPartition for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForPartition
func (c *Glue) UpdateColumnStatisticsForPartition(input *UpdateColumnStatisticsForPartitionInput) (*UpdateColumnStatisticsForPartitionOutput, error) {
	req, out := c.UpdateColumnStatisticsForPartitionRequest(input)
	return out, req.Send()
}

// UpdateColumnStatisticsForPartitionWithContext is the same as UpdateColumnStatisticsForPartition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateColumnStatisticsForPartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateColumnStatisticsForPartitionWithContext(ctx aws.Context, input *UpdateColumnStatisticsForPartitionInput, opts ...request.Option) (*UpdateColumnStatisticsForPartitionOutput, error) {
	req, out := c.UpdateColumnStatisticsForPartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateColumnStatisticsForTable = "UpdateColumnStatisticsForTable"

// UpdateColumnStatisticsForTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateColumnStatisticsForTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateColumnStatisticsForTable for more information on using the UpdateColumnStatisticsForTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateColumnStatisticsForTableRequest method.
//    req, resp := client.UpdateColumnStatisticsForTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForTable
func (c *Glue) UpdateColumnStatisticsForTableRequest(input *UpdateColumnStatisticsForTableInput) (req *request.Request, output *UpdateColumnStatisticsForTableOutput) {
	op := &request.Operation{
		Name:       opUpdateColumnStatisticsForTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateColumnStatisticsForTableInput{}
	}

	output = &UpdateColumnStatisticsForTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateColumnStatisticsForTable API operation for AWS Glue.
//
// Creates or updates table statistics of columns.
//
// The Identity and Access Management (IAM) permission required for this operation
// is UpdateTable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateColumnStatisticsForTable for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForTable
func (c *Glue) UpdateColumnStatisticsForTable(input *UpdateColumnStatisticsForTableInput) (*UpdateColumnStatisticsForTableOutput, error) {
	req, out := c.UpdateColumnStatisticsForTableRequest(input)
	return out, req.Send()
}

// UpdateColumnStatisticsForTableWithContext is the same as UpdateColumnStatisticsForTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateColumnStatisticsForTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateColumnStatisticsForTableWithContext(ctx aws.Context, input *UpdateColumnStatisticsForTableInput, opts ...request.Option) (*UpdateColumnStatisticsForTableOutput, error) {
	req, out := c.UpdateColumnStatisticsForTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnection = "UpdateConnection"

// UpdateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnection for more information on using the UpdateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectionRequest method.
//    req, resp := client.UpdateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateConnection
func (c *Glue) UpdateConnectionRequest(input *UpdateConnectionInput) (req *request.Request, output *UpdateConnectionOutput) {
	op := &request.Operation{
		Name:       opUpdateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConnectionInput{}
	}

	output = &UpdateConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConnection API operation for AWS Glue.
//
// Updates a connection definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateConnection for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateConnection
func (c *Glue) UpdateConnection(input *UpdateConnectionInput) (*UpdateConnectionOutput, error) {
	req, out := c.UpdateConnectionRequest(input)
	return out, req.Send()
}

// UpdateConnectionWithContext is the same as UpdateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateConnectionWithContext(ctx aws.Context, input *UpdateConnectionInput, opts ...request.Option) (*UpdateConnectionOutput, error) {
	req, out := c.UpdateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCrawler = "UpdateCrawler"

// UpdateCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCrawler for more information on using the UpdateCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCrawlerRequest method.
//    req, resp := client.UpdateCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawler
func (c *Glue) UpdateCrawlerRequest(input *UpdateCrawlerInput) (req *request.Request, output *UpdateCrawlerOutput) {
	op := &request.Operation{
		Name:       opUpdateCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCrawlerInput{}
	}

	output = &UpdateCrawlerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCrawler API operation for AWS Glue.
//
// Updates a crawler. If a crawler is running, you must stop it using StopCrawler
// before updating it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateCrawler for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * VersionMismatchException
//   There was a version conflict.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * CrawlerRunningException
//   The operation cannot be performed because the crawler is already running.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawler
func (c *Glue) UpdateCrawler(input *UpdateCrawlerInput) (*UpdateCrawlerOutput, error) {
	req, out := c.UpdateCrawlerRequest(input)
	return out, req.Send()
}

// UpdateCrawlerWithContext is the same as UpdateCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateCrawlerWithContext(ctx aws.Context, input *UpdateCrawlerInput, opts ...request.Option) (*UpdateCrawlerOutput, error) {
	req, out := c.UpdateCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCrawlerSchedule = "UpdateCrawlerSchedule"

// UpdateCrawlerScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCrawlerSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCrawlerSchedule for more information on using the UpdateCrawlerSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCrawlerScheduleRequest method.
//    req, resp := client.UpdateCrawlerScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule
func (c *Glue) UpdateCrawlerScheduleRequest(input *UpdateCrawlerScheduleInput) (req *request.Request, output *UpdateCrawlerScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCrawlerScheduleInput{}
	}

	output = &UpdateCrawlerScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCrawlerSchedule API operation for AWS Glue.
//
// Updates the schedule of a crawler using a cron expression.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateCrawlerSchedule for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * VersionMismatchException
//   There was a version conflict.
//
//   * SchedulerTransitioningException
//   The specified scheduler is transitioning.
//
//   * OperationTimeoutException
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule
func (c *Glue) UpdateCrawlerSchedule(input *UpdateCrawlerScheduleInput) (*UpdateCrawlerScheduleOutput, error) {
	req, out := c.UpdateCrawlerScheduleRequest(input)
	return out, req.Send()
}

// UpdateCrawlerScheduleWithContext is the same as UpdateCrawlerSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCrawlerSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateCrawlerScheduleWithContext(ctx aws.Context, input *UpdateCrawlerScheduleInput, opts ...request.Option) (*UpdateCrawlerScheduleOutput, error) {
	req, out := c.UpdateCrawlerScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatabase = "UpdateDatabase"

// UpdateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatabase for more information on using the UpdateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatabaseRequest method.
//    req, resp := client.UpdateDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDatabase
func (c *Glue) UpdateDatabaseRequest(input *UpdateDatabaseInput) (req *request.Request, output *UpdateDatabaseOutput) {
	op := &request.Operation{
		Name:       opUpdateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatabaseInput{}
	}

	output = &UpdateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatabase API operation for AWS Glue.
//
// Updates an existing database definition in a Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateDatabase for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDatabase
func (c *Glue) UpdateDatabase(input *UpdateDatabaseInput) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	return out, req.Send()
}

// UpdateDatabaseWithContext is the same as UpdateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateDatabaseWithContext(ctx aws.Context, input *UpdateDatabaseInput, opts ...request.Option) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevEndpoint = "UpdateDevEndpoint"

// UpdateDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevEndpoint for more information on using the UpdateDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDevEndpointRequest method.
//    req, resp := client.UpdateDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDevEndpoint
func (c *Glue) UpdateDevEndpointRequest(input *UpdateDevEndpointInput) (req *request.Request, output *UpdateDevEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDevEndpointInput{}
	}

	output = &UpdateDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDevEndpoint API operation for AWS Glue.
//
// Updates a specified development endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateDevEndpoint for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * ValidationException
//   A value could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDevEndpoint
func (c *Glue) UpdateDevEndpoint(input *UpdateDevEndpointInput) (*UpdateDevEndpointOutput, error) {
	req, out := c.UpdateDevEndpointRequest(input)
	return out, req.Send()
}

// UpdateDevEndpointWithContext is the same as UpdateDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateDevEndpointWithContext(ctx aws.Context, input *UpdateDevEndpointInput, opts ...request.Option) (*UpdateDevEndpointOutput, error) {
	req, out := c.UpdateDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJob for more information on using the UpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobRequest method.
//    req, resp := client.UpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJob
func (c *Glue) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	output = &UpdateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateJob API operation for AWS Glue.
//
// Updates an existing job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateJob for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJob
func (c *Glue) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	return out, req.Send()
}

// UpdateJobWithContext is the same as UpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateJobWithContext(ctx aws.Context, input *UpdateJobInput, opts ...request.Option) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMLTransform = "UpdateMLTransform"

// UpdateMLTransformRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMLTransform operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMLTransform for more information on using the UpdateMLTransform
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMLTransformRequest method.
//    req, resp := client.UpdateMLTransformRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateMLTransform
func (c *Glue) UpdateMLTransformRequest(input *UpdateMLTransformInput) (req *request.Request, output *UpdateMLTransformOutput) {
	op := &request.Operation{
		Name:       opUpdateMLTransform,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMLTransformInput{}
	}

	output = &UpdateMLTransformOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMLTransform API operation for AWS Glue.
//
// Updates an existing machine learning transform. Call this operation to tune
// the algorithm parameters to achieve better results.
//
// After calling this operation, you can call the StartMLEvaluationTaskRun operation
// to assess how well your new parameters achieved your goals (such as improving
// the quality of your machine learning transform, or making it more cost-effective).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateMLTransform for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateMLTransform
func (c *Glue) UpdateMLTransform(input *UpdateMLTransformInput) (*UpdateMLTransformOutput, error) {
	req, out := c.UpdateMLTransformRequest(input)
	return out, req.Send()
}

// UpdateMLTransformWithContext is the same as UpdateMLTransform with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMLTransform for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateMLTransformWithContext(ctx aws.Context, input *UpdateMLTransformInput, opts ...request.Option) (*UpdateMLTransformOutput, error) {
	req, out := c.UpdateMLTransformRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePartition = "UpdatePartition"

// UpdatePartitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePartition for more information on using the UpdatePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePartitionRequest method.
//    req, resp := client.UpdatePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdatePartition
func (c *Glue) UpdatePartitionRequest(input *UpdatePartitionInput) (req *request.Request, output *UpdatePartitionOutput) {
	op := &request.Operation{
		Name:       opUpdatePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePartitionInput{}
	}

	output = &UpdatePartitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePartition API operation for AWS Glue.
//
// Updates a partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdatePartition for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdatePartition
func (c *Glue) UpdatePartition(input *UpdatePartitionInput) (*UpdatePartitionOutput, error) {
	req, out := c.UpdatePartitionRequest(input)
	return out, req.Send()
}

// UpdatePartitionWithContext is the same as UpdatePartition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdatePartitionWithContext(ctx aws.Context, input *UpdatePartitionInput, opts ...request.Option) (*UpdatePartitionOutput, error) {
	req, out := c.UpdatePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegistry = "UpdateRegistry"

// UpdateRegistryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegistry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegistry for more information on using the UpdateRegistry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRegistryRequest method.
//    req, resp := client.UpdateRegistryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateRegistry
func (c *Glue) UpdateRegistryRequest(input *UpdateRegistryInput) (req *request.Request, output *UpdateRegistryOutput) {
	op := &request.Operation{
		Name:       opUpdateRegistry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRegistryInput{}
	}

	output = &UpdateRegistryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRegistry API operation for AWS Glue.
//
// Updates an existing registry which is used to hold a collection of schemas.
// The updated properties relate to the registry, and do not modify any of the
// schemas within the registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateRegistry for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateRegistry
func (c *Glue) UpdateRegistry(input *UpdateRegistryInput) (*UpdateRegistryOutput, error) {
	req, out := c.UpdateRegistryRequest(input)
	return out, req.Send()
}

// UpdateRegistryWithContext is the same as UpdateRegistry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegistry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateRegistryWithContext(ctx aws.Context, input *UpdateRegistryInput, opts ...request.Option) (*UpdateRegistryOutput, error) {
	req, out := c.UpdateRegistryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSchema = "UpdateSchema"

// UpdateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSchema for more information on using the UpdateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSchemaRequest method.
//    req, resp := client.UpdateSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateSchema
func (c *Glue) UpdateSchemaRequest(input *UpdateSchemaInput) (req *request.Request, output *UpdateSchemaOutput) {
	op := &request.Operation{
		Name:       opUpdateSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSchemaInput{}
	}

	output = &UpdateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSchema API operation for AWS Glue.
//
// Updates the description, compatibility setting, or version checkpoint for
// a schema set.
//
// For updating the compatibility setting, the call will not validate compatibility
// for the entire set of schema versions with the new compatibility setting.
// If the value for Compatibility is provided, the VersionNumber (a checkpoint)
// is also required. The API will validate the checkpoint version number for
// consistency.
//
// If the value for the VersionNumber (checkpoint) is provided, Compatibility
// is optional and this can be used to set/reset a checkpoint for the schema.
//
// This update will happen only if the schema is in the AVAILABLE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateSchema for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * AccessDeniedException
//   Access to a resource was denied.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * InternalServiceException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateSchema
func (c *Glue) UpdateSchema(input *UpdateSchemaInput) (*UpdateSchemaOutput, error) {
	req, out := c.UpdateSchemaRequest(input)
	return out, req.Send()
}

// UpdateSchemaWithContext is the same as UpdateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateSchemaWithContext(ctx aws.Context, input *UpdateSchemaInput, opts ...request.Option) (*UpdateSchemaOutput, error) {
	req, out := c.UpdateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTable = "UpdateTable"

// UpdateTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTable for more information on using the UpdateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTableRequest method.
//    req, resp := client.UpdateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTable
func (c *Glue) UpdateTableRequest(input *UpdateTableInput) (req *request.Request, output *UpdateTableOutput) {
	op := &request.Operation{
		Name:       opUpdateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableInput{}
	}

	output = &UpdateTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTable API operation for AWS Glue.
//
// Updates a metadata table in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateTable for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
//   * ResourceNumberLimitExceededException
//   A resource numerical limit was exceeded.
//
//   * EncryptionException
//   An encryption operation failed.
//
//   * ResourceNotReadyException
//   A resource was not ready for a transaction.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTable
func (c *Glue) UpdateTable(input *UpdateTableInput) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	return out, req.Send()
}

// UpdateTableWithContext is the same as UpdateTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateTableWithContext(ctx aws.Context, input *UpdateTableInput, opts ...request.Option) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrigger = "UpdateTrigger"

// UpdateTriggerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrigger for more information on using the UpdateTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTriggerRequest method.
//    req, resp := client.UpdateTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTrigger
func (c *Glue) UpdateTriggerRequest(input *UpdateTriggerInput) (req *request.Request, output *UpdateTriggerOutput) {
	op := &request.Operation{
		Name:       opUpdateTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTriggerInput{}
	}

	output = &UpdateTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrigger API operation for AWS Glue.
//
// Updates a trigger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateTrigger for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTrigger
func (c *Glue) UpdateTrigger(input *UpdateTriggerInput) (*UpdateTriggerOutput, error) {
	req, out := c.UpdateTriggerRequest(input)
	return out, req.Send()
}

// UpdateTriggerWithContext is the same as UpdateTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateTriggerWithContext(ctx aws.Context, input *UpdateTriggerInput, opts ...request.Option) (*UpdateTriggerOutput, error) {
	req, out := c.UpdateTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserDefinedFunction = "UpdateUserDefinedFunction"

// UpdateUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserDefinedFunction for more information on using the UpdateUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserDefinedFunctionRequest method.
//    req, resp := client.UpdateUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction
func (c *Glue) UpdateUserDefinedFunctionRequest(input *UpdateUserDefinedFunctionInput) (req *request.Request, output *UpdateUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opUpdateUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserDefinedFunctionInput{}
	}

	output = &UpdateUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserDefinedFunction API operation for AWS Glue.
//
// Updates an existing function definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateUserDefinedFunction for usage and error information.
//
// Returned Error Types:
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InvalidInputException
//   The input provided was not valid.
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * EncryptionException
//   An encryption operation failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction
func (c *Glue) UpdateUserDefinedFunction(input *UpdateUserDefinedFunctionInput) (*UpdateUserDefinedFunctionOutput, error) {
	req, out := c.UpdateUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// UpdateUserDefinedFunctionWithContext is the same as UpdateUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateUserDefinedFunctionWithContext(ctx aws.Context, input *UpdateUserDefinedFunctionInput, opts ...request.Option) (*UpdateUserDefinedFunctionOutput, error) {
	req, out := c.UpdateUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkflow = "UpdateWorkflow"

// UpdateWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkflow for more information on using the UpdateWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkflowRequest method.
//    req, resp := client.UpdateWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateWorkflow
func (c *Glue) UpdateWorkflowRequest(input *UpdateWorkflowInput) (req *request.Request, output *UpdateWorkflowOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkflowInput{}
	}

	output = &UpdateWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkflow API operation for AWS Glue.
//
// Updates an existing workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateWorkflow for usage and error information.
//
// Returned Error Types:
//   * InvalidInputException
//   The input provided was not valid.
//
//   * EntityNotFoundException
//   A specified entity does not exist
//
//   * InternalServiceException
//   An internal service error occurred.
//
//   * OperationTimeoutException
//   The operation timed out.
//
//   * ConcurrentModificationException
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateWorkflow
func (c *Glue) UpdateWorkflow(input *UpdateWorkflowInput) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	return out, req.Send()
}

// UpdateWorkflowWithContext is the same as UpdateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateWorkflowWithContext(ctx aws.Context, input *UpdateWorkflowInput, opts ...request.Option) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access to a resource was denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines an action to be initiated by a trigger.
type Action struct {
	_ struct{} `type:"structure"`

	// The job arguments used when this trigger fires. For this job run, they replace
	// the default arguments set in the job definition itself.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling Glue APIs in Python (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that Glue consumes to set up your
	// job, see the Special Parameters Used by Glue (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]*string `type:"map"`

	// The name of the crawler to be used with this action.
	CrawlerName *string `min:"1" type:"string"`

	// The name of a job to be run.
	JobName *string `min:"1" type:"string"`

	// Specifies configuration properties of a job run notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The name of the SecurityConfiguration structure to be used with this action.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The JobRun timeout in minutes. This is the maximum time that a job run can
	// consume resources before it is terminated and enters TIMEOUT status. The
	// default is 2,880 minutes (48 hours). This overrides the timeout value set
	// in the parent job.
	Timeout *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrawlerName", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.NotificationProperty != nil {
		if err := s.NotificationProperty.Validate(); err != nil {
			invalidParams.AddNested("NotificationProperty", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArguments sets the Arguments field's value.
func (s *Action) SetArguments(v map[string]*string) *Action {
	s.Arguments = v
	return s
}

// SetCrawlerName sets the CrawlerName field's value.
func (s *Action) SetCrawlerName(v string) *Action {
	s.CrawlerName = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *Action) SetJobName(v string) *Action {
	s.JobName = &v
	return s
}

// SetNotificationProperty sets the NotificationProperty field's value.
func (s *Action) SetNotificationProperty(v *NotificationProperty) *Action {
	s.NotificationProperty = v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *Action) SetSecurityConfiguration(v string) *Action {
	s.SecurityConfiguration = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *Action) SetTimeout(v int64) *Action {
	s.Timeout = &v
	return s
}

// A resource to be created or added already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure containing information for audit.
type AuditContext struct {
	_ struct{} `type:"structure"`

	// The context for the audit..
	AdditionalAuditContext *string `type:"string"`

	// All columns request for audit.
	AllColumnsRequested *bool `type:"boolean"`

	// The requested columns for audit.
	RequestedColumns []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditContext) GoString() string {
	return s.String()
}

// SetAdditionalAuditContext sets the AdditionalAuditContext field's value.
func (s *AuditContext) SetAdditionalAuditContext(v string) *AuditContext {
	s.AdditionalAuditContext = &v
	return s
}

// SetAllColumnsRequested sets the AllColumnsRequested field's value.
func (s *AuditContext) SetAllColumnsRequested(v bool) *AuditContext {
	s.AllColumnsRequested = &v
	return s
}

// SetRequestedColumns sets the RequestedColumns field's value.
func (s *AuditContext) SetRequestedColumns(v []*string) *AuditContext {
	s.RequestedColumns = v
	return s
}

// A list of errors that can occur when registering partition indexes for an
// existing table.
//
// These errors give the details about why an index registration failed and
// provide a limited number of partitions in the response, so that you can fix
// the partitions at fault and try registering the index again. The most common
// set of errors that can occur are categorized as follows:
//
//    * EncryptedPartitionError: The partitions are encrypted.
//
//    * InvalidPartitionTypeDataError: The partition value doesn't match the
//    data type for that partition column.
//
//    * MissingPartitionValueError: The partitions are encrypted.
//
//    * UnsupportedPartitionCharacterError: Characters inside the partition
//    value are not supported. For example: U+0000 , U+0001, U+0002.
//
//    * InternalError: Any error which does not belong to other error codes.
type BackfillError struct {
	_ struct{} `type:"structure"`

	// The error code for an error that occurred when registering partition indexes
	// for an existing table.
	Code *string `type:"string" enum:"BackfillErrorCode"`

	// A list of a limited number of partitions in the response.
	Partitions []*PartitionValueList `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackfillError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackfillError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BackfillError) SetCode(v string) *BackfillError {
	s.Code = &v
	return s
}

// SetPartitions sets the Partitions field's value.
func (s *BackfillError) SetPartitions(v []*PartitionValueList) *BackfillError {
	s.Partitions = v
	return s
}

type BatchCreatePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the catalog in which the partition is to be created. Currently,
	// this should be the Amazon Web Services account ID.
	CatalogId *string `min:"1" type:"string"`

	// The name of the metadata database in which the partition is to be created.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of PartitionInput structures that define the partitions to be created.
	//
	// PartitionInputList is a required field
	PartitionInputList []*PartitionInput `type:"list" required:"true"`

	// The name of the metadata table in which the partition is to be created.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreatePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreatePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreatePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreatePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionInputList == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionInputList"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionInputList != nil {
		for i, v := range s.PartitionInputList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionInputList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchCreatePartitionInput) SetCatalogId(v string) *BatchCreatePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchCreatePartitionInput) SetDatabaseName(v string) *BatchCreatePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionInputList sets the PartitionInputList field's value.
func (s *BatchCreatePartitionInput) SetPartitionInputList(v []*PartitionInput) *BatchCreatePartitionInput {
	s.PartitionInputList = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchCreatePartitionInput) SetTableName(v string) *BatchCreatePartitionInput {
	s.TableName = &v
	return s
}

type BatchCreatePartitionOutput struct {
	_ struct{} `type:"structure"`

	// The errors encountered when trying to create the requested partitions.
	Errors []*PartitionError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreatePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreatePartitionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchCreatePartitionOutput) SetErrors(v []*PartitionError) *BatchCreatePartitionOutput {
	s.Errors = v
	return s
}

type BatchDeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the connections reside. If none is provided,
	// the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A list of names of the connections to delete.
	//
	// ConnectionNameList is a required field
	ConnectionNameList []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ConnectionNameList == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionNameList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeleteConnectionInput) SetCatalogId(v string) *BatchDeleteConnectionInput {
	s.CatalogId = &v
	return s
}

// SetConnectionNameList sets the ConnectionNameList field's value.
func (s *BatchDeleteConnectionInput) SetConnectionNameList(v []*string) *BatchDeleteConnectionInput {
	s.ConnectionNameList = v
	return s
}

type BatchDeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// A map of the names of connections that were not successfully deleted to error
	// details.
	Errors map[string]*ErrorDetail `type:"map"`

	// A list of names of the connection definitions that were successfully deleted.
	Succeeded []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteConnectionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteConnectionOutput) SetErrors(v map[string]*ErrorDetail) *BatchDeleteConnectionOutput {
	s.Errors = v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *BatchDeleteConnectionOutput) SetSucceeded(v []*string) *BatchDeleteConnectionOutput {
	s.Succeeded = v
	return s
}

type BatchDeletePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partition to be deleted resides. If
	// none is provided, the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table in question resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of PartitionInput structures that define the partitions to be deleted.
	//
	// PartitionsToDelete is a required field
	PartitionsToDelete []*PartitionValueList `type:"list" required:"true"`

	// The name of the table that contains the partitions to be deleted.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeletePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeletePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionsToDelete == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionsToDelete"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionsToDelete != nil {
		for i, v := range s.PartitionsToDelete {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionsToDelete", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeletePartitionInput) SetCatalogId(v string) *BatchDeletePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchDeletePartitionInput) SetDatabaseName(v string) *BatchDeletePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionsToDelete sets the PartitionsToDelete field's value.
func (s *BatchDeletePartitionInput) SetPartitionsToDelete(v []*PartitionValueList) *BatchDeletePartitionInput {
	s.PartitionsToDelete = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchDeletePartitionInput) SetTableName(v string) *BatchDeletePartitionInput {
	s.TableName = &v
	return s
}

type BatchDeletePartitionOutput struct {
	_ struct{} `type:"structure"`

	// The errors encountered when trying to delete the requested partitions.
	Errors []*PartitionError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeletePartitionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeletePartitionOutput) SetErrors(v []*PartitionError) *BatchDeletePartitionOutput {
	s.Errors = v
	return s
}

type BatchDeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the table resides. If none is provided,
	// the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the tables to delete reside. For
	// Hive compatibility, this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of the table to delete.
	//
	// TablesToDelete is a required field
	TablesToDelete []*string `type:"list" required:"true"`

	// The transaction ID at which to delete the table contents.
	TransactionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TablesToDelete == nil {
		invalidParams.Add(request.NewErrParamRequired("TablesToDelete"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeleteTableInput) SetCatalogId(v string) *BatchDeleteTableInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchDeleteTableInput) SetDatabaseName(v string) *BatchDeleteTableInput {
	s.DatabaseName = &v
	return s
}

// SetTablesToDelete sets the TablesToDelete field's value.
func (s *BatchDeleteTableInput) SetTablesToDelete(v []*string) *BatchDeleteTableInput {
	s.TablesToDelete = v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *BatchDeleteTableInput) SetTransactionId(v string) *BatchDeleteTableInput {
	s.TransactionId = &v
	return s
}

type BatchDeleteTableOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors encountered in attempting to delete the specified tables.
	Errors []*TableError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteTableOutput) SetErrors(v []*TableError) *BatchDeleteTableOutput {
	s.Errors = v
	return s
}

type BatchDeleteTableVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is provided,
	// the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// A list of the IDs of versions to be deleted. A VersionId is a string representation
	// of an integer. Each version is incremented by 1.
	//
	// VersionIds is a required field
	VersionIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteTableVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteTableVersionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VersionIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeleteTableVersionInput) SetCatalogId(v string) *BatchDeleteTableVersionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchDeleteTableVersionInput) SetDatabaseName(v string) *BatchDeleteTableVersionInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchDeleteTableVersionInput) SetTableName(v string) *BatchDeleteTableVersionInput {
	s.TableName = &v
	return s
}

// SetVersionIds sets the VersionIds field's value.
func (s *BatchDeleteTableVersionInput) SetVersionIds(v []*string) *BatchDeleteTableVersionInput {
	s.VersionIds = v
	return s
}

type BatchDeleteTableVersionOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors encountered while trying to delete the specified table versions.
	Errors []*TableVersionError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTableVersionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteTableVersionOutput) SetErrors(v []*TableVersionError) *BatchDeleteTableVersionOutput {
	s.Errors = v
	return s
}

type BatchGetBlueprintsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether or not to include the blueprint in the response.
	IncludeBlueprint *bool `type:"boolean"`

	// Specifies whether or not to include the parameters, as a JSON string, for
	// the blueprint in the response.
	IncludeParameterSpec *bool `type:"boolean"`

	// A list of blueprint names.
	//
	// Names is a required field
	Names []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetBlueprintsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetBlueprintsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetBlueprintsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetBlueprintsInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeBlueprint sets the IncludeBlueprint field's value.
func (s *BatchGetBlueprintsInput) SetIncludeBlueprint(v bool) *BatchGetBlueprintsInput {
	s.IncludeBlueprint = &v
	return s
}

// SetIncludeParameterSpec sets the IncludeParameterSpec field's value.
func (s *BatchGetBlueprintsInput) SetIncludeParameterSpec(v bool) *BatchGetBlueprintsInput {
	s.IncludeParameterSpec = &v
	return s
}

// SetNames sets the Names field's value.
func (s *BatchGetBlueprintsInput) SetNames(v []*string) *BatchGetBlueprintsInput {
	s.Names = v
	return s
}

type BatchGetBlueprintsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of blueprint as a Blueprints object.
	Blueprints []*Blueprint `type:"list"`

	// Returns a list of BlueprintNames that were not found.
	MissingBlueprints []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetBlueprintsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetBlueprintsOutput) GoString() string {
	return s.String()
}

// SetBlueprints sets the Blueprints field's value.
func (s *BatchGetBlueprintsOutput) SetBlueprints(v []*Blueprint) *BatchGetBlueprintsOutput {
	s.Blueprints = v
	return s
}

// SetMissingBlueprints sets the MissingBlueprints field's value.
func (s *BatchGetBlueprintsOutput) SetMissingBlueprints(v []*string) *BatchGetBlueprintsOutput {
	s.MissingBlueprints = v
	return s
}

type BatchGetCrawlersInput struct {
	_ struct{} `type:"structure"`

	// A list of crawler names, which might be the names returned from the ListCrawlers
	// operation.
	//
	// CrawlerNames is a required field
	CrawlerNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCrawlersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCrawlersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetCrawlersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetCrawlersInput"}
	if s.CrawlerNames == nil {
		invalidParams.Add(request.NewErrParamRequired("CrawlerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerNames sets the CrawlerNames field's value.
func (s *BatchGetCrawlersInput) SetCrawlerNames(v []*string) *BatchGetCrawlersInput {
	s.CrawlerNames = v
	return s
}

type BatchGetCrawlersOutput struct {
	_ struct{} `type:"structure"`

	// A list of crawler definitions.
	Crawlers []*Crawler `type:"list"`

	// A list of names of crawlers that were not found.
	CrawlersNotFound []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCrawlersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCrawlersOutput) GoString() string {
	return s.String()
}

// SetCrawlers sets the Crawlers field's value.
func (s *BatchGetCrawlersOutput) SetCrawlers(v []*Crawler) *BatchGetCrawlersOutput {
	s.Crawlers = v
	return s
}

// SetCrawlersNotFound sets the CrawlersNotFound field's value.
func (s *BatchGetCrawlersOutput) SetCrawlersNotFound(v []*string) *BatchGetCrawlersOutput {
	s.CrawlersNotFound = v
	return s
}

type BatchGetDevEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The list of DevEndpoint names, which might be the names returned from the
	// ListDevEndpoint operation.
	//
	// DevEndpointNames is a required field
	DevEndpointNames []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDevEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDevEndpointsInput"}
	if s.DevEndpointNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DevEndpointNames"))
	}
	if s.DevEndpointNames != nil && len(s.DevEndpointNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DevEndpointNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevEndpointNames sets the DevEndpointNames field's value.
func (s *BatchGetDevEndpointsInput) SetDevEndpointNames(v []*string) *BatchGetDevEndpointsInput {
	s.DevEndpointNames = v
	return s
}

type BatchGetDevEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DevEndpoint definitions.
	DevEndpoints []*DevEndpoint `type:"list"`

	// A list of DevEndpoints not found.
	DevEndpointsNotFound []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetDevEndpointsOutput) GoString() string {
	return s.String()
}

// SetDevEndpoints sets the DevEndpoints field's value.
func (s *BatchGetDevEndpointsOutput) SetDevEndpoints(v []*DevEndpoint) *BatchGetDevEndpointsOutput {
	s.DevEndpoints = v
	return s
}

// SetDevEndpointsNotFound sets the DevEndpointsNotFound field's value.
func (s *BatchGetDevEndpointsOutput) SetDevEndpointsNotFound(v []*string) *BatchGetDevEndpointsOutput {
	s.DevEndpointsNotFound = v
	return s
}

type BatchGetJobsInput struct {
	_ struct{} `type:"structure"`

	// A list of job names, which might be the names returned from the ListJobs
	// operation.
	//
	// JobNames is a required field
	JobNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetJobsInput"}
	if s.JobNames == nil {
		invalidParams.Add(request.NewErrParamRequired("JobNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNames sets the JobNames field's value.
func (s *BatchGetJobsInput) SetJobNames(v []*string) *BatchGetJobsInput {
	s.JobNames = v
	return s
}

type BatchGetJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job definitions.
	Jobs []*Job `type:"list"`

	// A list of names of jobs not found.
	JobsNotFound []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *BatchGetJobsOutput) SetJobs(v []*Job) *BatchGetJobsOutput {
	s.Jobs = v
	return s
}

// SetJobsNotFound sets the JobsNotFound field's value.
func (s *BatchGetJobsOutput) SetJobsNotFound(v []*string) *BatchGetJobsOutput {
	s.JobsNotFound = v
	return s
}

type BatchGetPartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of partition values identifying the partitions to retrieve.
	//
	// PartitionsToGet is a required field
	PartitionsToGet []*PartitionValueList `type:"list" required:"true"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetPartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetPartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetPartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetPartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionsToGet == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionsToGet"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionsToGet != nil {
		for i, v := range s.PartitionsToGet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionsToGet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchGetPartitionInput) SetCatalogId(v string) *BatchGetPartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchGetPartitionInput) SetDatabaseName(v string) *BatchGetPartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionsToGet sets the PartitionsToGet field's value.
func (s *BatchGetPartitionInput) SetPartitionsToGet(v []*PartitionValueList) *BatchGetPartitionInput {
	s.PartitionsToGet = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchGetPartitionInput) SetTableName(v string) *BatchGetPartitionInput {
	s.TableName = &v
	return s
}

type BatchGetPartitionOutput struct {
	_ struct{} `type:"structure"`

	// A list of the requested partitions.
	Partitions []*Partition `type:"list"`

	// A list of the partition values in the request for which partitions were not
	// returned.
	UnprocessedKeys []*PartitionValueList `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetPartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetPartitionOutput) GoString() string {
	return s.String()
}

// SetPartitions sets the Partitions field's value.
func (s *BatchGetPartitionOutput) SetPartitions(v []*Partition) *BatchGetPartitionOutput {
	s.Partitions = v
	return s
}

// SetUnprocessedKeys sets the UnprocessedKeys field's value.
func (s *BatchGetPartitionOutput) SetUnprocessedKeys(v []*PartitionValueList) *BatchGetPartitionOutput {
	s.UnprocessedKeys = v
	return s
}

type BatchGetTriggersInput struct {
	_ struct{} `type:"structure"`

	// A list of trigger names, which may be the names returned from the ListTriggers
	// operation.
	//
	// TriggerNames is a required field
	TriggerNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetTriggersInput"}
	if s.TriggerNames == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTriggerNames sets the TriggerNames field's value.
func (s *BatchGetTriggersInput) SetTriggerNames(v []*string) *BatchGetTriggersInput {
	s.TriggerNames = v
	return s
}

type BatchGetTriggersOutput struct {
	_ struct{} `type:"structure"`

	// A list of trigger definitions.
	Triggers []*Trigger `type:"list"`

	// A list of names of triggers not found.
	TriggersNotFound []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTriggersOutput) GoString() string {
	return s.String()
}

// SetTriggers sets the Triggers field's value.
func (s *BatchGetTriggersOutput) SetTriggers(v []*Trigger) *BatchGetTriggersOutput {
	s.Triggers = v
	return s
}

// SetTriggersNotFound sets the TriggersNotFound field's value.
func (s *BatchGetTriggersOutput) SetTriggersNotFound(v []*string) *BatchGetTriggersOutput {
	s.TriggersNotFound = v
	return s
}

type BatchGetWorkflowsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include a graph when returning the workflow resource
	// metadata.
	IncludeGraph *bool `type:"boolean"`

	// A list of workflow names, which may be the names returned from the ListWorkflows
	// operation.
	//
	// Names is a required field
	Names []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetWorkflowsInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeGraph sets the IncludeGraph field's value.
func (s *BatchGetWorkflowsInput) SetIncludeGraph(v bool) *BatchGetWorkflowsInput {
	s.IncludeGraph = &v
	return s
}

// SetNames sets the Names field's value.
func (s *BatchGetWorkflowsInput) SetNames(v []*string) *BatchGetWorkflowsInput {
	s.Names = v
	return s
}

type BatchGetWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// A list of names of workflows not found.
	MissingWorkflows []*string `min:"1" type:"list"`

	// A list of workflow resource metadata.
	Workflows []*Workflow `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetWorkflowsOutput) GoString() string {
	return s.String()
}

// SetMissingWorkflows sets the MissingWorkflows field's value.
func (s *BatchGetWorkflowsOutput) SetMissingWorkflows(v []*string) *BatchGetWorkflowsOutput {
	s.MissingWorkflows = v
	return s
}

// SetWorkflows sets the Workflows field's value.
func (s *BatchGetWorkflowsOutput) SetWorkflows(v []*Workflow) *BatchGetWorkflowsOutput {
	s.Workflows = v
	return s
}

// Records an error that occurred when attempting to stop a specified job run.
type BatchStopJobRunError struct {
	_ struct{} `type:"structure"`

	// Specifies details about the error that was encountered.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the job definition that is used in the job run in question.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the job run in question.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunError) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *BatchStopJobRunError) SetErrorDetail(v *ErrorDetail) *BatchStopJobRunError {
	s.ErrorDetail = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchStopJobRunError) SetJobName(v string) *BatchStopJobRunError {
	s.JobName = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *BatchStopJobRunError) SetJobRunId(v string) *BatchStopJobRunError {
	s.JobRunId = &v
	return s
}

type BatchStopJobRunInput struct {
	_ struct{} `type:"structure"`

	// The name of the job definition for which to stop job runs.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// A list of the JobRunIds that should be stopped for that job definition.
	//
	// JobRunIds is a required field
	JobRunIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchStopJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchStopJobRunInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobRunIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobRunIds"))
	}
	if s.JobRunIds != nil && len(s.JobRunIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobRunIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *BatchStopJobRunInput) SetJobName(v string) *BatchStopJobRunInput {
	s.JobName = &v
	return s
}

// SetJobRunIds sets the JobRunIds field's value.
func (s *BatchStopJobRunInput) SetJobRunIds(v []*string) *BatchStopJobRunInput {
	s.JobRunIds = v
	return s
}

type BatchStopJobRunOutput struct {
	_ struct{} `type:"structure"`

	// A list of the errors that were encountered in trying to stop JobRuns, including
	// the JobRunId for which each error was encountered and details about the error.
	Errors []*BatchStopJobRunError `type:"list"`

	// A list of the JobRuns that were successfully submitted for stopping.
	SuccessfulSubmissions []*BatchStopJobRunSuccessfulSubmission `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchStopJobRunOutput) SetErrors(v []*BatchStopJobRunError) *BatchStopJobRunOutput {
	s.Errors = v
	return s
}

// SetSuccessfulSubmissions sets the SuccessfulSubmissions field's value.
func (s *BatchStopJobRunOutput) SetSuccessfulSubmissions(v []*BatchStopJobRunSuccessfulSubmission) *BatchStopJobRunOutput {
	s.SuccessfulSubmissions = v
	return s
}

// Records a successful request to stop a specified JobRun.
type BatchStopJobRunSuccessfulSubmission struct {
	_ struct{} `type:"structure"`

	// The name of the job definition used in the job run that was stopped.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the job run that was stopped.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunSuccessfulSubmission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopJobRunSuccessfulSubmission) GoString() string {
	return s.String()
}

// SetJobName sets the JobName field's value.
func (s *BatchStopJobRunSuccessfulSubmission) SetJobName(v string) *BatchStopJobRunSuccessfulSubmission {
	s.JobName = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *BatchStopJobRunSuccessfulSubmission) SetJobRunId(v string) *BatchStopJobRunSuccessfulSubmission {
	s.JobRunId = &v
	return s
}

// Contains information about a batch update partition error.
type BatchUpdatePartitionFailureEntry struct {
	_ struct{} `type:"structure"`

	// The details about the batch update partition error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// A list of values defining the partitions.
	PartitionValueList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionFailureEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionFailureEntry) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *BatchUpdatePartitionFailureEntry) SetErrorDetail(v *ErrorDetail) *BatchUpdatePartitionFailureEntry {
	s.ErrorDetail = v
	return s
}

// SetPartitionValueList sets the PartitionValueList field's value.
func (s *BatchUpdatePartitionFailureEntry) SetPartitionValueList(v []*string) *BatchUpdatePartitionFailureEntry {
	s.PartitionValueList = v
	return s
}

type BatchUpdatePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the catalog in which the partition is to be updated. Currently,
	// this should be the Amazon Web Services account ID.
	CatalogId *string `min:"1" type:"string"`

	// The name of the metadata database in which the partition is to be updated.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of up to 100 BatchUpdatePartitionRequestEntry objects to update.
	//
	// Entries is a required field
	Entries []*BatchUpdatePartitionRequestEntry `min:"1" type:"list" required:"true"`

	// The name of the metadata table in which the partition is to be updated.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdatePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdatePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchUpdatePartitionInput) SetCatalogId(v string) *BatchUpdatePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchUpdatePartitionInput) SetDatabaseName(v string) *BatchUpdatePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchUpdatePartitionInput) SetEntries(v []*BatchUpdatePartitionRequestEntry) *BatchUpdatePartitionInput {
	s.Entries = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchUpdatePartitionInput) SetTableName(v string) *BatchUpdatePartitionInput {
	s.TableName = &v
	return s
}

type BatchUpdatePartitionOutput struct {
	_ struct{} `type:"structure"`

	// The errors encountered when trying to update the requested partitions. A
	// list of BatchUpdatePartitionFailureEntry objects.
	Errors []*BatchUpdatePartitionFailureEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchUpdatePartitionOutput) SetErrors(v []*BatchUpdatePartitionFailureEntry) *BatchUpdatePartitionOutput {
	s.Errors = v
	return s
}

// A structure that contains the values and structure used to update a partition.
type BatchUpdatePartitionRequestEntry struct {
	_ struct{} `type:"structure"`

	// The structure used to update a partition.
	//
	// PartitionInput is a required field
	PartitionInput *PartitionInput `type:"structure" required:"true"`

	// A list of values defining the partitions.
	//
	// PartitionValueList is a required field
	PartitionValueList []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdatePartitionRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdatePartitionRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdatePartitionRequestEntry"}
	if s.PartitionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionInput"))
	}
	if s.PartitionValueList == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionValueList"))
	}
	if s.PartitionInput != nil {
		if err := s.PartitionInput.Validate(); err != nil {
			invalidParams.AddNested("PartitionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionInput sets the PartitionInput field's value.
func (s *BatchUpdatePartitionRequestEntry) SetPartitionInput(v *PartitionInput) *BatchUpdatePartitionRequestEntry {
	s.PartitionInput = v
	return s
}

// SetPartitionValueList sets the PartitionValueList field's value.
func (s *BatchUpdatePartitionRequestEntry) SetPartitionValueList(v []*string) *BatchUpdatePartitionRequestEntry {
	s.PartitionValueList = v
	return s
}

// Defines column statistics supported for bit sequence data values.
type BinaryColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// The average bit sequence length in the column.
	//
	// AverageLength is a required field
	AverageLength *float64 `type:"double" required:"true"`

	// The size of the longest bit sequence in the column.
	//
	// MaximumLength is a required field
	MaximumLength *int64 `type:"long" required:"true"`

	// The number of null values in the column.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BinaryColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BinaryColumnStatisticsData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BinaryColumnStatisticsData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BinaryColumnStatisticsData"}
	if s.AverageLength == nil {
		invalidParams.Add(request.NewErrParamRequired("AverageLength"))
	}
	if s.MaximumLength == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumLength"))
	}
	if s.NumberOfNulls == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAverageLength sets the AverageLength field's value.
func (s *BinaryColumnStatisticsData) SetAverageLength(v float64) *BinaryColumnStatisticsData {
	s.AverageLength = &v
	return s
}

// SetMaximumLength sets the MaximumLength field's value.
func (s *BinaryColumnStatisticsData) SetMaximumLength(v int64) *BinaryColumnStatisticsData {
	s.MaximumLength = &v
	return s
}

// SetNumberOfNulls sets the NumberOfNulls field's value.
func (s *BinaryColumnStatisticsData) SetNumberOfNulls(v int64) *BinaryColumnStatisticsData {
	s.NumberOfNulls = &v
	return s
}

// The details of a blueprint.
type Blueprint struct {
	_ struct{} `type:"structure"`

	// Specifies the path in Amazon S3 where the blueprint is published.
	BlueprintLocation *string `type:"string"`

	// Specifies a path in Amazon S3 where the blueprint is copied when you call
	// CreateBlueprint/UpdateBlueprint to register the blueprint in Glue.
	BlueprintServiceLocation *string `type:"string"`

	// The date and time the blueprint was registered.
	CreatedOn *time.Time `type:"timestamp"`

	// The description of the blueprint.
	Description *string `min:"1" type:"string"`

	// An error message.
	ErrorMessage *string `type:"string"`

	// When there are multiple versions of a blueprint and the latest version has
	// some errors, this attribute indicates the last successful blueprint definition
	// that is available with the service.
	LastActiveDefinition *LastActiveDefinition `type:"structure"`

	// The date and time the blueprint was last modified.
	LastModifiedOn *time.Time `type:"timestamp"`

	// The name of the blueprint.
	Name *string `min:"1" type:"string"`

	// A JSON string that indicates the list of parameter specifications for the
	// blueprint.
	ParameterSpec *string `min:"1" type:"string"`

	// The status of the blueprint registration.
	//
	//    * Creating — The blueprint registration is in progress.
	//
	//    * Active — The blueprint has been successfully registered.
	//
	//    * Updating — An update to the blueprint registration is in progress.
	//
	//    * Failed — The blueprint registration failed.
	Status *string `type:"string" enum:"BlueprintStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Blueprint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Blueprint) GoString() string {
	return s.String()
}

// SetBlueprintLocation sets the BlueprintLocation field's value.
func (s *Blueprint) SetBlueprintLocation(v string) *Blueprint {
	s.BlueprintLocation = &v
	return s
}

// SetBlueprintServiceLocation sets the BlueprintServiceLocation field's value.
func (s *Blueprint) SetBlueprintServiceLocation(v string) *Blueprint {
	s.BlueprintServiceLocation = &v
	return s
}

// SetCreatedOn sets the CreatedOn field's value.
func (s *Blueprint) SetCreatedOn(v time.Time) *Blueprint {
	s.CreatedOn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Blueprint) SetDescription(v string) *Blueprint {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Blueprint) SetErrorMessage(v string) *Blueprint {
	s.ErrorMessage = &v
	return s
}

// SetLastActiveDefinition sets the LastActiveDefinition field's value.
func (s *Blueprint) SetLastActiveDefinition(v *LastActiveDefinition) *Blueprint {
	s.LastActiveDefinition = v
	return s
}

// SetLastModifiedOn sets the LastModifiedOn field's value.
func (s *Blueprint) SetLastModifiedOn(v time.Time) *Blueprint {
	s.LastModifiedOn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Blueprint) SetName(v string) *Blueprint {
	s.Name = &v
	return s
}

// SetParameterSpec sets the ParameterSpec field's value.
func (s *Blueprint) SetParameterSpec(v string) *Blueprint {
	s.ParameterSpec = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Blueprint) SetStatus(v string) *Blueprint {
	s.Status = &v
	return s
}

// The details of a blueprint.
type BlueprintDetails struct {
	_ struct{} `type:"structure"`

	// The name of the blueprint.
	BlueprintName *string `min:"1" type:"string"`

	// The run ID for this blueprint.
	RunId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlueprintDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlueprintDetails) GoString() string {
	return s.String()
}

// SetBlueprintName sets the BlueprintName field's value.
func (s *BlueprintDetails) SetBlueprintName(v string) *BlueprintDetails {
	s.BlueprintName = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *BlueprintDetails) SetRunId(v string) *BlueprintDetails {
	s.RunId = &v
	return s
}

// The details of a blueprint run.
type BlueprintRun struct {
	_ struct{} `type:"structure"`

	// The name of the blueprint.
	BlueprintName *string `min:"1" type:"string"`

	// The date and time that the blueprint run completed.
	CompletedOn *time.Time `type:"timestamp"`

	// Indicates any errors that are seen while running the blueprint.
	ErrorMessage *string `type:"string"`

	// The blueprint parameters as a string. You will have to provide a value for
	// each key that is required from the parameter spec that is defined in the
	// Blueprint$ParameterSpec.
	Parameters *string `min:"1" type:"string"`

	// The role ARN. This role will be assumed by the Glue service and will be used
	// to create the workflow and other entities of a workflow.
	RoleArn *string `min:"1" type:"string"`

	// If there are any errors while creating the entities of a workflow, we try
	// to roll back the created entities until that point and delete them. This
	// attribute indicates the errors seen while trying to delete the entities that
	// are created.
	RollbackErrorMessage *string `type:"string"`

	// The run ID for this blueprint run.
	RunId *string `min:"1" type:"string"`

	// The date and time that the blueprint run started.
	StartedOn *time.Time `type:"timestamp"`

	// The state of the blueprint run. Possible values are:
	//
	//    * Running — The blueprint run is in progress.
	//
	//    * Succeeded — The blueprint run completed successfully.
	//
	//    * Failed — The blueprint run failed and rollback is complete.
	//
	//    * Rolling Back — The blueprint run failed and rollback is in progress.
	State *string `type:"string" enum:"BlueprintRunState"`

	// The name of a workflow that is created as a result of a successful blueprint
	// run. If a blueprint run has an error, there will not be a workflow created.
	WorkflowName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlueprintRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlueprintRun) GoString() string {
	return s.String()
}

// SetBlueprintName sets the BlueprintName field's value.
func (s *BlueprintRun) SetBlueprintName(v string) *BlueprintRun {
	s.BlueprintName = &v
	return s
}

// SetCompletedOn sets the CompletedOn field's value.
func (s *BlueprintRun) SetCompletedOn(v time.Time) *BlueprintRun {
	s.CompletedOn = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BlueprintRun) SetErrorMessage(v string) *BlueprintRun {
	s.ErrorMessage = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *BlueprintRun) SetParameters(v string) *BlueprintRun {
	s.Parameters = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BlueprintRun) SetRoleArn(v string) *BlueprintRun {
	s.RoleArn = &v
	return s
}

// SetRollbackErrorMessage sets the RollbackErrorMessage field's value.
func (s *BlueprintRun) SetRollbackErrorMessage(v string) *BlueprintRun {
	s.RollbackErrorMessage = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *BlueprintRun) SetRunId(v string) *BlueprintRun {
	s.RunId = &v
	return s
}

// SetStartedOn sets the StartedOn field's value.
func (s *BlueprintRun) SetStartedOn(v time.Time) *BlueprintRun {
	s.StartedOn = &v
	return s
}

// SetState sets the State field's value.
func (s *BlueprintRun) SetState(v string) *BlueprintRun {
	s.State = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *BlueprintRun) SetWorkflowName(v string) *BlueprintRun {
	s.WorkflowName = &v
	return s
}

// Defines column statistics supported for Boolean data columns.
type BooleanColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// The number of false values in the column.
	//
	// NumberOfFalses is a required field
	NumberOfFalses *int64 `type:"long" required:"true"`

	// The number of null values in the column.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`

	// The number of true values in the column.
	//
	// NumberOfTrues is a required field
	NumberOfTrues *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BooleanColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BooleanColumnStatisticsData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BooleanColumnStatisticsData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BooleanColumnStatisticsData"}
	if s.NumberOfFalses == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfFalses"))
	}
	if s.NumberOfNulls == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfNulls"))
	}
	if s.NumberOfTrues == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfTrues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberOfFalses sets the NumberOfFalses field's value.
func (s *BooleanColumnStatisticsData) SetNumberOfFalses(v int64) *BooleanColumnStatisticsData {
	s.NumberOfFalses = &v
	return s
}

// SetNumberOfNulls sets the NumberOfNulls field's value.
func (s *BooleanColumnStatisticsData) SetNumberOfNulls(v int64) *BooleanColumnStatisticsData {
	s.NumberOfNulls = &v
	return s
}

// SetNumberOfTrues sets the NumberOfTrues field's value.
func (s *BooleanColumnStatisticsData) SetNumberOfTrues(v int64) *BooleanColumnStatisticsData {
	s.NumberOfTrues = &v
	return s
}

type CancelMLTaskRunInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the task run.
	//
	// TaskRunId is a required field
	TaskRunId *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the machine learning transform.
	//
	// TransformId is a required field
	TransformId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLTaskRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLTaskRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMLTaskRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMLTaskRunInput"}
	if s.TaskRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskRunId"))
	}
	if s.TaskRunId != nil && len(*s.TaskRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskRunId", 1))
	}
	if s.TransformId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformId"))
	}
	if s.TransformId != nil && len(*s.TransformId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskRunId sets the TaskRunId field's value.
func (s *CancelMLTaskRunInput) SetTaskRunId(v string) *CancelMLTaskRunInput {
	s.TaskRunId = &v
	return s
}

// SetTransformId sets the TransformId field's value.
func (s *CancelMLTaskRunInput) SetTransformId(v string) *CancelMLTaskRunInput {
	s.TransformId = &v
	return s
}

type CancelMLTaskRunOutput struct {
	_ struct{} `type:"structure"`

	// The status for this run.
	Status *string `type:"string" enum:"TaskStatusType"`

	// The unique identifier for the task run.
	TaskRunId *string `min:"1" type:"string"`

	// The unique identifier of the machine learning transform.
	TransformId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLTaskRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMLTaskRunOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CancelMLTaskRunOutput) SetStatus(v string) *CancelMLTaskRunOutput {
	s.Status = &v
	return s
}

// SetTaskRunId sets the TaskRunId field's value.
func (s *CancelMLTaskRunOutput) SetTaskRunId(v string) *CancelMLTaskRunOutput {
	s.TaskRunId = &v
	return s
}

// SetTransformId sets the TransformId field's value.
func (s *CancelMLTaskRunOutput) SetTransformId(v string) *CancelMLTaskRunOutput {
	s.TransformId = &v
	return s
}

type CancelStatementInput struct {
	_ struct{} `type:"structure"`

	// The ID of the statement to be cancelled.
	//
	// Id is a required field
	Id *int64 `type:"integer" required:"true"`

	// The origin of the request to cancel the statement.
	RequestOrigin *string `min:"1" type:"string"`

	// The Session ID of the statement to be cancelled.
	//
	// SessionId is a required field
	SessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelStatementInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.RequestOrigin != nil && len(*s.RequestOrigin) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestOrigin", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CancelStatementInput) SetId(v int64) *CancelStatementInput {
	s.Id = &v
	return s
}

// SetRequestOrigin sets the RequestOrigin field's value.
func (s *CancelStatementInput) SetRequestOrigin(v string) *CancelStatementInput {
	s.RequestOrigin = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *CancelStatementInput) SetSessionId(v string) *CancelStatementInput {
	s.SessionId = &v
	return s
}

type CancelStatementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementOutput) GoString() string {
	return s.String()
}

// Specifies a table definition in the Glue Data Catalog.
type CatalogEntry struct {
	_ struct{} `type:"structure"`

	// The database in which the table metadata resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table in question.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CatalogEntry"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CatalogEntry) SetDatabaseName(v string) *CatalogEntry {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CatalogEntry) SetTableName(v string) *CatalogEntry {
	s.TableName = &v
	return s
}

// A structure containing migration status information.
type CatalogImportStatus struct {
	_ struct{} `type:"structure"`

	// True if the migration has completed, or False otherwise.
	ImportCompleted *bool `type:"boolean"`

	// The time that the migration was started.
	ImportTime *time.Time `type:"timestamp"`

	// The name of the person who initiated the migration.
	ImportedBy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogImportStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogImportStatus) GoString() string {
	return s.String()
}

// SetImportCompleted sets the ImportCompleted field's value.
func (s *CatalogImportStatus) SetImportCompleted(v bool) *CatalogImportStatus {
	s.ImportCompleted = &v
	return s
}

// SetImportTime sets the ImportTime field's value.
func (s *CatalogImportStatus) SetImportTime(v time.Time) *CatalogImportStatus {
	s.ImportTime = &v
	return s
}

// SetImportedBy sets the ImportedBy field's value.
func (s *CatalogImportStatus) SetImportedBy(v string) *CatalogImportStatus {
	s.ImportedBy = &v
	return s
}

// Specifies an Glue Data Catalog target.
type CatalogTarget struct {
	_ struct{} `type:"structure"`

	// The name of the connection for an Amazon S3-backed Data Catalog table to
	// be a target of the crawl when using a Catalog connection type paired with
	// a NETWORK Connection type.
	ConnectionName *string `type:"string"`

	// The name of the database to be synchronized.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of the tables to be synchronized.
	//
	// Tables is a required field
	Tables []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CatalogTarget"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Tables == nil {
		invalidParams.Add(request.NewErrParamRequired("Tables"))
	}
	if s.Tables != nil && len(s.Tables) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tables", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionName sets the ConnectionName field's value.
func (s *CatalogTarget) SetConnectionName(v string) *CatalogTarget {
	s.ConnectionName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CatalogTarget) SetDatabaseName(v string) *CatalogTarget {
	s.DatabaseName = &v
	return s
}

// SetTables sets the Tables field's value.
func (s *CatalogTarget) SetTables(v []*string) *CatalogTarget {
	s.Tables = v
	return s
}

type CheckSchemaVersionValidityInput struct {
	_ struct{} `type:"structure"`

	// The data format of the schema definition. Currently AVRO, JSON and PROTOBUF
	// are supported.
	//
	// DataFormat is a required field
	DataFormat *string `type:"string" required:"true" enum:"DataFormat"`

	// The definition of the schema that has to be validated.
	//
	// SchemaDefinition is a required field
	SchemaDefinition *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSchemaVersionValidityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSchemaVersionValidityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckSchemaVersionValidityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckSchemaVersionValidityInput"}
	if s.DataFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("DataFormat"))
	}
	if s.SchemaDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaDefinition"))
	}
	if s.SchemaDefinition != nil && len(*s.SchemaDefinition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaDefinition", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataFormat sets the DataFormat field's value.
func (s *CheckSchemaVersionValidityInput) SetDataFormat(v string) *CheckSchemaVersionValidityInput {
	s.DataFormat = &v
	return s
}

// SetSchemaDefinition sets the SchemaDefinition field's value.
func (s *CheckSchemaVersionValidityInput) SetSchemaDefinition(v string) *CheckSchemaVersionValidityInput {
	s.SchemaDefinition = &v
	return s
}

type CheckSchemaVersionValidityOutput struct {
	_ struct{} `type:"structure"`

	// A validation failure error message.
	Error *string `min:"1" type:"string"`

	// Return true, if the schema is valid and false otherwise.
	Valid *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSchemaVersionValidityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSchemaVersionValidityOutput) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *CheckSchemaVersionValidityOutput) SetError(v string) *CheckSchemaVersionValidityOutput {
	s.Error = &v
	return s
}

// SetValid sets the Valid field's value.
func (s *CheckSchemaVersionValidityOutput) SetValid(v bool) *CheckSchemaVersionValidityOutput {
	s.Valid = &v
	return s
}

// Classifiers are triggered during a crawl task. A classifier checks whether
// a given file is in a format it can handle. If it is, the classifier creates
// a schema in the form of a StructType object that matches that data format.
//
// You can use the standard classifiers that Glue provides, or you can write
// your own classifiers to best categorize your data sources and specify the
// appropriate schemas to use for them. A classifier can be a grok classifier,
// an XML classifier, a JSON classifier, or a custom CSV classifier, as specified
// in one of the fields in the Classifier object.
type Classifier struct {
	_ struct{} `type:"structure"`

	// A classifier for comma-separated values (CSV).
	CsvClassifier *CsvClassifier `type:"structure"`

	// A classifier that uses grok.
	GrokClassifier *GrokClassifier `type:"structure"`

	// A classifier for JSON content.
	JsonClassifier *JsonClassifier `type:"structure"`

	// A classifier for XML content.
	XMLClassifier *XMLClassifier `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Classifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Classifier) GoString() string {
	return s.String()
}

// SetCsvClassifier sets the CsvClassifier field's value.
func (s *Classifier) SetCsvClassifier(v *CsvClassifier) *Classifier {
	s.CsvClassifier = v
	return s
}

// SetGrokClassifier sets the GrokClassifier field's value.
func (s *Classifier) SetGrokClassifier(v *GrokClassifier) *Classifier {
	s.GrokClassifier = v
	return s
}

// SetJsonClassifier sets the JsonClassifier field's value.
func (s *Classifier) SetJsonClassifier(v *JsonClassifier) *Classifier {
	s.JsonClassifier = v
	return s
}

// SetXMLClassifier sets the XMLClassifier field's value.
func (s *Classifier) SetXMLClassifier(v *XMLClassifier) *Classifier {
	s.XMLClassifier = v
	return s
}

// Specifies how Amazon CloudWatch data should be encrypted.
type CloudWatchEncryption struct {
	_ struct{} `type:"structure"`

	// The encryption mode to use for CloudWatch data.
	CloudWatchEncryptionMode *string `type:"string" enum:"CloudWatchEncryptionMode"`

	// The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
	KmsKeyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchEncryption) GoString() string {
	return s.String()
}

// SetCloudWatchEncryptionMode sets the CloudWatchEncryptionMode field's value.
func (s *CloudWatchEncryption) SetCloudWatchEncryptionMode(v string) *CloudWatchEncryption {
	s.CloudWatchEncryptionMode = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CloudWatchEncryption) SetKmsKeyArn(v string) *CloudWatchEncryption {
	s.KmsKeyArn = &v
	return s
}

// Represents a directional edge in a directed acyclic graph (DAG).
type CodeGenEdge struct {
	_ struct{} `type:"structure"`

	// The ID of the node at which the edge starts.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`

	// The ID of the node at which the edge ends.
	//
	// Target is a required field
	Target *string `min:"1" type:"string" required:"true"`

	// The target of the edge.
	TargetParameter *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeGenEdge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeGenEdge) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenEdge) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeGenEdge"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *CodeGenEdge) SetSource(v string) *CodeGenEdge {
	s.Source = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CodeGenEdge) SetTarget(v string) *CodeGenEdge {
	s.Target = &v
	return s
}

// SetTargetParameter sets the TargetParameter field's value.
func (s *CodeGenEdge) SetTargetParameter(v string) *CodeGenEdge {
	s.TargetParameter = &v
	return s
}

// Represents a node in a directed acyclic graph (DAG)
type CodeGenNode struct {
	_ struct{} `type:"structure"`

	// Properties of the node, in the form of name-value pairs.
	//
	// Args is a required field
	Args []*CodeGenNodeArg `type:"list" required:"true"`

	// A node identifier that is unique within the node's graph.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The line number of the node.
	LineNumber *int64 `type:"integer"`

	// The type of node that this is.
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeGenNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeGenNode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeGenNode"}
	if s.Args == nil {
		invalidParams.Add(request.NewErrParamRequired("Args"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.NodeType == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeType"))
	}
	if s.Args != nil {
		for i, v := range s.Args {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Args", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *CodeGenNode) SetArgs(v []*CodeGenNodeArg) *CodeGenNode {
	s.Args = v
	return s
}

// SetId sets the Id field's value.
func (s *CodeGenNode) SetId(v string) *CodeGenNode {
	s.Id = &v
	return s
}

// SetLineNumber sets the LineNumber field's value.
func (s *CodeGenNode) SetLineNumber(v int64) *CodeGenNode {
	s.LineNumber = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *CodeGenNode) SetNodeType(v string) *CodeGenNode {
	s.NodeType = &v
	return s
}

// An argument or property of a node.
type CodeGenNodeArg struct {
	_ struct{} `type:"structure"`

	// The name of the argument or property.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// True if the value is used as a parameter.
	Param *bool `type:"boolean"`

	// The value of the argument or property.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeGenNodeArg) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeGenNodeArg) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNodeArg) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeGenNodeArg"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CodeGenNodeArg) SetName(v string) *CodeGenNodeArg {
	s.Name = &v
	return s
}

// SetParam sets the Param field's value.
func (s *CodeGenNodeArg) SetParam(v bool) *CodeGenNodeArg {
	s.Param = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CodeGenNodeArg) SetValue(v string) *CodeGenNodeArg {
	s.Value = &v
	return s
}

// A column in a Table.
type Column struct {
	_ struct{} `type:"structure"`

	// A free-form text comment.
	Comment *string `type:"string"`

	// The name of the Column.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// These key-value pairs define properties associated with the column.
	Parameters map[string]*string `type:"map"`

	// The data type of the Column.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Column) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Column) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Column) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Column"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *Column) SetComment(v string) *Column {
	s.Comment = &v
	return s
}

// SetName sets the Name field's value.
func (s *Column) SetName(v string) *Column {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Column) SetParameters(v map[string]*string) *Column {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *Column) SetType(v string) *Column {
	s.Type = &v
	return s
}

// Encapsulates a column name that failed and the reason for failure.
type ColumnError struct {
	_ struct{} `type:"structure"`

	// The name of the column that failed.
	ColumnName *string `min:"1" type:"string"`

	// An error message with the reason for the failure of an operation.
	Error *ErrorDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnError) GoString() string {
	return s.String()
}

// SetColumnName sets the ColumnName field's value.
func (s *ColumnError) SetColumnName(v string) *ColumnError {
	s.ColumnName = &v
	return s
}

// SetError sets the Error field's value.
func (s *ColumnError) SetError(v *ErrorDetail) *ColumnError {
	s.Error = v
	return s
}

// A structure containing the column name and column importance score for a
// column.
//
// Column importance helps you understand how columns contribute to your model,
// by identifying which columns in your records are more important than others.
type ColumnImportance struct {
	_ struct{} `type:"structure"`

	// The name of a column.
	ColumnName *string `min:"1" type:"string"`

	// The column importance score for the column, as a decimal.
	Importance *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnImportance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnImportance) GoString() string {
	return s.String()
}

// SetColumnName sets the ColumnName field's value.
func (s *ColumnImportance) SetColumnName(v string) *ColumnImportance {
	s.ColumnName = &v
	return s
}

// SetImportance sets the Importance field's value.
func (s *ColumnImportance) SetImportance(v float64) *ColumnImportance {
	s.Importance = &v
	return s
}

type ColumnRowFilter struct {
	_ struct{} `type:"structure"`

	ColumnName *string `min:"1" type:"string"`

	RowFilterExpression *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnRowFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnRowFilter) GoString() string {
	return s.String()
}

// SetColumnName sets the ColumnName field's value.
func (s *ColumnRowFilter) SetColumnName(v string) *ColumnRowFilter {
	s.ColumnName = &v
	return s
}

// SetRowFilterExpression sets the RowFilterExpression field's value.
func (s *ColumnRowFilter) SetRowFilterExpression(v string) *ColumnRowFilter {
	s.RowFilterExpression = &v
	return s
}

// Represents the generated column-level statistics for a table or partition.
type ColumnStatistics struct {
	_ struct{} `type:"structure"`

	// The timestamp of when column statistics were generated.
	//
	// AnalyzedTime is a required field
	AnalyzedTime *time.Time `type:"timestamp" required:"true"`

	// Name of column which statistics belong to.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// The data type of the column.
	//
	// ColumnType is a required field
	ColumnType *string `type:"string" required:"true"`

	// A ColumnStatisticData object that contains the statistics data values.
	//
	// StatisticsData is a required field
	StatisticsData *ColumnStatisticsData `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatistics) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnStatistics) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnStatistics"}
	if s.AnalyzedTime == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzedTime"))
	}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.ColumnType == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnType"))
	}
	if s.StatisticsData == nil {
		invalidParams.Add(request.NewErrParamRequired("StatisticsData"))
	}
	if s.StatisticsData != nil {
		if err := s.StatisticsData.Validate(); err != nil {
			invalidParams.AddNested("StatisticsData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzedTime sets the AnalyzedTime field's value.
func (s *ColumnStatistics) SetAnalyzedTime(v time.Time) *ColumnStatistics {
	s.AnalyzedTime = &v
	return s
}

// SetColumnName sets the ColumnName field's value.
func (s *ColumnStatistics) SetColumnName(v string) *ColumnStatistics {
	s.ColumnName = &v
	return s
}

// SetColumnType sets the ColumnType field's value.
func (s *ColumnStatistics) SetColumnType(v string) *ColumnStatistics {
	s.ColumnType = &v
	return s
}

// SetStatisticsData sets the StatisticsData field's value.
func (s *ColumnStatistics) SetStatisticsData(v *ColumnStatisticsData) *ColumnStatistics {
	s.StatisticsData = v
	return s
}

// Contains the individual types of column statistics data. Only one data object
// should be set and indicated by the Type attribute.
type ColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// Binary column statistics data.
	BinaryColumnStatisticsData *BinaryColumnStatisticsData `type:"structure"`

	// Boolean column statistics data.
	BooleanColumnStatisticsData *BooleanColumnStatisticsData `type:"structure"`

	// Date column statistics data.
	DateColumnStatisticsData *DateColumnStatisticsData `type:"structure"`

	// Decimal column statistics data.
	DecimalColumnStatisticsData *DecimalColumnStatisticsData `type:"structure"`

	// Double column statistics data.
	DoubleColumnStatisticsData *DoubleColumnStatisticsData `type:"structure"`

	// Long column statistics data.
	LongColumnStatisticsData *LongColumnStatisticsData `type:"structure"`

	// String column statistics data.
	StringColumnStatisticsData *StringColumnStatisticsData `type:"structure"`

	// The type of column statistics data.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ColumnStatisticsType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatisticsData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnStatisticsData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnStatisticsData"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.BinaryColumnStatisticsData != nil {
		if err := s.BinaryColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("BinaryColumnStatisticsData", err.(request.ErrInvalidParams))
		}
	}
	if s.BooleanColumnStatisticsData != nil {
		if err := s.BooleanColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("BooleanColumnStatisticsData", err.(request.ErrInvalidParams))
		}
	}
	if s.DateColumnStatisticsData != nil {
		if err := s.DateColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("DateColumnStatisticsData", err.(request.ErrInvalidParams))
		}
	}
	if s.DecimalColumnStatisticsData != nil {
		if err := s.DecimalColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("DecimalColumnStatisticsData", err.(request.ErrInvalidParams))
		}
	}
	if s.DoubleColumnStatisticsData != nil {
		if err := s.DoubleColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("DoubleColumnStatisticsData", err.(request.ErrInvalidParams))
		}
	}
	if s.LongColumnStatisticsData != nil {
		if err := s.LongColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("LongColumnStatisticsData", err.(request.ErrInvalidParams))
		}
	}
	if s.StringColumnStatisticsData != nil {
		if err := s.StringColumnStatisticsData.Validate(); err != nil {
			invalidParams.AddNested("StringColumnStatisticsData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBinaryColumnStatisticsData sets the BinaryColumnStatisticsData field's value.
func (s *ColumnStatisticsData) SetBinaryColumnStatisticsData(v *BinaryColumnStatisticsData) *ColumnStatisticsData {
	s.BinaryColumnStatisticsData = v
	return s
}

// SetBooleanColumnStatisticsData sets the BooleanColumnStatisticsData field's value.
func (s *ColumnStatisticsData) SetBooleanColumnStatisticsData(v *BooleanColumnStatisticsData) *ColumnStatisticsData {
	s.BooleanColumnStatisticsData = v
	return s
}

// SetDateColumnStatisticsData sets the DateColumnStatisticsData field's value.
func (s *ColumnStatisticsData) SetDateColumnStatisticsData(v *DateColumnStatisticsData) *ColumnStatisticsData {
	s.DateColumnStatisticsData = v
	return s
}

// SetDecimalColumnStatisticsData sets the DecimalColumnStatisticsData field's value.
func (s *ColumnStatisticsData) SetDecimalColumnStatisticsData(v *DecimalColumnStatisticsData) *ColumnStatisticsData {
	s.DecimalColumnStatisticsData = v
	return s
}

// SetDoubleColumnStatisticsData sets the DoubleColumnStatisticsData field's value.
func (s *ColumnStatisticsData) SetDoubleColumnStatisticsData(v *DoubleColumnStatisticsData) *ColumnStatisticsData {
	s.DoubleColumnStatisticsData = v
	return s
}

// SetLongColumnStatisticsData sets the LongColumnStatisticsData field's value.
func (s *ColumnStatisticsData) SetLongColumnStatisticsData(v *LongColumnStatisticsData) *ColumnStatisticsData {
	s.LongColumnStatisticsData = v
	return s
}

// SetStringColumnStatisticsData sets the StringColumnStatisticsData field's value.
func (s *ColumnStatisticsData) SetStringColumnStatisticsData(v *StringColumnStatisticsData) *ColumnStatisticsData {
	s.StringColumnStatisticsData = v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnStatisticsData) SetType(v string) *ColumnStatisticsData {
	s.Type = &v
	return s
}

// Encapsulates a ColumnStatistics object that failed and the reason for failure.
type ColumnStatisticsError struct {
	_ struct{} `type:"structure"`

	// The ColumnStatistics of the column.
	ColumnStatistics *ColumnStatistics `type:"structure"`

	// An error message with the reason for the failure of an operation.
	Error *ErrorDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatisticsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatisticsError) GoString() string {
	return s.String()
}

// SetColumnStatistics sets the ColumnStatistics field's value.
func (s *ColumnStatisticsError) SetColumnStatistics(v *ColumnStatistics) *ColumnStatisticsError {
	s.ColumnStatistics = v
	return s
}

// SetError sets the Error field's value.
func (s *ColumnStatisticsError) SetError(v *ErrorDetail) *ColumnStatisticsError {
	s.Error = v
	return s
}

// Two processes are trying to modify a resource simultaneously.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Too many jobs are being run concurrently.
type ConcurrentRunsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentRunsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentRunsExceededException) GoString() string {
	return s.String()
}

func newErrorConcurrentRunsExceededException(v protocol.ResponseMetadata) error {
	return &ConcurrentRunsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentRunsExceededException) Code() string {
	return "ConcurrentRunsExceededException"
}

// Message returns the exception's message.
func (s *ConcurrentRunsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentRunsExceededException) OrigErr() error {
	return nil
}

func (s *ConcurrentRunsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentRunsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentRunsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines a condition under which a trigger fires.
type Condition struct {
	_ struct{} `type:"structure"`

	// The state of the crawler to which this condition applies.
	CrawlState *string `type:"string" enum:"CrawlState"`

	// The name of the crawler to which this condition applies.
	CrawlerName *string `min:"1" type:"string"`

	// The name of the job whose JobRuns this condition applies to, and on which
	// this trigger waits.
	JobName *string `min:"1" type:"string"`

	// A logical operator.
	LogicalOperator *string `type:"string" enum:"LogicalOperator"`

	// The condition state. Currently, the only job states that a trigger can listen
	// for are SUCCEEDED, STOPPED, FAILED, and TIMEOUT. The only crawler states
	// that a trigger can listen for are SUCCEEDED, FAILED, and CANCELLED.
	State *string `type:"string" enum:"JobRunState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrawlerName", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlState sets the CrawlState field's value.
func (s *Condition) SetCrawlState(v string) *Condition {
	s.CrawlState = &v
	return s
}

// SetCrawlerName sets the CrawlerName field's value.
func (s *Condition) SetCrawlerName(v string) *Condition {
	s.CrawlerName = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *Condition) SetJobName(v string) *Condition {
	s.JobName = &v
	return s
}

// SetLogicalOperator sets the LogicalOperator field's value.
func (s *Condition) SetLogicalOperator(v string) *Condition {
	s.LogicalOperator = &v
	return s
}

// SetState sets the State field's value.
func (s *Condition) SetState(v string) *Condition {
	s.State = &v
	return s
}

// A specified condition was not satisfied.
type ConditionCheckFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionCheckFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionCheckFailureException) GoString() string {
	return s.String()
}

func newErrorConditionCheckFailureException(v protocol.ResponseMetadata) error {
	return &ConditionCheckFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConditionCheckFailureException) Code() string {
	return "ConditionCheckFailureException"
}

// Message returns the exception's message.
func (s *ConditionCheckFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConditionCheckFailureException) OrigErr() error {
	return nil
}

func (s *ConditionCheckFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConditionCheckFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConditionCheckFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The CreatePartitions API was called on a table that has indexes enabled.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The confusion matrix shows you what your transform is predicting accurately
// and what types of errors it is making.
//
// For more information, see Confusion matrix (https://en.wikipedia.org/wiki/Confusion_matrix)
// in Wikipedia.
type ConfusionMatrix struct {
	_ struct{} `type:"structure"`

	// The number of matches in the data that the transform didn't find, in the
	// confusion matrix for your transform.
	NumFalseNegatives *int64 `type:"long"`

	// The number of nonmatches in the data that the transform incorrectly classified
	// as a match, in the confusion matrix for your transform.
	NumFalsePositives *int64 `type:"long"`

	// The number of nonmatches in the data that the transform correctly rejected,
	// in the confusion matrix for your transform.
	NumTrueNegatives *int64 `type:"long"`

	// The number of matches in the data that the transform correctly found, in
	// the confusion matrix for your transform.
	NumTruePositives *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfusionMatrix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfusionMatrix) GoString() string {
	return s.String()
}

// SetNumFalseNegatives sets the NumFalseNegatives field's value.
func (s *ConfusionMatrix) SetNumFalseNegatives(v int64) *ConfusionMatrix {
	s.NumFalseNegatives = &v
	return s
}

// SetNumFalsePositives sets the NumFalsePositives field's value.
func (s *ConfusionMatrix) SetNumFalsePositives(v int64) *ConfusionMatrix {
	s.NumFalsePositives = &v
	return s
}

// SetNumTrueNegatives sets the NumTrueNegatives field's value.
func (s *ConfusionMatrix) SetNumTrueNegatives(v int64) *ConfusionMatrix {
	s.NumTrueNegatives = &v
	return s
}

// SetNumTruePositives sets the NumTruePositives field's value.
func (s *ConfusionMatrix) SetNumTruePositives(v int64) *ConfusionMatrix {
	s.NumTruePositives = &v
	return s
}

// Defines a connection to a data source.
type Connection struct {
	_ struct{} `type:"structure"`

	// These key-value pairs define parameters for the connection:
	//
	//    * HOST - The host URI: either the fully qualified domain name (FQDN) or
	//    the IPv4 address of the database host.
	//
	//    * PORT - The port number, between 1024 and 65535, of the port on which
	//    the database host is listening for database connections.
	//
	//    * USER_NAME - The name under which to log in to the database. The value
	//    string for USER_NAME is "USERNAME".
	//
	//    * PASSWORD - A password, if one is used, for the user name.
	//
	//    * ENCRYPTED_PASSWORD - When you enable connection password protection
	//    by setting ConnectionPasswordEncryption in the Data Catalog encryption
	//    settings, this field stores the encrypted password.
	//
	//    * JDBC_DRIVER_JAR_URI - The Amazon Simple Storage Service (Amazon S3)
	//    path of the JAR file that contains the JDBC driver to use.
	//
	//    * JDBC_DRIVER_CLASS_NAME - The class name of the JDBC driver to use.
	//
	//    * JDBC_ENGINE - The name of the JDBC engine to use.
	//
	//    * JDBC_ENGINE_VERSION - The version of the JDBC engine to use.
	//
	//    * CONFIG_FILES - (Reserved for future use.)
	//
	//    * INSTANCE_ID - The instance ID to use.
	//
	//    * JDBC_CONNECTION_URL - The URL for connecting to a JDBC data source.
	//
	//    * JDBC_ENFORCE_SSL - A Boolean string (true, false) specifying whether
	//    Secure Sockets Layer (SSL) with hostname matching is enforced for the
	//    JDBC connection on the client. The default is false.
	//
	//    * CUSTOM_JDBC_CERT - An Amazon S3 location specifying the customer's root
	//    certificate. Glue uses this root certificate to validate the customer’s
	//    certificate when connecting to the customer database. Glue only handles
	//    X.509 certificates. The certificate provided must be DER-encoded and supplied
	//    in Base64 encoding PEM format.
	//
	//    * SKIP_CUSTOM_JDBC_CERT_VALIDATION - By default, this is false. Glue validates
	//    the Signature algorithm and Subject Public Key Algorithm for the customer
	//    certificate. The only permitted algorithms for the Signature algorithm
	//    are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject Public
	//    Key Algorithm, the key length must be at least 2048. You can set the value
	//    of this property to true to skip Glue’s validation of the customer certificate.
	//
	//    * CUSTOM_JDBC_CERT_STRING - A custom JDBC certificate string which is
	//    used for domain match or distinguished name match to prevent a man-in-the-middle
	//    attack. In Oracle database, this is used as the SSL_SERVER_CERT_DN; in
	//    Microsoft SQL Server, this is used as the hostNameInCertificate.
	//
	//    * CONNECTION_URL - The URL for connecting to a general (non-JDBC) data
	//    source.
	//
	//    * KAFKA_BOOTSTRAP_SERVERS - A comma-separated list of host and port pairs
	//    that are the addresses of the Apache Kafka brokers in a Kafka cluster
	//    to which a Kafka client will connect to and bootstrap itself.
	//
	//    * KAFKA_SSL_ENABLED - Whether to enable or disable SSL on an Apache Kafka
	//    connection. Default value is "true".
	//
	//    * KAFKA_CUSTOM_CERT - The Amazon S3 URL for the private CA cert file (.pem
	//    format). The default is an empty string.
	//
	//    * KAFKA_SKIP_CUSTOM_CERT_VALIDATION - Whether to skip the validation of
	//    the CA cert file or not. Glue validates for three algorithms: SHA256withRSA,
	//    SHA384withRSA and SHA512withRSA. Default value is "false".
	//
	//    * SECRET_ID - The secret ID used for the secret manager of credentials.
	//
	//    * CONNECTOR_URL - The connector URL for a MARKETPLACE or CUSTOM connection.
	//
	//    * CONNECTOR_TYPE - The connector type for a MARKETPLACE or CUSTOM connection.
	//
	//    * CONNECTOR_CLASS_NAME - The connector class name for a MARKETPLACE or
	//    CUSTOM connection.
	//
	//    * KAFKA_CLIENT_KEYSTORE - The Amazon S3 location of the client keystore
	//    file for Kafka client side authentication (Optional).
	//
	//    * KAFKA_CLIENT_KEYSTORE_PASSWORD - The password to access the provided
	//    keystore (Optional).
	//
	//    * KAFKA_CLIENT_KEY_PASSWORD - A keystore can consist of multiple keys,
	//    so this is the password to access the client key to be used with the Kafka
	//    server side key (Optional).
	//
	//    * ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD - The encrypted version of
	//    the Kafka client keystore password (if the user has the Glue encrypt passwords
	//    setting selected).
	//
	//    * ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD - The encrypted version of the Kafka
	//    client key password (if the user has the Glue encrypt passwords setting
	//    selected).
	ConnectionProperties map[string]*string `type:"map"`

	// The type of the connection. Currently, SFTP is not supported.
	ConnectionType *string `type:"string" enum:"ConnectionType"`

	// The time that this connection definition was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the connection.
	Description *string `type:"string"`

	// The user, group, or role that last updated this connection definition.
	LastUpdatedBy *string `min:"1" type:"string"`

	// The last time that this connection definition was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []*string `type:"list"`

	// The name of the connection definition.
	Name *string `min:"1" type:"string"`

	// A map of physical connection requirements, such as virtual private cloud
	// (VPC) and SecurityGroup, that are needed to make this connection successfully.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) GoString() string {
	return s.String()
}

// SetConnectionProperties sets the ConnectionProperties field's value.
func (s *Connection) SetConnectionProperties(v map[string]*string) *Connection {
	s.ConnectionProperties = v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *Connection) SetConnectionType(v string) *Connection {
	s.ConnectionType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Connection) SetCreationTime(v time.Time) *Connection {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Connection) SetDescription(v string) *Connection {
	s.Description = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *Connection) SetLastUpdatedBy(v string) *Connection {
	s.LastUpdatedBy = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Connection) SetLastUpdatedTime(v time.Time) *Connection {
	s.LastUpdatedTime = &v
	return s
}

// SetMatchCriteria sets the MatchCriteria field's value.
func (s *Connection) SetMatchCriteria(v []*string) *Connection {
	s.MatchCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *Connection) SetName(v string) *Connection {
	s.Name = &v
	return s
}

// SetPhysicalConnectionRequirements sets the PhysicalConnectionRequirements field's value.
func (s *Connection) SetPhysicalConnectionRequirements(v *PhysicalConnectionRequirements) *Connection {
	s.PhysicalConnectionRequirements = v
	return s
}

// A structure that is used to specify a connection to create or update.
type ConnectionInput struct {
	_ struct{} `type:"structure"`

	// These key-value pairs define parameters for the connection.
	//
	// ConnectionProperties is a required field
	ConnectionProperties map[string]*string `type:"map" required:"true"`

	// The type of the connection. Currently, these types are supported:
	//
	//    * JDBC - Designates a connection to a database through Java Database Connectivity
	//    (JDBC).
	//
	//    * KAFKA - Designates a connection to an Apache Kafka streaming platform.
	//
	//    * MONGODB - Designates a connection to a MongoDB document database.
	//
	//    * NETWORK - Designates a network connection to a data source within an
	//    Amazon Virtual Private Cloud environment (Amazon VPC).
	//
	//    * MARKETPLACE - Uses configuration settings contained in a connector purchased
	//    from Amazon Web Services Marketplace to read from and write to data stores
	//    that are not natively supported by Glue.
	//
	//    * CUSTOM - Uses configuration settings contained in a custom connector
	//    to read from and write to data stores that are not natively supported
	//    by Glue.
	//
	// SFTP is not supported.
	//
	// ConnectionType is a required field
	ConnectionType *string `type:"string" required:"true" enum:"ConnectionType"`

	// The description of the connection.
	Description *string `type:"string"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []*string `type:"list"`

	// The name of the connection.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A map of physical connection requirements, such as virtual private cloud
	// (VPC) and SecurityGroup, that are needed to successfully make this connection.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectionInput"}
	if s.ConnectionProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionProperties"))
	}
	if s.ConnectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhysicalConnectionRequirements != nil {
		if err := s.PhysicalConnectionRequirements.Validate(); err != nil {
			invalidParams.AddNested("PhysicalConnectionRequirements", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionProperties sets the ConnectionProperties field's value.
func (s *ConnectionInput) SetConnectionProperties(v map[string]*string) *ConnectionInput {
	s.ConnectionProperties = v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *ConnectionInput) SetConnectionType(v string) *ConnectionInput {
	s.ConnectionType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConnectionInput) SetDescription(v string) *ConnectionInput {
	s.Description = &v
	return s
}

// SetMatchCriteria sets the MatchCriteria field's value.
func (s *ConnectionInput) SetMatchCriteria(v []*string) *ConnectionInput {
	s.MatchCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *ConnectionInput) SetName(v string) *ConnectionInput {
	s.Name = &v
	return s
}

// SetPhysicalConnectionRequirements sets the PhysicalConnectionRequirements field's value.
func (s *ConnectionInput) SetPhysicalConnectionRequirements(v *PhysicalConnectionRequirements) *ConnectionInput {
	s.PhysicalConnectionRequirements = v
	return s
}

// The data structure used by the Data Catalog to encrypt the password as part
// of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD
// field in the connection properties. You can enable catalog encryption or
// only password encryption.
//
// When a CreationConnection request arrives containing a password, the Data
// Catalog first encrypts the password using your KMS key. It then encrypts
// the whole connection object again if catalog encryption is also enabled.
//
// This encryption requires that you set KMS key permissions to enable or restrict
// access on the password key according to your security requirements. For example,
// you might want only administrators to have decrypt permission on the password
// key.
type ConnectionPasswordEncryption struct {
	_ struct{} `type:"structure"`

	// An KMS key that is used to encrypt the connection password.
	//
	// If connection password protection is enabled, the caller of CreateConnection
	// and UpdateConnection needs at least kms:Encrypt permission on the specified
	// KMS key, to encrypt passwords before storing them in the Data Catalog.
	//
	// You can set the decrypt permission to enable or restrict access on the password
	// key according to your security requirements.
	AwsKmsKeyId *string `min:"1" type:"string"`

	// When the ReturnConnectionPasswordEncrypted flag is set to "true", passwords
	// remain encrypted in the responses of GetConnection and GetConnections. This
	// encryption takes effect independently from catalog encryption.
	//
	// ReturnConnectionPasswordEncrypted is a required field
	ReturnConnectionPasswordEncrypted *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionPasswordEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionPasswordEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionPasswordEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectionPasswordEncryption"}
	if s.AwsKmsKeyId != nil && len(*s.AwsKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsKmsKeyId", 1))
	}
	if s.ReturnConnectionPasswordEncrypted == nil {
		invalidParams.Add(request.NewErrParamRequired("ReturnConnectionPasswordEncrypted"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsKmsKeyId sets the AwsKmsKeyId field's value.
func (s *ConnectionPasswordEncryption) SetAwsKmsKeyId(v string) *ConnectionPasswordEncryption {
	s.AwsKmsKeyId = &v
	return s
}

// SetReturnConnectionPasswordEncrypted sets the ReturnConnectionPasswordEncrypted field's value.
func (s *ConnectionPasswordEncryption) SetReturnConnectionPasswordEncrypted(v bool) *ConnectionPasswordEncryption {
	s.ReturnConnectionPasswordEncrypted = &v
	return s
}

// Specifies the connections used by a job.
type ConnectionsList struct {
	_ struct{} `type:"structure"`

	// A list of connections used by the job.
	Connections []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionsList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionsList) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *ConnectionsList) SetConnections(v []*string) *ConnectionsList {
	s.Connections = v
	return s
}

// The details of a crawl in the workflow.
type Crawl struct {
	_ struct{} `type:"structure"`

	// The date and time on which the crawl completed.
	CompletedOn *time.Time `type:"timestamp"`

	// The error message associated with the crawl.
	ErrorMessage *string `type:"string"`

	// The log group associated with the crawl.
	LogGroup *string `min:"1" type:"string"`

	// The log stream associated with the crawl.
	LogStream *string `min:"1" type:"string"`

	// The date and time on which the crawl started.
	StartedOn *time.Time `type:"timestamp"`

	// The state of the crawler.
	State *string `type:"string" enum:"CrawlState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Crawl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Crawl) GoString() string {
	return s.String()
}

// SetCompletedOn sets the CompletedOn field's value.
func (s *Crawl) SetCompletedOn(v time.Time) *Crawl {
	s.CompletedOn = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Crawl) SetErrorMessage(v string) *Crawl {
	s.ErrorMessage = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *Crawl) SetLogGroup(v string) *Crawl {
	s.LogGroup = &v
	return s
}

// SetLogStream sets the LogStream field's value.
func (s *Crawl) SetLogStream(v string) *Crawl {
	s.LogStream = &v
	return s
}

// SetStartedOn sets the StartedOn field's value.
func (s *Crawl) SetStartedOn(v time.Time) *Crawl {
	s.StartedOn = &v
	return s
}

// SetState sets the State field's value.
func (s *Crawl) SetState(v string) *Crawl {
	s.State = &v
	return s
}

// Specifies a crawler program that examines a data source and uses classifiers
// to try to determine its schema. If successful, the crawler records metadata
// concerning the data source in the Glue Data Catalog.
type Crawler struct {
	_ struct{} `type:"structure"`

	// A list of UTF-8 strings that specify the custom classifiers that are associated
	// with the crawler.
	Classifiers []*string `type:"list"`

	// Crawler configuration information. This versioned JSON string allows users
	// to specify aspects of a crawler's behavior. For more information, see Include
	// and Exclude Patterns (https://docs.aws.amazon.com/glue/latest/dg/define-crawler.html#crawler-data-stores-exclude).
	Configuration *string `type:"string"`

	// If the crawler is running, contains the total time elapsed since the last
	// crawl began.
	CrawlElapsedTime *int64 `type:"long"`

	// The name of the SecurityConfiguration structure to be used by this crawler.
	CrawlerSecurityConfiguration *string `type:"string"`

	// The time that the crawler was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the database in which the crawler's output is stored.
	DatabaseName *string `type:"string"`

	// A description of the crawler.
	Description *string `type:"string"`

	LakeFormationConfiguration *LakeFormationConfiguration `type:"structure"`

	// The status of the last crawl, and potentially error information if an error
	// occurred.
	LastCrawl *LastCrawlInfo `type:"structure"`

	// The time that the crawler was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// A configuration that specifies whether data lineage is enabled for the crawler.
	LineageConfiguration *LineageConfiguration `type:"structure"`

	// The name of the crawler.
	Name *string `min:"1" type:"string"`

	// A policy that specifies whether to crawl the entire dataset again, or to
	// crawl only folders that were added since the last crawler run.
	RecrawlPolicy *RecrawlPolicy `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that's used to access customer
	// resources, such as Amazon Simple Storage Service (Amazon S3) data.
	Role *string `type:"string"`

	// For scheduled crawlers, the schedule when the crawler runs.
	Schedule *Schedule `type:"structure"`

	// The policy that specifies update and delete behaviors for the crawler.
	SchemaChangePolicy *SchemaChangePolicy `type:"structure"`

	// Indicates whether the crawler is running, or whether a run is pending.
	State *string `type:"string" enum:"CrawlerState"`

	// The prefix added to the names of tables that are created.
	TablePrefix *string `type:"string"`

	// A collection of targets to crawl.
	Targets *CrawlerTargets `type:"structure"`

	// The version of the crawler.
	Version *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Crawler) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Crawler) GoString() string {
	return s.String()
}

// SetClassifiers sets the Classifiers field's value.
func (s *Crawler) SetClassifiers(v []*string) *Crawler {
	s.Classifiers = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *Crawler) SetConfiguration(v string) *Crawler {
	s.Configuration = &v
	return s
}

// SetCrawlElapsedTime sets the CrawlElapsedTime field's value.
func (s *Crawler) SetCrawlElapsedTime(v int64) *Crawler {
	s.CrawlElapsedTime = &v
	return s
}

// SetCrawlerSecurityConfiguration sets the CrawlerSecurityConfiguration field's value.
func (s *Crawler) SetCrawlerSecurityConfiguration(v string) *Crawler {
	s.CrawlerSecurityConfiguration = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Crawler) SetCreationTime(v time.Time) *Crawler {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Crawler) SetDatabaseName(v string) *Crawler {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Crawler) SetDescription(v string) *Crawler {
	s.Description = &v
	return s
}

// SetLakeFormationConfiguration sets the LakeFormationConfiguration field's value.
func (s *Crawler) SetLakeFormationConfiguration(v *LakeFormationConfiguration) *Crawler {
	s.LakeFormationConfiguration = v
	return s
}

// SetLastCrawl sets the LastCrawl field's value.
func (s *Crawler) SetLastCrawl(v *LastCrawlInfo) *Crawler {
	s.LastCrawl = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *Crawler) SetLastUpdated(v time.Time) *Crawler {
	s.LastUpdated = &v
	return s
}

// SetLineageConfiguration sets the LineageConfiguration field's value.
func (s *Crawler) SetLineageConfiguration(v *LineageConfiguration) *Crawler {
	s.LineageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *Crawler) SetName(v string) *Crawler {
	s.Name = &v
	return s
}

// SetRecrawlPolicy sets the RecrawlPolicy field's value.
func (s *Crawler) SetRecrawlPolicy(v *RecrawlPolicy) *Crawler {
	s.RecrawlPolicy = v
	return s
}

// SetRole sets the Role field's value.
func (s *Crawler) SetRole(v string) *Crawler {
	s.Role = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *Crawler) SetSchedule(v *Schedule) *Crawler {
	s.Schedule = v
	return s
}

// SetSchemaChangePolicy sets the SchemaChangePolicy field's value.
func (s *Crawler) SetSchemaChangePolicy(v *SchemaChangePolicy) *Crawler {
	s.SchemaChangePolicy = v
	return s
}

// SetState sets the State field's value.
func (s *Crawler) SetState(v string) *Crawler {
	s.State = &v
	return s
}

// SetTablePrefix sets the TablePrefix field's value.
func (s *Crawler) SetTablePrefix(v string) *Crawler {
	s.TablePrefix = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Crawler) SetTargets(v *CrawlerTargets) *Crawler {
	s.Targets = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Crawler) SetVersion(v int64) *Crawler {
	s.Version = &v
	return s
}

// Metrics for a specified crawler.
type CrawlerMetrics struct {
	_ struct{} `type:"structure"`

	// The name of the crawler.
	CrawlerName *string `min:"1" type:"string"`

	// The duration of the crawler's most recent run, in seconds.
	LastRuntimeSeconds *float64 `type:"double"`

	// The median duration of this crawler's runs, in seconds.
	MedianRuntimeSeconds *float64 `type:"double"`

	// True if the crawler is still estimating how long it will take to complete
	// this run.
	StillEstimating *bool `type:"boolean"`

	// The number of tables created by this crawler.
	TablesCreated *int64 `type:"integer"`

	// The number of tables deleted by this crawler.
	TablesDeleted *int64 `type:"integer"`

	// The number of tables updated by this crawler.
	TablesUpdated *int64 `type:"integer"`

	// The estimated time left to complete a running crawl.
	TimeLeftSeconds *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerMetrics) GoString() string {
	return s.String()
}

// SetCrawlerName sets the CrawlerName field's value.
func (s *CrawlerMetrics) SetCrawlerName(v string) *CrawlerMetrics {
	s.CrawlerName = &v
	return s
}

// SetLastRuntimeSeconds sets the LastRuntimeSeconds field's value.
func (s *CrawlerMetrics) SetLastRuntimeSeconds(v float64) *CrawlerMetrics {
	s.LastRuntimeSeconds = &v
	return s
}

// SetMedianRuntimeSeconds sets the MedianRuntimeSeconds field's value.
func (s *CrawlerMetrics) SetMedianRuntimeSeconds(v float64) *CrawlerMetrics {
	s.MedianRuntimeSeconds = &v
	return s
}

// SetStillEstimating sets the StillEstimating field's value.
func (s *CrawlerMetrics) SetStillEstimating(v bool) *CrawlerMetrics {
	s.StillEstimating = &v
	return s
}

// SetTablesCreated sets the TablesCreated field's value.
func (s *CrawlerMetrics) SetTablesCreated(v int64) *CrawlerMetrics {
	s.TablesCreated = &v
	return s
}

// SetTablesDeleted sets the TablesDeleted field's value.
func (s *CrawlerMetrics) SetTablesDeleted(v int64) *CrawlerMetrics {
	s.TablesDeleted = &v
	return s
}

// SetTablesUpdated sets the TablesUpdated field's value.
func (s *CrawlerMetrics) SetTablesUpdated(v int64) *CrawlerMetrics {
	s.TablesUpdated = &v
	return s
}

// SetTimeLeftSeconds sets the TimeLeftSeconds field's value.
func (s *CrawlerMetrics) SetTimeLeftSeconds(v float64) *CrawlerMetrics {
	s.TimeLeftSeconds = &v
	return s
}

// The details of a Crawler node present in the workflow.
type CrawlerNodeDetails struct {
	_ struct{} `type:"structure"`

	// A list of crawls represented by the crawl node.
	Crawls []*Crawl `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerNodeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerNodeDetails) GoString() string {
	return s.String()
}

// SetCrawls sets the Crawls field's value.
func (s *CrawlerNodeDetails) SetCrawls(v []*Crawl) *CrawlerNodeDetails {
	s.Crawls = v
	return s
}

// The specified crawler is not running.
type CrawlerNotRunningException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerNotRunningException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerNotRunningException) GoString() string {
	return s.String()
}

func newErrorCrawlerNotRunningException(v protocol.ResponseMetadata) error {
	return &CrawlerNotRunningException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CrawlerNotRunningException) Code() string {
	return "CrawlerNotRunningException"
}

// Message returns the exception's message.
func (s *CrawlerNotRunningException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CrawlerNotRunningException) OrigErr() error {
	return nil
}

func (s *CrawlerNotRunningException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CrawlerNotRunningException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CrawlerNotRunningException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation cannot be performed because the crawler is already running.
type CrawlerRunningException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerRunningException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerRunningException) GoString() string {
	return s.String()
}

func newErrorCrawlerRunningException(v protocol.ResponseMetadata) error {
	return &CrawlerRunningException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CrawlerRunningException) Code() string {
	return "CrawlerRunningException"
}

// Message returns the exception's message.
func (s *CrawlerRunningException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CrawlerRunningException) OrigErr() error {
	return nil
}

func (s *CrawlerRunningException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CrawlerRunningException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CrawlerRunningException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified crawler is stopping.
type CrawlerStoppingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerStoppingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerStoppingException) GoString() string {
	return s.String()
}

func newErrorCrawlerStoppingException(v protocol.ResponseMetadata) error {
	return &CrawlerStoppingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CrawlerStoppingException) Code() string {
	return "CrawlerStoppingException"
}

// Message returns the exception's message.
func (s *CrawlerStoppingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CrawlerStoppingException) OrigErr() error {
	return nil
}

func (s *CrawlerStoppingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CrawlerStoppingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CrawlerStoppingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies data stores to crawl.
type CrawlerTargets struct {
	_ struct{} `type:"structure"`

	// Specifies Glue Data Catalog targets.
	CatalogTargets []*CatalogTarget `type:"list"`

	// Specifies Delta data store targets.
	DeltaTargets []*DeltaTarget `type:"list"`

	// Specifies Amazon DynamoDB targets.
	DynamoDBTargets []*DynamoDBTarget `type:"list"`

	// Specifies JDBC targets.
	JdbcTargets []*JdbcTarget `type:"list"`

	// Specifies Amazon DocumentDB or MongoDB targets.
	MongoDBTargets []*MongoDBTarget `type:"list"`

	// Specifies Amazon Simple Storage Service (Amazon S3) targets.
	S3Targets []*S3Target `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerTargets) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlerTargets) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrawlerTargets) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrawlerTargets"}
	if s.CatalogTargets != nil {
		for i, v := range s.CatalogTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CatalogTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogTargets sets the CatalogTargets field's value.
func (s *CrawlerTargets) SetCatalogTargets(v []*CatalogTarget) *CrawlerTargets {
	s.CatalogTargets = v
	return s
}

// SetDeltaTargets sets the DeltaTargets field's value.
func (s *CrawlerTargets) SetDeltaTargets(v []*DeltaTarget) *CrawlerTargets {
	s.DeltaTargets = v
	return s
}

// SetDynamoDBTargets sets the DynamoDBTargets field's value.
func (s *CrawlerTargets) SetDynamoDBTargets(v []*DynamoDBTarget) *CrawlerTargets {
	s.DynamoDBTargets = v
	return s
}

// SetJdbcTargets sets the JdbcTargets field's value.
func (s *CrawlerTargets) SetJdbcTargets(v []*JdbcTarget) *CrawlerTargets {
	s.JdbcTargets = v
	return s
}

// SetMongoDBTargets sets the MongoDBTargets field's value.
func (s *CrawlerTargets) SetMongoDBTargets(v []*MongoDBTarget) *CrawlerTargets {
	s.MongoDBTargets = v
	return s
}

// SetS3Targets sets the S3Targets field's value.
func (s *CrawlerTargets) SetS3Targets(v []*S3Target) *CrawlerTargets {
	s.S3Targets = v
	return s
}

type CreateBlueprintInput struct {
	_ struct{} `type:"structure"`

	// Specifies a path in Amazon S3 where the blueprint is published.
	//
	// BlueprintLocation is a required field
	BlueprintLocation *string `min:"1" type:"string" required:"true"`

	// A description of the blueprint.
	Description *string `min:"1" type:"string"`

	// The name of the blueprint.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags to be applied to this blueprint.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBlueprintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBlueprintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBlueprintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBlueprintInput"}
	if s.BlueprintLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("BlueprintLocation"))
	}
	if s.BlueprintLocation != nil && len(*s.BlueprintLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlueprintLocation", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlueprintLocation sets the BlueprintLocation field's value.
func (s *CreateBlueprintInput) SetBlueprintLocation(v string) *CreateBlueprintInput {
	s.BlueprintLocation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBlueprintInput) SetDescription(v string) *CreateBlueprintInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateBlueprintInput) SetName(v string) *CreateBlueprintInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBlueprintInput) SetTags(v map[string]*string) *CreateBlueprintInput {
	s.Tags = v
	return s
}

type CreateBlueprintOutput struct {
	_ struct{} `type:"structure"`

	// Returns the name of the blueprint that was registered.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBlueprintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBlueprintOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateBlueprintOutput) SetName(v string) *CreateBlueprintOutput {
	s.Name = &v
	return s
}

type CreateClassifierInput struct {
	_ struct{} `type:"structure"`

	// A CsvClassifier object specifying the classifier to create.
	CsvClassifier *CreateCsvClassifierRequest `type:"structure"`

	// A GrokClassifier object specifying the classifier to create.
	GrokClassifier *CreateGrokClassifierRequest `type:"structure"`

	// A JsonClassifier object specifying the classifier to create.
	JsonClassifier *CreateJsonClassifierRequest `type:"structure"`

	// An XMLClassifier object specifying the classifier to create.
	XMLClassifier *CreateXMLClassifierRequest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClassifierInput"}
	if s.CsvClassifier != nil {
		if err := s.CsvClassifier.Validate(); err != nil {
			invalidParams.AddNested("CsvClassifier", err.(request.ErrInvalidParams))
		}
	}
	if s.GrokClassifier != nil {
		if err := s.GrokClassifier.Validate(); err != nil {
			invalidParams.AddNested("GrokClassifier", err.(request.ErrInvalidParams))
		}
	}
	if s.JsonClassifier != nil {
		if err := s.JsonClassifier.Validate(); err != nil {
			invalidParams.AddNested("JsonClassifier", err.(request.ErrInvalidParams))
		}
	}
	if s.XMLClassifier != nil {
		if err := s.XMLClassifier.Validate(); err != nil {
			invalidParams.AddNested("XMLClassifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvClassifier sets the CsvClassifier field's value.
func (s *CreateClassifierInput) SetCsvClassifier(v *CreateCsvClassifierRequest) *CreateClassifierInput {
	s.CsvClassifier = v
	return s
}

// SetGrokClassifier sets the GrokClassifier field's value.
func (s *CreateClassifierInput) SetGrokClassifier(v *CreateGrokClassifierRequest) *CreateClassifierInput {
	s.GrokClassifier = v
	return s
}

// SetJsonClassifier sets the JsonClassifier field's value.
func (s *CreateClassifierInput) SetJsonClassifier(v *CreateJsonClassifierRequest) *CreateClassifierInput {
	s.JsonClassifier = v
	return s
}

// SetXMLClassifier sets the XMLClassifier field's value.
func (s *CreateClassifierInput) SetXMLClassifier(v *CreateXMLClassifierRequest) *CreateClassifierInput {
	s.XMLClassifier = v
	return s
}

type CreateClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClassifierOutput) GoString() string {
	return s.String()
}

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the connection. If none is
	// provided, the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A ConnectionInput object defining the connection to create.
	//
	// ConnectionInput is a required field
	ConnectionInput *ConnectionInput `type:"structure" required:"true"`

	// The tags you assign to the connection.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ConnectionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionInput"))
	}
	if s.ConnectionInput != nil {
		if err := s.ConnectionInput.Validate(); err != nil {
			invalidParams.AddNested("ConnectionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateConnectionInput) SetCatalogId(v string) *CreateConnectionInput {
	s.CatalogId = &v
	return s
}

// SetConnectionInput sets the ConnectionInput field's value.
func (s *CreateConnectionInput) SetConnectionInput(v *ConnectionInput) *CreateConnectionInput {
	s.ConnectionInput = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectionInput) SetTags(v map[string]*string) *CreateConnectionInput {
	s.Tags = v
	return s
}

type CreateConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) GoString() string {
	return s.String()
}

type CreateCrawlerInput struct {
	_ struct{} `type:"structure"`

	// A list of custom classifiers that the user has registered. By default, all
	// built-in classifiers are included in a crawl, but these custom classifiers
	// always override the default classifiers for a given classification.
	Classifiers []*string `type:"list"`

	// Crawler configuration information. This versioned JSON string allows users
	// to specify aspects of a crawler's behavior. For more information, see Configuring
	// a Crawler (https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
	Configuration *string `type:"string"`

	// The name of the SecurityConfiguration structure to be used by this crawler.
	CrawlerSecurityConfiguration *string `type:"string"`

	// The Glue database where results are written, such as: arn:aws:daylight:us-east-1::database/sometable/*.
	DatabaseName *string `type:"string"`

	// A description of the new crawler.
	Description *string `type:"string"`

	LakeFormationConfiguration *LakeFormationConfiguration `type:"structure"`

	// Specifies data lineage configuration settings for the crawler.
	LineageConfiguration *LineageConfiguration `type:"structure"`

	// Name of the new crawler.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A policy that specifies whether to crawl the entire dataset again, or to
	// crawl only folders that were added since the last crawler run.
	RecrawlPolicy *RecrawlPolicy `type:"structure"`

	// The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new
	// crawler to access customer resources.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`

	// The policy for the crawler's update and deletion behavior.
	SchemaChangePolicy *SchemaChangePolicy `type:"structure"`

	// The table prefix used for catalog tables that are created.
	TablePrefix *string `type:"string"`

	// The tags to use with this crawler request. You may use tags to limit access
	// to the crawler. For more information about tags in Glue, see Amazon Web Services
	// Tags in Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html)
	// in the developer guide.
	Tags map[string]*string `type:"map"`

	// A list of collection of targets to crawl.
	//
	// Targets is a required field
	Targets *CrawlerTargets `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrawlerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCrawlerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCrawlerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		if err := s.Targets.Validate(); err != nil {
			invalidParams.AddNested("Targets", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassifiers sets the Classifiers field's value.
func (s *CreateCrawlerInput) SetClassifiers(v []*string) *CreateCrawlerInput {
	s.Classifiers = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateCrawlerInput) SetConfiguration(v string) *CreateCrawlerInput {
	s.Configuration = &v
	return s
}

// SetCrawlerSecurityConfiguration sets the CrawlerSecurityConfiguration field's value.
func (s *CreateCrawlerInput) SetCrawlerSecurityConfiguration(v string) *CreateCrawlerInput {
	s.CrawlerSecurityConfiguration = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateCrawlerInput) SetDatabaseName(v string) *CreateCrawlerInput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCrawlerInput) SetDescription(v string) *CreateCrawlerInput {
	s.Description = &v
	return s
}

// SetLakeFormationConfiguration sets the LakeFormationConfiguration field's value.
func (s *CreateCrawlerInput) SetLakeFormationConfiguration(v *LakeFormationConfiguration) *CreateCrawlerInput {
	s.LakeFormationConfiguration = v
	return s
}

// SetLineageConfiguration sets the LineageConfiguration field's value.
func (s *CreateCrawlerInput) SetLineageConfiguration(v *LineageConfiguration) *CreateCrawlerInput {
	s.LineageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCrawlerInput) SetName(v string) *CreateCrawlerInput {
	s.Name = &v
	return s
}

// SetRecrawlPolicy sets the RecrawlPolicy field's value.
func (s *CreateCrawlerInput) SetRecrawlPolicy(v *RecrawlPolicy) *CreateCrawlerInput {
	s.RecrawlPolicy = v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateCrawlerInput) SetRole(v string) *CreateCrawlerInput {
	s.Role = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateCrawlerInput) SetSchedule(v string) *CreateCrawlerInput {
	s.Schedule = &v
	return s
}

// SetSchemaChangePolicy sets the SchemaChangePolicy field's value.
func (s *CreateCrawlerInput) SetSchemaChangePolicy(v *SchemaChangePolicy) *CreateCrawlerInput {
	s.SchemaChangePolicy = v
	return s
}

// SetTablePrefix sets the TablePrefix field's value.
func (s *CreateCrawlerInput) SetTablePrefix(v string) *CreateCrawlerInput {
	s.TablePrefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCrawlerInput) SetTags(v map[string]*string) *CreateCrawlerInput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateCrawlerInput) SetTargets(v *CrawlerTargets) *CreateCrawlerInput {
	s.Targets = v
	return s
}

type CreateCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCrawlerOutput) GoString() string {
	return s.String()
}

// Specifies a custom CSV classifier for CreateClassifier to create.
type CreateCsvClassifierRequest struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader *string `type:"string" enum:"CsvHeaderOption"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []*string `type:"list"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// Must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCsvClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCsvClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCsvClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCsvClassifierRequest"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Delimiter", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QuoteSymbol != nil && len(*s.QuoteSymbol) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuoteSymbol", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowSingleColumn sets the AllowSingleColumn field's value.
func (s *CreateCsvClassifierRequest) SetAllowSingleColumn(v bool) *CreateCsvClassifierRequest {
	s.AllowSingleColumn = &v
	return s
}

// SetContainsHeader sets the ContainsHeader field's value.
func (s *CreateCsvClassifierRequest) SetContainsHeader(v string) *CreateCsvClassifierRequest {
	s.ContainsHeader = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *CreateCsvClassifierRequest) SetDelimiter(v string) *CreateCsvClassifierRequest {
	s.Delimiter = &v
	return s
}

// SetDisableValueTrimming sets the DisableValueTrimming field's value.
func (s *CreateCsvClassifierRequest) SetDisableValueTrimming(v bool) *CreateCsvClassifierRequest {
	s.DisableValueTrimming = &v
	return s
}

// SetHeader sets the Header field's value.
func (s *CreateCsvClassifierRequest) SetHeader(v []*string) *CreateCsvClassifierRequest {
	s.Header = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCsvClassifierRequest) SetName(v string) *CreateCsvClassifierRequest {
	s.Name = &v
	return s
}

// SetQuoteSymbol sets the QuoteSymbol field's value.
func (s *CreateCsvClassifierRequest) SetQuoteSymbol(v string) *CreateCsvClassifierRequest {
	s.QuoteSymbol = &v
	return s
}

type CreateDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the database. If none is provided,
	// the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The metadata for the database.
	//
	// DatabaseInput is a required field
	DatabaseInput *DatabaseInput `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatabaseInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseInput == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseInput"))
	}
	if s.DatabaseInput != nil {
		if err := s.DatabaseInput.Validate(); err != nil {
			invalidParams.AddNested("DatabaseInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateDatabaseInput) SetCatalogId(v string) *CreateDatabaseInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseInput sets the DatabaseInput field's value.
func (s *CreateDatabaseInput) SetDatabaseInput(v *DatabaseInput) *CreateDatabaseInput {
	s.DatabaseInput = v
	return s
}

type CreateDatabaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseOutput) GoString() string {
	return s.String()
}

type CreateDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// A map of arguments used to configure the DevEndpoint.
	Arguments map[string]*string `type:"map"`

	// The name to be assigned to the new DevEndpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The path to one or more Java .jar files in an S3 bucket that should be loaded
	// in your DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// The paths to one or more Python libraries in an Amazon S3 bucket that should
	// be loaded in your DevEndpoint. Multiple values must be complete paths separated
	// by a comma.
	//
	// You can only use pure Python libraries with a DevEndpoint. Libraries that
	// rely on C extensions, such as the pandas (http://pandas.pydata.org/) Python
	// data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`

	// Glue version determines the versions of Apache Spark and Python that Glue
	// supports. The Python version indicates the version supported for running
	// your ETL scripts on development endpoints.
	//
	// For more information about the available Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	//
	// Development endpoints that are created without specifying a Glue version
	// default to Glue 0.9.
	//
	// You can specify a version of Python support for development endpoints by
	// using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint
	// APIs. If no arguments are provided, the version defaults to Python 2.
	GlueVersion *string `min:"1" type:"string"`

	// The number of Glue Data Processing Units (DPUs) to allocate to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The number of workers of a defined workerType that are allocated to the development
	// endpoint.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The public key to be used by this DevEndpoint for authentication. This attribute
	// is provided for backward compatibility because the recommended attribute
	// to use is public keys.
	PublicKey *string `type:"string"`

	// A list of public keys to be used by the development endpoints for authentication.
	// The use of this attribute is preferred over a single public key because the
	// public keys allow you to have a different private key per client.
	//
	// If you previously created an endpoint with a public key, you must remove
	// that key to be able to set a list of public keys. Call the UpdateDevEndpoint
	// API with the public key content in the deletePublicKeys attribute, and the
	// list of new keys in the addPublicKeys attribute.
	PublicKeys []*string `type:"list"`

	// The IAM role for the DevEndpoint.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The name of the SecurityConfiguration structure to be used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// Security group IDs for the security groups to be used by the new DevEndpoint.
	SecurityGroupIds []*string `type:"list"`

	// The subnet ID for the new DevEndpoint to use.
	SubnetId *string `type:"string"`

	// The tags to use with this DevEndpoint. You may use tags to limit access to
	// the DevEndpoint. For more information about tags in Glue, see Amazon Web
	// Services Tags in Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html)
	// in the developer guide.
	Tags map[string]*string `type:"map"`

	// The type of predefined worker that is allocated to the development endpoint.
	// Accepts a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of
	//    memory, 64 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	//    * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of
	//    memory, 128 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	// Known issue: when a development endpoint is created with the G.2X WorkerType
	// configuration, the Spark drivers for the development endpoint will run on
	// 4 vCPU, 16 GB of memory, and a 64 GB disk.
	WorkerType *string `type:"string" enum:"WorkerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDevEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDevEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlueVersion", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityConfiguration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArguments sets the Arguments field's value.
func (s *CreateDevEndpointInput) SetArguments(v map[string]*string) *CreateDevEndpointInput {
	s.Arguments = v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateDevEndpointInput) SetEndpointName(v string) *CreateDevEndpointInput {
	s.EndpointName = &v
	return s
}

// SetExtraJarsS3Path sets the ExtraJarsS3Path field's value.
func (s *CreateDevEndpointInput) SetExtraJarsS3Path(v string) *CreateDevEndpointInput {
	s.ExtraJarsS3Path = &v
	return s
}

// SetExtraPythonLibsS3Path sets the ExtraPythonLibsS3Path field's value.
func (s *CreateDevEndpointInput) SetExtraPythonLibsS3Path(v string) *CreateDevEndpointInput {
	s.ExtraPythonLibsS3Path = &v
	return s
}

// SetGlueVersion sets the GlueVersion field's value.
func (s *CreateDevEndpointInput) SetGlueVersion(v string) *CreateDevEndpointInput {
	s.GlueVersion = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *CreateDevEndpointInput) SetNumberOfNodes(v int64) *CreateDevEndpointInput {
	s.NumberOfNodes = &v
	return s
}

// SetNumberOfWorkers sets the NumberOfWorkers field's value.
func (s *CreateDevEndpointInput) SetNumberOfWorkers(v int64) *CreateDevEndpointInput {
	s.NumberOfWorkers = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *CreateDevEndpointInput) SetPublicKey(v string) *CreateDevEndpointInput {
	s.PublicKey = &v
	return s
}

// SetPublicKeys sets the PublicKeys field's value.
func (s *CreateDevEndpointInput) SetPublicKeys(v []*string) *CreateDevEndpointInput {
	s.PublicKeys = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDevEndpointInput) SetRoleArn(v string) *CreateDevEndpointInput {
	s.RoleArn = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *CreateDevEndpointInput) SetSecurityConfiguration(v string) *CreateDevEndpointInput {
	s.SecurityConfiguration = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateDevEndpointInput) SetSecurityGroupIds(v []*string) *CreateDevEndpointInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateDevEndpointInput) SetSubnetId(v string) *CreateDevEndpointInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDevEndpointInput) SetTags(v map[string]*string) *CreateDevEndpointInput {
	s.Tags = v
	return s
}

// SetWorkerType sets the WorkerType field's value.
func (s *CreateDevEndpointInput) SetWorkerType(v string) *CreateDevEndpointInput {
	s.WorkerType = &v
	return s
}

type CreateDevEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The map of arguments used to configure this DevEndpoint.
	//
	// Valid arguments are:
	//
	//    * "--enable-glue-datacatalog": ""
	//
	// You can specify a version of Python support for development endpoints by
	// using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint
	// APIs. If no arguments are provided, the version defaults to Python 2.
	Arguments map[string]*string `type:"map"`

	// The AWS Availability Zone where this DevEndpoint is located.
	AvailabilityZone *string `type:"string"`

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The name assigned to the new DevEndpoint.
	EndpointName *string `type:"string"`

	// Path to one or more Java .jar files in an S3 bucket that will be loaded in
	// your DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// The paths to one or more Python libraries in an S3 bucket that will be loaded
	// in your DevEndpoint.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string `type:"string"`

	// Glue version determines the versions of Apache Spark and Python that Glue
	// supports. The Python version indicates the version supported for running
	// your ETL scripts on development endpoints.
	//
	// For more information about the available Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	GlueVersion *string `min:"1" type:"string"`

	// The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The number of workers of a defined workerType that are allocated to the development
	// endpoint.
	NumberOfWorkers *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the role assigned to the new DevEndpoint.
	RoleArn *string `type:"string"`

	// The name of the SecurityConfiguration structure being used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The security groups assigned to the new DevEndpoint.
	SecurityGroupIds []*string `type:"list"`

	// The current status of the new DevEndpoint.
	Status *string `type:"string"`

	// The subnet ID assigned to the new DevEndpoint.
	SubnetId *string `type:"string"`

	// The ID of the virtual private cloud (VPC) used by this DevEndpoint.
	VpcId *string `type:"string"`

	// The type of predefined worker that is allocated to the development endpoint.
	// May be a value of Standard, G.1X, or G.2X.
	WorkerType *string `type:"string" enum:"WorkerType"`

	// The address of the YARN endpoint used by this DevEndpoint.
	YarnEndpointAddress *string `type:"string"`

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevEndpointOutput) GoString() string {
	return s.String()
}

// SetArguments sets the Arguments field's value.
func (s *CreateDevEndpointOutput) SetArguments(v map[string]*string) *CreateDevEndpointOutput {
	s.Arguments = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDevEndpointOutput) SetAvailabilityZone(v string) *CreateDevEndpointOutput {
	s.AvailabilityZone = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateDevEndpointOutput) SetCreatedTimestamp(v time.Time) *CreateDevEndpointOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateDevEndpointOutput) SetEndpointName(v string) *CreateDevEndpointOutput {
	s.EndpointName = &v
	return s
}

// SetExtraJarsS3Path sets the ExtraJarsS3Path field's value.
func (s *CreateDevEndpointOutput) SetExtraJarsS3Path(v string) *CreateDevEndpointOutput {
	s.ExtraJarsS3Path = &v
	return s
}

// SetExtraPythonLibsS3Path sets the ExtraPythonLibsS3Path field's value.
func (s *CreateDevEndpointOutput) SetExtraPythonLibsS3Path(v string) *CreateDevEndpointOutput {
	s.ExtraPythonLibsS3Path = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateDevEndpointOutput) SetFailureReason(v string) *CreateDevEndpointOutput {
	s.FailureReason = &v
	return s
}

// SetGlueVersion sets the GlueVersion field's value.
func (s *CreateDevEndpointOutput) SetGlueVersion(v string) *CreateDevEndpointOutput {
	s.GlueVersion = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *CreateDevEndpointOutput) SetNumberOfNodes(v int64) *CreateDevEndpointOutput {
	s.NumberOfNodes = &v
	return s
}

// SetNumberOfWorkers sets the NumberOfWorkers field's value.
func (s *CreateDevEndpointOutput) SetNumberOfWorkers(v int64) *CreateDevEndpointOutput {
	s.NumberOfWorkers = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDevEndpointOutput) SetRoleArn(v string) *CreateDevEndpointOutput {
	s.RoleArn = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *CreateDevEndpointOutput) SetSecurityConfiguration(v string) *CreateDevEndpointOutput {
	s.SecurityConfiguration = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateDevEndpointOutput) SetSecurityGroupIds(v []*string) *CreateDevEndpointOutput {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDevEndpointOutput) SetStatus(v string) *CreateDevEndpointOutput {
	s.Status = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateDevEndpointOutput) SetSubnetId(v string) *CreateDevEndpointOutput {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateDevEndpointOutput) SetVpcId(v string) *CreateDevEndpointOutput {
	s.VpcId = &v
	return s
}

// SetWorkerType sets the WorkerType field's value.
func (s *CreateDevEndpointOutput) SetWorkerType(v string) *CreateDevEndpointOutput {
	s.WorkerType = &v
	return s
}

// SetYarnEndpointAddress sets the YarnEndpointAddress field's value.
func (s *CreateDevEndpointOutput) SetYarnEndpointAddress(v string) *CreateDevEndpointOutput {
	s.YarnEndpointAddress = &v
	return s
}

// SetZeppelinRemoteSparkInterpreterPort sets the ZeppelinRemoteSparkInterpreterPort field's value.
func (s *CreateDevEndpointOutput) SetZeppelinRemoteSparkInterpreterPort(v int64) *CreateDevEndpointOutput {
	s.ZeppelinRemoteSparkInterpreterPort = &v
	return s
}

// Specifies a grok classifier for CreateClassifier to create.
type CreateGrokClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string `type:"string"`

	// The grok pattern used by this classifier.
	//
	// GrokPattern is a required field
	GrokPattern *string `min:"1" type:"string" required:"true"`

	// The name of the new classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGrokClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGrokClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGrokClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGrokClassifierRequest"}
	if s.Classification == nil {
		invalidParams.Add(request.NewErrParamRequired("Classification"))
	}
	if s.GrokPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("GrokPattern"))
	}
	if s.GrokPattern != nil && len(*s.GrokPattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrokPattern", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *CreateGrokClassifierRequest) SetClassification(v string) *CreateGrokClassifierRequest {
	s.Classification = &v
	return s
}

// SetCustomPatterns sets the CustomPatterns field's value.
func (s *CreateGrokClassifierRequest) SetCustomPatterns(v string) *CreateGrokClassifierRequest {
	s.CustomPatterns = &v
	return s
}

// SetGrokPattern sets the GrokPattern field's value.
func (s *CreateGrokClassifierRequest) SetGrokPattern(v string) *CreateGrokClassifierRequest {
	s.GrokPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGrokClassifierRequest) SetName(v string) *CreateGrokClassifierRequest {
	s.Name = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// This parameter is deprecated. Use MaxCapacity instead.
	//
	// The number of Glue data processing units (DPUs) to allocate to this Job.
	// You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Deprecated: This property is deprecated, use MaxCapacity instead.
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The JobCommand that runs this job.
	//
	// Command is a required field
	Command *JobCommand `type:"structure" required:"true"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The default arguments for this job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling Glue APIs in Python (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that Glue consumes to set up your
	// job, see the Special Parameters Used by Glue (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]*string `type:"map"`

	// Description of the job being defined.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// Glue version determines the versions of Apache Spark and Python that Glue
	// supports. The Python version indicates the version supported for jobs of
	// type Spark.
	//
	// For more information about the available Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	//
	// Jobs that are created without specifying a Glue version default to Glue 0.9.
	GlueVersion *string `min:"1" type:"string"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// For Glue version 1.0 or earlier jobs, using the standard worker type, the
	// number of Glue data processing units (DPUs) that can be allocated when this
	// job runs. A DPU is a relative measure of processing power that consists of
	// 4 vCPUs of compute capacity and 16 GB of memory. For more information, see
	// the Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a Python shell job or an Apache Spark ETL job:
	//
	//    * When you specify a Python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl")
	//    or Apache Spark streaming ETL job (JobCommand.Name="gluestreaming"), you
	//    can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type
	//    cannot have a fractional DPU allocation.
	//
	// For Glue version 2.0 jobs, you cannot instead specify a Maximum capacity.
	// Instead, you should specify a Worker type and the Number of workers.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry this job if it fails.
	MaxRetries *int64 `type:"integer"`

	// The name you assign to this job definition. It must be unique in your account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Non-overridable arguments for this job, specified as name-value pairs.
	NonOverridableArguments map[string]*string `type:"map"`

	// Specifies configuration properties of a job notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The name or Amazon Resource Name (ARN) of the IAM role associated with this
	// job.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The tags to use with this job. You may use tags to limit access to the job.
	// For more information about tags in Glue, see Amazon Web Services Tags in
	// Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in the
	// developer guide.
	Tags map[string]*string `type:"map"`

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of
	//    memory, 64 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	//    * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of
	//    memory, 128 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	WorkerType *string `type:"string" enum:"WorkerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlueVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.NotificationProperty != nil {
		if err := s.NotificationProperty.Validate(); err != nil {
			invalidParams.AddNested("NotificationProperty", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedCapacity sets the AllocatedCapacity field's value.
func (s *CreateJobInput) SetAllocatedCapacity(v int64) *CreateJobInput {
	s.AllocatedCapacity = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *CreateJobInput) SetCommand(v *JobCommand) *CreateJobInput {
	s.Command = v
	return s
}

// SetConnections sets the Connections field's value.
func (s *CreateJobInput) SetConnections(v *ConnectionsList) *CreateJobInput {
	s.Connections = v
	return s
}

// SetDefaultArguments sets the DefaultArguments field's value.
func (s *CreateJobInput) SetDefaultArguments(v map[string]*string) *CreateJobInput {
	s.DefaultArguments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetExecutionProperty sets the ExecutionProperty field's value.
func (s *CreateJobInput) SetExecutionProperty(v *ExecutionProperty) *CreateJobInput {
	s.ExecutionProperty = v
	return s
}

// SetGlueVersion sets the GlueVersion field's value.
func (s *CreateJobInput) SetGlueVersion(v string) *CreateJobInput {
	s.GlueVersion = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *CreateJobInput) SetLogUri(v string) *CreateJobInput {
	s.LogUri = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *CreateJobInput) SetMaxCapacity(v float64) *CreateJobInput {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *CreateJobInput) SetMaxRetries(v int64) *CreateJobInput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateJobInput) SetName(v string) *CreateJobInput {
	s.Name = &v
	return s
}

// SetNonOverridableArguments sets the NonOverridableArguments field's value.
func (s *CreateJobInput) SetNonOverridableArguments(v map[string]*string) *CreateJobInput {
	s.NonOverridableArguments = v
	return s
}

// SetNotificationProperty sets the NotificationProperty field's value.
func (s *CreateJobInput) SetNotificationProperty(v *NotificationProperty) *CreateJobInput {
	s.NotificationProperty = v
	return s
}

// SetNumberOfWorkers sets the NumberOfWorkers field's value.
func (s *CreateJobInput) SetNumberOfWorkers(v int64) *CreateJobInput {
	s.NumberOfWorkers = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateJobInput) SetRole(v string) *CreateJobInput {
	s.Role = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *CreateJobInput) SetSecurityConfiguration(v string) *CreateJobInput {
	s.SecurityConfiguration = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateJobInput) SetTags(v map[string]*string) *CreateJobInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateJobInput) SetTimeout(v int64) *CreateJobInput {
	s.Timeout = &v
	return s
}

// SetWorkerType sets the WorkerType field's value.
func (s *CreateJobInput) SetWorkerType(v string) *CreateJobInput {
	s.WorkerType = &v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique name that was provided for this job definition.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateJobOutput) SetName(v string) *CreateJobOutput {
	s.Name = &v
	return s
}

// Specifies a JSON classifier for CreateClassifier to create.
type CreateJsonClassifierRequest struct {
	_ struct{} `type:"structure"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// Glue supports a subset of JsonPath, as described in Writing JsonPath Custom
	// Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// JsonPath is a required field
	JsonPath *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJsonClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJsonClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJsonClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJsonClassifierRequest"}
	if s.JsonPath == nil {
		invalidParams.Add(request.NewErrParamRequired("JsonPath"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJsonPath sets the JsonPath field's value.
func (s *CreateJsonClassifierRequest) SetJsonPath(v string) *CreateJsonClassifierRequest {
	s.JsonPath = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateJsonClassifierRequest) SetName(v string) *CreateJsonClassifierRequest {
	s.Name = &v
	return s
}

type CreateMLTransformInput struct {
	_ struct{} `type:"structure"`

	// A description of the machine learning transform that is being defined. The
	// default is an empty string.
	Description *string `type:"string"`

	// This value determines which version of Glue this machine learning transform
	// is compatible with. Glue 1.0 is recommended for most customers. If the value
	// is not set, the Glue compatibility defaults to Glue 0.9. For more information,
	// see Glue Versions (https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
	// in the developer guide.
	GlueVersion *string `min:"1" type:"string"`

	// A list of Glue table definitions used by the transform.
	//
	// InputRecordTables is a required field
	InputRecordTables []*Table `type:"list" required:"true"`

	// The number of Glue data processing units (DPUs) that are allocated to task
	// runs for this transform. You can allocate from 2 to 100 DPUs; the default
	// is 10. A DPU is a relative measure of processing power that consists of 4
	// vCPUs of compute capacity and 16 GB of memory. For more information, see
	// the Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.
	//
	//    * If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot
	//    be set.
	//
	//    * If MaxCapacity is set then neither NumberOfWorkers or WorkerType can
	//    be set.
	//
	//    * If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	//
	//    * MaxCapacity and NumberOfWorkers must both be at least 1.
	//
	// When the WorkerType field is set to a value other than Standard, the MaxCapacity
	// field is set automatically and becomes read-only.
	//
	// When the WorkerType field is set to a value other than Standard, the MaxCapacity
	// field is set automatically and becomes read-only.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry a task for this transform after a task
	// run fails.
	MaxRetries *int64 `type:"integer"`

	// The unique name that you give the transform when you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The number of workers of a defined workerType that are allocated when this
	// task runs.
	//
	// If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	NumberOfWorkers *int64 `type:"integer"`

	// The algorithmic parameters that are specific to the transform type used.
	// Conditionally dependent on the transform type.
	//
	// Parameters is a required field
	Parameters *TransformParameters `type:"structure" required:"true"`

	// The name or Amazon Resource Name (ARN) of the IAM role with the required
	// permissions. The required permissions include both Glue service role permissions
	// to Glue resources, and Amazon S3 permissions required by the transform.
	//
	//    * This role needs Glue service role permissions to allow access to resources
	//    in Glue. See Attach a Policy to IAM Users That Access Glue (https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html).
	//
	//    * This role needs permission to your Amazon Simple Storage Service (Amazon
	//    S3) sources, targets, temporary directory, scripts, and any libraries
	//    used by the task run for this transform.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The tags to use with this machine learning transform. You may use tags to
	// limit access to the machine learning transform. For more information about
	// tags in Glue, see Amazon Web Services Tags in Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html)
	// in the developer guide.
	Tags map[string]*string `type:"map"`

	// The timeout of the task run for this transform in minutes. This is the maximum
	// time that a task run for this transform can consume resources before it is
	// terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The encryption-at-rest settings of the transform that apply to accessing
	// user data. Machine learning transforms can access user data encrypted in
	// Amazon S3 using KMS.
	TransformEncryption *TransformEncryption `type:"structure"`

	// The type of predefined worker that is allocated when this task runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	//
	// MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.
	//
	//    * If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot
	//    be set.
	//
	//    * If MaxCapacity is set then neither NumberOfWorkers or WorkerType can
	//    be set.
	//
	//    * If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	//
	//    * MaxCapacity and NumberOfWorkers must both be at least 1.
	WorkerType *string `type:"string" enum:"WorkerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLTransformInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLTransformInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMLTransformInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMLTransformInput"}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlueVersion", 1))
	}
	if s.InputRecordTables == nil {
		invalidParams.Add(request.NewErrParamRequired("InputRecordTables"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.InputRecordTables != nil {
		for i, v := range s.InputRecordTables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputRecordTables", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TransformEncryption != nil {
		if err := s.TransformEncryption.Validate(); err != nil {
			invalidParams.AddNested("TransformEncryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateMLTransformInput) SetDescription(v string) *CreateMLTransformInput {
	s.Description = &v
	return s
}

// SetGlueVersion sets the GlueVersion field's value.
func (s *CreateMLTransformInput) SetGlueVersion(v string) *CreateMLTransformInput {
	s.GlueVersion = &v
	return s
}

// SetInputRecordTables sets the InputRecordTables field's value.
func (s *CreateMLTransformInput) SetInputRecordTables(v []*Table) *CreateMLTransformInput {
	s.InputRecordTables = v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *CreateMLTransformInput) SetMaxCapacity(v float64) *CreateMLTransformInput {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *CreateMLTransformInput) SetMaxRetries(v int64) *CreateMLTransformInput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMLTransformInput) SetName(v string) *CreateMLTransformInput {
	s.Name = &v
	return s
}

// SetNumberOfWorkers sets the NumberOfWorkers field's value.
func (s *CreateMLTransformInput) SetNumberOfWorkers(v int64) *CreateMLTransformInput {
	s.NumberOfWorkers = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateMLTransformInput) SetParameters(v *TransformParameters) *CreateMLTransformInput {
	s.Parameters = v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateMLTransformInput) SetRole(v string) *CreateMLTransformInput {
	s.Role = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMLTransformInput) SetTags(v map[string]*string) *CreateMLTransformInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateMLTransformInput) SetTimeout(v int64) *CreateMLTransformInput {
	s.Timeout = &v
	return s
}

// SetTransformEncryption sets the TransformEncryption field's value.
func (s *CreateMLTransformInput) SetTransformEncryption(v *TransformEncryption) *CreateMLTransformInput {
	s.TransformEncryption = v
	return s
}

// SetWorkerType sets the WorkerType field's value.
func (s *CreateMLTransformInput) SetWorkerType(v string) *CreateMLTransformInput {
	s.WorkerType = &v
	return s
}

type CreateMLTransformOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is generated for the transform.
	TransformId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLTransformOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMLTransformOutput) GoString() string {
	return s.String()
}

// SetTransformId sets the TransformId field's value.
func (s *CreateMLTransformOutput) SetTransformId(v string) *CreateMLTransformOutput {
	s.TransformId = &v
	return s
}

type CreatePartitionIndexInput struct {
	_ struct{} `type:"structure"`

	// The catalog ID where the table resides.
	CatalogId *string `min:"1" type:"string"`

	// Specifies the name of a database in which you want to create a partition
	// index.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// Specifies a PartitionIndex structure to create a partition index in an existing
	// table.
	//
	// PartitionIndex is a required field
	PartitionIndex *PartitionIndex `type:"structure" required:"true"`

	// Specifies the name of a table in which you want to create a partition index.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePartitionIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePartitionIndexInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionIndex"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionIndex != nil {
		if err := s.PartitionIndex.Validate(); err != nil {
			invalidParams.AddNested("PartitionIndex", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreatePartitionIndexInput) SetCatalogId(v string) *CreatePartitionIndexInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreatePartitionIndexInput) SetDatabaseName(v string) *CreatePartitionIndexInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionIndex sets the PartitionIndex field's value.
func (s *CreatePartitionIndexInput) SetPartitionIndex(v *PartitionIndex) *CreatePartitionIndexInput {
	s.PartitionIndex = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreatePartitionIndexInput) SetTableName(v string) *CreatePartitionIndexInput {
	s.TableName = &v
	return s
}

type CreatePartitionIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionIndexOutput) GoString() string {
	return s.String()
}

type CreatePartitionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the catalog in which the partition
	// is to be created.
	CatalogId *string `min:"1" type:"string"`

	// The name of the metadata database in which the partition is to be created.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A PartitionInput structure defining the partition to be created.
	//
	// PartitionInput is a required field
	PartitionInput *PartitionInput `type:"structure" required:"true"`

	// The name of the metadata table in which the partition is to be created.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionInput"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionInput != nil {
		if err := s.PartitionInput.Validate(); err != nil {
			invalidParams.AddNested("PartitionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreatePartitionInput) SetCatalogId(v string) *CreatePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreatePartitionInput) SetDatabaseName(v string) *CreatePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionInput sets the PartitionInput field's value.
func (s *CreatePartitionInput) SetPartitionInput(v *PartitionInput) *CreatePartitionInput {
	s.PartitionInput = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreatePartitionInput) SetTableName(v string) *CreatePartitionInput {
	s.TableName = &v
	return s
}

type CreatePartitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartitionOutput) GoString() string {
	return s.String()
}

type CreateRegistryInput struct {
	_ struct{} `type:"structure"`

	// A description of the registry. If description is not provided, there will
	// not be any default value for this.
	Description *string `type:"string"`

	// Name of the registry to be created of max length of 255, and may only contain
	// letters, numbers, hyphen, underscore, dollar sign, or hash mark. No whitespace.
	//
	// RegistryName is a required field
	RegistryName *string `min:"1" type:"string" required:"true"`

	// Amazon Web Services tags that contain a key value pair and may be searched
	// by console, command line, or API.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRegistryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRegistryInput"}
	if s.RegistryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryName"))
	}
	if s.RegistryName != nil && len(*s.RegistryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRegistryInput) SetDescription(v string) *CreateRegistryInput {
	s.Description = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *CreateRegistryInput) SetRegistryName(v string) *CreateRegistryInput {
	s.RegistryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRegistryInput) SetTags(v map[string]*string) *CreateRegistryInput {
	s.Tags = v
	return s
}

type CreateRegistryOutput struct {
	_ struct{} `type:"structure"`

	// A description of the registry.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the newly created registry.
	RegistryArn *string `min:"1" type:"string"`

	// The name of the registry.
	RegistryName *string `min:"1" type:"string"`

	// The tags for the registry.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRegistryOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateRegistryOutput) SetDescription(v string) *CreateRegistryOutput {
	s.Description = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *CreateRegistryOutput) SetRegistryArn(v string) *CreateRegistryOutput {
	s.RegistryArn = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *CreateRegistryOutput) SetRegistryName(v string) *CreateRegistryOutput {
	s.RegistryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRegistryOutput) SetTags(v map[string]*string) *CreateRegistryOutput {
	s.Tags = v
	return s
}

type CreateSchemaInput struct {
	_ struct{} `type:"structure"`

	// The compatibility mode of the schema. The possible values are:
	//
	//    * NONE: No compatibility mode applies. You can use this choice in development
	//    scenarios or if you do not know the compatibility mode that you want to
	//    apply to schemas. Any new version added will be accepted without undergoing
	//    a compatibility check.
	//
	//    * DISABLED: This compatibility choice prevents versioning for a particular
	//    schema. You can use this choice to prevent future versioning of a schema.
	//
	//    * BACKWARD: This compatibility choice is recommended as it allows data
	//    receivers to read both the current and one previous schema version. This
	//    means that for instance, a new schema version cannot drop data fields
	//    or change the type of these fields, so they can't be read by readers using
	//    the previous version.
	//
	//    * BACKWARD_ALL: This compatibility choice allows data receivers to read
	//    both the current and all previous schema versions. You can use this choice
	//    when you need to delete fields or add optional fields, and check compatibility
	//    against all previous schema versions.
	//
	//    * FORWARD: This compatibility choice allows data receivers to read both
	//    the current and one next schema version, but not necessarily later versions.
	//    You can use this choice when you need to add fields or delete optional
	//    fields, but only check compatibility against the last schema version.
	//
	//    * FORWARD_ALL: This compatibility choice allows data receivers to read
	//    written by producers of any new registered schema. You can use this choice
	//    when you need to add fields or delete optional fields, and check compatibility
	//    against all previous schema versions.
	//
	//    * FULL: This compatibility choice allows data receivers to read data written
	//    by producers using the previous or next version of the schema, but not
	//    necessarily earlier or later versions. You can use this choice when you
	//    need to add or remove optional fields, but only check compatibility against
	//    the last schema version.
	//
	//    * FULL_ALL: This compatibility choice allows data receivers to read data
	//    written by producers using all previous schema versions. You can use this
	//    choice when you need to add or remove optional fields, and check compatibility
	//    against all previous schema versions.
	Compatibility *string `type:"string" enum:"Compatibility"`

	// The data format of the schema definition. Currently AVRO, JSON and PROTOBUF
	// are supported.
	//
	// DataFormat is a required field
	DataFormat *string `type:"string" required:"true" enum:"DataFormat"`

	// An optional description of the schema. If description is not provided, there
	// will not be any automatic default value for this.
	Description *string `type:"string"`

	// This is a wrapper shape to contain the registry identity fields. If this
	// is not provided, the default registry will be used. The ARN format for the
	// same will be: arn:aws:glue:us-east-2:<customer id>:registry/default-registry:random-5-letter-id.
	RegistryId *RegistryId `type:"structure"`

	// The schema definition using the DataFormat setting for SchemaName.
	SchemaDefinition *string `min:"1" type:"string"`

	// Name of the schema to be created of max length of 255, and may only contain
	// letters, numbers, hyphen, underscore, dollar sign, or hash mark. No whitespace.
	//
	// SchemaName is a required field
	SchemaName *string `min:"1" type:"string" required:"true"`

	// Amazon Web Services tags that contain a key value pair and may be searched
	// by console, command line, or API. If specified, follows the Amazon Web Services
	// tags-on-create pattern.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchemaInput"}
	if s.DataFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("DataFormat"))
	}
	if s.SchemaDefinition != nil && len(*s.SchemaDefinition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaDefinition", 1))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}
	if s.RegistryId != nil {
		if err := s.RegistryId.Validate(); err != nil {
			invalidParams.AddNested("RegistryId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibility sets the Compatibility field's value.
func (s *CreateSchemaInput) SetCompatibility(v string) *CreateSchemaInput {
	s.Compatibility = &v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *CreateSchemaInput) SetDataFormat(v string) *CreateSchemaInput {
	s.DataFormat = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaInput) SetDescription(v string) *CreateSchemaInput {
	s.Description = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *CreateSchemaInput) SetRegistryId(v *RegistryId) *CreateSchemaInput {
	s.RegistryId = v
	return s
}

// SetSchemaDefinition sets the SchemaDefinition field's value.
func (s *CreateSchemaInput) SetSchemaDefinition(v string) *CreateSchemaInput {
	s.SchemaDefinition = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaInput) SetSchemaName(v string) *CreateSchemaInput {
	s.SchemaName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSchemaInput) SetTags(v map[string]*string) *CreateSchemaInput {
	s.Tags = v
	return s
}

type CreateSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The schema compatibility mode.
	Compatibility *string `type:"string" enum:"Compatibility"`

	// The data format of the schema definition. Currently AVRO, JSON and PROTOBUF
	// are supported.
	DataFormat *string `type:"string" enum:"DataFormat"`

	// A description of the schema if specified when created.
	Description *string `type:"string"`

	// The latest version of the schema associated with the returned schema definition.
	LatestSchemaVersion *int64 `min:"1" type:"long"`

	// The next version of the schema associated with the returned schema definition.
	NextSchemaVersion *int64 `min:"1" type:"long"`

	// The Amazon Resource Name (ARN) of the registry.
	RegistryArn *string `min:"1" type:"string"`

	// The name of the registry.
	RegistryName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string `min:"1" type:"string"`

	// The version number of the checkpoint (the last time the compatibility mode
	// was changed).
	SchemaCheckpoint *int64 `min:"1" type:"long"`

	// The name of the schema.
	SchemaName *string `min:"1" type:"string"`

	// The status of the schema.
	SchemaStatus *string `type:"string" enum:"SchemaStatus"`

	// The unique identifier of the first schema version.
	SchemaVersionId *string `min:"36" type:"string"`

	// The status of the first schema version created.
	SchemaVersionStatus *string `type:"string" enum:"SchemaVersionStatus"`

	// The tags for the schema.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaOutput) GoString() string {
	return s.String()
}

// SetCompatibility sets the Compatibility field's value.
func (s *CreateSchemaOutput) SetCompatibility(v string) *CreateSchemaOutput {
	s.Compatibility = &v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *CreateSchemaOutput) SetDataFormat(v string) *CreateSchemaOutput {
	s.DataFormat = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaOutput) SetDescription(v string) *CreateSchemaOutput {
	s.Description = &v
	return s
}

// SetLatestSchemaVersion sets the LatestSchemaVersion field's value.
func (s *CreateSchemaOutput) SetLatestSchemaVersion(v int64) *CreateSchemaOutput {
	s.LatestSchemaVersion = &v
	return s
}

// SetNextSchemaVersion sets the NextSchemaVersion field's value.
func (s *CreateSchemaOutput) SetNextSchemaVersion(v int64) *CreateSchemaOutput {
	s.NextSchemaVersion = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *CreateSchemaOutput) SetRegistryArn(v string) *CreateSchemaOutput {
	s.RegistryArn = &v
	return s
}

// SetRegistryName sets the RegistryName field's value.
func (s *CreateSchemaOutput) SetRegistryName(v string) *CreateSchemaOutput {
	s.RegistryName = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateSchemaOutput) SetSchemaArn(v string) *CreateSchemaOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaCheckpoint sets the SchemaCheckpoint field's value.
func (s *CreateSchemaOutput) SetSchemaCheckpoint(v int64) *CreateSchemaOutput {
	s.SchemaCheckpoint = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaOutput) SetSchemaName(v string) *CreateSchemaOutput {
	s.SchemaName = &v
	return s
}

// SetSchemaStatus sets the SchemaStatus field's value.
func (s *CreateSchemaOutput) SetSchemaStatus(v string) *CreateSchemaOutput {
	s.SchemaStatus = &v
	return s
}

// SetSchemaVersionId sets the SchemaVersionId field's value.
func (s *CreateSchemaOutput) SetSchemaVersionId(v string) *CreateSchemaOutput {
	s.SchemaVersionId = &v
	return s
}

// SetSchemaVersionStatus sets the SchemaVersionStatus field's value.
func (s *CreateSchemaOutput) SetSchemaVersionStatus(v string) *CreateSchemaOutput {
	s.SchemaVersionStatus = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSchemaOutput) SetTags(v map[string]*string) *CreateSchemaOutput {
	s.Tags = v
	return s
}

type CreateScriptInput struct {
	_ struct{} `type:"structure"`

	// A list of the edges in the DAG.
	DagEdges []*CodeGenEdge `type:"list"`

	// A list of the nodes in the DAG.
	DagNodes []*CodeGenNode `type:"list"`

	// The programming language of the resulting code from the DAG.
	Language *string `type:"string" enum:"Language"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScriptInput"}
	if s.DagEdges != nil {
		for i, v := range s.DagEdges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DagEdges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DagNodes != nil {
		for i, v := range s.DagNodes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DagNodes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDagEdges sets the DagEdges field's value.
func (s *CreateScriptInput) SetDagEdges(v []*CodeGenEdge) *CreateScriptInput {
	s.DagEdges = v
	return s
}

// SetDagNodes sets the DagNodes field's value.
func (s *CreateScriptInput) SetDagNodes(v []*CodeGenNode) *CreateScriptInput {
	s.DagNodes = v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CreateScriptInput) SetLanguage(v string) *CreateScriptInput {
	s.Language = &v
	return s
}

type CreateScriptOutput struct {
	_ struct{} `type:"structure"`

	// The Python script generated from the DAG.
	PythonScript *string `type:"string"`

	// The Scala code generated from the DAG.
	ScalaCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptOutput) GoString() string {
	return s.String()
}

// SetPythonScript sets the PythonScript field's value.
func (s *CreateScriptOutput) SetPythonScript(v string) *CreateScriptOutput {
	s.PythonScript = &v
	return s
}

// SetScalaCode sets the ScalaCode field's value.
func (s *CreateScriptOutput) SetScalaCode(v string) *CreateScriptOutput {
	s.ScalaCode = &v
	return s
}

type CreateSecurityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The encryption configuration for the new security configuration.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *EncryptionConfiguration `type:"structure" required:"true"`

	// The name for the new security configuration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityConfigurationInput"}
	if s.EncryptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionConfiguration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *CreateSecurityConfigurationInput) SetEncryptionConfiguration(v *EncryptionConfiguration) *CreateSecurityConfigurationInput {
	s.EncryptionConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecurityConfigurationInput) SetName(v string) *CreateSecurityConfigurationInput {
	s.Name = &v
	return s
}

type CreateSecurityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the new security configuration was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The name assigned to the new security configuration.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateSecurityConfigurationOutput) SetCreatedTimestamp(v time.Time) *CreateSecurityConfigurationOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecurityConfigurationOutput) SetName(v string) *CreateSecurityConfigurationOutput {
	s.Name = &v
	return s
}

// Request to create a new session.
type CreateSessionInput struct {
	_ struct{} `type:"structure"`

	// The SessionCommand that runs the job.
	//
	// Command is a required field
	Command *SessionCommand `type:"structure" required:"true"`

	// The number of connections to use for the session.
	Connections *ConnectionsList `type:"structure"`

	// A map array of key-value pairs. Max is 75 pairs.
	DefaultArguments map[string]*string `type:"map"`

	// The description of the session.
	Description *string `type:"string"`

	// The Glue version determines the versions of Apache Spark and Python that
	// AWS Glue supports. The GlueVersion must be greater than 2.0.
	GlueVersion *string `min:"1" type:"string"`

	// The ID of the session request.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The number of seconds when idle before request times out.
	IdleTimeout *int64 `min:"1" type:"integer"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when the job runs. A DPU is a relative measure of processing power that consists
	// of 4 vCPUs of compute capacity and 16 GB memory.
	MaxCapacity *float64 `type:"double"`

	// The number of workers to use for the session.
	NumberOfWorkers *int64 `type:"integer"`

	// The origin of the request.
	RequestOrigin *string `min:"1" type:"string"`

	// The IAM Role ARN
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`

	// The name of the SecurityConfiguration structure to be used with the session
	SecurityConfiguration *string `min:"1" type:"string"`

	// The map of key value pairs (tags) belonging to the session.
	Tags map[string]*string `type:"map"`

	// The number of seconds before request times out.
	Timeout *int64 `min:"1" type:"integer"`

	// The Worker Type. Can be one of G.1X, G.2X, Standard
	WorkerType *string `type:"string" enum:"WorkerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSessionInput"}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlueVersion", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IdleTimeout != nil && *s.IdleTimeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IdleTimeout", 1))
	}
	if s.RequestOrigin != nil && len(*s.RequestOrigin) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestOrigin", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.Command != nil {
		if err := s.Command.Validate(); err != nil {
			invalidParams.AddNested("Command", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *CreateSessionInput) SetCommand(v *SessionCommand) *CreateSessionInput {
	s.Command = v
	return s
}

// SetConnections sets the Connections field's value.
func (s *CreateSessionInput) SetConnections(v *ConnectionsList) *CreateSessionInput {
	s.Connections = v
	return s
}

// SetDefaultArguments sets the DefaultArguments field's value.
func (s *CreateSessionInput) SetDefaultArguments(v map[string]*string) *CreateSessionInput {
	s.DefaultArguments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSessionInput) SetDescription(v string) *CreateSessionInput {
	s.Description = &v
	return s
}

// SetGlueVersion sets the GlueVersion field's value.
func (s *CreateSessionInput) SetGlueVersion(v string) *CreateSessionInput {
	s.GlueVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSessionInput) SetId(v string) *CreateSessionInput {
	s.Id = &v
	return s
}

// SetIdleTimeout sets the IdleTimeout field's value.
func (s *CreateSessionInput) SetIdleTimeout(v int64) *CreateSessionInput {
	s.IdleTimeout = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *CreateSessionInput) SetMaxCapacity(v float64) *CreateSessionInput {
	s.MaxCapacity = &v
	return s
}

// SetNumberOfWorkers sets the NumberOfWorkers field's value.
func (s *CreateSessionInput) SetNumberOfWorkers(v int64) *CreateSessionInput {
	s.NumberOfWorkers = &v
	return s
}

// SetRequestOrigin sets the RequestOrigin field's value.
func (s *CreateSessionInput) SetRequestOrigin(v string) *CreateSessionInput {
	s.RequestOrigin = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateSessionInput) SetRole(v string) *CreateSessionInput {
	s.Role = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *CreateSessionInput) SetSecurityConfiguration(v string) *CreateSessionInput {
	s.SecurityConfiguration = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSessionInput) SetTags(v map[string]*string) *CreateSessionInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateSessionInput) SetTimeout(v int64) *CreateSessionInput {
	s.Timeout = &v
	return s
}

// SetWorkerType sets the WorkerType field's value.
func (s *CreateSessionInput) SetWorkerType(v string) *CreateSessionInput {
	s.WorkerType = &v
	return s
}

type CreateSessionOutput struct {
	_ struct{} `type:"structure"`

	// Returns the session object in the response.
	Session *Session `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *CreateSessionOutput) SetSession(v *Session) *CreateSessionOutput {
	s.Session = v
	return s
}

type CreateTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the Table. If none is supplied,
	// the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The catalog database in which to create the new table. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of partition indexes, PartitionIndex structures, to create in the
	// table.
	PartitionIndexes []*PartitionIndex `type:"list"`

	// The TableInput object that defines the metadata table to create in the catalog.
	//
	// TableInput is a required field
	TableInput *TableInput `type:"structure" required:"true"`

	// The ID of the transaction.
	TransactionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableInput == nil {
		invalidParams.Add(request.NewErrParamRequired("TableInput"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}
	if s.PartitionIndexes != nil {
		for i, v := range s.PartitionIndexes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionIndexes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TableInput != nil {
		if err := s.TableInput.Validate(); err != nil {
			invalidParams.AddNested("TableInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateTableInput) SetCatalogId(v string) *CreateTableInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateTableInput) SetDatabaseName(v string) *CreateTableInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionIndexes sets the PartitionIndexes field's value.
func (s *CreateTableInput) SetPartitionIndexes(v []*PartitionIndex) *CreateTableInput {
	s.PartitionIndexes = v
	return s
}

// SetTableInput sets the TableInput field's value.
func (s *CreateTableInput) SetTableInput(v *TableInput) *CreateTableInput {
	s.TableInput = v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *CreateTableInput) SetTransactionId(v string) *CreateTableInput {
	s.TransactionId = &v
	return s
}

type CreateTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) GoString() string {
	return s.String()
}

type CreateTriggerInput struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger when it fires.
	//
	// Actions is a required field
	Actions []*Action `type:"list" required:"true"`

	// A description of the new trigger.
	Description *string `type:"string"`

	// Batch condition that must be met (specified number of events received or
	// batch time window expired) before EventBridge event trigger fires.
	EventBatchingCondition *EventBatchingCondition `type:"structure"`

	// The name of the trigger.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A predicate to specify when the new trigger should fire.
	//
	// This field is required when the trigger type is CONDITIONAL.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	//
	// This field is required when the trigger type is SCHEDULED.
	Schedule *string `type:"string"`

	// Set to true to start SCHEDULED and CONDITIONAL triggers when created. True
	// is not supported for ON_DEMAND triggers.
	StartOnCreation *bool `type:"boolean"`

	// The tags to use with this trigger. You may use tags to limit access to the
	// trigger. For more information about tags in Glue, see Amazon Web Services
	// Tags in Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html)
	// in the developer guide.
	Tags map[string]*string `type:"map"`

	// The type of the new trigger.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"TriggerType"`

	// The name of the workflow associated with the trigger.
	WorkflowName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTriggerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTriggerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTriggerInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EventBatchingCondition != nil {
		if err := s.EventBatchingCondition.Validate(); err != nil {
			invalidParams.AddNested("EventBatchingCondition", err.(request.ErrInvalidParams))
		}
	}
	if s.Predicate != nil {
		if err := s.Predicate.Validate(); err != nil {
			invalidParams.AddNested("Predicate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateTriggerInput) SetActions(v []*Action) *CreateTriggerInput {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTriggerInput) SetDescription(v string) *CreateTriggerInput {
	s.Description = &v
	return s
}

// SetEventBatchingCondition sets the EventBatchingCondition field's value.
func (s *CreateTriggerInput) SetEventBatchingCondition(v *EventBatchingCondition) *CreateTriggerInput {
	s.EventBatchingCondition = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTriggerInput) SetName(v string) *CreateTriggerInput {
	s.Name = &v
	return s
}

// SetPredicate sets the Predicate field's value.
func (s *CreateTriggerInput) SetPredicate(v *Predicate) *CreateTriggerInput {
	s.Predicate = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateTriggerInput) SetSchedule(v string) *CreateTriggerInput {
	s.Schedule = &v
	return s
}

// SetStartOnCreation sets the StartOnCreation field's value.
func (s *CreateTriggerInput) SetStartOnCreation(v bool) *CreateTriggerInput {
	s.StartOnCreation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTriggerInput) SetTags(v map[string]*string) *CreateTriggerInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateTriggerInput) SetType(v string) *CreateTriggerInput {
	s.Type = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *CreateTriggerInput) SetWorkflowName(v string) *CreateTriggerInput {
	s.WorkflowName = &v
	return s
}

type CreateTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTriggerOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateTriggerOutput) SetName(v string) *CreateTriggerOutput {
	s.Name = &v
	return s
}

type CreateUserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the function. If none is provided,
	// the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which to create the function.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A FunctionInput object that defines the function to create in the Data Catalog.
	//
	// FunctionInput is a required field
	FunctionInput *UserDefinedFunctionInput `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserDefinedFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserDefinedFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserDefinedFunctionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.FunctionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionInput"))
	}
	if s.FunctionInput != nil {
		if err := s.FunctionInput.Validate(); err != nil {
			invalidParams.AddNested("FunctionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateUserDefinedFunctionInput) SetCatalogId(v string) *CreateUserDefinedFunctionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateUserDefinedFunctionInput) SetDatabaseName(v string) *CreateUserDefinedFunctionInput {
	s.DatabaseName = &v
	return s
}

// SetFunctionInput sets the FunctionInput field's value.
func (s *CreateUserDefinedFunctionInput) SetFunctionInput(v *UserDefinedFunctionInput) *CreateUserDefinedFunctionInput {
	s.FunctionInput = v
	return s
}

type CreateUserDefinedFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserDefinedFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserDefinedFunctionOutput) GoString() string {
	return s.String()
}

type CreateWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A collection of properties to be used as part of each execution of the workflow.
	DefaultRunProperties map[string]*string `type:"map"`

	// A description of the workflow.
	Description *string `type:"string"`

	// You can use this parameter to prevent unwanted multiple updates to data,
	// to control costs, or in some cases, to prevent exceeding the maximum number
	// of concurrent runs of any of the component jobs. If you leave this parameter
	// blank, there is no limit to the number of concurrent workflow runs.
	MaxConcurrentRuns *int64 `type:"integer"`

	// The name to be assigned to the workflow. It should be unique within your
	// account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags to be used with this workflow.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkflowInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultRunProperties sets the DefaultRunProperties field's value.
func (s *CreateWorkflowInput) SetDefaultRunProperties(v map[string]*string) *CreateWorkflowInput {
	s.DefaultRunProperties = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowInput) SetDescription(v string) *CreateWorkflowInput {
	s.Description = &v
	return s
}

// SetMaxConcurrentRuns sets the MaxConcurrentRuns field's value.
func (s *CreateWorkflowInput) SetMaxConcurrentRuns(v int64) *CreateWorkflowInput {
	s.MaxConcurrentRuns = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowInput) SetName(v string) *CreateWorkflowInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkflowInput) SetTags(v map[string]*string) *CreateWorkflowInput {
	s.Tags = v
	return s
}

type CreateWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The name of the workflow which was provided as part of the request.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateWorkflowOutput) SetName(v string) *CreateWorkflowOutput {
	s.Name = &v
	return s
}

// Specifies an XML classifier for CreateClassifier to create.
type CreateXMLClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This can't identify a self-closing element (closed by />).
	// An empty row element that contains only attributes can be parsed as long
	// as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateXMLClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateXMLClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateXMLClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateXMLClassifierRequest"}
	if s.Classification == nil {
		invalidParams.Add(request.NewErrParamRequired("Classification"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *CreateXMLClassifierRequest) SetClassification(v string) *CreateXMLClassifierRequest {
	s.Classification = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateXMLClassifierRequest) SetName(v string) *CreateXMLClassifierRequest {
	s.Name = &v
	return s
}

// SetRowTag sets the RowTag field's value.
func (s *CreateXMLClassifierRequest) SetRowTag(v string) *CreateXMLClassifierRequest {
	s.RowTag = &v
	return s
}

// A classifier for custom CSV content.
type CsvClassifier struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader *string `type:"string" enum:"CsvHeaderOption"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []*string `type:"list"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// It must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvClassifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvClassifier) GoString() string {
	return s.String()
}

// SetAllowSingleColumn sets the AllowSingleColumn field's value.
func (s *CsvClassifier) SetAllowSingleColumn(v bool) *CsvClassifier {
	s.AllowSingleColumn = &v
	return s
}

// SetContainsHeader sets the ContainsHeader field's value.
func (s *CsvClassifier) SetContainsHeader(v string) *CsvClassifier {
	s.ContainsHeader = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CsvClassifier) SetCreationTime(v time.Time) *CsvClassifier {
	s.CreationTime = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *CsvClassifier) SetDelimiter(v string) *CsvClassifier {
	s.Delimiter = &v
	return s
}

// SetDisableValueTrimming sets the DisableValueTrimming field's value.
func (s *CsvClassifier) SetDisableValueTrimming(v bool) *CsvClassifier {
	s.DisableValueTrimming = &v
	return s
}

// SetHeader sets the Header field's value.
func (s *CsvClassifier) SetHeader(v []*string) *CsvClassifier {
	s.Header = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *CsvClassifier) SetLastUpdated(v time.Time) *CsvClassifier {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *CsvClassifier) SetName(v string) *CsvClassifier {
	s.Name = &v
	return s
}

// SetQuoteSymbol sets the QuoteSymbol field's value.
func (s *CsvClassifier) SetQuoteSymbol(v string) *CsvClassifier {
	s.QuoteSymbol = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CsvClassifier) SetVersion(v int64) *CsvClassifier {
	s.Version = &v
	return s
}

// Contains configuration information for maintaining Data Catalog security.
type DataCatalogEncryptionSettings struct {
	_ struct{} `type:"structure"`

	// When connection password protection is enabled, the Data Catalog uses a customer-provided
	// key to encrypt the password as part of CreateConnection or UpdateConnection
	// and store it in the ENCRYPTED_PASSWORD field in the connection properties.
	// You can enable catalog encryption or only password encryption.
	ConnectionPasswordEncryption *ConnectionPasswordEncryption `type:"structure"`

	// Specifies the encryption-at-rest configuration for the Data Catalog.
	EncryptionAtRest *EncryptionAtRest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCatalogEncryptionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCatalogEncryptionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCatalogEncryptionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataCatalogEncryptionSettings"}
	if s.ConnectionPasswordEncryption != nil {
		if err := s.ConnectionPasswordEncryption.Validate(); err != nil {
			invalidParams.AddNested("ConnectionPasswordEncryption", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRest != nil {
		if err := s.EncryptionAtRest.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionPasswordEncryption sets the ConnectionPasswordEncryption field's value.
func (s *DataCatalogEncryptionSettings) SetConnectionPasswordEncryption(v *ConnectionPasswordEncryption) *DataCatalogEncryptionSettings {
	s.ConnectionPasswordEncryption = v
	return s
}

// SetEncryptionAtRest sets the EncryptionAtRest field's value.
func (s *DataCatalogEncryptionSettings) SetEncryptionAtRest(v *EncryptionAtRest) *DataCatalogEncryptionSettings {
	s.EncryptionAtRest = v
	return s
}

// The Lake Formation principal.
type DataLakePrincipal struct {
	_ struct{} `type:"structure"`

	// An identifier for the Lake Formation principal.
	DataLakePrincipalIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakePrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakePrincipal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakePrincipal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakePrincipal"}
	if s.DataLakePrincipalIdentifier != nil && len(*s.DataLakePrincipalIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataLakePrincipalIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataLakePrincipalIdentifier sets the DataLakePrincipalIdentifier field's value.
func (s *DataLakePrincipal) SetDataLakePrincipalIdentifier(v string) *DataLakePrincipal {
	s.DataLakePrincipalIdentifier = &v
	return s
}

// The Database object represents a logical grouping of tables that might reside
// in a Hive metastore or an RDBMS.
type Database struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the database resides.
	CatalogId *string `min:"1" type:"string"`

	// Creates a set of default permissions on the table for principals.
	CreateTableDefaultPermissions []*PrincipalPermissions `type:"list"`

	// The time at which the metadata database was created in the catalog.
	CreateTime *time.Time `type:"timestamp"`

	// A description of the database.
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// The name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// These key-value pairs define parameters and properties of the database.
	Parameters map[string]*string `type:"map"`

	// A DatabaseIdentifier structure that describes a target database for resource
	// linking.
	TargetDatabase *DatabaseIdentifier `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) GoString() string {
	return s.String()
}

// SetCatalogId sets the CatalogId field's value.
func (s *Database) SetCatalogId(v string) *Database {
	s.CatalogId = &v
	return s
}

// SetCreateTableDefaultPermissions sets the CreateTableDefaultPermissions field's value.
func (s *Database) SetCreateTableDefaultPermissions(v []*PrincipalPermissions) *Database {
	s.CreateTableDefaultPermissions = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *Database) SetCreateTime(v time.Time) *Database {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Database) SetDescription(v string) *Database {
	s.Description = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *Database) SetLocationUri(v string) *Database {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *Database) SetName(v string) *Database {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Database) SetParameters(v map[string]*string) *Database {
	s.Parameters = v
	return s
}

// SetTargetDatabase sets the TargetDatabase field's value.
func (s *Database) SetTargetDatabase(v *DatabaseIdentifier) *Database {
	s.TargetDatabase = v
	return s
}

// A structure that describes a target database for resource linking.
type DatabaseIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the database resides.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database.
	DatabaseName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseIdentifier"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DatabaseIdentifier) SetCatalogId(v string) *DatabaseIdentifier {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DatabaseIdentifier) SetDatabaseName(v string) *DatabaseIdentifier {
	s.DatabaseName = &v
	return s
}

// The structure used to create or update a database.
type DatabaseInput struct {
	_ struct{} `type:"structure"`

	// Creates a set of default permissions on the table for principals.
	CreateTableDefaultPermissions []*PrincipalPermissions `type:"list"`

	// A description of the database.
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// The name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// These key-value pairs define parameters and properties of the database.
	//
	// These key-value pairs define parameters and properties of the database.
	Parameters map[string]*string `type:"map"`

	// A DatabaseIdentifier structure that describes a target database for resource
	// linking.
	TargetDatabase *DatabaseIdentifier `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseInput"}
	if s.LocationUri != nil && len(*s.LocationUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocationUri", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.CreateTableDefaultPermissions != nil {
		for i, v := range s.CreateTableDefaultPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateTableDefaultPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetDatabase != nil {
		if err := s.TargetDatabase.Validate(); err != nil {
			invalidParams.AddNested("TargetDatabase", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateTableDefaultPermissions sets the CreateTableDefaultPermissions field's value.
func (s *DatabaseInput) SetCreateTableDefaultPermissions(v []*PrincipalPermissions) *DatabaseInput {
	s.CreateTableDefaultPermissions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DatabaseInput) SetDescription(v string) *DatabaseInput {
	s.Description = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DatabaseInput) SetLocationUri(v string) *DatabaseInput {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatabaseInput) SetName(v string) *DatabaseInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DatabaseInput) SetParameters(v map[string]*string) *DatabaseInput {
	s.Parameters = v
	return s
}

// SetTargetDatabase sets the TargetDatabase field's value.
func (s *DatabaseInput) SetTargetDatabase(v *DatabaseIdentifier) *DatabaseInput {
	s.TargetDatabase = v
	return s
}

// Defines column statistics supported for timestamp data columns.
type DateColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// The highest value in the column.
	MaximumValue *time.Time `type:"timestamp"`

	// The lowest value in the column.
	MinimumValue *time.Time `type:"timestamp"`

	// The number of distinct values in a column.
	//
	// NumberOfDistinctValues is a required field
	NumberOfDistinctValues *int64 `type:"long" required:"true"`

	// The number of null values in the column.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateColumnStatisticsData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateColumnStatisticsData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateColumnStatisticsData"}
	if s.NumberOfDistinctValues == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfDistinctValues"))
	}
	if s.NumberOfNulls == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfNulls"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumValue sets the MaximumValue field's value.
func (s *DateColumnStatisticsData) SetMaximumValue(v time.Time) *DateColumnStatisticsData {
	s.MaximumValue = &v
	return s
}

// SetMinimumValue sets the MinimumValue field's value.
func (s *DateColumnStatisticsData) SetMinimumValue(v time.Time) *DateColumnStatisticsData {
	s.MinimumValue = &v
	return s
}

// SetNumberOfDistinctValues sets the NumberOfDistinctValues field's value.
func (s *DateColumnStatisticsData) SetNumberOfDistinctValues(v int64) *DateColumnStatisticsData {
	s.NumberOfDistinctValues = &v
	return s
}

// SetNumberOfNulls sets the NumberOfNulls field's value.
func (s *DateColumnStatisticsData) SetNumberOfNulls(v int64) *DateColumnStatisticsData {
	s.NumberOfNulls = &v
	return s
}

// Defines column statistics supported for fixed-point number data columns.
type DecimalColumnStatisticsData struct {
	_ struct{} `type:"structure"`

	// The highest value in the column.
	MaximumValue *DecimalNumber `type:"structure"`

	// The lowest value in the column.
	MinimumValue *DecimalNumber `type:"structure"`

	// The number of distinct values in a column.
	//
	// NumberOfDistinctValues is a required field
	NumberOfDistinctValues *int64 `type:"long" required:"true"`

	// The number of null values in the column.
	//
	// NumberOfNulls is a required field
	NumberOfNulls *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecimalColumnStatisticsData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecimalColumnStatisticsData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecimalColumnStatisticsData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecimalColumnStatisticsData"}
	if s.NumberOfDistinctValues == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfDistinctValues"))
	}
	if s.NumberOfNulls == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfNulls"))
	}
	if s.MaximumValue != nil {
		if err := s.MaximumValue.Validate(); err != nil {
			invalidParams.AddNested("MaximumValue", err.(request.ErrInvalidParams))
		}
	}
	if s.MinimumValue != nil {
		if err := s.MinimumValue.Validate(); err != nil {
			invalidParams.AddNested("MinimumValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumValue sets the MaximumValue field's value.
func (s *DecimalColumnStatisticsData) SetMaximumValue(v *DecimalNumber) *DecimalColumnStatisticsData {
	s.MaximumValue = v
	return s
}

// SetMinimumValue sets the MinimumValue field's value.
func (s *DecimalColumnStatisticsData) SetMinimumValue(v *DecimalNumber) *DecimalColumnStatisticsData {
	s.MinimumValue = v
	return s
}

// SetNumberOfDistinctValues sets the NumberOfDistinctValues field's value.
func (s *DecimalColumnStatisticsData) SetNumberOfDistinctValues(v int64) *DecimalColumnStatisticsData {
	s.NumberOfDistinctValues = &v
	return s
}

// SetNumberOfNulls sets the NumberOfNulls field's value.
func (s *DecimalColumnStatisticsData) SetNumberOfNulls(v int64) *DecimalColumnStatisticsData {
	s.NumberOfNulls = &v
	return s
}

// Contains a numeric value in decimal format.
type DecimalNumber struct {
	_ struct{} `type:"structure"`

	// The scale that determines where the decimal point falls in the unscaled value.
	//
	// Scale is a required field
	Scale *int64 `type:"integer" required:"true"`

	// The unscaled numeric value.
	// UnscaledValue is automatically base64 encoded/decoded by the SDK.
	//
	// UnscaledValue is a required field
	UnscaledValue []byte `type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecimalNumber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecimalNumber) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecimalNumber) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecimalNumber"}
	if s.Scale == nil {
		invalidParams.Add(request.NewErrParamRequired("Scale"))
	}
	if s.UnscaledValue == nil {
		invalidParams.Add(request.NewErrParamRequired("UnscaledValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScale sets the Scale field's value.
func (s *DecimalNumber) SetScale(v int64) *DecimalNumber {
	s.Scale = &v
	return s
}

// SetUnscaledValue sets the UnscaledValue field's value.
func (s *DecimalNumber) SetUnscaledValue(v []byte) *DecimalNumber {
	s.UnscaledValue = v
	return s
}

type DeleteBlueprintInput struct {
	_ struct{} `type:"structure"`

	// The name of the blueprint to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBlueprintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBlueprintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBlueprintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBlueprintInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteBlueprintInput) SetName(v string) *DeleteBlueprintInput {
	s.Name = &v
	return s
}

type DeleteBlueprintOutput struct {
	_ struct{} `type:"structure"`

	// Returns the name of the blueprint that was deleted.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBlueprintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBlueprintOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteBlueprintOutput) SetName(v string) *DeleteBlueprintOutput {
	s.Name = &v
	return s
}

type DeleteClassifierInput struct {
	_ struct{} `type:"structure"`

	// Name of the classifier to remove.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClassifierInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteClassifierInput) SetName(v string) *DeleteClassifierInput {
	s.Name = &v
	return s
}

type DeleteClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced w