# tests/test_away.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins

import unittest, time, Queue

plugins.reload('gozerplugs.plugs', 'away')

class test_away(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
        
    def setUp(self):
        self.b.say = self.sayoverload
        result = self.b.test('away-enable')
        self.queue = Queue.Queue()

    def sayoverload(self, printto, txt, who=None, how='msg', fromm=None, speed=5):
        self.queue.put(txt)

    def test_away2(self):
        self.b.fakein(':test!test@test PRIVMSG #test :re')
        self.b.fakein(':test!test@test PRIVMSG #test :&')
        result = waitforqueue(self.queue, 2)
        self.assert_(stringinlist('ltrs', result))

    def test_away3(self):
        self.b.fakein(':test!test@test PRIVMSG #test :&')
        time.sleep(0.1)
        self.b.fakein(':test!test@test PRIVMSG #test :re')
        result = waitforqueue(self.queue, 2)
        self.assert_(stringinlist('welcome', result))

    def test_away4(self):
        self.b.fakein(':test!test@test PRIVMSG #test :re')
        time.sleep(0.1)
        self.b.fakein(':test!test@test PRIVMSG #test :\001&\001')
        result = waitforqueue(self.queue, 2)
        self.assert_(stringinlist('ltrs', result))

    def test_away5(self):
        self.b.fakein(':test!test@test PRIVMSG #test :&')
        time.sleep(0.1)
        self.b.fakein(':test!test@test PRIVMSG #test :back')
        result = waitforqueue(self.queue, 2)
        self.assert_(stringinlist('welcome', result))
