# tests/test_code.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'code')
plugins.reload('gozerplugs.plugs', 'googletalk')

class test_code(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_funcnames(self):
        result = self.b.test('funcnames')
        self.assert_(stringinlist('<plugname>', result))

    def test_funcnames2(self):
        result = self.b.test('funcnames mekker')
        self.assert_(stringinlist('no mekker plugin exists', result))

    def test_funcnames3(self):
        result = self.b.test('funcnames code')
        self.assert_(stringinlist('handle_funcnames', result))

    def test_funcnames4(self):
        result = self.b.test('funcnames googletalk')
        self.assert_(stringinlist("can't find", result))
