%{
/*
Copyright (C) 2000-2004  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#define YYDEBUG 1
#define YYERROR_VERBOSE 1
#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"
int linecount;
int yyerror(char *s);
int yylex(void);
static int once=0;
%}
%union {
  int val;
  strcom str;
}
%token <str> KINTEGER KREAL
%token <str> KENTRY
%token <str> KSTRING
%left KEOC
%left INT LVAL
%left ';' ','
%right '=' KPE KSE KME KDE KDRE KEUCE KMODE KSRE KSLE
%left '&' KAND '|' KOR 
%left KEQ KNE KGE '<' KLE '>' 
%left '+' '-'
%left KSR KSL 
%left '%' KDR '\\' '/' '*'
%left SIGN
%right '^'
%left '!' '~' '[' '\'' '#'
%left '.' MAT
%token KPP KSS 
%left ':'
%type <val> commands seq matrix matrix_index expr
%type <val> lvalue 
%type <val> matrixelts matrixlines arg listarg definition 
%type <val> funcid memberid
%start commands
%%
commands: {$$=-1;}
        | commands seq KEOC {$$=($1==-1)?$2:newnode(Fseq,$1,$2);}
	| commands KEOC     {$$=$1;}
	| commands semicommas KEOC     {$$=$1;}
;

semicommas: ';'
          | semicommas ';'
;

seq: expr     {$$=$1;}
   | semicommas expr     {$$=$2;}
   | seq ';' expr {$$=newnode(Fseq,$1,$3);}
   | seq ';'      {$$=$1;}
;

matrix_index: '[' expr ',' expr ']' {$$=newnode(Fmatrix,$2,$4);}
            | '[' expr ']' {$$=newnode(Fmatrix,$2,-1);}
            | '[' expr ',' ']' {$$=newnode(FmatrixL,$2,-1);}
            | '[' ',' expr ']' {$$=newnode(FmatrixR,$3,-1);}
;

/* KREAL catch all reals except REAL_NOTAIL, i.e "[0-9]*."
 * We need to fix that here.
 */
expr: KINTEGER %prec INT {$$=newintnode($1.s,$1.c);}
    | KREAL              {$$=newrealnode($1.s,$1.c);}
    | '.'                {$$=newnode(Fconst,newsmallrealvalue(0),-1);}
    | KINTEGER '.'       {$$=newdotnode($1.s,$1.c);}
    | KINTEGER '.' KENTRY  {$$=newnodecom(Fentryfunc,newmember($3.s),newintnode($1.s,$1.c),$3.c);}
    | KSTRING           {$$=newstringnode($1.s,$1.c);}
    | '\'' KENTRY       {$$=newquotenode($2.s,$2.c);}
    | funcid            {$$=$1;}
    | lvalue %prec LVAL	{$$=$1;}
    | matrix            {$$=$1;}
    | definition        {$$=$1;} 
    | lvalue '=' expr {$$=newnode(Faffect,$1,$3);}
    | lvalue KPP {$$=newopcall(OPpp,$1,-1);}
    | lvalue KSS {$$=newopcall(OPss,$1,-1);}
    | lvalue KME expr {$$=newopcall(OPme,$1,$3);}
    | lvalue KDE expr {$$=newopcall(OPde,$1,$3);}
    | lvalue KDRE expr {$$=newopcall(OPdre,$1,$3);}
    | lvalue KEUCE expr {$$=newopcall(OPeuce,$1,$3);}
    | lvalue KMODE expr {$$=newopcall(OPmode,$1,$3);}
    | lvalue KSLE expr {$$=newopcall(OPsle,$1,$3);}
    | lvalue KSRE expr {$$=newopcall(OPsre,$1,$3);}
    | lvalue KPE expr {$$=newopcall(OPpe,$1,$3);}
    | lvalue KSE expr {$$=newopcall(OPse,$1,$3);}
    | '!' expr 	      {$$=newopcall(OPnb,$2,-1);}
    | '#' expr 	      {$$=newcall("length",$2);}
    | expr KOR  expr  {$$=newopcall(OPor,$1,$3);}
    | expr '|'  expr  {$$=newopcall(OPor,$1,$3);}
    | expr KAND expr  {$$=newopcall(OPand,$1,$3);}
    | expr '&'  expr  {$$=newopcall(OPand,$1,$3);}
    | expr KEQ  expr  {$$=newopcall(OPeq,$1,$3);}
    | expr KNE  expr  {$$=newopcall(OPne,$1,$3);}
    | expr KGE  expr  {$$=newopcall(OPge,$1,$3);}
    | expr '>'  expr  {$$=newopcall(OPg,$1,$3);}
    | expr KLE  expr  {$$=newopcall(OPle,$1,$3);}
    | expr '<'  expr  {$$=newopcall(OPl,$1,$3);}
    | expr '-'  expr  {$$=newopcall(OPs,$1,$3);}
    | expr '+'  expr  {$$=newopcall(OPp,$1,$3);}
    | expr KSL  expr  {$$=newopcall(OPsl,$1,$3);}
    | expr KSR  expr  {$$=newopcall(OPsr,$1,$3);}
    | expr '%'  expr  {$$=newopcall(OPmod,$1,$3);}
    | expr KDR  expr  {$$=newopcall(OPdr,$1,$3);}
    | expr '\\' expr  {$$=newopcall(OPeuc,$1,$3);}
    | expr '/'  expr  {$$=newopcall(OPd,$1,$3);}
    | expr '*'  expr  {$$=newopcall(OPm,$1,$3);}
    | '+' expr %prec SIGN {$$=newopcall(OPpl,$2,-1);}
    | '-' expr %prec SIGN {$$=newopcall(OPn,$2,-1);}
    | expr '^' expr {$$=newopcall(OPpow,$1,$3);}
    | expr '~' {$$=newopcall(OPtrans,$1,-1);}
    | expr '\'' {$$=newopcall(OPderiv,$1,-1);}
    | expr '!'  {$$=newopcall(OPfact,$1,-1);}
    | expr matrix_index %prec MAT {$$=newnode(Ffacteurmat,$1,$2);}
    | memberid {$$=$1;}
    | expr ':' KENTRY   {$$=newtag($1,$3.s,$3.c);}
    | '(' expr ')' {$$=$2;}
;

lvalue: KENTRY               {$$=newnodecom(Fentry,newentry($1.s),-1,$1.c);}
      | lvalue matrix_index  {$$=newnode(Ffacteurmat,$1,$2);}
      | lvalue ':' KENTRY    {$$=newtag($1,$3.s,$3.c);}
;

matrixelts: expr {$$=$1;}
          | matrixelts ',' expr {$$=newnode(Fmatrixelts,$1,$3);}
;

matrixlines: matrixelts  ';' matrixelts {$$=newnode(Fmatrixlines,$1,$3);}
           | matrixlines ';' matrixelts {$$=newnode(Fmatrixlines,$1,$3);}
;

matrix: '[' ']'             {$$=newnode(Fvec,-1,-1);}
      | '[' ';' ']'         {$$=newnode(Fmat,-1,-1);}
      | '[' matrixelts ']'  {$$=newnode(Fvec,$2,-1);}
      | '[' matrixlines ']' {$$=newnode(Fmat,$2,-1);}
;

arg: /*empty*/  {$$=GNOARG;}
   | semicommas {$$=GNOARG;}
   | seq        {$$=$1;}
   | '&' lvalue {$$=newnode(Frefarg,$2,-1);}
   | arg error {if (!once) { yyerrok; s_errors.n--;} once=1;}  expr {once=0; $$=newopcall(OPcat,$1,$4);}
;

listarg: arg {$$=$1;}
       | listarg ',' arg {$$=newnode(Flistarg,$1,$3);}
;

funcid: KENTRY '(' listarg ')' {$$=newnodecom(Fentryfunc,newentry($1.s),$3,$1.c);} 
;

memberid: expr '.' KENTRY  {$$=newnodecom(Fentryfunc,newmember($3.s),$1,$3.c);}
;

definition: funcid '=' seq KEOC {$$=newnode(Fdeffunc,$1,$3);}
          | funcid '=' semicommas KEOC {$$=newnode(Fdeffunc,$1,-1);}
          | funcid '=' KEOC {$$=newnode(Fdeffunc,$1,-1);}
          | memberid '=' seq KEOC {$$=newnode(Fdeffunc,$1,$3);}
          | memberid '=' semicommas KEOC {$$=newnode(Fdeffunc,$1,-1);}
          | memberid '=' KEOC {$$=newnode(Fdeffunc,$1,-1);}
;

%%
int yyerror(char *s)
{ 
  int n=stack_new(&s_errors);
  errors[n].lineno=linecount;
  errors[n].txt=strdup(s);
  if (yydebug) fprintf(stderr,"%s:%d: %s\n",nameparse,linecount,s);
  return 0;
}
