/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: term.c 1.5 Sun, 07 Nov 1999 14:13:51 -0600 dreier $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

#ifdef HAVE_LIBSLANG
#if defined (HAVE_SLANG_H)
#include <slang.h>
#elif defined (HAVE_SLANG_SLANG_H)
#include <slang/slang.h>
#else
#error "Can't find slang.h."
#endif
#endif

#include "gphone.h"
#include "gphone-lib.h"

#ifdef HAVE_LIBSLANG
int term_got_initialized = 0;

void
term_setup(void)
{
  struct winsize ws;

  if (ioctl(STDOUT_FILENO, TIOCGWINSZ, &ws) < 0) {
    perror("failed to get window size");
    exit(1);
  }

  SLtt_get_terminfo();

  SLtt_Screen_Rows = ws.ws_row;
  SLtt_Screen_Cols = ws.ws_col;

  if (SLang_init_tty(-1, 0, 1) < 0) {
    fprintf (stderr, "Unable to initialize the terminal.\n");
    exit (1);
  }

  SLsmg_init_smg();
  SLsmg_cls();

  term_got_initialized = 1;
}

void
term_cleanup(void)
{
  if (term_got_initialized) {
    SLsmg_gotorc(SLtt_Screen_Rows - 1, 0);
    SLsmg_refresh();
    SLsmg_reset_smg();
    SLang_reset_tty();
  }
}
#endif



/*
 * Local variables:
 *  compile-command: "make -k libgphone.a"
 * End:
 */
