/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/
/*         {NULL, 'q', POPT_ARG_NONE, &q, 0,  */
/*          N_("Explain gpiv"), NULL}, */


static const struct poptOption options [] = {
        {"bins", 'b', POPT_ARG_INT, &gpiv_par.nbins, 0, 
         N_("number of bins for histograms"), N_("BINS")},
        
        {"columns", 'c', POPT_ARG_INT, &gpiv_par.img_width, 0, 
         N_("number of columns in image"), N_("NCOLUMNS")},
        
        {"rows", 'r', POPT_ARG_INT, &gpiv_par.img_height, 0, 
         N_("number of rows in image"), N_("NROWS")},
        
        {"depth", 'd', POPT_ARG_INT, &gpiv_par.img_depth, 0, 
         N_("image colour depth in bits"), N_("DEPTH")},
        
        {"display_img1", '\0', POPT_ARG_NONE, &gpiv_par.display_img1, 0, 
         N_("enables displaying of the first image of a PIV image pair"), 
         NULL},
        
        {"display_img2", '\0', POPT_ARG_NONE, &gpiv_par.display_img2, 0, 
         N_("enables displaying of the second image of a PIV image pair"), 
         NULL},
        
        {"display_intregs", '\0', POPT_ARG_NONE, &gpiv_par.display_intregs, 0, 
         N_("enables displaying of interrogation regions"), NULL},
        
        {"display_piv", '\0', POPT_ARG_NONE, &gpiv_par.display_piv, 0, 
         N_("enables displaying of PIV data"), NULL},
        
        {"display_vor", '\0', POPT_ARG_NONE, &gpiv_par.display_vor, 0, 
         N_("enables displaying of vorticity data"), NULL},
        
        {"display_sstrain", '\0', POPT_ARG_NONE, &gpiv_par.display_sstrain, 0, 
         N_("enables displaying of shear strain data"), NULL},
        
        {"display_nstrain", '\0', POPT_ARG_NONE, &gpiv_par.display_nstrain, 0, 
         N_("enables displaying of normal strain data"), NULL},
        
        {"hdf", '\0', POPT_ARG_NONE, &gpiv_par.hdf, 0, 
         N_("save data in HDF5 format with .gpi extension"), NULL},
        {"hdf_img", '\0', POPT_ARG_NONE, &gpiv_par.hdf_img, 0, 
         N_("include image data in .gpi file (HDF5 format)"), NULL},
        
        {"print", 'p', POPT_ARG_NONE, &print_par, 0, 
         N_("print parameters and other info to stdout"), NULL},
        
#ifndef DISABLE_DAC
        {"proc_dac", '\0', POPT_ARG_NONE, &gpiv_par.process_dac, 0, 
         N_("includes data acquisition in the chain-process"), NULL},
#endif /* DISABLE_DAC */
        
        {"proc_piv", '\0', POPT_ARG_NONE, &gpiv_par.process_piv, 0, 
         N_("includes piv in the chain-process"), NULL},
        
        {"proc_gradient", '\0', POPT_ARG_NONE, &gpiv_par.process_gradient, 0, 
         N_("includes gradient in the chain-process"), NULL},
        
        {"proc_resstats", '\0', POPT_ARG_NONE, &gpiv_par.process_resstats, 0, 
         N_("includes resstats in the chain-process"), NULL},
        
        {"proc_errvec", '\0', POPT_ARG_NONE, &gpiv_par.process_errvec, 0, 
         N_("includes validate in the chain-process"), NULL},
        
        {"proc_peaklock", '\0', POPT_ARG_NONE, &gpiv_par.process_peaklock, 0, 
         N_("includes peaklock in the chain-process"), NULL},
        
        {"proc_average", '\0', POPT_ARG_NONE, &gpiv_par.process_average, 0, 
         N_("includes average in the chain-process"), NULL},
        
        {"proc_scale", '\0', POPT_ARG_NONE, &gpiv_par.process_scale, 0, 
         N_("includes scaling in the chain-process"), NULL},
        
        {"proc_subtract", '\0', POPT_ARG_NONE, &gpiv_par.process_subtract, 0, 
         N_("includes subtract in the chain-process"), NULL},
        
        {"proc_vorstra", '\0', POPT_ARG_NONE, &gpiv_par.process_vorstra, 0, 
         N_("includes vorticity in the chain-process"), NULL},
        
        {"tooltips", 't', POPT_ARG_NONE, &gpiv_par.show_tooltips, 0, 
         N_("show tooltips"), NULL},
        
        {"zoomscale", 'z', POPT_ARG_INT, &gpiv_par.zoom_index, 0, 
         N_("display zoom index: 0:0.5, 1:0.83, 2:1.0, 3:1.3, 4:1.6, 5:2.0"), 
         N_("SCALE")},
        
        {"vectorscale", 's', POPT_ARG_INT, &gpiv_par.vector_scale, 0, 
         N_("vector length scale"), N_("SCALE")},

        {"verbose", 'V', POPT_ARG_NONE, &verbose, 0, 
         N_("verbose output to stdout"), NULL},
        
        {"view_gpivbuttons", '\0', POPT_ARG_NONE, &gpiv_par.view_gpivbuttons, 0, 
         N_("view the GPIV buttons of the application"), NULL},
        
        {"view_tabulator", '\0', POPT_ARG_NONE, &gpiv_par.view_tabulator, 0, 
         N_("view the tabulator of the application"), NULL},

        {"cross", 'x', POPT_ARG_NONE, &gpiv_par.x_corr, 0, 
         N_("cross-correlation image"), N_("NCOLUMNS")},
        
        {NULL, '\0', 0, NULL, 0}
    };

/*         {"stretch_window", '\0', POPT_ARG_NONE, &gpiv_par.stretch_window, 0,  */
/*          N_("stretch display window to fit image area "), NULL}, */

