/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasmodel.h - interface for canvas model.
 */
#ifndef __GOO_CANVAS_MODEL_H__
#define __GOO_CANVAS_MODEL_H__

#include <gtk/gtk.h>
#include "goocanvasitem.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_MODEL            (goo_canvas_model_get_type ())
#define GOO_CANVAS_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_MODEL, GooCanvasModel))
#define GOO_CANVAS_MODEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_MODEL, GooCanvasModelClass))
#define GOO_IS_CANVAS_MODEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_MODEL))
#define GOO_CANVAS_MODEL_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GOO_TYPE_CANVAS_MODEL, GooCanvasModelIface))


typedef struct _GooCanvasModelIface  GooCanvasModelIface;

/**
 * GooCanvasModel
 *
 * #GooCanvasModel is a typedef used for objects that implement the
 * #GooCanvasModel interface.
 *
 * (There is no actual #GooCanvasModel struct, since it is only an interface.
 * But using '#GooCanvasModel' is more helpful than using '#GObject'.)
 */

/**
 * GooCanvasModelIface
 * @get_root_item: returns the root canvas item of the model.
 *
 * #GooCanvasModelIFace holds the virtual methods that make up the
 * #GooCanvasModel interface.
 */
struct _GooCanvasModelIface
{
  /*< private >*/
  GTypeInterface base_iface;

  /* Virtual Methods. */
  /*< public >*/
  GooCanvasItem* (* get_root_item)     (GooCanvasModel     *model);
};


GType          goo_canvas_model_get_type             (void) G_GNUC_CONST;

GooCanvasItem* goo_canvas_model_get_root_item	     (GooCanvasModel *model);


G_END_DECLS

#endif /* __GOO_CANVAS_MODEL_H__ */
