/*
 * GooCanvas. Copyright (C) 2005-6 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvaspathview.h - view for path item.
 */
#ifndef __GOO_CANVAS_PATH_VIEW_H__
#define __GOO_CANVAS_PATH_VIEW_H__

#include <gtk/gtk.h>
#include "goocanvasitemviewsimple.h"
#include "goocanvaspath.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_PATH_VIEW            (goo_canvas_path_view_get_type ())
#define GOO_CANVAS_PATH_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_PATH_VIEW, GooCanvasPathView))
#define GOO_CANVAS_PATH_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_PATH_VIEW, GooCanvasPathViewClass))
#define GOO_IS_CANVAS_PATH_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_PATH_VIEW))
#define GOO_IS_CANVAS_PATH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_PATH_VIEW))
#define GOO_CANVAS_PATH_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_PATH_VIEW, GooCanvasPathViewClass))


typedef struct _GooCanvasPathView       GooCanvasPathView;
typedef struct _GooCanvasPathViewClass  GooCanvasPathViewClass;

/**
 * GooCanvasPathView
 *
 * The #GooCanvasPathView-struct struct contains private data only.
 */
struct _GooCanvasPathView
{
  GooCanvasItemViewSimple parent_object;
};

struct _GooCanvasPathViewClass
{
  GooCanvasItemViewSimpleClass parent_class;
};


GType              goo_canvas_path_view_get_type (void) G_GNUC_CONST;
GooCanvasItemView* goo_canvas_path_view_new      (GooCanvasView     *canvas_view,
						  GooCanvasItemView *parent_view,
						  GooCanvasPath     *path);


G_END_DECLS

#endif /* __GOO_CANVAS_PATH_VIEW_H__ */
