/** $Header: /cvsroot/gprolog/contribs/gplmysql/mysqlwrap.h,v 1.2 2002/01/29 06:02:52 oommoo Exp $
 *
 * MySQL is a very fast, multi-threaded, multi-user, and robust SQL (Structured Query Language) database server.  Brief comments are listed here as a reference alignment from the original documentation.
 * http://www.mysql.com/documentation/
 *
 * These wrapper functions allow low level access to the mysql function.  The pointers to various mysql structure types are masked as int pointers for ease of reference.  Where appropriate, wrapper function will return a value, gprc, set to the recturn code from called mysql function.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include <gprolog.h>
#include <mysql/mysql.h>

/** Callers declare these functions external.
 */
#ifndef GPLSQL_IMPL
#define GPCDECL extern
#endif

#define RC_DEFAULT 0

/** Allocates or initializes a reference suitable for sql_real_connect(). 
 */
Bool GPCDECL sql_init( int * gpref );

/** Closes a previously opened connection (see also : sql_init() and sql_real_connect()).
 */
Bool GPCDECL sql_close( int * gpref );

/** Attempts to establish a connection to a database engine.
 *
 * The parameters are specified as follows: 
 * - The first parameter should be an existing reference from sql_init(),  
 * - The value of host may be either a hostname or an IP address,
 * - The user parameter contains the user's login ID,
 * - The passwd parameter contains the password for user,
 */
Bool GPCDECL sql_real_connect( int * gpref, 
			  char * gphost,
			  char * gpuser,
			  char * gppasswd,
			   int * gprc
			 );

/** Causes the database specified by db to become the default (current) database on the connection.
 */
Bool GPCDECL sql_select_db( int * gpref, 
                        char * gpdb,
			int * gprc
                       );

/** Executes the SQL query pointed to by the null-terminated string query.
 */
Bool GPCDECL sql_query( int * gpref, 
                     char * gpquery,
		     int * gprc
                   );

/** sql_store_result() reads the entire result of a query, allocates a structure, and places the result into this structure.
*/
Bool GPCDECL sql_store_result( int * gpref, int * gpres );

/** sql_use_result() initiates a result set retrieval but does not actually read the entire result set like sql_store_result() does. Instead, each row must be retrieved individually by making calls to sql_fetch_row().
 */
Bool GPCDECL sql_use_result( int * gpref, int * gpres );

/** Retrieves the next row of a result set. When used after sql_store_result(), sql_fetch_row() returns NULL when there are no more rows to retrieve.
*/
Bool GPCDECL sql_fetch_row( int * gpref,
			PlTerm * gplist,
			int * gprow
                       );

/** Frees the memory allocated for a result set by sql_store_result().
*/
Bool GPCDECL sql_free_result( int * gpres );

/** mysql_error() returns the error message for the most recently invoked API function that can succeed or fail.
 */
Bool GPCDECL sql_error(  int * gpref, PlTerm * error );


Bool GPCDECL sql_info(  int * gpref, PlTerm * error );

/** a brief history since ChangeLog.
 *
 * $Log: mysqlwrap.h,v $
 * Revision 1.2  2002/01/29 06:02:52  oommoo
 * Descriptive comments for doxygen processing.
 *
 *
 */
