/* kisen_position.h
 */
#ifndef _KISEN_POSITION_H
#define _KISEN_POSITION_H

#include "osl/record/kisen.h"
#include "osl/applyMove.h"
namespace osl
{
  SimpleState kisen_position(KisenFile& kisen_file,
			     int record_id, int move_id)
  {
    static osl::vector<Move> moves;
    static int last_record_id = -1;
    if (record_id != last_record_id)
    {
      moves = kisen_file.getMoves(record_id);
      last_record_id = record_id;
    }
    SimpleState state(HIRATE);
    for (int i=0; i<=abs(move_id); ++i)
    {
      ApplyMoveOfTurn::doMove(state, moves[i]);
    }
    if (move_id < 0)
      state.changeTurn();
    return state;
  }
} // namespace osl

#endif /* _KISEN_POSITION_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
