#!/usr/bin/perl -w
use strict;
use Getopt::Std;
use IO::File;
use CheckEval;

my %options;
getopts('mx:y:X:Y:N:', \%options);

my $mixed = $options{'m'} ? "mixed-" : "";
my $pdp_filename = $options{'y'};
my $property_filename = $options{'x'};
my $max_id = 240000;
$max_id = $options{'N'}
    if $options{'N'};
my $xbase = "x";
$xbase = $options{'X'}
    if $options{'X'};
my $ybase = "y";
$xbase = $options{'Y'}
    if $options{'Y'};

my $x_out     = $mixed."tsumero-$xbase.txt";
my $xS_out    = $mixed."tsumero-$xbase-S.txt";
my $xSe_out   = $mixed."tsumero-$xbase-Se.txt";
my $xSek_out  = $mixed."tsumero-$xbase-Sek.txt";
my $xSekc_out = $mixed."tsumero-$xbase-Sekc.txt";
my $y_out     = $mixed."tsumero-$ybase.txt";
my $logy_out  = $mixed."tsumero-$ybase-log.txt";

die "please specify pdp_filename and property_filename"
    unless $pdp_filename && $property_filename;

open (PDP, "$pdp_filename")
    || die $!;
open (X, "> $x_out")
    || die $!;
open (XS, "> $xS_out")
    || die $!;
open (XSE, "> $xSe_out")
    || die $!;
open (XSEK, "> $xSek_out")
    || die $!;
open (XSEKC, "> $xSekc_out")
    || die $!;
open (Y, "> $y_out")
    || die $!;
open (LOGY, "> $logy_out")
    || die $!;
my $prop_io = new IO::File("< $property_filename")
    || die $!;

sub print_x ($$) {
    my ($record_id, $state_id) = @_;
    my @properties = CheckEval::getProperties($prop_io, $record_id, $state_id);
    my $blackStand = &CheckEval::makeBlackStand(@properties);
    my $blackBinaryStand = &CheckEval::makeBinaryBlackStand(@properties);
    my $whiteCastleEffect = &CheckEval::makeWhiteCastleEffect(@properties);
    my $whiteKingPos = &CheckEval::makeWhiteKingPosition(@properties);
    my $whiteCastle = &CheckEval::makeWhiteCastle(@properties);
    print X "$blackStand\n";
    print XS "$blackBinaryStand $blackStand\n";
    print XSE "$blackBinaryStand $blackStand $whiteCastleEffect\n";
    print XSEK "$blackBinaryStand $blackStand $whiteCastleEffect".
	" $whiteKingPos\n";
    print XSEKC "$blackBinaryStand $blackStand $whiteCastleEffect".
	" $whiteKingPos $whiteCastle\n";
}

my $disproof_counter = 0;
while (<PDP>) {
    my ($record_id, $state_id, $defense_p, $defense_d,
	$attack_p, $attack_d, $tsumero_p, $tsumero_d) = split(/\s+/);
    last
	if ($record_id >= $max_id);
    if ($tsumero_p > 0) {
	next
	    unless ($state_id % 2==0); # ˵ͤä̤Ȥ ()
	# print STDERR "$record_id, $state_id\n";
	my $y = ($mixed ? 1.0/$tsumero_p : $tsumero_p);
	print Y "$y\n";
	print LOGY log($y)/log(2)."\n";
	&print_x($record_id, $state_id);
    }
    elsif ($mixed && ($attack_d > 1) && ($disproof_counter++ % 16 == 0)) {
	next
	    unless ($state_id % 2==1); # ͤʤä̤Ȥ ()
	# print STDERR "$record_id, $state_id\n";
	print Y "0\n";
	print LOGY log(1.0/65536)/log(2)."\n";
	&print_x($record_id, $state_id);
    }
}
