/* piecePair.cc
 */
#include "eval/piecePair.h"
#include "eval/indexCache.h"
#include "osl/centering5x3.h"
#include "osl/stat/average.h"
#include <iostream>
#include <iomanip>


gpsshogi::
PiecePair::PiecePair()
{
  PiecePairFeature::init();
}

gpsshogi::
PiecePair::~PiecePair()
{
}

void gpsshogi::
PiecePair::featuresNonUniq(const NumEffectState& state, 
			   index_list_t& out, int offset) const
{
#ifndef L1BALL_NO_SORT
  CArray<IndexCache<40*10>,3> indices;
#endif
  for (int i=0; i<Piece::SIZE; i++) {
    const Piece p = state.getPieceOf(i);
    if (! p.isOnBoard())
      continue;
    for (size_t i=0; i<PiecePairFeature::offsets.size(); ++i) {
      const Position target = p.position() + offsets[i];
      const Piece q = state.getPieceAt(target);
      if (! q.isPiece() || q.number() <= p.number()) // 反対向きの重複排除
	continue;
      assert(!target.isPieceStand() && p.isOnBoard() && q.isOnBoard());
      CArray<int,3> index = PiecePairFeature::index(i, q, p);
      for (size_t i=0; i<index.size(); ++i) {
	if (index[i] == 0)
	  continue;
#ifndef L1BALL_NO_SORT
	indices[i].add(abs(index[i]), index[i] > 0 ? 1.0 : -1.0);
#else
	out.add(abs(index[i]) + offset, index[i] > 0 ? 1 : -1);	
#endif
      }
    }
  }
#ifndef L1BALL_NO_SORT
  for (int i=0; i<3; ++i)
    indices[i].uniqWrite(out, offset);
#endif
}

void gpsshogi::
PiecePair::showSummary(std::ostream& os) const
{
  osl::stat::Average a, a_abs;
  for (size_t i=0; i<values.size(); ++i) {
    if (! values[i]) continue;
    a.add(values[i]);
    a_abs.add(abs(values[i]));
  }
  
  os << "PiecePair min. " << values.min() 
     << " abs(ave.) " << abs(values).sum()/(double)dimension()
     << " ave. " << values.sum()/(double)dimension() << " max. " << values.max() << "\n";
  os << "  ave. (nonzero) " << a.getAverage() << " abs(ave., nonzero) " << a_abs.getAverage()
     << " #nonzero " << a.numElements() << "\n";
}

void gpsshogi::
PiecePair::showAll(std::ostream& os) const
{
  showSummary(os);
}

size_t gpsshogi::
PiecePair::maxActive() const
{
  return 40*10*3;
}

void gpsshogi::
PiecePair::setRandom()
{
  EvalComponent::setRandom();
  PiecePairFeature::sanitize(*this);
}

void gpsshogi::
PiecePair::setWeightScale(const double *w, const double& scale)
{
  EvalComponent::setWeightScale(w, scale);
  PiecePairFeature::sanitize(*this);
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
