/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>

#include <glib.h>


#define CONFIG_INDENT_STRING   "    "

#define RCFILE           ".gq"

#define RCFILE_MODE_MSG "%s is world readable.\nThis file can contain " \
			"passwords,\n and should be mode 0600.\n\n" \
			"Continuing with default settings...\n"


/* tokens for config file */
#define T_UNKNOWN             0
#define T_XML_VERSION         1
#define T_COMMENT             2
#define T_GQ_CONFIG          10

#define T_CONFIRM_MOD        11
#define T_SEARCH_ARGUMENT    12
#define T_SHOWDN             13
#define T_SHOWOC             14
#define T_SORT_SEARCH        15
#define T_SORT_BROWSE        16
#define T_SHOW_RDN_ONLY	     17
#define T_SCHEMASERVER       18

/* per-server tokens */
#define T_LDAPSERVER         20
#define T_NAME               21
#define T_LDAPHOST           22
#define T_LDAPPORT           23
#define T_BASEDN             24
#define T_BINDDN             25
#define T_BINDPW             26
#define T_BINDTYPE           27
#define T_SEARCHATTR         28
#define T_MAXENTRIES         29
#define T_CACHECONN          30
#define T_ENABLETLS          31
#define T_LDIF_FORMAT        32

/* template tokens */
#define T_TEMPLATE           40
/* T_NAME already defined in per-server tokens */
#define T_OBJECTCLASS        41

/* filter tokens */
#define T_FILTER             42
/* T_NAME already defined in per-server tokens */
#define T_LDAPFILTER         43
#define T_SERVERNAME         44

#define T_DATA               50

/* bitwise flags used in keywordlist.flags */
#define NEEDS_CLOSE   1
#define NEEDS_DATA    2

#define BINDTYPE_SIMPLE        0
#define BINDTYPE_KERBEROS      1

#define MAX_ENTITY_LEN        64   /* not using XML attributes anyway */
#define MAX_DATA_LEN         128
#define DEFAULT_MAXENTRIES   200
#define DEFAULT_SEARCHATTR   "cn"
#define DEFAULT_BINDTYPE     BINDTYPE_SIMPLE
#define DEFAULT_LDIFFORMAT   LDIF_UMICH
#define DEFAULT_CACHECONN      1
#define DEFAULT_ENABLETLS      0

enum searchtype {
     ST_SEARCH,
     ST_FILTER
};


/* this holds all configuration data */
struct gq_config {
     /* persistent */
     struct ldapserver *ldapservers;
     GList *templates;
     GList *filters;
     int search_argument;
     int ldifformat;
     int confirm_mod; /* not used yet */
     int showdn;
     int showoc;
     int sort_search;
     int sort_browse;
     int show_rdn_only;
     char schemaserver[64];
};

struct keywordlist {
     char attribute[64];
     int token;
     int flags;
};

enum parselevel {
     TOP, IN_TAG, END
};

enum entitytype {
     IGNORE, OPEN, CLOSE
};

struct configfile {
     char *rcfile;
     int p;
     int line;
     enum parselevel status;
     char cur_string[128];
     int cur_token;
     int cur_token_flags;
     enum entitytype cur_entity_type;
     int stack[16];
     int sp;

     int err_context;

     struct ldapserver *cur_ldapserver;
     struct gq_template *cur_template;
     struct gq_filter *cur_filter;
};


/* handy for writing config file */
struct writeconfig {
     FILE *outfile;
     int indent;
};


struct ldapserver *new_ldapserver(void);
struct gq_template *new_template(void);
struct gq_filter *new_filter(void);
void delete_ldapserver(struct ldapserver *dserver);
char *homedir(void);
void config_id_string(struct configfile *f);
void config_get_token(struct configfile *f);
void config_skip_whitespace(struct configfile *f);
int config_get_bool(struct configfile *f);
void init_ldapserver(struct ldapserver *server);
char *filename_config(int context);
void load_config(void);
void config_write(struct writeconfig *wc, char *string);
void config_write_bool(struct writeconfig *wc, int value, char *entity);
void config_write_int(struct writeconfig *wc, int value, char *entity);
void config_write_string(struct writeconfig *wc, char *value, char *entity);
void config_write_string_ne(struct writeconfig *wc, char *value, char *entity);
void save_config(void);
void init_config(void);
