/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdlib.h>


#ifdef DEBUG

#define MALLOC(size, msg)         gq_malloc(size, msg)
#define FREE(mem, msg)            gq_free(mem, msg)

#else

#define MALLOC(size, msg)         malloc(size)
#define FREE(mem, msg)            free(mem)

#endif


void *gq_malloc(size_t size, char *msg);
void gq_free(void *mem, char *msg);
void report_num_mallocs(void);
void dump_ldapservers(void);

