/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_int.c,v 1.3 2003/11/02 07:20:43 stamfest Exp $ */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <config.h>

#include "dt_int.h"

#include "common.h"
#include "util.h"
#include "errorchain.h"
#include "input.h"
#include "tinput.h"
#include "browse.h"
#include "encode.h"
#include "ldif.h" /* for b64_decode */
#include "syntax.h"
#include "dtutil.h"
#include "utf8-compat.h"


static dt_int_handler dt_int_handler_vtab = {
     {
	  "Integer", 
	  TRUE,
	  TRUE,

	  dt_int_get_widget,
	  dt_int_get_data,
	  dt_int_set_data,
	  bervalLDAPMod
     },
#if GTK_MAJOR < 2
     decode_utf8, /* encode method */
     encode_utf8, /* decode method */
#else
     /* gtk2 uses UTF-8 natively! Yipieeh */
     NULL,
     NULL,
#endif
};

display_type_handler *dt_int_get_handler() {
     return (display_type_handler *) &dt_int_handler_vtab;
}

static void dt_int_verify(GtkWidget *entry)
{
     char *txt = gtk_editable_get_chars(GTK_EDITABLE(entry), 0, -1);
     gunichar c = 0;
     
     
     if (txt) {
	  char *t;
	  GString *s	= g_string_sized_new(strlen(txt));
	  int nope	= 0;

	  /* strip leading whitespace */
	  for(t = txt, c = g_utf8_get_char(t) ; 
	      g_unichar_isspace(c) ;
	      t = g_utf8_next_char(t), c = g_utf8_get_char(t)) {
	  }	  

	  /* one leading minus is OK */
	  if (c == g_utf8_get_char("-")) {
	       g_string_append_unichar(s, c);
	       t = g_utf8_next_char(t);
	       c = g_utf8_get_char(t);
	  }

	  /* allow only digits, no leading zeroes */
	  for(c = g_utf8_get_char(t) ; 
	      c ;
	      t = g_utf8_next_char(t), c = g_utf8_get_char(t)) {
	       if (g_unichar_isdigit(c)) {
		    g_string_append_unichar(s, c);
	       } else {
		    nope = 1;
	       }
	  }
	  g_free(txt);

	  txt = g_strcompress(s->str); /* one-byte chars only */
	  if (strcmp(txt, "0") != 0) {
	       for(t = txt ; *t == '0' ; t++) nope = 1;
	       if (*t == 0 && txt != t) t--; /* must have zeros-only string */
	  }

	  if (nope) {
	       gtk_entry_set_text(GTK_ENTRY(entry), t);
	  }

	  g_string_free(s, TRUE);
     }
     return;
}

GtkWidget *dt_int_get_widget(int error_context,
			     struct formfill *form, GByteArray *data,
			     GtkSignalFunc *activatefunc,
			     gpointer funcdata) 
{
    GtkWidget *hbox, *inputbox, *label;

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox);
    
    inputbox = gtk_entry_new();
    gtk_widget_show(inputbox);
    if(activatefunc)
	gtk_signal_connect_object(GTK_OBJECT(inputbox), "activate",
				  GTK_SIGNAL_FUNC(activatefunc), 
				  (gpointer) funcdata);

    gtk_signal_connect(GTK_OBJECT(inputbox), "changed",
		       GTK_SIGNAL_FUNC(dt_int_verify), 
		       (gpointer) NULL);

    gtk_box_pack_start(GTK_BOX(hbox), inputbox, TRUE, TRUE, 0);
    
    label = gtk_label_new(_("(int)"));
    gtk_widget_show(label);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    gtk_object_set_data(GTK_OBJECT(hbox), "inputbox", inputbox);

    dt_int_set_data(form, data, hbox);

    return hbox;
}

GByteArray *dt_int_get_data(struct formfill *form, GtkWidget *widget) 
{
    return editable_get_text(GTK_EDITABLE(dt_int_retrieve_inputbox(widget)));
}

void dt_int_set_data(struct formfill *form, GByteArray *data,
		       GtkWidget *widget) 
{
     editable_set_text(GTK_EDITABLE(dt_int_retrieve_inputbox(widget)),
		       data,
		       DT_INT(form->dt_handler)->encode,
		       DT_INT(form->dt_handler)->decode);
}

GtkWidget *dt_int_retrieve_inputbox(GtkWidget *hbox)
{
     return gtk_object_get_data(GTK_OBJECT(hbox), "inputbox");
}

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
