/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 by Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: utf8-compat.h,v 1.5 2003/10/24 19:10:25 stamfest Exp $ */

#ifndef GQ_UTF8_COMPAT_H_INCLUDED
#define GQ_UTF8_COMPAT_H_INCLUDED

#include "config.h" 
#include <glib.h>
#include <gtk/gtk.h>

#ifndef HAVE_GUNICHAR
    typedef char gunichar;
#   define g_utf8_get_char(p)  (*(p))
#   define g_utf8_next_char(p) (((char*)(p))+1)
#   define g_strcompress(x) g_strdup(x)
#else
#   include <glib/gunicode.h>
#endif

#ifndef HAVE_G_UNICHAR_ISSPACE
#   include <ctype.h>
#   define g_unichar_isspace isspace
#   define g_unichar_isdigit(c) isdigit(c)
#endif

#ifndef HAVE_G_UTF8_STRCHR
#   define g_utf8_strchr(haystack,len,needle) strchr((haystack),(needle))
#endif

#ifndef HAVE_G_STRING_APPEND_UNICHAR
#   define g_string_append_unichar(s,c) g_string_append_c((s),(c))
#endif

#ifndef HAVE_G_STRING_NEW_LEN
#   define g_string_new_len(s,l) g_string_assign(g_string_sized_new(l), (s))
#endif

#endif

/* 
   Local Variables:
   c-basic-offset: 4
   End:
 */
