#include "gql++/mod-result-set.h"

namespace GQL
{

ModResultSet::ModResultSet(int cols, int rows = 0) : ResultSet(0), rows_(rows)
{
  cols_ = cols;
  rowno_ = -1;
}

ModResultSet::~ModResultSet()
{
  for (vector<string **>::size_type i = 0; i < rows_.size(); i++)
  {
    for (int j = 0; j < cols_; j++)
      delete rows_[i][j];
    delete rows_[i];
  }
}

bool ModResultSet::next() throw(SQLException)
{
  if ((int)rows_.size() > rowno_ + 1)
  {
    rowno_++;
    return(true);
  }
  return(false);
}

void ModResultSet::get(int i, SQLObject *obj) const throw(SQLException)
{
  if (i < 0 || i >= cols_)
    throw SQLException("Attempt to access invalid field");

  if (rows_[rowno_][i] == 0)
    obj->set_null();
  else
    obj->from_string(*rows_[rowno_][i]);
}

void ModResultSet::append(const string **tuple)
{
  string **new_tuple = new string *[cols_];
  
  for (int i = 0; i < cols_; i++)
    new_tuple[i] = tuple[i] ? new string(*tuple[i]) : 0;

  rows_.push_back(new_tuple);
}

}
