/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_RESULTSET_H)
#define __INC_RESULTSET_H

#include "gql++/warnable.h"
#include "gql++/object.h"

namespace GQL
{

class Connection;
class ResultSetMetaData;

class ResultSet : public Warnable
{
  public:
    ResultSet(Connection *conn) : conn_(conn) { }
    virtual ~ResultSet();

    virtual bool next() throw(SQLException)= 0;
    
    virtual void get(int i, SQLObject *obj) const throw(SQLException) = 0;
    virtual ResultSetMetaData *get_meta_data() = 0;

    const Connection *get_connection() const { return(conn_); }
    Connection *get_connection() { return(conn_); }
    
    // Signals
    SigC::Signal0<void> destroy;
  private:
    Connection *conn_;
};

}


#endif
