/* Generated by xcc-0.6.0 */

#line 4 "grace.xcc"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "defines.h"
#include "files.h"
#include "utils.h"
#include "dicts.h"
#include "core_utils.h"
#include "protos.h"

#include "xstrings.h"

typedef struct {
    Grace *grace;
    int ncol;
    int nrow;
    Quark *ss;
} ParserData;

typedef struct _Page {
    int width;
    int height;
    int bgfill;
    int bgcolor;
} Page;

Page *page_new(void)
{
    Page *retval;
    
    retval = xmalloc(sizeof(Page));
    if (retval) {
        memset(retval, 0, sizeof(Page));
        retval->bgfill = TRUE;
    }
    
    return retval;
}

Colordef *colordef_new(void)
{
    Colordef *retval;
    retval = xmalloc(sizeof(Colordef));
    retval->id = -1;
    retval->cname = NULL;
    return retval;
}

void colordef_free(Colordef *cd)
{
    if (cd) {
        xfree(cd->cname);
        xfree(cd);
    }
}

Fontdef *fontdef_new()
{
    Fontdef *retval;
    retval = xmalloc(sizeof(Fontdef));
    retval->id = -1;
    retval->fontname = NULL;
    retval->fallback = NULL;
    return retval;
}

void fontdef_free(Fontdef *fd)
{
    if (fd) {
        xfree(fd->fontname);
        xfree(fd->fallback);
        xfree(fd);
    }
}

typedef struct {
    int font;
    int color;
    double size;
} FaceSpec;

FaceSpec *facespec_new()
{
    FaceSpec *fs;
    fs = xmalloc(sizeof(FaceSpec));
    if (fs) {
        memset(fs, 0, sizeof(FaceSpec));
    }
    return fs;
}

void facespec_free(FaceSpec *fs)
{
    if (fs) {
        xfree(fs);
    }
}

typedef struct {
    GraphType type;
    int stacked;
    double bargap;
} PresentationSpec;


PresentationSpec *presentationspec_new()
{
    PresentationSpec *ps;
    ps = xmalloc(sizeof(PresentationSpec));
    if (ps) {
        memset(ps, 0, sizeof(PresentationSpec));
    }
    return ps;
}

void presentationspec_free(PresentationSpec *ps)
{
    if (ps) {
        xfree(ps);
    }
}

view *view_new()
{
    view *v;
    v = xmalloc(sizeof(view));
    if (v) {
        memset(v, 0, sizeof(view));
    }
    return v;
}

typedef struct {
    int type;
    double min;
    double max;
    int invert;
} Scale;

Scale *scale_new()
{
    Scale *s;
    s = xmalloc(sizeof(Scale));
    if (s) {
        memset(s, 0, sizeof(Scale));
    }
    return s;
}

typedef struct {
    int type;
    APoint ap;
} Location;

Location *location_new()
{
    Location *retval;
    retval = xmalloc(sizeof(Location));
    if (retval) {
        memset(retval, 0, sizeof(Location));
    }
    return retval;
}

typedef struct {
    FPoint anchor;
    int just;
    VPoint offset;
    Line line;
    Pen fillpen;
} Legframe;

Legframe *legframe_new()
{
    Legframe *lf;
    lf = xmalloc(sizeof(Legframe));
    if (lf) {
        memset(lf, 0, sizeof(Legframe));
    }
    return lf;
}

typedef struct {
    int active;
    double x;
    double y;
} Fixedpoint;

Fixedpoint *fixedpoint_new()
{
    Fixedpoint *fp;
    fp = xmalloc(sizeof(Fixedpoint));
    if (fp) {
        memset(fp, 0, sizeof(Fixedpoint));
    }
    return fp;
}

GLocator *glocator_new()
{
    GLocator *retval;
    retval = xmalloc(sizeof(GLocator));
    if (retval) {
        memset(retval, 0, sizeof(GLocator));
    }
    return retval;
}

TextProps *textprops_new(void)
{
    TextProps *retval;
    retval = xmalloc(sizeof(TextProps));
    if (retval) {
        memset(retval, 0, sizeof(TextProps));
    }
    return retval;
}

typedef struct {
    Line line;
} ABar;

ABar *axisbar_new()
{
    ABar *retval;
    retval = xmalloc(sizeof(ABar));
    if (retval) {
        memset(retval, 0, sizeof(ABar));
    }
    return retval;
}

typedef struct {
    int active;
    int sideplacement;
    char *transform;
    char *prepend;
    char *append;
    VPoint offset;
    
    TextProps tprops;
    
    int skip;
    int stagger;
    int autostart;
    double start;
    int autostop;
    double stop;
    Format format;
} TLabels;

TLabels *tlabels_new()
{
    TLabels *retval;
    retval = xmalloc(sizeof(TLabels));
    if (retval) {
        memset(retval, 0, sizeof(TLabels));
    }
    return retval;
}

void tlabels_free(TLabels *tl)
{
    if (tl) {
        xfree(tl->transform);
        xfree(tl->prepend);
        xfree(tl->append);
        xfree(tl);
    }
}

typedef struct {
    int type;                   /* type of user ticks */
    int nticks;                 /* total number of ticks */
    tickloc tloc[MAX_TICKS];    /* locations of ticks */
} UTicks;

UTicks *uticks_new()
{
    UTicks *retval;
    retval = xmalloc(sizeof(UTicks));
    if (retval) {
        memset(retval, 0, sizeof(UTicks));
    }
    return retval;
}

tickloc *tick_new()
{
    tickloc *retval;
    retval = xmalloc(sizeof(tickloc));
    if (retval) {
        memset(retval, 0, sizeof(tickloc));
    }
    return retval;
}

int utick_add(UTicks *uticks, tickloc *tick)
{
    if (uticks && uticks->nticks < MAX_TICKS) {
        uticks->tloc[uticks->nticks++] = *tick;
        return RETURN_SUCCESS;
    } else {
        return RETURN_FAILURE;
    }
}

tickprops *tickprops_new()
{
    tickprops *retval;
    retval = xmalloc(sizeof(tickprops));
    if (retval) {
        memset(retval, 0, sizeof(tickprops));
    }
    return retval;
}

gridprops *gridprops_new()
{
    gridprops *retval;
    retval = xmalloc(sizeof(gridprops));
    if (retval) {
        memset(retval, 0, sizeof(gridprops));
    }
    return retval;
}

typedef struct {
    int autov;
    double value;
} Autoval;

Arrow *arrow_new(void)
{
    Arrow *retval;
    retval = xmalloc(sizeof(Arrow));
    if (retval) {
        memset(retval, 0, sizeof(Arrow));
    }
    return retval;
}

typedef struct {
    int decor;
    double offset;
    Line line;
    Pen fillpen;
} TextFrame;

TextFrame *textframe_new(void)
{
    TextFrame *retval;
    retval = xmalloc(sizeof(TextFrame));
    if (retval) {
        memset(retval, 0, sizeof(TextFrame));
    }
    return retval;
}

typedef struct {
    int active;
    Arrow arrow;
} TextPointer;

TextPointer *textpointer_new(void)
{
    TextPointer *retval;
    retval = xmalloc(sizeof(TextPointer));
    if (retval) {
        memset(retval, 0, sizeof(TextPointer));
    }
    return retval;
}

AValue *avalue_new(void)
{
    AValue *retval;
    retval = xmalloc(sizeof(AValue));
    if (retval) {
        memset(retval, 0, sizeof(AValue));
    }
    return retval;
}

void avalue_free(AValue *av)
{
    if (av) {
        xfree(av->prestr);
        xfree(av->appstr);
        xfree(av);
    }
}

char *utf2iso(const char *s)
{
    char *retval;
    char *p1, *p2;
    
    if (!s) {
        return NULL;
    }
    
    retval = xmalloc(strlen(s) + 1);
    if (!retval) {
        return NULL;
    }
    
    p1 = (char *) s;
    p2 = retval;
    
    while (*p1) {
        if (*p1 & 0x80) {
            /* last 2 bits */
            *p2 = (*p1 & 0x03) << 6; p1++;
            /* last 6 bits of the next byte */
            *p2 += *p1 & 0x3F;
        } else {
            *p2 = *p1;
        }
        p1++; p2++;
    }
    
    *(p2) = '\0';
    
    return retval;
}

    
#line 435 "xml_in.c"
/*
 * XCC - XML Compiler-Compiler
 * 
 * Copyright (c) 2000-2006 Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* As a special exception, when this file is SOLELY used to provide the
   functionality as needed by an XCC-generated output at run-time (either
   copied by XCC into the output file or otherwise linked to), you may use
   this file without further restrictions, provided that its contents are
   preserved verbatim. */

/* Public stuff */

#ifndef __XCC_H_
#define __XCC_H_

#include <stdio.h>
#include <string.h>
#include <expat.h>

#define XCC_VERSION_MAJOR   0
#define XCC_VERSION_MINOR   6
#define XCC_VERSION_NANO    0

#define XCC_RETURN_SUCCESS   0
#define XCC_RETURN_FAILURE   1

#define XCC_NS_SEPARATOR    '|'

#define XCC_STACK_CHUNK_SIZE  16

#define XCC_BUFFSIZE        8192

#define XCC_DEFAULT_PREFIX    "xcc"


/* error codes */
#define XCC_ECNTX   1
#define XCC_EATTR   2
#define XCC_EELEM   3
#define XCC_EEMIN   4
#define XCC_EEMAX   5
#define XCC_EAREQ   6
#define XCC_EINTR   7

/* ------------------- */

#define xcc_realloc realloc

typedef void (*XCC_stack_data_free)(void *data); 

typedef int (*XCCExceptionHandler)(int ierrno,
    const char *entity, const char *context, void *udata);

typedef struct _XCCStack {
    unsigned int size;
    unsigned int depth;
    void **entries;
    XCC_stack_data_free data_free;
} XCCStack;

typedef struct _XCCElementEntry {
    int key;
    char *name;
} XCCElementEntry;

typedef struct _XCCParserData {
    int error;
    
    char *cbuffer;
    int cbufsize;
    int cbuflen;
    
    XCCStack *nodes;
    void *root;
    
    void *udata;
    
    XCCExceptionHandler exception_handler;

    XML_Parser parser;

} XCCParserData;

typedef struct {
    int          allowed;
    unsigned int minOccurs;
    unsigned int maxOccurs;
    unsigned int occurred;
} XCCOccurrence;

typedef struct _XCCNode {
    char *name;
    int  id;
    void *data;
    XCCOccurrence *occurrence;
} XCCNode;

void xcc_get_version_numbers(int *major, int *minor, int *nano);

void *xcc_malloc(size_t size);
void xcc_free(void *p);

void xcc_error(const char *fmt, ...);

int xcc_stack_increment(XCCStack *xs, const void *data);
int xcc_stack_decrement(XCCStack *xs);
int xcc_stack_get_last(const XCCStack *xs, void **data);
int xcc_stack_depth(const XCCStack *xs);

XCCNode *xcc_node_new(void);

char *xcc_get_local(const char *name, const char *ns_uri, int *skip);

char **xcc_augment_attributes(const char **attr,
    unsigned int n2, char **attr2);

void *xcc_get_root(const XCCParserData *pdata);
int xcc_get_linenum(const XCCParserData *pdata);

int xcc_run(FILE *fp, void **root, void *udata,
              XML_StartElementHandler start_element_handler,
              XML_EndElementHandler end_element_handler,
              XCCExceptionHandler exception_handler);

#endif /* __XCC_H_ */
/*
 * XCC - XML Compiler-Compiler
 * 
 * Copyright (c) 2000-2005 Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* As a special exception, when this file is SOLELY used to provide the
   functionality as needed by an XCC-generated output at run-time (either
   copied by XCC into the output file or otherwise linked to), you may use
   this file without further restrictions, provided that its contents are
   preserved verbatim. */

#include <string.h>
#include <stdarg.h>


void xcc_get_version_numbers(int *major, int *minor, int *nano)
{
    *major = XCC_VERSION_MAJOR;
    *minor = XCC_VERSION_MINOR;
    *nano  = XCC_VERSION_NANO;
}

void xcc_error(const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    fputs("xcc: ", stderr);
    vfprintf(stderr, fmt, ap);
    fputc('\n', stderr);
    va_end(ap);
}

void xcc_free(void *p)
{
    if (p) {
        free(p);
    }
}

void *xcc_malloc(size_t size)
{
    if (size == 0) {
        return NULL;
    } else {
        void *p = malloc(size);
        if (p) {
            return p;
        } else {
            xcc_error("memory exhausted");
            abort();
        }
    }
}

char *xcc_strdup(const char *s)
{
    char *ret;
    if (s) {
        ret = xcc_malloc(strlen(s) + 1);
        if (ret) {
            strcpy(ret, s);
        }
    } else {
        ret = NULL;
    }
    return ret;
}

XCCStack *xcc_stack_new(XCC_stack_data_free data_free)
{
    XCCStack *xs = xcc_malloc(sizeof(XCCStack));
    
    if (xs) {
        xs->size      = 0;
        xs->depth     = 0;
        xs->entries   = NULL;
        xs->data_free = data_free;
    }
    
    return xs;
}

void xcc_stack_free(XCCStack *xs)
{
    if (xs) {
        while (xs->depth) {
            void *e;
            xs->depth--;
            e = xs->entries[xs->depth];
            if (e && xs->data_free) {
                xs->data_free(e);
            }
        }
        xcc_free(xs->entries);
        
        xcc_free(xs);
    }
}

int xcc_stack_increment(XCCStack *xs, const void *data)
{
    if (xs->size <= xs->depth) {
        unsigned int new_size = xs->size + XCC_STACK_CHUNK_SIZE;
        void **p = xcc_realloc(xs->entries, new_size*sizeof(void *));
        if (!p) {
            return XCC_RETURN_FAILURE;
        } else {
            xs->entries = p;
            xs->size = new_size;
        }
    }
    xs->entries[xs->depth] = (void *) data;
    xs->depth++;
    
    return XCC_RETURN_SUCCESS;
}

int xcc_stack_decrement(XCCStack *xs)
{
    if (xs->depth < 1) {
        return XCC_RETURN_FAILURE;
    } else {
        void *e;
        xs->depth--;
        e = xs->entries[xs->depth];
        if (e && xs->data_free) {
            xs->data_free(e);
        }
        
        return XCC_RETURN_SUCCESS;
    }
}

int xcc_stack_get_first(const XCCStack *xs, void **data)
{
    if (xs && xs->depth > 0) {
        *data = xs->entries[0];
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}

int xcc_stack_get_last(const XCCStack *xs, void **data)
{
    if (xs && xs->depth > 0) {
        *data = xs->entries[xs->depth - 1];
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}

int xcc_stack_get_data(const XCCStack *xs, unsigned int ind, void **data)
{
    if (xs && xs->depth > ind) {
        *data = xs->entries[ind];
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}

int xcc_stack_depth(const XCCStack *xs)
{
    return xs->depth;
}


XCCNode *xcc_node_new(void)
{
    XCCNode *n;
    n = xcc_malloc(sizeof(XCCNode));
    if (n) {
        memset(n, 0, sizeof(XCCNode));
    }
    return n;
}

void xcc_node_free(XCCNode *n)
{
    if (n) {
        xcc_free(n->name);
        xcc_free(n->occurrence);
        xcc_free(n);
    }
}

char *xcc_get_local(const char *name, const char *ns_uri, int *skip)
{
    char *sep, *local_name;
    if (ns_uri && (sep = strchr(name, XCC_NS_SEPARATOR))) {
        char *buf = strstr(name, ns_uri);
        if (buf != name) {
            *skip = 1;
        }
        local_name = xcc_strdup(sep + 1);
    } else {
        local_name = xcc_strdup(name);
    }
    
    return local_name;
}

/* NB: attr1 is NULL-terminated, attr2 is NOT */
char **xcc_augment_attributes(const char **attr,
    unsigned int n2, char **attr2)
{
    unsigned int nattr, i2;
    int nextra = 2*n2;
    
    if (!n2) {
        return (char **) attr;
    }

    for (nattr = 0; attr[nattr]; nattr += 2) {
        const char *aname = attr[nattr];
        for (i2 = 0; i2 < 2*n2; i2 += 2) {
            char *aname2 = attr2[i2];
            if (aname2 && !strcmp(aname, aname2)) {
                attr2[i2] = NULL;
                nextra -= 2;
            }
        } 
    }
    
    if (nextra <= 0) {
        /* actually, it CAN'T be negative... */
        return (char **) attr;
    } else {
        unsigned nnew = nattr + nextra;
        char **attr_new = xcc_malloc((nnew + 1)*sizeof(char *));
        if (attr_new) {
            unsigned int inew = nattr;
            memcpy(attr_new, attr, nattr*sizeof(char *));
            for (i2 = 0; i2 < 2*n2; i2 += 2) {
                if (attr2[i2]) {
                    attr_new[inew] = attr2[i2];
                    attr_new[inew + 1] = attr2[i2 + 1];
                    inew += 2;
                }
            }
            attr_new[nnew] = NULL;
        }
        
        return attr_new;
    }
}

void *xcc_get_root(const XCCParserData *pdata)
{
    void *p;
    if (xcc_stack_get_data(pdata->nodes, 0, &p) != XCC_RETURN_SUCCESS) {
        return NULL;
    } else {
        XCCNode *node = p;
        return node->data;
    }
}

int xcc_get_linenum(const XCCParserData *pdata)
{
    if (pdata && pdata->parser) {
        return XML_GetCurrentLineNumber(pdata->parser);
    } else {
        return -1;
    }
}

static void xcc_char_data_handler(void *data, const char *s, int len)
{
    XCCParserData *pdata = (XCCParserData *) data;
    int new_len;

    if (pdata->error) {
        return;
    }
    
    new_len = pdata->cbuflen + len;
    
    if (new_len >= pdata->cbufsize) {
        pdata->cbuffer = xcc_realloc(pdata->cbuffer, (new_len + 1));
        pdata->cbufsize = new_len + 1;
    }
    
    memcpy(pdata->cbuffer + pdata->cbuflen, s, len);
    pdata->cbuffer[new_len] = '\0';
    pdata->cbuflen = new_len;
}


static int xcc_exception_handler(int ierrno,
    const char *entity, const char *context, void *udata)
{
    int handled = 0;
    
    switch (ierrno) {
    case XCC_ECNTX:
        xcc_error("unexpected \"%s\" in the context of \"%s\"", entity, context ? context:"xml");
        break;
    case XCC_EATTR:
        xcc_error("unknown attribute \"%s\" of element \"%s\"", entity, context);
        break;
    case XCC_EELEM:
        xcc_error("unknown element \"%s\" appeared in context of \"%s\"", entity, context);
        break;
    case XCC_EEMIN:
        xcc_error("underrun of occurrences of \"%s\" in the context of \"%s\"", entity, context);
        break;
    case XCC_EEMAX:
        xcc_error("overrun of occurrences of \"%s\" in the context of \"%s\"", entity, context);
        break;
    case XCC_EAREQ:
        xcc_error("required attribute \"%s\" of element \"%s\" is missing", entity, context);
        break;
    case XCC_EINTR:
        xcc_error("internal error");
        break;
    }
    
    return handled;
}

int xcc_run(FILE *fp, void **root, void *udata,
              XML_StartElementHandler start_element_handler,
              XML_EndElementHandler end_element_handler,
              XCCExceptionHandler exception_handler)
{
    XML_Parser xp;
    XCCParserData pdata;
    char Buff[XCC_BUFFSIZE];
    
    xp = XML_ParserCreateNS(NULL, XCC_NS_SEPARATOR);
    if (!xp) {
        *root = NULL;
        xcc_error("Couldn't allocate memory for parser");
        return XCC_RETURN_FAILURE;
    }

    /* Set XML_Parser's user data */
    pdata.error    = 0;
    
    pdata.cbuffer  = NULL;
    pdata.cbufsize = 0;
    pdata.cbuflen  = 0;
 
    pdata.nodes    = xcc_stack_new((XCC_stack_data_free) xcc_node_free);
    pdata.root     = NULL;
    
    pdata.udata    = udata;
    pdata.parser   = xp;

    if (exception_handler) {
        pdata.exception_handler = exception_handler;
    } else {
        pdata.exception_handler = xcc_exception_handler;
    }
    
    XML_SetUserData(xp, (void *) &pdata);

    XML_SetElementHandler(xp, start_element_handler, end_element_handler);

    /* Set the char data handler */
    XML_SetCharacterDataHandler(xp, xcc_char_data_handler);

    while (!pdata.error) {
        int done;
        int len;

        len = fread(Buff, 1, XCC_BUFFSIZE, fp);
        if (ferror(fp)) {
            xcc_error("Read error");
            pdata.error = 1;
            break;
        }
        done = feof(fp);

        if (!XML_Parse(xp, Buff, len, done)) {
            xcc_error("parse error at line %d:\n\t%s",
                XML_GetCurrentLineNumber(xp),
                XML_ErrorString(XML_GetErrorCode(xp)));
            pdata.error = 1;
            break;
        }

        if (done) {
            break;
        }
    }
    
    /* Free allocated storage */
    XML_ParserFree(xp);
    xcc_stack_free(pdata.nodes);
    xcc_free(pdata.cbuffer);
    
    *root = pdata.root;
    if (!pdata.error) {
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}
typedef union {
    int ival;
    double dval;
    char * sval;
    int bval;
    RGB * rgb;
    FormatType ftype;
    int fontid;
    VVector * offset;
    FPoint * fpoint;
    int axislayout;
    int inoutplacement;
    int uticktype;
    int ticktype;
    int loctype;
    SetType settype;
    int fillrule;
    int regiontype;
    double dateordval;
    Autoval * autodateordval;
} XCCAType;

typedef union {
    Quark * project;
    Page * page;
    char ** string;
    Pen * pen;
    Line * line;
    void * dummy;
    Colordef * colordef;
    Fontdef * fontdef;
    FaceSpec * facespec;
    Quark * ssd;
    Quark * graph;
    PresentationSpec * presentationspec;
    view * view;
    Scale * scale;
    double * dptr;
    legend * legend;
    Legframe * legframe;
    GLocator * glocator;
    Fixedpoint * fixedpoint;
    Format * format;
    Quark * frame;
    TextProps * textprops;
    Quark * axisgrid;
    Quark * axis;
    ABar * axisbar;
    gridprops * gridprops;
    tickprops * tickprops;
    TLabels * tlabels;
    UTicks * uticks;
    tickloc * tick;
    Quark * object;
    Quark * atext;
    Location * location;
    DOLineData * do_line_data;
    DOBoxData * do_box_data;
    DOArcData * do_arc_data;
    TextFrame * textframe;
    TextPointer * textpointer;
    Arrow * arrow;
    Quark * set;
    Symbol * symbol;
    SetLine * setline;
    AValue * annotation;
    Errbar * errorbar;
    BarLine * barline;
    RiserLine * riserline;
    Dataset * dataset;
    WPoint * wpoint;
    Quark * region;
    ss_column * scolumn;
    ss_column * dcolumn;
    char ** cell;
    void * unicast;
} XCCEType;

static XCCElementEntry XCCElementTab[] = {
    {1, EStrGrace},
    {2, EStrDefinitions},
    {3, EStrColormap},
    {4, EStrFontmap},
    {5, EStrScales},
    {6, EStrColorDef},
    {7, EStrFontDef},
    {8, EStrPage},
    {9, EStrDescription},
    {10, EStrDataFormats},
    {11, EStrFaceSpec},
    {12, EStrDates},
    {13, EStrWorld},
    {14, EStrText},
    {15, EStrFillSpec},
    {16, EStrFrame},
    {17, EStrGraph},
    {18, EStrPresentationSpec},
    {19, EStrViewport},
    {20, EStrXscale},
    {21, EStrYscale},
    {22, EStrZscale},
    {23, EStrLegend},
    {24, EStrLegframe},
    {25, EStrLineSpec},
    {26, EStrLocator},
    {27, EStrFixedpoint},
    {28, EStrXformat},
    {29, EStrYformat},
    {30, EStrAGrid},
    {31, EStrMajorGridlines},
    {32, EStrMinorGridlines},
    {33, EStrAxisbar},
    {34, EStrUserticks},
    {35, EStrMajorTickmarks},
    {36, EStrMinorTickmarks},
    {37, EStrTicklabels},
    {38, EStrTick},
    {39, EStrAxis},
    {40, EStrFormat},
    {41, EStrObject},
    {42, EStrLocation},
    {43, EStrBoxData},
    {44, EStrArcData},
    {45, EStrLineData},
    {46, EStrAText},
    {47, EStrTextFrame},
    {48, EStrPointer},
    {49, EStrArrow},
    {50, EStrSSD},
    {51, EStrScolumn},
    {52, EStrDcolumn},
    {53, EStrCell},
    {54, EStrSet},
    {55, EStrSymbol},
    {56, EStrLine},
    {57, EStrAnnotation},
    {58, EStrTextProperties},
    {59, EStrErrorbar},
    {60, EStrBarline},
    {61, EStrRiserline},
    {62, EStrLegendEntry},
    {63, EStrDataset},
    {64, EStrRow},
    {65, EStrRegion}
};

static int get_element_id_by_name(const char *name)
{
    int i;
    for (i = 0; i < 65; i++) {
        if (!strcmp(XCCElementTab[i].name, name)) {
            return XCCElementTab[i].key;
        }
    }
    return -1;
}

static char *get_element_name_by_id(int id)
{
    int i;
    for (i = 0; i < 65; i++) {
        if (XCCElementTab[i].key == id) {
            return XCCElementTab[i].name;
        }
    }
    return NULL;
}

static XCCOccurrence *init_occurrence(int element_id)
{
    XCCOccurrence *occurrence;
    switch (element_id) {
    case 5:
    case 6:
    case 7:
    case 8:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 25:
    case 27:
    case 28:
    case 29:
    case 38:
    case 40:
    case 42:
    case 43:
    case 44:
    case 49:
    case 53:
    case 63:
    case 64:
        return NULL;
        break;
    }

    occurrence = xcc_malloc(65*sizeof(XCCOccurrence));
    if (occurrence) {
        memset(occurrence, 0, 65*sizeof(XCCOccurrence));
        switch (element_id) {
        case 1:
            occurrence[8].allowed = 1;
            occurrence[8].minOccurs = 1;
            occurrence[8].maxOccurs = 1;
            occurrence[1].allowed = 1;
            occurrence[1].minOccurs = 1;
            occurrence[1].maxOccurs = 1;
            occurrence[7].allowed = 1;
            occurrence[7].minOccurs = 1;
            occurrence[7].maxOccurs = 1;
            occurrence[9].allowed = 1;
            occurrence[9].minOccurs = 1;
            occurrence[9].maxOccurs = 1;
            occurrence[15].allowed = 1;
            occurrence[40].allowed = 1;
            occurrence[45].allowed = 1;
            break;
        case 2:
            occurrence[2].allowed = 1;
            occurrence[2].minOccurs = 1;
            occurrence[2].maxOccurs = 1;
            occurrence[3].allowed = 1;
            occurrence[3].minOccurs = 1;
            occurrence[3].maxOccurs = 1;
            occurrence[4].allowed = 1;
            occurrence[4].minOccurs = 1;
            occurrence[4].maxOccurs = 1;
            break;
        case 3:
            occurrence[5].allowed = 1;
            occurrence[5].minOccurs = 2;
            break;
        case 4:
            occurrence[6].allowed = 1;
            occurrence[6].minOccurs = 1;
            break;
        case 9:
            occurrence[13].allowed = 1;
            occurrence[13].minOccurs = 1;
            occurrence[13].maxOccurs = 1;
            break;
        case 10:
            occurrence[12].allowed = 1;
            occurrence[12].minOccurs = 1;
            occurrence[12].maxOccurs = 1;
            occurrence[11].allowed = 1;
            occurrence[11].minOccurs = 1;
            occurrence[11].maxOccurs = 1;
            break;
        case 16:
            occurrence[18].allowed = 1;
            occurrence[18].minOccurs = 1;
            occurrence[18].maxOccurs = 1;
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            occurrence[14].allowed = 1;
            occurrence[14].minOccurs = 1;
            occurrence[14].maxOccurs = 1;
            occurrence[22].allowed = 1;
            occurrence[22].minOccurs = 1;
            occurrence[22].maxOccurs = 1;
            occurrence[16].allowed = 1;
            occurrence[40].allowed = 1;
            occurrence[45].allowed = 1;
            break;
        case 17:
            occurrence[17].allowed = 1;
            occurrence[17].minOccurs = 1;
            occurrence[17].maxOccurs = 1;
            occurrence[19].allowed = 1;
            occurrence[19].minOccurs = 1;
            occurrence[19].maxOccurs = 1;
            occurrence[20].allowed = 1;
            occurrence[20].minOccurs = 1;
            occurrence[20].maxOccurs = 1;
            occurrence[21].allowed = 1;
            occurrence[21].minOccurs = 1;
            occurrence[21].maxOccurs = 1;
            occurrence[25].allowed = 1;
            occurrence[25].minOccurs = 1;
            occurrence[25].maxOccurs = 1;
            occurrence[49].allowed = 1;
            occurrence[29].allowed = 1;
            occurrence[40].allowed = 1;
            occurrence[45].allowed = 1;
            occurrence[64].allowed = 1;
            break;
        case 23:
            occurrence[10].allowed = 1;
            occurrence[10].minOccurs = 1;
            occurrence[10].maxOccurs = 1;
            occurrence[23].allowed = 1;
            occurrence[23].minOccurs = 1;
            occurrence[23].maxOccurs = 1;
            break;
        case 24:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            occurrence[14].allowed = 1;
            occurrence[14].minOccurs = 1;
            occurrence[14].maxOccurs = 1;
            break;
        case 26:
            occurrence[26].allowed = 1;
            occurrence[26].minOccurs = 1;
            occurrence[26].maxOccurs = 1;
            occurrence[27].allowed = 1;
            occurrence[27].minOccurs = 1;
            occurrence[27].maxOccurs = 1;
            occurrence[28].allowed = 1;
            occurrence[28].minOccurs = 1;
            occurrence[28].maxOccurs = 1;
            break;
        case 30:
            occurrence[30].allowed = 1;
            occurrence[30].minOccurs = 1;
            occurrence[30].maxOccurs = 1;
            occurrence[31].allowed = 1;
            occurrence[31].minOccurs = 1;
            occurrence[31].maxOccurs = 1;
            occurrence[33].allowed = 1;
            occurrence[33].minOccurs = 1;
            occurrence[33].maxOccurs = 1;
            occurrence[32].allowed = 1;
            occurrence[32].minOccurs = 1;
            occurrence[32].maxOccurs = 1;
            occurrence[34].allowed = 1;
            occurrence[34].minOccurs = 1;
            occurrence[34].maxOccurs = 1;
            occurrence[35].allowed = 1;
            occurrence[35].minOccurs = 1;
            occurrence[35].maxOccurs = 1;
            occurrence[36].allowed = 1;
            occurrence[36].minOccurs = 1;
            occurrence[36].maxOccurs = 1;
            occurrence[38].allowed = 1;
            break;
        case 31:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            break;
        case 32:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            break;
        case 33:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            break;
        case 34:
            occurrence[37].allowed = 1;
            break;
        case 35:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            break;
        case 36:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            break;
        case 37:
            occurrence[57].allowed = 1;
            occurrence[57].minOccurs = 1;
            occurrence[57].maxOccurs = 1;
            occurrence[39].allowed = 1;
            occurrence[39].minOccurs = 1;
            occurrence[39].maxOccurs = 1;
            break;
        case 39:
            occurrence[45].allowed = 1;
            occurrence[40].allowed = 1;
            break;
        case 41:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            occurrence[41].allowed = 1;
            occurrence[41].minOccurs = 1;
            occurrence[41].maxOccurs = 1;
            occurrence[14].allowed = 1;
            occurrence[14].minOccurs = 1;
            occurrence[14].maxOccurs = 1;
            occurrence[44].allowed = 1;
            occurrence[44].maxOccurs = 1;
            occurrence[42].allowed = 1;
            occurrence[42].maxOccurs = 1;
            occurrence[43].allowed = 1;
            occurrence[43].maxOccurs = 1;
            break;
        case 45:
            occurrence[48].allowed = 1;
            occurrence[48].minOccurs = 1;
            occurrence[48].maxOccurs = 1;
            break;
        case 46:
            occurrence[41].allowed = 1;
            occurrence[41].minOccurs = 1;
            occurrence[41].maxOccurs = 1;
            occurrence[57].allowed = 1;
            occurrence[57].minOccurs = 1;
            occurrence[57].maxOccurs = 1;
            occurrence[13].allowed = 1;
            occurrence[13].minOccurs = 1;
            occurrence[13].maxOccurs = 1;
            occurrence[46].allowed = 1;
            occurrence[46].minOccurs = 1;
            occurrence[46].maxOccurs = 1;
            occurrence[47].allowed = 1;
            occurrence[47].minOccurs = 1;
            occurrence[47].maxOccurs = 1;
            break;
        case 47:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            occurrence[14].allowed = 1;
            occurrence[14].minOccurs = 1;
            occurrence[14].maxOccurs = 1;
            break;
        case 48:
            occurrence[48].allowed = 1;
            occurrence[48].minOccurs = 1;
            occurrence[48].maxOccurs = 1;
            break;
        case 50:
            occurrence[51].allowed = 1;
            occurrence[50].allowed = 1;
            occurrence[53].allowed = 1;
            break;
        case 51:
            occurrence[52].allowed = 1;
            break;
        case 52:
            occurrence[52].allowed = 1;
            break;
        case 54:
            occurrence[62].allowed = 1;
            occurrence[62].minOccurs = 1;
            occurrence[62].maxOccurs = 1;
            occurrence[54].allowed = 1;
            occurrence[54].minOccurs = 1;
            occurrence[54].maxOccurs = 1;
            occurrence[55].allowed = 1;
            occurrence[55].minOccurs = 1;
            occurrence[55].maxOccurs = 1;
            occurrence[56].allowed = 1;
            occurrence[56].minOccurs = 1;
            occurrence[56].maxOccurs = 1;
            occurrence[58].allowed = 1;
            occurrence[58].minOccurs = 1;
            occurrence[58].maxOccurs = 1;
            occurrence[61].allowed = 1;
            occurrence[61].minOccurs = 1;
            occurrence[61].maxOccurs = 1;
            break;
        case 55:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            occurrence[14].allowed = 1;
            occurrence[14].minOccurs = 1;
            occurrence[14].maxOccurs = 1;
            break;
        case 56:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            occurrence[14].allowed = 1;
            occurrence[14].minOccurs = 1;
            occurrence[14].maxOccurs = 1;
            break;
        case 57:
            occurrence[57].allowed = 1;
            occurrence[57].minOccurs = 1;
            occurrence[57].maxOccurs = 1;
            occurrence[39].allowed = 1;
            occurrence[39].minOccurs = 1;
            occurrence[39].maxOccurs = 1;
            break;
        case 58:
            occurrence[10].allowed = 1;
            occurrence[10].minOccurs = 1;
            occurrence[10].maxOccurs = 1;
            break;
        case 59:
            occurrence[59].allowed = 1;
            occurrence[59].minOccurs = 1;
            occurrence[59].maxOccurs = 1;
            occurrence[60].allowed = 1;
            occurrence[60].minOccurs = 1;
            occurrence[60].maxOccurs = 1;
            break;
        case 60:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            break;
        case 61:
            occurrence[24].allowed = 1;
            occurrence[24].minOccurs = 1;
            occurrence[24].maxOccurs = 1;
            break;
        case 62:
            occurrence[13].allowed = 1;
            occurrence[13].minOccurs = 1;
            occurrence[13].maxOccurs = 1;
            break;
        case 65:
            occurrence[63].allowed = 1;
            occurrence[63].minOccurs = 2;
            break;
        }
    }
    return occurrence;
}

static void xgr_start_handler(void *data, const char *el, const char **attr_in)
{
    char **attr;
    XCCParserData *pdata = (XCCParserData *) data;
    XCCNode *pnode = NULL, *node;
    XCCEType element;
    int i, element_id = -1, parent_id = -1, skip = 0, askip;
    const char *avalue;
    char *aname, *el_local;
    unsigned int nattr_extra  = 0;
    char *attr_extra[16];
    XCCAType attribute;
    char *attribs_required[8];
    int nattribs_required = 0;
    if (pdata->error) {
        return;
    }

    memset(attribs_required, 0, 8*sizeof(char *));
    memset(attr_extra, 0, 16*sizeof(char *));

    pdata->cbuflen = 0;
    if (pdata->cbufsize) {
        pdata->cbuffer[0] = '\0';
    }

    element.unicast = NULL;

    el_local  = xcc_get_local(el, GRACE_NS_URI, &skip);
    if (skip) {
        goto e_switch;
    }

    if (xcc_stack_depth(pdata->nodes) == 0) {
        pnode = NULL;
        parent_id = 0;
    } else {
        void *p;
        xcc_stack_get_last(pdata->nodes, &p);
        pnode = p;
        parent_id = pnode->id;
    }
    if (parent_id < 0) {
        skip = 1;
        goto e_switch;
    }

    element_id = get_element_id_by_name(el_local);
    if (element_id < 0) {
        if (pdata->exception_handler(XCC_EELEM, el_local, pnode ? pnode->name:NULL, pdata->udata)) {
            skip = 1;
        } else {
            pdata->error = 1;
        }
        goto e_switch;
    }

    if (!pnode) {
        goto e_switch;
    }

    if (pnode->occurrence) {
        pnode->occurrence[element_id - 1].occurred++;
    }

    if (!pnode->occurrence || !pnode->occurrence[element_id - 1].allowed) {
        if (pdata->exception_handler(XCC_ECNTX, el_local, pnode ? pnode->name:NULL, pdata->udata)) {
            skip = 1;
        } else {
            pdata->error = 1;
        }
        goto e_switch;
    }

    if (pnode->occurrence[element_id - 1].maxOccurs &&
        pnode->occurrence[element_id - 1].occurred > pnode->occurrence[element_id - 1].maxOccurs) {
        if (pdata->exception_handler(XCC_EEMAX, el_local, pnode->name, pdata->udata)) {
            skip = 1;
        } else {
            pdata->error = 1;
        }
        goto e_switch;
    }

e_switch:

    switch (element_id) {
    case 1: /* #EStrGrace */
#line 558 "grace.xcc"

        element.project = grace_project_new(((ParserData *) pdata->udata)->grace, AMEM_MODEL_LIBUNDO);
    
#line 1623 "xml_in.c"
        attribs_required[0] = AStrVersion;
        nattribs_required = 1;

        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrVersion)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 1637 "xml_in.c"
                {
#line 738 "grace.xcc"

            project_set_version_id(element.project, attribute.ival);
        
#line 1643 "xml_in.c"
                }
                attribs_required[0] = NULL;
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 2: /* #EStrDefinitions */
#line 577 "grace.xcc"

        element.dummy = NULL;
    
#line 1666 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 3: /* #EStrColormap */
#line 577 "grace.xcc"

        element.dummy = NULL;
    
#line 1691 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 4: /* #EStrFontmap */
#line 577 "grace.xcc"

        element.dummy = NULL;
    
#line 1716 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 5: /* #EStrScales */
#line 577 "grace.xcc"

        element.dummy = NULL;
    
#line 1741 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrFontSize)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 1752 "xml_in.c"
                {
#line 784 "grace.xcc"

            project_set_fontsize_scale(xcc_get_root(pdata), attribute.dval);
        
#line 1758 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrLineWidth)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 1766 "xml_in.c"
                {
#line 787 "grace.xcc"

            project_set_linewidth_scale(xcc_get_root(pdata), attribute.dval);
        
#line 1772 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 6: /* #EStrColorDef */
#line 580 "grace.xcc"

        element.colordef = colordef_new();
    
#line 1794 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 1805 "xml_in.c"
                {
#line 793 "grace.xcc"

            element.colordef->id = attribute.ival;
        
#line 1811 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrRgb)) {
#line 448 "grace.xcc"

        unsigned int r, g, b;
        attribute.rgb = xmalloc(sizeof(RGB));
        sscanf(avalue, "#%02x%02x%02x", &r, &g, &b);
        attribute.rgb->red = r; attribute.rgb->green = g; attribute.rgb->blue = b;
    
#line 1822 "xml_in.c"
                {
#line 796 "grace.xcc"

            element.colordef->rgb = *(attribute.rgb);
            xfree(attribute.rgb);
        
#line 1829 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrName)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 1837 "xml_in.c"
                {
#line 800 "grace.xcc"

            element.colordef->cname = attribute.sval;
        
#line 1843 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 7: /* #EStrFontDef */
#line 583 "grace.xcc"

        element.fontdef = fontdef_new();
    
#line 1865 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 1876 "xml_in.c"
                {
#line 806 "grace.xcc"

            element.fontdef->id = attribute.ival;
        
#line 1882 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrName)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 1890 "xml_in.c"
                {
#line 809 "grace.xcc"

            element.fontdef->fontname = attribute.sval;
        
#line 1896 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFallback)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 1904 "xml_in.c"
                {
#line 812 "grace.xcc"

            element.fontdef->fallback = attribute.sval;
        
#line 1910 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 8: /* #EStrPage */
#line 561 "grace.xcc"

        element.page = page_new();
    
#line 1932 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrWidth)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 1943 "xml_in.c"
                {
#line 818 "grace.xcc"

            element.page->width = attribute.ival;
        
#line 1949 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrHeight)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 1957 "xml_in.c"
                {
#line 821 "grace.xcc"

            element.page->height = attribute.ival;
        
#line 1963 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrColorId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 1971 "xml_in.c"
                {
#line 824 "grace.xcc"

            element.page->bgcolor = attribute.ival;
        
#line 1977 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFill)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 1985 "xml_in.c"
                {
#line 827 "grace.xcc"

            element.page->bgfill = attribute.bval;
        
#line 1991 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 9: /* #EStrDescription */
#line 564 "grace.xcc"

        element.string = xmalloc(sizeof(char *));
    
#line 2013 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 10: /* #EStrDataFormats */
#line 577 "grace.xcc"

        element.dummy = NULL;
    
#line 2038 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 11: /* #EStrFaceSpec */
#line 586 "grace.xcc"

        element.facespec = facespec_new();
    
#line 2063 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrFontId)) {
#line 458 "grace.xcc"

        attribute.fontid = atoi(avalue);
    
#line 2074 "xml_in.c"
                {
#line 845 "grace.xcc"

            element.facespec->font = attribute.fontid;
        
#line 2080 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrColorId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 2088 "xml_in.c"
                {
#line 848 "grace.xcc"

            element.facespec->color = attribute.ival;
        
#line 2094 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrCharSize)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2102 "xml_in.c"
                {
#line 851 "grace.xcc"

            element.facespec->size = attribute.dval;
        
#line 2108 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 12: /* #EStrDates */
#line 577 "grace.xcc"

        element.dummy = NULL;
    
#line 2130 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrReference)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 2141 "xml_in.c"
                {
#line 857 "grace.xcc"

            project_set_ref_date(xcc_get_root(pdata), attribute.ival);
        
#line 2147 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrWrap)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2155 "xml_in.c"
                {
#line 860 "grace.xcc"

            project_allow_two_digits_years(xcc_get_root(pdata), attribute.bval);
        
#line 2161 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrWrapYear)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 2169 "xml_in.c"
                {
#line 863 "grace.xcc"

            project_set_wrap_year(xcc_get_root(pdata), attribute.ival);
        
#line 2175 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 13: /* #EStrWorld */
#line 577 "grace.xcc"

        element.dummy = NULL;
    
#line 2197 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrPrec)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 2208 "xml_in.c"
                {
#line 869 "grace.xcc"

            project_set_prec(xcc_get_root(pdata), attribute.ival);
        
#line 2214 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 14: /* #EStrText */
#line 564 "grace.xcc"

        element.string = xmalloc(sizeof(char *));
    
#line 2236 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 15: /* #EStrFillSpec */
#line 567 "grace.xcc"

        element.pen = xmalloc(sizeof(Pen));
        element.pen->color = element.pen->pattern = 1;
    
#line 2262 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrColorId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 2273 "xml_in.c"
                {
#line 881 "grace.xcc"

            element.pen->color = attribute.ival;
        
#line 2279 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPatternId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 2287 "xml_in.c"
                {
#line 884 "grace.xcc"

            element.pen->pattern = attribute.ival;
        
#line 2293 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 16: /* #EStrFrame */
#line 624 "grace.xcc"

        element.frame = frame_new(pnode->data);
    
#line 2315 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2326 "xml_in.c"
                {
#line 890 "grace.xcc"

            quark_idstr_set(element.frame, attribute.sval);
            xfree(attribute.sval);
        
#line 2333 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2341 "xml_in.c"
                {
#line 894 "grace.xcc"

            quark_set_active(element.frame, attribute.bval);
        
#line 2347 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2355 "xml_in.c"
                {
#line 897 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            frame_set_type(element.frame, get_frame_type_by_name(rt, attribute.sval));
            xfree(attribute.sval);
        
#line 2363 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 17: /* #EStrGraph */
#line 594 "grace.xcc"

        element.graph = graph_new(pnode->data);
    
#line 2385 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2396 "xml_in.c"
                {
#line 922 "grace.xcc"

            quark_idstr_set(element.graph, attribute.sval);
            xfree(attribute.sval);
        
#line 2403 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2411 "xml_in.c"
                {
#line 926 "grace.xcc"

            quark_set_active(element.graph, attribute.bval);
        
#line 2417 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 18: /* #EStrPresentationSpec */
#line 597 "grace.xcc"

        element.presentationspec = presentationspec_new();
    
#line 2439 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2450 "xml_in.c"
                {
#line 973 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.presentationspec->type = graph_get_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 2458 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrStacked)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2466 "xml_in.c"
                {
#line 978 "grace.xcc"

            element.presentationspec->stacked = attribute.bval;
        
#line 2472 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrBargap)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2480 "xml_in.c"
                {
#line 981 "grace.xcc"

            element.presentationspec->bargap = attribute.dval;
        
#line 2486 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 19: /* #EStrViewport */
#line 600 "grace.xcc"

        element.view = view_new();
    
#line 2508 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrXmin)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2519 "xml_in.c"
                {
#line 987 "grace.xcc"

            element.view->xv1 = attribute.dval;
        
#line 2525 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrYmin)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2533 "xml_in.c"
                {
#line 990 "grace.xcc"

            element.view->yv1 = attribute.dval;
        
#line 2539 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrXmax)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2547 "xml_in.c"
                {
#line 993 "grace.xcc"

            element.view->xv2 = attribute.dval;
        
#line 2553 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrYmax)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2561 "xml_in.c"
                {
#line 996 "grace.xcc"

            element.view->yv2 = attribute.dval;
        
#line 2567 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 20: /* #EStrXscale */
#line 603 "grace.xcc"

        element.scale = scale_new();
    
#line 2589 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrMin)) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 2602 "xml_in.c"
                {
#line 1002 "grace.xcc"

            element.scale->min = attribute.dateordval;
        
#line 2608 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrMax)) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 2618 "xml_in.c"
                {
#line 1005 "grace.xcc"

            element.scale->max = attribute.dateordval;
        
#line 2624 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2632 "xml_in.c"
                {
#line 1008 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.scale->type = get_scale_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 2640 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrInvert)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2648 "xml_in.c"
                {
#line 1013 "grace.xcc"

            element.scale->invert = attribute.bval;
        
#line 2654 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 21: /* #EStrYscale */
#line 603 "grace.xcc"

        element.scale = scale_new();
    
#line 2676 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrMin)) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 2689 "xml_in.c"
                {
#line 1019 "grace.xcc"

            element.scale->min = attribute.dateordval;
        
#line 2695 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrMax)) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 2705 "xml_in.c"
                {
#line 1022 "grace.xcc"

            element.scale->max = attribute.dateordval;
        
#line 2711 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2719 "xml_in.c"
                {
#line 1025 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.scale->type = get_scale_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 2727 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrInvert)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2735 "xml_in.c"
                {
#line 1030 "grace.xcc"

            element.scale->invert = attribute.bval;
        
#line 2741 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 22: /* #EStrZscale */
#line 606 "grace.xcc"

        element.dptr = xcalloc(1, SIZEOF_DOUBLE);
    
#line 2763 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrNorm)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2774 "xml_in.c"
                {
#line 1036 "grace.xcc"

            *(element.dptr) = attribute.dval;
        
#line 2780 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 23: /* #EStrLegend */
#line 609 "grace.xcc"

        element.legend = frame_get_legend(pnode->data);
    
#line 2802 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2813 "xml_in.c"
                {
#line 1042 "grace.xcc"

            element.legend->active = attribute.bval;
        
#line 2819 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrLength)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2827 "xml_in.c"
                {
#line 1045 "grace.xcc"

            element.legend->len = attribute.dval;
        
#line 2833 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrVgap)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2841 "xml_in.c"
                {
#line 1048 "grace.xcc"

            element.legend->vgap = attribute.dval;
        
#line 2847 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrHgap)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 2855 "xml_in.c"
                {
#line 1051 "grace.xcc"

            element.legend->hgap = attribute.dval;
        
#line 2861 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrInvert)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2869 "xml_in.c"
                {
#line 1054 "grace.xcc"

            element.legend->invert = attribute.bval;
        
#line 2875 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrSingleSymbol)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 2883 "xml_in.c"
                {
#line 1057 "grace.xcc"

            element.legend->singlesym = attribute.bval;
        
#line 2889 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 24: /* #EStrLegframe */
#line 612 "grace.xcc"

        element.legframe = legframe_new();
    
#line 2911 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrAnchor)) {
#line 467 "grace.xcc"

        attribute.fpoint = xmalloc(sizeof(FPoint));
        sscanf(avalue, "(%lg, %lg)", &(attribute.fpoint->x), &(attribute.fpoint->y));
    
#line 2923 "xml_in.c"
                {
#line 1078 "grace.xcc"

            element.legframe->anchor = *(attribute.fpoint);
            xfree(attribute.fpoint);
        
#line 2930 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrHJust)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2938 "xml_in.c"
                {
#line 1082 "grace.xcc"

            int hjust = JUST_LEFT;
            if (!strcmp(attribute.sval, VStrLeft)) {
                hjust = JUST_LEFT;
            } else
            if (!strcmp(attribute.sval, VStrRight)) {
                hjust = JUST_RIGHT;
            } else
            if (!strcmp(attribute.sval, VStrCenter)) {
                hjust = JUST_CENTER;
            }
            element.legframe->just |= hjust;
            xfree(attribute.sval);
        
#line 2955 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrVJust)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 2963 "xml_in.c"
                {
#line 1096 "grace.xcc"

            int vjust = JUST_BOTTOM;
            if (!strcmp(attribute.sval, VStrBottom)) {
                vjust = JUST_BOTTOM;
            } else
            if (!strcmp(attribute.sval, VStrTop)) {
                vjust = JUST_TOP;
            } else
            if (!strcmp(attribute.sval, VStrMiddle)) {
                vjust = JUST_MIDDLE;
            } else
            if (!strcmp(attribute.sval, VStrBaseline)) {
                vjust = JUST_BLINE;
            }
            element.legframe->just |= vjust;
            xfree(attribute.sval);
        
#line 2983 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrOffset)) {
#line 461 "grace.xcc"

        attribute.offset = xmalloc(sizeof(VVector));
        if (sscanf(avalue, "(%lg, %lg)", &(attribute.offset->x), &(attribute.offset->y)) != 2) {
            attribute.offset->x = attribute.offset->y = 0.0;
        }
    
#line 2994 "xml_in.c"
                {
#line 1113 "grace.xcc"

            element.legframe->offset = *(attribute.offset);
            xfree(attribute.offset);
        
#line 3001 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 25: /* #EStrLineSpec */
#line 571 "grace.xcc"

        element.line = xmalloc(sizeof(Line));
        element.line->pen.color = element.line->pen.pattern = 1;
        element.line->width = 1.0;
        element.line->style = 1;
    
#line 3026 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrColorId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3037 "xml_in.c"
                {
#line 1129 "grace.xcc"

            element.line->pen.color = attribute.ival;
        
#line 3043 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPatternId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3051 "xml_in.c"
                {
#line 1132 "grace.xcc"

            element.line->pen.pattern = attribute.ival;
        
#line 3057 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrStyleId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3065 "xml_in.c"
                {
#line 1135 "grace.xcc"

            element.line->style = attribute.ival;
        
#line 3071 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrWidth)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 3079 "xml_in.c"
                {
#line 1138 "grace.xcc"

            element.line->width = attribute.dval;
        
#line 3085 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 26: /* #EStrLocator */
#line 615 "grace.xcc"

        element.glocator = glocator_new();
    
#line 3107 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3118 "xml_in.c"
                {
#line 1144 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.glocator->type = get_glocator_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 3126 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 27: /* #EStrFixedpoint */
#line 618 "grace.xcc"

        element.fixedpoint = fixedpoint_new();
    
#line 3148 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 3159 "xml_in.c"
                {
#line 1171 "grace.xcc"

            element.fixedpoint->active = attribute.bval;
        
#line 3165 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrX)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 3173 "xml_in.c"
                {
#line 1174 "grace.xcc"

            element.fixedpoint->x = attribute.dval;
        
#line 3179 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrY)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 3187 "xml_in.c"
                {
#line 1177 "grace.xcc"

            element.fixedpoint->y = attribute.dval;
        
#line 3193 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 28: /* #EStrXformat */
#line 621 "grace.xcc"

        element.format = format_new();
    
#line 3215 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 454 "grace.xcc"

        RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
        attribute.ftype = get_format_type_by_name(rt, avalue);
    
#line 3227 "xml_in.c"
                {
#line 1183 "grace.xcc"

            element.format->type = attribute.ftype;
        
#line 3233 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPrec)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3241 "xml_in.c"
                {
#line 1186 "grace.xcc"

            element.format->prec = attribute.ival;
        
#line 3247 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFormatString)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3255 "xml_in.c"
                {
#line 1189 "grace.xcc"

            element.format->fstring = attribute.sval;
        
#line 3261 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 29: /* #EStrYformat */
#line 621 "grace.xcc"

        element.format = format_new();
    
#line 3283 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 454 "grace.xcc"

        RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
        attribute.ftype = get_format_type_by_name(rt, avalue);
    
#line 3295 "xml_in.c"
                {
#line 1195 "grace.xcc"

            element.format->type = attribute.ftype;
        
#line 3301 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPrec)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3309 "xml_in.c"
                {
#line 1198 "grace.xcc"

            element.format->prec = attribute.ival;
        
#line 3315 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFormatString)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3323 "xml_in.c"
                {
#line 1201 "grace.xcc"

            element.format->fstring = attribute.sval;
        
#line 3329 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 30: /* #EStrAGrid */
#line 630 "grace.xcc"

        element.axisgrid = axisgrid_new(pnode->data);
    
#line 3351 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3362 "xml_in.c"
                {
#line 1207 "grace.xcc"

            quark_idstr_set(element.axisgrid, attribute.sval);
            xfree(attribute.sval);
        
#line 3369 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3377 "xml_in.c"
                {
#line 1211 "grace.xcc"

            int axis_type;
            if (!strcmp(attribute.sval, "x")) {
                axis_type = AXIS_TYPE_X;
            } else {
                axis_type = AXIS_TYPE_Y;
            }
            axisgrid_set_type(element.axisgrid, axis_type);
            xfree(attribute.sval);
        
#line 3390 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 3398 "xml_in.c"
                {
#line 1221 "grace.xcc"

            quark_set_active(element.axisgrid, attribute.bval);
        
#line 3404 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrMajorStep)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 3412 "xml_in.c"
                {
#line 1224 "grace.xcc"

            tickmarks *t = axisgrid_get_data(element.axisgrid);
            t->tmajor = attribute.dval;
        
#line 3419 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrMinorDivisions)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3427 "xml_in.c"
                {
#line 1228 "grace.xcc"

            tickmarks *t = axisgrid_get_data(element.axisgrid);
            t->nminor = attribute.ival;
        
#line 3434 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrAutoTicking)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3442 "xml_in.c"
                {
#line 1232 "grace.xcc"

            tickmarks *t = axisgrid_get_data(element.axisgrid);
            t->t_autonum = attribute.ival;
        
#line 3449 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrRoundedPosition)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 3457 "xml_in.c"
                {
#line 1236 "grace.xcc"

            tickmarks *t = axisgrid_get_data(element.axisgrid);
            t->t_round = attribute.bval;
        
#line 3464 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 31: /* #EStrMajorGridlines */
#line 639 "grace.xcc"

        element.gridprops = gridprops_new();
    
#line 3486 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 3497 "xml_in.c"
                {
#line 1307 "grace.xcc"

            element.gridprops->onoff = attribute.bval;
        
#line 3503 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 32: /* #EStrMinorGridlines */
#line 639 "grace.xcc"

        element.gridprops = gridprops_new();
    
#line 3525 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 3536 "xml_in.c"
                {
#line 1318 "grace.xcc"

            element.gridprops->onoff = attribute.bval;
        
#line 3542 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 33: /* #EStrAxisbar */
#line 636 "grace.xcc"

        element.axisbar = axisbar_new();
    
#line 3564 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 34: /* #EStrUserticks */
#line 648 "grace.xcc"

        element.uticks = uticks_new();
    
#line 3589 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 492 "grace.xcc"

        if (!strcmp(avalue, VStrNone)) {
            attribute.uticktype = TICKS_SPEC_NONE;
        } else
        if (!strcmp(avalue, VStrTicks)) {
            attribute.uticktype = TICKS_SPEC_MARKS;
        } else
        if (!strcmp(avalue, VStrBoth)) {
            attribute.uticktype = TICKS_SPEC_BOTH;
        } else {
            attribute.uticktype = TICKS_SPEC_BOTH;
            errmsg("Wrong uticktype");
        }
    
#line 3611 "xml_in.c"
                {
#line 1336 "grace.xcc"

            element.uticks->type = attribute.uticktype;
        
#line 3617 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 35: /* #EStrMajorTickmarks */
#line 642 "grace.xcc"

        element.tickprops = tickprops_new();
    
#line 3639 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrInoutPlacement)) {
#line 478 "grace.xcc"

        if (!strcmp(avalue, VStrIn)) {
            attribute.inoutplacement = TICKS_IN;
        } else
        if (!strcmp(avalue, VStrOut)) {
            attribute.inoutplacement = TICKS_OUT;
        } else
        if (!strcmp(avalue, VStrBoth)) {
            attribute.inoutplacement = TICKS_BOTH;
        } else {
            attribute.inoutplacement = TICKS_IN;
            errmsg("Wrong inoutplacement");
        }
    
#line 3661 "xml_in.c"
                {
#line 1348 "grace.xcc"

            element.tickprops->inout = attribute.inoutplacement;
        
#line 3667 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrSize)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 3675 "xml_in.c"
                {
#line 1351 "grace.xcc"

            element.tickprops->size = attribute.dval;
        
#line 3681 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 36: /* #EStrMinorTickmarks */
#line 642 "grace.xcc"

        element.tickprops = tickprops_new();
    
#line 3703 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrInoutPlacement)) {
#line 478 "grace.xcc"

        if (!strcmp(avalue, VStrIn)) {
            attribute.inoutplacement = TICKS_IN;
        } else
        if (!strcmp(avalue, VStrOut)) {
            attribute.inoutplacement = TICKS_OUT;
        } else
        if (!strcmp(avalue, VStrBoth)) {
            attribute.inoutplacement = TICKS_BOTH;
        } else {
            attribute.inoutplacement = TICKS_IN;
            errmsg("Wrong inoutplacement");
        }
    
#line 3725 "xml_in.c"
                {
#line 1363 "grace.xcc"

            element.tickprops->inout = attribute.inoutplacement;
        
#line 3731 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrSize)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 3739 "xml_in.c"
                {
#line 1366 "grace.xcc"

            element.tickprops->size = attribute.dval;
        
#line 3745 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 37: /* #EStrTicklabels */
#line 645 "grace.xcc"

        element.tlabels = tlabels_new();
    
#line 3767 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrTransform)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3778 "xml_in.c"
                {
#line 1378 "grace.xcc"

            element.tlabels->transform = attribute.sval;
        
#line 3784 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPrepend)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3792 "xml_in.c"
                {
#line 1381 "grace.xcc"

            element.tlabels->prepend = attribute.sval;
        
#line 3798 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrAppend)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3806 "xml_in.c"
                {
#line 1384 "grace.xcc"

            element.tlabels->append = attribute.sval;
        
#line 3812 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrOffset)) {
#line 461 "grace.xcc"

        attribute.offset = xmalloc(sizeof(VVector));
        if (sscanf(avalue, "(%lg, %lg)", &(attribute.offset->x), &(attribute.offset->y)) != 2) {
            attribute.offset->x = attribute.offset->y = 0.0;
        }
    
#line 3823 "xml_in.c"
                {
#line 1387 "grace.xcc"

            element.tlabels->offset = *(attribute.offset);
            xfree(attribute.offset);
        
#line 3830 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrSkip)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3838 "xml_in.c"
                {
#line 1391 "grace.xcc"

            element.tlabels->skip = attribute.ival;
        
#line 3844 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrStagger)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 3852 "xml_in.c"
                {
#line 1394 "grace.xcc"

            element.tlabels->stagger = attribute.ival;
        
#line 3858 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrStart)) {
#line 544 "grace.xcc"

        attribute.autodateordval = xmalloc(sizeof(Autoval));
        if (!strcmp(avalue, VStrAuto)) {
            attribute.autodateordval->autov = TRUE;
            attribute.autodateordval->value = 0.0;
        } else {
            attribute.autodateordval->autov = FALSE;
            if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.autodateordval->value) != RETURN_SUCCESS) {
                    attribute.autodateordval->value = 0.0;
            }
        }
    
#line 3875 "xml_in.c"
                {
#line 1397 "grace.xcc"

            element.tlabels->autostart = attribute.autodateordval->autov;
            element.tlabels->start     = attribute.autodateordval->value;
            xfree(attribute.autodateordval);
        
#line 3883 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrStop)) {
#line 544 "grace.xcc"

        attribute.autodateordval = xmalloc(sizeof(Autoval));
        if (!strcmp(avalue, VStrAuto)) {
            attribute.autodateordval->autov = TRUE;
            attribute.autodateordval->value = 0.0;
        } else {
            attribute.autodateordval->autov = FALSE;
            if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.autodateordval->value) != RETURN_SUCCESS) {
                    attribute.autodateordval->value = 0.0;
            }
        }
    
#line 3900 "xml_in.c"
                {
#line 1402 "grace.xcc"

            element.tlabels->autostop = attribute.autodateordval->autov;
            element.tlabels->stop     = attribute.autodateordval->value;
            xfree(attribute.autodateordval);
        
#line 3908 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 38: /* #EStrTick */
#line 651 "grace.xcc"

        element.tick = tick_new();
    
#line 3930 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 506 "grace.xcc"

        if (!strcmp(avalue, VStrMajor)) {
            attribute.ticktype = TICK_TYPE_MAJOR;
        } else
        if (!strcmp(avalue, VStrMinor)) {
            attribute.ticktype = TICK_TYPE_MINOR;
        } else {
            attribute.ticktype = TICK_TYPE_MINOR;
            errmsg("Wrong ticktype");
        }
    
#line 3949 "xml_in.c"
                {
#line 1422 "grace.xcc"

            element.tick->type = attribute.ticktype;
        
#line 3955 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPosition)) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 3965 "xml_in.c"
                {
#line 1425 "grace.xcc"

            element.tick->wtpos = attribute.dateordval;
        
#line 3971 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrLabel)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 3979 "xml_in.c"
                {
#line 1428 "grace.xcc"

            element.tick->label = attribute.sval;
        
#line 3985 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 39: /* #EStrAxis */
#line 633 "grace.xcc"

        element.axis = axis_new(pnode->data);
    
#line 4007 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4018 "xml_in.c"
                {
#line 1434 "grace.xcc"

            quark_idstr_set(element.axis, attribute.sval);
            xfree(attribute.sval);
        
#line 4025 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4033 "xml_in.c"
                {
#line 1438 "grace.xcc"

            quark_set_active(element.axis, attribute.bval);
        
#line 4039 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPosition)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4047 "xml_in.c"
                {
#line 1442 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            axis_set_position(element.axis, get_axis_position_by_name(rt, attribute.sval));
            xfree(attribute.sval);
        
#line 4055 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrOffset)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4063 "xml_in.c"
                {
#line 1448 "grace.xcc"

            axis_set_offset(element.axis, attribute.dval);
        
#line 4069 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrBar)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4077 "xml_in.c"
                {
#line 1451 "grace.xcc"

            axis_enable_bar(element.axis, attribute.bval);
        
#line 4083 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrTicks)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4091 "xml_in.c"
                {
#line 1454 "grace.xcc"

            axis_enable_ticks(element.axis, attribute.bval);
        
#line 4097 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrLabels)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4105 "xml_in.c"
                {
#line 1457 "grace.xcc"

            axis_enable_labels(element.axis, attribute.bval);
        
#line 4111 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 40: /* #EStrFormat */
#line 621 "grace.xcc"

        element.format = format_new();
    
#line 4133 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 454 "grace.xcc"

        RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
        attribute.ftype = get_format_type_by_name(rt, avalue);
    
#line 4145 "xml_in.c"
                {
#line 1466 "grace.xcc"

            element.format->type = attribute.ftype;
        
#line 4151 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPrec)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 4159 "xml_in.c"
                {
#line 1469 "grace.xcc"

            element.format->prec = attribute.ival;
        
#line 4165 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFormatString)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4173 "xml_in.c"
                {
#line 1472 "grace.xcc"

            element.format->fstring = attribute.sval;
        
#line 4179 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 41: /* #EStrObject */
#line 654 "grace.xcc"

        element.object = object_new(pnode->data);
    
#line 4201 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4212 "xml_in.c"
                {
#line 1478 "grace.xcc"

            quark_idstr_set(element.object, attribute.sval);
            xfree(attribute.sval);
        
#line 4219 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4227 "xml_in.c"
                {
#line 1482 "grace.xcc"

            quark_set_active(element.object, attribute.bval);
        
#line 4233 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrAngle)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4241 "xml_in.c"
                {
#line 1485 "grace.xcc"

            object_set_angle(element.object, attribute.dval);
        
#line 4247 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrOffset)) {
#line 461 "grace.xcc"

        attribute.offset = xmalloc(sizeof(VVector));
        if (sscanf(avalue, "(%lg, %lg)", &(attribute.offset->x), &(attribute.offset->y)) != 2) {
            attribute.offset->x = attribute.offset->y = 0.0;
        }
    
#line 4258 "xml_in.c"
                {
#line 1488 "grace.xcc"

            object_set_offset(element.object, attribute.offset);
            xfree(attribute.offset);
        
#line 4265 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 42: /* #EStrLocation */
#line 660 "grace.xcc"

        element.location = location_new();
    
#line 4287 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrX)) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 4300 "xml_in.c"
                {
#line 1530 "grace.xcc"

            element.location->ap.x = attribute.dateordval;
        
#line 4306 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrY)) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 4316 "xml_in.c"
                {
#line 1533 "grace.xcc"

            element.location->ap.y = attribute.dateordval;
        
#line 4322 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 43: /* #EStrBoxData */
#line 666 "grace.xcc"

        element.do_box_data = object_odata_new(quark_get_amem(pnode->data), DO_BOX);
    
#line 4344 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrWidth)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4355 "xml_in.c"
                {
#line 1539 "grace.xcc"

            element.do_box_data->width = attribute.dval;
        
#line 4361 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrHeight)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4369 "xml_in.c"
                {
#line 1542 "grace.xcc"

            element.do_box_data->height = attribute.dval;
        
#line 4375 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 44: /* #EStrArcData */
#line 669 "grace.xcc"

        element.do_arc_data = object_odata_new(quark_get_amem(pnode->data), DO_ARC);
    
#line 4397 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrWidth)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4408 "xml_in.c"
                {
#line 1548 "grace.xcc"

            element.do_arc_data->width = attribute.dval;
        
#line 4414 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrHeight)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4422 "xml_in.c"
                {
#line 1551 "grace.xcc"

            element.do_arc_data->height = attribute.dval;
        
#line 4428 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrStartAngle)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4436 "xml_in.c"
                {
#line 1554 "grace.xcc"

            element.do_arc_data->angle1 = attribute.dval;
        
#line 4442 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrExtentAngle)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4450 "xml_in.c"
                {
#line 1557 "grace.xcc"

            element.do_arc_data->angle2 = attribute.dval;
        
#line 4456 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrClosureType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4464 "xml_in.c"
                {
#line 1560 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.do_arc_data->closure_type = get_arcclosure_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 4472 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrDrawClosure)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4480 "xml_in.c"
                {
#line 1565 "grace.xcc"

            element.do_arc_data->draw_closure = attribute.bval;
        
#line 4486 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 45: /* #EStrLineData */
#line 663 "grace.xcc"

        element.do_line_data = object_odata_new(quark_get_amem(pnode->data), DO_LINE);
    
#line 4508 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrX)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4519 "xml_in.c"
                {
#line 1571 "grace.xcc"

            element.do_line_data->vector.x = attribute.dval;
        
#line 4525 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrY)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4533 "xml_in.c"
                {
#line 1574 "grace.xcc"

            element.do_line_data->vector.y = attribute.dval;
        
#line 4539 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrArrowsAt)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4547 "xml_in.c"
                {
#line 1577 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.do_line_data->arrow_end = get_arrow_placement_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 4555 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 46: /* #EStrAText */
#line 657 "grace.xcc"

        element.atext = atext_new(pnode->data);
    
#line 4577 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4588 "xml_in.c"
                {
#line 1591 "grace.xcc"

            quark_idstr_set(element.atext, attribute.sval);
            xfree(attribute.sval);
        
#line 4595 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4603 "xml_in.c"
                {
#line 1595 "grace.xcc"

            quark_set_active(element.atext, attribute.bval);
        
#line 4609 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrOffset)) {
#line 461 "grace.xcc"

        attribute.offset = xmalloc(sizeof(VVector));
        if (sscanf(avalue, "(%lg, %lg)", &(attribute.offset->x), &(attribute.offset->y)) != 2) {
            attribute.offset->x = attribute.offset->y = 0.0;
        }
    
#line 4620 "xml_in.c"
                {
#line 1598 "grace.xcc"

            atext_set_offset(element.atext, attribute.offset);
            xfree(attribute.offset);
        
#line 4627 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 47: /* #EStrTextFrame */
#line 672 "grace.xcc"

        element.textframe = textframe_new();
    
#line 4649 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4660 "xml_in.c"
                {
#line 1638 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.textframe->decor = get_framedecor_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 4668 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrOffset)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4676 "xml_in.c"
                {
#line 1643 "grace.xcc"

            element.textframe->offset = attribute.dval;
        
#line 4682 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 48: /* #EStrPointer */
#line 675 "grace.xcc"

        element.textpointer = textpointer_new();
    
#line 4704 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4715 "xml_in.c"
                {
#line 1659 "grace.xcc"

            element.textpointer->active = attribute.bval;
        
#line 4721 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 49: /* #EStrArrow */
#line 678 "grace.xcc"

        element.arrow = arrow_new();
    
#line 4743 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4754 "xml_in.c"
                {
#line 1671 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.arrow->type = get_arrow_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 4762 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrLength)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4770 "xml_in.c"
                {
#line 1676 "grace.xcc"

            element.arrow->length = attribute.dval;
        
#line 4776 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrDlFf)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4784 "xml_in.c"
                {
#line 1679 "grace.xcc"

            element.arrow->dL_ff = attribute.dval;
        
#line 4790 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrLlFf)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 4798 "xml_in.c"
                {
#line 1682 "grace.xcc"

            element.arrow->lL_ff = attribute.dval;
        
#line 4804 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 50: /* #EStrSSD */
#line 589 "grace.xcc"

        element.ssd = grace_ssd_new(pnode->data);
        ((ParserData *) pdata->udata)->ss = element.ssd;
        ((ParserData *) pdata->udata)->ncol = -1;
    
#line 4828 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4839 "xml_in.c"
                {
#line 1688 "grace.xcc"

            quark_idstr_set(element.ssd, attribute.sval);
            xfree(attribute.sval);
        
#line 4846 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4854 "xml_in.c"
                {
#line 1692 "grace.xcc"

            quark_set_active(element.ssd, attribute.bval);
        
#line 4860 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrRows)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 4868 "xml_in.c"
                {
#line 1695 "grace.xcc"

            ssd_set_nrows(element.ssd, attribute.ival);
        
#line 4874 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrIndexed)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 4882 "xml_in.c"
                {
#line 1698 "grace.xcc"

            ssd_set_indexed(element.ssd, attribute.bval);
        
#line 4888 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 51: /* #EStrScolumn */
#line 713 "grace.xcc"

        {
        ParserData *udata = (ParserData *) pdata->udata;
        element.scolumn = ssd_add_col(pnode->data, FFORMAT_STRING);
        udata->ncol++;
        udata->nrow = -1;
        }
    
#line 4915 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrLabel)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4926 "xml_in.c"
                {
#line 1708 "grace.xcc"

            ParserData *udata = (ParserData *) pdata->udata;
            element.scolumn->label = amem_strdup(quark_get_amem(udata->ss), attribute.sval);
            xfree(attribute.sval);
        
#line 4934 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 52: /* #EStrDcolumn */
#line 721 "grace.xcc"

        {
        ParserData *udata = (ParserData *) pdata->udata;
        element.dcolumn = ssd_add_col(pnode->data, FFORMAT_NUMBER);
        udata->ncol++;
        udata->nrow = -1;
        }
    
#line 4961 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrLabel)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 4972 "xml_in.c"
                {
#line 1723 "grace.xcc"

            ParserData *udata = (ParserData *) pdata->udata;
            element.dcolumn->label = amem_strdup(quark_get_amem(udata->ss), attribute.sval);
            xfree(attribute.sval);
        
#line 4980 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 53: /* #EStrCell */
#line 729 "grace.xcc"

        element.cell = xmalloc(SIZEOF_VOID_P);
        ((ParserData *) pdata->udata)->nrow++;
    
#line 5003 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 54: /* #EStrSet */
#line 681 "grace.xcc"

        element.set = grace_set_new(pnode->data);
    
#line 5028 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5039 "xml_in.c"
                {
#line 1748 "grace.xcc"

            quark_idstr_set(element.set, attribute.sval);
            xfree(attribute.sval);
        
#line 5046 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 5054 "xml_in.c"
                {
#line 1752 "grace.xcc"

            quark_set_active(element.set, attribute.bval);
        
#line 5060 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrType)) {
#line 524 "grace.xcc"

        RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
        attribute.settype = get_settype_by_name(rt, avalue);
    
#line 5069 "xml_in.c"
                {
#line 1755 "grace.xcc"

            set_set_type(element.set, attribute.settype);
        
#line 5075 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrSkip)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5083 "xml_in.c"
                {
#line 1758 "grace.xcc"

            set_set_symskip(element.set, attribute.ival);
        
#line 5089 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrSkipMinDist)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 5097 "xml_in.c"
                {
#line 1761 "grace.xcc"

            set_set_symskipmindist(element.set, attribute.dval);
        
#line 5103 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 55: /* #EStrSymbol */
#line 684 "grace.xcc"

        element.symbol = symbol_new();
    
#line 5125 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5136 "xml_in.c"
                {
#line 1794 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.symbol->type = get_sym_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 5144 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrSize)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 5152 "xml_in.c"
                {
#line 1799 "grace.xcc"

            element.symbol->size = attribute.dval;
        
#line 5158 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrChar)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5166 "xml_in.c"
                {
#line 1802 "grace.xcc"

            element.symbol->symchar = attribute.ival;
        
#line 5172 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFontId)) {
#line 458 "grace.xcc"

        attribute.fontid = atoi(avalue);
    
#line 5180 "xml_in.c"
                {
#line 1805 "grace.xcc"

            element.symbol->charfont = attribute.fontid;
        
#line 5186 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 56: /* #EStrLine */
#line 687 "grace.xcc"

        element.setline = setline_new();
    
#line 5208 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5219 "xml_in.c"
                {
#line 1821 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.setline->type = get_line_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 5227 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFillType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5235 "xml_in.c"
                {
#line 1826 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.setline->filltype = get_setfill_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 5243 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrFillRule)) {
#line 528 "grace.xcc"

        if (!strcmp(avalue, VStrWinding)) {
            attribute.fillrule = FILLRULE_WINDING;
        } else {
            attribute.fillrule = FILLRULE_EVENODD;
        }
    
#line 5255 "xml_in.c"
                {
#line 1831 "grace.xcc"

            element.setline->fillrule = attribute.fillrule;
        
#line 5261 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrBaselineType)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5269 "xml_in.c"
                {
#line 1834 "grace.xcc"

            RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
            element.setline->baseline_type = get_baseline_type_by_name(rt, attribute.sval);
            xfree(attribute.sval);
        
#line 5277 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrDrawBaseline)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 5285 "xml_in.c"
                {
#line 1839 "grace.xcc"

            element.setline->baseline = attribute.bval;
        
#line 5291 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrDrawDroplines)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 5299 "xml_in.c"
                {
#line 1842 "grace.xcc"

            element.setline->droplines = attribute.bval;
        
#line 5305 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 57: /* #EStrAnnotation */
#line 690 "grace.xcc"

        element.annotation = avalue_new();
    
#line 5327 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 5338 "xml_in.c"
                {
#line 1858 "grace.xcc"

            element.annotation->active = attribute.bval;
        
#line 5344 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrOffset)) {
#line 461 "grace.xcc"

        attribute.offset = xmalloc(sizeof(VVector));
        if (sscanf(avalue, "(%lg, %lg)", &(attribute.offset->x), &(attribute.offset->y)) != 2) {
            attribute.offset->x = attribute.offset->y = 0.0;
        }
    
#line 5355 "xml_in.c"
                {
#line 1861 "grace.xcc"

            element.annotation->offset = *(attribute.offset);
            xfree(attribute.offset);
        
#line 5362 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrPrepend)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5370 "xml_in.c"
                {
#line 1865 "grace.xcc"

            element.annotation->prestr = attribute.sval;
        
#line 5376 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrAppend)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5384 "xml_in.c"
                {
#line 1868 "grace.xcc"

            element.annotation->appstr = attribute.sval;
        
#line 5390 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 58: /* #EStrTextProperties */
#line 627 "grace.xcc"

        element.textprops = textprops_new();
    
#line 5412 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrAngle)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 5423 "xml_in.c"
                {
#line 1886 "grace.xcc"

            element.textprops->angle = attribute.dval;
        
#line 5429 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrHJust)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5437 "xml_in.c"
                {
#line 1889 "grace.xcc"

            int hjust = JUST_LEFT;
            if (!strcmp(attribute.sval, VStrLeft)) {
                hjust = JUST_LEFT;
            } else
            if (!strcmp(attribute.sval, VStrRight)) {
                hjust = JUST_RIGHT;
            } else
            if (!strcmp(attribute.sval, VStrCenter)) {
                hjust = JUST_CENTER;
            }
            element.textprops->just |= hjust;
            xfree(attribute.sval);
        
#line 5454 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrVJust)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5462 "xml_in.c"
                {
#line 1903 "grace.xcc"

            int vjust = JUST_BOTTOM;
            if (!strcmp(attribute.sval, VStrBottom)) {
                vjust = JUST_BOTTOM;
            } else
            if (!strcmp(attribute.sval, VStrTop)) {
                vjust = JUST_TOP;
            } else
            if (!strcmp(attribute.sval, VStrMiddle)) {
                vjust = JUST_MIDDLE;
            } else
            if (!strcmp(attribute.sval, VStrBaseline)) {
                vjust = JUST_BLINE;
            }
            element.textprops->just |= vjust;
            xfree(attribute.sval);
        
#line 5482 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 59: /* #EStrErrorbar */
#line 693 "grace.xcc"

        element.errorbar = xmalloc(sizeof(Errbar));
        memset(element.errorbar, 0, sizeof(Errbar));
    
#line 5505 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 5516 "xml_in.c"
                {
#line 1931 "grace.xcc"

            element.errorbar->active = attribute.bval;
        
#line 5522 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 60: /* #EStrBarline */
#line 697 "grace.xcc"

        element.barline = barline_new();
    
#line 5544 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrSize)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 5555 "xml_in.c"
                {
#line 1954 "grace.xcc"

            element.barline->size = attribute.dval;
        
#line 5561 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 61: /* #EStrRiserline */
#line 700 "grace.xcc"

        element.riserline = riserline_new();
    
#line 5583 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrArrowClip)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 5594 "xml_in.c"
                {
#line 1966 "grace.xcc"

            element.riserline->arrow_clip = attribute.bval;
        
#line 5600 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrClipLength)) {
#line 439 "grace.xcc"

        attribute.dval = atof(avalue);
    
#line 5608 "xml_in.c"
                {
#line 1969 "grace.xcc"

            element.riserline->clip_length = attribute.dval;
        
#line 5614 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 62: /* #EStrLegendEntry */
#line 564 "grace.xcc"

        element.string = xmalloc(sizeof(char *));
    
#line 5636 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 63: /* #EStrDataset */
#line 703 "grace.xcc"

        element.dataset = dataset_new(quark_get_amem(pnode->data));
    
#line 5661 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, "x")) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5672 "xml_in.c"
                {
#line 1988 "grace.xcc"

            element.dataset->cols[DATA_X] = attribute.ival;
        
#line 5678 "xml_in.c"
                }
            } else
            if (!strcmp(aname, "y")) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5686 "xml_in.c"
                {
#line 1991 "grace.xcc"

            element.dataset->cols[DATA_Y] = attribute.ival;
        
#line 5692 "xml_in.c"
                }
            } else
            if (!strcmp(aname, "y1")) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5700 "xml_in.c"
                {
#line 1994 "grace.xcc"

            element.dataset->cols[DATA_Y1] = attribute.ival;
        
#line 5706 "xml_in.c"
                }
            } else
            if (!strcmp(aname, "y2")) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5714 "xml_in.c"
                {
#line 1997 "grace.xcc"

            element.dataset->cols[DATA_Y2] = attribute.ival;
        
#line 5720 "xml_in.c"
                }
            } else
            if (!strcmp(aname, "y3")) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5728 "xml_in.c"
                {
#line 2000 "grace.xcc"

            element.dataset->cols[DATA_Y3] = attribute.ival;
        
#line 5734 "xml_in.c"
                }
            } else
            if (!strcmp(aname, "y4")) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5742 "xml_in.c"
                {
#line 2003 "grace.xcc"

            element.dataset->cols[DATA_Y4] = attribute.ival;
        
#line 5748 "xml_in.c"
                }
            } else
            if (!strcmp(aname, "s")) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5756 "xml_in.c"
                {
#line 2006 "grace.xcc"

            element.dataset->acol = attribute.ival;
        
#line 5762 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 64: /* #EStrRow */
#line 706 "grace.xcc"

        element.wpoint = xmalloc(sizeof(WPoint));
        memset(element.wpoint, 0, sizeof(WPoint));
    
#line 5785 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, "x")) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 5798 "xml_in.c"
                {
#line 2012 "grace.xcc"

            element.wpoint->x = attribute.dateordval;
        
#line 5804 "xml_in.c"
                }
            } else
            if (!strcmp(aname, "y")) {
#line 539 "grace.xcc"

        if (parse_date_or_number(xcc_get_root(pdata), avalue, FALSE, &attribute.dateordval) != RETURN_SUCCESS) {
                attribute.dateordval = 0.0;
        }
    
#line 5814 "xml_in.c"
                {
#line 2015 "grace.xcc"

            element.wpoint->y = attribute.dateordval;
        
#line 5820 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 65: /* #EStrRegion */
#line 710 "grace.xcc"

        element.region = region_new(pnode->data);
    
#line 5842 "xml_in.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], GRACE_NS_URI, &askip);
            avalue = attr[i + 1];
            if (!strcmp(aname, AStrId)) {
#line 442 "grace.xcc"

        attribute.sval = utf2iso(avalue);
    
#line 5853 "xml_in.c"
                {
#line 2021 "grace.xcc"

            quark_idstr_set(element.region, attribute.sval);
            xfree(attribute.sval);
        
#line 5860 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrActive)) {
#line 445 "grace.xcc"

        attribute.bval = strings_are_equal(avalue, "yes");
    
#line 5868 "xml_in.c"
                {
#line 2025 "grace.xcc"

            quark_set_active(element.region, attribute.bval);
        
#line 5874 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrType)) {
#line 535 "grace.xcc"

        RunTime *rt = ((ParserData *)pdata->udata)->grace->rt;
        attribute.regiontype = get_regiontype_by_name(rt, avalue);
    
#line 5883 "xml_in.c"
                {
#line 2028 "grace.xcc"

            region_set_type(element.region, attribute.regiontype);
        
#line 5889 "xml_in.c"
                }
            } else
            if (!strcmp(aname, AStrColorId)) {
#line 436 "grace.xcc"

        attribute.ival = atoi(avalue);
    
#line 5897 "xml_in.c"
                {
#line 2031 "grace.xcc"

            region_set_color(element.region, attribute.ival);
        
#line 5903 "xml_in.c"
                }
            } else
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    }

    if (skip) {
        element_id = -1;
    }
    else {
        for (i = 0; i < nattribs_required; i++) {
            aname = attribs_required[i];
            if (aname) {
                askip = pdata->exception_handler(XCC_EAREQ, aname, el_local, pdata->udata);
                if (!askip) {
                    pdata->error = 1;
                }
            }
        }
    }

    node = xcc_node_new();
    node->name = el_local;
    node->id = element_id;
    node->data = element.unicast;
    node->occurrence = init_occurrence(element_id);
    xcc_stack_increment(pdata->nodes, node);
}

static void xgr_end_handler(void *data, const char *el)
{
    XCCParserData *pdata = (XCCParserData *) data;
    XCCNode *node, *pnode;
    void *p;
    int element_id, parent_id, parent_child, skip = 0;
    XCCEType element, pelement;
    char *cdata = pdata->cbuffer;

    if (pdata->error) {
        return;
    }

    xcc_stack_get_last(pdata->nodes, &p);
    node = p;
    element_id = node->id;
    element.unicast = node->data;
    switch (element_id) {
    case 14: /* #EStrText */
        {
#line 875 "grace.xcc"

            *element.string = utf2iso(cdata);
        
#line 5969 "xml_in.c"
        }
        break;
    case 53: /* #EStrCell */
        {
#line 1742 "grace.xcc"

            *element.cell = utf2iso(cdata);
        
#line 5978 "xml_in.c"
        }
        break;
    }

    if (node->occurrence) {
        unsigned int i;
        for (i = 0; i < 65; i++) {
            if (node->occurrence[i].occurred < node->occurrence[i].minOccurs) {
                char *cname = get_element_name_by_id(i + 1);
                if (!pdata->exception_handler(XCC_EEMIN, cname, node->name, pdata->udata)) {
                    pdata->error = 1;
                }
            }
        }
    }

    xcc_stack_decrement(pdata->nodes);
    if (xcc_stack_depth(pdata->nodes) == 0) {
        pdata->root = element.unicast;
        parent_id  = 0;
        pelement.unicast = NULL;
    } else {
        xcc_stack_get_last(pdata->nodes, &p);
        pnode = p;
        parent_id  = pnode->id;
        pelement.unicast = pnode->data;
    }
    if (parent_id >= 0 && element_id >= 0) {
        parent_child = 65*parent_id + element_id;
    } else {
        parent_child = -1;
        skip = 1;
    }

    switch (parent_child) {
    case 1:
        break;
    case 74:
        {
#line 743 "grace.xcc"

            project_set_description(pelement.project, *element.string);
            xfree(*element.string);
            xfree(element.string);
        
#line 6024 "xml_in.c"
        }
        break;
    case 67:
        {
#line 748 "grace.xcc"

#line 6031 "xml_in.c"
        }
        break;
    case 73:
        {
#line 749 "grace.xcc"

            Project *pr  = project_get_data(pelement.project);
            pr->page_wpp = element.page->width;
            pr->page_hpp = element.page->height,
            pr->bgfill   = element.page->bgfill;
            pr->bgcolor  = element.page->bgcolor;
            xfree(element.page);
        
#line 6045 "xml_in.c"
        }
        break;
    case 75:
        {
#line 757 "grace.xcc"

#line 6052 "xml_in.c"
        }
        break;
    case 81:
        {
#line 758 "grace.xcc"

#line 6059 "xml_in.c"
        }
        break;
    case 106:
        {
#line 759 "grace.xcc"

#line 6066 "xml_in.c"
        }
        break;
    case 111:
        {
#line 760 "grace.xcc"

#line 6073 "xml_in.c"
        }
        break;
    case 133:
        {
#line 764 "grace.xcc"

#line 6080 "xml_in.c"
        }
        break;
    case 134:
        {
#line 765 "grace.xcc"

#line 6087 "xml_in.c"
        }
        break;
    case 135:
        {
#line 766 "grace.xcc"

#line 6094 "xml_in.c"
        }
        break;
    case 201:
        {
#line 770 "grace.xcc"

            project_add_color(xcc_get_root(pdata), element.colordef);
            colordef_free(element.colordef);
        
#line 6104 "xml_in.c"
        }
        break;
    case 267:
        {
#line 777 "grace.xcc"

            project_add_font(xcc_get_root(pdata), element.fontdef);
            fontdef_free(element.fontdef);
        
#line 6114 "xml_in.c"
        }
        break;
    case 599:
        {
#line 833 "grace.xcc"

            *pelement.string = *element.string;
            xfree(element.string);
        
#line 6124 "xml_in.c"
        }
        break;
    case 663:
        {
#line 840 "grace.xcc"

#line 6131 "xml_in.c"
        }
        break;
    case 662:
        {
#line 841 "grace.xcc"

#line 6138 "xml_in.c"
        }
        break;
    case 1059:
        {
#line 903 "grace.xcc"

            frame_set_view(pelement.frame, element.view);
            xfree(element.view);
        
#line 6148 "xml_in.c"
        }
        break;
    case 1065:
        {
#line 907 "grace.xcc"

            frame_set_outline(pelement.frame, element.line);
            xfree(element.line);
        
#line 6158 "xml_in.c"
        }
        break;
    case 1055:
        {
#line 911 "grace.xcc"

            frame_set_fillpen(pelement.frame, element.pen);
            xfree(element.pen);
        
#line 6168 "xml_in.c"
        }
        break;
    case 1063:
        {
#line 915 "grace.xcc"

#line 6175 "xml_in.c"
        }
        break;
    case 1057:
        {
#line 916 "grace.xcc"

#line 6182 "xml_in.c"
        }
        break;
    case 1081:
        {
#line 917 "grace.xcc"

#line 6189 "xml_in.c"
        }
        break;
    case 1086:
        {
#line 918 "grace.xcc"

#line 6196 "xml_in.c"
        }
        break;
    case 1123:
        {
#line 931 "grace.xcc"

            graph_set_type(pelement.graph, element.presentationspec->type);
            graph_set_bargap(pelement.graph, element.presentationspec->bargap);
            graph_set_stacked(pelement.graph, element.presentationspec->stacked);
            presentationspec_free(element.presentationspec);
        
#line 6208 "xml_in.c"
        }
        break;
    case 1125:
        {
#line 937 "grace.xcc"

            world w;
            graph_get_world(pelement.graph, &w);
            w.xg1 = element.scale->min;
            w.xg2 = element.scale->max;
            graph_set_world(pelement.graph, &w);
            graph_set_xscale(pelement.graph, element.scale->type);
            graph_set_xinvert(pelement.graph, element.scale->invert);
            xfree(element.scale);
        
#line 6224 "xml_in.c"
        }
        break;
    case 1126:
        {
#line 947 "grace.xcc"

            world w;
            graph_get_world(pelement.graph, &w);
            w.yg1 = element.scale->min;
            w.yg2 = element.scale->max;
            graph_set_world(pelement.graph, &w);
            graph_set_yscale(pelement.graph, element.scale->type);
            graph_set_yinvert(pelement.graph, element.scale->invert);
            xfree(element.scale);
        
#line 6240 "xml_in.c"
        }
        break;
    case 1127:
        {
#line 957 "grace.xcc"

            graph_set_znorm(pelement.graph, *(element.dptr));
            xfree(element.dptr);
        
#line 6250 "xml_in.c"
        }
        break;
    case 1131:
        {
#line 961 "grace.xcc"

            graph_set_locator(pelement.graph, element.glocator);
            xfree(element.glocator);
        
#line 6260 "xml_in.c"
        }
        break;
    case 1155:
        {
#line 965 "grace.xcc"

#line 6267 "xml_in.c"
        }
        break;
    case 1135:
        {
#line 966 "grace.xcc"

#line 6274 "xml_in.c"
        }
        break;
    case 1146:
        {
#line 967 "grace.xcc"

#line 6281 "xml_in.c"
        }
        break;
    case 1151:
        {
#line 968 "grace.xcc"

#line 6288 "xml_in.c"
        }
        break;
    case 1170:
        {
#line 969 "grace.xcc"

#line 6295 "xml_in.c"
        }
        break;
    case 1506:
        {
#line 1062 "grace.xcc"

            pelement.legend->font     = element.facespec->font;
            pelement.legend->color    = element.facespec->color;
            pelement.legend->charsize = element.facespec->size;
            facespec_free(element.facespec);
        
#line 6307 "xml_in.c"
        }
        break;
    case 1519:
        {
#line 1068 "grace.xcc"

            pelement.legend->boxfillpen = element.legframe->fillpen;
            pelement.legend->boxline    = element.legframe->line;
            pelement.legend->anchor     = element.legframe->anchor;
            pelement.legend->just       = element.legframe->just;
            pelement.legend->offset     = element.legframe->offset;
            xfree(element.legframe);
        
#line 6321 "xml_in.c"
        }
        break;
    case 1585:
        {
#line 1118 "grace.xcc"

            pelement.legframe->line = *(element.line);
            xfree(element.line);
        
#line 6331 "xml_in.c"
        }
        break;
    case 1575:
        {
#line 1122 "grace.xcc"

            pelement.legframe->fillpen = *(element.pen);
            xfree(element.pen);
        
#line 6341 "xml_in.c"
        }
        break;
    case 1717:
        {
#line 1150 "grace.xcc"

            pelement.glocator->pointset = element.fixedpoint->active;
            pelement.glocator->origin.x = element.fixedpoint->x;
            pelement.glocator->origin.y = element.fixedpoint->y;
            xfree(element.fixedpoint);
        
#line 6353 "xml_in.c"
        }
        break;
    case 1718:
        {
#line 1156 "grace.xcc"

            AMem *amem = quark_get_amem(xcc_get_root(pdata));
            pelement.glocator->fx = *element.format;
            pelement.glocator->fx.fstring = amem_strdup(amem, element.format->fstring);
            format_free(element.format);
        
#line 6365 "xml_in.c"
        }
        break;
    case 1719:
        {
#line 1162 "grace.xcc"

            AMem *amem = quark_get_amem(xcc_get_root(pdata));
            pelement.glocator->fy = *element.format;
            pelement.glocator->fy.fstring = amem_strdup(amem, element.format->fstring);
            format_free(element.format);
        
#line 6377 "xml_in.c"
        }
        break;
    case 1981:
        {
#line 1242 "grace.xcc"

            tickmarks *t = axisgrid_get_data(pelement.axisgrid);
            if (t) {
                t->gprops = *(element.gridprops);
            }
            xfree(element.gridprops);
        
#line 6390 "xml_in.c"
        }
        break;
    case 1982:
        {
#line 1249 "grace.xcc"

            tickmarks *t = axisgrid_get_data(pelement.axisgrid);
            if (t) {
                t->mgprops = *(element.gridprops);
            }
            xfree(element.gridprops);
        
#line 6403 "xml_in.c"
        }
        break;
    case 1984:
        {
#line 1256 "grace.xcc"

            tickmarks *t = axisgrid_get_data(pelement.axisgrid);
            t->t_spec    = element.uticks->type;
            if (t->t_spec != TICKS_SPEC_NONE) {
                int i;
                t->nticks = element.uticks->nticks;
                for (i = 0; i < t->nticks; i++) {
                    t->tloc[i] = element.uticks->tloc[i];
                }
            }
            xfree(element.uticks);
        
#line 6421 "xml_in.c"
        }
        break;
    case 1983:
        {
#line 1268 "grace.xcc"

            tickmarks *t = axisgrid_get_data(pelement.axisgrid);
            if (t) {
                t->bar = element.axisbar->line;
            }
            xfree(element.axisbar);
        
#line 6434 "xml_in.c"
        }
        break;
    case 1985:
        {
#line 1275 "grace.xcc"

            tickmarks *t = axisgrid_get_data(pelement.axisgrid);
            t->props = *(element.tickprops);
            xfree(element.tickprops);
        
#line 6445 "xml_in.c"
        }
        break;
    case 1986:
        {
#line 1280 "grace.xcc"

            tickmarks *t = axisgrid_get_data(pelement.axisgrid);
            t->mprops = *(element.tickprops);
            xfree(element.tickprops);
        
#line 6456 "xml_in.c"
        }
        break;
    case 1987:
        {
#line 1285 "grace.xcc"

            AMem *amem = quark_get_amem(pelement.axisgrid);
            tickmarks *t = axisgrid_get_data(pelement.axisgrid);
            t->tl_formula   = amem_strdup(amem, element.tlabels->transform);
            t->tl_tprops    = element.tlabels->tprops;
            t->tl_skip      = element.tlabels->skip;
            t->tl_staggered = element.tlabels->stagger;
            t->tl_format    = element.tlabels->format;
            t->tl_gap.x     = element.tlabels->offset.x;
            t->tl_gap.y     = element.tlabels->offset.y;
            t->tl_starttype = element.tlabels->autostart ? TYPE_AUTO:TYPE_SPEC;
            t->tl_start     = element.tlabels->start;
            t->tl_stoptype  = element.tlabels->autostop ? TYPE_AUTO:TYPE_SPEC;
            t->tl_stop      = element.tlabels->stop;
            t->tl_prestr    = amem_strdup(amem, element.tlabels->prepend);
            t->tl_appstr    = amem_strdup(amem, element.tlabels->append);
            tlabels_free(element.tlabels);
        
#line 6480 "xml_in.c"
        }
        break;
    case 1989:
        {
#line 1303 "grace.xcc"

#line 6487 "xml_in.c"
        }
        break;
    case 2040:
        {
#line 1311 "grace.xcc"

            pelement.gridprops->line = *(element.line);
            xfree(element.line);
        
#line 6497 "xml_in.c"
        }
        break;
    case 2105:
        {
#line 1322 "grace.xcc"

            pelement.gridprops->line = *(element.line);
            xfree(element.line);
        
#line 6507 "xml_in.c"
        }
        break;
    case 2170:
        {
#line 1329 "grace.xcc"

            pelement.axisbar->line = *(element.line);
            xfree(element.line);
        
#line 6517 "xml_in.c"
        }
        break;
    case 2248:
        {
#line 1341 "grace.xcc"

            utick_add(pelement.uticks, element.tick);
            xfree(element.tick);
        
#line 6527 "xml_in.c"
        }
        break;
    case 2300:
        {
#line 1356 "grace.xcc"

            pelement.tickprops->line = *element.line;
            xfree(element.line);
        
#line 6537 "xml_in.c"
        }
        break;
    case 2365:
        {
#line 1371 "grace.xcc"

            pelement.tickprops->line = *element.line;
            xfree(element.line);
        
#line 6547 "xml_in.c"
        }
        break;
    case 2463:
        {
#line 1409 "grace.xcc"

            pelement.tlabels->tprops = *(element.textprops);
            xfree(element.textprops);
        
#line 6557 "xml_in.c"
        }
        break;
    case 2445:
        {
#line 1413 "grace.xcc"

            AMem *amem = quark_get_amem(xcc_get_root(pdata));
            pelement.tlabels->format = *(element.format);
            pelement.tlabels->format.fstring = amem_strdup(amem, element.format->fstring);
            format_free(element.format);
        
#line 6569 "xml_in.c"
        }
        break;
    case 2581:
        {
#line 1461 "grace.xcc"

#line 6576 "xml_in.c"
        }
        break;
    case 2576:
        {
#line 1462 "grace.xcc"

#line 6583 "xml_in.c"
        }
        break;
    case 2690:
        {
#line 1494 "grace.xcc"

            object_set_line(pelement.object, element.line);
            xfree(element.line);
        
#line 6593 "xml_in.c"
        }
        break;
    case 2707:
        {
#line 1498 "grace.xcc"

            object_set_location(pelement.object, &(element.location->ap));
            xfree(element.location);
        
#line 6603 "xml_in.c"
        }
        break;
    case 2680:
        {
#line 1502 "grace.xcc"

            object_set_fillpen(pelement.object, element.pen);
            xfree(element.pen);
        
#line 6613 "xml_in.c"
        }
        break;
    case 2710:
        {
#line 1506 "grace.xcc"

            DObject *o = object_get_data(pelement.object);
            if (o) {
                o->odata = element.do_line_data;
                o->type  = DO_LINE;
            }
        
#line 6626 "xml_in.c"
        }
        break;
    case 2708:
        {
#line 1513 "grace.xcc"

            DObject *o = object_get_data(pelement.object);
            if (o) {
                o->odata = element.do_box_data;
                o->type  = DO_BOX;
            }
        
#line 6639 "xml_in.c"
        }
        break;
    case 2709:
        {
#line 1520 "grace.xcc"

            DObject *o = object_get_data(pelement.object);
            if (o) {
                o->odata = element.do_arc_data;
                o->type  = DO_ARC;
            }
        
#line 6652 "xml_in.c"
        }
        break;
    case 2974:
        {
#line 1584 "grace.xcc"

            pelement.do_line_data->arrow = *(element.arrow);
            xfree(element.arrow);
        
#line 6662 "xml_in.c"
        }
        break;
    case 3032:
        {
#line 1604 "grace.xcc"

            atext_set_ap(pelement.atext, &(element.location->ap));
            xfree(element.location);
        
#line 6672 "xml_in.c"
        }
        break;
    case 3048:
        {
#line 1608 "grace.xcc"

            atext_set_tprops(pelement.atext, element.textprops);
            xfree(element.textprops);
        
#line 6682 "xml_in.c"
        }
        break;
    case 3004:
        {
#line 1612 "grace.xcc"

            atext_set_string(pelement.atext, *element.string);
            xfree(*element.string);
            xfree(element.string);
        
#line 6693 "xml_in.c"
        }
        break;
    case 3037:
        {
#line 1617 "grace.xcc"

            AText *at = atext_get_data(pelement.atext);
            if (at) {
                at->frame_decor  = element.textframe->decor;
                at->frame_offset = element.textframe->offset;
                at->line         = element.textframe->line;
                at->fillpen      = element.textframe->fillpen;
            }
            xfree(element.textframe);
        
#line 6709 "xml_in.c"
        }
        break;
    case 3038:
        {
#line 1627 "grace.xcc"

            AText *at = atext_get_data(pelement.atext);
            if (at) {
                at->arrow_flag = element.textpointer->active;
                at->arrow      = element.textpointer->arrow;
            }
            xfree(element.textpointer);
        
#line 6723 "xml_in.c"
        }
        break;
    case 3080:
        {
#line 1648 "grace.xcc"

            pelement.textframe->line = *(element.line);
            xfree(element.line);
        
#line 6733 "xml_in.c"
        }
        break;
    case 3070:
        {
#line 1652 "grace.xcc"

            pelement.textframe->fillpen = *(element.pen);
            xfree(element.pen);
        
#line 6743 "xml_in.c"
        }
        break;
    case 3169:
        {
#line 1664 "grace.xcc"

            pelement.textpointer->arrow = *(element.arrow);
            xfree(element.arrow);
        
#line 6753 "xml_in.c"
        }
        break;
    case 3302:
        {
#line 1702 "grace.xcc"

#line 6760 "xml_in.c"
        }
        break;
    case 3301:
        {
#line 1703 "grace.xcc"

#line 6767 "xml_in.c"
        }
        break;
    case 3304:
        {
#line 1704 "grace.xcc"

#line 6774 "xml_in.c"
        }
        break;
    case 3368:
        {
#line 1714 "grace.xcc"

            ParserData *udata = (ParserData *) pdata->udata;
            ssd_set_string(udata->ss, udata->nrow, udata->ncol, *element.cell);
            xfree(*element.cell);
            xfree(element.cell);
        
#line 6786 "xml_in.c"
        }
        break;
    case 3433:
        {
#line 1729 "grace.xcc"

            ParserData *udata = (ParserData *) pdata->udata;
            double val;
            if (parse_date_or_number(xcc_get_root(pdata), *element.cell, FALSE, &val) != RETURN_SUCCESS) {
                val = 0;
            }
            ssd_set_value(udata->ss, udata->nrow, udata->ncol, val);
            xfree(*element.cell);
            xfree(element.cell);
        
#line 6802 "xml_in.c"
        }
        break;
    case 3573:
        {
#line 1766 "grace.xcc"

            set_set_dataset(pelement.set, element.dataset);
            dataset_free(quark_get_amem(pelement.set), element.dataset);
        
#line 6812 "xml_in.c"
        }
        break;
    case 3565:
        {
#line 1770 "grace.xcc"

            set_set_symbol(pelement.set, element.symbol);
            xfree(element.symbol);
        
#line 6822 "xml_in.c"
        }
        break;
    case 3566:
        {
#line 1774 "grace.xcc"

            set_set_line(pelement.set, element.setline);
            xfree(element.setline);
        
#line 6832 "xml_in.c"
        }
        break;
    case 3567:
        {
#line 1778 "grace.xcc"

            set_set_avalue(pelement.set, element.annotation);
            avalue_free(element.annotation);
        
#line 6842 "xml_in.c"
        }
        break;
    case 3569:
        {
#line 1782 "grace.xcc"

            set_set_errbar(pelement.set, element.errorbar);
            xfree(element.errorbar);
        
#line 6852 "xml_in.c"
        }
        break;
    case 3572:
        {
#line 1786 "grace.xcc"

            set_set_legstr(pelement.set, *element.string);
            xfree(*element.string);
            xfree(element.string);
        
#line 6863 "xml_in.c"
        }
        break;
    case 3600:
        {
#line 1810 "grace.xcc"

            pelement.symbol->line = *(element.line);
            xfree(element.line);
        
#line 6873 "xml_in.c"
        }
        break;
    case 3590:
        {
#line 1814 "grace.xcc"

            pelement.symbol->fillpen = *(element.pen);
            xfree(element.pen);
        
#line 6883 "xml_in.c"
        }
        break;
    case 3665:
        {
#line 1847 "grace.xcc"

            pelement.setline->line = *(element.line);
            xfree(element.line);
        
#line 6893 "xml_in.c"
        }
        break;
    case 3655:
        {
#line 1851 "grace.xcc"

            pelement.setline->fillpen = *(element.pen);
            xfree(element.pen);
        
#line 6903 "xml_in.c"
        }
        break;
    case 3763:
        {
#line 1873 "grace.xcc"

            pelement.annotation->tprops = *element.textprops;
            xfree(element.textprops);
        
#line 6913 "xml_in.c"
        }
        break;
    case 3745:
        {
#line 1877 "grace.xcc"

            AMem *amem = quark_get_amem(xcc_get_root(pdata));
            pelement.annotation->format = *element.format;
            pelement.annotation->format.fstring = amem_strdup(amem, element.format->fstring);
            format_free(element.format);
        
#line 6925 "xml_in.c"
        }
        break;
    case 3781:
        {
#line 1922 "grace.xcc"

            pelement.textprops->charsize  = element.facespec->size;
            pelement.textprops->font      = element.facespec->font;
            pelement.textprops->color     = element.facespec->color;
            xfree(element.facespec);
        
#line 6937 "xml_in.c"
        }
        break;
    case 3895:
        {
#line 1936 "grace.xcc"

            pelement.errorbar->barsize = element.barline->size;
            pelement.errorbar->pen     = element.barline->line.pen;
            pelement.errorbar->linew   = element.barline->line.width;
            pelement.errorbar->lines   = element.barline->line.style;
            xfree(element.barline);
        
#line 6950 "xml_in.c"
        }
        break;
    case 3896:
        {
#line 1944 "grace.xcc"

            pelement.errorbar->arrow_clip  = element.riserline->arrow_clip;
            pelement.errorbar->cliplen     = element.riserline->clip_length;
            pelement.errorbar->riser_linew = element.riserline->line.width;
            pelement.errorbar->riser_lines = element.riserline->line.style;
            xfree(element.riserline);
        
#line 6963 "xml_in.c"
        }
        break;
    case 3925:
        {
#line 1959 "grace.xcc"

            pelement.barline->line = *(element.line);
            xfree(element.line);
        
#line 6973 "xml_in.c"
        }
        break;
    case 3990:
        {
#line 1974 "grace.xcc"

            pelement.riserline->line = *(element.line);
            xfree(element.line);
        
#line 6983 "xml_in.c"
        }
        break;
    case 4044:
        {
#line 1981 "grace.xcc"

            *pelement.string = *element.string;
            xfree(element.string);
        
#line 6993 "xml_in.c"
        }
        break;
    case 4289:
        {
#line 2036 "grace.xcc"

            region_add_point(pelement.region, element.wpoint);
            xfree(element.wpoint);
        
#line 7003 "xml_in.c"
        }
        break;
    default:
        if (!skip) {
            pdata->exception_handler(XCC_EINTR, NULL, NULL, pdata->udata);
            pdata->error = 1;
        }
        break;
    }

    pdata->cbuflen = 0;
    if (pdata->cbufsize) {
        pdata->cbuffer[0] = '\0';
    }
}

int xgr_parse(FILE *fp, void **root, void *udata, XCCExceptionHandler exception_handler)
{
    return xcc_run(fp, root, udata, xgr_start_handler, xgr_end_handler, exception_handler);
}
#line 2043 "grace.xcc"


static int exception_handler(int ierrno,
    const char *entity, const char *context, void *udata)
{
    int handled = 0;
    
    switch (ierrno) {
    case XCC_ECNTX:
        xcc_error("unexpected \"%s\" in the context of \"%s\"", entity, context ? context:"xml");
        break;
    case XCC_EATTR:
        handled = 1;
        xcc_error("unknown attribute \"%s\" of element \"%s\"", entity, context);
        break;
    case XCC_EELEM:
        xcc_error("unknown element \"%s\" appeared in context of \"%s\"", entity, context);
        break;
    case XCC_EEMIN:
        xcc_error("underrun of occurrences of \"%s\" in the context of \"%s\"", entity, context);
        break;
    case XCC_EEMAX:
        xcc_error("overrun of occurrences of \"%s\" in the context of \"%s\"", entity, context);
        break;
    case XCC_EAREQ:
        xcc_error("required attribute \"%s\" of element \"%s\" is missing", entity, context);
        break;
    case XCC_EINTR:
        xcc_error("internal error");
        break;
    }
    
    return handled;
}


Quark *load_xgr_project(Grace *grace, char *fn)
{
    ParserData udata;
    void *p;
    Quark *project;
    FILE *fp;
    int ret;

    fp = grace_openr(grace, fn, SOURCE_DISK);
    if (fp == NULL) {
        return NULL;
    }

    udata.grace = grace;
    udata.ss    = NULL;
    udata.nrow  = -1;
    udata.ncol  = -1;
    
    ret = xgr_parse(fp, &p, &udata, exception_handler);
    project = p;

    grace_close(fp);
    
    if (ret == XCC_RETURN_SUCCESS) {
        return project;
    } else {
        quark_free(project);
        
        return NULL;
    }
}
    
#line 7093 "xml_in.c"
