/* declare.h
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */
#ifndef _G_DECARE_H
#define _G_DECARE_H

typedef enum {
  PB_UPDATE_AUDIO,
  PB_UPDATE_DATA,
  PB_NONE
} Ttypemajpbar;
  
typedef enum {
  CONF_IGNORE,
  CONF_PROG,
  CONF_DIR,
  CONF_STRING,
  CONF_BOOLEAN
} Ttypeconf;

typedef enum {
  DVD_FORMAT,
  DVD_BLANK,
  DVD_FULLBLANK
} Ttypeformatdvd;

typedef enum {
  WRITE_CD,
  WRITE_CD_MULTI,
  WRITE_DVD
} Ttypeoperation;

typedef struct {
  Ttypeconf type;
  gchar *entry;
  gchar *defaultvalue;
  guint level;
} TProgRequis;

typedef struct {
  gchar *name;  /* label du lecteur */
  GSList *dev;   /* peripheriques */
  GSList *bus;   /* liste des bus */
  gint actuperiph;
  gint  type;   /* type 15 = graveur cdrw, 1 = lecteur */
  gshort vitesse;
  gshort vitessedvd;
  gboolean manual;  /* ajouter manuelement ou non */
} Tdriveinfo;

typedef struct {
  gchar *detectline;
  gchar *useline;
  gchar *bus;
  gint priority;
} Tsearchdrive;

typedef struct {
  gchar *basecode;
  gchar *label;
  gboolean defaut;
  gint filtre;
} Tmyentry;

typedef struct {
  gulong size;
  gchar *labeldata;
  gchar *labelaudio;
} Tmediaentry;

typedef struct {
  gchar *data;
  gchar *label;
} Tdata;

/* type majeur contenant un object glade ainsi que les donnees associes */
typedef struct {
  GladeXML *xml;
  GHashTable *data;
} Tgrave;

#endif

/*
 * vim:et:ts=8:sts=2:sw=2
 */
