/* dvdrwmediainfo.c
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

/* communication avec dvd+rw-mediainfo */
#define DVDRWMEDIAINFO_MEDIA  " Mounted Media:"
#define DVDRWMEDIAINFO_DVDR "DVD+R"
#define DVDRWMEDIAINFO_DVD "DVD"
#define DVDRWMEDIAINFO_DVDPRW "DVD+RW"
#define DVDRWMEDIAINFO_DVDMRW "DVD-RW"
#define DVDRWMEDIAINFO_DISCSTATUS " Disc status:"
#define DVDRWMEDIAINFO_BLANK "blank"
#define DVDRWMEDIAINFO_COMPLETE "complete"

/* retourne les infos sur le media inser dans le lecteur */
gint get_dvdinfo(Tgrave *Ag, Tdriveinfo *Adevice, GError **Aerror)
{
  gchar Lcommandline[_BUF_SIZE];
  gboolean Lstatus;
  gchar **Lcmd;
  gchar **Larrbuf;
  gint i;
  gint Llu = _MEDIA_NONE;
  gint g_err, g_out, Lnbrarg;
  GIOChannel *Lcom;
  guint Lcomevent;
  gint Lloccont = 2;
  gint *Lpid = (gint *)sc_grave_get_data(Ag, "pid");
  GString *Loutput;
  gchar *Ldvdprg = conf_get_string("dvd+rw-mediainfo");
  gchar *Ldevicestr = get_dvdrwtools_bus(Adevice);

  if (!Ldvdprg || !Ldevicestr || !*Ldvdprg || !*Ldevicestr) return 0;
  
  g_snprintf(Lcommandline, sizeof(Lcommandline)-1, "%s %s", Ldvdprg, Ldevicestr);
_DEB("execution de [%s]\n", Lcommandline);
  if (!g_shell_parse_argv(Lcommandline, &Lnbrarg, &Lcmd, Aerror)) return 0;

  Lstatus = g_spawn_async_with_pipes(NULL, Lcmd, NULL, (GSpawnFlags) (G_SPAWN_DO_NOT_REAP_CHILD), NULL, NULL, Lpid,
      NULL, &g_out, &g_err, Aerror);
  g_strfreev(Lcmd);

  if (Lstatus == FALSE) {
    return 0;
  }

  Loutput = g_string_new("");
  sc_grave_set_data(Ag, Loutput, "buffer");
  sc_grave_set_data(Ag, &Lloccont, "loccont");

  Lcom = g_io_channel_unix_new( g_out );
  g_io_channel_set_encoding (Lcom, NULL, NULL);
  g_io_channel_set_flags( Lcom, G_IO_FLAG_NONBLOCK, NULL );
  Lcomevent = g_io_add_watch (Lcom, (G_IO_IN | G_IO_HUP | G_IO_ERR | G_IO_PRI),
                                      read_all_output_callback, Ag);

  while (Lloccont > 0) {
    gtk_main_iteration();
  }
  exit_prog(*Lpid, FALSE, Aerror, NULL);

  g_source_remove(Lcomevent);

  g_io_channel_shutdown(Lcom, FALSE, NULL);
  g_io_channel_unref(Lcom);
  g_spawn_close_pid(*Lpid);

  _DEB("Lu => [%s]\n", Loutput->str);
  if (Loutput->str) {
    Larrbuf = g_strsplit(Loutput->str, "\n", 0);

    for (i=0; Larrbuf[i]; i++) {
      if (!*Larrbuf[i]) continue;

      if (!strncmp(Larrbuf[i], DVDRWMEDIAINFO_MEDIA, strlen(DVDRWMEDIAINFO_MEDIA)-1)) {
        if (strstr(Larrbuf[i], DVDRWMEDIAINFO_DVDPRW)) {
          Llu |= _MEDIA_DVDPRW;
          Llu |= _MEDIA_DVDRew;
        } else if (strstr(Larrbuf[i], DVDRWMEDIAINFO_DVDMRW)) {
          Llu |= _MEDIA_DVDMRW;
          Llu |= _MEDIA_DVDRew;
        } else if (strstr(Larrbuf[i], DVDRWMEDIAINFO_DVDR)) {
          Llu |= _MEDIA_DVDR;
          Llu |= _MEDIA_DVDRew;
        } else if (strstr(Larrbuf[i], DVDRWMEDIAINFO_DVD)) {
          Llu |= _MEDIA_DVD;
        }
      } else if (!strncmp(Larrbuf[i], DVDRWMEDIAINFO_DISCSTATUS, strlen(DVDRWMEDIAINFO_DISCSTATUS)-1)) {
        if (strstr(Larrbuf[i], DVDRWMEDIAINFO_BLANK)) {
          Llu |= _MEDIA_BLANK;
        } else {
          Llu |= _MEDIA_NOBLANK;
        }
      }
    }

  }
  
  g_strfreev(Larrbuf);

  return Llu;
}


/*
 * vim:et:ts=8:sts=2:sw=2
 */
