/* interface.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 * 
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

/* definition des fenetres */

#include "graveman.h"
/* drag and drop */

enum {
  TARGET_URI_LIST,
  TARGET_STRING
};

GtkTargetEntry Gdndaudio[] = { {"text/uri-list", 0, TARGET_URI_LIST } };
GtkTargetEntry Gdnddata[] = { {"text/uri-list", 0, TARGET_URI_LIST } };

/* liste des medias */
GSList *Gmedialist = NULL;

#if 0
Tmediaentry Gdefaultmedia[] = {
  { 665600, N_("74 min"), N_("650 mb") },
  { 716800, N_("80 min"), N_("700 mb") },
  { 808960, N_("90 min"), N_("790 mb") },
  { 889856, N_("99 min"), N_("869 mb") },
  { 899072, N_("100 min"), N_("878 mb") },
  { 0, "", "" },
};
#endif

static Tmyentry Gtypecdaudio[] = {
  { "1260", N_("21 min"), FALSE, 0 },
  { "1380", N_("23 min"), FALSE, 0 },
  { "4440", N_("74 min"), FALSE, 0 },
  { "4800", N_("80 min"), TRUE, 0 },
  { "5400", N_("90 min"), FALSE, 0 },
  { "5940", N_("99 min"), FALSE, 0 },
  { "6000", N_("100 min"), FALSE, 0 },
  { NULL }
};

static Tmyentry Gtypecddata[] = {
  { "180", N_("180 mb"), FALSE, 0 },
  { "202", N_("202 mb"), FALSE, 0 },
  { "650", N_("650 mb"), FALSE, 0 },
  { "700", N_("700 mb"), TRUE, 0 },
  { "790", N_("790 mb"), FALSE ,0 },
  { "869", N_("869 mb"), FALSE, 0 },
  { "878", N_("878 mb"), FALSE, 0 },
  { NULL }
};

static Tmyentry Gtypedvddata[] = {
  { "4482", N_("4.7 gb"), TRUE, 0 },
  { "8964", N_("9.4 gb"), FALSE, 0 },
  { NULL }
};

Tmyentry Gtypeicosize[] = {
  { "16", N_("16x16 px"), FALSE, 0 },
  { "24", N_("24x24 px"), FALSE, 0 },
  { "32", N_("32x32 px"), FALSE, 0 },
  { "48", N_("48x48 px"), FALSE, 0 },
  { NULL }
};

/*
static Tmyentry Gtypeunit[] = {
  { "kb", N_("kb"), TRUE },
  { "mb", N_("mb"), FALSE },
  { "gb", N_("gb"), FALSE },
};*/

static Tmyentry Gmodburn[] = {
    { "dao", N_("Disk At Once - DAO (default)"), TRUE, 0 },
    { "", N_("Track At Once  - TAO"), FALSE, 0 },
    { "raw96r", N_("RAW writing - raw96r"), FALSE, 0 },
    { "raw96", N_("RAW writing - raw96"), FALSE, 0 },
    { "raw96p", N_("RAW writing - raw96p"), FALSE, 0 },
    { NULL }
  };

static Tmyentry Gisolevel[] = {
  { "1", N_("ISO 9660 level 1"), FALSE, 0 },
  { "2", N_("ISO 9660 level 2 (default)"), TRUE, 0 },
  { "3", N_("ISO 9660 level 3"), FALSE, 0 },
  { "4", N_("ISO 9660 version 2"), FALSE, 1 },
  { NULL }
};

static Tmyentry Gformatcd[] = {
    { "data", N_("CD-Rom Mode 1 (default)"), TRUE, 0 },
    { "mode2", N_("CD-Rom Mode 2"), FALSE, 0 },
    { "xa1", N_("CD-Rom XA Mode 1"), FALSE, 0 },
    { "xa2", N_("CD-Rom XA Mode 2"), FALSE, 0 },
    { NULL }
  };

void remplire_combo_vitesse(GtkComboBox *Acombo, Tdriveinfo *Adrive, gchar *Aselvalue)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  const gchar *Lname = glade_get_widget_name(GTK_WIDGET(Acombo));
  gchar *Llabel, *Lident;  
  gint i;
  gint passe = 0;
  GtkTreeIter Liter;
  gint Lmaxspeed = MAX_SPEED;
  gboolean Lselok = FALSE;
  gboolean Lisdvd = FALSE;

  if (Adrive) {
    if (strstr(Lname, "dvd")) Lisdvd = TRUE;
    Lmaxspeed = Lisdvd ? Adrive->vitessedvd : Adrive->vitesse;
  }

  gtk_list_store_clear(Ldata);

  for (i=1; 1; i++) {
    if (!Lisdvd) {
      passe = ! passe;
      if (passe) continue;
    }
    Llabel = g_strdup_printf("%dx", i);
    Lident = g_strdup_printf("%d", i);    
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, Lident, 1, Llabel, -1);

    if (Aselvalue && *Aselvalue && Lselok == FALSE) {
      if (!strcmp(Lident, Aselvalue)) {
        gtk_combo_box_set_active_iter(Acombo, &Liter);
        Lselok = TRUE;
      }
    }

    g_free(Llabel); g_free(Lident);
    
    if (i >= Lmaxspeed) break;
  }

  gtk_list_store_append(Ldata, &Liter);
  gtk_list_store_set(Ldata, &Liter, 0, "0", 1, _("Full speed"), -1);
  
  if (Lselok == FALSE) gtk_combo_box_set_active_iter(Acombo, &Liter);
}

void remplirecombo_full (GtkComboBox *Acombo, gchar *Abasename, Tmyentry *Aentry, gboolean Adoinit, gchar *Aselvalue, gint Afiltre)
{
  GtkListStore *Ldata;
  gchar *Lident;
  Tmyentry *Lcurentry;
  GtkTreeIter Liter;
  gboolean Lselok = FALSE;

  if (Adoinit == FALSE) {
    Ldata = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  } else {
    GtkCellRenderer *Lcellrender;

    Ldata = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);  
    gtk_combo_box_set_model(Acombo, GTK_TREE_MODEL(Ldata));

    gtk_cell_layout_clear(GTK_CELL_LAYOUT(Acombo));
    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombo), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombo), Lcellrender,
      "text", 1, NULL);
  }

  gtk_list_store_clear(Ldata);
  
  for (Lcurentry = Aentry; Lcurentry->label; Lcurentry++) {
    if (Afiltre > -1 && Lcurentry->filtre > Afiltre) continue;
    
    Lident = g_strdup_printf("%s%s", Abasename, Lcurentry->basecode);
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, Lident, 1, _(Lcurentry->label), -1); 

    if (!Aselvalue || !*Aselvalue) {
      if (Lcurentry->defaut == TRUE) {
        gtk_combo_box_set_active_iter(Acombo, &Liter);
        Lselok = TRUE;
      }
    } else {
      if (!strcmp(Aselvalue, Lident)) { 
        gtk_combo_box_set_active_iter(Acombo, &Liter);
        Lselok = TRUE;
      }
    }
    g_free(Lident);
  }

  /* si pas de selection alors on met le premier par defaut */
  if (Lselok == FALSE) gtk_combo_box_set_active(Acombo, 0);
}

void remplirecombograveur(GtkComboBox *Acombo, gint Aquoi, gchar *Aselvalue)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  GtkTreeIter Liter;
  GSList *Lcur;
  Tdriveinfo *Ldrive;
  gint i;
  gboolean Lselok = FALSE;
  gchar *Lcurdrive;

  if (GTK_IS_LIST_STORE(Ldata)) {
    gtk_list_store_clear(Ldata);
  }
  for (Lcur = Glistdrives, i=0; Lcur; Lcur = g_slist_next(Lcur), i++) { 
    Ldrive = (Tdriveinfo *)Lcur->data;
    if ((Aquoi & TYPE_ALLWRITER) && (! DRIVE_WRITER(Ldrive))) continue;
    if ((Aquoi & TYPE_DVDWRITER) && (! DRIVE_DVDWRITER(Ldrive))) continue;
    
    gtk_list_store_append(Ldata, &Liter);

    Lcurdrive =g_slist_nth_data(Ldrive->dev, Ldrive->actuperiph);

    gtk_list_store_set(Ldata, &Liter, 0, Ldrive, 1, 
      DRIVE_ICONE(Ldrive), 2, Ldrive->name, 3, i, -1);
    
    if (Aselvalue && *Aselvalue && Lselok==FALSE) {
      if (!strcmp(Aselvalue, Lcurdrive)) { 
        gtk_combo_box_set_active_iter(Acombo, &Liter); 
        Lselok = TRUE;
      }
    }
  }
  
  if (Aquoi & TYPE_ISO) { 
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, NULL, 1, GISOpetiteIcone, 2, _("ISO file..."), 3, -1, -1);

    if (Aselvalue && Lselok==FALSE && !strcmp(Aselvalue, "iso")) {
      gtk_combo_box_set_active_iter(Acombo, &Liter); 
      Lselok = TRUE;
    }
  }

/* si pas de selection alors on met le premier par defaut */
  if (Lselok == FALSE) gtk_combo_box_set_active(Acombo, 0);
}

void remplirelistegraveur(GtkTreeView *Aliste)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_tree_view_get_model(Aliste));
  GtkTreeIter Liter;
  gint i;
  gchar Llabeldevice[50];
  GSList *Lcur;
  Tdriveinfo *Ldrive;

  gtk_list_store_clear(Ldata);

  for (Lcur = Glistdrives, i=0; Lcur; Lcur = g_slist_next(Lcur), i++) {
    Ldrive = (Tdriveinfo *)Lcur->data;

    gtk_list_store_append(Ldata, &Liter);

    put_devicelabel(Ldrive, Llabeldevice, sizeof(Llabeldevice)-1);
    gtk_list_store_set(Ldata, &Liter, 0, i, 1, DRIVE_ICONE(Ldrive), 2,
          (gchar *)g_slist_nth_data(Ldrive->dev, Ldrive->actuperiph), 3, 
          Llabeldevice, 4, Ldrive->name, -1);
  }
}

#if 0
void remplirelistemedia(GtkTreeView *Aliste)
{
  GtkListStore *Ldata = GTK_LIST_STORE(gtk_tree_view_get_model(Aliste));
  GtkTreeIter Liter;
  GSList *Lcur;
  Tmediaentry *Lcurmedia;

  gtk_list_store_clear(Ldata);

  for (Lcur = Gmedialist; Lcur; Lcur = g_slist_next(Lcur)) {
    Lcurmedia = (Tmediaentry *)Lcur->data;
    gtk_list_store_append(Ldata, &Liter);
    gtk_list_store_set(Ldata, &Liter, 0, Lcurmedia->labeldata, 1, Lcurmedia->labelaudio, -1);
  }
}
#endif
/* menu popup sur les lecteurs/graveurs */
GtkMenu *create_gtkpopupmenudevices(GtkWidget *Aliste, Tgrave *Ag)
{
  GtkMenu *Lmenu = GTK_MENU(sc_grave_get_widget(Ag, "popupdevices"));
  GtkWidget *Litem;
  GtkTreePath *Lpath = NULL;

  /* on cherche l'object selectionne, on est pas sur qu'il y en ai un car
   * il n'y a pas forcement de peripheriques de detect */
  gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);

  Litem = GTK_WIDGET(sc_grave_get_widget(Ag, "popupdevices_edit"));
  gtk_widget_set_sensitive(Litem, Lpath ? TRUE : FALSE);
  Litem = GTK_WIDGET(sc_grave_get_widget(Ag, "popupdevices_remove"));
  gtk_widget_set_sensitive(Litem, Lpath ? TRUE : FALSE);

  if (Lpath) gtk_tree_path_free(Lpath);

  return Lmenu;
}

/* menu popup sur les character sets */
GtkMenu *create_gtkpopupmenucharset(GtkWidget *Aliste, Tgrave *Ag)
{
  GtkMenu *Lmenu = GTK_MENU(sc_grave_get_widget(Ag, "popupcharset"));
  GtkWidget *Litem;
  GtkTreePath *Lpath = NULL;

  /* on cherche l'object selectionne, on est pas sur qu'il y en ai un car
   * il n'y a pas forcement de peripheriques de detect */
  gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);

  Litem = GTK_WIDGET(sc_grave_get_widget(Ag, "popupcharset_edit"));
  gtk_widget_set_sensitive(Litem, Lpath ? TRUE : FALSE);
  Litem = GTK_WIDGET(sc_grave_get_widget(Ag, "popupcharset_remove"));
  gtk_widget_set_sensitive(Litem, Lpath ? TRUE : FALSE);

  if (Lpath) gtk_tree_path_free(Lpath);

  return Lmenu;
}

/* menu popup sur le formatage d'un dvd */
GtkMenu *create_gtkpopupmenuformatdvd(Tgrave *Ag)
{
  GtkMenu *Lmenu = GTK_MENU(sc_grave_get_widget(Ag, "popupformatdvd"));

  return Lmenu;
}

/* menu popup sur les pistes audio */
GtkMenu *create_gtkpopupmenuaudio(GtkWidget *Aliste, Tgrave *Ag)
{
  GtkMenu *Lmenu = GTK_MENU(sc_grave_get_widget(Ag, "popupaudio"));
  GtkWidget *Litem;
  GtkTreePath *Lpath = NULL;

  /* on cherche l'object selectionne, on est pas sur qu'il y en ai un car
   * on est en SELECTION_MULTIPLE */
  gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);

  Litem = GTK_WIDGET(sc_grave_get_widget(Ag, "popupaudio_removetrack"));
  if (Lpath) {
    gtk_widget_set_sensitive(Litem, TRUE);
  } else {
    gtk_widget_set_sensitive(Litem, FALSE);
  }

  if (Lpath) gtk_tree_path_free(Lpath);
   
  return Lmenu;
}

/* creation popup "affichage" */
GtkMenu *create_gtkpopupmenudisplay(GtkWidget *Aliste, Tgrave *Ag)
{
  GtkMenu *Lmenu = GTK_MENU(sc_grave_get_widget(Ag, "popupdisplay"));
  gboolean Ldispsb = conf_get_boolean("statusbar");
  GtkWidget *Litem, *Litem2;
  

  Litem = sc_grave_get_widget(Ag, "popupdisp_showstatusbar");
  Litem2 = sc_grave_get_widget(Ag, "popupdisp_hidestatusbar");
  if (Ldispsb) {
    gtk_widget_hide(Litem);
    gtk_widget_show(Litem2);
  } else {
    gtk_widget_show(Litem);
    gtk_widget_hide(Litem2);
  }

  Litem = sc_grave_get_widgetv(Ag, "popupdisp_iconsize_%s", conf_get_string("iconsize"));
  if (GTK_IS_WIDGET(Litem)) gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(Litem), TRUE);
  
  return Lmenu;
}

/* creation popup "cd/dvd data" */
GtkMenu *create_gtkpopupmenudata(GtkWidget *Aliste, Tgrave *Ag)
{
  GtkMenu *Lmenu = GTK_MENU(sc_grave_get_widget(Ag, "popupdata"));
  GtkTreeModel *Lmodel = gtk_tree_view_get_model(GTK_TREE_VIEW(Aliste));
  GtkWidget *Litem, *Litem2, *Lsep;
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Aliste));
  GtkTreeIter Liter;
  gint type;
  gint Lnumsel = gtk_tree_selection_count_selected_rows(Lselection);
  gboolean Lonlyone = TRUE;
  const gchar *Llistename = glade_get_widget_name(Aliste);
  GtkTreePath *Lpath = NULL;

  /* on cherche l'object selectionne, il peu y en avoir plusieur
   * car on est en SELECTION_MULTIPLE */

  /* focus sur le premier element si pas de focus */
  if (!Lnumsel) {
    if (!gtk_tree_model_get_iter_first(Lmodel, &Liter)) return NULL;

    gtk_tree_selection_select_iter(Lselection, &Liter);
    gtk_widget_grab_focus(Aliste);
  } else {
    /* si plusieurs elements de selectionne alors on pointe sur celui etant
     * sous le curseur */
    gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);
    if (!Lpath) {
      gtk_widget_grab_focus(Aliste);
      gtk_tree_view_get_cursor(GTK_TREE_VIEW(Aliste), &Lpath, NULL);
      if (!Lpath) return NULL;
    }
    gtk_tree_model_get_iter(Lmodel, &Liter, Lpath);
    gtk_tree_path_free(Lpath);

    Lonlyone = (Lnumsel == 1 ? TRUE : FALSE);
  }

  
  /* type nous permet de savoir le type de ligne selectionne (CD, DIR, FILE...) */
  gtk_tree_model_get(Lmodel, &Liter, 0, &type, -1);

  /* RENOMMER LE CD */
  Litem = sc_grave_get_widget(Ag, "popupdata_renamecd");
  Litem2 = sc_grave_get_widget(Ag, "popupdata_renamedvd");
  if (!strcmp(Llistename, "LISTEDVDDATA")) {
    if (type == TYPE_CD && Lonlyone) {
      gtk_widget_show(Litem2);
    } else {
      gtk_widget_hide(Litem2);
    } 
    gtk_widget_hide(Litem);
  } else {
    if (type == TYPE_CD && Lonlyone) {
      gtk_widget_show(Litem);
    } else {
      gtk_widget_hide(Litem);
    }
    gtk_widget_hide(Litem2);
  }

  /* EXPAND */
  Litem = sc_grave_get_widget(Ag, "popupdata_expand");
  if (type != TYPE_FILE && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide(Litem);
  }

  /* RENOMMER L'ELEMENT SELECTIONNE */
  Litem = sc_grave_get_widget(Ag, "popupdata_renamedirectory");
  if (type == TYPE_DIR && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide (Litem);
  }
  Litem = sc_grave_get_widget(Ag, "popupdata_renamefile");
  if (type == TYPE_FILE && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide (Litem);
  }

  /* CREER UN REPERTOIRE */
  Litem = sc_grave_get_widget(Ag, "popupdata_createdirectory");
  if (type != TYPE_FILE && Lonlyone) {
    gtk_widget_show (Litem);
  } else {
    gtk_widget_hide (Litem);
  }

  /* AJOUTER DES FICHIERS */
  /* AJOUTER DES REPERTOIRES */
  Lsep = sc_grave_get_widget(Ag, "popupdata_sep1");
  Litem = sc_grave_get_widget(Ag, "popupdata_addfile");
  Litem2 = sc_grave_get_widget(Ag, "popupdata_adddirectory");
  if (type != TYPE_FILE && Lonlyone) {
    gtk_widget_show (Lsep);
    gtk_widget_show (Litem);
    gtk_widget_show (Litem2);
  } else {
    gtk_widget_hide (Lsep);
    gtk_widget_hide (Litem);
    gtk_widget_hide (Litem2);
  }

  /* SUPPRIMER DE LA LISTE */
  Lsep = sc_grave_get_widget(Ag, "popupdata_sep2");
  Litem = sc_grave_get_widget(Ag, "popupdata_remove");
  if (type != TYPE_CD) {
    if (Lonlyone) {
      gtk_widget_show (Lsep);
    } else {
      gtk_widget_hide (Lsep);
    }
    gtk_widget_set_sensitive(Litem, TRUE);
    gtk_widget_show (Litem);

    /* suppresion des fichiers */
  } else {
    gtk_widget_hide (Lsep);
    if (Lonlyone) {
      gtk_widget_hide (Litem);
    } else {
      /* si plusieurs elements de selectionne mais que le focus
       * est sur le CD alors on affiche quand meme l'action "suppresion
       * des fichiers" dans le popup en la grisant pour que le popup
       * ne soit pas entierement vide */
      gtk_widget_set_sensitive(Litem, FALSE);
      gtk_widget_show (Litem);
    }
  }

  /* IMAGE DE BOOT */
/*  Lsep = sc_grave_get_widget(Ag, "popupdata_sep3");
  Litem = sc_grave_get_widget(Ag, "popupdata_imageboot");
  if (type == TYPE_FILE) {
    gtk_widget_show (Lsep);
    gtk_widget_show (Litem);

  } else {
    gtk_widget_hide (Lsep);
    gtk_widget_hide (Litem);
  }*/

  return Lmenu;
}

void prepare_popups(Tgrave *Ag)
{
  /* popup cd audio */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupaudio_addtrack")),
      "activate", G_CALLBACK(gtk_audio_addtrack), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupaudio_removetrack")),
      "activate", G_CALLBACK(gtk_audio_removetrack), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupaudio_append")),
      "activate", G_CALLBACK(menu_load), Ag);

  /* popup cd data */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_renamecd")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_renamedvd")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ag);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_expand")),
      "activate", G_CALLBACK(gtk_data_expandelement), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_renamefile")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_renamedirectory")),
      "activate", G_CALLBACK(gtk_data_renommerelement), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_createdirectory")),
      "activate", G_CALLBACK(gtk_data_creerrepertoire), Ag);
  sc_grave_get_widget(Ag, "popupdata_sep1");
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_addfile")),
      "activate", G_CALLBACK(gtk_data_addfile), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_adddirectory")),
      "activate", G_CALLBACK(gtk_data_adddirectory), Ag);

  sc_grave_get_widget(Ag, "popupdata_sep2");
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_remove")),
      "activate", G_CALLBACK(gtk_data_removefiles), Ag);

#if 0
  sc_grave_get_widget(Ag, "popupdata_sep3");
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdata_imageboot")),
      "activate", G_CALLBACK(gtk_def_imageboot), Ahash);
#endif

  /* popup affichage */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdisp_iconsize_48")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdisp_iconsize_32")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdisp_iconsize_24")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdisp_iconsize_16")),
      "activate", G_CALLBACK(gtk_display_updatesize), Ag);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdisp_showstatusbar")),
      "activate", G_CALLBACK(gtk_display_switchstatusbar), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupdisp_hidestatusbar")),
      "activate", G_CALLBACK(gtk_display_switchstatusbar), Ag);

  /* popup formater un dvd */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupform_format")),
      "activate", G_CALLBACK(gtk_confirm_dvdoperation), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupform_blank")),
      "activate", G_CALLBACK(gtk_confirm_dvdoperation), Ag);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Ag, "popupform_blankfull")),
      "activate", G_CALLBACK(gtk_confirm_dvdoperation), Ag);
}

/* fenetre principal */
Tgrave *manage_main_window (guint64 *Aaudiolen, guint64 *Aaudiomaxlen,
    guint64 *Adatasize, guint64 *Adatamaxsize, guint64 *Advddatasize, guint64 *Advddatamaxsize)
{
  Tgrave *Lg = sc_grave_load("window_main.glade");
  GtkWidget *Lwindow;
  GtkNotebook *Lbodycdaudio, *Lbodycddata, *Lbodycdcopy, *Lbodycdother, *Lbodydvddata;
  GtkHBox *Lmainbody;
  GtkComboBox *Lcombo;
  GtkTreeView *Ltreeaudio, *Ltreedata, *Ltopmenu, *Ltreedvddata;

  g_assert(Lg);

  Lmainbody = GTK_HBOX(sc_grave_get_widget(Lg, "mainbody"));
  Lwindow = GTK_WIDGET(sc_grave_get_widget(Lg, "topwindow"));

  sc_grave_set_data(Lg, Lwindow, "window");
  sc_grave_set_data(Lg, Aaudiolen, "audiolen");
  sc_grave_set_data(Lg, Aaudiomaxlen, "audiomaxlen");
  sc_grave_set_data(Lg, Adatasize, "datasize");
  sc_grave_set_data(Lg, Adatamaxsize, "datamaxsize");
  sc_grave_set_data(Lg, Advddatasize, "dvddatasize");
  sc_grave_set_data(Lg, Advddatamaxsize, "dvddatamaxsize");

  /* onglets page de droite */
  Lbodycdaudio = GTK_NOTEBOOK(sc_grave_get_widget(Lg, "bodycdaudio"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycdaudio), GTK_WIDGET(Lmainbody));
  Lbodycddata = GTK_NOTEBOOK(sc_grave_get_widget(Lg, "bodycddata"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycddata), GTK_WIDGET(Lmainbody));
  Lbodydvddata = GTK_NOTEBOOK(sc_grave_get_widget(Lg, "bodydvddata"));
  gtk_widget_reparent(GTK_WIDGET(Lbodydvddata), GTK_WIDGET(Lmainbody));
  Lbodycdcopy = GTK_NOTEBOOK(sc_grave_get_widget(Lg, "bodycdcopy"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycdcopy), GTK_WIDGET(Lmainbody));
  Lbodycdother = GTK_NOTEBOOK(sc_grave_get_widget(Lg, "bodycdother"));
  gtk_widget_reparent(GTK_WIDGET(Lbodycdother), GTK_WIDGET(Lmainbody));
  sc_grave_replace_data(Lg, Lbodycdaudio, "_lstclicked");

  /* mise a jour des label lorsque l'on change d'onglet dans la partie "graver un cd de donnee" */
  g_signal_connect(G_OBJECT(Lbodycddata), "switch-page", G_CALLBACK(switchpage), Lg);
  /* mise a jour des label lorsque l'on change d'onglet dans la partie "graver un dvd de donnee" */
  g_signal_connect(G_OBJECT(Lbodydvddata), "switch-page", G_CALLBACK(switchpage), Lg);

  /* bouttons barre de gauche */
  Ltopmenu = GTK_TREE_VIEW(sc_grave_get_widget(Lg, "topmenu"));

  manage_interface(Lg, MENU_NEW + COMBO_UPDATE);
  update_status_bar_display(Lg);

  g_signal_connect(G_OBJECT(Ltopmenu), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lg);
  g_signal_connect(G_OBJECT(Ltopmenu), "popup-menu", G_CALLBACK(key_popupmenu_display), Lg);


  /* signaux sur le menu */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menustartnew")), "activate",
      G_CALLBACK(menu_start_new), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menuload")), "activate",
      G_CALLBACK(menu_load), Lg);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menucdaudio")), "activate",
      G_CALLBACK(menu_active_panel), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menucddata")), "activate",
      G_CALLBACK(menu_active_panel), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menudvddata")), "activate",
      G_CALLBACK(menu_active_panel), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menucdcopy")), "activate",
      G_CALLBACK(menu_active_panel), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menucdother")), "activate",
      G_CALLBACK(menu_active_panel), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menuproperties")), "activate",
      G_CALLBACK(menu_active_proprietes), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menuquit")), "activate",
      G_CALLBACK(menu_quit), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "menuabout")), "activate",
      G_CALLBACK(on_about), Lg);
  
  prepare_combobox_vitesse(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "dstaudiospeed")));
  prepare_combobox_vitesse(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "dstcopyspeed")));
  prepare_combobox_vitesse(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "dstdataspeed")));
  prepare_combobox_vitesse(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "dstdvddataspeed")));

  /* tous les combo contenant la liste des lecteurs */
  prepare_combobox_graveur(Lg, "dstaudio");
  
  prepare_combobox_graveur(Lg, "dstdata");
  prepare_disable_when_iso(Lg, "dstdatacombo", "nbrcddata", "datamulti", "datanotfix", "datasimul", NULL);

  prepare_combobox_graveur(Lg, "dstdvddata");
  prepare_disable_when_iso(Lg, "dstdvddatacombo", "nbrdvddata", "dvddatanotfix", "dvddatasimul", NULL);

  prepare_combobox_graveur(Lg, "srccopy");
  prepare_combobox_graveur(Lg, "dstcopy");

  prepare_combobox_graveur(Lg, "dstother");
  prepare_disable_when(Lg, "dstothercombo_notcdrw", "btnerasecdrwother1", NULL);
  prepare_disable_when(Lg, "dstothercombo_notdvdrw", "btnformatdvdrwother1", NULL);

  /* checkbox continuer un cd multi session, on ne permet dans ce cas pas de faire
   * plusieurs copie a la suite */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "datamulti")), "toggled", G_CALLBACK(change_datamulti), Lg);

  
  /* on rempli les autres combo */
  remplirecombo(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "dataformat")), "", Gformatcd,
      TRUE, conf_get_string("dataformat"));
  remplirecombo(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "datamodburn")), "", Gmodburn,
      TRUE, conf_get_string("datamodburn"));
  Lcombo = GTK_COMBO_BOX(sc_grave_get_widget(Lg, "listeremplidata"));
  remplirecombo(Lcombo, "", Gtypecddata, TRUE, conf_get_string("listeremplidata")); 
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(change_remplissage), Lg);

  Lcombo = GTK_COMBO_BOX(sc_grave_get_widget(Lg, "listeremplidvddata"));
  remplirecombo(Lcombo, "", Gtypedvddata, TRUE, conf_get_string("listeremplidvddata")); 
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(change_remplissage), Lg);

  Lcombo = GTK_COMBO_BOX(sc_grave_get_widget(Lg, "listerempliaudio"));
  remplirecombo(Lcombo, "", Gtypecdaudio, TRUE, conf_get_string("listerempliaudio"));
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(change_remplissage), Lg);
 
  /* boutons "page suivante" */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnnextaudio1")), "clicked", G_CALLBACK(gonextpage), Lbodycdaudio);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnnextdata1")), "clicked", G_CALLBACK(gonextpage), Lbodycddata);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnnextdata2")), "clicked", G_CALLBACK(gonextpage), Lbodycddata);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnnextdvddata1")), "clicked", G_CALLBACK(gonextpage), Lbodydvddata);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnnextdvddata2")), "clicked", G_CALLBACK(gonextpage), Lbodydvddata);

  /* boutons "graver" */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnburnaudio2")), "clicked", G_CALLBACK(confirm_burn), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnburndata2")), "clicked", G_CALLBACK(confirm_burn), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnburndata3")), "clicked", G_CALLBACK(confirm_burn), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnburndvddata2")), "clicked", G_CALLBACK(confirm_burn), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnburndvddata3")), "clicked", G_CALLBACK(confirm_burn), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnburncopy1")), "clicked", G_CALLBACK(confirm_burn), Lg);

  /* boutons de la page "autres operations" */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnerasecdrwother1")), "clicked", G_CALLBACK(confirm_erasecdrw), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnformatdvdrwother1")), "clicked", G_CALLBACK(popup_formatdvdrw), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnfixcdother1")), "clicked", G_CALLBACK(confirm_fixcd), Lg);
  
  update_combo_graveur(Lg);

  /* menu popup sur les listes */
  Ltreeaudio = GTK_TREE_VIEW(sc_grave_get_widget(Lg, "LISTEAUDIO"));

  prepare_popups(Lg);
  prepare_listeaudio(Ltreeaudio);

  g_signal_connect(G_OBJECT(Ltreeaudio), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lg);
  g_signal_connect(G_OBJECT(Ltreeaudio), "popup-menu", G_CALLBACK(key_popupmenu_addaudio), Lg);
  g_signal_connect(G_OBJECT(Ltreeaudio), "key-release-event", G_CALLBACK(gtk_do_eventkeyrelease), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnaddtrack")), "clicked", G_CALLBACK(gtk_audio_addtrack), Lg);

  Ltreedata = GTK_TREE_VIEW(sc_grave_get_widget(Lg, "LISTEDATA"));
  prepare_listedata(Ltreedata, _("New CD"));
  g_signal_connect(G_OBJECT(Ltreedata), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lg);
  g_signal_connect(G_OBJECT(Ltreedata), "popup-menu", G_CALLBACK(key_popupmenu_addfile), Lg);
  g_signal_connect(G_OBJECT(Ltreedata), "key-release-event", G_CALLBACK(gtk_do_eventkeyrelease), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnaddfile")), "clicked", G_CALLBACK(gtk_data_addfile), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btnadddirectory")), "clicked",
      G_CALLBACK(gtk_data_adddirectory), Lg);

  Ltreedvddata = GTK_TREE_VIEW(sc_grave_get_widget(Lg, "LISTEDVDDATA"));
  prepare_listedata(Ltreedvddata, _("New DVD"));
  g_signal_connect(G_OBJECT(Ltreedvddata), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lg);
  g_signal_connect(G_OBJECT(Ltreedvddata), "popup-menu", G_CALLBACK(key_popupmenu_addfile), Lg);
  g_signal_connect(G_OBJECT(Ltreedvddata), "key-release-event", G_CALLBACK(gtk_do_eventkeyrelease), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btndvdaddfile")), "clicked", G_CALLBACK(gtk_data_addfile), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "btndvdadddirectory")), "clicked",
      G_CALLBACK(gtk_data_adddirectory), Lg);


  /* drag and drop */
  /* audio */
  gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (Ltreeaudio),
           GDK_BUTTON1_MASK, Gdndaudio, G_N_ELEMENTS (Gdndaudio), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (Ltreeaudio),
               Gdndaudio, G_N_ELEMENTS (Gdndaudio), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  g_signal_connect(G_OBJECT(Ltreeaudio), "drag-data-received", G_CALLBACK(audio_dnd_data_received), Lg);

  /* cd data */
  gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (Ltreedata),
           GDK_BUTTON1_MASK, Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY|GDK_ACTION_LINK);
  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (Ltreedata),
           Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY|GDK_ACTION_LINK);
  g_signal_connect(G_OBJECT(Ltreedata), "drag-data-received", G_CALLBACK(data_dnd_data_received),
      Lg);
  /* dvd data */
  gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (Ltreedvddata),
           GDK_BUTTON1_MASK, Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (Ltreedvddata),
           Gdnddata, G_N_ELEMENTS (Gdnddata), GDK_ACTION_MOVE|GDK_ACTION_COPY);
  g_signal_connect(G_OBJECT(Ltreedvddata), "drag-data-received", G_CALLBACK(data_dnd_data_received),
      Lg);

  /* evenement fermer la fenetre */
  g_signal_connect(G_OBJECT(Lwindow), "delete-event", G_CALLBACK(delete_event_quit), Lg);

  /* on restaure la taille et la position que la fenetre avait lors de la derniere utilisation */ 
  restore_main_window_pos(Lwindow); 

  /* on restaure les dernieres valeurs utilisees pour certains champs */
  restore_last_used_values(Lg);
  
  gtk_widget_show(Lwindow);

  return Lg;
}

/* mise a jour des listes contenant les lecteurs */
void update_combo_graveur(Tgrave *Ag)
{
  GtkComboBox *Lsrccopycombo = GTK_COMBO_BOX(sc_grave_get_widget(Ag, "srccopycombo"));
  GtkComboBox *Ldstcopycombo = GTK_COMBO_BOX(sc_grave_get_widget(Ag, "dstcopycombo"));
  GtkComboBox *Ldstdatacombo = GTK_COMBO_BOX(sc_grave_get_widget(Ag, "dstdatacombo"));
  GtkComboBox *Ldstdvddatacombo = GTK_COMBO_BOX(sc_grave_get_widget(Ag, "dstdvddatacombo"));
  GtkComboBox *Ldstaudiocombo = GTK_COMBO_BOX(sc_grave_get_widget(Ag, "dstaudiocombo"));
  GtkComboBox *Ldstothercombo = GTK_COMBO_BOX(sc_grave_get_widget(Ag, "dstothercombo"));
  GtkButton *Lbtnburnaudio2 = GTK_BUTTON(sc_grave_get_widget(Ag, "btnburnaudio2"));
  GtkButton *Lbtnburncopy1 = GTK_BUTTON(sc_grave_get_widget(Ag, "btnburncopy1"));
  GtkButton *Lbtnfixcdother1 = GTK_BUTTON(sc_grave_get_widget(Ag, "btnfixcdother1"));
  GtkButton *Lbtnerasecdrwother1 = GTK_BUTTON(sc_grave_get_widget(Ag, "btnerasecdrwother1"));
  gboolean Lreadcd, Lwritecdr, Lwritecdrw, Lreaddvd, Lwritedvd;

  get_current_matos(&Lreadcd, &Lwritecdr, &Lwritecdrw, &Lreaddvd, &Lwritedvd);
  
  remplirecombograveur(Lsrccopycombo, TYPE_ALL + TYPE_ISO, conf_get_string("srccopycombo"));
  
  remplirecombograveur(Ldstcopycombo, TYPE_ALLWRITER + TYPE_ISO, conf_get_string("dstcopycombo"));
  
  remplirecombograveur(Ldstdatacombo, TYPE_ALLWRITER + TYPE_ISO, conf_get_string("dstdatacombo"));

  remplirecombograveur(Ldstdvddatacombo, TYPE_DVDWRITER + TYPE_ISO, conf_get_string("dstdvddatacombo"));
  
  remplirecombograveur(Ldstaudiocombo, TYPE_ALLWRITER, conf_get_string("dstaudiocombo"));

  remplirecombograveur(Ldstothercombo, TYPE_ALLWRITER, conf_get_string("dstothercombo"));

  if (Lreadcd == FALSE) {
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburncopy1), FALSE);
  }
  if (Lwritecdr == FALSE) {
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburnaudio2), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnfixcdother1), FALSE);
  }
  if (Lwritecdrw == FALSE) {
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnerasecdrwother1), FALSE);
  }
/*if (Lwritedvd == FALSE) { et l'image iso ?! 
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburndvddata2), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(Lbtnburndvddata3), FALSE);
  }*/
}

GtkWidget* create_isoselection (GtkWindow *AParent, GtkFileChooserAction AType)
{
  GtkWidget *Lfileselection;

  GtkFileFilter *filterall, *filteriso;

  /* filtres pour la selection de fichiers */
  filterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(filterall, "*");
  filteriso = gtk_file_filter_new ();
  gtk_file_filter_set_name (filteriso, _("Iso images only (*.iso)"));
  gtk_file_filter_add_pattern(filteriso, "*.iso");

  Lfileselection = gtk_file_chooser_dialog_new(AType == GTK_FILE_CHOOSER_ACTION_OPEN ? 
                                                _("Select iso image source") : _("Select iso image destination"),
                        AParent, AType, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);

  gtk_dialog_set_default_response (GTK_DIALOG (Lfileselection), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filteriso);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filterall);

  return Lfileselection;
}

GtkWidget* create_addfileselection (GtkWindow *AParent)
{
  GtkWidget *Lfileselection;

  GtkFileFilter *filterall;

  /* filtres pour la selection de fichiers */
  filterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(filterall, "*");

  Lfileselection = gtk_file_chooser_dialog_new(_("Select files to add"),
      AParent, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(Lfileselection), TRUE);
  gtk_dialog_set_default_response (GTK_DIALOG (Lfileselection), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filterall);

  return Lfileselection;
}

GtkWidget* create_addpisteselection (GtkWindow *AParent)
{
  GtkWidget *Lfileselection;
  GtkFileFilter *filterall, *filterwav, *filteraudio;
  gchar Ltxt[_BUF_SIZE];
#ifdef ENABLE_MP3
  GtkFileFilter *filtermp3;
#endif
#ifdef ENABLE_OGG
  GtkFileFilter *filterogg;
#endif
#ifdef ENABLE_FLAC
  GtkFileFilter *filterflac;
#endif

  /* filtres pour la selection de fichiers */
  filterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(filterall, "*");

  filteraudio = gtk_file_filter_new ();

  g_strlcpy(Ltxt,  _("All audio files ("), sizeof(Ltxt)-1);
  if (GsupportFlac) strncat(Ltxt, "*.flac", sizeof(Ltxt)-strlen(Ltxt)-1);
  if (GsupportMp3) strncat(Ltxt, "*.mp3", sizeof(Ltxt)-strlen(Ltxt)-1);
  if (GsupportOgg) strncat(Ltxt, "*.ogg", sizeof(Ltxt)-strlen(Ltxt)-1);
  strncat(Ltxt, "*.wav)", sizeof(Ltxt)-strlen(Ltxt)-1);
  
  gtk_file_filter_set_name (filteraudio, Ltxt);

#ifdef ENABLE_FLAC
  if (GsupportFlac) {
    gtk_file_filter_add_pattern(filteraudio, "*.flac");
    filterflac = gtk_file_filter_new ();
    gtk_file_filter_set_name (filterflac, _("Flac files (*.flac)"));
    gtk_file_filter_add_pattern(filterflac, "*.flac");
  }
#endif
#ifdef ENABLE_MP3
  if (GsupportMp3) {
    gtk_file_filter_add_pattern(filteraudio, "*.mp3");
    filtermp3 = gtk_file_filter_new ();
    gtk_file_filter_set_name (filtermp3, _("Mp3 files (*.mp3)"));
    gtk_file_filter_add_pattern(filtermp3, "*.mp3");
  }
#endif
#ifdef ENABLE_OGG
  if (GsupportOgg) {
    gtk_file_filter_add_pattern(filteraudio, "*.ogg");
    filterogg = gtk_file_filter_new ();
    gtk_file_filter_set_name (filterogg, _("Ogg files (*.ogg)"));
    gtk_file_filter_add_pattern(filterogg, "*.ogg");
  }
#endif
  gtk_file_filter_add_pattern(filteraudio, "*.wav");

  filterwav = gtk_file_filter_new ();
  gtk_file_filter_set_name (filterwav, _("Wav files (*.wav)"));
  gtk_file_filter_add_pattern(filterwav, "*.wav");

  Lfileselection = gtk_file_chooser_dialog_new(_("Select audio files to add"),
      AParent, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(Lfileselection), TRUE);
  gtk_dialog_set_default_response (GTK_DIALOG (Lfileselection), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filteraudio);
#ifdef ENABLE_FLAC
  if (GsupportFlac) {
    gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filterflac);
  }
#endif
#ifdef ENABLE_MP3
  if (GsupportMp3) {
    gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filtermp3);
  }
#endif
#ifdef ENABLE_OGG
  if (GsupportOgg) {
    gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filterogg);
  }
#endif  
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filterwav);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), filterall);

  return Lfileselection;
}

GtkWidget* create_adddirselection (GtkWindow *AParent)
{
  GtkWidget *Lfileselection;
  GtkFileFilter *Lfilterall;

  /* filtres pour la selection de fichiers */
  Lfilterall = gtk_file_filter_new ();
  gtk_file_filter_set_name (Lfilterall, _("All files (*.*)"));
  gtk_file_filter_add_pattern(Lfilterall, "*");
  Lfileselection = gtk_file_chooser_dialog_new(_("Select directories to add"),
      AParent, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(Lfileselection), TRUE);
  gtk_dialog_set_default_response (GTK_DIALOG (Lfileselection), GTK_RESPONSE_ACCEPT);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (Lfileselection), Lfilterall);

  return Lfileselection;
}

/* boite de dialogue "edition media" */
#if 0
GHashTable *addmediaformat(GHashTable *Aparent)
{
  gchar *Ltemplate = PACKAGE_DATA_DIR "/" PACKAGE "/dialog_media.glade";
  GladeXML *Lxml = glade_xml_new(Ltemplate, NULL,NULL);
  GtkWidget *Ldialog;
  GHashTable *Lhash = _hash();
  gulong Lsize = 0;
  GtkComboBox *Lcombo;

  if (!Lxml) {
    g_error("Cannot load '%s': %s\n", Ltemplate, g_strerror(errno));
  }
  Ldialog = glade_to_hash(Lxml, Lhash, "dialog_media"); 

  g_hash_table_insert(Lhash, "fullsize", &Lsize);
  
  g_signal_connect(G_OBJECT(glade_to_hash(Lxml, Lhash, "mediadata")), "value-changed",
      G_CALLBACK(update_media_fields), Lhash);

  Lcombo = GTK_COMBO_BOX(glade_to_hash(Lxml, Lhash, "mediadataunit"));
  remplirecombo(Lcombo, "", Gtypeunit, TRUE);
  g_signal_connect(G_OBJECT(Lcombo), "changed", G_CALLBACK(update_media_unit), Lhash);

  glade_to_hash(Lxml, Lhash, "labelmediadata");
  glade_to_hash(Lxml, Lhash, "labelmediaaudio");

  return Lhash;
}
#endif

/* boite de dialogue "editer un peripherique" */
Tgrave *create_dialog_edit_device(GtkWidget *Aparent, Tdriveinfo *Adrive)
{
  Tgrave *Lg = sc_grave_load("dialog_device.glade");
  GtkWidget *Ldialog;
  GtkComboBox *Lcombobox;

  g_assert(Lg);

  Ldialog = sc_grave_get_widget(Lg, "dialog_device");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  sc_grave_ref_wtd(Lg, "dialog_device", "window");

  gtk_entry_set_text(GTK_ENTRY(sc_grave_get_widget(Lg, "devicename")), Adrive->name);
  Lcombobox = GTK_COMBO_BOX(sc_grave_get_widget(Lg, "devicebus"));

  manage_combobox_devicebus(Lcombobox, Adrive);

  return Lg;
}

/* boite de dialogue "ajouter un peripherique" */
Tgrave *create_dialog_add_device(GtkWidget *Aparent)
{
  Tgrave *Lg = sc_grave_load("dialog_add_device.glade");
  GtkWidget *Ldialog;

  g_assert(Lg);

  Ldialog = sc_grave_get_widget(Lg, "dialog_add_device");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  sc_grave_ref_wtd(Lg, "dialog_add_device", "window");

  gtk_entry_set_text(GTK_ENTRY(sc_grave_get_widget(Lg, "devicename")), _("New device"));

  return Lg;
}


/* boite de dialogue "a propos de ..." */
void about_graveman (void)
{
  Tgrave *Lg = sc_grave_load("dialog_about.glade");
  GtkWidget *Ldialog;
  GtkLabel *Llabelversion;
  gchar *Ltmp;

  g_assert(Lg);

  Llabelversion = GTK_LABEL(sc_grave_get_widget(Lg, "version"));

  Ltmp = g_strdup_printf(_("version %s - http://www.nongnu.org/graveman"), VERSION);
  gtk_label_set_label(Llabelversion, Ltmp);
  g_free(Ltmp);

  Ldialog = sc_grave_get_widget(Lg, "dialog_about");
  gtk_dialog_run(GTK_DIALOG(Ldialog));
  gtk_widget_destroy(Ldialog);

  sc_grave_destroy(Lg);
}

void hide_some_progressbar(Tgrave *Ag)
{
  GtkWidget *Lpbfifo = sc_grave_get_widget(Ag, "pb_fifo");
  GtkWidget *Lpbbuffer = sc_grave_get_widget(Ag, "pb_buffer");
  GtkWidget *Llfifo = sc_grave_get_widget(Ag, "l_fifo");
  GtkWidget *Llbuffer = sc_grave_get_widget(Ag, "l_buffer");

  gtk_widget_hide(Lpbfifo); 
  gtk_widget_hide(Llfifo); 
  gtk_widget_hide(Lpbbuffer); 
  gtk_widget_hide(Llbuffer); 
}

/* fenetre gravure d'un cd en cours */
void show_graverwindow (Tgrave *Ag, gchar *Aaction, gchar *Atitle)
{
  Tgrave *Lburng = sc_grave_load("window_burn.glade");
  GtkWidget *Lwindowburn;
  GtkLabel *Ltitle;
  GtkProgressBar *Lpbtotal, *Lpbstep, *Lpbfifo, *Lpbbuffer;
  gint Ltotaldone = 0;
  gint Lpid = 0, Lpid2 = 0;
  gboolean Labort = FALSE;
  gboolean Lbackvalue = FALSE;
  gint Lcont = 1;
  GtkWidget *Lstatusbox = NULL;
  GtkWidget *Lparent = GTK_WIDGET(sc_grave_get_widget(Ag, "topwindow"));
  GError *Lerror = NULL;

  g_assert(Lburng);

  Lwindowburn = sc_grave_get_widget(Lburng, "window_burn"); 
  gtk_window_set_transient_for(GTK_WINDOW(Lwindowburn), GTK_WINDOW(Lparent));

  /* barres de progression */
  Lpbtotal = GTK_PROGRESS_BAR(sc_grave_get_widget(Lburng, "pb_total"));
  Lpbstep = GTK_PROGRESS_BAR(sc_grave_get_widget(Lburng, "pb_step"));

  /* pour la conversion des fichiers audio et la pulse bar */
  Lpbfifo = GTK_PROGRESS_BAR(sc_grave_get_widget(Lburng, "pb_fifo"));
  Lpbbuffer = GTK_PROGRESS_BAR(sc_grave_get_widget(Lburng, "pb_buffer"));
  Ltitle = GTK_LABEL(sc_grave_get_widget(Lburng, "gravetitle"));

  if (Atitle && *Atitle) {
    gtk_label_set_text(Ltitle, Atitle);
  }

  /* on attache les variables utilisees lors de l'operation */
  sc_grave_set_data(Ag, Lwindowburn, "window_burn");
  sc_grave_set_data(Ag, Ltitle, "gravetitle");
  sc_grave_set_data(Ag, Lpbtotal, "pb_total");
  sc_grave_set_data(Ag, Lpbstep, "pb_step");
  sc_grave_set_data(Ag, Lpbstep, "progress");
  sc_grave_set_data(Ag, Lpbfifo, "pb_fifo");
  sc_grave_set_data(Ag, Lpbbuffer, "pb_buffer");
  
  sc_grave_set_data(Ag, &Ltotaldone, "totaldone");
  sc_grave_set_data(Ag, &Labort, "gabort");  /* operation annulee par l'utilisateur ? */
  sc_grave_set_data(Ag, &Lpid, "pid");
  sc_grave_set_data(Ag, &Lcont, "cont");
  sc_grave_set_data(Ag, &Lpid2, "pid2");

  /* bouton annuler l'operation */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lburng, "btncancelburn")), "clicked", G_CALLBACK(abort_gravure), Ag);
  g_signal_connect(G_OBJECT(Lwindowburn), "delete_event", GTK_SIGNAL_FUNC(on_deleteevent_gravure), Ag);

  /* lancement de l'operation en elle meme */
  if (g_str_has_prefix(Aaction, "btnburncopy")) {
    Lbackvalue = burn_copy(Ag, &Lerror);
  } else if (g_str_has_prefix(Aaction, "btnburnaudio")) {
    Lbackvalue = burn_audio(Ag, &Lerror);
  } else if (g_str_has_prefix(Aaction, "btnburndata")) {
    Lbackvalue = burn_data(Ag, &Lerror);
  } else if (g_str_has_prefix(Aaction, "btnburndvddata")) {
    hide_some_progressbar(Lburng);
    Lbackvalue = burn_dvddata(Ag, &Lerror);
  }

  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindowburn),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else {
    
    /* pour plus de beaute on s'assure que les barres de progression aient les bonnes
     * valeurs :-) */
    gtk_progress_bar_set_fraction(Lpbtotal, 1);
    gtk_progress_bar_set_fraction(Lpbstep, 1);
    gtk_progress_bar_set_fraction(Lpbfifo, 0);
    gtk_progress_bar_set_fraction(Lpbbuffer, 0);
    gtk_progress_bar_set_text(Lpbtotal, "100%");
    gtk_progress_bar_set_text(Lpbstep, "100%");
    gtk_progress_bar_set_text(Lpbfifo, "0%");
    gtk_progress_bar_set_text(Lpbbuffer, "0%");
    
    if (Lbackvalue == FALSE) {
      gtk_label_set_text(Ltitle, _("Operation failed"));
      
      Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindowburn),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
                      Lerror ? Lerror->message : _("Operation failed"));
    } else {
      gtk_label_set_text(Ltitle, _("Operation successful."));

      Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwindowburn),
                GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
                _("Operation successful"));
    }
  }

  if (Lstatusbox) {
    gtk_dialog_run(GTK_DIALOG(Lstatusbox));
    gtk_widget_destroy(Lstatusbox);
  }

  gtk_widget_destroy(Lwindowburn);
  sc_grave_destroy(Lburng);
  if (Lerror) g_error_free(Lerror);
}
  
/* fenetre "operation en cours" */
Tgrave *create_window_encours(GtkWidget *Aparent)
{
  Tgrave *Lg = sc_grave_load("window_inprogress.glade");

  g_assert(Lg);

  if (GTK_IS_WIDGET(Aparent)) {
    gtk_window_set_transient_for(GTK_WINDOW(sc_grave_get_widget(Lg, "window_inprogress")), GTK_WINDOW(Aparent));
  }

  return Lg;
}

void prepare_combobox_vitesse(GtkComboBox *Acombobox)
{
  if (GTK_IS_WIDGET(Acombobox)) {
    GtkListStore *Lmodel = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);  
    GtkCellRenderer *Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
    gtk_combo_box_set_model(Acombobox, GTK_TREE_MODEL(Lmodel));
    
    gtk_cell_layout_clear(GTK_CELL_LAYOUT(Acombobox));
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombobox), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombobox), Lcellrender,
      "text", 1, NULL);
  }
}

/* objets a cacher lorsque l'on selectionne une image iso en tant que source ou destination */
void prepare_disable_when_iso(Tgrave *Ag, gchar *Abasename, const gchar *Afirst, ...)
{
  va_list Largs;
  gchar *Lbuf = (gchar *) Afirst;
  gint Lnbr = 0;
  gchar *Lname = g_strdup_printf("%s_isotodisabled%d", Abasename, Lnbr++);
  gchar *Lcur;

  sc_grave_ref_wtd(Ag, Lbuf, Lname);

  va_start(Largs, Afirst);
  while (*Lbuf++) {
    if (!(Lcur = va_arg(Largs, gchar *))) break;
    
    Lname = g_strdup_printf("%s_isotodisabled%d", Abasename, Lnbr++);
    sc_grave_ref_wtd(Ag, Lcur, Lname);
  }

  va_end(Largs);
}

/* objets a cacher lorsque l'on selectionne une image iso en tant que source ou destination */
void prepare_disable_when(Tgrave *Ag, gchar *Abasename, const gchar *Afirst, ...)
{
  va_list Largs;
  gchar *Lbuf = (gchar *) Afirst;
  gint Lnbr = 0;
  gchar *Lname = g_strdup_printf("%stodisabled%d", Abasename, Lnbr++);
  gchar *Lcur;

  sc_grave_ref_wtd(Ag, Lbuf, Lname);

  va_start(Largs, Afirst);
  while (*Lbuf++) {
    if (!(Lcur = va_arg(Largs, gchar *))) break;
    
    Lname = g_strdup_printf("%stodisabled%d", Abasename, Lnbr++);
    sc_grave_ref_wtd(Ag, Lcur, Lname);
  }

  va_end(Largs);
} 

void gtk_toggle_top_menu(GtkTreeView *Atopmenu, gpointer Adata)
{
  Tgrave *Lg = (Tgrave *)Adata;
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(Atopmenu);
  GtkTreeIter Liter;
  gchar *Lident;
  GtkNotebook *Llstclick = sc_grave_get_data(Lg, "_lstclicked"); /* dernier element ayant eu le focus */
  GtkNotebook *Lnewclick;
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(Atopmenu);

  if (!gtk_tree_selection_get_selected(Lselection, &Ltreemodel, &Liter)) return;

  gtk_tree_model_get(Ltreemodel, &Liter, 0, &Lident, -1);
  Lnewclick = GTK_NOTEBOOK(sc_grave_get_widget(Lg, Lident));
  if (GTK_IS_NOTEBOOK(Lnewclick)) {
    if (GTK_IS_NOTEBOOK(Llstclick)) {
      gtk_widget_hide(GTK_WIDGET(Llstclick));
    }
    sc_grave_replace_data(Lg, Lnewclick, "_lstclicked");

    gtk_widget_show(GTK_WIDGET(Lnewclick));

    /* pointeur sur la liste courante pour plus de simplicite */
    if (!strcmp(Lident, "bodycddata")) {
      sc_grave_replace_data(Lg, sc_grave_get_widget(Lg, "LISTEDATA"), "_current_list");
    } else if (!strcmp(Lident, "bodydvddata")) {
      sc_grave_replace_data(Lg, sc_grave_get_widget(Lg, "LISTEDVDDATA"), "_current_list");
    }
  }
  g_free(Lident);
}

/* status bar */
void update_status_bar_display(Tgrave *Ag)
{
  gboolean Ldispsb = conf_get_boolean("statusbar");
  GtkWidget *Ldisp = sc_grave_get_widget(Ag, "statusbar");

  if (Ldispsb) {
    gtk_widget_show(Ldisp);
  } else {
    gtk_widget_hide(Ldisp);
  }
}

/* mise a jour interface */
void manage_interface(Tgrave *Ag, gint Aaction)
{
  GtkListStore *Lmodel;
  GtkTreeView *Ltopmenu = GTK_TREE_VIEW(sc_grave_get_widget(Ag, "topmenu"));
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(Ltopmenu);
  GtkTreeIter Liter;
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  if (Aaction & MENU_NEW) {
    Lmodel = gtk_list_store_new(3, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_STRING);
    gtk_tree_selection_set_mode(Lselection, GTK_SELECTION_BROWSE);
    gtk_tree_view_set_model(Ltopmenu, GTK_TREE_MODEL(Lmodel));

    /* creation colonnes */
    Lcellrender = gtk_cell_renderer_pixbuf_new();
    Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
     gtk_tree_view_append_column(GTK_TREE_VIEW(Ltopmenu), Lcell);
	
    Lcellrender = gtk_cell_renderer_pixbuf_new();
    Lcellrender = gtk_cell_renderer_text_new();
    Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(Ltopmenu), Lcell);
    Lcellrender = gtk_cell_renderer_pixbuf_new();

    g_signal_connect(G_OBJECT(Ltopmenu), "cursor-changed", G_CALLBACK(gtk_toggle_top_menu), Ag); 
  } else {
    Lmodel = GTK_LIST_STORE(gtk_tree_view_get_model(Ltopmenu));
    gtk_list_store_clear(Lmodel);
  }

  /* les icones en elles meme */
  prepare_menu_images(Ag);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycdaudio", 1, GMenuAudio, 2, _("Audio CD"), -1);
  gtk_tree_selection_select_iter(Lselection, &Liter);
  gtk_toggle_top_menu(Ltopmenu, Ag);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycddata", 1, GMenuData, 2, _("Data CD"), -1);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodydvddata", 1, GMenuDvd, 2, _("Data DVD"), -1);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycdcopy", 1, GMenuCopy, 2, _("Duplicate CD"), -1);

  gtk_list_store_append(Lmodel, &Liter);
  gtk_list_store_set(Lmodel, &Liter, 0, "bodycdother", 1, GMenuOther, 2, _("Other operations"), -1);
 
  gtk_tree_view_columns_autosize(Ltopmenu); 

  /* mise a jour combo "iso level" */
  if (Aaction & COMBO_UPDATE) {
    remplirecombo_full(GTK_COMBO_BOX(sc_grave_get_widget(Ag, "dataisolevel")), "", Gisolevel,
        TRUE, conf_get_string("dataisolevel"), conf_get_int("mkisofs_support_isov2"));
  }
}

    
/* preparation du combo contenant la liste du peripherique a utiliser */
void prepare_combobox_graveur(Tgrave *Ag, gchar *Abasename)
{
  GtkComboBox *Lcombobox = GTK_COMBO_BOX(sc_grave_get_widgetv(Ag, "%scombo", Abasename));
  if (GTK_IS_COMBO_BOX(Lcombobox)) {
    GtkListStore *Lmodel = gtk_list_store_new(4, G_TYPE_POINTER, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_INT);
    GtkCellRenderer *Lcellrender;
    GtkWidget *Lbtniso = sc_grave_get_widgetv(Ag, "%sbtn", Abasename);
 
    gtk_combo_box_set_model(Lcombobox, GTK_TREE_MODEL(Lmodel));
    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_pixbuf_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Lcombobox), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Lcombobox), Lcellrender,
      "pixbuf", 1, NULL);                    
    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Lcombobox), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Lcombobox), Lcellrender,
      "text", 2, NULL);

    g_signal_connect(G_OBJECT(Lcombobox), "changed", G_CALLBACK(on_selectgraveur), Ag);
      /* il y a peutetre un champ "image iso" associe a ce combo graveur */

    if (GTK_IS_BUTTON(Lbtniso)) {
      g_signal_connect(G_OBJECT(Lbtniso), "clicked", G_CALLBACK(gtk_file_sel), Ag);
    }
  }
}

void manage_combobox_devicebus(GtkComboBox *Acombobox, Tdriveinfo *Adrive)
{
  GtkListStore *Lmodel = gtk_list_store_new(2, G_TYPE_INT, G_TYPE_STRING);
  GtkCellRenderer *Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
  GtkTreeIter Liter;
  GSList *Lcur;
  gint i;

  gtk_combo_box_set_model(Acombobox, GTK_TREE_MODEL(Lmodel));

  gtk_cell_layout_clear(GTK_CELL_LAYOUT(Acombobox));
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombobox), Lcellrender, TRUE);
  gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombobox), Lcellrender,
    "text", 1, NULL);
  
  for(Lcur = Adrive->dev, i=0; Lcur; Lcur = g_slist_next(Lcur), i++) {
    gtk_list_store_append(Lmodel, &Liter);
    gtk_list_store_set(Lmodel, &Liter, 0, i, 1, (gchar *)Lcur->data, -1);
    if (i==Adrive->actuperiph) gtk_combo_box_set_active_iter(Acombobox, &Liter);
  }
}

#if 0
void prepare_properties_mediatreeview(GtkTreeView *Atreeview)
{
  GtkListStore *Lmodel = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_view_set_model(Atreeview, GTK_TREE_MODEL(Lmodel));

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(("Label for Audio media"), Lcellrender, "text", 0, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(("Label for Data media"), Lcellrender, "text", 1, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);
}
#endif

void prepare_properties_devicestreeview(GtkTreeView *Atreeview)
{
  GtkListStore *Lmodel = gtk_list_store_new(5, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING,
                G_TYPE_STRING, G_TYPE_STRING);
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_view_set_model(Atreeview, GTK_TREE_MODEL(Lmodel));

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_pixbuf_new();
  Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Location"), Lcellrender, "text", 2, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Type"), Lcellrender, "text", 3, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Name"), Lcellrender, "text", 4, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeview), Lcell);

}

void prepare_listeaudio(GtkTreeView *Atreeaudio)
{
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Atreeaudio));
  GtkListStore *Lmodel = gtk_list_store_new(7, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING,
                        G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_selection_set_mode(Lselection, GTK_SELECTION_MULTIPLE);

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_pixbuf_new();
  Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);
	
  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Track"), Lcellrender, "text", 2, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Length"), Lcellrender, "text", 3, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Location"), Lcellrender, "text", 4, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(Atreeaudio), Lcell);

  gtk_tree_view_set_model(Atreeaudio, GTK_TREE_MODEL(Lmodel));
}

void prepare_listedata(GtkTreeView *Atreedata, gchar *Atitle)
{
  GtkTreeSelection *Lselection = gtk_tree_view_get_selection(GTK_TREE_VIEW(Atreedata));
  GtkTreeStore *Lmodel = gtk_tree_store_new(7, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING,
                                G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);
  GtkTreeIter Liter;
  GtkCellRenderer *Lcellrender;
  GtkTreeViewColumn *Lcell;

  gtk_tree_selection_set_mode(Lselection, GTK_SELECTION_MULTIPLE);
  gtk_tree_view_set_enable_search(Atreedata, TRUE);
  gtk_tree_view_set_model(Atreedata, GTK_TREE_MODEL(Lmodel));

  /* creation colonnes */
  Lcellrender = gtk_cell_renderer_pixbuf_new();
  Lcell = gtk_tree_view_column_new_with_attributes("", Lcellrender, "pixbuf", 1, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);
	
  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Name"), Lcellrender, "text", 2, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Size"), Lcellrender, "text", 3, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);

  Lcellrender = gtk_cell_renderer_text_new();
  Lcell = gtk_tree_view_column_new_with_attributes(_("Location"), Lcellrender, "text", 4, NULL);
  gtk_tree_view_append_column(Atreedata, Lcell);

  /* icone de base dans la liste des fichiers */
  gtk_tree_store_append(GTK_TREE_STORE(Lmodel), &Liter, NULL);
  gtk_tree_store_set(Lmodel, &Liter, 0, TYPE_CD, 1, GCDpetiteIcone, 2, Atitle, 3, "", 4, "", 5, "", 6, 0, -1);
}

/* fenetre de confirmation avec une checkbox */
Tgrave *create_dialog_confirm_operation (GtkWidget *Aparent,
    gchar *Alabel, gchar *Acheckboxlbl, gboolean Acheckboxstatus)
{
  Tgrave *Lg = sc_grave_load("dialog_confirm_operation.glade");
  GtkWidget *Ldialog;
  GtkToggleButton *Ltoggleoption;

  g_assert(Lg);

  Ldialog = sc_grave_get_widget(Lg, "dialog_confirm_operation");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  sc_grave_set_data(Lg, Ldialog, "window");

  /* titre */
  gtk_label_set_text(GTK_LABEL(sc_grave_get_widget(Lg, "label")), Alabel);
  
  /* effacer les cdrw en mode fast ? */
  Ltoggleoption = GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "checkbox"));
  if (Acheckboxlbl) {
    gtk_toggle_button_set_active(Ltoggleoption, Acheckboxstatus);
    gtk_button_set_label(GTK_BUTTON(Ltoggleoption), Acheckboxlbl);
  } else {
    gtk_widget_hide(GTK_WIDGET(Ltoggleoption));
  }

  return Lg;
}

/* fenetre selection d'une operation sur un dvd */
Tgrave *create_dialog_select_dvdoperation (GtkWidget *Aparent, gint Atypedvd)
{
  Tgrave *Lg = sc_grave_load("dialog_select_operation.glade");
  GtkWidget *Ldialog;

  g_assert(Lg);

  Ldialog = sc_grave_get_widget(Lg, "dialog_select_operation");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  sc_grave_set_data(Lg, Ldialog, "window");

  /* commencer une session ou merger ? */
  if (Atypedvd & _MEDIA_BLANK) {
    /* si le dvd est vide alors c'est forcement pour la commencer, on cache
     * donc la case a cocher "merger" */
    gtk_widget_hide(sc_grave_get_widget(Lg, "burnmerge"));
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "burninitial")), TRUE);

  return Lg;
}

/* premiere utilisation de graveman, bienvenue ! */
void welcome_to_graveman(void)
{
  Tgrave *Lg = sc_grave_load("dialog_welcome.glade");
  GtkWidget *Ldialog;

  g_assert(Lg);

  Ldialog = sc_grave_get_widget(Lg, "dialog_welcome"); 

  gtk_dialog_run(GTK_DIALOG(Ldialog));
  gtk_widget_destroy(Ldialog);
  sc_grave_destroy(Lg);
}

/* mise a jour d'une bar indicant le remplissage, passage en rouge si le cd est plein */
void switch_pbar_status(GtkProgressBar *Apbar, guint64 Amaxlen, guint64 Acurlen, Ttypemajpbar Aupdatetext) {
  gdouble Lpremp = (1.0/Amaxlen)*Acurlen;
  if (Lpremp>1) { 
    GdkColor Lcolor;
    gdk_color_parse ("red", &Lcolor);
    Lpremp = 1;
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_NORMAL, &Lcolor);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_ACTIVE, &Lcolor);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_PRELIGHT, &Lcolor);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_SELECTED, &Lcolor);
  } else {
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_NORMAL, NULL);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_ACTIVE, NULL);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_PRELIGHT, NULL);
    gtk_widget_modify_bg (GTK_WIDGET(Apbar), GTK_STATE_SELECTED, NULL);
  }
  gtk_progress_bar_set_fraction(Apbar, Lpremp);

  if (Aupdatetext != PB_NONE) {
    gchar *Ltmp = Aupdatetext == PB_UPDATE_AUDIO ? format_length(Acurlen) : format_size(Acurlen);
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(Apbar), Ltmp);
    g_free(Ltmp);
  }
}

/* effacer un cd reinscriptible */
void show_erasecdrwwindow(Tgrave *Ag)
{
  GtkWidget *Lwindow1 = sc_grave_get_data(Ag, "window");
  Tgrave *Lerasecdg = create_window_encours(Lwindow1);
  gint Lcont = 2;
  gint Lpid;
  gboolean Loperationstatus = FALSE;
  gboolean Labort = FALSE;
  GtkWidget *Lwin;
  GError *Lerror = NULL;
  GtkWidget *Lstatusbox = NULL;

  Lwin = sc_grave_get_widget(Lerasecdg, "window_inprogress"); 
  gtk_label_set_text(GTK_LABEL(sc_grave_get_widget(Lerasecdg, "labelava")), _("Erasing CD-RW in progress, please wait..."));

  
  sc_grave_set_data(Ag, &Lcont, "cont");
  sc_grave_set_data(Ag, &Lpid, "pid");
  sc_grave_set_data(Ag, &Labort, "gabort");
  sc_grave_set_data(Ag, &Lerror, "gerror");
  sc_grave_set_data(Ag, sc_grave_get_widget(Lerasecdg, "progress"), "progress");
  sc_grave_set_data(Ag, &Loperationstatus, "operationstatus");

  /* bouton annuler */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lerasecdg, "cancelbtn")), "clicked", G_CALLBACK(abort_encours), Ag);
  g_signal_connect(G_OBJECT(Lwin), "delete-event", G_CALLBACK(delete_event_encours), Ag);

  gtk_widget_show(Lwin);
  g_timeout_add(500, encours_callback, Ag);

  /* operation en elle meme */
  perform_erase_cdrw(Ag, &Lerror);
  
  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else if (Lerror) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                      Lerror->message);
  } else {
     Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
               GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
               _("Operation successful"));
  }
  gtk_dialog_run(GTK_DIALOG(Lstatusbox));
  gtk_widget_destroy(Lstatusbox);
  
  gtk_widget_destroy(Lwin);
  sc_grave_destroy(Lerasecdg);

  if (Lerror) g_error_free(Lerror);
}

/* cloturer un cd */
void show_fixcdwindow(Tgrave *Ag)
{
  GtkWidget *Lwindow1 = sc_grave_get_data(Ag, "window");
  Tgrave *Lfixcdg = create_window_encours(Lwindow1);
  gint Lcont = 2;
  gint Lpid;
  gboolean Loperationstatus = FALSE;
  gboolean Labort = FALSE;
  GtkWidget *Lwin;
  GError *Lerror = NULL;
  GtkWidget *Lstatusbox = NULL;

  Lwin = sc_grave_get_widget(Lfixcdg, "window_inprogress"); 
  gtk_label_set_text(GTK_LABEL(sc_grave_get_widget(Lfixcdg, "labelava")), _("Fixating CD-R in progress, please wait..."));
  
  sc_grave_set_data(Ag, &Lcont, "cont");
  sc_grave_set_data(Ag, &Lpid, "pid");
  sc_grave_set_data(Ag, &Labort, "gabort");
  sc_grave_set_data(Ag, &Lerror, "gerror");
  sc_grave_set_data(Ag, sc_grave_get_widget(Lfixcdg, "progress"), "progress");
  sc_grave_set_data(Ag, &Loperationstatus, "operationstatus");

  /* bouton annuler */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lfixcdg, "cancelbtn")), "clicked", G_CALLBACK(abort_encours), Ag);
  g_signal_connect(G_OBJECT(Lwin), "delete-event", G_CALLBACK(delete_event_encours), Ag);

  gtk_widget_show(Lwin);
  g_timeout_add(500, encours_callback, Ag);

  /* operation en elle meme */
  perform_fix_cd(Ag, &Lerror);
  
  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else if (Lerror) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                      Lerror->message);
  } else {
     Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
               GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
               _("Operation successful"));
  }
  gtk_dialog_run(GTK_DIALOG(Lstatusbox));
  gtk_widget_destroy(Lstatusbox);
  
  gtk_widget_destroy(Lwin);
  sc_grave_destroy(Lfixcdg);

  if (Lerror) g_error_free(Lerror);
}

/* formater un dvd */
void show_dvdformatwindow(Tgrave *Ag, gchar *Atitle, Ttypeformatdvd Aoperation)
{
  GtkWidget *Lwindow1 = sc_grave_get_widget(Ag, "window");
  Tgrave *Lformatdvdg = create_window_encours(Lwindow1);
  gint Lcont = 2;
  gint Lpid;
  gboolean Loperationstatus = FALSE;
  gboolean Labort = FALSE;
  GtkLabel *Llabel;
  GtkWidget *Lwin;
  GError *Lerror = NULL;
  GtkWidget *Lstatusbox = NULL;

  Lwin = sc_grave_get_widget(Lformatdvdg, "window_inprogress"); 
  Llabel = GTK_LABEL(sc_grave_get_widget(Lformatdvdg, "labelava"));
  gtk_label_set_text(Llabel, Atitle);

  
  sc_grave_set_data(Ag, &Lcont, "cont");
  sc_grave_set_data(Ag, &Lpid, "pid");
  sc_grave_set_data(Ag, &Labort, "gabort");
  sc_grave_set_data(Ag, &Lerror, "gerror");
  sc_grave_set_data(Ag, sc_grave_get_widget(Lformatdvdg, "progress"), "progress");
  sc_grave_set_data(Ag, &Loperationstatus, "operationstatus");

  /* bouton annuler */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lformatdvdg, "cancelbtn")), "clicked", G_CALLBACK(abort_encours), Ag);
  g_signal_connect(G_OBJECT(Lwin), "delete-event", G_CALLBACK(delete_event_encours), Ag);

  gtk_widget_show(Lwin);

  /* operation en elle meme */
  perform_format_dvd(Ag, Aoperation, &Lerror);
  
  if (Labort) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                                     GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                                     _("Operation aborted by user !"));
  } else if (Lerror) {
    Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
                      GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                      Lerror->message);
  } else {
     Lstatusbox = gtk_message_dialog_new(GTK_WINDOW(Lwin),
               GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
               _("Operation successful"));
  }
  gtk_dialog_run(GTK_DIALOG(Lstatusbox));
  gtk_widget_destroy(Lstatusbox);
  
  gtk_widget_destroy(Lwin);

  sc_grave_destroy(Lformatdvdg);
  
  if (Lerror) g_error_free(Lerror);
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
